/*
 * Decompiled with CFR 0.152.
 */
package sun.security.internal.spec;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.spec.AlgorithmParameterSpec;

@Deprecated
public class TlsRsaPremasterSecretParameterSpec
implements AlgorithmParameterSpec {
    private final byte[] encodedSecret;
    private static final String PROP_NAME = "com.sun.net.ssl.rsaPreMasterSecretFix";
    private static final boolean rsaPreMasterSecretFix = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            String string = System.getProperty(TlsRsaPremasterSecretParameterSpec.PROP_NAME);
            if (string != null && string.equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    });
    private final int clientVersion;
    private final int serverVersion;

    public TlsRsaPremasterSecretParameterSpec(int n, int n2) {
        this.clientVersion = this.checkVersion(n);
        this.serverVersion = this.checkVersion(n2);
        this.encodedSecret = null;
    }

    public TlsRsaPremasterSecretParameterSpec(int n, int n2, byte[] byArray) {
        this.clientVersion = this.checkVersion(n);
        this.serverVersion = this.checkVersion(n2);
        if (byArray == null || byArray.length != 48) {
            throw new IllegalArgumentException("Encoded secret is not exactly 48 bytes");
        }
        this.encodedSecret = (byte[])byArray.clone();
    }

    public int getClientVersion() {
        return this.clientVersion;
    }

    public int getServerVersion() {
        return this.serverVersion;
    }

    public int getMajorVersion() {
        if (rsaPreMasterSecretFix || this.clientVersion >= 770) {
            return this.clientVersion >>> 8 & 0xFF;
        }
        return this.serverVersion >>> 8 & 0xFF;
    }

    public int getMinorVersion() {
        if (rsaPreMasterSecretFix || this.clientVersion >= 770) {
            return this.clientVersion & 0xFF;
        }
        return this.serverVersion & 0xFF;
    }

    private int checkVersion(int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Version must be between 0 and 65,535");
        }
        return n;
    }

    public byte[] getEncodedSecret() {
        return this.encodedSecret == null ? null : (byte[])this.encodedSecret.clone();
    }
}

