/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.detector.utils.collections.array;

import ai.grazie.detector.utils.collections.array.OptimizedFloatArray;
import ai.grazie.detector.utils.collections.array.TwoOptimizedFloatArray;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\t\b\u0016\u00a2\u0006\u0004\b\u0006\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\fJ\u0011\u0010\r\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0096\u0002J \u0010\u000e\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lai/grazie/detector/utils/collections/array/OneOptimizedFloatArray;", "Lai/grazie/detector/utils/collections/array/OptimizedFloatArray;", "fstIndex", "", "fstValue", "", "<init>", "(BF)V", "()V", "index", "", "value", "(IF)V", "get", "set", "size", "nlp-detect"})
public final class OneOptimizedFloatArray
implements OptimizedFloatArray {
    private byte fstIndex;
    private float fstValue;

    public OneOptimizedFloatArray(byte fstIndex, float fstValue) {
        this.fstIndex = fstIndex;
        this.fstValue = fstValue;
    }

    public OneOptimizedFloatArray() {
        this(-1, -1.0f);
    }

    public OneOptimizedFloatArray(int index, float value) {
        this((byte)index, value);
    }

    @Override
    public float get(int index) {
        if (this.fstIndex == (byte)index) {
            return this.fstValue;
        }
        return 0.0f;
    }

    @Override
    @NotNull
    public OptimizedFloatArray set(int index, float value, byte size) {
        if (this.fstIndex == -1) {
            this.fstIndex = (byte)index;
            this.fstValue = value;
            return this;
        }
        TwoOptimizedFloatArray two = new TwoOptimizedFloatArray();
        two.set(this.fstIndex, this.fstValue, size);
        two.set(index, value, size);
        return two;
    }
}

