/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.translate.test;

import com.thaiopensource.util.UriOrFile;
import com.thaiopensource.xml.sax.AbstractLexicalHandler;
import com.thaiopensource.xml.sax.Jaxp11XMLReaderCreator;
import com.thaiopensource.xml.sax.XMLReaderCreator;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class Compare {
    public static boolean compare(File file, File file2, XMLReaderCreator xMLReaderCreator) throws SAXException, IOException {
        return Compare.load(xMLReaderCreator, file).equals(Compare.load(xMLReaderCreator, file2));
    }

    private static List load(XMLReaderCreator xMLReaderCreator, File file) throws SAXException, IOException {
        InputSource inputSource = new InputSource(UriOrFile.fileToUri(file));
        Saver saver = new Saver();
        XMLReader xMLReader = xMLReaderCreator.createXMLReader();
        try {
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new SAXException("support for namespaces-prefixes feature required");
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new SAXException("support for namespaces-prefixes feature required");
        }
        xMLReader.setContentHandler(saver);
        try {
            xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", new CommentSaver(saver));
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            // empty catch block
        }
        xMLReader.parse(inputSource);
        return saver.getEventList();
    }

    public static void main(String[] stringArray) throws SAXException, IOException {
        System.err.println(Compare.compare(new File(stringArray[0]), new File(stringArray[1]), new Jaxp11XMLReaderCreator()));
    }

    static class CommentSaver
    extends AbstractLexicalHandler {
        private final Saver saver;

        CommentSaver(Saver saver) {
            this.saver = saver;
        }

        public void comment(char[] cArray, int n, int n2) throws SAXException {
            this.saver.comment(new String(cArray, n, n2));
        }
    }

    static class Saver
    extends DefaultHandler {
        private final List eventList = new Vector();
        private final List attributeList = new Vector();

        Saver() {
        }

        List getEventList() {
            return this.eventList;
        }

        void flushWhitespace(boolean bl) {
            int n = this.eventList.size();
            if (n == 0) {
                return;
            }
            if (!((Event)this.eventList.get(n - 1)).isWhitespace()) {
                return;
            }
            if (bl && n > 1 && this.eventList.get(n - 2) instanceof StartElement) {
                return;
            }
            this.eventList.remove(n - 1);
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            this.flushWhitespace(false);
            this.eventList.add(new StartElement(string3));
            int n = 0;
            int n2 = attributes.getLength();
            while (n < n2) {
                this.attributeList.add(new Attribute(attributes.getQName(n), attributes.getValue(n)));
                ++n;
            }
            Collections.sort(this.attributeList, new Comparator(this){
                private final /* synthetic */ Saver this$0;
                {
                    this.this$0 = saver;
                }

                public int compare(Object object, Object object2) {
                    return ((Attribute)object).getQName().compareTo(((Attribute)object2).getQName());
                }
            });
            this.eventList.addAll(this.attributeList);
            this.attributeList.clear();
        }

        public void endElement(String string, String string2, String string3) {
            this.flushWhitespace(true);
            this.eventList.add(new EndElement());
        }

        public void characters(char[] cArray, int n, int n2) {
            int n3 = this.eventList.size();
            if (n3 == 0 || !((Event)this.eventList.get(n3 - 1)).merge(cArray, n, n2)) {
                this.eventList.add(new Text(new String(cArray, n, n2)));
            }
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) {
            this.characters(cArray, n, n2);
        }

        public void endDocument() {
            this.flushWhitespace(false);
        }

        void comment(String string) {
            this.flushWhitespace(false);
            this.eventList.add(new Comment(string));
        }
    }

    static class Text
    extends Event {
        private String value;

        Text(String string) {
            this.value = string;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Text)) {
                return false;
            }
            return this.value.equals(((Text)object).value);
        }

        boolean isWhitespace() {
            int n = 0;
            int n2 = this.value.length();
            while (n < n2) {
                switch (this.value.charAt(n)) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                ++n;
            }
            return true;
        }

        boolean merge(char[] cArray, int n, int n2) {
            StringBuffer stringBuffer = new StringBuffer(this.value);
            stringBuffer.append(cArray, n, n2);
            this.value = stringBuffer.toString();
            return true;
        }
    }

    static class Comment
    extends Event {
        private final String value;

        Comment(String string) {
            this.value = string;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Comment)) {
                return false;
            }
            return this.value.equals(((Comment)object).value);
        }
    }

    static class EndElement
    extends Event {
        EndElement() {
        }

        public boolean equals(Object object) {
            return object instanceof EndElement;
        }
    }

    static class Attribute
    extends Event {
        private final String qName;
        private final String value;

        Attribute(String string, String string2) {
            this.qName = string;
            this.value = string2;
        }

        String getQName() {
            return this.qName;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Attribute)) {
                return false;
            }
            Attribute attribute = (Attribute)object;
            return this.qName.equals(attribute.qName) && this.value.equals(attribute.value);
        }
    }

    static class StartElement
    extends Event {
        private final String qName;

        StartElement(String string) {
            this.qName = string;
        }

        public boolean equals(Object object) {
            if (!(object instanceof StartElement)) {
                return false;
            }
            return this.qName.equals(((StartElement)object).qName);
        }
    }

    static abstract class Event {
        Event() {
        }

        boolean merge(char[] cArray, int n, int n2) {
            return false;
        }

        boolean isWhitespace() {
            return false;
        }
    }
}

