/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import org.freeplane.api.swing.JFileChooser;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.WindowConfigurationStorage;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.LogUtils;
import sun.awt.shell.ShellFolder;

public class JFreeplaneCustomizableFileChooser
extends JFileChooser {
    private static final String FILE_CHOOSER_SPECIAL_FOLDERS_PROPERTY = "file_chooser_shows_special_folders";
    private static final String USE_SHELL_FOLDER_JAVA_PROPERTY = "FileChooser.useShellFolder";
    private static final long serialVersionUID = 1L;
    private final List<JComponent> optionComponents = new ArrayList<JComponent>();
    private boolean areSpecialFoldersShown;
    private boolean isFileHidingDisabledForCurrentDirectory = false;
    private Consumer<JDialog> customizer = Customizer.DEFAULT;
    private static final String WINDOW_CONFIG_PROPERTY = "file_chooser_window_configuration";

    public JFreeplaneCustomizableFileChooser() {
        this.initializeSpecialFolderShownFlag();
    }

    private void initializeSpecialFolderShownFlag() {
        boolean areSpecialFoldersShown = ResourceController.getResourceController().getBooleanProperty(FILE_CHOOSER_SPECIAL_FOLDERS_PROPERTY);
        if (this.areSpecialFoldersShown != areSpecialFoldersShown) {
            this.areSpecialFoldersShown = areSpecialFoldersShown;
        }
    }

    public JFreeplaneCustomizableFileChooser(File currentDirectory) {
        super(currentDirectory);
        this.initializeSpecialFolderShownFlag();
    }

    protected void setup(FileSystemView view) {
        this.initializeSpecialFolderShownFlag();
        this.putClientProperty(USE_SHELL_FOLDER_JAVA_PROPERTY, this.areSpecialFoldersShown);
        super.setup(view);
    }

    public Dimension getPreferredSize() {
        return this.fixAquaFileChooserUIPreferredSize();
    }

    public boolean isFileHidingEnabled() {
        if (this.isFileHidingDisabledForCurrentDirectory) {
            return false;
        }
        return super.isFileHidingEnabled();
    }

    private Dimension fixAquaFileChooserUIPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        if (this.isPreferredSizeSet() || !this.getUI().getClass().getSimpleName().equals("AquaFileChooserUI")) {
            return preferredSize;
        }
        LayoutManager layout = this.getLayout();
        Dimension layoutPrefSize = layout.preferredLayoutSize((Container)((Object)this));
        Dimension maximumSize = super.getMaximumSize();
        int width = Math.min(maximumSize.width, Math.max(preferredSize.width, layoutPrefSize.width));
        int height = Math.min(maximumSize.height, Math.max(preferredSize.height, layoutPrefSize.height));
        return new Dimension(width, height);
    }

    public void setCurrentDirectory(File dir) {
        if (dir != null && !this.areSpecialFoldersShown && Compat.isWindowsOS() && dir.getClass().equals(File.class)) {
            try {
                this.setDirectoryBehavingLikeShellFolder(dir);
                return;
            }
            catch (IOException | InvalidPathException exception) {
            }
            catch (IllegalAccessError e) {
                LogUtils.severe(e);
            }
        }
        if (UIManager.getLookAndFeel().getName().equals("VAqua")) {
            boolean wasFileHidingEnabled = this.isFileHidingEnabled();
            this.isFileHidingDisabledForCurrentDirectory = this.isDirectoryHiddenInVAqua(dir);
            boolean isFileHidingEnabled = this.isFileHidingEnabled();
            if (wasFileHidingEnabled != isFileHidingEnabled) {
                SwingUtilities.invokeLater(() -> this.firePropertyChange("FileHidingChanged", wasFileHidingEnabled, isFileHidingEnabled));
            }
        }
        super.setCurrentDirectory(dir);
    }

    private boolean isDirectoryHiddenInVAqua(File directory) {
        while (directory != null) {
            if (this.getFileSystemView().isHiddenFile(directory)) {
                return true;
            }
            directory = directory.getParentFile();
        }
        return false;
    }

    private void setDirectoryBehavingLikeShellFolder(File dir) throws IOException {
        ShellFolder shellFolder = ShellFolder.getShellFolder(dir);
        super.setCurrentDirectory((File)shellFolder);
    }

    public boolean accept(File f) {
        if (!this.areSpecialFoldersShown && Compat.isWindowsOS() && f.getName().endsWith(".lnk")) {
            return false;
        }
        return super.accept(f);
    }

    public void addCustomizer(Customizer newCustomizer) {
        this.customizer = this.customizer.andThen(newCustomizer);
    }

    public Consumer<JDialog> getCustomizer() {
        return this.customizer;
    }

    protected JDialog createDialog(Component parent) throws HeadlessException {
        JDialog dialog = super.createDialog(parent);
        this.customizer.accept(dialog);
        if (this.optionComponents.size() == 1) {
            dialog.getContentPane().add((Component)this.optionComponents.get(0), "South");
        } else if (this.optionComponents.size() > 1) {
            Box optionBox = Box.createVerticalBox();
            this.optionComponents.forEach(c -> c.setAlignmentX(0.0f));
            this.optionComponents.forEach(optionBox::add);
            dialog.getContentPane().add((Component)optionBox, "South");
        }
        String windowConfigurationPropertyName = this.windowConfigurationPropertyName();
        WindowConfigurationStorage windowConfigurationStorage = new WindowConfigurationStorage(windowConfigurationPropertyName);
        windowConfigurationStorage.setBounds(dialog);
        if (Compat.isMacOsX()) {
            ActionMap am = this.getActionMap();
            InputMap globalInputMap = this.getInputMap(2);
            KeyStroke ks = KeyStroke.getKeyStroke(46, 5);
            globalInputMap.put(ks, ks);
            am.put(ks, new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean isHiding = JFreeplaneCustomizableFileChooser.this.isFileHidingEnabled();
                    JFreeplaneCustomizableFileChooser.this.setFileHidingEnabled(!isHiding);
                }
            });
        }
        return dialog;
    }

    private String windowConfigurationPropertyName() {
        JComponent accessory = this.getAccessory();
        if (accessory == null) {
            return WINDOW_CONFIG_PROPERTY;
        }
        Dimension preferredSize = accessory.getPreferredSize();
        return "file_chooser_window_configuration_" + preferredSize.width + "." + preferredSize.height;
    }

    public void addOptionComponent(JComponent component) {
        this.optionComponents.add(component);
    }

    @FunctionalInterface
    public static interface Customizer
    extends Consumer<JDialog> {
        public static final Customizer DEFAULT = d -> {};
    }
}

