/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode.styleeditorpanel;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.freeplane.core.resources.components.BooleanProperty;
import org.freeplane.core.resources.components.ColorProperty;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.features.edge.EdgeController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.nodestyle.NodeBorderModel;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.mindmapmode.MNodeStyleController;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroupChangeListener;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.RevertingProperty;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.StylePropertyAdjuster;

public class BorderColorAndColorMatchesEdgeControlGroup
implements ControlGroup {
    private static final String BORDER_COLOR_MATCHES_EDGE_COLOR = "border_color_matches_edge_color";
    private static final String BORDER_COLOR = "border_color";
    private RevertingProperty mSetBorderColor;
    private ColorProperty mBorderColor;
    private RevertingProperty mSetBorderColorMatchesEdgeColor;
    private BooleanProperty mBorderColorMatchesEdgeColor;
    private BorderColorListener borderColorListener;
    private BorderColorMatchesEdgeColorListener borderColorMatchesEdgeColorChangeListener;
    private boolean canEdit;

    @Override
    public void addControlGroup(DefaultFormBuilder formBuilder) {
        this.addBorderColorMatchesEdgeColorControl(formBuilder);
        this.addBorderColorControl(formBuilder);
    }

    private void addBorderColorControl(DefaultFormBuilder formBuilder) {
        this.mSetBorderColor = new RevertingProperty();
        this.mBorderColor = new ColorProperty(BORDER_COLOR, ColorUtils.colorToString((Color)EdgeController.STANDARD_EDGE_COLOR));
        this.borderColorListener = new BorderColorListener(this.mSetBorderColor, (IPropertyControl)this.mBorderColor);
        this.mSetBorderColor.addPropertyChangeListener(this.borderColorListener);
        this.mBorderColor.addPropertyChangeListener((PropertyChangeListener)this.borderColorListener);
        this.mBorderColor.appendToForm(formBuilder);
        this.mSetBorderColor.appendToForm(formBuilder);
    }

    public void addBorderColorMatchesEdgeColorControl(DefaultFormBuilder formBuilder) {
        this.mSetBorderColorMatchesEdgeColor = new RevertingProperty();
        this.mBorderColorMatchesEdgeColor = new BooleanProperty(BORDER_COLOR_MATCHES_EDGE_COLOR);
        this.borderColorMatchesEdgeColorChangeListener = new BorderColorMatchesEdgeColorListener(this.mSetBorderColorMatchesEdgeColor, (IPropertyControl)this.mBorderColorMatchesEdgeColor);
        this.mSetBorderColorMatchesEdgeColor.addPropertyChangeListener(this.borderColorMatchesEdgeColorChangeListener);
        this.mBorderColorMatchesEdgeColor.addPropertyChangeListener((PropertyChangeListener)this.borderColorMatchesEdgeColorChangeListener);
        this.mBorderColorMatchesEdgeColor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BorderColorAndColorMatchesEdgeControlGroup.this.enableOrDisableBorderColorControls();
            }
        });
        this.mBorderColorMatchesEdgeColor.appendToForm(formBuilder);
        this.mSetBorderColorMatchesEdgeColor.appendToForm(formBuilder);
    }

    @Override
    public void setStyle(NodeModel node, boolean canEdit) {
        this.canEdit = canEdit;
        this.borderColorListener.setStyle(node);
        this.borderColorMatchesEdgeColorChangeListener.setStyle(node);
    }

    private void enableOrDisableBorderColorControls() {
        boolean borderColorCanBeSet = !this.mBorderColorMatchesEdgeColor.getBooleanValue();
        this.mSetBorderColor.setEnabled(borderColorCanBeSet && this.canEdit);
        this.mBorderColor.setEnabled(borderColorCanBeSet && this.canEdit);
    }

    private class BorderColorListener
    extends ControlGroupChangeListener {
        public BorderColorListener(RevertingProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MNodeStyleController styleController = (MNodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
            styleController.setBorderColor(node, enabled ? BorderColorAndColorMatchesEdgeControlGroup.this.mBorderColor.getColorValue() : null);
        }

        @Override
        void setStyleOnExternalChange(NodeModel node) {
            NodeStyleController styleController = NodeStyleController.getController();
            NodeBorderModel nodeBorderModel = NodeBorderModel.getModel((NodeModel)node);
            Color color = nodeBorderModel != null ? nodeBorderModel.getBorderColor() : null;
            Color viewColor = styleController.getBorderColor(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
            BorderColorAndColorMatchesEdgeControlGroup.this.mSetBorderColor.setValue(color != null);
            BorderColorAndColorMatchesEdgeControlGroup.this.mBorderColor.setColorValue(viewColor);
        }

        @Override
        void adjustForStyle(NodeModel node) {
            StylePropertyAdjuster.adjustPropertyControl(node, (IPropertyControl)BorderColorAndColorMatchesEdgeControlGroup.this.mSetBorderColor);
            StylePropertyAdjuster.adjustPropertyControl(node, (IPropertyControl)BorderColorAndColorMatchesEdgeControlGroup.this.mBorderColor);
            if (!MapStyleModel.isStyleNode((NodeModel)node) || BorderColorAndColorMatchesEdgeControlGroup.this.mBorderColor.isEnabled()) {
                BorderColorAndColorMatchesEdgeControlGroup.this.enableOrDisableBorderColorControls();
            }
        }
    }

    private class BorderColorMatchesEdgeColorListener
    extends ControlGroupChangeListener {
        public BorderColorMatchesEdgeColorListener(RevertingProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MNodeStyleController styleController = (MNodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
            styleController.setBorderColorMatchesEdgeColor(node, enabled ? Boolean.valueOf(BorderColorAndColorMatchesEdgeControlGroup.this.mBorderColorMatchesEdgeColor.getBooleanValue()) : null);
        }

        @Override
        void setStyleOnExternalChange(NodeModel node) {
            NodeStyleController styleController = NodeStyleController.getController();
            NodeBorderModel nodeBorderModel = NodeBorderModel.getModel((NodeModel)node);
            Boolean match = nodeBorderModel != null ? nodeBorderModel.getBorderColorMatchesEdgeColor() : null;
            Boolean viewMatch = styleController.getBorderColorMatchesEdgeColor(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
            BorderColorAndColorMatchesEdgeControlGroup.this.mSetBorderColorMatchesEdgeColor.setValue(match != null);
            BorderColorAndColorMatchesEdgeControlGroup.this.mBorderColorMatchesEdgeColor.setValue(viewMatch.booleanValue());
        }

        @Override
        void adjustForStyle(NodeModel node) {
            StylePropertyAdjuster.adjustPropertyControl(node, (IPropertyControl)BorderColorAndColorMatchesEdgeControlGroup.this.mSetBorderColorMatchesEdgeColor);
            StylePropertyAdjuster.adjustPropertyControl(node, (IPropertyControl)BorderColorAndColorMatchesEdgeControlGroup.this.mBorderColorMatchesEdgeColor);
        }
    }
}

