/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.tools.content;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.freeplane.features.link.ConnectorModel;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ConnectorItem {
    private final String sourceNodeIdentifier;
    private final String targetNodeIdentifier;
    private final String sourceLabel;
    private final String middleLabel;
    private final String targetLabel;

    @JsonCreator
    public ConnectorItem(@JsonProperty(value="sourceNodeIdentifier") String sourceNodeIdentifier, @JsonProperty(value="targetNodeIdentifier") String targetNodeIdentifier, @JsonProperty(value="sourceLabel") String sourceLabel, @JsonProperty(value="middleLabel") String middleLabel, @JsonProperty(value="targetLabel") String targetLabel) {
        this.sourceNodeIdentifier = sourceNodeIdentifier;
        this.targetNodeIdentifier = targetNodeIdentifier;
        this.sourceLabel = sourceLabel;
        this.middleLabel = middleLabel;
        this.targetLabel = targetLabel;
    }

    public static ConnectorItem fromConnector(ConnectorModel connectorModel) {
        if (connectorModel == null) {
            return null;
        }
        String sourceIdentifier = connectorModel.getSource() == null ? null : connectorModel.getSource().createID();
        return new ConnectorItem(sourceIdentifier, connectorModel.getTargetID(), connectorModel.getSourceLabel().orElse(null), connectorModel.getMiddleLabel().orElse(null), connectorModel.getTargetLabel().orElse(null));
    }

    public String getSourceNodeIdentifier() {
        return this.sourceNodeIdentifier;
    }

    public String getTargetNodeIdentifier() {
        return this.targetNodeIdentifier;
    }

    public String getSourceLabel() {
        return this.sourceLabel;
    }

    public String getMiddleLabel() {
        return this.middleLabel;
    }

    public String getTargetLabel() {
        return this.targetLabel;
    }
}

