/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPResourceHandler;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNLazyNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNNodeWithCache;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.navigator.DesktopNavigatorModel;
import org.jkiss.dbeaver.model.navigator.NavigatorResources;
import org.jkiss.dbeaver.model.rcp.RCPProject;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class NavigatorResourceListener
implements IResourceChangeListener {
    private static final Log log = Log.getLog(NavigatorResourceListener.class);
    private final DesktopNavigatorModel model;

    public NavigatorResourceListener(DesktopNavigatorModel model) {
        this.model = model;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 1) {
            IResourceDelta delta = event.getDelta();
            IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta childDelta = iResourceDeltaArray[n2];
                IResource iResource = childDelta.getResource();
                if (iResource instanceof IProject) {
                    IProject project = (IProject)iResource;
                    DBNProject projectNode = NavigatorResources.getProjectNode(this.model.getRoot(), project);
                    if (projectNode == null) {
                        if (childDelta.getKind() == 1) {
                            projectMeta = DBPPlatformDesktop.getInstance().getWorkspace().getProject(project);
                            if (projectMeta == null) {
                                log.error((Object)("Can't find project '" + project.getName() + "' metadata"));
                            } else {
                                this.model.getRoot().addProject(projectMeta, true);
                            }
                        } else if (childDelta.getKind() != 2) {
                            log.error((Object)("Project '" + childDelta.getResource().getName() + "' not found in navigator"));
                        }
                    } else if (childDelta.getKind() == 2) {
                        projectMeta = DBPPlatformDesktop.getInstance().getWorkspace().getProject(project);
                        if (projectMeta == null) {
                            log.error((Object)("Can't find project '" + project.getName() + "' metadata"));
                        } else {
                            this.model.getRoot().removeProject(projectMeta);
                        }
                    } else {
                        this.handleResourceChange((DBNNode)projectNode, childDelta);
                    }
                }
                ++n2;
            }
        }
    }

    public void refreshResourceState(DBNNode node, Object source) {
        if (node instanceof DBNResource) {
            DBNResource resourceNode = (DBNResource)node;
            DBPResourceHandler newHandler = DBPPlatformDesktop.getInstance().getWorkspace().getResourceHandler(resourceNode.getResource());
            if (newHandler != resourceNode.getHandler()) {
                resourceNode.setHandler(newHandler);
            }
            this.model.fireNodeEvent(new DBNEvent(source, DBNEvent.Action.UPDATE, node));
        }
    }

    public void handleResourceChange(DBNNode node, IResourceDelta delta) {
        DBNLazyNode lazyNode;
        if (delta.getKind() == 4) {
            this.refreshResourceState(node, delta);
        }
        if (node instanceof DBNLazyNode && (lazyNode = (DBNLazyNode)node).needsInitialization()) {
            return;
        }
        IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren(31, 8);
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta childDelta = iResourceDeltaArray[n2];
            this.handleChildResourceChange(node, childDelta);
            ++n2;
        }
    }

    public void handleChildResourceChange(DBNNode parentNode, IResourceDelta delta) {
        DBNNodeWithCache nodeWithCache;
        DBNProject project;
        if (parentNode instanceof DBNProject && this.handleProjectChanges(project = (DBNProject)parentNode, delta)) {
            return;
        }
        if (!(parentNode instanceof DBNNodeWithCache) || (nodeWithCache = (DBNNodeWithCache)parentNode).needsInitialization()) {
            return;
        }
        IResource deltaResource = delta.getResource();
        DBNNode childResource = NavigatorResources.getChild(parentNode, deltaResource);
        if (childResource == null) {
            DBNNode newChild;
            if ((delta.getKind() == 1 || delta.getKind() == 4) && (newChild = NavigatorResources.getChild(parentNode, deltaResource)) == null && (newChild = NavigatorResources.makeNode(parentNode, deltaResource)) != null) {
                Object[] children = nodeWithCache.getCachedChildren();
                children = (DBNNode[])ArrayUtils.add(DBNNode.class, (Object[])children, (Object)newChild);
                NavigatorResources.sortChildren((DBNNode[])children);
                nodeWithCache.setCachedChildren((DBNNode[])children);
                this.model.fireNodeEvent(new DBNEvent((Object)delta, DBNEvent.Action.ADD, newChild));
                if (delta.getKind() == 4 && (childResource = NavigatorResources.getChild(parentNode, deltaResource)) != null) {
                    this.handleResourceChange(childResource, delta);
                }
            }
        } else if (delta.getKind() == 2) {
            Object[] children = nodeWithCache.getCachedChildren();
            children = (DBNNode[])ArrayUtils.remove(DBNNode.class, (Object[])children, (Object)childResource);
            nodeWithCache.setCachedChildren((DBNNode[])children);
            DBNUtils.disposeNode((DBNNode)childResource, (boolean)true);
        } else {
            this.handleResourceChange(childResource, delta);
        }
    }

    private boolean handleProjectChanges(DBNProject projectNode, IResourceDelta delta) {
        String name;
        DBPProject dBPProject = projectNode.getProject();
        if (dBPProject instanceof RCPProject) {
            RCPProject rcpProject = (RCPProject)dBPProject;
            if (CommonUtils.equalObjects((Object)delta.getResource(), (Object)rcpProject.getRootResource())) {
                IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
                int n = iResourceDeltaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceDelta cChild = iResourceDeltaArray[n2];
                    this.handleChildResourceChange((DBNNode)projectNode, cChild);
                    ++n2;
                }
                return true;
            }
        }
        if ((name = delta.getResource().getName()).equals(".dbeaver")) {
            IResourceDelta[] configFiles = delta.getAffectedChildren();
            boolean dsChanged = false;
            if (configFiles != null) {
                IResourceDelta[] iResourceDeltaArray = configFiles;
                int n = configFiles.length;
                int n3 = 0;
                while (n3 < n) {
                    IResourceDelta rd = iResourceDeltaArray[n3];
                    IResource childRes = rd.getResource();
                    if (childRes instanceof IFile && childRes.getName().startsWith("data-sources")) {
                        dsChanged = true;
                    }
                    ++n3;
                }
            }
            if (dsChanged) {
                projectNode.getDatabases().getDataSourceRegistry().refreshConfig();
            }
            return true;
        }
        return false;
    }
}

