/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkSliceImageFilter_h
#define sitkSliceImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class SliceImageFilter
\brief Slices an image based on a starting index and a stopping index, and a step size.

This class is designed to facilitate the implementation of extended sliced based indexing into images.

The input and output image must be of the same dimension.

The input parameters are a starting and stopping index as well as a stepping size. The starting index indicates the first pixels to be used and for each dimension the index is incremented by the step until the index is equal to or "beyond" the stopping index. If the step is negative then the image will be reversed in the dimension, and the stopping index is expected to be less then the starting index. If the stopping index is already beyond the starting index then an image of size zero will be returned.

The output image's starting index is always zero. The origin is the physical location of the starting index. The output directions cosine matrix is that of the input but with sign changes matching that of the step's sign.

\note In certain combinations such as with start=1, and step>1 while the physical location of the center of the pixel remains the same, the extent (edge to edge space) of the output image will be beyond the extent of the original image.
\sa itk::simple::Slice for the procedural interface
\sa itk::SliceImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT SliceImageFilter : public ImageFilter {
    public:
      using Self = SliceImageFilter;

      /** Destructor */
      virtual ~SliceImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      SliceImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = NonLabelPixelIDTypeList;
\

      /**
       * Set/Get the first index extracted from the input image
       */
      SITK_RETURN_SELF_TYPE_HEADER SetStart ( std::vector<int32_t> Start ) { this->m_Start = std::move(Start); return *this; }

      /**
       * Set/Get the first index extracted from the input image
       */
      std::vector<int32_t> GetStart() const { return this->m_Start; }\

      /**
       * Set/Get the excluded end of the range
       */
      SITK_RETURN_SELF_TYPE_HEADER SetStop ( std::vector<int32_t> Stop ) { this->m_Stop = std::move(Stop); return *this; }

      /**
       * Set/Get the excluded end of the range
       */
      std::vector<int32_t> GetStop() const { return this->m_Stop; }\

      /**
       * Set/Get the stride of indexes extracted An exception will be generated if 0.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetStep ( std::vector<int> Step ) { this->m_Step = std::move(Step); return *this; }

      /** Set the values of the Step vector all to value */
      SITK_RETURN_SELF_TYPE_HEADER SetStep( int value ) { this->m_Step = std::vector<int>(3, value); return *this; }

      /**
       * Set/Get the stride of indexes extracted An exception will be generated if 0.
       */
      std::vector<int> GetStep() const { return this->m_Step; }

      /** Name of this class */
      std::string GetName() const { return std::string ("SliceImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */

      Image Execute ( const Image& image1 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      std::vector<int32_t>  m_Start{std::vector<int32_t>(3, 0)};

      std::vector<int32_t>  m_Stop{std::vector<int32_t>(3, std::numeric_limits<int32_t>::max())};

      std::vector<int>  m_Step{std::vector<int>(3, 1)};


    };

    /**\
     * \brief Slices an image based on a starting index and a stopping index, and a step size.
     *
     * This function directly calls the execute method of SliceImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::SliceImageFilter for the object oriented interface
     * @{
     */

     SITKBasicFilters_EXPORT Image Slice ( const Image& image1, std::vector<int32_t> start = std::vector<int32_t>(3, 0), std::vector<int32_t> stop = std::vector<int32_t>(3, std::numeric_limits<int32_t>::max()), std::vector<int> step = std::vector<int>(3, 1) );

     /** @} */
}
#endif
