/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkLabelUniqueLabelMapFilter_h
#define sitkLabelUniqueLabelMapFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class LabelUniqueLabelMapFilter
\brief Make sure that the objects are not overlapping.

AttributeUniqueLabelMapFilter search the overlapping zones in the overlapping objects and keeps only a single object on all the pixels of the image. The object to keep is selected according to their label.

\author Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA de Jouy-en-Josas, France.


This implementation was taken from the Insight Journal paper: https://doi.org/10.54294/q6auw4 

\see AttributeLabelObject
\sa itk::simple::LabelUniqueLabelMapFilter for the procedural interface
\sa itk::LabelUniqueLabelMapFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT LabelUniqueLabelMapFilter : public ImageFilter {
    public:
      using Self = LabelUniqueLabelMapFilter;

      /** Destructor */
      virtual ~LabelUniqueLabelMapFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      LabelUniqueLabelMapFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = LabelPixelIDTypeList;
\

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetReverseOrdering ( bool ReverseOrdering ) { this->m_ReverseOrdering = ReverseOrdering; return *this; }

      /** Set the value of ReverseOrdering to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER ReverseOrderingOn() { return this->SetReverseOrdering(true); }
      SITK_RETURN_SELF_TYPE_HEADER ReverseOrderingOff() { return this->SetReverseOrdering(false); }

      /**
       */
      bool GetReverseOrdering() const { return this->m_ReverseOrdering; }

      /** Name of this class */
      std::string GetName() const { return std::string ("LabelUniqueLabelMapFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
#ifndef SWIG
      Image Execute ( Image&& image1 );
#endif
      Image Execute ( const Image& image1 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /*  */
      bool  m_ReverseOrdering{false};


      bool m_InPlace{false};
    };

    /**\
     * \brief Make sure that the objects are not overlapping.
     *
     * This function directly calls the execute method of LabelUniqueLabelMapFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::LabelUniqueLabelMapFilter for the object oriented interface
     * @{
     */
#ifndef SWIG
     SITKBasicFilters_EXPORT Image LabelUniqueLabelMap ( Image&& image1, bool reverseOrdering = false );
#endif
     SITKBasicFilters_EXPORT Image LabelUniqueLabelMap ( const Image& image1, bool reverseOrdering = false );

     /** @} */
}
#endif
