/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.criterion;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.resolver.Criterion;
import org.opensaml.xmlsec.SignatureSigningConfiguration;

public class SignatureSigningConfigurationCriterion
implements Criterion {
    @Nonnull
    private List<SignatureSigningConfiguration> configs;

    public SignatureSigningConfigurationCriterion(@Nonnull @NotEmpty List<SignatureSigningConfiguration> configurations) {
        this.configs = CollectionSupport.copyToList((Collection)Constraint.isNotNull(configurations, "List of configurations cannot be null"));
        Constraint.isNotEmpty(this.configs, "At least one configuration is required");
    }

    public SignatureSigningConfigurationCriterion(SignatureSigningConfiguration ... configurations) {
        this.configs = CollectionSupport.listOf(Constraint.isNotNull(configurations, "List of configurations cannot be null"));
        Constraint.isNotEmpty(this.configs, "At least one configuration is required");
    }

    @Nonnull
    @NotEmpty
    @NotLive
    @Unmodifiable
    public List<SignatureSigningConfiguration> getConfigurations() {
        return this.configs;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SignatureSigningConfigurationCriterion [configs=");
        builder.append(this.configs);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        return this.configs.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof SignatureSigningConfigurationCriterion) {
            SignatureSigningConfigurationCriterion other = (SignatureSigningConfigurationCriterion)obj;
            return this.configs.equals(other.getConfigurations());
        }
        return false;
    }
}

