/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.registry;

import org.gradle.model.internal.core.ModelNode;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelPredicate;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.type.ModelType;
import org.jspecify.annotations.Nullable;

public class BindingPredicate
extends ModelPredicate {
    private final ModelReference<?> reference;

    public BindingPredicate(ModelReference<?> reference) {
        this.reference = reference;
    }

    public ModelReference<?> getReference() {
        return this.reference;
    }

    public String toString() {
        ModelType<?> type = this.reference.getType();
        return "{type: " + (type == null ? null : type.getDisplayName()) + ", path: " + this.getPath() + ", scope: " + this.getScope() + ", state: " + (Object)((Object)this.getState()) + "}";
    }

    @Override
    public @Nullable ModelPath getPath() {
        return this.reference.getPath();
    }

    public ModelType<?> getType() {
        return this.reference.getType();
    }

    public boolean matches(MutableModelNode node) {
        return this.reference.isUntyped() || node.canBeViewedAs(this.reference.getType());
    }

    public @Nullable ModelPath getScope() {
        return this.reference.getScope();
    }

    public ModelNode.State getState() {
        return this.reference.getState();
    }
}

