/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.testing.toolchains.internal;

import java.util.HashMap;
import java.util.Map;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.testing.toolchains.internal.JvmTestToolchain;
import org.gradle.api.testing.toolchains.internal.JvmTestToolchainParameters;
import org.gradle.util.Path;

public class FrameworkCachingJvmTestToolchain<T extends JvmTestToolchainParameters>
implements JvmTestToolchain<T> {
    private final JvmTestToolchain<T> delegate;
    private final Map<Path, TestFramework> testFrameworks = new HashMap<Path, TestFramework>();

    public FrameworkCachingJvmTestToolchain(JvmTestToolchain<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public TestFramework createTestFramework(Test task) {
        return this.testFrameworks.computeIfAbsent(task.getIdentityPath(), k -> this.delegate.createTestFramework(task));
    }

    @Override
    public Iterable<Dependency> getCompileOnlyDependencies() {
        return this.delegate.getCompileOnlyDependencies();
    }

    @Override
    public Iterable<Dependency> getRuntimeOnlyDependencies() {
        return this.delegate.getRuntimeOnlyDependencies();
    }

    @Override
    public Iterable<Dependency> getImplementationDependencies() {
        return this.delegate.getImplementationDependencies();
    }

    @Override
    public T getParameters() {
        return this.delegate.getParameters();
    }
}

