// SubNoteUI.h
// generated by Fast Light User Interface Designer (fluid) version 1.0404

#ifndef SUBnoteUI_h
#define SUBnoteUI_h
#include <FL/Fl.H>
// Original ZynAddSubFX author Nasca Octavian Paul
// Copyright (C) 2002-2005 Nasca Octavian Paul
// Copyright 2009-2011, Alan Calvert
// Copyright 2015-2025, Will Godfrey & others

// This file is part of yoshimi, which is free software: you can redistribute
// it and/or modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either version 2 of
// the License, or (at your option) any later version.

// yoshimi is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.   See the GNU General Public License (version 2 or
// later) for more details.

// You should have received a copy of the GNU General Public License along with
// yoshimi; if not, write to the Free Software Foundation, Inc., 51 Franklin
// Street, Fifth Floor, Boston, MA  02110-1301, USA.

// This file is derivative of ZynAddSubFX original code


#include "UI/MiscGui.h"
#include "UI/WidgetPDial.h"
#include "UI/WidgetCheckButton.h"
#include "UI/WidgetMWSlider.h"
#include "UI/ScaleTrackedWindow.h"
#include "EnvelopeUI.h"
#include "FilterUI.h"
#include "LFOUI.h"
#include "PresetsUI.h"
#include "Params/SUBnoteParameters.h"
#include "Misc/SynthEngine.h"
#include <FL/Fl_Box.H>

class SUBnoteharmonic : public Fl_Group {
public:
  Fl_Group* make_window();
  Fl_Group *harmonic;
  mwheel_slider *mag;
private:
  inline void cb_mag_i(mwheel_slider*, void*);
  static void cb_mag(mwheel_slider*, void*);
public:
  mwheel_slider *bw;
private:
  inline void cb_bw_i(mwheel_slider*, void*);
  static void cb_bw(mwheel_slider*, void*);
public:
  Fl_Box *h_dash;
  Fl_Box *h_num;
  SUBnoteharmonic(int x,int y, int w, int h, const char *label=0);
  void send_data(int action, int insert, int control, float value, int type);
  void init(SUBnoteParameters *pars_, int n_, int npart_, int kititem_);
  void refresh();
  ~SUBnoteharmonic();
private:
  SUBnoteParameters *pars;
  SynthEngine *synth;
  int n;
  int npart;
  int kititem;
};
#include <FL/Fl_Scroll.H>
#include <FL/Fl_Pack.H>
#include <FL/Fl_Group.H>
#include <FL/Fl_Text_Display.H>
#include <FL/Fl_Counter.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_Value_Output.H>
#include <FL/Fl_Button.H>

class SUBnoteUI : public PresetsUI_ {
public:
  ScaleTrackedWindow* make_window();
// randompan MUST be placed after panwidth
  ScaleTrackedWindow *SUBparameters;
private:
  inline void cb_SUBparameters_i(ScaleTrackedWindow*, void*);
  static void cb_SUBparameters(ScaleTrackedWindow*, void*);
public:
  Fl_Scroll *frame;
  Fl_Pack *harmonics;
  Fl_Group *ampgrp;
  EnvelopeUI *ampenv;
  WidgetPDial *vol;
private:
  inline void cb_vol_i(WidgetPDial*, void*);
  static void cb_vol(WidgetPDial*, void*);
public:
  WidgetPDial *vsns;
private:
  inline void cb_vsns_i(WidgetPDial*, void*);
  static void cb_vsns(WidgetPDial*, void*);
public:
  WidgetPDial *pan;
private:
  inline void cb_pan_i(WidgetPDial*, void*);
  static void cb_pan(WidgetPDial*, void*);
public:
  WidgetPDial *panwidth;
private:
  inline void cb_panwidth_i(WidgetPDial*, void*);
  static void cb_panwidth(WidgetPDial*, void*);
public:
  Fl_Check_Button2 *randompan;
private:
  inline void cb_randompan_i(Fl_Check_Button2*, void*);
  static void cb_randompan(Fl_Check_Button2*, void*);
public:
  LFOUI *amplfo;
  Fl_Box *ampLabel;
  Fl_Group *freqsettingsui;
  EnvelopeUI *freqenvelopegroup;
  LFOUI *freqlfogroup;
  Fl_Check_Button2 *freqee;
private:
  inline void cb_freqee_i(Fl_Check_Button2*, void*);
  static void cb_freqee(Fl_Check_Button2*, void*);
public:
  Fl_Check_Button2 *freqlfo;
private:
  inline void cb_freqlfo_i(Fl_Check_Button2*, void*);
  static void cb_freqlfo(Fl_Check_Button2*, void*);
public:
  Fl_Text_Display *octavetext;
  Fl_Counter *octave;
private:
  inline void cb_octave_i(Fl_Counter*, void*);
  static void cb_octave(Fl_Counter*, void*);
public:
  WidgetPDial *bend;
private:
  inline void cb_bend_i(WidgetPDial*, void*);
  static void cb_bend(WidgetPDial*, void*);
public:
  WidgetPDial *offset;
private:
  inline void cb_offset_i(WidgetPDial*, void*);
  static void cb_offset(WidgetPDial*, void*);
public:
  Fl_Check_Button2 *hz440;
private:
  inline void cb_hz440_i(Fl_Check_Button2*, void*);
  static void cb_hz440(Fl_Check_Button2*, void*);
public:
  WidgetPDial *fixedfreqetdial;
private:
  inline void cb_fixedfreqetdial_i(WidgetPDial*, void*);
  static void cb_fixedfreqetdial(WidgetPDial*, void*);
public:
  mwheel_slider_rev *detune;
private:
  inline void cb_detune_i(mwheel_slider_rev*, void*);
  static void cb_detune(mwheel_slider_rev*, void*);
public:
  Fl_Choice *detunetype;
private:
  inline void cb_detunetype_i(Fl_Choice*, void*);
  static void cb_detunetype(Fl_Choice*, void*);
public:
  Fl_Counter *coarsedet;
private:
  inline void cb_coarsedet_i(Fl_Counter*, void*);
  static void cb_coarsedet(Fl_Counter*, void*);
public:
  Fl_Value_Output *detunevalueoutput;
private:
  inline void cb_detunevalueoutput_i(Fl_Value_Output*, void*);
  static void cb_detunevalueoutput(Fl_Value_Output*, void*);
public:
  Fl_Group *bandwidthsettingsui;
  EnvelopeUI *bandwidthenvelopegroup;
  Fl_Check_Button2 *bwee;
private:
  inline void cb_bwee_i(Fl_Check_Button2*, void*);
  static void cb_bwee(Fl_Check_Button2*, void*);
public:
  mwheel_slider_rev *bandwidth;
private:
  inline void cb_bandwidth_i(mwheel_slider_rev*, void*);
  static void cb_bandwidth(mwheel_slider_rev*, void*);
public:
  mwheel_slider_rev *bwidthscale;
private:
  inline void cb_bwidthscale_i(mwheel_slider_rev*, void*);
  static void cb_bwidthscale(mwheel_slider_rev*, void*);
public:
  Fl_Group *spreadGroup;
  WidgetPDial *spreadpar1;
private:
  inline void cb_spreadpar1_i(WidgetPDial*, void*);
  static void cb_spreadpar1(WidgetPDial*, void*);
public:
  WidgetPDial *spreadpar2;
private:
  inline void cb_spreadpar2_i(WidgetPDial*, void*);
  static void cb_spreadpar2(WidgetPDial*, void*);
public:
  WidgetPDial *spreadpar3;
private:
  inline void cb_spreadpar3_i(WidgetPDial*, void*);
  static void cb_spreadpar3(WidgetPDial*, void*);
public:
  Fl_Choice *spreadtype;
private:
  inline void cb_spreadtype_i(Fl_Choice*, void*);
  static void cb_spreadtype(Fl_Choice*, void*);
public:
  Fl_Group *globalfiltergroup;
  EnvelopeUI *filterenv;
  FilterUI *filterui;
  LFOUI *filterlfo;
  Fl_Check_Button2 *filtere;
private:
  inline void cb_filtere_i(Fl_Check_Button2*, void*);
  static void cb_filtere(Fl_Check_Button2*, void*);
public:
  Fl_Counter *filterstages;
private:
  inline void cb_filterstages_i(Fl_Counter*, void*);
  static void cb_filterstages(Fl_Counter*, void*);
public:
  Fl_Choice *magtype;
private:
  inline void cb_magtype_i(Fl_Choice*, void*);
  static void cb_magtype(Fl_Choice*, void*);
public:
  Fl_Choice *start;
private:
  inline void cb_start_i(Fl_Choice*, void*);
  static void cb_start(Fl_Choice*, void*);
public:
  Fl_Check_Button2 *stereo;
private:
  inline void cb_stereo_i(Fl_Check_Button2*, void*);
  static void cb_stereo(Fl_Check_Button2*, void*);
public:
  Fl_Button *subClear;
private:
  inline void cb_subClear_i(Fl_Button*, void*);
  static void cb_subClear(Fl_Button*, void*);
public:
  Fl_Button *subCopy;
private:
  inline void cb_subCopy_i(Fl_Button*, void*);
  static void cb_subCopy(Fl_Button*, void*);
public:
  Fl_Button *subPaste;
private:
  inline void cb_subPaste_i(Fl_Button*, void*);
  static void cb_subPaste(Fl_Button*, void*);
public:
  Fl_Button *subClose;
private:
  inline void cb_subClose_i(Fl_Button*, void*);
  static void cb_subClose(Fl_Button*, void*);
public:
  void refresh();
  void Showsub();
  void subRtext();
  void theme();
  void send_data(int action, int control, float value, int type);
  void returns_update(CommandBlock *getData);
  SUBnoteUI(SUBnoteParameters *parameters, int npart_, int kititem_);
  virtual ~SUBnoteUI();
private:
  SUBnoteParameters *pars;
  SUBnoteharmonic *h[MAX_SUB_HARMONICS];
  SynthEngine *synth;
  int npart;
  int kititem;
  float subDW;
  float subDH;
  bool subSeen;
  int lastsubW;
};
#endif
