/* BackgroundManager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from BackgroundManager.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-2-or-later
 * SPDX-FileCopyrightText: 2011-2015 Wingpanel Developers (http://launchpad.net/wingpanel)
 *                         2025 elementary, Inc. (https://elementary.io)
 */

#include "wingpanel-interface.h"
#include <glib.h>
#include <meta/workspace.h>
#include <glib-object.h>
#include <gala.h>
#include <meta/meta-background-group.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <meta/meta-workspace-manager.h>
#include <meta/display.h>
#include <meta/common.h>
#include <meta/window.h>
#include <stdlib.h>
#include <string.h>

#define WINGPANEL_INTERFACE_BACKGROUND_MANAGER_MINIMIZE_DURATION 200
#define WINGPANEL_INTERFACE_BACKGROUND_MANAGER_SNAP_DURATION 250
#define WINGPANEL_INTERFACE_BACKGROUND_MANAGER_WALLPAPER_TRANSITION_DURATION 150
#define WINGPANEL_INTERFACE_BACKGROUND_MANAGER_WORKSPACE_SWITCH_DURATION 300
#define WINGPANEL_INTERFACE_BACKGROUND_MANAGER_ACUTANCE_THRESHOLD ((gdouble) 8)
#define WINGPANEL_INTERFACE_BACKGROUND_MANAGER_STD_THRESHOLD ((gdouble) 45)
#define WINGPANEL_INTERFACE_BACKGROUND_MANAGER_LUMINANCE_THRESHOLD ((gdouble) 180)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	WINGPANEL_INTERFACE_BACKGROUND_MANAGER_0_PROPERTY,
	WINGPANEL_INTERFACE_BACKGROUND_MANAGER_PANEL_HEIGHT_PROPERTY,
	WINGPANEL_INTERFACE_BACKGROUND_MANAGER_NUM_PROPERTIES
};
static GParamSpec* wingpanel_interface_background_manager_properties[WINGPANEL_INTERFACE_BACKGROUND_MANAGER_NUM_PROPERTIES];
#define _wingpanel_interface_utils_color_information_free0(var) ((var == NULL) ? NULL : (var = (wingpanel_interface_utils_color_information_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _WingpanelInterfaceBackgroundManagerUpdateBkColorInfoData WingpanelInterfaceBackgroundManagerUpdateBkColorInfoData;
enum  {
	WINGPANEL_INTERFACE_BACKGROUND_MANAGER_STATE_CHANGED_SIGNAL,
	WINGPANEL_INTERFACE_BACKGROUND_MANAGER_NUM_SIGNALS
};
static guint wingpanel_interface_background_manager_signals[WINGPANEL_INTERFACE_BACKGROUND_MANAGER_NUM_SIGNALS] = {0};

struct _WingpanelInterfaceBackgroundManagerPrivate {
	gint _panel_height;
	gulong wallpaper_hook_id;
	gboolean showing_desktop;
	MetaWorkspace* current_workspace;
	BackgroundState current_state;
	WingpanelInterfaceUtilsColorInformation* bk_color_info;
};

struct _Block1Data {
	int _ref_count_;
	WingpanelInterfaceBackgroundManager* self;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	gpointer _async_data_;
};

struct _WingpanelInterfaceBackgroundManagerUpdateBkColorInfoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	WingpanelInterfaceBackgroundManager* self;
	Block1Data* _data1_;
	GalaWindowManager* _tmp0_;
	gint _tmp1_;
};

static gint WingpanelInterfaceBackgroundManager_private_offset;
static gpointer wingpanel_interface_background_manager_parent_class = NULL;

static void wingpanel_interface_background_manager_connect_signals (WingpanelInterfaceBackgroundManager* self);
static void __lambda15_ (WingpanelInterfaceBackgroundManager* self,
                  GObject* obj,
                  GAsyncResult* res);
static void wingpanel_interface_background_manager_update_current_workspace (WingpanelInterfaceBackgroundManager* self);
static void ___lambda15__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void __lambda4_ (WingpanelInterfaceBackgroundManager* self);
static void ___lambda4__meta_workspace_manager_workspace_switched (MetaWorkspaceManager* _sender,
                                                            gint object,
                                                            gint p0,
                                                            MetaMotionDirection p1,
                                                            gpointer self);
static void __lambda9_ (WingpanelInterfaceBackgroundManager* self);
static void wingpanel_interface_background_manager_check_for_state_change (WingpanelInterfaceBackgroundManager* self,
                                                                    guint animation_duration);
static void ___lambda9__meta_workspace_manager_showing_desktop_changed (MetaWorkspaceManager* _sender,
                                                                 gpointer self);
static gboolean __lambda10_ (WingpanelInterfaceBackgroundManager* self,
                      GSignalInvocationHint* ihint,
                      GValue* param_values,
                      guint param_values_length1);
static void __lambda14_ (WingpanelInterfaceBackgroundManager* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda14__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static gboolean ___lambda10__gsignal_emission_hook (GSignalInvocationHint* ihint,
                                             guint n_param_values,
                                             GValue* param_values,
                                             gpointer self);
static void wingpanel_interface_background_manager_on_window_added (WingpanelInterfaceBackgroundManager* self,
                                                             MetaWindow* window);
static void _wingpanel_interface_background_manager_on_window_added_meta_workspace_window_added (MetaWorkspace* _sender,
                                                                                          MetaWindow* object,
                                                                                          gpointer self);
static void wingpanel_interface_background_manager_on_window_removed (WingpanelInterfaceBackgroundManager* self,
                                                               MetaWindow* window);
static void _wingpanel_interface_background_manager_on_window_removed_meta_workspace_window_removed (MetaWorkspace* _sender,
                                                                                              MetaWindow* object,
                                                                                              gpointer self);
static void wingpanel_interface_background_manager_register_window (WingpanelInterfaceBackgroundManager* self,
                                                             MetaWindow* window);
static void __lambda5_ (WingpanelInterfaceBackgroundManager* self);
static void ___lambda5__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void __lambda6_ (WingpanelInterfaceBackgroundManager* self);
static void ___lambda6__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void __lambda7_ (WingpanelInterfaceBackgroundManager* self);
static void ___lambda7__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void __lambda8_ (WingpanelInterfaceBackgroundManager* self);
static void ___lambda8__meta_window_workspace_changed (MetaWindow* _sender,
                                                gpointer self);
static void wingpanel_interface_background_manager_update_bk_color_info_data_free (gpointer _data);
static gboolean wingpanel_interface_background_manager_update_bk_color_info_co (WingpanelInterfaceBackgroundManagerUpdateBkColorInfoData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean _wingpanel_interface_background_manager_update_bk_color_info_co_gsource_func (gpointer self);
static gint wingpanel_interface_background_manager_get_panel_height (WingpanelInterfaceBackgroundManager* self);
static void __lambda13_ (Block1Data* _data1_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda13__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void g_cclosure_user_marshal_VOID__ENUM_UINT (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data);
static void wingpanel_interface_background_manager_finalize (GObject * obj);
static GType wingpanel_interface_background_manager_get_type_once (void);
static void _vala_wingpanel_interface_background_manager_get_property (GObject * object,
                                                                guint property_id,
                                                                GValue * value,
                                                                GParamSpec * pspec);
static void _vala_wingpanel_interface_background_manager_set_property (GObject * object,
                                                                guint property_id,
                                                                const GValue * value,
                                                                GParamSpec * pspec);

static GType
background_state_get_type_once (void)
{
	static const GEnumValue values[] = {{BACKGROUND_STATE_LIGHT, "BACKGROUND_STATE_LIGHT", "light"}, {BACKGROUND_STATE_DARK, "BACKGROUND_STATE_DARK", "dark"}, {BACKGROUND_STATE_MAXIMIZED, "BACKGROUND_STATE_MAXIMIZED", "maximized"}, {BACKGROUND_STATE_TRANSLUCENT_DARK, "BACKGROUND_STATE_TRANSLUCENT_DARK", "translucent-dark"}, {BACKGROUND_STATE_TRANSLUCENT_LIGHT, "BACKGROUND_STATE_TRANSLUCENT_LIGHT", "translucent-light"}, {0, NULL, NULL}};
	GType background_state_type_id;
	background_state_type_id = g_enum_register_static ("BackgroundState", values);
	return background_state_type_id;
}

GType
background_state_get_type (void)
{
	static volatile gsize background_state_type_id__once = 0;
	if (g_once_init_enter (&background_state_type_id__once)) {
		GType background_state_type_id;
		background_state_type_id = background_state_get_type_once ();
		g_once_init_leave (&background_state_type_id__once, background_state_type_id);
	}
	return background_state_type_id__once;
}

static inline gpointer
wingpanel_interface_background_manager_get_instance_private (WingpanelInterfaceBackgroundManager* self)
{
	return G_STRUCT_MEMBER_P (self, WingpanelInterfaceBackgroundManager_private_offset);
}

static void
__lambda15_ (WingpanelInterfaceBackgroundManager* self,
             GObject* obj,
             GAsyncResult* res)
{
	g_return_if_fail (res != NULL);
	wingpanel_interface_background_manager_update_bk_color_info_finish (self, res);
	wingpanel_interface_background_manager_update_current_workspace (self);
}

static void
___lambda15__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda15_ ((WingpanelInterfaceBackgroundManager*) self, source_object, res);
	g_object_unref (self);
}

WingpanelInterfaceBackgroundManager*
wingpanel_interface_background_manager_construct (GType object_type,
                                                  gint panel_height)
{
	WingpanelInterfaceBackgroundManager * self = NULL;
	self = (WingpanelInterfaceBackgroundManager*) g_object_new (object_type, "panel-height", panel_height, NULL);
	wingpanel_interface_background_manager_connect_signals (self);
	wingpanel_interface_background_manager_update_bk_color_info (self, ___lambda15__gasync_ready_callback, g_object_ref (self));
	return self;
}

WingpanelInterfaceBackgroundManager*
wingpanel_interface_background_manager_new (gint panel_height)
{
	return wingpanel_interface_background_manager_construct (WINGPANEL_INTERFACE_TYPE_BACKGROUND_MANAGER, panel_height);
}

static void
__lambda4_ (WingpanelInterfaceBackgroundManager* self)
{
	wingpanel_interface_background_manager_update_current_workspace (self);
}

static void
___lambda4__meta_workspace_manager_workspace_switched (MetaWorkspaceManager* _sender,
                                                       gint object,
                                                       gint p0,
                                                       MetaMotionDirection p1,
                                                       gpointer self)
{
	__lambda4_ ((WingpanelInterfaceBackgroundManager*) self);
}

static void
__lambda9_ (WingpanelInterfaceBackgroundManager* self)
{
	self->priv->showing_desktop = !self->priv->showing_desktop;
	wingpanel_interface_background_manager_check_for_state_change (self, (guint) WINGPANEL_INTERFACE_BACKGROUND_MANAGER_WALLPAPER_TRANSITION_DURATION);
}

static void
___lambda9__meta_workspace_manager_showing_desktop_changed (MetaWorkspaceManager* _sender,
                                                            gpointer self)
{
	__lambda9_ ((WingpanelInterfaceBackgroundManager*) self);
}

static void
__lambda14_ (WingpanelInterfaceBackgroundManager* self,
             GObject* obj,
             GAsyncResult* res)
{
	g_return_if_fail (res != NULL);
	wingpanel_interface_background_manager_update_bk_color_info_finish (self, res);
	wingpanel_interface_background_manager_check_for_state_change (self, (guint) WINGPANEL_INTERFACE_BACKGROUND_MANAGER_WALLPAPER_TRANSITION_DURATION);
}

static void
___lambda14__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda14_ ((WingpanelInterfaceBackgroundManager*) self, source_object, res);
	g_object_unref (self);
}

static gboolean
__lambda10_ (WingpanelInterfaceBackgroundManager* self,
             GSignalInvocationHint* ihint,
             GValue* param_values,
             guint param_values_length1)
{
	gboolean result;
	g_return_val_if_fail (ihint != NULL, FALSE);
	wingpanel_interface_background_manager_update_bk_color_info (self, ___lambda14__gasync_ready_callback, g_object_ref (self));
	result = TRUE;
	return result;
}

static gboolean
___lambda10__gsignal_emission_hook (GSignalInvocationHint* ihint,
                                    guint n_param_values,
                                    GValue* param_values,
                                    gpointer self)
{
	gboolean result;
	result = __lambda10_ ((WingpanelInterfaceBackgroundManager*) self, ihint, param_values, n_param_values);
	return result;
}

static void
wingpanel_interface_background_manager_connect_signals (WingpanelInterfaceBackgroundManager* self)
{
	MetaWorkspaceManager* manager = NULL;
	MetaDisplay* _tmp0_;
	MetaWorkspaceManager* _tmp1_;
	guint signal_id = 0U;
	GalaWindowManager* _tmp2_;
	MetaBackgroundGroup* _tmp3_;
	MetaBackgroundGroup* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = wingpanel_interface_main_display;
	_tmp1_ = meta_display_get_workspace_manager (_tmp0_);
	manager = _tmp1_;
	g_signal_connect_object (manager, "workspace-switched", (GCallback) ___lambda4__meta_workspace_manager_workspace_switched, self, 0);
	g_signal_connect_object (manager, "showing-desktop-changed", (GCallback) ___lambda9__meta_workspace_manager_showing_desktop_changed, self, 0);
	_tmp2_ = wingpanel_interface_main_wm;
	_tmp3_ = gala_window_manager_get_background_group (_tmp2_);
	_tmp4_ = _tmp3_;
	signal_id = g_signal_lookup ("changed", G_TYPE_FROM_INSTANCE ((GObject*) _tmp4_));
	self->priv->wallpaper_hook_id = g_signal_add_emission_hook (signal_id, (GQuark) 0, ___lambda10__gsignal_emission_hook, g_object_ref (self), g_object_unref);
}

static void
_wingpanel_interface_background_manager_on_window_added_meta_workspace_window_added (MetaWorkspace* _sender,
                                                                                     MetaWindow* object,
                                                                                     gpointer self)
{
	wingpanel_interface_background_manager_on_window_added ((WingpanelInterfaceBackgroundManager*) self, object);
}

static void
_wingpanel_interface_background_manager_on_window_removed_meta_workspace_window_removed (MetaWorkspace* _sender,
                                                                                         MetaWindow* object,
                                                                                         gpointer self)
{
	wingpanel_interface_background_manager_on_window_removed ((WingpanelInterfaceBackgroundManager*) self, object);
}

static void
wingpanel_interface_background_manager_update_current_workspace (WingpanelInterfaceBackgroundManager* self)
{
	MetaWorkspaceManager* manager = NULL;
	MetaDisplay* _tmp0_;
	MetaWorkspaceManager* _tmp1_;
	MetaWorkspace* workspace = NULL;
	MetaWorkspaceManager* _tmp2_;
	MetaWorkspace* _tmp3_;
	MetaWorkspace* _tmp4_;
	MetaWorkspace* _tmp5_;
	MetaWorkspace* _tmp10_;
	MetaWorkspace* _tmp11_;
	GList* _tmp12_;
	MetaWorkspace* _tmp15_;
	MetaWorkspace* _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = wingpanel_interface_main_display;
	_tmp1_ = meta_display_get_workspace_manager (_tmp0_);
	manager = _tmp1_;
	_tmp2_ = manager;
	_tmp3_ = meta_workspace_manager_get_active_workspace (_tmp2_);
	workspace = _tmp3_;
	_tmp4_ = workspace;
	if (_tmp4_ == NULL) {
		g_warning ("BackgroundManager.vala:78: Cannot get active workspace");
		return;
	}
	_tmp5_ = self->priv->current_workspace;
	if (_tmp5_ != NULL) {
		MetaWorkspace* _tmp6_;
		guint _tmp7_;
		MetaWorkspace* _tmp8_;
		guint _tmp9_;
		_tmp6_ = self->priv->current_workspace;
		g_signal_parse_name ("window-added", meta_workspace_get_type (), &_tmp7_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _wingpanel_interface_background_manager_on_window_added_meta_workspace_window_added, self);
		_tmp8_ = self->priv->current_workspace;
		g_signal_parse_name ("window-removed", meta_workspace_get_type (), &_tmp9_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _wingpanel_interface_background_manager_on_window_removed_meta_workspace_window_removed, self);
	}
	_tmp10_ = workspace;
	self->priv->current_workspace = _tmp10_;
	_tmp11_ = self->priv->current_workspace;
	_tmp12_ = meta_workspace_list_windows (_tmp11_);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp12_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MetaWindow* window = NULL;
			window = (MetaWindow*) window_it->data;
			{
				MetaWindow* _tmp13_;
				_tmp13_ = window;
				if (meta_window_is_on_primary_monitor (_tmp13_)) {
					MetaWindow* _tmp14_;
					_tmp14_ = window;
					wingpanel_interface_background_manager_register_window (self, _tmp14_);
				}
			}
		}
		(window_collection == NULL) ? NULL : (window_collection = (g_list_free (window_collection), NULL));
	}
	_tmp15_ = self->priv->current_workspace;
	g_signal_connect_object (_tmp15_, "window-added", (GCallback) _wingpanel_interface_background_manager_on_window_added_meta_workspace_window_added, self, 0);
	_tmp16_ = self->priv->current_workspace;
	g_signal_connect_object (_tmp16_, "window-removed", (GCallback) _wingpanel_interface_background_manager_on_window_removed_meta_workspace_window_removed, self, 0);
	wingpanel_interface_background_manager_check_for_state_change (self, (guint) WINGPANEL_INTERFACE_BACKGROUND_MANAGER_WORKSPACE_SWITCH_DURATION);
}

static void
__lambda5_ (WingpanelInterfaceBackgroundManager* self)
{
	wingpanel_interface_background_manager_check_for_state_change (self, (guint) WINGPANEL_INTERFACE_BACKGROUND_MANAGER_SNAP_DURATION);
}

static void
___lambda5__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda5_ ((WingpanelInterfaceBackgroundManager*) self);
}

static void
__lambda6_ (WingpanelInterfaceBackgroundManager* self)
{
	wingpanel_interface_background_manager_check_for_state_change (self, (guint) WINGPANEL_INTERFACE_BACKGROUND_MANAGER_MINIMIZE_DURATION);
}

static void
___lambda6__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda6_ ((WingpanelInterfaceBackgroundManager*) self);
}

static void
__lambda7_ (WingpanelInterfaceBackgroundManager* self)
{
	wingpanel_interface_background_manager_check_for_state_change (self, (guint) WINGPANEL_INTERFACE_BACKGROUND_MANAGER_SNAP_DURATION);
}

static void
___lambda7__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda7_ ((WingpanelInterfaceBackgroundManager*) self);
}

static void
__lambda8_ (WingpanelInterfaceBackgroundManager* self)
{
	wingpanel_interface_background_manager_check_for_state_change (self, (guint) WINGPANEL_INTERFACE_BACKGROUND_MANAGER_WORKSPACE_SWITCH_DURATION);
}

static void
___lambda8__meta_window_workspace_changed (MetaWindow* _sender,
                                           gpointer self)
{
	__lambda8_ ((WingpanelInterfaceBackgroundManager*) self);
}

static void
wingpanel_interface_background_manager_register_window (WingpanelInterfaceBackgroundManager* self,
                                                        MetaWindow* window)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	g_signal_connect_object ((GObject*) window, "notify::maximized-vertically", (GCallback) ___lambda5__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) window, "notify::minimized", (GCallback) ___lambda6__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) window, "notify::fullscreen", (GCallback) ___lambda7__g_object_notify, self, 0);
	g_signal_connect_object (window, "workspace-changed", (GCallback) ___lambda8__meta_window_workspace_changed, self, 0);
}

static void
wingpanel_interface_background_manager_on_window_added (WingpanelInterfaceBackgroundManager* self,
                                                        MetaWindow* window)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	wingpanel_interface_background_manager_register_window (self, window);
	wingpanel_interface_background_manager_check_for_state_change (self, (guint) WINGPANEL_INTERFACE_BACKGROUND_MANAGER_SNAP_DURATION);
}

static void
wingpanel_interface_background_manager_on_window_removed (WingpanelInterfaceBackgroundManager* self,
                                                          MetaWindow* window)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	wingpanel_interface_background_manager_check_for_state_change (self, (guint) WINGPANEL_INTERFACE_BACKGROUND_MANAGER_SNAP_DURATION);
}

static void
wingpanel_interface_background_manager_update_bk_color_info_data_free (gpointer _data)
{
	WingpanelInterfaceBackgroundManagerUpdateBkColorInfoData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (WingpanelInterfaceBackgroundManagerUpdateBkColorInfoData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
wingpanel_interface_background_manager_update_bk_color_info (WingpanelInterfaceBackgroundManager* self,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_)
{
	WingpanelInterfaceBackgroundManagerUpdateBkColorInfoData* _data_;
	WingpanelInterfaceBackgroundManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (WingpanelInterfaceBackgroundManagerUpdateBkColorInfoData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, wingpanel_interface_background_manager_update_bk_color_info_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	wingpanel_interface_background_manager_update_bk_color_info_co (_data_);
}

void
wingpanel_interface_background_manager_update_bk_color_info_finish (WingpanelInterfaceBackgroundManager* self,
                                                                    GAsyncResult* _res_)
{
	WingpanelInterfaceBackgroundManagerUpdateBkColorInfoData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		WingpanelInterfaceBackgroundManager* self;
		self = _data1_->self;
		(_data1_->callback_target_destroy_notify == NULL) ? NULL : (_data1_->callback_target_destroy_notify (_data1_->callback_target), NULL);
		_data1_->callback = NULL;
		_data1_->callback_target = NULL;
		_data1_->callback_target_destroy_notify = NULL;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gboolean
_wingpanel_interface_background_manager_update_bk_color_info_co_gsource_func (gpointer self)
{
	gboolean result;
	result = wingpanel_interface_background_manager_update_bk_color_info_co (self);
	return result;
}

static gpointer
_wingpanel_interface_utils_color_information_dup0 (gpointer self)
{
	return self ? wingpanel_interface_utils_color_information_dup (self) : NULL;
}

static void
__lambda13_ (Block1Data* _data1_,
             GObject* obj,
             GAsyncResult* res)
{
	WingpanelInterfaceBackgroundManager* self;
	GError* _inner_error0_ = NULL;
	self = _data1_->self;
	g_return_if_fail (res != NULL);
	{
		WingpanelInterfaceUtilsColorInformation _tmp0_ = {0};
		WingpanelInterfaceUtilsColorInformation _tmp1_ = {0};
		WingpanelInterfaceUtilsColorInformation* _tmp2_;
		wingpanel_interface_utils_get_background_color_information_finish (res, &_tmp1_, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _wingpanel_interface_utils_color_information_dup0 (&_tmp0_);
		_wingpanel_interface_utils_color_information_free0 (self->priv->bk_color_info);
		self->priv->bk_color_info = _tmp2_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("BackgroundManager.vala:137: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	{
		GError* _inner_error1_ = NULL;
		_data1_->callback (_data1_->callback_target);
	}
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda13__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda13_ (self, source_object, res);
	block1_data_unref (self);
}

static gboolean
wingpanel_interface_background_manager_update_bk_color_info_co (WingpanelInterfaceBackgroundManagerUpdateBkColorInfoData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_data_->_data1_->_async_data_ = _data_;
	_data_->_data1_->callback = _wingpanel_interface_background_manager_update_bk_color_info_co_gsource_func;
	_data_->_data1_->callback_target = _data_;
	_data_->_data1_->callback_target_destroy_notify = NULL;
	_data_->_tmp0_ = wingpanel_interface_main_wm;
	_data_->_tmp1_ = _data_->self->priv->_panel_height;
	wingpanel_interface_utils_get_background_color_information (_data_->_tmp0_, _data_->_tmp1_, ___lambda13__gasync_ready_callback, block1_data_ref (_data_->_data1_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
     * Check if Wingpanel's background state should change.
     *
     * The state is defined as follows:
     *  - If there's a maximized or fullscreen window, the state should be MAXIMIZED;
     *  - If no information about the background could be gathered, it should be TRANSLUCENT;
     *  - If there's too much contrast or sharpness, it should be TRANSLUCENT;
     *  - If the background is too bright, it should be DARK;
     *  - Else it should be LIGHT.
     */
static void
wingpanel_interface_background_manager_check_for_state_change (WingpanelInterfaceBackgroundManager* self,
                                                               guint animation_duration)
{
	gboolean _tmp0_ = FALSE;
	gboolean has_fullscreen_window = FALSE;
	gboolean has_maximized_window = FALSE;
	MetaWorkspace* _tmp1_;
	GList* _tmp2_;
	BackgroundState new_state = 0;
	g_return_if_fail (self != NULL);
	if (self->priv->showing_desktop) {
		_tmp0_ = self->priv->current_state != BACKGROUND_STATE_LIGHT;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		self->priv->current_state = BACKGROUND_STATE_LIGHT;
		g_signal_emit (self, wingpanel_interface_background_manager_signals[WINGPANEL_INTERFACE_BACKGROUND_MANAGER_STATE_CHANGED_SIGNAL], 0, self->priv->current_state, animation_duration);
		return;
	}
	has_fullscreen_window = FALSE;
	has_maximized_window = FALSE;
	_tmp1_ = self->priv->current_workspace;
	_tmp2_ = meta_workspace_list_windows (_tmp1_);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp2_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MetaWindow* window = NULL;
			window = (MetaWindow*) window_it->data;
			{
				gboolean _tmp3_ = FALSE;
				MetaWindow* _tmp4_;
				MetaWindow* _tmp8_;
				gboolean _tmp9_;
				gboolean _tmp10_;
				_tmp4_ = window;
				if (!meta_window_is_on_primary_monitor (_tmp4_)) {
					_tmp3_ = TRUE;
				} else {
					MetaWindow* _tmp5_;
					gboolean _tmp6_;
					gboolean _tmp7_;
					_tmp5_ = window;
					g_object_get (_tmp5_, "minimized", &_tmp6_, NULL);
					_tmp7_ = _tmp6_;
					_tmp3_ = _tmp7_;
				}
				if (_tmp3_) {
					continue;
				}
				_tmp8_ = window;
				g_object_get (_tmp8_, "fullscreen", &_tmp9_, NULL);
				_tmp10_ = _tmp9_;
				if (_tmp10_) {
					has_fullscreen_window = TRUE;
				} else {
					MetaWindow* _tmp11_;
					gboolean _tmp12_;
					gboolean _tmp13_;
					_tmp11_ = window;
					g_object_get (_tmp11_, "maximized-vertically", &_tmp12_, NULL);
					_tmp13_ = _tmp12_;
					if (_tmp13_) {
						has_maximized_window = TRUE;
					}
				}
			}
		}
		(window_collection == NULL) ? NULL : (window_collection = (g_list_free (window_collection), NULL));
	}
	if (has_fullscreen_window) {
		new_state = BACKGROUND_STATE_TRANSLUCENT_LIGHT;
	} else {
		if (has_maximized_window) {
			new_state = BACKGROUND_STATE_MAXIMIZED;
		} else {
			WingpanelInterfaceUtilsColorInformation* _tmp14_;
			_tmp14_ = self->priv->bk_color_info;
			if (_tmp14_ == NULL) {
				new_state = BACKGROUND_STATE_TRANSLUCENT_LIGHT;
			} else {
				gdouble luminance_std = 0.0;
				WingpanelInterfaceUtilsColorInformation* _tmp15_;
				gboolean _tmp16_ = FALSE;
				gboolean _tmp17_ = FALSE;
				gboolean bg_is_busy = FALSE;
				gboolean bg_is_dark = FALSE;
				WingpanelInterfaceUtilsColorInformation* _tmp22_;
				gboolean bg_is_busy_dark = FALSE;
				WingpanelInterfaceUtilsColorInformation* _tmp23_;
				gboolean _tmp24_ = FALSE;
				_tmp15_ = self->priv->bk_color_info;
				luminance_std = sqrt ((*_tmp15_).luminance_variance);
				if (luminance_std > WINGPANEL_INTERFACE_BACKGROUND_MANAGER_STD_THRESHOLD) {
					_tmp17_ = TRUE;
				} else {
					gboolean _tmp18_ = FALSE;
					WingpanelInterfaceUtilsColorInformation* _tmp19_;
					_tmp19_ = self->priv->bk_color_info;
					if ((*_tmp19_).mean_luminance < WINGPANEL_INTERFACE_BACKGROUND_MANAGER_LUMINANCE_THRESHOLD) {
						WingpanelInterfaceUtilsColorInformation* _tmp20_;
						_tmp20_ = self->priv->bk_color_info;
						_tmp18_ = ((*_tmp20_).mean_luminance + (1.645 * luminance_std)) > WINGPANEL_INTERFACE_BACKGROUND_MANAGER_LUMINANCE_THRESHOLD;
					} else {
						_tmp18_ = FALSE;
					}
					_tmp17_ = _tmp18_;
				}
				if (_tmp17_) {
					_tmp16_ = TRUE;
				} else {
					WingpanelInterfaceUtilsColorInformation* _tmp21_;
					_tmp21_ = self->priv->bk_color_info;
					_tmp16_ = (*_tmp21_).mean_acutance > WINGPANEL_INTERFACE_BACKGROUND_MANAGER_ACUTANCE_THRESHOLD;
				}
				bg_is_busy = _tmp16_;
				_tmp22_ = self->priv->bk_color_info;
				bg_is_dark = (*_tmp22_).mean_luminance > WINGPANEL_INTERFACE_BACKGROUND_MANAGER_LUMINANCE_THRESHOLD;
				_tmp23_ = self->priv->bk_color_info;
				bg_is_busy_dark = ((*_tmp23_).mean_luminance * 1.25) > WINGPANEL_INTERFACE_BACKGROUND_MANAGER_LUMINANCE_THRESHOLD;
				if (bg_is_busy) {
					_tmp24_ = bg_is_busy_dark;
				} else {
					_tmp24_ = FALSE;
				}
				if (_tmp24_) {
					new_state = BACKGROUND_STATE_TRANSLUCENT_DARK;
				} else {
					if (bg_is_busy) {
						new_state = BACKGROUND_STATE_TRANSLUCENT_LIGHT;
					} else {
						if (bg_is_dark) {
							new_state = BACKGROUND_STATE_DARK;
						} else {
							new_state = BACKGROUND_STATE_LIGHT;
						}
					}
				}
			}
		}
	}
	if (new_state != self->priv->current_state) {
		self->priv->current_state = new_state;
		g_signal_emit (self, wingpanel_interface_background_manager_signals[WINGPANEL_INTERFACE_BACKGROUND_MANAGER_STATE_CHANGED_SIGNAL], 0, self->priv->current_state, animation_duration);
	}
}

static gint
wingpanel_interface_background_manager_get_panel_height (WingpanelInterfaceBackgroundManager* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_panel_height;
	return result;
}

static void
wingpanel_interface_background_manager_set_panel_height (WingpanelInterfaceBackgroundManager* self,
                                                         gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = wingpanel_interface_background_manager_get_panel_height (self);
	if (old_value != value) {
		self->priv->_panel_height = value;
		g_object_notify_by_pspec ((GObject *) self, wingpanel_interface_background_manager_properties[WINGPANEL_INTERFACE_BACKGROUND_MANAGER_PANEL_HEIGHT_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__ENUM_UINT (GClosure * closure,
                                         GValue * return_value,
                                         guint n_param_values,
                                         const GValue * param_values,
                                         gpointer invocation_hint,
                                         gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__ENUM_UINT) (gpointer data1, gint arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__ENUM_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__ENUM_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_enum (param_values + 1), g_value_get_uint (param_values + 2), data2);
}

static void
wingpanel_interface_background_manager_class_init (WingpanelInterfaceBackgroundManagerClass * klass,
                                                   gpointer klass_data)
{
	wingpanel_interface_background_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &WingpanelInterfaceBackgroundManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_wingpanel_interface_background_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_wingpanel_interface_background_manager_set_property;
	G_OBJECT_CLASS (klass)->finalize = wingpanel_interface_background_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), WINGPANEL_INTERFACE_BACKGROUND_MANAGER_PANEL_HEIGHT_PROPERTY, wingpanel_interface_background_manager_properties[WINGPANEL_INTERFACE_BACKGROUND_MANAGER_PANEL_HEIGHT_PROPERTY] = g_param_spec_int ("panel-height", "panel-height", "panel-height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	wingpanel_interface_background_manager_signals[WINGPANEL_INTERFACE_BACKGROUND_MANAGER_STATE_CHANGED_SIGNAL] = g_signal_new ("state-changed", WINGPANEL_INTERFACE_TYPE_BACKGROUND_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__ENUM_UINT, G_TYPE_NONE, 2, TYPE_BACKGROUND_STATE, G_TYPE_UINT);
}

static void
wingpanel_interface_background_manager_instance_init (WingpanelInterfaceBackgroundManager * self,
                                                      gpointer klass)
{
	self->priv = wingpanel_interface_background_manager_get_instance_private (self);
	self->priv->showing_desktop = FALSE;
	self->priv->current_workspace = NULL;
	self->priv->current_state = BACKGROUND_STATE_LIGHT;
	self->priv->bk_color_info = NULL;
}

static void
wingpanel_interface_background_manager_finalize (GObject * obj)
{
	WingpanelInterfaceBackgroundManager * self;
	guint signal_id = 0U;
	GalaWindowManager* _tmp0_;
	MetaBackgroundGroup* _tmp1_;
	MetaBackgroundGroup* _tmp2_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WINGPANEL_INTERFACE_TYPE_BACKGROUND_MANAGER, WingpanelInterfaceBackgroundManager);
	_tmp0_ = wingpanel_interface_main_wm;
	_tmp1_ = gala_window_manager_get_background_group (_tmp0_);
	_tmp2_ = _tmp1_;
	signal_id = g_signal_lookup ("changed", G_TYPE_FROM_INSTANCE ((GObject*) _tmp2_));
	g_signal_remove_emission_hook (signal_id, self->priv->wallpaper_hook_id);
	_wingpanel_interface_utils_color_information_free0 (self->priv->bk_color_info);
	G_OBJECT_CLASS (wingpanel_interface_background_manager_parent_class)->finalize (obj);
}

static GType
wingpanel_interface_background_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WingpanelInterfaceBackgroundManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) wingpanel_interface_background_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WingpanelInterfaceBackgroundManager), 0, (GInstanceInitFunc) wingpanel_interface_background_manager_instance_init, NULL };
	GType wingpanel_interface_background_manager_type_id;
	wingpanel_interface_background_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "WingpanelInterfaceBackgroundManager", &g_define_type_info, 0);
	WingpanelInterfaceBackgroundManager_private_offset = g_type_add_instance_private (wingpanel_interface_background_manager_type_id, sizeof (WingpanelInterfaceBackgroundManagerPrivate));
	return wingpanel_interface_background_manager_type_id;
}

GType
wingpanel_interface_background_manager_get_type (void)
{
	static volatile gsize wingpanel_interface_background_manager_type_id__once = 0;
	if (g_once_init_enter (&wingpanel_interface_background_manager_type_id__once)) {
		GType wingpanel_interface_background_manager_type_id;
		wingpanel_interface_background_manager_type_id = wingpanel_interface_background_manager_get_type_once ();
		g_once_init_leave (&wingpanel_interface_background_manager_type_id__once, wingpanel_interface_background_manager_type_id);
	}
	return wingpanel_interface_background_manager_type_id__once;
}

static void
_vala_wingpanel_interface_background_manager_get_property (GObject * object,
                                                           guint property_id,
                                                           GValue * value,
                                                           GParamSpec * pspec)
{
	WingpanelInterfaceBackgroundManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, WINGPANEL_INTERFACE_TYPE_BACKGROUND_MANAGER, WingpanelInterfaceBackgroundManager);
	switch (property_id) {
		case WINGPANEL_INTERFACE_BACKGROUND_MANAGER_PANEL_HEIGHT_PROPERTY:
		g_value_set_int (value, wingpanel_interface_background_manager_get_panel_height (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_wingpanel_interface_background_manager_set_property (GObject * object,
                                                           guint property_id,
                                                           const GValue * value,
                                                           GParamSpec * pspec)
{
	WingpanelInterfaceBackgroundManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, WINGPANEL_INTERFACE_TYPE_BACKGROUND_MANAGER, WingpanelInterfaceBackgroundManager);
	switch (property_id) {
		case WINGPANEL_INTERFACE_BACKGROUND_MANAGER_PANEL_HEIGHT_PROPERTY:
		wingpanel_interface_background_manager_set_panel_height (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

