//
// Copyright 2016 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
// This file is generated by a script.  Do not edit directly.  Edit the
// wrapMatrix4.template.cpp file to make changes.

#ifndef PXR_BOOST_PYTHON_MAX_ARITY
#define PXR_BOOST_PYTHON_MAX_ARITY 20
#endif


#include "pxr/pxr.h"
#include "pxr/base/gf/matrix4d.h"
#include "pxr/base/gf/matrix4f.h"

#include "pxr/base/gf/pyBufferUtils.h"

#include "pxr/base/gf/matrix3f.h"
#include "pxr/base/gf/quatf.h"
#include "pxr/base/gf/rotation.h"

#include "pxr/base/tf/hash.h"
#include "pxr/base/tf/pyUtils.h"
#include "pxr/base/tf/pyContainerConversions.h"
#include "pxr/base/tf/wrapTypeHelpers.h"

#include "pxr/external/boost/python/class.hpp"
#include "pxr/external/boost/python/def.hpp"
#include "pxr/external/boost/python/detail/api_placeholder.hpp"
#include "pxr/external/boost/python/errors.hpp"
#include "pxr/external/boost/python/extract.hpp"
#include "pxr/external/boost/python/make_constructor.hpp"
#include "pxr/external/boost/python/operators.hpp"
#include "pxr/external/boost/python/return_arg.hpp"
#include "pxr/external/boost/python/tuple.hpp"

#include <string>
#include <vector>

using std::string;
using std::vector;

PXR_NAMESPACE_USING_DIRECTIVE

using namespace pxr_boost::python;

namespace {

////////////////////////////////////////////////////////////////////////
// Python buffer protocol support.

// Python's getbuffer interface function.
static int
getbuffer(PyObject *self, Py_buffer *view, int flags) {
    if (view == NULL) {
        PyErr_SetString(PyExc_ValueError, "NULL view in getbuffer");
        return -1;
    }

    // We don't support fortran order.
    if ((flags & PyBUF_F_CONTIGUOUS) == PyBUF_F_CONTIGUOUS) {
        PyErr_SetString(PyExc_ValueError, "Fortran contiguity unsupported");
        return -1;
    }

    GfMatrix4f &mat = extract<GfMatrix4f &>(self);

    view->obj = self;
    view->buf = static_cast<void *>(mat.GetArray());
    view->len = sizeof(GfMatrix4f);
    view->readonly = 0;
    view->itemsize = sizeof(float);
    if ((flags & PyBUF_FORMAT) == PyBUF_FORMAT) {
        view->format = Gf_GetPyBufferFmtFor<float>();
    } else {
        view->format = NULL;
    }
    if ((flags & PyBUF_ND) == PyBUF_ND) {
        view->ndim = 2;
        static Py_ssize_t shape[] = { 4, 4 };
        view->shape = shape;
    } else {
        view->ndim = 0;
        view->shape = NULL;
    }
    if ((flags & PyBUF_STRIDES) == PyBUF_STRIDES) {
        static Py_ssize_t strides[] = {
            4 * sizeof(float), sizeof(float) };
        view->strides = strides;
    } else {
        view->strides = NULL;
    }
    view->suboffsets = NULL;
    view->internal = NULL;

    Py_INCREF(self); // need to retain a reference to self.
    return 0;
}

// This structure serves to instantiate a PyBufferProcs instance with pointers
// to the right buffer protocol functions.
static PyBufferProcs bufferProcs = {
    (getbufferproc) getbuffer,
    (releasebufferproc) 0,
};

// End python buffer protocol support.
////////////////////////////////////////////////////////////////////////

static string _Repr(GfMatrix4f const &self) {
    static char newline[] = ",\n            ";
    return TF_PY_REPR_PREFIX + "Matrix4f(" +
        TfPyRepr(self[0][0]) + ", " + TfPyRepr(self[0][1]) + ", " + TfPyRepr(self[0][2]) + ", " + TfPyRepr(self[0][3]) + newline +
        TfPyRepr(self[1][0]) + ", " + TfPyRepr(self[1][1]) + ", " + TfPyRepr(self[1][2]) + ", " + TfPyRepr(self[1][3]) + newline +
        TfPyRepr(self[2][0]) + ", " + TfPyRepr(self[2][1]) + ", " + TfPyRepr(self[2][2]) + ", " + TfPyRepr(self[2][3]) + newline +
        TfPyRepr(self[3][0]) + ", " + TfPyRepr(self[3][1]) + ", " + TfPyRepr(self[3][2]) + ", " + TfPyRepr(self[3][3]) + ")";
}

static GfMatrix4f GetInverseWrapper( const GfMatrix4f &self ) {
    return self.GetInverse();
}

static void
throwIndexErr( const char *msg )
{
    PyErr_SetString(PyExc_IndexError, msg);
    pxr_boost::python::throw_error_already_set();
}    

static int
normalizeIndex(int index) {
    return TfPyNormalizeIndex(index, 4, true /*throw error*/);
}

// Return number of rows
static int __len__(GfMatrix4f const &self) {
    return 4;
}

static float __getitem__float(GfMatrix4f const &self, tuple index) {
    int i1=0, i2=0;
    if (len(index) == 2) {
        i1 = normalizeIndex(extract<int>(index[0]));
        i2 = normalizeIndex(extract<int>(index[1]));
    } else
        throwIndexErr("Index has incorrect size.");

    return self[i1][i2];
}

static GfVec4f __getitem__vector(GfMatrix4f const &self, int index) {
    return GfVec4f(self[normalizeIndex(index)]);
}

static void __setitem__float(GfMatrix4f &self, tuple index, float value) {
    int i1=0, i2=0;
    if (len(index) == 2) {
        i1 = normalizeIndex(extract<int>(index[0]));
        i2 = normalizeIndex(extract<int>(index[1]));
    } else
        throwIndexErr("Index has incorrect size.");

    self[i1][i2] = value;
}

static void __setitem__vector( GfMatrix4f &self, int index, GfVec4f value ) {
    int ni = normalizeIndex(index);
    self[ni][0] = value[0];
    self[ni][1] = value[1];
    self[ni][2] = value[2];
    self[ni][3] = value[3];
}

static bool __contains__float( const GfMatrix4f &self, float value ) {
    for( int i = 0; i < 4; ++i )
        for( int j = 0; j < 4; ++j )
            if( self[i][j] == value )
                return true;
    return false;
}

// Check rows against GfVec
static bool __contains__vector( const GfMatrix4f &self, GfVec4f value ) {
    for( int i = 0; i < 4; ++i )
	if( self.GetRow(i) == value )
	    return true;
    return false;
}

static GfMatrix4f __truediv__(const GfMatrix4f &self, GfMatrix4f value)
{
    return self / value;
}

static GfMatrix4f *__init__() {
    // Default constructor produces identity from python.
    return new GfMatrix4f(1);
}

static tuple FactorWithEpsilon(GfMatrix4f &self, double eps) {
    GfMatrix4f r, u, p;
    GfVec3f s, t;
    bool result = self.Factor(&r, &s, &u, &t, &p, eps);
    return pxr_boost::python::make_tuple(result, r, s, u, t, p);
}    

static tuple Factor(GfMatrix4f &self) {
    GfMatrix4f r, u, p;
    GfVec3f s, t;
    bool result = self.Factor(&r, &s, &u, &t, &p);
    return pxr_boost::python::make_tuple(result, r, s, u, t, p);
}

static GfMatrix4f RemoveScaleShearWrapper( const GfMatrix4f &self ) {
    return self.RemoveScaleShear();
}

// This adds support for python's builtin pickling library
// This is used by our Shake plugins which need to pickle entire classes
// (including code), which we don't support in pxml.
struct GfMatrix4f_Pickle_Suite : pxr_boost::python::pickle_suite
{
    static pxr_boost::python::tuple getinitargs(const GfMatrix4f &m)
    {
        return pxr_boost::python::make_tuple(
            m[0][0], m[0][1], m[0][2], m[0][3], 
            m[1][0], m[1][1], m[1][2], m[1][3], 
            m[2][0], m[2][1], m[2][2], m[2][3], 
            m[3][0], m[3][1], m[3][2], m[3][3]);
    }
};

static size_t __hash__(GfMatrix4f const &m) { return TfHash{}(m); }

static pxr_boost::python::tuple get_dimension()
{
    // At one time this was a constant static tuple we returned for
    // dimension. With boost building for python 3 that results in
    // a segfault at shutdown. Building for python 2 with a static
    // tuple returned here seems to work fine.
    //
    // It seems likely that this has to do with the order of
    // destruction of these objects when deinitializing, but we did
    // not dig deeply into this difference.
    return make_tuple(4, 4);
}

} // anonymous namespace 

void wrapMatrix4f()
{    
    typedef GfMatrix4f This;

    def("IsClose", (bool (*)(const GfMatrix4f &m1, const GfMatrix4f &m2, double))
        GfIsClose);
    
    class_<This> cls( "Matrix4f", no_init);
    cls
        .def_pickle(GfMatrix4f_Pickle_Suite())
	.def("__init__", make_constructor(__init__))
        .def(init< const GfMatrix4d & >())
        .def(init< const GfMatrix4f & >())
        .def(init< int >())
        .def(init< float >())
        .def(init<
             float, float, float, float, 
             float, float, float, float, 
             float, float, float, float, 
             float, float, float, float 
             >())
        .def(init< const GfVec4f & >())
        .def(init< const vector< vector<float> >& >())
        .def(init< const vector< vector<double> >& >())
        .def(init< const vector<float>&,
                   const vector<float>&,
                   const vector<float>&,
                   const vector<float>& >())
        .def(init< const vector<double>&,
                   const vector<double>&,
                   const vector<double>&,
                   const vector<double>& >())
        .def(init< const GfMatrix3f &, const GfVec3f >())
        .def(init< const GfRotation &, const GfVec3f >())

        .def( TfTypePythonClass() )

        .add_static_property("dimension", get_dimension)
        .def( "__len__", __len__, "Return number of rows" )

        .def( "__getitem__", __getitem__float )
        .def( "__getitem__", __getitem__vector )
        .def( "__setitem__", __setitem__float )
        .def( "__setitem__", __setitem__vector )
        .def( "__contains__", __contains__float )
        .def( "__contains__", __contains__vector, "Check rows against GfVec"  )

        .def("Set", (This &(This::*)(float, float, float, float, 
                                     float, float, float, float, 
                                     float, float, float, float, 
                                     float, float, float, float))&This::Set,
             return_self<>())
        
        .def("SetIdentity", &This::SetIdentity, return_self<>())
        .def("SetZero", &This::SetZero, return_self<>())

        .def("SetDiagonal", 
             (This & (This::*)(float))&This::SetDiagonal, 
             return_self<>())
        .def("SetDiagonal", 
             (This & (This::*)(const GfVec4f &))&This::SetDiagonal, 
             return_self<>())

        .def("SetRow", &This::SetRow)
        .def("SetColumn", &This::SetColumn)
        .def("GetRow", &This::GetRow)
        .def("GetColumn", &This::GetColumn)

        .def("GetTranspose", &This::GetTranspose)
        .def("GetInverse", GetInverseWrapper)

        .def("GetDeterminant", &This::GetDeterminant)
        .def("GetRow3", &This::GetRow3)
        .def("SetRow3", &This::SetRow3)
        .def("GetDeterminant3", &This::GetDeterminant3)
        .def("HasOrthogonalRows3", &This::HasOrthogonalRows3)

        .def("GetHandedness", &This::GetHandedness)
        .def("IsLeftHanded", &This::IsLeftHanded)
        .def("IsRightHanded", &This::IsRightHanded)

        .def("Orthonormalize", &This::Orthonormalize,
             (arg("issueWarning") = true))
        .def("GetOrthonormalized", &This::GetOrthonormalized,
             (arg("issueWarning") = true))
        
        .def( str(self) )
        .def( self == self )
        .def( self == GfMatrix4d() )
        .def( self != self )
        .def( self != GfMatrix4d() )
        .def( self *= self )
        .def( self * self )
        .def( self *= double() )
        .def( self * double() )
        .def( double() * self )
        .def( self += self )
        .def( self + self )
        .def( self -= self )
        .def( self - self )
        .def( -self )
        .def( self / self )
        .def( self * GfVec4f() )
        .def( GfVec4f() * self )

        .def("SetTransform",
	     (This & (This::*)( const GfRotation &,
				const GfVec3f & ))&This::SetTransform,
	     return_self<>())	
        .def("SetTransform",
	     (This & (This::*)( const GfMatrix3f&,
				const GfVec3f & ))&This::SetTransform,
	     return_self<>())

        .def("SetScale", (This & (This::*)( const GfVec3f& ))&This::SetScale,
	     return_self<>())

        .def("SetTranslate", &This::SetTranslate, return_self<>())
        .def("SetTranslateOnly", &This::SetTranslateOnly, return_self<>())

        .def("SetRotate",
	     (This & (This::*)( const GfQuatf & )) &This::SetRotate,
	     return_self<>())
        .def("SetRotateOnly",
	     (This & (This::*)( const GfQuatf & )) &This::SetRotateOnly,
	     return_self<>())

        .def("SetRotate",
	     (This & (This::*)( const GfRotation & )) &This::SetRotate,
	     return_self<>())
        .def("SetRotateOnly",
	     (This & (This::*)( const GfRotation & )) &This::SetRotateOnly,
	     return_self<>())

        .def("SetRotate",
	     (This & (This::*)( const GfMatrix3f& )) &This::SetRotate,
	     return_self<>())
        .def("SetRotateOnly",
	     (This & (This::*)( const GfMatrix3f& )) &This::SetRotateOnly,
	     return_self<>())

        .def("SetLookAt", (This & (This::*)( const GfVec3f &,
                                             const GfVec3f &,
                                             const GfVec3f & ))&This::SetLookAt,
	     return_self<>())

        .def("SetLookAt",
             (This & (This::*)( const GfVec3f &,
                                const GfRotation & ))&This::SetLookAt,
             return_self<>())

        .def("ExtractTranslation", &This::ExtractTranslation)
        .def("ExtractRotation", &This::ExtractRotation)
        .def("ExtractRotationMatrix", &This::ExtractRotationMatrix)
        .def("ExtractRotationQuat", &This::ExtractRotationQuat)

        .def("Factor", FactorWithEpsilon)
        .def("Factor", Factor)
        .def("RemoveScaleShear", RemoveScaleShearWrapper)
        
        .def("Transform",
	     (GfVec3f (This::*)(const GfVec3f &) const)&This::Transform)
        .def("Transform",
	     (GfVec3d (This::*)(const GfVec3d &) const)&This::Transform)

        .def("TransformDir",
	     (GfVec3f (This::*)(const GfVec3f &) const)&This::TransformDir)
        .def("TransformDir",
	     (GfVec3d (This::*)(const GfVec3d &) const)&This::TransformDir)

        .def("TransformAffine",
	     (GfVec3f (This::*)(const GfVec3f &) const)&This::TransformAffine)
        .def("TransformAffine",
	     (GfVec3d (This::*)(const GfVec3d &) const)&This::TransformAffine)
        .def("SetScale", (This & (This::*)( float ))&This::SetScale,
	     return_self<>())

        .def("__repr__", _Repr)
        .def("__hash__", __hash__)

        ;
    to_python_converter<std::vector<This>,
        TfPySequenceToPython<std::vector<This> > >();
    
    // Install buffer protocol: set the tp_as_buffer slot to point to a
    // structure of function pointers that implement the buffer protocol for
    // this type.
    auto *typeObj = reinterpret_cast<PyTypeObject *>(cls.ptr());
    typeObj->tp_as_buffer = &bufferProcs;

    if (!PyObject_HasAttrString(cls.ptr(), "__truediv__")) {
        // __truediv__ not added by .def( self / self ) above, which
        // happens when building with python 2, but we need it to support
        // "from __future__ import division"
        cls.def("__truediv__", __truediv__ );
    }
}
