/* LabelWithWidgets.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from LabelWithWidgets.vala, do not modify */

/* LabelWithWidgets is ported from Fractal*/
/* https://gitlab.gnome.org/GNOME/fractal/-/blob/3f8a7e8bd06441d83a5f052a2ae68d7d228dfcd0/src/components/label_with_widgets.rs*/
/* How to use:*/
/* Set `text` to the label's content but use the `placeholder` keyword where widgets should be placed.*/
/* Then use `set_children` with an array of Widgets in order of how they should be placed in the label.*/
/* There are some helper functions like `append_child` to add children and*/
/* `LabelWithWidgets.with_label_and_widgets` to construct it with the desired text and widgets.*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>

#define TUBA_WIDGETS_LABEL_WITH_WIDGETS_OBJECT_REPLACEMENT_CHARACTER "\xEF\xBF\xBC"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TUBA_WIDGETS_TYPE_LABEL_WITH_WIDGETS (tuba_widgets_label_with_widgets_get_type ())
#define TUBA_WIDGETS_LABEL_WITH_WIDGETS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_WIDGETS_TYPE_LABEL_WITH_WIDGETS, TubaWidgetsLabelWithWidgets))
#define TUBA_WIDGETS_LABEL_WITH_WIDGETS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_WIDGETS_TYPE_LABEL_WITH_WIDGETS, TubaWidgetsLabelWithWidgetsClass))
#define TUBA_WIDGETS_IS_LABEL_WITH_WIDGETS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_WIDGETS_TYPE_LABEL_WITH_WIDGETS))
#define TUBA_WIDGETS_IS_LABEL_WITH_WIDGETS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_WIDGETS_TYPE_LABEL_WITH_WIDGETS))
#define TUBA_WIDGETS_LABEL_WITH_WIDGETS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_WIDGETS_TYPE_LABEL_WITH_WIDGETS, TubaWidgetsLabelWithWidgetsClass))

typedef struct _TubaWidgetsLabelWithWidgets TubaWidgetsLabelWithWidgets;
typedef struct _TubaWidgetsLabelWithWidgetsClass TubaWidgetsLabelWithWidgetsClass;
typedef struct _TubaWidgetsLabelWithWidgetsPrivate TubaWidgetsLabelWithWidgetsPrivate;

#define TUBA_WIDGETS_LABEL_WITH_WIDGETS_TYPE_LWW_WIDGET (tuba_widgets_label_with_widgets_lww_widget_get_type ())
typedef struct _TubaWidgetsLabelWithWidgetsLWWWidget TubaWidgetsLabelWithWidgetsLWWWidget;
enum  {
	TUBA_WIDGETS_LABEL_WITH_WIDGETS_0_PROPERTY,
	TUBA_WIDGETS_LABEL_WITH_WIDGETS_PLACEHOLDER_PROPERTY,
	TUBA_WIDGETS_LABEL_WITH_WIDGETS_TEXT_PROPERTY,
	TUBA_WIDGETS_LABEL_WITH_WIDGETS_USE_MARKUP_PROPERTY,
	TUBA_WIDGETS_LABEL_WITH_WIDGETS_ACCESSIBLE_TEXT_PROPERTY,
	TUBA_WIDGETS_LABEL_WITH_WIDGETS_LABEL_TEXT_PROPERTY,
	TUBA_WIDGETS_LABEL_WITH_WIDGETS_SINGLE_LINE_MODE_PROPERTY,
	TUBA_WIDGETS_LABEL_WITH_WIDGETS_XALIGN_PROPERTY,
	TUBA_WIDGETS_LABEL_WITH_WIDGETS_YALIGN_PROPERTY,
	TUBA_WIDGETS_LABEL_WITH_WIDGETS_SELECTABLE_PROPERTY,
	TUBA_WIDGETS_LABEL_WITH_WIDGETS_LINES_PROPERTY,
	TUBA_WIDGETS_LABEL_WITH_WIDGETS_ELLIPSIZE_PROPERTY,
	TUBA_WIDGETS_LABEL_WITH_WIDGETS_JUSTIFY_PROPERTY,
	TUBA_WIDGETS_LABEL_WITH_WIDGETS_NUM_PROPERTIES
};
static GParamSpec* tuba_widgets_label_with_widgets_properties[TUBA_WIDGETS_LABEL_WITH_WIDGETS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _pango_attribute_destroy0(var) ((var == NULL) ? NULL : (var = (pango_attribute_destroy (var), NULL)))
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))
#define __vala_PangoLayoutRun_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoLayoutRun_free (var), NULL)))
#define __vala_PangoLayoutIter_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoLayoutIter_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
enum  {
	TUBA_WIDGETS_LABEL_WITH_WIDGETS_ACTIVATE_LINK_SIGNAL,
	TUBA_WIDGETS_LABEL_WITH_WIDGETS_NUM_SIGNALS
};
static guint tuba_widgets_label_with_widgets_signals[TUBA_WIDGETS_LABEL_WITH_WIDGETS_NUM_SIGNALS] = {0};

struct _TubaWidgetsLabelWithWidgets {
	GtkWidget parent_instance;
	TubaWidgetsLabelWithWidgetsPrivate * priv;
	GtkLabel* label;
};

struct _TubaWidgetsLabelWithWidgetsClass {
	GtkWidgetClass parent_class;
};

struct _TubaWidgetsLabelWithWidgetsLWWWidget {
	GtkWidget* widget;
	gint height;
	gint width;
};

struct _TubaWidgetsLabelWithWidgetsPrivate {
	TubaWidgetsLabelWithWidgetsLWWWidget* widgets;
	gint widgets_length1;
	gint _widgets_size_;
	gchar* _placeholder;
	gchar* _label_text;
	gchar* _text;
	gboolean _use_markup;
	gchar* _accessible_text;
	gboolean _ellipsize;
};

static gint TubaWidgetsLabelWithWidgets_private_offset;
static gpointer tuba_widgets_label_with_widgets_parent_class = NULL;
static GtkBuildableIface * tuba_widgets_label_with_widgets_gtk_buildable_parent_iface = NULL;
static GtkAccessibleInterface * tuba_widgets_label_with_widgets_gtk_accessible_parent_iface = NULL;

VALA_EXTERN GType tuba_widgets_label_with_widgets_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaWidgetsLabelWithWidgets, g_object_unref)
static GType tuba_widgets_label_with_widgets_lww_widget_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static TubaWidgetsLabelWithWidgetsLWWWidget* tuba_widgets_label_with_widgets_lww_widget_dup (const TubaWidgetsLabelWithWidgetsLWWWidget* self);
static void tuba_widgets_label_with_widgets_lww_widget_free (TubaWidgetsLabelWithWidgetsLWWWidget* self);
static void tuba_widgets_label_with_widgets_lww_widget_copy (const TubaWidgetsLabelWithWidgetsLWWWidget* self,
                                                      TubaWidgetsLabelWithWidgetsLWWWidget* dest);
static void tuba_widgets_label_with_widgets_lww_widget_destroy (TubaWidgetsLabelWithWidgetsLWWWidget* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (TubaWidgetsLabelWithWidgetsLWWWidget, tuba_widgets_label_with_widgets_lww_widget_destroy)
static void _vala_TubaWidgetsLabelWithWidgetsLWWWidget_array_free (TubaWidgetsLabelWithWidgetsLWWWidget * array,
                                                            gssize array_length);
static gboolean tuba_widgets_label_with_widgets_on_activate_link (TubaWidgetsLabelWithWidgets* self,
                                                           const gchar* url);
static void tuba_widgets_label_with_widgets_allocate_shapes (TubaWidgetsLabelWithWidgets* self);
VALA_EXTERN const gchar* tuba_widgets_label_with_widgets_get_text (TubaWidgetsLabelWithWidgets* self);
static void tuba_widgets_label_with_widgets_allocate_children (TubaWidgetsLabelWithWidgets* self);
VALA_EXTERN gboolean tuba_widgets_label_with_widgets_get_ellipsize (TubaWidgetsLabelWithWidgets* self);
static PangoLayoutRun* _vala_PangoLayoutRun_copy (PangoLayoutRun* self);
static gint tuba_widgets_label_with_widgets_pango_pixels (TubaWidgetsLabelWithWidgets* self,
                                                   gint d,
                                                   gint a);
static void _vala_PangoLayoutRun_free (PangoLayoutRun* self);
static void _vala_PangoLayoutIter_free (PangoLayoutIter* self);
static void tuba_widgets_label_with_widgets_real_size_allocate (GtkWidget* base,
                                                         gint width,
                                                         gint height,
                                                         gint baseline);
static GtkSizeRequestMode tuba_widgets_label_with_widgets_real_get_request_mode (GtkWidget* base);
static void tuba_widgets_label_with_widgets_real_measure (GtkWidget* base,
                                                   GtkOrientation orientation,
                                                   gint for_size,
                                                   gint* minimum,
                                                   gint* natural,
                                                   gint* minimum_baseline,
                                                   gint* natural_baseline);
static void tuba_widgets_label_with_widgets_update_label (TubaWidgetsLabelWithWidgets* self);
VALA_EXTERN const gchar* tuba_widgets_label_with_widgets_get_placeholder (TubaWidgetsLabelWithWidgets* self);
static void tuba_widgets_label_with_widgets_update_accessible_label (TubaWidgetsLabelWithWidgets* self);
static void tuba_widgets_label_with_widgets_invalidate_child_widgets (TubaWidgetsLabelWithWidgets* self);
static void tuba_widgets_label_with_widgets_set_accessible_text (TubaWidgetsLabelWithWidgets* self,
                                                          const gchar* value);
VALA_EXTERN const gchar* tuba_widgets_label_with_widgets_get_accessible_text (TubaWidgetsLabelWithWidgets* self);
VALA_EXTERN void tuba_widgets_label_with_widgets_append_child (TubaWidgetsLabelWithWidgets* self,
                                                   GtkWidget* child);
static void _vala_array_add109 (TubaWidgetsLabelWithWidgetsLWWWidget* * array,
                         gint* length,
                         gint* size,
                         const TubaWidgetsLabelWithWidgetsLWWWidget* value);
VALA_EXTERN TubaWidgetsLabelWithWidgets* tuba_widgets_label_with_widgets_new_with_label_and_widgets (const gchar* t_text,
                                                                                         GtkWidget** t_widgets,
                                                                                         gint t_widgets_length1);
VALA_EXTERN TubaWidgetsLabelWithWidgets* tuba_widgets_label_with_widgets_construct_with_label_and_widgets (GType object_type,
                                                                                               const gchar* t_text,
                                                                                               GtkWidget** t_widgets,
                                                                                               gint t_widgets_length1);
VALA_EXTERN void tuba_widgets_label_with_widgets_set_text (TubaWidgetsLabelWithWidgets* self,
                                               const gchar* value);
VALA_EXTERN void tuba_widgets_label_with_widgets_set_children (TubaWidgetsLabelWithWidgets* self,
                                                   GtkWidget** t_widgets,
                                                   gint t_widgets_length1);
static void tuba_widgets_label_with_widgets_real_add_child (GtkBuildable* base,
                                                     GtkBuilder* builder,
                                                     GObject* child,
                                                     const gchar* type);
VALA_EXTERN gboolean tuba_widgets_label_with_widgets_grab_focus (TubaWidgetsLabelWithWidgets* self);
VALA_EXTERN gchar* tuba_widgets_label_with_widgets_get_current_uri (TubaWidgetsLabelWithWidgets* self);
VALA_EXTERN TubaWidgetsLabelWithWidgets* tuba_widgets_label_with_widgets_new (void);
VALA_EXTERN TubaWidgetsLabelWithWidgets* tuba_widgets_label_with_widgets_construct (GType object_type);
VALA_EXTERN void tuba_widgets_label_with_widgets_set_placeholder (TubaWidgetsLabelWithWidgets* self,
                                                      const gchar* value);
VALA_EXTERN gboolean tuba_widgets_label_with_widgets_get_use_markup (TubaWidgetsLabelWithWidgets* self);
VALA_EXTERN void tuba_widgets_label_with_widgets_set_use_markup (TubaWidgetsLabelWithWidgets* self,
                                                     gboolean value);
VALA_EXTERN const gchar* tuba_widgets_label_with_widgets_get_label_text (TubaWidgetsLabelWithWidgets* self);
VALA_EXTERN gboolean tuba_widgets_label_with_widgets_get_single_line_mode (TubaWidgetsLabelWithWidgets* self);
VALA_EXTERN void tuba_widgets_label_with_widgets_set_single_line_mode (TubaWidgetsLabelWithWidgets* self,
                                                           gboolean value);
VALA_EXTERN gfloat tuba_widgets_label_with_widgets_get_xalign (TubaWidgetsLabelWithWidgets* self);
VALA_EXTERN void tuba_widgets_label_with_widgets_set_xalign (TubaWidgetsLabelWithWidgets* self,
                                                 gfloat value);
VALA_EXTERN gfloat tuba_widgets_label_with_widgets_get_yalign (TubaWidgetsLabelWithWidgets* self);
VALA_EXTERN void tuba_widgets_label_with_widgets_set_yalign (TubaWidgetsLabelWithWidgets* self,
                                                 gfloat value);
VALA_EXTERN gboolean tuba_widgets_label_with_widgets_get_selectable (TubaWidgetsLabelWithWidgets* self);
VALA_EXTERN void tuba_widgets_label_with_widgets_set_selectable (TubaWidgetsLabelWithWidgets* self,
                                                     gboolean value);
VALA_EXTERN gint tuba_widgets_label_with_widgets_get_lines (TubaWidgetsLabelWithWidgets* self);
VALA_EXTERN void tuba_widgets_label_with_widgets_set_lines (TubaWidgetsLabelWithWidgets* self,
                                                gint value);
VALA_EXTERN void tuba_widgets_label_with_widgets_set_ellipsize (TubaWidgetsLabelWithWidgets* self,
                                                    gboolean value);
VALA_EXTERN GtkJustification tuba_widgets_label_with_widgets_get_justify (TubaWidgetsLabelWithWidgets* self);
VALA_EXTERN void tuba_widgets_label_with_widgets_set_justify (TubaWidgetsLabelWithWidgets* self,
                                                  GtkJustification value);
static void g_cclosure_user_marshal_BOOLEAN__STRING (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data);
static GObject * tuba_widgets_label_with_widgets_constructor (GType type,
                                                       guint n_construct_properties,
                                                       GObjectConstructParam * construct_properties);
static gboolean _tuba_widgets_label_with_widgets_on_activate_link_gtk_label_activate_link (GtkLabel* _sender,
                                                                                    const gchar* uri,
                                                                                    gpointer self);
static void tuba_widgets_label_with_widgets_finalize (GObject * obj);
static GType tuba_widgets_label_with_widgets_get_type_once (void);
static void _vala_tuba_widgets_label_with_widgets_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec);
static void _vala_tuba_widgets_label_with_widgets_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec);

static inline gpointer
tuba_widgets_label_with_widgets_get_instance_private (TubaWidgetsLabelWithWidgets* self)
{
	return G_STRUCT_MEMBER_P (self, TubaWidgetsLabelWithWidgets_private_offset);
}

static void
_vala_TubaWidgetsLabelWithWidgetsLWWWidget_array_free (TubaWidgetsLabelWithWidgetsLWWWidget * array,
                                                       gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			tuba_widgets_label_with_widgets_lww_widget_destroy (&array[i]);
		}
	}
	g_free (array);
}

static gboolean
tuba_widgets_label_with_widgets_on_activate_link (TubaWidgetsLabelWithWidgets* self,
                                                  const gchar* url)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (url != NULL, FALSE);
	g_signal_emit (self, tuba_widgets_label_with_widgets_signals[TUBA_WIDGETS_LABEL_WITH_WIDGETS_ACTIVATE_LINK_SIGNAL], 0, url, &_tmp0_);
	result = _tmp0_;
	return result;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static void
tuba_widgets_label_with_widgets_allocate_shapes (TubaWidgetsLabelWithWidgets* self)
{
	gboolean child_size_changed = FALSE;
	gboolean _tmp0_ = FALSE;
	TubaWidgetsLabelWithWidgetsLWWWidget* _tmp1_;
	gint _tmp1__length1;
	PangoAttrList* attrs = NULL;
	PangoAttrList* _tmp25_;
	gint index = 0;
	GtkLabel* _tmp51_;
	PangoAttrList* _tmp52_;
	g_return_if_fail (self != NULL);
	child_size_changed = FALSE;
	_tmp1_ = self->priv->widgets;
	_tmp1__length1 = self->priv->widgets_length1;
	if (_tmp1__length1 == 0) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = tuba_widgets_label_with_widgets_get_text (self);
		_tmp3_ = _tmp2_;
		_tmp0_ = g_strcmp0 (_tmp3_, "") == 0;
	}
	if (_tmp0_) {
		GtkLabel* _tmp4_;
		_tmp4_ = self->label;
		gtk_label_set_attributes (_tmp4_, NULL);
		return;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				TubaWidgetsLabelWithWidgetsLWWWidget* _tmp7_;
				gint _tmp7__length1;
				GtkRequisition size = {0};
				GtkRequisition natural_size = {0};
				TubaWidgetsLabelWithWidgetsLWWWidget* _tmp8_;
				gint _tmp8__length1;
				TubaWidgetsLabelWithWidgetsLWWWidget _tmp9_;
				GtkWidget* _tmp10_;
				GtkRequisition _tmp11_ = {0};
				GtkRequisition _tmp12_ = {0};
				gint width = 0;
				GtkRequisition _tmp13_;
				gint height = 0;
				GtkRequisition _tmp14_;
				gint old_width = 0;
				TubaWidgetsLabelWithWidgetsLWWWidget* _tmp15_;
				gint _tmp15__length1;
				TubaWidgetsLabelWithWidgetsLWWWidget _tmp16_;
				gint old_height = 0;
				TubaWidgetsLabelWithWidgetsLWWWidget* _tmp17_;
				gint _tmp17__length1;
				TubaWidgetsLabelWithWidgetsLWWWidget _tmp18_;
				gboolean _tmp19_ = FALSE;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = self->priv->widgets;
				_tmp7__length1 = self->priv->widgets_length1;
				if (!(i < _tmp7__length1)) {
					break;
				}
				_tmp8_ = self->priv->widgets;
				_tmp8__length1 = self->priv->widgets_length1;
				_tmp9_ = _tmp8_[i];
				_tmp10_ = _tmp9_.widget;
				gtk_widget_get_preferred_size (_tmp10_, &_tmp11_, &_tmp12_);
				size = _tmp11_;
				natural_size = _tmp12_;
				_tmp13_ = natural_size;
				width = _tmp13_.width;
				_tmp14_ = natural_size;
				height = _tmp14_.height;
				_tmp15_ = self->priv->widgets;
				_tmp15__length1 = self->priv->widgets_length1;
				_tmp16_ = _tmp15_[i];
				old_width = _tmp16_.width;
				_tmp17_ = self->priv->widgets;
				_tmp17__length1 = self->priv->widgets_length1;
				_tmp18_ = _tmp17_[i];
				old_height = _tmp18_.height;
				if (old_width > 0) {
					_tmp19_ = TRUE;
				} else {
					_tmp19_ = old_height > 0;
				}
				if (_tmp19_) {
					gboolean _tmp20_ = FALSE;
					if (old_width != width) {
						_tmp20_ = TRUE;
					} else {
						_tmp20_ = old_height != height;
					}
					if (_tmp20_) {
						TubaWidgetsLabelWithWidgetsLWWWidget* _tmp21_;
						gint _tmp21__length1;
						TubaWidgetsLabelWithWidgetsLWWWidget* _tmp22_;
						gint _tmp22__length1;
						_tmp21_ = self->priv->widgets;
						_tmp21__length1 = self->priv->widgets_length1;
						_tmp21_[i].width = width;
						_tmp22_ = self->priv->widgets;
						_tmp22__length1 = self->priv->widgets_length1;
						_tmp22_[i].height = height;
						child_size_changed = TRUE;
					}
				} else {
					TubaWidgetsLabelWithWidgetsLWWWidget* _tmp23_;
					gint _tmp23__length1;
					TubaWidgetsLabelWithWidgetsLWWWidget* _tmp24_;
					gint _tmp24__length1;
					_tmp23_ = self->priv->widgets;
					_tmp23__length1 = self->priv->widgets_length1;
					_tmp23_[i].width = width;
					_tmp24_ = self->priv->widgets;
					_tmp24__length1 = self->priv->widgets_length1;
					_tmp24_[i].height = height;
					child_size_changed = TRUE;
				}
			}
		}
	}
	if (!child_size_changed) {
		return;
	}
	_tmp25_ = pango_attr_list_new ();
	attrs = _tmp25_;
	index = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp26_ = FALSE;
			_tmp26_ = TRUE;
			while (TRUE) {
				TubaWidgetsLabelWithWidgetsLWWWidget* _tmp28_;
				gint _tmp28__length1;
				const gchar* _tmp29_;
				PangoRectangle logical_rect = {0};
				TubaWidgetsLabelWithWidgetsLWWWidget* _tmp30_;
				gint _tmp30__length1;
				TubaWidgetsLabelWithWidgetsLWWWidget _tmp31_;
				TubaWidgetsLabelWithWidgetsLWWWidget* _tmp32_;
				gint _tmp32__length1;
				TubaWidgetsLabelWithWidgetsLWWWidget _tmp33_;
				TubaWidgetsLabelWithWidgetsLWWWidget* _tmp34_;
				gint _tmp34__length1;
				TubaWidgetsLabelWithWidgetsLWWWidget _tmp35_;
				TubaWidgetsLabelWithWidgetsLWWWidget* _tmp36_;
				gint _tmp36__length1;
				TubaWidgetsLabelWithWidgetsLWWWidget _tmp37_;
				PangoRectangle _tmp38_ = {0};
				PangoAttribute* shape = NULL;
				PangoRectangle _tmp39_;
				PangoRectangle _tmp40_;
				PangoAttribute* _tmp41_;
				PangoAttribute* _tmp42_;
				PangoAttribute* _tmp43_;
				gint _tmp44_;
				gint _tmp45_;
				PangoAttrList* _tmp46_;
				PangoAttribute* _tmp47_;
				PangoAttribute* _tmp48_;
				gint _tmp49_;
				gint _tmp50_;
				if (!_tmp26_) {
					gint _tmp27_;
					_tmp27_ = i;
					i = _tmp27_ + 1;
				}
				_tmp26_ = FALSE;
				_tmp28_ = self->priv->widgets;
				_tmp28__length1 = self->priv->widgets_length1;
				if (!(i < _tmp28__length1)) {
					break;
				}
				_tmp29_ = self->priv->_label_text;
				index = string_index_of (_tmp29_, TUBA_WIDGETS_LABEL_WITH_WIDGETS_OBJECT_REPLACEMENT_CHARACTER, index);
				if (index < 0) {
					break;
				}
				_tmp30_ = self->priv->widgets;
				_tmp30__length1 = self->priv->widgets_length1;
				_tmp31_ = _tmp30_[i];
				_tmp32_ = self->priv->widgets;
				_tmp32__length1 = self->priv->widgets_length1;
				_tmp33_ = _tmp32_[i];
				_tmp34_ = self->priv->widgets;
				_tmp34__length1 = self->priv->widgets_length1;
				_tmp35_ = _tmp34_[i];
				_tmp36_ = self->priv->widgets;
				_tmp36__length1 = self->priv->widgets_length1;
				_tmp37_ = _tmp36_[i];
				memset (&_tmp38_, 0, sizeof (PangoRectangle));
				_tmp38_.x = 0;
				_tmp38_.y = (-(_tmp31_.height - (_tmp33_.height / 4))) * PANGO_SCALE;
				_tmp38_.width = _tmp35_.width * PANGO_SCALE;
				_tmp38_.height = _tmp37_.height * PANGO_SCALE;
				logical_rect = _tmp38_;
				_tmp39_ = logical_rect;
				_tmp40_ = logical_rect;
				_tmp41_ = pango_attr_shape_new (&_tmp39_, &_tmp40_);
				shape = _tmp41_;
				_tmp42_ = shape;
				_tmp42_->start_index = (guint) index;
				_tmp43_ = shape;
				_tmp44_ = strlen (TUBA_WIDGETS_LABEL_WITH_WIDGETS_OBJECT_REPLACEMENT_CHARACTER);
				_tmp45_ = _tmp44_;
				_tmp43_->end_index = (guint) (index + _tmp45_);
				_tmp46_ = attrs;
				_tmp47_ = shape;
				_tmp48_ = pango_attribute_copy (_tmp47_);
				pango_attr_list_insert (_tmp46_, _tmp48_);
				_tmp49_ = strlen (TUBA_WIDGETS_LABEL_WITH_WIDGETS_OBJECT_REPLACEMENT_CHARACTER);
				_tmp50_ = _tmp49_;
				index = index + _tmp50_;
				_pango_attribute_destroy0 (shape);
			}
		}
	}
	_tmp51_ = self->label;
	_tmp52_ = attrs;
	gtk_label_set_attributes (_tmp51_, _tmp52_);
	_pango_attr_list_unref0 (attrs);
}

static PangoLayoutRun*
_vala_PangoLayoutRun_copy (PangoLayoutRun* self)
{
	return g_boxed_copy (pango_glyph_item_get_type (), self);
}

static gpointer
__vala_PangoLayoutRun_copy0 (gpointer self)
{
	return self ? _vala_PangoLayoutRun_copy (self) : NULL;
}

static void
_vala_PangoLayoutRun_free (PangoLayoutRun* self)
{
	g_boxed_free (pango_glyph_item_get_type (), self);
}

static void
_vala_PangoLayoutIter_free (PangoLayoutIter* self)
{
	g_boxed_free (pango_layout_iter_get_type (), self);
}

static void
tuba_widgets_label_with_widgets_allocate_children (TubaWidgetsLabelWithWidgets* self)
{
	TubaWidgetsLabelWithWidgetsLWWWidget* _tmp0_;
	gint _tmp0__length1;
	PangoLayoutIter* run_iter = NULL;
	GtkLabel* _tmp1_;
	PangoLayout* _tmp2_;
	PangoLayoutIter* _tmp3_;
	gint i = 0;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->widgets;
	_tmp0__length1 = self->priv->widgets_length1;
	if (_tmp0__length1 == 0) {
		return;
	}
	_tmp1_ = self->label;
	_tmp2_ = gtk_label_get_layout (_tmp1_);
	_tmp3_ = pango_layout_get_iter (_tmp2_);
	run_iter = _tmp3_;
	i = 0;
	_tmp4_ = tuba_widgets_label_with_widgets_get_ellipsize (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		TubaWidgetsLabelWithWidgetsLWWWidget* _tmp6_;
		gint _tmp6__length1;
		_tmp6_ = self->priv->widgets;
		_tmp6__length1 = self->priv->widgets_length1;
		{
			TubaWidgetsLabelWithWidgetsLWWWidget* child_collection = NULL;
			gint child_collection_length1 = 0;
			gint _child_collection_size_ = 0;
			gint child_it = 0;
			child_collection = _tmp6_;
			child_collection_length1 = _tmp6__length1;
			for (child_it = 0; child_it < child_collection_length1; child_it = child_it + 1) {
				TubaWidgetsLabelWithWidgetsLWWWidget _tmp7_;
				TubaWidgetsLabelWithWidgetsLWWWidget _tmp8_ = {0};
				TubaWidgetsLabelWithWidgetsLWWWidget child = {0};
				_tmp7_ = child_collection[child_it];
				tuba_widgets_label_with_widgets_lww_widget_copy (&_tmp7_, &_tmp8_);
				child = _tmp8_;
				{
					TubaWidgetsLabelWithWidgetsLWWWidget _tmp9_;
					GtkWidget* _tmp10_;
					_tmp9_ = child;
					_tmp10_ = _tmp9_.widget;
					gtk_widget_set_visible (_tmp10_, FALSE);
					tuba_widgets_label_with_widgets_lww_widget_destroy (&child);
				}
			}
		}
	}
	while (TRUE) {
		PangoLayoutRun* run = NULL;
		PangoLayoutIter* _tmp11_;
		PangoLayoutRun* _tmp12_;
		PangoLayoutRun* _tmp13_;
		PangoLayoutRun* _tmp14_;
		PangoLayoutIter* _tmp48_;
		_tmp11_ = run_iter;
		_tmp12_ = pango_layout_iter_get_run_readonly (_tmp11_);
		_tmp13_ = __vala_PangoLayoutRun_copy0 (_tmp12_);
		run = _tmp13_;
		_tmp14_ = run;
		if (_tmp14_ != NULL) {
			GSList* extra_attrs = NULL;
			PangoLayoutRun* _tmp15_;
			PangoItem* _tmp16_;
			PangoAnalysis _tmp17_;
			GSList* _tmp18_;
			GSList* _tmp19_;
			gboolean has_shape_attr = FALSE;
			GSList* _tmp20_;
			_tmp15_ = run;
			_tmp16_ = ((PangoGlyphItem*) _tmp15_)->item;
			_tmp17_ = _tmp16_->analysis;
			_tmp18_ = _tmp17_.extra_attrs;
			_tmp19_ = g_slist_copy (_tmp18_);
			extra_attrs = _tmp19_;
			has_shape_attr = FALSE;
			_tmp20_ = extra_attrs;
			{
				GSList* attr_collection = NULL;
				GSList* attr_it = NULL;
				attr_collection = _tmp20_;
				for (attr_it = attr_collection; attr_it != NULL; attr_it = attr_it->next) {
					void* attr = NULL;
					attr = attr_it->data;
					{
						void* _tmp21_;
						PangoAttrShape* _tmp22_;
						_tmp21_ = attr;
						_tmp22_ = pango_attribute_as_shape ((PangoAttribute*) _tmp21_);
						if (_tmp22_ != NULL) {
							has_shape_attr = TRUE;
							break;
						}
					}
				}
			}
			if (has_shape_attr) {
				TubaWidgetsLabelWithWidgetsLWWWidget* _tmp23_;
				gint _tmp23__length1;
				_tmp23_ = self->priv->widgets;
				_tmp23__length1 = self->priv->widgets_length1;
				if (i < _tmp23__length1) {
					PangoRectangle logical_rect = {0};
					PangoLayoutIter* _tmp24_;
					PangoRectangle _tmp25_ = {0};
					PangoRectangle _tmp26_;
					PangoRectangle _tmp27_;
					gint offset_x = 0;
					gint offset_y = 0;
					GtkLabel* _tmp28_;
					gint _tmp29_ = 0;
					gint _tmp30_ = 0;
					GtkAllocation allocation = {0};
					PangoRectangle _tmp31_;
					PangoRectangle _tmp32_;
					TubaWidgetsLabelWithWidgetsLWWWidget* _tmp33_;
					gint _tmp33__length1;
					TubaWidgetsLabelWithWidgetsLWWWidget _tmp34_;
					TubaWidgetsLabelWithWidgetsLWWWidget* _tmp35_;
					gint _tmp35__length1;
					TubaWidgetsLabelWithWidgetsLWWWidget _tmp36_;
					GtkAllocation _tmp37_ = {0};
					gboolean _tmp38_;
					gboolean _tmp39_;
					TubaWidgetsLabelWithWidgetsLWWWidget* _tmp43_;
					gint _tmp43__length1;
					TubaWidgetsLabelWithWidgetsLWWWidget _tmp44_;
					GtkWidget* _tmp45_;
					GtkAllocation _tmp46_;
					gint _tmp47_;
					_tmp24_ = run_iter;
					pango_layout_iter_get_run_extents (_tmp24_, NULL, &_tmp25_);
					logical_rect = _tmp25_;
					_tmp26_ = logical_rect;
					logical_rect.x = tuba_widgets_label_with_widgets_pango_pixels (self, _tmp26_.x, 0);
					_tmp27_ = logical_rect;
					logical_rect.y = tuba_widgets_label_with_widgets_pango_pixels (self, _tmp27_.y, 0);
					_tmp28_ = self->label;
					gtk_label_get_layout_offsets (_tmp28_, &_tmp29_, &_tmp30_);
					offset_x = _tmp29_;
					offset_y = _tmp30_;
					_tmp31_ = logical_rect;
					_tmp32_ = logical_rect;
					_tmp33_ = self->priv->widgets;
					_tmp33__length1 = self->priv->widgets_length1;
					_tmp34_ = _tmp33_[i];
					_tmp35_ = self->priv->widgets;
					_tmp35__length1 = self->priv->widgets_length1;
					_tmp36_ = _tmp35_[i];
					memset (&_tmp37_, 0, sizeof (GtkAllocation));
					_tmp37_.x = _tmp31_.x + offset_x;
					_tmp37_.y = _tmp32_.y + offset_y;
					_tmp37_.height = _tmp34_.height;
					_tmp37_.width = _tmp36_.width;
					allocation = _tmp37_;
					_tmp38_ = tuba_widgets_label_with_widgets_get_ellipsize (self);
					_tmp39_ = _tmp38_;
					if (_tmp39_) {
						TubaWidgetsLabelWithWidgetsLWWWidget* _tmp40_;
						gint _tmp40__length1;
						TubaWidgetsLabelWithWidgetsLWWWidget _tmp41_;
						GtkWidget* _tmp42_;
						_tmp40_ = self->priv->widgets;
						_tmp40__length1 = self->priv->widgets_length1;
						_tmp41_ = _tmp40_[i];
						_tmp42_ = _tmp41_.widget;
						gtk_widget_set_visible (_tmp42_, TRUE);
					}
					_tmp43_ = self->priv->widgets;
					_tmp43__length1 = self->priv->widgets_length1;
					_tmp44_ = _tmp43_[i];
					_tmp45_ = _tmp44_.widget;
					_tmp46_ = allocation;
					gtk_widget_size_allocate (_tmp45_, &_tmp46_, -1);
					_tmp47_ = i;
					i = _tmp47_ + 1;
				} else {
					(extra_attrs == NULL) ? NULL : (extra_attrs = (g_slist_free (extra_attrs), NULL));
					__vala_PangoLayoutRun_free0 (run);
					break;
				}
			}
			(extra_attrs == NULL) ? NULL : (extra_attrs = (g_slist_free (extra_attrs), NULL));
		}
		_tmp48_ = run_iter;
		if (!pango_layout_iter_next_run (_tmp48_)) {
			__vala_PangoLayoutRun_free0 (run);
			break;
		}
		__vala_PangoLayoutRun_free0 (run);
	}
	__vala_PangoLayoutIter_free0 (run_iter);
}

static void
tuba_widgets_label_with_widgets_real_size_allocate (GtkWidget* base,
                                                    gint width,
                                                    gint height,
                                                    gint baseline)
{
	TubaWidgetsLabelWithWidgets * self;
	GtkLabel* _tmp0_;
	self = (TubaWidgetsLabelWithWidgets*) base;
	_tmp0_ = self->label;
	gtk_widget_allocate ((GtkWidget*) _tmp0_, width, height, baseline, NULL);
	tuba_widgets_label_with_widgets_allocate_children (self);
}

static GtkSizeRequestMode
tuba_widgets_label_with_widgets_real_get_request_mode (GtkWidget* base)
{
	TubaWidgetsLabelWithWidgets * self;
	GtkLabel* _tmp0_;
	GtkSizeRequestMode result;
	self = (TubaWidgetsLabelWithWidgets*) base;
	_tmp0_ = self->label;
	result = gtk_widget_get_request_mode ((GtkWidget*) _tmp0_);
	return result;
}

static void
tuba_widgets_label_with_widgets_real_measure (GtkWidget* base,
                                              GtkOrientation orientation,
                                              gint for_size,
                                              gint* minimum,
                                              gint* natural,
                                              gint* minimum_baseline,
                                              gint* natural_baseline)
{
	TubaWidgetsLabelWithWidgets * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	gint _vala_minimum_baseline = 0;
	gint _vala_natural_baseline = 0;
	GtkLabel* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	self = (TubaWidgetsLabelWithWidgets*) base;
	tuba_widgets_label_with_widgets_allocate_shapes (self);
	_tmp0_ = self->label;
	gtk_widget_measure ((GtkWidget*) _tmp0_, orientation, for_size, &_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_);
	_vala_minimum = _tmp1_;
	_vala_natural = _tmp2_;
	_vala_minimum_baseline = _tmp3_;
	_vala_natural_baseline = _tmp4_;
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
	if (minimum_baseline) {
		*minimum_baseline = _vala_minimum_baseline;
	}
	if (natural_baseline) {
		*natural_baseline = _vala_natural_baseline;
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
tuba_widgets_label_with_widgets_update_label (TubaWidgetsLabelWithWidgets* self)
{
	gchar* old_label = NULL;
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* new_label = NULL;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->label;
	_tmp1_ = gtk_label_get_label (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	old_label = _tmp3_;
	_tmp4_ = self->priv->_text;
	_tmp5_ = tuba_widgets_label_with_widgets_get_placeholder (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = string_replace (_tmp4_, _tmp6_, TUBA_WIDGETS_LABEL_WITH_WIDGETS_OBJECT_REPLACEMENT_CHARACTER);
	new_label = _tmp7_;
	_tmp8_ = old_label;
	_tmp9_ = new_label;
	if (g_strcmp0 (_tmp8_, _tmp9_) != 0) {
		const gchar* _tmp10_;
		gchar* _tmp11_;
		GtkLabel* _tmp12_;
		const gchar* _tmp13_;
		GtkLabel* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp10_ = new_label;
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (self->priv->_text);
		self->priv->_text = _tmp11_;
		_tmp12_ = self->label;
		_tmp13_ = self->priv->_text;
		gtk_label_set_label (_tmp12_, _tmp13_);
		_tmp14_ = self->label;
		_tmp15_ = gtk_label_get_text (_tmp14_);
		_tmp16_ = g_strdup (_tmp15_);
		_g_free0 (self->priv->_label_text);
		self->priv->_label_text = _tmp16_;
		tuba_widgets_label_with_widgets_update_accessible_label (self);
		tuba_widgets_label_with_widgets_invalidate_child_widgets (self);
	}
	_g_free0 (new_label);
	_g_free0 (old_label);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gchar*
string_splice (const gchar* self,
               glong start,
               glong end,
               const gchar* str)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gsize str_size = 0UL;
	const gchar* _result_ = NULL;
	void* _tmp6_;
	gchar* dest = NULL;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	if (str == NULL) {
		str_size = (gsize) 0;
	} else {
		gint _tmp4_;
		gint _tmp5_;
		_tmp4_ = strlen ((const gchar*) str);
		_tmp5_ = _tmp4_;
		str_size = (gsize) _tmp5_;
	}
	_tmp6_ = g_malloc0 (((string_length - (end - start)) + str_size) + 1);
	_result_ = _tmp6_;
	_tmp7_ = _result_;
	dest = (gchar*) _tmp7_;
	_tmp8_ = dest;
	memcpy (_tmp8_, self, (gsize) start);
	_tmp9_ = dest;
	dest = _tmp9_ + start;
	if (str != NULL) {
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = dest;
		memcpy (_tmp10_, str, str_size);
		_tmp11_ = dest;
		dest = _tmp11_ + str_size;
	}
	_tmp12_ = dest;
	memcpy (_tmp12_, ((gchar*) self) + end, (gsize) (string_length - end));
	_tmp13_ = _result_;
	_result_ = NULL;
	result = (gchar*) _tmp13_;
	return result;
}

static void
tuba_widgets_label_with_widgets_update_accessible_label (TubaWidgetsLabelWithWidgets* self)
{
	const gchar* _tmp0_;
	gint index_of_obj = 0;
	const gchar* _tmp24_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_label_text;
	tuba_widgets_label_with_widgets_set_accessible_text (self, _tmp0_);
	index_of_obj = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				TubaWidgetsLabelWithWidgetsLWWWidget* _tmp3_;
				gint _tmp3__length1;
				const gchar* _tmp4_;
				gint original_index_of_obj = 0;
				gint _tmp5_;
				gint _tmp6_;
				GtkWidget* child_widget = NULL;
				TubaWidgetsLabelWithWidgetsLWWWidget* _tmp7_;
				gint _tmp7__length1;
				TubaWidgetsLabelWithWidgetsLWWWidget _tmp8_;
				GtkWidget* _tmp9_;
				GtkWidget* _tmp10_;
				gboolean _tmp11_ = FALSE;
				GtkWidget* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				const gchar* _tmp18_;
				GtkWidget* _tmp19_;
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = self->priv->widgets;
				_tmp3__length1 = self->priv->widgets_length1;
				if (!(i < _tmp3__length1)) {
					break;
				}
				_tmp4_ = self->priv->_accessible_text;
				index_of_obj = string_index_of (_tmp4_, TUBA_WIDGETS_LABEL_WITH_WIDGETS_OBJECT_REPLACEMENT_CHARACTER, index_of_obj);
				if (index_of_obj == -1) {
					break;
				}
				original_index_of_obj = index_of_obj;
				_tmp5_ = strlen (TUBA_WIDGETS_LABEL_WITH_WIDGETS_OBJECT_REPLACEMENT_CHARACTER);
				_tmp6_ = _tmp5_;
				index_of_obj += _tmp6_;
				_tmp7_ = self->priv->widgets;
				_tmp7__length1 = self->priv->widgets_length1;
				_tmp8_ = _tmp7_[i];
				_tmp9_ = _tmp8_.widget;
				_tmp10_ = _g_object_ref0 (_tmp9_);
				child_widget = _tmp10_;
				_tmp12_ = child_widget;
				_tmp13_ = gtk_widget_get_tooltip_text (_tmp12_);
				_tmp14_ = _tmp13_;
				if (_tmp14_ == NULL) {
					_tmp11_ = TRUE;
				} else {
					GtkWidget* _tmp15_;
					const gchar* _tmp16_;
					const gchar* _tmp17_;
					_tmp15_ = child_widget;
					_tmp16_ = gtk_widget_get_tooltip_text (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp11_ = g_strcmp0 (_tmp17_, "") == 0;
				}
				if (_tmp11_) {
					_g_object_unref0 (child_widget);
					continue;
				}
				_tmp18_ = self->priv->_accessible_text;
				_tmp19_ = child_widget;
				_tmp20_ = gtk_widget_get_tooltip_text (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = string_splice (_tmp18_, (glong) original_index_of_obj, (glong) index_of_obj, _tmp21_);
				_tmp23_ = _tmp22_;
				tuba_widgets_label_with_widgets_set_accessible_text (self, _tmp23_);
				_g_free0 (_tmp23_);
				_g_object_unref0 (child_widget);
			}
		}
	}
	_tmp24_ = self->priv->_accessible_text;
	gtk_accessible_update_property ((GtkAccessible*) self, GTK_ACCESSIBLE_PROPERTY_LABEL, _tmp24_, -1, -1);
}

static void
_vala_array_add109 (TubaWidgetsLabelWithWidgetsLWWWidget* * array,
                    gint* length,
                    gint* size,
                    const TubaWidgetsLabelWithWidgetsLWWWidget* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TubaWidgetsLabelWithWidgetsLWWWidget, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

void
tuba_widgets_label_with_widgets_append_child (TubaWidgetsLabelWithWidgets* self,
                                              GtkWidget* child)
{
	GtkWidget* _tmp0_;
	TubaWidgetsLabelWithWidgetsLWWWidget _tmp1_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (child != NULL);
	_tmp0_ = _g_object_ref0 (child);
	memset (&_tmp1_, 0, sizeof (TubaWidgetsLabelWithWidgetsLWWWidget));
	_g_object_unref0 (_tmp1_.widget);
	_tmp1_.widget = _tmp0_;
	_tmp1_.width = 0;
	_tmp1_.height = 0;
	_vala_array_add109 (&self->priv->widgets, &self->priv->widgets_length1, &self->priv->_widgets_size_, &_tmp1_);
	gtk_widget_set_parent (child, (GtkWidget*) self);
	tuba_widgets_label_with_widgets_invalidate_child_widgets (self);
}

TubaWidgetsLabelWithWidgets*
tuba_widgets_label_with_widgets_construct_with_label_and_widgets (GType object_type,
                                                                  const gchar* t_text,
                                                                  GtkWidget** t_widgets,
                                                                  gint t_widgets_length1)
{
	TubaWidgetsLabelWithWidgets * self = NULL;
	g_return_val_if_fail (t_text != NULL, NULL);
	self = (TubaWidgetsLabelWithWidgets*) g_object_new (object_type, NULL);
	{
		GtkWidget** widget_collection = NULL;
		gint widget_collection_length1 = 0;
		gint _widget_collection_size_ = 0;
		gint widget_it = 0;
		widget_collection = t_widgets;
		widget_collection_length1 = t_widgets_length1;
		for (widget_it = 0; widget_it < widget_collection_length1; widget_it = widget_it + 1) {
			GtkWidget* widget = NULL;
			widget = widget_collection[widget_it];
			{
				GtkWidget* _tmp0_;
				_tmp0_ = widget;
				tuba_widgets_label_with_widgets_append_child (self, _tmp0_);
			}
		}
	}
	tuba_widgets_label_with_widgets_set_text (self, t_text);
	return self;
}

TubaWidgetsLabelWithWidgets*
tuba_widgets_label_with_widgets_new_with_label_and_widgets (const gchar* t_text,
                                                            GtkWidget** t_widgets,
                                                            gint t_widgets_length1)
{
	return tuba_widgets_label_with_widgets_construct_with_label_and_widgets (TUBA_WIDGETS_TYPE_LABEL_WITH_WIDGETS, t_text, t_widgets, t_widgets_length1);
}

void
tuba_widgets_label_with_widgets_set_children (TubaWidgetsLabelWithWidgets* self,
                                              GtkWidget** t_widgets,
                                              gint t_widgets_length1)
{
	TubaWidgetsLabelWithWidgetsLWWWidget* _tmp0_;
	gint _tmp0__length1;
	TubaWidgetsLabelWithWidgetsLWWWidget* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->widgets;
	_tmp0__length1 = self->priv->widgets_length1;
	{
		TubaWidgetsLabelWithWidgetsLWWWidget* child_collection = NULL;
		gint child_collection_length1 = 0;
		gint _child_collection_size_ = 0;
		gint child_it = 0;
		child_collection = _tmp0_;
		child_collection_length1 = _tmp0__length1;
		for (child_it = 0; child_it < child_collection_length1; child_it = child_it + 1) {
			TubaWidgetsLabelWithWidgetsLWWWidget _tmp1_;
			TubaWidgetsLabelWithWidgetsLWWWidget _tmp2_ = {0};
			TubaWidgetsLabelWithWidgetsLWWWidget child = {0};
			_tmp1_ = child_collection[child_it];
			tuba_widgets_label_with_widgets_lww_widget_copy (&_tmp1_, &_tmp2_);
			child = _tmp2_;
			{
				TubaWidgetsLabelWithWidgetsLWWWidget _tmp3_;
				GtkWidget* _tmp4_;
				TubaWidgetsLabelWithWidgetsLWWWidget _tmp5_;
				GtkWidget* _tmp6_;
				_tmp3_ = child;
				_tmp4_ = _tmp3_.widget;
				gtk_widget_unparent (_tmp4_);
				_tmp5_ = child;
				_tmp6_ = _tmp5_.widget;
				g_signal_emit_by_name (_tmp6_, "destroy");
				tuba_widgets_label_with_widgets_lww_widget_destroy (&child);
			}
		}
	}
	_tmp7_ = g_new0 (TubaWidgetsLabelWithWidgetsLWWWidget, 0);
	self->priv->widgets = (_vala_TubaWidgetsLabelWithWidgetsLWWWidget_array_free (self->priv->widgets, self->priv->widgets_length1), NULL);
	self->priv->widgets = _tmp7_;
	self->priv->widgets_length1 = 0;
	self->priv->_widgets_size_ = self->priv->widgets_length1;
	{
		GtkWidget** widget_collection = NULL;
		gint widget_collection_length1 = 0;
		gint _widget_collection_size_ = 0;
		gint widget_it = 0;
		widget_collection = t_widgets;
		widget_collection_length1 = t_widgets_length1;
		for (widget_it = 0; widget_it < widget_collection_length1; widget_it = widget_it + 1) {
			GtkWidget* widget = NULL;
			widget = widget_collection[widget_it];
			{
				GtkWidget* _tmp8_;
				_tmp8_ = widget;
				tuba_widgets_label_with_widgets_append_child (self, _tmp8_);
			}
		}
	}
}

static void
tuba_widgets_label_with_widgets_invalidate_child_widgets (TubaWidgetsLabelWithWidgets* self)
{
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				TubaWidgetsLabelWithWidgetsLWWWidget* _tmp2_;
				gint _tmp2__length1;
				TubaWidgetsLabelWithWidgetsLWWWidget* _tmp3_;
				gint _tmp3__length1;
				TubaWidgetsLabelWithWidgetsLWWWidget* _tmp4_;
				gint _tmp4__length1;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->widgets;
				_tmp2__length1 = self->priv->widgets_length1;
				if (!(i < _tmp2__length1)) {
					break;
				}
				_tmp3_ = self->priv->widgets;
				_tmp3__length1 = self->priv->widgets_length1;
				_tmp3_[i].width = 0;
				_tmp4_ = self->priv->widgets;
				_tmp4__length1 = self->priv->widgets_length1;
				_tmp4_[i].height = 0;
			}
		}
	}
	tuba_widgets_label_with_widgets_allocate_shapes (self);
	gtk_widget_queue_resize ((GtkWidget*) self);
}

static gint
tuba_widgets_label_with_widgets_pango_pixels (TubaWidgetsLabelWithWidgets* self,
                                              gint d,
                                              gint a)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (d + a) >> 10;
	return result;
}

static void
tuba_widgets_label_with_widgets_real_add_child (GtkBuildable* base,
                                                GtkBuilder* builder,
                                                GObject* child,
                                                const gchar* type)
{
	TubaWidgetsLabelWithWidgets * self;
	GtkWidget* widget = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	self = (TubaWidgetsLabelWithWidgets*) base;
	g_return_if_fail (builder != NULL);
	g_return_if_fail (child != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (child, gtk_widget_get_type ()) ? ((GtkWidget*) child) : NULL);
	widget = _tmp0_;
	_tmp1_ = widget;
	if (_tmp1_ != NULL) {
		GtkWidget* _tmp2_;
		_tmp2_ = widget;
		tuba_widgets_label_with_widgets_append_child (self, _tmp2_);
	} else {
		GtkWidget* _tmp3_;
		GtkWidget* _tmp4_;
		_tmp3_ = gtk_widget_get_parent ((GtkWidget*) self);
		_tmp4_ = _tmp3_;
		G_TYPE_INSTANCE_GET_INTERFACE ((GtkBuildable*) _tmp4_, gtk_buildable_get_type (), GtkBuildableIface)->add_child ((GtkBuildable*) _tmp4_, builder, child, type);
	}
	tuba_widgets_label_with_widgets_gtk_buildable_parent_iface->add_child ((GtkBuildable*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), builder, child, type);
	_g_object_unref0 (widget);
}

gboolean
tuba_widgets_label_with_widgets_grab_focus (TubaWidgetsLabelWithWidgets* self)
{
	GtkLabel* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->label;
	result = gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
	return result;
}

gchar*
tuba_widgets_label_with_widgets_get_current_uri (TubaWidgetsLabelWithWidgets* self)
{
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->label;
	_tmp1_ = gtk_label_get_current_uri (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

TubaWidgetsLabelWithWidgets*
tuba_widgets_label_with_widgets_construct (GType object_type)
{
	TubaWidgetsLabelWithWidgets * self = NULL;
	self = (TubaWidgetsLabelWithWidgets*) g_object_new (object_type, NULL);
	return self;
}

TubaWidgetsLabelWithWidgets*
tuba_widgets_label_with_widgets_new (void)
{
	return tuba_widgets_label_with_widgets_construct (TUBA_WIDGETS_TYPE_LABEL_WITH_WIDGETS);
}

const gchar*
tuba_widgets_label_with_widgets_get_placeholder (TubaWidgetsLabelWithWidgets* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_placeholder;
	result = _tmp0_;
	return result;
}

void
tuba_widgets_label_with_widgets_set_placeholder (TubaWidgetsLabelWithWidgets* self,
                                                 const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_placeholder);
	self->priv->_placeholder = _tmp0_;
	tuba_widgets_label_with_widgets_update_label (self);
	g_object_notify_by_pspec ((GObject *) self, tuba_widgets_label_with_widgets_properties[TUBA_WIDGETS_LABEL_WITH_WIDGETS_PLACEHOLDER_PROPERTY]);
}

const gchar*
tuba_widgets_label_with_widgets_get_text (TubaWidgetsLabelWithWidgets* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_text;
	result = _tmp0_;
	return result;
}

void
tuba_widgets_label_with_widgets_set_text (TubaWidgetsLabelWithWidgets* self,
                                          const gchar* value)
{
	gchar* _tmp0_;
	GtkLabel* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_text);
	self->priv->_text = _tmp0_;
	tuba_widgets_label_with_widgets_update_label (self);
	_tmp1_ = self->label;
	g_object_notify ((GObject*) _tmp1_, "label");
	g_object_notify_by_pspec ((GObject *) self, tuba_widgets_label_with_widgets_properties[TUBA_WIDGETS_LABEL_WITH_WIDGETS_TEXT_PROPERTY]);
}

gboolean
tuba_widgets_label_with_widgets_get_use_markup (TubaWidgetsLabelWithWidgets* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_use_markup;
	return result;
}

void
tuba_widgets_label_with_widgets_set_use_markup (TubaWidgetsLabelWithWidgets* self,
                                                gboolean value)
{
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	if (self->priv->_use_markup == value) {
		return;
	}
	self->priv->_use_markup = value;
	_tmp0_ = self->label;
	gtk_label_set_use_markup (_tmp0_, self->priv->_use_markup);
	g_object_notify_by_pspec ((GObject *) self, tuba_widgets_label_with_widgets_properties[TUBA_WIDGETS_LABEL_WITH_WIDGETS_USE_MARKUP_PROPERTY]);
}

const gchar*
tuba_widgets_label_with_widgets_get_accessible_text (TubaWidgetsLabelWithWidgets* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_accessible_text;
	result = _tmp0_;
	return result;
}

static void
tuba_widgets_label_with_widgets_set_accessible_text (TubaWidgetsLabelWithWidgets* self,
                                                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = tuba_widgets_label_with_widgets_get_accessible_text (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_accessible_text);
		self->priv->_accessible_text = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, tuba_widgets_label_with_widgets_properties[TUBA_WIDGETS_LABEL_WITH_WIDGETS_ACCESSIBLE_TEXT_PROPERTY]);
	}
}

const gchar*
tuba_widgets_label_with_widgets_get_label_text (TubaWidgetsLabelWithWidgets* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label_text;
	result = _tmp0_;
	return result;
}

gboolean
tuba_widgets_label_with_widgets_get_single_line_mode (TubaWidgetsLabelWithWidgets* self)
{
	gboolean result;
	GtkLabel* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->label;
	_tmp1_ = gtk_label_get_single_line_mode (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
tuba_widgets_label_with_widgets_set_single_line_mode (TubaWidgetsLabelWithWidgets* self,
                                                      gboolean value)
{
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->label;
	gtk_label_set_single_line_mode (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, tuba_widgets_label_with_widgets_properties[TUBA_WIDGETS_LABEL_WITH_WIDGETS_SINGLE_LINE_MODE_PROPERTY]);
}

gfloat
tuba_widgets_label_with_widgets_get_xalign (TubaWidgetsLabelWithWidgets* self)
{
	gfloat result;
	GtkLabel* _tmp0_;
	gfloat _tmp1_;
	gfloat _tmp2_;
	g_return_val_if_fail (self != NULL, 0.0F);
	_tmp0_ = self->label;
	_tmp1_ = gtk_label_get_xalign (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
tuba_widgets_label_with_widgets_set_xalign (TubaWidgetsLabelWithWidgets* self,
                                            gfloat value)
{
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->label;
	gtk_label_set_xalign (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, tuba_widgets_label_with_widgets_properties[TUBA_WIDGETS_LABEL_WITH_WIDGETS_XALIGN_PROPERTY]);
}

gfloat
tuba_widgets_label_with_widgets_get_yalign (TubaWidgetsLabelWithWidgets* self)
{
	gfloat result;
	GtkLabel* _tmp0_;
	gfloat _tmp1_;
	gfloat _tmp2_;
	g_return_val_if_fail (self != NULL, 0.0F);
	_tmp0_ = self->label;
	_tmp1_ = gtk_label_get_yalign (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
tuba_widgets_label_with_widgets_set_yalign (TubaWidgetsLabelWithWidgets* self,
                                            gfloat value)
{
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->label;
	gtk_label_set_yalign (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, tuba_widgets_label_with_widgets_properties[TUBA_WIDGETS_LABEL_WITH_WIDGETS_YALIGN_PROPERTY]);
}

gboolean
tuba_widgets_label_with_widgets_get_selectable (TubaWidgetsLabelWithWidgets* self)
{
	gboolean result;
	GtkLabel* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->label;
	_tmp1_ = gtk_label_get_selectable (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
tuba_widgets_label_with_widgets_set_selectable (TubaWidgetsLabelWithWidgets* self,
                                                gboolean value)
{
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->label;
	gtk_label_set_selectable (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, tuba_widgets_label_with_widgets_properties[TUBA_WIDGETS_LABEL_WITH_WIDGETS_SELECTABLE_PROPERTY]);
}

gint
tuba_widgets_label_with_widgets_get_lines (TubaWidgetsLabelWithWidgets* self)
{
	gint result;
	GtkLabel* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->label;
	_tmp1_ = gtk_label_get_lines (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
tuba_widgets_label_with_widgets_set_lines (TubaWidgetsLabelWithWidgets* self,
                                           gint value)
{
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->label;
	gtk_label_set_lines (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, tuba_widgets_label_with_widgets_properties[TUBA_WIDGETS_LABEL_WITH_WIDGETS_LINES_PROPERTY]);
}

gboolean
tuba_widgets_label_with_widgets_get_ellipsize (TubaWidgetsLabelWithWidgets* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_ellipsize;
	return result;
}

void
tuba_widgets_label_with_widgets_set_ellipsize (TubaWidgetsLabelWithWidgets* self,
                                               gboolean value)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = tuba_widgets_label_with_widgets_get_ellipsize (self);
	_tmp1_ = _tmp0_;
	if (value != _tmp1_) {
		PangoEllipsizeMode _tmp2_ = 0;
		GtkLabel* _tmp3_;
		if (value) {
			_tmp2_ = PANGO_ELLIPSIZE_END;
		} else {
			_tmp2_ = PANGO_ELLIPSIZE_NONE;
		}
		_tmp3_ = self->label;
		gtk_label_set_ellipsize (_tmp3_, _tmp2_);
		self->priv->_ellipsize = TRUE;
	}
	g_object_notify_by_pspec ((GObject *) self, tuba_widgets_label_with_widgets_properties[TUBA_WIDGETS_LABEL_WITH_WIDGETS_ELLIPSIZE_PROPERTY]);
}

GtkJustification
tuba_widgets_label_with_widgets_get_justify (TubaWidgetsLabelWithWidgets* self)
{
	GtkJustification result;
	GtkLabel* _tmp0_;
	GtkJustification _tmp1_;
	GtkJustification _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->label;
	_tmp1_ = gtk_label_get_justify (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
tuba_widgets_label_with_widgets_set_justify (TubaWidgetsLabelWithWidgets* self,
                                             GtkJustification value)
{
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->label;
	gtk_label_set_justify (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, tuba_widgets_label_with_widgets_properties[TUBA_WIDGETS_LABEL_WITH_WIDGETS_JUSTIFY_PROPERTY]);
}

static void
g_cclosure_user_marshal_BOOLEAN__STRING (GClosure * closure,
                                         GValue * return_value,
                                         guint n_param_values,
                                         const GValue * param_values,
                                         gpointer invocation_hint,
                                         gpointer marshal_data)
{
	typedef gboolean (*GMarshalFunc_BOOLEAN__STRING) (gpointer data1, const char* arg_1, gpointer data2);
	register GMarshalFunc_BOOLEAN__STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__STRING) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_string (param_values + 1), data2);
	g_value_set_boolean (return_value, v_return);
}

static void
tuba_widgets_label_with_widgets_lww_widget_copy (const TubaWidgetsLabelWithWidgetsLWWWidget* self,
                                                 TubaWidgetsLabelWithWidgetsLWWWidget* dest)
{
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	_tmp0_ = (*self).widget;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).widget);
	(*dest).widget = _tmp1_;
	(*dest).height = (*self).height;
	(*dest).width = (*self).width;
}

static void
tuba_widgets_label_with_widgets_lww_widget_destroy (TubaWidgetsLabelWithWidgetsLWWWidget* self)
{
	_g_object_unref0 ((*self).widget);
}

static TubaWidgetsLabelWithWidgetsLWWWidget*
tuba_widgets_label_with_widgets_lww_widget_dup (const TubaWidgetsLabelWithWidgetsLWWWidget* self)
{
	TubaWidgetsLabelWithWidgetsLWWWidget* dup;
	dup = g_new0 (TubaWidgetsLabelWithWidgetsLWWWidget, 1);
	tuba_widgets_label_with_widgets_lww_widget_copy (self, dup);
	return dup;
}

static void
tuba_widgets_label_with_widgets_lww_widget_free (TubaWidgetsLabelWithWidgetsLWWWidget* self)
{
	tuba_widgets_label_with_widgets_lww_widget_destroy (self);
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
tuba_widgets_label_with_widgets_lww_widget_get_type_once (void)
{
	GType tuba_widgets_label_with_widgets_lww_widget_type_id;
	tuba_widgets_label_with_widgets_lww_widget_type_id = g_boxed_type_register_static ("TubaWidgetsLabelWithWidgetsLWWWidget", (GBoxedCopyFunc) tuba_widgets_label_with_widgets_lww_widget_dup, (GBoxedFreeFunc) tuba_widgets_label_with_widgets_lww_widget_free);
	return tuba_widgets_label_with_widgets_lww_widget_type_id;
}

static GType
tuba_widgets_label_with_widgets_lww_widget_get_type (void)
{
	static gsize tuba_widgets_label_with_widgets_lww_widget_type_id__once = 0;
	if (g_once_init_enter (&tuba_widgets_label_with_widgets_lww_widget_type_id__once)) {
		GType tuba_widgets_label_with_widgets_lww_widget_type_id;
		tuba_widgets_label_with_widgets_lww_widget_type_id = tuba_widgets_label_with_widgets_lww_widget_get_type_once ();
		g_once_init_leave (&tuba_widgets_label_with_widgets_lww_widget_type_id__once, tuba_widgets_label_with_widgets_lww_widget_type_id);
	}
	return tuba_widgets_label_with_widgets_lww_widget_type_id__once;
}

static gboolean
_tuba_widgets_label_with_widgets_on_activate_link_gtk_label_activate_link (GtkLabel* _sender,
                                                                           const gchar* uri,
                                                                           gpointer self)
{
	gboolean result;
	result = tuba_widgets_label_with_widgets_on_activate_link ((TubaWidgetsLabelWithWidgets*) self, uri);
	return result;
}

static GObject *
tuba_widgets_label_with_widgets_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	TubaWidgetsLabelWithWidgets * self;
	GtkLabel* _tmp0_ = NULL;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	parent_class = G_OBJECT_CLASS (tuba_widgets_label_with_widgets_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TUBA_WIDGETS_TYPE_LABEL_WITH_WIDGETS, TubaWidgetsLabelWithWidgets);
	_tmp0_ = (GtkLabel*) gtk_label_new ("");
	gtk_label_set_wrap (_tmp0_, TRUE);
	gtk_label_set_wrap_mode (_tmp0_, PANGO_WRAP_WORD_CHAR);
	gtk_label_set_xalign (_tmp0_, 0.0f);
	gtk_widget_set_valign ((GtkWidget*) _tmp0_, GTK_ALIGN_START);
	gtk_label_set_use_markup (_tmp0_, FALSE);
	gtk_label_set_ellipsize (_tmp0_, PANGO_ELLIPSIZE_NONE);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->label);
	self->label = _tmp0_;
	_tmp1_ = self->label;
	gtk_widget_set_parent ((GtkWidget*) _tmp1_, (GtkWidget*) self);
	_tmp2_ = self->label;
	g_signal_connect_object (_tmp2_, "activate-link", (GCallback) _tuba_widgets_label_with_widgets_on_activate_link_gtk_label_activate_link, self, 0);
	return obj;
}

static void
tuba_widgets_label_with_widgets_class_init (TubaWidgetsLabelWithWidgetsClass * klass,
                                            gpointer klass_data)
{
	tuba_widgets_label_with_widgets_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TubaWidgetsLabelWithWidgets_private_offset);
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, gint, gint, gint)) tuba_widgets_label_with_widgets_real_size_allocate;
	((GtkWidgetClass *) klass)->get_request_mode = (GtkSizeRequestMode (*) (GtkWidget*)) tuba_widgets_label_with_widgets_real_get_request_mode;
	((GtkWidgetClass *) klass)->measure = (void (*) (GtkWidget*, GtkOrientation, gint, gint*, gint*, gint*, gint*)) tuba_widgets_label_with_widgets_real_measure;
	G_OBJECT_CLASS (klass)->get_property = _vala_tuba_widgets_label_with_widgets_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tuba_widgets_label_with_widgets_set_property;
	G_OBJECT_CLASS (klass)->constructor = tuba_widgets_label_with_widgets_constructor;
	G_OBJECT_CLASS (klass)->finalize = tuba_widgets_label_with_widgets_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_WIDGETS_LABEL_WITH_WIDGETS_PLACEHOLDER_PROPERTY, tuba_widgets_label_with_widgets_properties[TUBA_WIDGETS_LABEL_WITH_WIDGETS_PLACEHOLDER_PROPERTY] = g_param_spec_string ("placeholder", "placeholder", "placeholder", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_WIDGETS_LABEL_WITH_WIDGETS_TEXT_PROPERTY, tuba_widgets_label_with_widgets_properties[TUBA_WIDGETS_LABEL_WITH_WIDGETS_TEXT_PROPERTY] = g_param_spec_string ("text", "text", "text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_WIDGETS_LABEL_WITH_WIDGETS_USE_MARKUP_PROPERTY, tuba_widgets_label_with_widgets_properties[TUBA_WIDGETS_LABEL_WITH_WIDGETS_USE_MARKUP_PROPERTY] = g_param_spec_boolean ("use-markup", "use-markup", "use-markup", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_WIDGETS_LABEL_WITH_WIDGETS_ACCESSIBLE_TEXT_PROPERTY, tuba_widgets_label_with_widgets_properties[TUBA_WIDGETS_LABEL_WITH_WIDGETS_ACCESSIBLE_TEXT_PROPERTY] = g_param_spec_string ("accessible-text", "accessible-text", "accessible-text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_WIDGETS_LABEL_WITH_WIDGETS_LABEL_TEXT_PROPERTY, tuba_widgets_label_with_widgets_properties[TUBA_WIDGETS_LABEL_WITH_WIDGETS_LABEL_TEXT_PROPERTY] = g_param_spec_string ("label-text", "label-text", "label-text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_WIDGETS_LABEL_WITH_WIDGETS_SINGLE_LINE_MODE_PROPERTY, tuba_widgets_label_with_widgets_properties[TUBA_WIDGETS_LABEL_WITH_WIDGETS_SINGLE_LINE_MODE_PROPERTY] = g_param_spec_boolean ("single-line-mode", "single-line-mode", "single-line-mode", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_WIDGETS_LABEL_WITH_WIDGETS_XALIGN_PROPERTY, tuba_widgets_label_with_widgets_properties[TUBA_WIDGETS_LABEL_WITH_WIDGETS_XALIGN_PROPERTY] = g_param_spec_float ("xalign", "xalign", "xalign", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_WIDGETS_LABEL_WITH_WIDGETS_YALIGN_PROPERTY, tuba_widgets_label_with_widgets_properties[TUBA_WIDGETS_LABEL_WITH_WIDGETS_YALIGN_PROPERTY] = g_param_spec_float ("yalign", "yalign", "yalign", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_WIDGETS_LABEL_WITH_WIDGETS_SELECTABLE_PROPERTY, tuba_widgets_label_with_widgets_properties[TUBA_WIDGETS_LABEL_WITH_WIDGETS_SELECTABLE_PROPERTY] = g_param_spec_boolean ("selectable", "selectable", "selectable", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_WIDGETS_LABEL_WITH_WIDGETS_LINES_PROPERTY, tuba_widgets_label_with_widgets_properties[TUBA_WIDGETS_LABEL_WITH_WIDGETS_LINES_PROPERTY] = g_param_spec_int ("lines", "lines", "lines", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_WIDGETS_LABEL_WITH_WIDGETS_ELLIPSIZE_PROPERTY, tuba_widgets_label_with_widgets_properties[TUBA_WIDGETS_LABEL_WITH_WIDGETS_ELLIPSIZE_PROPERTY] = g_param_spec_boolean ("ellipsize", "ellipsize", "ellipsize", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_WIDGETS_LABEL_WITH_WIDGETS_JUSTIFY_PROPERTY, tuba_widgets_label_with_widgets_properties[TUBA_WIDGETS_LABEL_WITH_WIDGETS_JUSTIFY_PROPERTY] = g_param_spec_enum ("justify", "justify", "justify", gtk_justification_get_type (), 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	tuba_widgets_label_with_widgets_signals[TUBA_WIDGETS_LABEL_WITH_WIDGETS_ACTIVATE_LINK_SIGNAL] = g_signal_new ("activate-link", TUBA_WIDGETS_TYPE_LABEL_WITH_WIDGETS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__STRING, G_TYPE_BOOLEAN, 1, G_TYPE_STRING);
}

static void
tuba_widgets_label_with_widgets_gtk_buildable_interface_init (GtkBuildableIface * iface,
                                                              gpointer iface_data)
{
	tuba_widgets_label_with_widgets_gtk_buildable_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_child = (void (*) (GtkBuildable*, GtkBuilder*, GObject*, const gchar*)) tuba_widgets_label_with_widgets_real_add_child;
}

static void
tuba_widgets_label_with_widgets_gtk_accessible_interface_init (GtkAccessibleInterface * iface,
                                                               gpointer iface_data)
{
	tuba_widgets_label_with_widgets_gtk_accessible_parent_iface = g_type_interface_peek_parent (iface);
}

static void
tuba_widgets_label_with_widgets_instance_init (TubaWidgetsLabelWithWidgets * self,
                                               gpointer klass)
{
	TubaWidgetsLabelWithWidgetsLWWWidget* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	self->priv = tuba_widgets_label_with_widgets_get_instance_private (self);
	_tmp0_ = g_new0 (TubaWidgetsLabelWithWidgetsLWWWidget, 0);
	self->priv->widgets = _tmp0_;
	self->priv->widgets_length1 = 0;
	self->priv->_widgets_size_ = self->priv->widgets_length1;
	_tmp1_ = g_strdup ("<widget>");
	self->priv->_placeholder = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->priv->_label_text = _tmp2_;
	_tmp3_ = g_strdup ("");
	self->priv->_text = _tmp3_;
	self->priv->_use_markup = FALSE;
	_tmp4_ = g_strdup ("");
	self->priv->_accessible_text = _tmp4_;
	self->priv->_ellipsize = FALSE;
}

static void
tuba_widgets_label_with_widgets_finalize (GObject * obj)
{
	TubaWidgetsLabelWithWidgets * self;
	GtkLabel* _tmp0_;
	TubaWidgetsLabelWithWidgetsLWWWidget* _tmp1_;
	gint _tmp1__length1;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TUBA_WIDGETS_TYPE_LABEL_WITH_WIDGETS, TubaWidgetsLabelWithWidgets);
	_tmp0_ = self->label;
	gtk_widget_unparent ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->widgets;
	_tmp1__length1 = self->priv->widgets_length1;
	{
		TubaWidgetsLabelWithWidgetsLWWWidget* child_collection = NULL;
		gint child_collection_length1 = 0;
		gint _child_collection_size_ = 0;
		gint child_it = 0;
		child_collection = _tmp1_;
		child_collection_length1 = _tmp1__length1;
		for (child_it = 0; child_it < child_collection_length1; child_it = child_it + 1) {
			TubaWidgetsLabelWithWidgetsLWWWidget _tmp2_;
			TubaWidgetsLabelWithWidgetsLWWWidget _tmp3_ = {0};
			TubaWidgetsLabelWithWidgetsLWWWidget child = {0};
			_tmp2_ = child_collection[child_it];
			tuba_widgets_label_with_widgets_lww_widget_copy (&_tmp2_, &_tmp3_);
			child = _tmp3_;
			{
				TubaWidgetsLabelWithWidgetsLWWWidget _tmp4_;
				GtkWidget* _tmp5_;
				_tmp4_ = child;
				_tmp5_ = _tmp4_.widget;
				gtk_widget_unparent (_tmp5_);
				tuba_widgets_label_with_widgets_lww_widget_destroy (&child);
			}
		}
	}
	self->priv->widgets = (_vala_TubaWidgetsLabelWithWidgetsLWWWidget_array_free (self->priv->widgets, self->priv->widgets_length1), NULL);
	_g_object_unref0 (self->label);
	_g_free0 (self->priv->_placeholder);
	_g_free0 (self->priv->_label_text);
	_g_free0 (self->priv->_text);
	_g_free0 (self->priv->_accessible_text);
	G_OBJECT_CLASS (tuba_widgets_label_with_widgets_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
tuba_widgets_label_with_widgets_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TubaWidgetsLabelWithWidgetsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tuba_widgets_label_with_widgets_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TubaWidgetsLabelWithWidgets), 0, (GInstanceInitFunc) tuba_widgets_label_with_widgets_instance_init, NULL };
	static const GInterfaceInfo gtk_buildable_info = { (GInterfaceInitFunc) tuba_widgets_label_with_widgets_gtk_buildable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gtk_accessible_info = { (GInterfaceInitFunc) tuba_widgets_label_with_widgets_gtk_accessible_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType tuba_widgets_label_with_widgets_type_id;
	tuba_widgets_label_with_widgets_type_id = g_type_register_static (gtk_widget_get_type (), "TubaWidgetsLabelWithWidgets", &g_define_type_info, 0);
	g_type_add_interface_static (tuba_widgets_label_with_widgets_type_id, gtk_buildable_get_type (), &gtk_buildable_info);
	g_type_add_interface_static (tuba_widgets_label_with_widgets_type_id, gtk_accessible_get_type (), &gtk_accessible_info);
	TubaWidgetsLabelWithWidgets_private_offset = g_type_add_instance_private (tuba_widgets_label_with_widgets_type_id, sizeof (TubaWidgetsLabelWithWidgetsPrivate));
	return tuba_widgets_label_with_widgets_type_id;
}

GType
tuba_widgets_label_with_widgets_get_type (void)
{
	static gsize tuba_widgets_label_with_widgets_type_id__once = 0;
	if (g_once_init_enter (&tuba_widgets_label_with_widgets_type_id__once)) {
		GType tuba_widgets_label_with_widgets_type_id;
		tuba_widgets_label_with_widgets_type_id = tuba_widgets_label_with_widgets_get_type_once ();
		g_once_init_leave (&tuba_widgets_label_with_widgets_type_id__once, tuba_widgets_label_with_widgets_type_id);
	}
	return tuba_widgets_label_with_widgets_type_id__once;
}

static void
_vala_tuba_widgets_label_with_widgets_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec)
{
	TubaWidgetsLabelWithWidgets * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TUBA_WIDGETS_TYPE_LABEL_WITH_WIDGETS, TubaWidgetsLabelWithWidgets);
	switch (property_id) {
		case TUBA_WIDGETS_LABEL_WITH_WIDGETS_PLACEHOLDER_PROPERTY:
		g_value_set_string (value, tuba_widgets_label_with_widgets_get_placeholder (self));
		break;
		case TUBA_WIDGETS_LABEL_WITH_WIDGETS_TEXT_PROPERTY:
		g_value_set_string (value, tuba_widgets_label_with_widgets_get_text (self));
		break;
		case TUBA_WIDGETS_LABEL_WITH_WIDGETS_USE_MARKUP_PROPERTY:
		g_value_set_boolean (value, tuba_widgets_label_with_widgets_get_use_markup (self));
		break;
		case TUBA_WIDGETS_LABEL_WITH_WIDGETS_ACCESSIBLE_TEXT_PROPERTY:
		g_value_set_string (value, tuba_widgets_label_with_widgets_get_accessible_text (self));
		break;
		case TUBA_WIDGETS_LABEL_WITH_WIDGETS_LABEL_TEXT_PROPERTY:
		g_value_set_string (value, tuba_widgets_label_with_widgets_get_label_text (self));
		break;
		case TUBA_WIDGETS_LABEL_WITH_WIDGETS_SINGLE_LINE_MODE_PROPERTY:
		g_value_set_boolean (value, tuba_widgets_label_with_widgets_get_single_line_mode (self));
		break;
		case TUBA_WIDGETS_LABEL_WITH_WIDGETS_XALIGN_PROPERTY:
		g_value_set_float (value, tuba_widgets_label_with_widgets_get_xalign (self));
		break;
		case TUBA_WIDGETS_LABEL_WITH_WIDGETS_YALIGN_PROPERTY:
		g_value_set_float (value, tuba_widgets_label_with_widgets_get_yalign (self));
		break;
		case TUBA_WIDGETS_LABEL_WITH_WIDGETS_SELECTABLE_PROPERTY:
		g_value_set_boolean (value, tuba_widgets_label_with_widgets_get_selectable (self));
		break;
		case TUBA_WIDGETS_LABEL_WITH_WIDGETS_LINES_PROPERTY:
		g_value_set_int (value, tuba_widgets_label_with_widgets_get_lines (self));
		break;
		case TUBA_WIDGETS_LABEL_WITH_WIDGETS_ELLIPSIZE_PROPERTY:
		g_value_set_boolean (value, tuba_widgets_label_with_widgets_get_ellipsize (self));
		break;
		case TUBA_WIDGETS_LABEL_WITH_WIDGETS_JUSTIFY_PROPERTY:
		g_value_set_enum (value, tuba_widgets_label_with_widgets_get_justify (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_tuba_widgets_label_with_widgets_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec)
{
	TubaWidgetsLabelWithWidgets * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TUBA_WIDGETS_TYPE_LABEL_WITH_WIDGETS, TubaWidgetsLabelWithWidgets);
	switch (property_id) {
		case TUBA_WIDGETS_LABEL_WITH_WIDGETS_PLACEHOLDER_PROPERTY:
		tuba_widgets_label_with_widgets_set_placeholder (self, g_value_get_string (value));
		break;
		case TUBA_WIDGETS_LABEL_WITH_WIDGETS_TEXT_PROPERTY:
		tuba_widgets_label_with_widgets_set_text (self, g_value_get_string (value));
		break;
		case TUBA_WIDGETS_LABEL_WITH_WIDGETS_USE_MARKUP_PROPERTY:
		tuba_widgets_label_with_widgets_set_use_markup (self, g_value_get_boolean (value));
		break;
		case TUBA_WIDGETS_LABEL_WITH_WIDGETS_ACCESSIBLE_TEXT_PROPERTY:
		tuba_widgets_label_with_widgets_set_accessible_text (self, g_value_get_string (value));
		break;
		case TUBA_WIDGETS_LABEL_WITH_WIDGETS_SINGLE_LINE_MODE_PROPERTY:
		tuba_widgets_label_with_widgets_set_single_line_mode (self, g_value_get_boolean (value));
		break;
		case TUBA_WIDGETS_LABEL_WITH_WIDGETS_XALIGN_PROPERTY:
		tuba_widgets_label_with_widgets_set_xalign (self, g_value_get_float (value));
		break;
		case TUBA_WIDGETS_LABEL_WITH_WIDGETS_YALIGN_PROPERTY:
		tuba_widgets_label_with_widgets_set_yalign (self, g_value_get_float (value));
		break;
		case TUBA_WIDGETS_LABEL_WITH_WIDGETS_SELECTABLE_PROPERTY:
		tuba_widgets_label_with_widgets_set_selectable (self, g_value_get_boolean (value));
		break;
		case TUBA_WIDGETS_LABEL_WITH_WIDGETS_LINES_PROPERTY:
		tuba_widgets_label_with_widgets_set_lines (self, g_value_get_int (value));
		break;
		case TUBA_WIDGETS_LABEL_WITH_WIDGETS_ELLIPSIZE_PROPERTY:
		tuba_widgets_label_with_widgets_set_ellipsize (self, g_value_get_boolean (value));
		break;
		case TUBA_WIDGETS_LABEL_WITH_WIDGETS_JUSTIFY_PROPERTY:
		tuba_widgets_label_with_widgets_set_justify (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

