const char metrics_utils_lua[] =
"local metrics_api = require('metrics.api')\n"
"\n"
"local TNT_PREFIX = 'tnt_'\n"
"local utils = {}\n"
"\n"
"function utils.set_gauge(name, description, value, labels, prefix, metainfo)\n"
"    prefix = prefix or TNT_PREFIX\n"
"    local gauge = metrics_api.gauge(prefix .. name, description, metainfo)\n"
"    gauge:set(value, labels or {})\n"
"    return gauge\n"
"end\n"
"\n"
"function utils.set_counter(name, description, value, labels, prefix, metainfo)\n"
"    prefix = prefix or TNT_PREFIX\n"
"    local counter = metrics_api.counter(prefix .. name, description, metainfo)\n"
"    counter:reset(labels or {})\n"
"    counter:inc(value, labels or {})\n"
"    return counter\n"
"end\n"
"\n"
"function utils.box_is_configured()\n"
"    local is_configured = type(box.cfg) ~= 'function'\n"
"    if is_configured then\n"
"        utils.box_is_configured = function() return true end\n"
"    end\n"
"    return is_configured\n"
"end\n"
"\n"
"function utils.delete_collectors(list)\n"
"    if list == nil then\n"
"        return\n"
"    end\n"
"    for _, collector in pairs(list) do\n"
"        metrics_api.registry:unregister(collector)\n"
"    end\n"
"    table.clear(list)\n"
"end\n"
"\n"
"return utils\n"
""
;
