const char metrics_registry_lua[] =
"local Registry = {}\n"
"Registry.__index = Registry\n"
"\n"
"function Registry.new()\n"
"    local obj = {}\n"
"    setmetatable(obj, Registry)\n"
"    obj:clear()\n"
"    return obj\n"
"end\n"
"\n"
"function Registry:clear()\n"
"    self.collectors = {}\n"
"    self.callbacks = {}\n"
"    self.label_pairs = {}\n"
"end\n"
"\n"
"function Registry:find(kind, name)\n"
"    return self.collectors[name .. kind]\n"
"end\n"
"\n"
"function Registry:find_or_create(class, name, ...)\n"
"    return self:find(class.kind, name) or self:register(class:new(name, ...))\n"
"end\n"
"\n"
"local function is_empty(str)\n"
"    return str == nil or str == ''\n"
"end\n"
"\n"
"function Registry:register(collector)\n"
"    assert(collector ~= nil, 'Collector is empty')\n"
"    assert(not is_empty(collector.name), \"Collector's name is empty\")\n"
"    assert(not is_empty(collector.kind), \"Collector's kind is empty\")\n"
"    if self:find(collector.kind, collector.name) then\n"
"        error('Already registered')\n"
"    end\n"
"    collector:set_registry(self)\n"
"    self.collectors[collector.name .. collector.kind] = collector\n"
"    return collector\n"
"end\n"
"\n"
"function Registry:unregister(collector)\n"
"    self.collectors[collector.name .. collector.kind] = nil\n"
"end\n"
"\n"
"function Registry:invoke_callbacks()\n"
"    for registered_callback, _ in pairs(self.callbacks) do\n"
"        registered_callback()\n"
"    end\n"
"end\n"
"\n"
"function Registry:collect()\n"
"    local result = {}\n"
"    for _, collector in pairs(self.collectors) do\n"
"        for _, obs in ipairs(collector:collect()) do\n"
"            table.insert(result, obs)\n"
"        end\n"
"    end\n"
"    return result\n"
"end\n"
"\n"
"function Registry:register_callback(callback)\n"
"    self.callbacks[callback] = true\n"
"end\n"
"\n"
"function Registry:unregister_callback(callback)\n"
"    self.callbacks[callback] = nil\n"
"end\n"
"\n"
"function Registry:set_labels(label_pairs)\n"
"    self.label_pairs = table.copy(label_pairs)\n"
"end\n"
"\n"
"return Registry\n"
""
;
