const char metrics_collectors_summary_lua[] =
"local Shared = require('metrics.collectors.shared')\n"
"local Counter = require('metrics.collectors.counter')\n"
"local Quantile = require('metrics.quantile')\n"
"\n"
"local fiber = require('fiber')\n"
"\n"
"local Summary = Shared:new_class('summary', {'observe_latency'})\n"
"\n"
"function Summary:new(name, help, objectives, params, metainfo)\n"
"    params = params or {}\n"
"    metainfo = table.copy(metainfo) or {}\n"
"    local obj = Shared.new(self, name, help, metainfo)\n"
"\n"
"    obj.count_collector = Counter:new(name .. '_count', help, metainfo)\n"
"    obj.sum_collector = Counter:new(name .. '_sum', help, metainfo)\n"
"    obj.objectives = objectives\n"
"    obj.max_age_time = params.max_age_time\n"
"    obj.age_buckets_count = params.age_buckets_count or 1\n"
"    obj.observations = {}\n"
"\n"
"    if obj.objectives then\n"
"        obj.quantiles = {}\n"
"        for q, _ in pairs(objectives) do\n"
"            table.insert(obj.quantiles, q)\n"
"        end\n"
"    end\n"
"    return obj\n"
"end\n"
"\n"
"function Summary.check_quantiles(objectives)\n"
"    for k, v in pairs(objectives) do\n"
"        if type(k) ~= 'number' then return false end\n"
"        if k > 1 or k < 0 then return false end\n"
"        if type(v) ~= 'number' then return false end\n"
"    end\n"
"    return true\n"
"end\n"
"\n"
"function Summary:set_registry(registry)\n"
"    Shared.set_registry(self, registry)\n"
"    self.count_collector:set_registry(registry)\n"
"    self.sum_collector:set_registry(registry)\n"
"end\n"
"\n"
"function Summary:rotate_age_buckets(key)\n"
"    local obs_object = self.observations[key]\n"
"    local old_index = obs_object.head_bucket_index\n"
"    obs_object.head_bucket_index = ((obs_object.head_bucket_index + 1) % self.age_buckets_count) + 1\n"
"    Quantile.Reset(obs_object.buckets[old_index])\n"
"    obs_object.last_rotate = os.time()\n"
"end\n"
"\n"
"function Summary:observe(num, label_pairs)\n"
"    label_pairs = label_pairs or {}\n"
"    if label_pairs.quantile then\n"
"        error('Label \"quantile\" are not allowed in summary')\n"
"    end\n"
"    if num ~= nil and type(tonumber(num)) ~= 'number' then\n"
"        error(\"Summary observation should be a number\")\n"
"    end\n"
"    self.count_collector:inc(1, label_pairs)\n"
"    self.sum_collector:inc(num, label_pairs)\n"
"    if self.objectives then\n"
"        local now = os.time()\n"
"        local key = self.make_key(label_pairs)\n"
"\n"
"        if not self.observations[key] then\n"
"            local obs_object = {\n"
"                buckets = {},\n"
"                head_bucket_index = 1,\n"
"                last_rotate = now,\n"
"                label_pairs = label_pairs,\n"
"            }\n"
"            self.label_pairs[key] = label_pairs\n"
"            for i = 1, self.age_buckets_count do\n"
"                local quantile_obj = Quantile.NewTargeted(self.objectives)\n"
"                Quantile.Insert(quantile_obj, num)\n"
"                obs_object.buckets[i] = quantile_obj\n"
"            end\n"
"            self.observations[key] = obs_object\n"
"        else\n"
"            local obs_object = self.observations[key]\n"
"            if self.age_buckets_count > 1 and now - obs_object.last_rotate >= self.max_age_time then\n"
"                self:rotate_age_buckets(key)\n"
"            end\n"
"            for _, bucket in ipairs(obs_object.buckets) do\n"
"                Quantile.Insert(bucket, num)\n"
"            end\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"function Summary:remove(label_pairs)\n"
"    assert(label_pairs, 'label pairs is a required parameter')\n"
"    self.count_collector:remove(label_pairs)\n"
"    self.sum_collector:remove(label_pairs)\n"
"    if self.objectives then\n"
"        local key = self.make_key(label_pairs)\n"
"        self.observations[key] = nil\n"
"    end\n"
"end\n"
"\n"
"function Summary:collect_quantiles()\n"
"    if not self.objectives or next(self.observations) == nil then\n"
"        return {}\n"
"    end\n"
"\n"
"    local result = {}\n"
"    local now = os.time()\n"
"    for key, observation in pairs(self.observations) do\n"
"        if self.age_buckets_count > 1 and now - observation.last_rotate >= self.max_age_time then\n"
"            self:rotate_age_buckets(key)\n"
"        end\n"
"        for _, objective in ipairs(self.quantiles) do\n"
"            local label_pairs = table.deepcopy(self:append_global_labels(observation.label_pairs))\n"
"            label_pairs.quantile = objective\n"
"            local obs = {\n"
"                metric_name = self.name,\n"
"                label_pairs = label_pairs,\n"
"                value = Quantile.Query(observation.buckets[observation.head_bucket_index], objective),\n"
"                timestamp = fiber.time64(),\n"
"            }\n"
"            table.insert(result, obs)\n"
"        end\n"
"    end\n"
"    return result\n"
"end\n"
"\n"
"function Summary:collect()\n"
"    local result = {}\n"
"    for _, obs in ipairs(self.count_collector:collect()) do\n"
"        table.insert(result, obs)\n"
"    end\n"
"    for _, obs in ipairs(self.sum_collector:collect()) do\n"
"        table.insert(result, obs)\n"
"    end\n"
"    for _, obs in ipairs(self:collect_quantiles()) do\n"
"        table.insert(result, obs)\n"
"    end\n"
"    return result\n"
"end\n"
"\n"
"-- debug function to get observation quantiles from summary\n"
"-- returns array of quantile objects or\n"
"-- single quantile object if summary has only one bucket\n"
"function Summary:get_observations(label_pairs)\n"
"    local key = self.make_key(label_pairs or {})\n"
"    local obs = self.observations[key]\n"
"    if self.age_buckets_count > 1 then\n"
"        return obs\n"
"    else\n"
"        return obs.buckets[1]\n"
"    end\n"
"end\n"
"\n"
"return Summary\n"
""
;
