//go:build !ignore_autogenerated
// +build !ignore_autogenerated

// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.

// Code generated by deepcopy-gen. DO NOT EDIT.

package v1alpha1

import (
	x509 "github.com/siderolabs/crypto/x509"
)

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *APIServerConfig) DeepCopyInto(out *APIServerConfig) {
	*out = *in
	if in.ExtraArgsConfig != nil {
		in, out := &in.ExtraArgsConfig, &out.ExtraArgsConfig
		*out = make(Args, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.ExtraVolumesConfig != nil {
		in, out := &in.ExtraVolumesConfig, &out.ExtraVolumesConfig
		*out = make([]VolumeMountConfig, len(*in))
		copy(*out, *in)
	}
	if in.EnvConfig != nil {
		in, out := &in.EnvConfig, &out.EnvConfig
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.CertSANs != nil {
		in, out := &in.CertSANs, &out.CertSANs
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.DisablePodSecurityPolicyConfig != nil {
		in, out := &in.DisablePodSecurityPolicyConfig, &out.DisablePodSecurityPolicyConfig
		*out = new(bool)
		**out = **in
	}
	if in.AdmissionControlConfig != nil {
		in, out := &in.AdmissionControlConfig, &out.AdmissionControlConfig
		*out = make(AdmissionPluginConfigList, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = new(AdmissionPluginConfig)
				(*in).DeepCopyInto(*out)
			}
		}
	}
	in.AuditPolicyConfig.DeepCopyInto(&out.AuditPolicyConfig)
	if in.ResourcesConfig != nil {
		in, out := &in.ResourcesConfig, &out.ResourcesConfig
		*out = new(ResourcesConfig)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new APIServerConfig.
func (in *APIServerConfig) DeepCopy() *APIServerConfig {
	if in == nil {
		return nil
	}
	out := new(APIServerConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AdminKubeconfigConfig) DeepCopyInto(out *AdminKubeconfigConfig) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AdminKubeconfigConfig.
func (in *AdminKubeconfigConfig) DeepCopy() *AdminKubeconfigConfig {
	if in == nil {
		return nil
	}
	out := new(AdminKubeconfigConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AdmissionPluginConfig) DeepCopyInto(out *AdmissionPluginConfig) {
	*out = *in
	in.PluginConfiguration.DeepCopyInto(&out.PluginConfiguration)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AdmissionPluginConfig.
func (in *AdmissionPluginConfig) DeepCopy() *AdmissionPluginConfig {
	if in == nil {
		return nil
	}
	out := new(AdmissionPluginConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in AdmissionPluginConfigList) DeepCopyInto(out *AdmissionPluginConfigList) {
	{
		in := &in
		*out = make(AdmissionPluginConfigList, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = new(AdmissionPluginConfig)
				(*in).DeepCopyInto(*out)
			}
		}
		return
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AdmissionPluginConfigList.
func (in AdmissionPluginConfigList) DeepCopy() AdmissionPluginConfigList {
	if in == nil {
		return nil
	}
	out := new(AdmissionPluginConfigList)
	in.DeepCopyInto(out)
	return *out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in Base64Bytes) DeepCopyInto(out *Base64Bytes) {
	{
		in := &in
		*out = make(Base64Bytes, len(*in))
		copy(*out, *in)
		return
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Base64Bytes.
func (in Base64Bytes) DeepCopy() Base64Bytes {
	if in == nil {
		return nil
	}
	out := new(Base64Bytes)
	in.DeepCopyInto(out)
	return *out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Bond) DeepCopyInto(out *Bond) {
	*out = *in
	if in.BondInterfaces != nil {
		in, out := &in.BondInterfaces, &out.BondInterfaces
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.BondDeviceSelectors != nil {
		in, out := &in.BondDeviceSelectors, &out.BondDeviceSelectors
		*out = make([]NetworkDeviceSelector, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.BondARPIPTarget != nil {
		in, out := &in.BondARPIPTarget, &out.BondARPIPTarget
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.BondUseCarrier != nil {
		in, out := &in.BondUseCarrier, &out.BondUseCarrier
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Bond.
func (in *Bond) DeepCopy() *Bond {
	if in == nil {
		return nil
	}
	out := new(Bond)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Bridge) DeepCopyInto(out *Bridge) {
	*out = *in
	if in.BridgedInterfaces != nil {
		in, out := &in.BridgedInterfaces, &out.BridgedInterfaces
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.BridgeSTP != nil {
		in, out := &in.BridgeSTP, &out.BridgeSTP
		*out = new(STP)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Bridge.
func (in *Bridge) DeepCopy() *Bridge {
	if in == nil {
		return nil
	}
	out := new(Bridge)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CNIConfig) DeepCopyInto(out *CNIConfig) {
	*out = *in
	if in.CNIUrls != nil {
		in, out := &in.CNIUrls, &out.CNIUrls
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.CNIFlannel != nil {
		in, out := &in.CNIFlannel, &out.CNIFlannel
		*out = new(FlannelCNIConfig)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CNIConfig.
func (in *CNIConfig) DeepCopy() *CNIConfig {
	if in == nil {
		return nil
	}
	out := new(CNIConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterConfig) DeepCopyInto(out *ClusterConfig) {
	*out = *in
	if in.ControlPlane != nil {
		in, out := &in.ControlPlane, &out.ControlPlane
		*out = new(ControlPlaneConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.ClusterNetwork != nil {
		in, out := &in.ClusterNetwork, &out.ClusterNetwork
		*out = new(ClusterNetworkConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.ClusterCA != nil {
		in, out := &in.ClusterCA, &out.ClusterCA
		*out = (*in).DeepCopy()
	}
	if in.ClusterAcceptedCAs != nil {
		in, out := &in.ClusterAcceptedCAs, &out.ClusterAcceptedCAs
		*out = make([]*x509.PEMEncodedCertificate, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = (*in).DeepCopy()
			}
		}
	}
	if in.ClusterAggregatorCA != nil {
		in, out := &in.ClusterAggregatorCA, &out.ClusterAggregatorCA
		*out = (*in).DeepCopy()
	}
	if in.ClusterServiceAccount != nil {
		in, out := &in.ClusterServiceAccount, &out.ClusterServiceAccount
		*out = (*in).DeepCopy()
	}
	if in.APIServerConfig != nil {
		in, out := &in.APIServerConfig, &out.APIServerConfig
		*out = new(APIServerConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.ControllerManagerConfig != nil {
		in, out := &in.ControllerManagerConfig, &out.ControllerManagerConfig
		*out = new(ControllerManagerConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.ProxyConfig != nil {
		in, out := &in.ProxyConfig, &out.ProxyConfig
		*out = new(ProxyConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.SchedulerConfig != nil {
		in, out := &in.SchedulerConfig, &out.SchedulerConfig
		*out = new(SchedulerConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.ClusterDiscoveryConfig != nil {
		in, out := &in.ClusterDiscoveryConfig, &out.ClusterDiscoveryConfig
		*out = new(ClusterDiscoveryConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.EtcdConfig != nil {
		in, out := &in.EtcdConfig, &out.EtcdConfig
		*out = new(EtcdConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.CoreDNSConfig != nil {
		in, out := &in.CoreDNSConfig, &out.CoreDNSConfig
		*out = new(CoreDNS)
		(*in).DeepCopyInto(*out)
	}
	if in.ExternalCloudProviderConfig != nil {
		in, out := &in.ExternalCloudProviderConfig, &out.ExternalCloudProviderConfig
		*out = new(ExternalCloudProviderConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.ExtraManifests != nil {
		in, out := &in.ExtraManifests, &out.ExtraManifests
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.ExtraManifestHeaders != nil {
		in, out := &in.ExtraManifestHeaders, &out.ExtraManifestHeaders
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.ClusterInlineManifests != nil {
		in, out := &in.ClusterInlineManifests, &out.ClusterInlineManifests
		*out = make(ClusterInlineManifests, len(*in))
		copy(*out, *in)
	}
	if in.AdminKubeconfigConfig != nil {
		in, out := &in.AdminKubeconfigConfig, &out.AdminKubeconfigConfig
		*out = new(AdminKubeconfigConfig)
		**out = **in
	}
	if in.AllowSchedulingOnMasters != nil {
		in, out := &in.AllowSchedulingOnMasters, &out.AllowSchedulingOnMasters
		*out = new(bool)
		**out = **in
	}
	if in.AllowSchedulingOnControlPlanes != nil {
		in, out := &in.AllowSchedulingOnControlPlanes, &out.AllowSchedulingOnControlPlanes
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterConfig.
func (in *ClusterConfig) DeepCopy() *ClusterConfig {
	if in == nil {
		return nil
	}
	out := new(ClusterConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterDiscoveryConfig) DeepCopyInto(out *ClusterDiscoveryConfig) {
	*out = *in
	if in.DiscoveryEnabled != nil {
		in, out := &in.DiscoveryEnabled, &out.DiscoveryEnabled
		*out = new(bool)
		**out = **in
	}
	in.DiscoveryRegistries.DeepCopyInto(&out.DiscoveryRegistries)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterDiscoveryConfig.
func (in *ClusterDiscoveryConfig) DeepCopy() *ClusterDiscoveryConfig {
	if in == nil {
		return nil
	}
	out := new(ClusterDiscoveryConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterInlineManifest) DeepCopyInto(out *ClusterInlineManifest) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterInlineManifest.
func (in *ClusterInlineManifest) DeepCopy() *ClusterInlineManifest {
	if in == nil {
		return nil
	}
	out := new(ClusterInlineManifest)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in ClusterInlineManifests) DeepCopyInto(out *ClusterInlineManifests) {
	{
		in := &in
		*out = make(ClusterInlineManifests, len(*in))
		copy(*out, *in)
		return
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterInlineManifests.
func (in ClusterInlineManifests) DeepCopy() ClusterInlineManifests {
	if in == nil {
		return nil
	}
	out := new(ClusterInlineManifests)
	in.DeepCopyInto(out)
	return *out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterNetworkConfig) DeepCopyInto(out *ClusterNetworkConfig) {
	*out = *in
	if in.CNI != nil {
		in, out := &in.CNI, &out.CNI
		*out = new(CNIConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.PodSubnet != nil {
		in, out := &in.PodSubnet, &out.PodSubnet
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.ServiceSubnet != nil {
		in, out := &in.ServiceSubnet, &out.ServiceSubnet
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterNetworkConfig.
func (in *ClusterNetworkConfig) DeepCopy() *ClusterNetworkConfig {
	if in == nil {
		return nil
	}
	out := new(ClusterNetworkConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (c *Config) DeepCopyInto(out *Config) {
	*out = *c
	if c.ConfigDebug != nil {
		in, out := &c.ConfigDebug, &out.ConfigDebug
		*out = new(bool)
		**out = **in
	}
	if c.ConfigPersist != nil {
		in, out := &c.ConfigPersist, &out.ConfigPersist
		*out = new(bool)
		**out = **in
	}
	if c.MachineConfig != nil {
		in, out := &c.MachineConfig, &out.MachineConfig
		*out = new(MachineConfig)
		(*in).DeepCopyInto(*out)
	}
	if c.ClusterConfig != nil {
		in, out := &c.ClusterConfig, &out.ClusterConfig
		*out = new(ClusterConfig)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Config.
func (c *Config) DeepCopy() *Config {
	if c == nil {
		return nil
	}
	out := new(Config)
	c.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ControlPlaneConfig) DeepCopyInto(out *ControlPlaneConfig) {
	*out = *in
	if in.Endpoint != nil {
		in, out := &in.Endpoint, &out.Endpoint
		*out = (*in).DeepCopy()
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ControlPlaneConfig.
func (in *ControlPlaneConfig) DeepCopy() *ControlPlaneConfig {
	if in == nil {
		return nil
	}
	out := new(ControlPlaneConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ControllerManagerConfig) DeepCopyInto(out *ControllerManagerConfig) {
	*out = *in
	if in.ExtraArgsConfig != nil {
		in, out := &in.ExtraArgsConfig, &out.ExtraArgsConfig
		*out = make(Args, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.ExtraVolumesConfig != nil {
		in, out := &in.ExtraVolumesConfig, &out.ExtraVolumesConfig
		*out = make([]VolumeMountConfig, len(*in))
		copy(*out, *in)
	}
	if in.EnvConfig != nil {
		in, out := &in.EnvConfig, &out.EnvConfig
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.ResourcesConfig != nil {
		in, out := &in.ResourcesConfig, &out.ResourcesConfig
		*out = new(ResourcesConfig)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ControllerManagerConfig.
func (in *ControllerManagerConfig) DeepCopy() *ControllerManagerConfig {
	if in == nil {
		return nil
	}
	out := new(ControllerManagerConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CoreDNS) DeepCopyInto(out *CoreDNS) {
	*out = *in
	if in.CoreDNSDisabled != nil {
		in, out := &in.CoreDNSDisabled, &out.CoreDNSDisabled
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CoreDNS.
func (in *CoreDNS) DeepCopy() *CoreDNS {
	if in == nil {
		return nil
	}
	out := new(CoreDNS)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DHCPOptions) DeepCopyInto(out *DHCPOptions) {
	*out = *in
	if in.DHCPIPv4 != nil {
		in, out := &in.DHCPIPv4, &out.DHCPIPv4
		*out = new(bool)
		**out = **in
	}
	if in.DHCPIPv6 != nil {
		in, out := &in.DHCPIPv6, &out.DHCPIPv6
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DHCPOptions.
func (in *DHCPOptions) DeepCopy() *DHCPOptions {
	if in == nil {
		return nil
	}
	out := new(DHCPOptions)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Device) DeepCopyInto(out *Device) {
	*out = *in
	if in.DeviceSelector != nil {
		in, out := &in.DeviceSelector, &out.DeviceSelector
		*out = new(NetworkDeviceSelector)
		(*in).DeepCopyInto(*out)
	}
	if in.DeviceAddresses != nil {
		in, out := &in.DeviceAddresses, &out.DeviceAddresses
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.DeviceRoutes != nil {
		in, out := &in.DeviceRoutes, &out.DeviceRoutes
		*out = make([]*Route, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = new(Route)
				**out = **in
			}
		}
	}
	if in.DeviceBond != nil {
		in, out := &in.DeviceBond, &out.DeviceBond
		*out = new(Bond)
		(*in).DeepCopyInto(*out)
	}
	if in.DeviceBridge != nil {
		in, out := &in.DeviceBridge, &out.DeviceBridge
		*out = new(Bridge)
		(*in).DeepCopyInto(*out)
	}
	if in.DeviceVlans != nil {
		in, out := &in.DeviceVlans, &out.DeviceVlans
		*out = make(VlanList, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = new(Vlan)
				(*in).DeepCopyInto(*out)
			}
		}
	}
	if in.DeviceDHCP != nil {
		in, out := &in.DeviceDHCP, &out.DeviceDHCP
		*out = new(bool)
		**out = **in
	}
	if in.DeviceIgnore != nil {
		in, out := &in.DeviceIgnore, &out.DeviceIgnore
		*out = new(bool)
		**out = **in
	}
	if in.DeviceDummy != nil {
		in, out := &in.DeviceDummy, &out.DeviceDummy
		*out = new(bool)
		**out = **in
	}
	if in.DeviceDHCPOptions != nil {
		in, out := &in.DeviceDHCPOptions, &out.DeviceDHCPOptions
		*out = new(DHCPOptions)
		(*in).DeepCopyInto(*out)
	}
	if in.DeviceWireguardConfig != nil {
		in, out := &in.DeviceWireguardConfig, &out.DeviceWireguardConfig
		*out = new(DeviceWireguardConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.DeviceVIPConfig != nil {
		in, out := &in.DeviceVIPConfig, &out.DeviceVIPConfig
		*out = new(DeviceVIPConfig)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Device.
func (in *Device) DeepCopy() *Device {
	if in == nil {
		return nil
	}
	out := new(Device)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DeviceVIPConfig) DeepCopyInto(out *DeviceVIPConfig) {
	*out = *in
	if in.EquinixMetalConfig != nil {
		in, out := &in.EquinixMetalConfig, &out.EquinixMetalConfig
		*out = new(VIPEquinixMetalConfig)
		**out = **in
	}
	if in.HCloudConfig != nil {
		in, out := &in.HCloudConfig, &out.HCloudConfig
		*out = new(VIPHCloudConfig)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DeviceVIPConfig.
func (in *DeviceVIPConfig) DeepCopy() *DeviceVIPConfig {
	if in == nil {
		return nil
	}
	out := new(DeviceVIPConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DeviceWireguardConfig) DeepCopyInto(out *DeviceWireguardConfig) {
	*out = *in
	if in.WireguardPeers != nil {
		in, out := &in.WireguardPeers, &out.WireguardPeers
		*out = make([]*DeviceWireguardPeer, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = new(DeviceWireguardPeer)
				(*in).DeepCopyInto(*out)
			}
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DeviceWireguardConfig.
func (in *DeviceWireguardConfig) DeepCopy() *DeviceWireguardConfig {
	if in == nil {
		return nil
	}
	out := new(DeviceWireguardConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DeviceWireguardPeer) DeepCopyInto(out *DeviceWireguardPeer) {
	*out = *in
	if in.WireguardAllowedIPs != nil {
		in, out := &in.WireguardAllowedIPs, &out.WireguardAllowedIPs
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DeviceWireguardPeer.
func (in *DeviceWireguardPeer) DeepCopy() *DeviceWireguardPeer {
	if in == nil {
		return nil
	}
	out := new(DeviceWireguardPeer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DiscoveryRegistriesConfig) DeepCopyInto(out *DiscoveryRegistriesConfig) {
	*out = *in
	in.RegistryKubernetes.DeepCopyInto(&out.RegistryKubernetes)
	in.RegistryService.DeepCopyInto(&out.RegistryService)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DiscoveryRegistriesConfig.
func (in *DiscoveryRegistriesConfig) DeepCopy() *DiscoveryRegistriesConfig {
	if in == nil {
		return nil
	}
	out := new(DiscoveryRegistriesConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DiskPartition) DeepCopyInto(out *DiskPartition) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DiskPartition.
func (in *DiskPartition) DeepCopy() *DiskPartition {
	if in == nil {
		return nil
	}
	out := new(DiskPartition)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EncryptionConfig) DeepCopyInto(out *EncryptionConfig) {
	*out = *in
	if in.EncryptionKeys != nil {
		in, out := &in.EncryptionKeys, &out.EncryptionKeys
		*out = make([]*EncryptionKey, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = new(EncryptionKey)
				(*in).DeepCopyInto(*out)
			}
		}
	}
	if in.EncryptionPerfOptions != nil {
		in, out := &in.EncryptionPerfOptions, &out.EncryptionPerfOptions
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EncryptionConfig.
func (in *EncryptionConfig) DeepCopy() *EncryptionConfig {
	if in == nil {
		return nil
	}
	out := new(EncryptionConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EncryptionKey) DeepCopyInto(out *EncryptionKey) {
	*out = *in
	if in.KeyStatic != nil {
		in, out := &in.KeyStatic, &out.KeyStatic
		*out = new(EncryptionKeyStatic)
		**out = **in
	}
	if in.KeyNodeID != nil {
		in, out := &in.KeyNodeID, &out.KeyNodeID
		*out = new(EncryptionKeyNodeID)
		**out = **in
	}
	if in.KeyKMS != nil {
		in, out := &in.KeyKMS, &out.KeyKMS
		*out = new(EncryptionKeyKMS)
		**out = **in
	}
	if in.KeyTPM != nil {
		in, out := &in.KeyTPM, &out.KeyTPM
		*out = new(EncryptionKeyTPM)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EncryptionKey.
func (in *EncryptionKey) DeepCopy() *EncryptionKey {
	if in == nil {
		return nil
	}
	out := new(EncryptionKey)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EncryptionKeyKMS) DeepCopyInto(out *EncryptionKeyKMS) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EncryptionKeyKMS.
func (in *EncryptionKeyKMS) DeepCopy() *EncryptionKeyKMS {
	if in == nil {
		return nil
	}
	out := new(EncryptionKeyKMS)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EncryptionKeyNodeID) DeepCopyInto(out *EncryptionKeyNodeID) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EncryptionKeyNodeID.
func (in *EncryptionKeyNodeID) DeepCopy() *EncryptionKeyNodeID {
	if in == nil {
		return nil
	}
	out := new(EncryptionKeyNodeID)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EncryptionKeyStatic) DeepCopyInto(out *EncryptionKeyStatic) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EncryptionKeyStatic.
func (in *EncryptionKeyStatic) DeepCopy() *EncryptionKeyStatic {
	if in == nil {
		return nil
	}
	out := new(EncryptionKeyStatic)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EncryptionKeyTPM) DeepCopyInto(out *EncryptionKeyTPM) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EncryptionKeyTPM.
func (in *EncryptionKeyTPM) DeepCopy() *EncryptionKeyTPM {
	if in == nil {
		return nil
	}
	out := new(EncryptionKeyTPM)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EtcdConfig) DeepCopyInto(out *EtcdConfig) {
	*out = *in
	if in.RootCA != nil {
		in, out := &in.RootCA, &out.RootCA
		*out = (*in).DeepCopy()
	}
	if in.EtcdExtraArgs != nil {
		in, out := &in.EtcdExtraArgs, &out.EtcdExtraArgs
		*out = make(Args, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.EtcdAdvertisedSubnets != nil {
		in, out := &in.EtcdAdvertisedSubnets, &out.EtcdAdvertisedSubnets
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.EtcdListenSubnets != nil {
		in, out := &in.EtcdListenSubnets, &out.EtcdListenSubnets
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EtcdConfig.
func (in *EtcdConfig) DeepCopy() *EtcdConfig {
	if in == nil {
		return nil
	}
	out := new(EtcdConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ExternalCloudProviderConfig) DeepCopyInto(out *ExternalCloudProviderConfig) {
	*out = *in
	if in.ExternalEnabled != nil {
		in, out := &in.ExternalEnabled, &out.ExternalEnabled
		*out = new(bool)
		**out = **in
	}
	if in.ExternalManifests != nil {
		in, out := &in.ExternalManifests, &out.ExternalManifests
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ExternalCloudProviderConfig.
func (in *ExternalCloudProviderConfig) DeepCopy() *ExternalCloudProviderConfig {
	if in == nil {
		return nil
	}
	out := new(ExternalCloudProviderConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ExtraHost) DeepCopyInto(out *ExtraHost) {
	*out = *in
	if in.HostAliases != nil {
		in, out := &in.HostAliases, &out.HostAliases
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ExtraHost.
func (in *ExtraHost) DeepCopy() *ExtraHost {
	if in == nil {
		return nil
	}
	out := new(ExtraHost)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ExtraMount) DeepCopyInto(out *ExtraMount) {
	*out = *in
	if in.Options != nil {
		in, out := &in.Options, &out.Options
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.UIDMappings != nil {
		in, out := &in.UIDMappings, &out.UIDMappings
		*out = make([]LinuxIDMapping, len(*in))
		copy(*out, *in)
	}
	if in.GIDMappings != nil {
		in, out := &in.GIDMappings, &out.GIDMappings
		*out = make([]LinuxIDMapping, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ExtraMount.
func (in *ExtraMount) DeepCopy() *ExtraMount {
	if in == nil {
		return nil
	}
	out := new(ExtraMount)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FeaturesConfig) DeepCopyInto(out *FeaturesConfig) {
	*out = *in
	if in.RBAC != nil {
		in, out := &in.RBAC, &out.RBAC
		*out = new(bool)
		**out = **in
	}
	if in.StableHostname != nil {
		in, out := &in.StableHostname, &out.StableHostname
		*out = new(bool)
		**out = **in
	}
	if in.KubernetesTalosAPIAccessConfig != nil {
		in, out := &in.KubernetesTalosAPIAccessConfig, &out.KubernetesTalosAPIAccessConfig
		*out = new(KubernetesTalosAPIAccessConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.ApidCheckExtKeyUsage != nil {
		in, out := &in.ApidCheckExtKeyUsage, &out.ApidCheckExtKeyUsage
		*out = new(bool)
		**out = **in
	}
	if in.DiskQuotaSupport != nil {
		in, out := &in.DiskQuotaSupport, &out.DiskQuotaSupport
		*out = new(bool)
		**out = **in
	}
	if in.KubePrismSupport != nil {
		in, out := &in.KubePrismSupport, &out.KubePrismSupport
		*out = new(KubePrism)
		(*in).DeepCopyInto(*out)
	}
	if in.HostDNSSupport != nil {
		in, out := &in.HostDNSSupport, &out.HostDNSSupport
		*out = new(HostDNSConfig)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FeaturesConfig.
func (in *FeaturesConfig) DeepCopy() *FeaturesConfig {
	if in == nil {
		return nil
	}
	out := new(FeaturesConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FlannelCNIConfig) DeepCopyInto(out *FlannelCNIConfig) {
	*out = *in
	if in.FlanneldExtraArgs != nil {
		in, out := &in.FlanneldExtraArgs, &out.FlanneldExtraArgs
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FlannelCNIConfig.
func (in *FlannelCNIConfig) DeepCopy() *FlannelCNIConfig {
	if in == nil {
		return nil
	}
	out := new(FlannelCNIConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *HostDNSConfig) DeepCopyInto(out *HostDNSConfig) {
	*out = *in
	if in.HostDNSEnabled != nil {
		in, out := &in.HostDNSEnabled, &out.HostDNSEnabled
		*out = new(bool)
		**out = **in
	}
	if in.HostDNSForwardKubeDNSToHost != nil {
		in, out := &in.HostDNSForwardKubeDNSToHost, &out.HostDNSForwardKubeDNSToHost
		*out = new(bool)
		**out = **in
	}
	if in.HostDNSResolveMemberNames != nil {
		in, out := &in.HostDNSResolveMemberNames, &out.HostDNSResolveMemberNames
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new HostDNSConfig.
func (in *HostDNSConfig) DeepCopy() *HostDNSConfig {
	if in == nil {
		return nil
	}
	out := new(HostDNSConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IfaceSelector) DeepCopyInto(out *IfaceSelector) {
	*out = *in
	if in.Name != nil {
		in, out := &in.Name, &out.Name
		*out = new(string)
		**out = **in
	}
	if in.Selector != nil {
		in, out := &in.Selector, &out.Selector
		*out = new(NetworkDeviceSelector)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IfaceSelector.
func (in *IfaceSelector) DeepCopy() *IfaceSelector {
	if in == nil {
		return nil
	}
	out := new(IfaceSelector)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *InstallConfig) DeepCopyInto(out *InstallConfig) {
	*out = *in
	if in.InstallDiskSelector != nil {
		in, out := &in.InstallDiskSelector, &out.InstallDiskSelector
		*out = new(InstallDiskSelector)
		(*in).DeepCopyInto(*out)
	}
	if in.InstallExtraKernelArgs != nil {
		in, out := &in.InstallExtraKernelArgs, &out.InstallExtraKernelArgs
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.InstallExtensions != nil {
		in, out := &in.InstallExtensions, &out.InstallExtensions
		*out = make([]InstallExtensionConfig, len(*in))
		copy(*out, *in)
	}
	if in.InstallBootloader != nil {
		in, out := &in.InstallBootloader, &out.InstallBootloader
		*out = new(bool)
		**out = **in
	}
	if in.InstallWipe != nil {
		in, out := &in.InstallWipe, &out.InstallWipe
		*out = new(bool)
		**out = **in
	}
	if in.InstallLegacyBIOSSupport != nil {
		in, out := &in.InstallLegacyBIOSSupport, &out.InstallLegacyBIOSSupport
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new InstallConfig.
func (in *InstallConfig) DeepCopy() *InstallConfig {
	if in == nil {
		return nil
	}
	out := new(InstallConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *InstallDiskSelector) DeepCopyInto(out *InstallDiskSelector) {
	*out = *in
	if in.Size != nil {
		in, out := &in.Size, &out.Size
		*out = new(InstallDiskSizeMatcher)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new InstallDiskSelector.
func (in *InstallDiskSelector) DeepCopy() *InstallDiskSelector {
	if in == nil {
		return nil
	}
	out := new(InstallDiskSelector)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *InstallDiskSizeMatchData) DeepCopyInto(out *InstallDiskSizeMatchData) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new InstallDiskSizeMatchData.
func (in *InstallDiskSizeMatchData) DeepCopy() *InstallDiskSizeMatchData {
	if in == nil {
		return nil
	}
	out := new(InstallDiskSizeMatchData)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *InstallDiskSizeMatcher) DeepCopyInto(out *InstallDiskSizeMatcher) {
	*out = *in
	out.MatchData = in.MatchData
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new InstallDiskSizeMatcher.
func (in *InstallDiskSizeMatcher) DeepCopy() *InstallDiskSizeMatcher {
	if in == nil {
		return nil
	}
	out := new(InstallDiskSizeMatcher)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *InstallExtensionConfig) DeepCopyInto(out *InstallExtensionConfig) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new InstallExtensionConfig.
func (in *InstallExtensionConfig) DeepCopy() *InstallExtensionConfig {
	if in == nil {
		return nil
	}
	out := new(InstallExtensionConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KernelConfig) DeepCopyInto(out *KernelConfig) {
	*out = *in
	if in.KernelModules != nil {
		in, out := &in.KernelModules, &out.KernelModules
		*out = make([]*KernelModuleConfig, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = new(KernelModuleConfig)
				(*in).DeepCopyInto(*out)
			}
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KernelConfig.
func (in *KernelConfig) DeepCopy() *KernelConfig {
	if in == nil {
		return nil
	}
	out := new(KernelConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KernelModuleConfig) DeepCopyInto(out *KernelModuleConfig) {
	*out = *in
	if in.ModuleParameters != nil {
		in, out := &in.ModuleParameters, &out.ModuleParameters
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KernelModuleConfig.
func (in *KernelModuleConfig) DeepCopy() *KernelModuleConfig {
	if in == nil {
		return nil
	}
	out := new(KernelModuleConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubePrism) DeepCopyInto(out *KubePrism) {
	*out = *in
	if in.ServerEnabled != nil {
		in, out := &in.ServerEnabled, &out.ServerEnabled
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubePrism.
func (in *KubePrism) DeepCopy() *KubePrism {
	if in == nil {
		return nil
	}
	out := new(KubePrism)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubeSpanFilters) DeepCopyInto(out *KubeSpanFilters) {
	*out = *in
	if in.KubeSpanFiltersEndpoints != nil {
		in, out := &in.KubeSpanFiltersEndpoints, &out.KubeSpanFiltersEndpoints
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubeSpanFilters.
func (in *KubeSpanFilters) DeepCopy() *KubeSpanFilters {
	if in == nil {
		return nil
	}
	out := new(KubeSpanFilters)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubeletConfig) DeepCopyInto(out *KubeletConfig) {
	*out = *in
	if in.KubeletClusterDNS != nil {
		in, out := &in.KubeletClusterDNS, &out.KubeletClusterDNS
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.KubeletExtraArgs != nil {
		in, out := &in.KubeletExtraArgs, &out.KubeletExtraArgs
		*out = make(Args, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.KubeletExtraMounts != nil {
		in, out := &in.KubeletExtraMounts, &out.KubeletExtraMounts
		*out = make([]ExtraMount, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	in.KubeletExtraConfig.DeepCopyInto(&out.KubeletExtraConfig)
	in.KubeletCredentialProviderConfig.DeepCopyInto(&out.KubeletCredentialProviderConfig)
	if in.KubeletDefaultRuntimeSeccompProfileEnabled != nil {
		in, out := &in.KubeletDefaultRuntimeSeccompProfileEnabled, &out.KubeletDefaultRuntimeSeccompProfileEnabled
		*out = new(bool)
		**out = **in
	}
	if in.KubeletRegisterWithFQDN != nil {
		in, out := &in.KubeletRegisterWithFQDN, &out.KubeletRegisterWithFQDN
		*out = new(bool)
		**out = **in
	}
	if in.KubeletNodeIP != nil {
		in, out := &in.KubeletNodeIP, &out.KubeletNodeIP
		*out = new(KubeletNodeIPConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.KubeletSkipNodeRegistration != nil {
		in, out := &in.KubeletSkipNodeRegistration, &out.KubeletSkipNodeRegistration
		*out = new(bool)
		**out = **in
	}
	if in.KubeletDisableManifestsDirectory != nil {
		in, out := &in.KubeletDisableManifestsDirectory, &out.KubeletDisableManifestsDirectory
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubeletConfig.
func (in *KubeletConfig) DeepCopy() *KubeletConfig {
	if in == nil {
		return nil
	}
	out := new(KubeletConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubeletNodeIPConfig) DeepCopyInto(out *KubeletNodeIPConfig) {
	*out = *in
	if in.KubeletNodeIPValidSubnets != nil {
		in, out := &in.KubeletNodeIPValidSubnets, &out.KubeletNodeIPValidSubnets
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubeletNodeIPConfig.
func (in *KubeletNodeIPConfig) DeepCopy() *KubeletNodeIPConfig {
	if in == nil {
		return nil
	}
	out := new(KubeletNodeIPConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubernetesTalosAPIAccessConfig) DeepCopyInto(out *KubernetesTalosAPIAccessConfig) {
	*out = *in
	if in.AccessEnabled != nil {
		in, out := &in.AccessEnabled, &out.AccessEnabled
		*out = new(bool)
		**out = **in
	}
	if in.AccessAllowedRoles != nil {
		in, out := &in.AccessAllowedRoles, &out.AccessAllowedRoles
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.AccessAllowedKubernetesNamespaces != nil {
		in, out := &in.AccessAllowedKubernetesNamespaces, &out.AccessAllowedKubernetesNamespaces
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubernetesTalosAPIAccessConfig.
func (in *KubernetesTalosAPIAccessConfig) DeepCopy() *KubernetesTalosAPIAccessConfig {
	if in == nil {
		return nil
	}
	out := new(KubernetesTalosAPIAccessConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LinuxIDMapping) DeepCopyInto(out *LinuxIDMapping) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LinuxIDMapping.
func (in *LinuxIDMapping) DeepCopy() *LinuxIDMapping {
	if in == nil {
		return nil
	}
	out := new(LinuxIDMapping)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LoggingConfig) DeepCopyInto(out *LoggingConfig) {
	*out = *in
	if in.LoggingDestinations != nil {
		in, out := &in.LoggingDestinations, &out.LoggingDestinations
		*out = make([]LoggingDestination, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LoggingConfig.
func (in *LoggingConfig) DeepCopy() *LoggingConfig {
	if in == nil {
		return nil
	}
	out := new(LoggingConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LoggingDestination) DeepCopyInto(out *LoggingDestination) {
	*out = *in
	if in.LoggingEndpoint != nil {
		in, out := &in.LoggingEndpoint, &out.LoggingEndpoint
		*out = (*in).DeepCopy()
	}
	if in.LoggingExtraTags != nil {
		in, out := &in.LoggingExtraTags, &out.LoggingExtraTags
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LoggingDestination.
func (in *LoggingDestination) DeepCopy() *LoggingDestination {
	if in == nil {
		return nil
	}
	out := new(LoggingDestination)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MachineConfig) DeepCopyInto(out *MachineConfig) {
	*out = *in
	if in.MachineCA != nil {
		in, out := &in.MachineCA, &out.MachineCA
		*out = (*in).DeepCopy()
	}
	if in.MachineAcceptedCAs != nil {
		in, out := &in.MachineAcceptedCAs, &out.MachineAcceptedCAs
		*out = make([]*x509.PEMEncodedCertificate, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = (*in).DeepCopy()
			}
		}
	}
	if in.MachineCertSANs != nil {
		in, out := &in.MachineCertSANs, &out.MachineCertSANs
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.MachineControlPlane != nil {
		in, out := &in.MachineControlPlane, &out.MachineControlPlane
		*out = new(MachineControlPlaneConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.MachineKubelet != nil {
		in, out := &in.MachineKubelet, &out.MachineKubelet
		*out = new(KubeletConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.MachinePods != nil {
		in, out := &in.MachinePods, &out.MachinePods
		*out = make([]Unstructured, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.MachineNetwork != nil {
		in, out := &in.MachineNetwork, &out.MachineNetwork
		*out = new(NetworkConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.MachineDisks != nil {
		in, out := &in.MachineDisks, &out.MachineDisks
		*out = make([]*MachineDisk, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = new(MachineDisk)
				(*in).DeepCopyInto(*out)
			}
		}
	}
	if in.MachineInstall != nil {
		in, out := &in.MachineInstall, &out.MachineInstall
		*out = new(InstallConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.MachineFiles != nil {
		in, out := &in.MachineFiles, &out.MachineFiles
		*out = make([]*MachineFile, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = new(MachineFile)
				**out = **in
			}
		}
	}
	if in.MachineEnv != nil {
		in, out := &in.MachineEnv, &out.MachineEnv
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.MachineTime != nil {
		in, out := &in.MachineTime, &out.MachineTime
		*out = new(TimeConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.MachineSysctls != nil {
		in, out := &in.MachineSysctls, &out.MachineSysctls
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.MachineSysfs != nil {
		in, out := &in.MachineSysfs, &out.MachineSysfs
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	in.MachineRegistries.DeepCopyInto(&out.MachineRegistries)
	if in.MachineSystemDiskEncryption != nil {
		in, out := &in.MachineSystemDiskEncryption, &out.MachineSystemDiskEncryption
		*out = new(SystemDiskEncryptionConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.MachineFeatures != nil {
		in, out := &in.MachineFeatures, &out.MachineFeatures
		*out = new(FeaturesConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.MachineUdev != nil {
		in, out := &in.MachineUdev, &out.MachineUdev
		*out = new(UdevConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.MachineLogging != nil {
		in, out := &in.MachineLogging, &out.MachineLogging
		*out = new(LoggingConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.MachineKernel != nil {
		in, out := &in.MachineKernel, &out.MachineKernel
		*out = new(KernelConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.MachineSeccompProfiles != nil {
		in, out := &in.MachineSeccompProfiles, &out.MachineSeccompProfiles
		*out = make([]*MachineSeccompProfile, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = new(MachineSeccompProfile)
				(*in).DeepCopyInto(*out)
			}
		}
	}
	if in.MachineNodeLabels != nil {
		in, out := &in.MachineNodeLabels, &out.MachineNodeLabels
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.MachineNodeTaints != nil {
		in, out := &in.MachineNodeTaints, &out.MachineNodeTaints
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MachineConfig.
func (in *MachineConfig) DeepCopy() *MachineConfig {
	if in == nil {
		return nil
	}
	out := new(MachineConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MachineControlPlaneConfig) DeepCopyInto(out *MachineControlPlaneConfig) {
	*out = *in
	if in.MachineControllerManager != nil {
		in, out := &in.MachineControllerManager, &out.MachineControllerManager
		*out = new(MachineControllerManagerConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.MachineScheduler != nil {
		in, out := &in.MachineScheduler, &out.MachineScheduler
		*out = new(MachineSchedulerConfig)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MachineControlPlaneConfig.
func (in *MachineControlPlaneConfig) DeepCopy() *MachineControlPlaneConfig {
	if in == nil {
		return nil
	}
	out := new(MachineControlPlaneConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MachineControllerManagerConfig) DeepCopyInto(out *MachineControllerManagerConfig) {
	*out = *in
	if in.MachineControllerManagerDisabled != nil {
		in, out := &in.MachineControllerManagerDisabled, &out.MachineControllerManagerDisabled
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MachineControllerManagerConfig.
func (in *MachineControllerManagerConfig) DeepCopy() *MachineControllerManagerConfig {
	if in == nil {
		return nil
	}
	out := new(MachineControllerManagerConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MachineDisk) DeepCopyInto(out *MachineDisk) {
	*out = *in
	if in.DiskPartitions != nil {
		in, out := &in.DiskPartitions, &out.DiskPartitions
		*out = make([]*DiskPartition, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = new(DiskPartition)
				**out = **in
			}
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MachineDisk.
func (in *MachineDisk) DeepCopy() *MachineDisk {
	if in == nil {
		return nil
	}
	out := new(MachineDisk)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MachineFile) DeepCopyInto(out *MachineFile) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MachineFile.
func (in *MachineFile) DeepCopy() *MachineFile {
	if in == nil {
		return nil
	}
	out := new(MachineFile)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MachineSchedulerConfig) DeepCopyInto(out *MachineSchedulerConfig) {
	*out = *in
	if in.MachineSchedulerDisabled != nil {
		in, out := &in.MachineSchedulerDisabled, &out.MachineSchedulerDisabled
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MachineSchedulerConfig.
func (in *MachineSchedulerConfig) DeepCopy() *MachineSchedulerConfig {
	if in == nil {
		return nil
	}
	out := new(MachineSchedulerConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MachineSeccompProfile) DeepCopyInto(out *MachineSeccompProfile) {
	*out = *in
	in.MachineSeccompProfileValue.DeepCopyInto(&out.MachineSeccompProfileValue)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MachineSeccompProfile.
func (in *MachineSeccompProfile) DeepCopy() *MachineSeccompProfile {
	if in == nil {
		return nil
	}
	out := new(MachineSeccompProfile)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NetworkConfig) DeepCopyInto(out *NetworkConfig) {
	*out = *in
	if in.NetworkInterfaces != nil {
		in, out := &in.NetworkInterfaces, &out.NetworkInterfaces
		*out = make(NetworkDeviceList, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = new(Device)
				(*in).DeepCopyInto(*out)
			}
		}
	}
	if in.NameServers != nil {
		in, out := &in.NameServers, &out.NameServers
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.ExtraHostEntries != nil {
		in, out := &in.ExtraHostEntries, &out.ExtraHostEntries
		*out = make([]*ExtraHost, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = new(ExtraHost)
				(*in).DeepCopyInto(*out)
			}
		}
	}
	if in.NetworkKubeSpan != nil {
		in, out := &in.NetworkKubeSpan, &out.NetworkKubeSpan
		*out = new(NetworkKubeSpan)
		(*in).DeepCopyInto(*out)
	}
	if in.NetworkDisableSearchDomain != nil {
		in, out := &in.NetworkDisableSearchDomain, &out.NetworkDisableSearchDomain
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NetworkConfig.
func (in *NetworkConfig) DeepCopy() *NetworkConfig {
	if in == nil {
		return nil
	}
	out := new(NetworkConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in NetworkDeviceList) DeepCopyInto(out *NetworkDeviceList) {
	{
		in := &in
		*out = make(NetworkDeviceList, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = new(Device)
				(*in).DeepCopyInto(*out)
			}
		}
		return
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NetworkDeviceList.
func (in NetworkDeviceList) DeepCopy() NetworkDeviceList {
	if in == nil {
		return nil
	}
	out := new(NetworkDeviceList)
	in.DeepCopyInto(out)
	return *out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NetworkDeviceSelector) DeepCopyInto(out *NetworkDeviceSelector) {
	*out = *in
	if in.NetworkDevicePhysical != nil {
		in, out := &in.NetworkDevicePhysical, &out.NetworkDevicePhysical
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NetworkDeviceSelector.
func (in *NetworkDeviceSelector) DeepCopy() *NetworkDeviceSelector {
	if in == nil {
		return nil
	}
	out := new(NetworkDeviceSelector)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NetworkKubeSpan) DeepCopyInto(out *NetworkKubeSpan) {
	*out = *in
	if in.KubeSpanEnabled != nil {
		in, out := &in.KubeSpanEnabled, &out.KubeSpanEnabled
		*out = new(bool)
		**out = **in
	}
	if in.KubeSpanAdvertiseKubernetesNetworks != nil {
		in, out := &in.KubeSpanAdvertiseKubernetesNetworks, &out.KubeSpanAdvertiseKubernetesNetworks
		*out = new(bool)
		**out = **in
	}
	if in.KubeSpanAllowDownPeerBypass != nil {
		in, out := &in.KubeSpanAllowDownPeerBypass, &out.KubeSpanAllowDownPeerBypass
		*out = new(bool)
		**out = **in
	}
	if in.KubeSpanHarvestExtraEndpoints != nil {
		in, out := &in.KubeSpanHarvestExtraEndpoints, &out.KubeSpanHarvestExtraEndpoints
		*out = new(bool)
		**out = **in
	}
	if in.KubeSpanMTU != nil {
		in, out := &in.KubeSpanMTU, &out.KubeSpanMTU
		*out = new(uint32)
		**out = **in
	}
	if in.KubeSpanFilters != nil {
		in, out := &in.KubeSpanFilters, &out.KubeSpanFilters
		*out = new(KubeSpanFilters)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NetworkKubeSpan.
func (in *NetworkKubeSpan) DeepCopy() *NetworkKubeSpan {
	if in == nil {
		return nil
	}
	out := new(NetworkKubeSpan)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PodCheckpointer) DeepCopyInto(out *PodCheckpointer) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PodCheckpointer.
func (in *PodCheckpointer) DeepCopy() *PodCheckpointer {
	if in == nil {
		return nil
	}
	out := new(PodCheckpointer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ProxyConfig) DeepCopyInto(out *ProxyConfig) {
	*out = *in
	if in.Disabled != nil {
		in, out := &in.Disabled, &out.Disabled
		*out = new(bool)
		**out = **in
	}
	if in.ExtraArgsConfig != nil {
		in, out := &in.ExtraArgsConfig, &out.ExtraArgsConfig
		*out = make(Args, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ProxyConfig.
func (in *ProxyConfig) DeepCopy() *ProxyConfig {
	if in == nil {
		return nil
	}
	out := new(ProxyConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RegistriesConfig) DeepCopyInto(out *RegistriesConfig) {
	*out = *in
	if in.RegistryMirrors != nil {
		in, out := &in.RegistryMirrors, &out.RegistryMirrors
		*out = make(map[string]*RegistryMirrorConfig, len(*in))
		for key, val := range *in {
			var outVal *RegistryMirrorConfig
			if val == nil {
				(*out)[key] = nil
			} else {
				in, out := &val, &outVal
				*out = new(RegistryMirrorConfig)
				(*in).DeepCopyInto(*out)
			}
			(*out)[key] = outVal
		}
	}
	if in.RegistryConfig != nil {
		in, out := &in.RegistryConfig, &out.RegistryConfig
		*out = make(map[string]*RegistryConfig, len(*in))
		for key, val := range *in {
			var outVal *RegistryConfig
			if val == nil {
				(*out)[key] = nil
			} else {
				in, out := &val, &outVal
				*out = new(RegistryConfig)
				(*in).DeepCopyInto(*out)
			}
			(*out)[key] = outVal
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RegistriesConfig.
func (in *RegistriesConfig) DeepCopy() *RegistriesConfig {
	if in == nil {
		return nil
	}
	out := new(RegistriesConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RegistryAuthConfig) DeepCopyInto(out *RegistryAuthConfig) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RegistryAuthConfig.
func (in *RegistryAuthConfig) DeepCopy() *RegistryAuthConfig {
	if in == nil {
		return nil
	}
	out := new(RegistryAuthConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RegistryConfig) DeepCopyInto(out *RegistryConfig) {
	*out = *in
	if in.RegistryTLS != nil {
		in, out := &in.RegistryTLS, &out.RegistryTLS
		*out = new(RegistryTLSConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.RegistryAuth != nil {
		in, out := &in.RegistryAuth, &out.RegistryAuth
		*out = new(RegistryAuthConfig)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RegistryConfig.
func (in *RegistryConfig) DeepCopy() *RegistryConfig {
	if in == nil {
		return nil
	}
	out := new(RegistryConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RegistryKubernetesConfig) DeepCopyInto(out *RegistryKubernetesConfig) {
	*out = *in
	if in.RegistryDisabled != nil {
		in, out := &in.RegistryDisabled, &out.RegistryDisabled
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RegistryKubernetesConfig.
func (in *RegistryKubernetesConfig) DeepCopy() *RegistryKubernetesConfig {
	if in == nil {
		return nil
	}
	out := new(RegistryKubernetesConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RegistryMirrorConfig) DeepCopyInto(out *RegistryMirrorConfig) {
	*out = *in
	if in.MirrorEndpoints != nil {
		in, out := &in.MirrorEndpoints, &out.MirrorEndpoints
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.MirrorOverridePath != nil {
		in, out := &in.MirrorOverridePath, &out.MirrorOverridePath
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RegistryMirrorConfig.
func (in *RegistryMirrorConfig) DeepCopy() *RegistryMirrorConfig {
	if in == nil {
		return nil
	}
	out := new(RegistryMirrorConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RegistryServiceConfig) DeepCopyInto(out *RegistryServiceConfig) {
	*out = *in
	if in.RegistryDisabled != nil {
		in, out := &in.RegistryDisabled, &out.RegistryDisabled
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RegistryServiceConfig.
func (in *RegistryServiceConfig) DeepCopy() *RegistryServiceConfig {
	if in == nil {
		return nil
	}
	out := new(RegistryServiceConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RegistryTLSConfig) DeepCopyInto(out *RegistryTLSConfig) {
	*out = *in
	if in.TLSClientIdentity != nil {
		in, out := &in.TLSClientIdentity, &out.TLSClientIdentity
		*out = (*in).DeepCopy()
	}
	if in.TLSCA != nil {
		in, out := &in.TLSCA, &out.TLSCA
		*out = make(Base64Bytes, len(*in))
		copy(*out, *in)
	}
	if in.TLSInsecureSkipVerify != nil {
		in, out := &in.TLSInsecureSkipVerify, &out.TLSInsecureSkipVerify
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RegistryTLSConfig.
func (in *RegistryTLSConfig) DeepCopy() *RegistryTLSConfig {
	if in == nil {
		return nil
	}
	out := new(RegistryTLSConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ResourcesConfig) DeepCopyInto(out *ResourcesConfig) {
	*out = *in
	in.Requests.DeepCopyInto(&out.Requests)
	in.Limits.DeepCopyInto(&out.Limits)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ResourcesConfig.
func (in *ResourcesConfig) DeepCopy() *ResourcesConfig {
	if in == nil {
		return nil
	}
	out := new(ResourcesConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Route) DeepCopyInto(out *Route) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Route.
func (in *Route) DeepCopy() *Route {
	if in == nil {
		return nil
	}
	out := new(Route)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *STP) DeepCopyInto(out *STP) {
	*out = *in
	if in.STPEnabled != nil {
		in, out := &in.STPEnabled, &out.STPEnabled
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new STP.
func (in *STP) DeepCopy() *STP {
	if in == nil {
		return nil
	}
	out := new(STP)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SchedulerConfig) DeepCopyInto(out *SchedulerConfig) {
	*out = *in
	if in.ExtraArgsConfig != nil {
		in, out := &in.ExtraArgsConfig, &out.ExtraArgsConfig
		*out = make(Args, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.ExtraVolumesConfig != nil {
		in, out := &in.ExtraVolumesConfig, &out.ExtraVolumesConfig
		*out = make([]VolumeMountConfig, len(*in))
		copy(*out, *in)
	}
	if in.EnvConfig != nil {
		in, out := &in.EnvConfig, &out.EnvConfig
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.ResourcesConfig != nil {
		in, out := &in.ResourcesConfig, &out.ResourcesConfig
		*out = new(ResourcesConfig)
		(*in).DeepCopyInto(*out)
	}
	in.SchedulerConfig.DeepCopyInto(&out.SchedulerConfig)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SchedulerConfig.
func (in *SchedulerConfig) DeepCopy() *SchedulerConfig {
	if in == nil {
		return nil
	}
	out := new(SchedulerConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SystemDiskEncryptionConfig) DeepCopyInto(out *SystemDiskEncryptionConfig) {
	*out = *in
	if in.StatePartition != nil {
		in, out := &in.StatePartition, &out.StatePartition
		*out = new(EncryptionConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.EphemeralPartition != nil {
		in, out := &in.EphemeralPartition, &out.EphemeralPartition
		*out = new(EncryptionConfig)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SystemDiskEncryptionConfig.
func (in *SystemDiskEncryptionConfig) DeepCopy() *SystemDiskEncryptionConfig {
	if in == nil {
		return nil
	}
	out := new(SystemDiskEncryptionConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TimeConfig) DeepCopyInto(out *TimeConfig) {
	*out = *in
	if in.TimeDisabled != nil {
		in, out := &in.TimeDisabled, &out.TimeDisabled
		*out = new(bool)
		**out = **in
	}
	if in.TimeServers != nil {
		in, out := &in.TimeServers, &out.TimeServers
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TimeConfig.
func (in *TimeConfig) DeepCopy() *TimeConfig {
	if in == nil {
		return nil
	}
	out := new(TimeConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UdevConfig) DeepCopyInto(out *UdevConfig) {
	*out = *in
	if in.UdevRules != nil {
		in, out := &in.UdevRules, &out.UdevRules
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UdevConfig.
func (in *UdevConfig) DeepCopy() *UdevConfig {
	if in == nil {
		return nil
	}
	out := new(UdevConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Unstructured) DeepCopyInto(out *Unstructured) {
	clone := in.DeepCopy()
	*out = *clone
	return
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VIPEquinixMetalConfig) DeepCopyInto(out *VIPEquinixMetalConfig) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VIPEquinixMetalConfig.
func (in *VIPEquinixMetalConfig) DeepCopy() *VIPEquinixMetalConfig {
	if in == nil {
		return nil
	}
	out := new(VIPEquinixMetalConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VIPHCloudConfig) DeepCopyInto(out *VIPHCloudConfig) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VIPHCloudConfig.
func (in *VIPHCloudConfig) DeepCopy() *VIPHCloudConfig {
	if in == nil {
		return nil
	}
	out := new(VIPHCloudConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Vlan) DeepCopyInto(out *Vlan) {
	*out = *in
	if in.VlanAddresses != nil {
		in, out := &in.VlanAddresses, &out.VlanAddresses
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.VlanRoutes != nil {
		in, out := &in.VlanRoutes, &out.VlanRoutes
		*out = make([]*Route, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = new(Route)
				**out = **in
			}
		}
	}
	if in.VlanDHCP != nil {
		in, out := &in.VlanDHCP, &out.VlanDHCP
		*out = new(bool)
		**out = **in
	}
	if in.VlanVIP != nil {
		in, out := &in.VlanVIP, &out.VlanVIP
		*out = new(DeviceVIPConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.VlanDHCPOptions != nil {
		in, out := &in.VlanDHCPOptions, &out.VlanDHCPOptions
		*out = new(DHCPOptions)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Vlan.
func (in *Vlan) DeepCopy() *Vlan {
	if in == nil {
		return nil
	}
	out := new(Vlan)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in VlanList) DeepCopyInto(out *VlanList) {
	{
		in := &in
		*out = make(VlanList, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = new(Vlan)
				(*in).DeepCopyInto(*out)
			}
		}
		return
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VlanList.
func (in VlanList) DeepCopy() VlanList {
	if in == nil {
		return nil
	}
	out := new(VlanList)
	in.DeepCopyInto(out)
	return *out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VolumeMountConfig) DeepCopyInto(out *VolumeMountConfig) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VolumeMountConfig.
func (in *VolumeMountConfig) DeepCopy() *VolumeMountConfig {
	if in == nil {
		return nil
	}
	out := new(VolumeMountConfig)
	in.DeepCopyInto(out)
	return out
}
