/* Sidebar.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Sidebar.vala, do not modify */

/*
 * Copyright 2011-2023 elementary, Inc (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street - Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "notifications.h"
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gdesktopappinfo.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <adwaita.h>
#include <granite-7.h>
#include <gee.h>

#define WIDGETS_SIDEBAR_FALLBACK_APP_ID "gala-other.desktop"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	WIDGETS_SIDEBAR_0_PROPERTY,
	WIDGETS_SIDEBAR_NUM_PROPERTIES
};
static GParamSpec* widgets_sidebar_properties[WIDGETS_SIDEBAR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;

struct _WidgetsSidebarPrivate {
	GtkSearchEntry* search_entry;
};

struct _Block1Data {
	int _ref_count_;
	WidgetsSidebar* self;
	GtkRevealer* search_revealer;
	GtkListBox* app_list;
};

static gint WidgetsSidebar_private_offset;
static gpointer widgets_sidebar_parent_class = NULL;

static gboolean widgets_sidebar_filter_function (WidgetsSidebar* self,
                                          GtkListBoxRow* row);
static gint widgets_sidebar_sort_func (WidgetsSidebar* self,
                                GtkListBoxRow* row1,
                                GtkListBoxRow* row2);
static void widgets_sidebar_show_row (WidgetsSidebar* self,
                               GtkListBoxRow* row);
static GObject * widgets_sidebar_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean _widgets_sidebar_filter_function_gtk_list_box_filter_func (GtkListBoxRow* row,
                                                                    gpointer self);
static gint _widgets_sidebar_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                        GtkListBoxRow* row2,
                                                        gpointer self);
static void _widgets_sidebar_show_row_gtk_list_box_row_selected (GtkListBox* _sender,
                                                          GtkListBoxRow* row,
                                                          gpointer self);
static void _widgets_sidebar___lambda5_ (Block1Data* _data1_);
static void __widgets_sidebar___lambda5__gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                   gpointer self);
static void _widgets_sidebar___lambda6_ (Block1Data* _data1_);
static void __widgets_sidebar___lambda6__g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self);
static gboolean _widgets_sidebar___lambda7_ (Block1Data* _data1_,
                                      GeeMapEntry* entry);
static gboolean __widgets_sidebar___lambda7__gee_forall_func (gpointer g,
                                                       gpointer self);
static void widgets_sidebar_finalize (GObject * obj);
static GType widgets_sidebar_get_type_once (void);

static inline gpointer
widgets_sidebar_get_instance_private (WidgetsSidebar* self)
{
	return G_STRUCT_MEMBER_P (self, WidgetsSidebar_private_offset);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
widgets_sidebar_filter_function (WidgetsSidebar* self,
                                 GtkListBoxRow* row)
{
	GtkSearchEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (row != NULL, FALSE);
	_tmp0_ = self->priv->search_entry;
	_tmp1_ = gtk_editable_get_text ((GtkEditable*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (g_strcmp0 (_tmp2_, "") != 0) {
		gchar* search_term = NULL;
		GtkSearchEntry* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* row_name = NULL;
		BackendApp* _tmp7_;
		BackendApp* _tmp8_;
		GDesktopAppInfo* _tmp9_;
		GDesktopAppInfo* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		_tmp3_ = self->priv->search_entry;
		_tmp4_ = gtk_editable_get_text ((GtkEditable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_utf8_strdown (_tmp5_, (gssize) -1);
		search_term = _tmp6_;
		_tmp7_ = widgets_app_entry_get_app (G_TYPE_CHECK_INSTANCE_CAST (row, WIDGETS_TYPE_APP_ENTRY, WidgetsAppEntry));
		_tmp8_ = _tmp7_;
		_tmp9_ = backend_app_get_app_info (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_app_info_get_display_name ((GAppInfo*) _tmp10_);
		_tmp12_ = g_utf8_strdown (_tmp11_, (gssize) -1);
		row_name = _tmp12_;
		_tmp13_ = row_name;
		_tmp14_ = search_term;
		result = string_contains (_tmp13_, _tmp14_);
		_g_free0 (row_name);
		_g_free0 (search_term);
		return result;
	}
	result = TRUE;
	return result;
}

static gint
widgets_sidebar_sort_func (WidgetsSidebar* self,
                           GtkListBoxRow* row1,
                           GtkListBoxRow* row2)
{
	gboolean _tmp0_ = FALSE;
	BackendApp* _tmp1_;
	BackendApp* _tmp2_;
	GDesktopAppInfo* _tmp3_;
	GDesktopAppInfo* _tmp4_;
	const gchar* _tmp5_;
	gchar* row_name1 = NULL;
	BackendApp* _tmp11_;
	BackendApp* _tmp12_;
	GDesktopAppInfo* _tmp13_;
	GDesktopAppInfo* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* row_name2 = NULL;
	BackendApp* _tmp17_;
	BackendApp* _tmp18_;
	GDesktopAppInfo* _tmp19_;
	GDesktopAppInfo* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gint order = 0;
	GCompareFunc _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (row1 != NULL, 0);
	g_return_val_if_fail (row2 != NULL, 0);
	if (WIDGETS_IS_APP_ENTRY (row1)) {
		_tmp0_ = WIDGETS_IS_APP_ENTRY (row2);
	} else {
		_tmp0_ = FALSE;
	}
	if (!_tmp0_) {
		result = 0;
		return result;
	}
	_tmp1_ = widgets_app_entry_get_app (G_TYPE_CHECK_INSTANCE_CAST (row1, WIDGETS_TYPE_APP_ENTRY, WidgetsAppEntry));
	_tmp2_ = _tmp1_;
	_tmp3_ = backend_app_get_app_info (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_app_info_get_id ((GAppInfo*) _tmp4_);
	if (g_strcmp0 (_tmp5_, WIDGETS_SIDEBAR_FALLBACK_APP_ID) == 0) {
		result = 1;
		return result;
	} else {
		BackendApp* _tmp6_;
		BackendApp* _tmp7_;
		GDesktopAppInfo* _tmp8_;
		GDesktopAppInfo* _tmp9_;
		const gchar* _tmp10_;
		_tmp6_ = widgets_app_entry_get_app (G_TYPE_CHECK_INSTANCE_CAST (row2, WIDGETS_TYPE_APP_ENTRY, WidgetsAppEntry));
		_tmp7_ = _tmp6_;
		_tmp8_ = backend_app_get_app_info (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_app_info_get_id ((GAppInfo*) _tmp9_);
		if (g_strcmp0 (_tmp10_, WIDGETS_SIDEBAR_FALLBACK_APP_ID) == 0) {
			result = -1;
			return result;
		}
	}
	_tmp11_ = widgets_app_entry_get_app (G_TYPE_CHECK_INSTANCE_CAST (row1, WIDGETS_TYPE_APP_ENTRY, WidgetsAppEntry));
	_tmp12_ = _tmp11_;
	_tmp13_ = backend_app_get_app_info (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_app_info_get_display_name ((GAppInfo*) _tmp14_);
	_tmp16_ = g_strdup (_tmp15_);
	row_name1 = _tmp16_;
	_tmp17_ = widgets_app_entry_get_app (G_TYPE_CHECK_INSTANCE_CAST (row2, WIDGETS_TYPE_APP_ENTRY, WidgetsAppEntry));
	_tmp18_ = _tmp17_;
	_tmp19_ = backend_app_get_app_info (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_app_info_get_display_name ((GAppInfo*) _tmp20_);
	_tmp22_ = g_strdup (_tmp21_);
	row_name2 = _tmp22_;
	_tmp23_ = ((GCompareFunc) g_strcmp0);
	_tmp24_ = row_name1;
	_tmp25_ = row_name2;
	order = _tmp23_ (_tmp24_, _tmp25_);
	result = CLAMP (order, -1, 1);
	_g_free0 (row_name2);
	_g_free0 (row_name1);
	return result;
}

static void
widgets_sidebar_show_row (WidgetsSidebar* self,
                          GtkListBoxRow* row)
{
	gboolean _tmp0_ = FALSE;
	BackendNotifyManager* _tmp1_;
	BackendApp* _tmp2_;
	BackendApp* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	if (row == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !WIDGETS_IS_APP_ENTRY (row);
	}
	if (_tmp0_) {
		return;
	}
	_tmp1_ = backend_notify_manager_get_default ();
	_tmp2_ = widgets_app_entry_get_app (G_TYPE_CHECK_INSTANCE_CAST (row, WIDGETS_TYPE_APP_ENTRY, WidgetsAppEntry));
	_tmp3_ = _tmp2_;
	_tmp4_ = backend_app_get_app_id (_tmp3_);
	_tmp5_ = _tmp4_;
	backend_notify_manager_set_selected_app_id (_tmp1_, _tmp5_);
}

WidgetsSidebar*
widgets_sidebar_construct (GType object_type)
{
	WidgetsSidebar * self = NULL;
	self = (WidgetsSidebar*) g_object_new (object_type, NULL);
	return self;
}

WidgetsSidebar*
widgets_sidebar_new (void)
{
	return widgets_sidebar_construct (WIDGETS_TYPE_SIDEBAR);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		WidgetsSidebar* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->app_list);
		_g_object_unref0 (_data1_->search_revealer);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
_widgets_sidebar_filter_function_gtk_list_box_filter_func (GtkListBoxRow* row,
                                                           gpointer self)
{
	gboolean result;
	result = widgets_sidebar_filter_function ((WidgetsSidebar*) self, row);
	return result;
}

static gint
_widgets_sidebar_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                   GtkListBoxRow* row2,
                                                   gpointer self)
{
	gint result;
	result = widgets_sidebar_sort_func ((WidgetsSidebar*) self, row1, row2);
	return result;
}

static void
_widgets_sidebar_show_row_gtk_list_box_row_selected (GtkListBox* _sender,
                                                     GtkListBoxRow* row,
                                                     gpointer self)
{
	widgets_sidebar_show_row ((WidgetsSidebar*) self, row);
}

static void
_widgets_sidebar___lambda5_ (Block1Data* _data1_)
{
	WidgetsSidebar* self;
	GtkListBox* _tmp0_;
	self = _data1_->self;
	_tmp0_ = _data1_->app_list;
	gtk_list_box_invalidate_filter (_tmp0_);
}

static void
__widgets_sidebar___lambda5__gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                              gpointer self)
{
	_widgets_sidebar___lambda5_ (self);
}

static void
_widgets_sidebar___lambda6_ (Block1Data* _data1_)
{
	WidgetsSidebar* self;
	GtkRevealer* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = _data1_->self;
	_tmp0_ = _data1_->search_revealer;
	_tmp1_ = gtk_revealer_get_child_revealed (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkSearchEntry* _tmp3_;
		_tmp3_ = self->priv->search_entry;
		gtk_widget_grab_focus ((GtkWidget*) _tmp3_);
	} else {
		GtkSearchEntry* _tmp4_;
		_tmp4_ = self->priv->search_entry;
		gtk_editable_set_text ((GtkEditable*) _tmp4_, "");
	}
}

static void
__widgets_sidebar___lambda6__g_object_notify (GObject* _sender,
                                              GParamSpec* pspec,
                                              gpointer self)
{
	_widgets_sidebar___lambda6_ (self);
}

static gboolean
_widgets_sidebar___lambda7_ (Block1Data* _data1_,
                             GeeMapEntry* entry)
{
	WidgetsSidebar* self;
	WidgetsAppEntry* app_entry = NULL;
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	WidgetsAppEntry* _tmp2_;
	GtkListBox* _tmp3_;
	WidgetsAppEntry* _tmp4_;
	gboolean result;
	self = _data1_->self;
	g_return_val_if_fail (entry != NULL, FALSE);
	_tmp0_ = gee_map_entry_get_value (entry);
	_tmp1_ = _tmp0_;
	_tmp2_ = widgets_app_entry_new ((BackendApp*) _tmp1_);
	g_object_ref_sink (_tmp2_);
	app_entry = _tmp2_;
	_tmp3_ = _data1_->app_list;
	_tmp4_ = app_entry;
	gtk_list_box_append (_tmp3_, (GtkWidget*) _tmp4_);
	result = TRUE;
	_g_object_unref0 (app_entry);
	_g_object_unref0 (entry);
	return result;
}

static gboolean
__widgets_sidebar___lambda7__gee_forall_func (gpointer g,
                                              gpointer self)
{
	gboolean result;
	result = _widgets_sidebar___lambda7_ (self, (GeeMapEntry*) g);
	return result;
}

static GObject *
widgets_sidebar_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	WidgetsSidebar * self;
	Block1Data* _data1_;
	gchar* _tmp0_;
	GtkSearchEntry* _tmp1_ = NULL;
	GtkSearchEntry* _tmp2_;
	GtkWidget* _tmp3_;
	GtkRevealer* _tmp4_ = NULL;
	GtkToggleButton* search_toggle = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GtkToggleButton* _tmp7_ = NULL;
	AdwHeaderBar* headerbar = NULL;
	AdwHeaderBar* _tmp8_ = NULL;
	AdwHeaderBar* _tmp9_;
	GtkToggleButton* _tmp10_;
	GtkListBox* _tmp11_ = NULL;
	GtkListBox* _tmp12_;
	GtkListBox* _tmp13_;
	GtkScrolledWindow* scrolled_window = NULL;
	GtkListBox* _tmp14_;
	GtkWidget* _tmp15_;
	GtkScrolledWindow* _tmp16_ = NULL;
	GtkLabel* do_not_disturb_label = NULL;
	GtkLabel* _tmp17_;
	GtkSwitch* do_not_disturb_switch = NULL;
	GtkSwitch* _tmp18_ = NULL;
	GtkActionBar* footer = NULL;
	GtkActionBar* _tmp19_;
	GtkActionBar* _tmp20_;
	GtkLabel* _tmp21_;
	GtkActionBar* _tmp22_;
	GtkSwitch* _tmp23_;
	AdwToolbarView* toolbarview = NULL;
	GtkScrolledWindow* _tmp24_;
	GtkWidget* _tmp25_;
	AdwToolbarView* _tmp26_ = NULL;
	AdwToolbarView* _tmp27_;
	AdwHeaderBar* _tmp28_;
	AdwToolbarView* _tmp29_;
	GtkRevealer* _tmp30_;
	AdwToolbarView* _tmp31_;
	GtkActionBar* _tmp32_;
	AdwToolbarView* _tmp33_;
	GtkListBox* _tmp34_;
	GtkSearchEntry* _tmp35_;
	GtkToggleButton* _tmp36_;
	GtkRevealer* _tmp37_;
	GtkRevealer* _tmp38_;
	GSettings* _tmp39_;
	GtkSwitch* _tmp40_;
	BackendNotifyManager* _tmp41_;
	GeeHashMap* _tmp42_;
	GeeHashMap* _tmp43_;
	GtkListBox* _tmp44_;
	GtkWidget* _tmp45_;
	parent_class = G_OBJECT_CLASS (widgets_sidebar_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WIDGETS_TYPE_SIDEBAR, WidgetsSidebar);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = g_strdup (_ ("Search Apps"));
	_tmp1_ = (GtkSearchEntry*) gtk_search_entry_new ();
	g_object_set (_tmp1_, "placeholder-text", _tmp0_, NULL);
	_g_free0 (_tmp0_);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp1_, 6);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp1_, 6);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp1_, 6);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp1_, 6);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp1_, TRUE);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->search_entry);
	self->priv->search_entry = _tmp1_;
	_tmp2_ = self->priv->search_entry;
	_tmp3_ = _g_object_ref0 ((GtkWidget*) _tmp2_);
	_tmp4_ = (GtkRevealer*) gtk_revealer_new ();
	gtk_revealer_set_child (_tmp4_, _tmp3_);
	_g_object_unref0 (_tmp3_);
	g_object_ref_sink (_tmp4_);
	_data1_->search_revealer = _tmp4_;
	_tmp5_ = g_strdup ("edit-find-symbolic");
	_tmp6_ = g_strdup (_ ("Search Apps"));
	_tmp7_ = (GtkToggleButton*) gtk_toggle_button_new ();
	gtk_button_set_icon_name ((GtkButton*) _tmp7_, _tmp5_);
	_g_free0 (_tmp5_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp7_, _tmp6_);
	_g_free0 (_tmp6_);
	g_object_ref_sink (_tmp7_);
	search_toggle = _tmp7_;
	_tmp8_ = (AdwHeaderBar*) adw_header_bar_new ();
	adw_header_bar_set_show_end_title_buttons (_tmp8_, FALSE);
	adw_header_bar_set_show_title (_tmp8_, FALSE);
	g_object_ref_sink (_tmp8_);
	headerbar = _tmp8_;
	_tmp9_ = headerbar;
	_tmp10_ = search_toggle;
	adw_header_bar_pack_end (_tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = (GtkListBox*) gtk_list_box_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp11_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp11_, TRUE);
	gtk_list_box_set_selection_mode (_tmp11_, GTK_SELECTION_SINGLE);
	g_object_ref_sink (_tmp11_);
	_data1_->app_list = _tmp11_;
	_tmp12_ = _data1_->app_list;
	gtk_list_box_set_filter_func (_tmp12_, _widgets_sidebar_filter_function_gtk_list_box_filter_func, g_object_ref (self), g_object_unref);
	_tmp13_ = _data1_->app_list;
	gtk_list_box_set_sort_func (_tmp13_, _widgets_sidebar_sort_func_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp14_ = _data1_->app_list;
	_tmp15_ = _g_object_ref0 ((GtkWidget*) _tmp14_);
	_tmp16_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	gtk_scrolled_window_set_child (_tmp16_, _tmp15_);
	_g_object_unref0 (_tmp15_);
	g_object_set (_tmp16_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	g_object_ref_sink (_tmp16_);
	scrolled_window = _tmp16_;
	_tmp17_ = (GtkLabel*) gtk_label_new (_ ("Do Not Disturb"));
	g_object_ref_sink (_tmp17_);
	do_not_disturb_label = _tmp17_;
	_tmp18_ = (GtkSwitch*) gtk_switch_new ();
	gtk_widget_set_valign ((GtkWidget*) _tmp18_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp18_);
	do_not_disturb_switch = _tmp18_;
	_tmp19_ = (GtkActionBar*) gtk_action_bar_new ();
	g_object_ref_sink (_tmp19_);
	footer = _tmp19_;
	_tmp20_ = footer;
	_tmp21_ = do_not_disturb_label;
	gtk_action_bar_pack_start (_tmp20_, (GtkWidget*) _tmp21_);
	_tmp22_ = footer;
	_tmp23_ = do_not_disturb_switch;
	gtk_action_bar_pack_end (_tmp22_, (GtkWidget*) _tmp23_);
	_tmp24_ = scrolled_window;
	_tmp25_ = _g_object_ref0 ((GtkWidget*) _tmp24_);
	_tmp26_ = (AdwToolbarView*) adw_toolbar_view_new ();
	adw_toolbar_view_set_content (_tmp26_, _tmp25_);
	_g_object_unref0 (_tmp25_);
	adw_toolbar_view_set_top_bar_style (_tmp26_, ADW_TOOLBAR_FLAT);
	adw_toolbar_view_set_bottom_bar_style (_tmp26_, ADW_TOOLBAR_RAISED);
	g_object_ref_sink (_tmp26_);
	toolbarview = _tmp26_;
	_tmp27_ = toolbarview;
	_tmp28_ = headerbar;
	adw_toolbar_view_add_top_bar (_tmp27_, (GtkWidget*) _tmp28_);
	_tmp29_ = toolbarview;
	_tmp30_ = _data1_->search_revealer;
	adw_toolbar_view_add_top_bar (_tmp29_, (GtkWidget*) _tmp30_);
	_tmp31_ = toolbarview;
	_tmp32_ = footer;
	adw_toolbar_view_add_bottom_bar (_tmp31_, (GtkWidget*) _tmp32_);
	_tmp33_ = toolbarview;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp33_);
	gtk_widget_add_css_class ((GtkWidget*) self, GRANITE_STYLE_CLASS_SIDEBAR);
	_tmp34_ = _data1_->app_list;
	g_signal_connect_object (_tmp34_, "row-selected", (GCallback) _widgets_sidebar_show_row_gtk_list_box_row_selected, self, 0);
	_tmp35_ = self->priv->search_entry;
	g_signal_connect_data (_tmp35_, "search-changed", (GCallback) __widgets_sidebar___lambda5__gtk_search_entry_search_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp36_ = search_toggle;
	_tmp37_ = _data1_->search_revealer;
	g_object_bind_property_with_closures ((GObject*) _tmp36_, "active", (GObject*) _tmp37_, "reveal-child", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp38_ = _data1_->search_revealer;
	g_signal_connect_data ((GObject*) _tmp38_, "notify::child-revealed", (GCallback) __widgets_sidebar___lambda6__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp39_ = notifications_plug_notify_settings;
	_tmp40_ = do_not_disturb_switch;
	g_settings_bind (_tmp39_, "do-not-disturb", (GObject*) _tmp40_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp41_ = backend_notify_manager_get_default ();
	_tmp42_ = backend_notify_manager_get_apps (_tmp41_);
	_tmp43_ = _tmp42_;
	gee_abstract_map_foreach ((GeeAbstractMap*) _tmp43_, __widgets_sidebar___lambda7__gee_forall_func, _data1_);
	_tmp44_ = _data1_->app_list;
	_tmp45_ = gtk_widget_get_first_child ((GtkWidget*) _tmp44_);
	if (_tmp45_ != NULL) {
		GtkListBoxRow* row = NULL;
		GtkListBox* _tmp46_;
		GtkWidget* _tmp47_;
		GtkListBoxRow* _tmp48_;
		GtkListBox* _tmp49_;
		GtkListBoxRow* _tmp50_;
		GtkListBoxRow* _tmp51_;
		_tmp46_ = _data1_->app_list;
		_tmp47_ = gtk_widget_get_first_child ((GtkWidget*) _tmp46_);
		_tmp48_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, gtk_list_box_row_get_type (), GtkListBoxRow));
		row = _tmp48_;
		_tmp49_ = _data1_->app_list;
		_tmp50_ = row;
		gtk_list_box_select_row (_tmp49_, _tmp50_);
		_tmp51_ = row;
		widgets_sidebar_show_row (self, _tmp51_);
		_g_object_unref0 (row);
	}
	_g_object_unref0 (toolbarview);
	_g_object_unref0 (footer);
	_g_object_unref0 (do_not_disturb_switch);
	_g_object_unref0 (do_not_disturb_label);
	_g_object_unref0 (scrolled_window);
	_g_object_unref0 (headerbar);
	_g_object_unref0 (search_toggle);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return obj;
}

static void
widgets_sidebar_base_init (WidgetsSidebarClass * klass)
{
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "settingssidebar");
}

static void
widgets_sidebar_class_init (WidgetsSidebarClass * klass,
                            gpointer klass_data)
{
	widgets_sidebar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &WidgetsSidebar_private_offset);
	G_OBJECT_CLASS (klass)->constructor = widgets_sidebar_constructor;
	G_OBJECT_CLASS (klass)->finalize = widgets_sidebar_finalize;
}

static void
widgets_sidebar_instance_init (WidgetsSidebar * self,
                               gpointer klass)
{
	self->priv = widgets_sidebar_get_instance_private (self);
}

static void
widgets_sidebar_finalize (GObject * obj)
{
	WidgetsSidebar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WIDGETS_TYPE_SIDEBAR, WidgetsSidebar);
	_g_object_unref0 (self->priv->search_entry);
	G_OBJECT_CLASS (widgets_sidebar_parent_class)->finalize (obj);
}

static GType
widgets_sidebar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WidgetsSidebarClass), (GBaseInitFunc) widgets_sidebar_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) widgets_sidebar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WidgetsSidebar), 0, (GInstanceInitFunc) widgets_sidebar_instance_init, NULL };
	GType widgets_sidebar_type_id;
	widgets_sidebar_type_id = g_type_register_static (gtk_box_get_type (), "WidgetsSidebar", &g_define_type_info, 0);
	WidgetsSidebar_private_offset = g_type_add_instance_private (widgets_sidebar_type_id, sizeof (WidgetsSidebarPrivate));
	return widgets_sidebar_type_id;
}

GType
widgets_sidebar_get_type (void)
{
	static volatile gsize widgets_sidebar_type_id__once = 0;
	if (g_once_init_enter (&widgets_sidebar_type_id__once)) {
		GType widgets_sidebar_type_id;
		widgets_sidebar_type_id = widgets_sidebar_get_type_once ();
		g_once_init_leave (&widgets_sidebar_type_id__once, widgets_sidebar_type_id);
	}
	return widgets_sidebar_type_id__once;
}

