/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.cxx.in to make changes.
 */

#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkLabelMap.h"
#include "itkLabelObject.h"
#include "itkNumericTraits.h"
#include "itkNumericTraitsVariableLengthVectorPixel.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkComposeImageFilter.h"

#include "sitkInverseDeconvolutionImageFilter.h"
#include "itkInverseDeconvolutionImageFilter.h"

// Additional include files
#include "sitkBoundaryConditions.hxx"
// Done with additional include files

namespace itk::simple {

//-----------------------------------------------------------------------------

//
// Default constructor that initializes parameters
//
InverseDeconvolutionImageFilter::InverseDeconvolutionImageFilter ()
{
  this->m_MemberFactory =  std::make_unique<detail::MemberFunctionFactory<MemberFunctionType>>( this );

  this->m_MemberFactory->RegisterMemberFunctions< PixelIDTypeList, 2, 3 > ();



}

//
// Destructor
//
InverseDeconvolutionImageFilter::~InverseDeconvolutionImageFilter() = default;



//
// ToString
//
std::string InverseDeconvolutionImageFilter::ToString() const
{
  std::ostringstream out;
  out << "itk::simple::InverseDeconvolutionImageFilter\n";
  out << "  KernelZeroMagnitudeThreshold: ";
  this->ToStringHelper(out, this->m_KernelZeroMagnitudeThreshold);
  out << std::endl;
  out << "  Normalize: ";
  this->ToStringHelper(out, this->m_Normalize);
  out << std::endl;
  out << "  BoundaryCondition: ";
  this->ToStringHelper(out, this->m_BoundaryCondition);
  out << std::endl;
  out << "  OutputRegionMode: ";
  this->ToStringHelper(out, this->m_OutputRegionMode);
  out << std::endl;

  out << ProcessObject::ToString();
  return out.str();
}

//
// Execute
//
Image InverseDeconvolutionImageFilter::Execute ( const Image& image1, const Image& image2 )
{
  const PixelIDValueEnum type = image1.GetPixelID();
  const unsigned int dimension = image1.GetDimension();
  CheckImageMatchingDimension( image1, image2, "image2" );
  CheckImageMatchingPixelType( image1, image2, "image2" );

  return this->m_MemberFactory->GetMemberFunction( type, dimension )( image1, image2 );
}



//-----------------------------------------------------------------------------

sitkClangDiagnosticPush();
sitkClangWarningIgnore("-Wunused-local-typedef");

//
// ExecuteInternal
//
template <class TImageType>
Image InverseDeconvolutionImageFilter::ExecuteInternal ( const Image& inImage1, const Image& inImage2 )
{
  // Define the input and output image types
  using InputImageType = TImageType;

  using InputImageType2 = TImageType;

  using OutputImageType = InputImageType;

  // Get the pointer to the ITK image contained in image1
  typename InputImageType::ConstPointer image1 = this->CastImageToITK<InputImageType>( inImage1 );
  // Get the a pointer to the ITK image contained in image2
  typename InputImageType2::ConstPointer image2 = this->CastImageToITK<InputImageType2>( inImage2 );


  using FilterType =  itk::InverseDeconvolutionImageFilter<InputImageType, InputImageType2,  OutputImageType>;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();

  filter->SetInput( image1 ); filter->SetKernelImage( image2 );


  filter->SetKernelZeroMagnitudeThreshold ( this->m_KernelZeroMagnitudeThreshold );
  filter->SetNormalize ( this->m_Normalize );
  std::unique_ptr< ImageBoundaryCondition< InputImageType > > bc( CreateNewBoundaryConditionInstance< Self, FilterType >( m_BoundaryCondition ) ); filter->SetBoundaryCondition( bc.get() );

  filter->SetOutputRegionMode ( typename FilterType::OutputRegionModeEnum ( int( this->m_OutputRegionMode ) ) );




  this->PreUpdate( filter.GetPointer() );



  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();



  typename FilterType::OutputImageType::Pointer itkOutImage{ filter->GetOutput()};
  filter = nullptr;
  this->FixNonZeroIndex( itkOutImage.GetPointer() );
  return Image{ this->CastITKToImage( itkOutImage.GetPointer() ) };

}

sitkClangDiagnosticPop();

//-----------------------------------------------------------------------------


//
// Function to run the Execute method of this filter
//
Image InverseDeconvolution ( const Image& image1, const Image& image2, double kernelZeroMagnitudeThreshold, bool normalize, InverseDeconvolutionImageFilter::BoundaryConditionType boundaryCondition, InverseDeconvolutionImageFilter::OutputRegionModeType outputRegionMode )
{
  InverseDeconvolutionImageFilter filter;
  filter.SetKernelZeroMagnitudeThreshold( kernelZeroMagnitudeThreshold );  filter.SetNormalize( normalize );  filter.SetBoundaryCondition( boundaryCondition );  filter.SetOutputRegionMode( outputRegionMode );
  return filter.Execute ( image1, image2 );
}


}
