/* PhotoFileSniffer.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from PhotoFileSniffer.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include "metadata.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gobject/gvaluecollector.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DETECTED_PHOTO_INFORMATION (detected_photo_information_get_type ())
#define DETECTED_PHOTO_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformation))
#define DETECTED_PHOTO_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformationClass))
#define IS_DETECTED_PHOTO_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DETECTED_PHOTO_INFORMATION))
#define IS_DETECTED_PHOTO_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DETECTED_PHOTO_INFORMATION))
#define DETECTED_PHOTO_INFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformationClass))

typedef struct _DetectedPhotoInformation DetectedPhotoInformation;
typedef struct _DetectedPhotoInformationClass DetectedPhotoInformationClass;
typedef struct _DetectedPhotoInformationPrivate DetectedPhotoInformationPrivate;
typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_GIF,
	PHOTO_FILE_FORMAT_WEBP,
	PHOTO_FILE_FORMAT_AVIF,
	PHOTO_FILE_FORMAT_HEIF,
	PHOTO_FILE_FORMAT_JPEGXL,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_PHOTO_METADATA (photo_metadata_get_type ())
#define PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_METADATA, PhotoMetadata))
#define PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_METADATA, PhotoMetadataClass))
#define IS_PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_METADATA))
#define IS_PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_METADATA))
#define PHOTO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_METADATA, PhotoMetadataClass))

typedef struct _PhotoMetadata PhotoMetadata;
typedef struct _PhotoMetadataClass PhotoMetadataClass;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecDetectedPhotoInformation ParamSpecDetectedPhotoInformation;

#define TYPE_PHOTO_FILE_SNIFFER (photo_file_sniffer_get_type ())
#define PHOTO_FILE_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer))
#define PHOTO_FILE_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_SNIFFER, PhotoFileSnifferClass))
#define IS_PHOTO_FILE_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_SNIFFER))
#define IS_PHOTO_FILE_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_SNIFFER))
#define PHOTO_FILE_SNIFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_SNIFFER, PhotoFileSnifferClass))

typedef struct _PhotoFileSniffer PhotoFileSniffer;
typedef struct _PhotoFileSnifferClass PhotoFileSnifferClass;
typedef struct _PhotoFileSnifferPrivate PhotoFileSnifferPrivate;
typedef enum  {
	PHOTO_FILE_SNIFFER_OPTIONS_GET_ALL = 0x00000000,
	PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5 = 0x00000001
} PhotoFileSnifferOptions;

#define PHOTO_FILE_SNIFFER_TYPE_OPTIONS (photo_file_sniffer_options_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParamSpecPhotoFileSniffer ParamSpecPhotoFileSniffer;

#define TYPE_PHOTO_FILE_INTERROGATOR (photo_file_interrogator_get_type ())
#define PHOTO_FILE_INTERROGATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_INTERROGATOR, PhotoFileInterrogator))
#define PHOTO_FILE_INTERROGATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_INTERROGATOR, PhotoFileInterrogatorClass))
#define IS_PHOTO_FILE_INTERROGATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_INTERROGATOR))
#define IS_PHOTO_FILE_INTERROGATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_INTERROGATOR))
#define PHOTO_FILE_INTERROGATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_INTERROGATOR, PhotoFileInterrogatorClass))

typedef struct _PhotoFileInterrogator PhotoFileInterrogator;
typedef struct _PhotoFileInterrogatorClass PhotoFileInterrogatorClass;
typedef struct _PhotoFileInterrogatorPrivate PhotoFileInterrogatorPrivate;
#define _detected_photo_information_unref0(var) ((var == NULL) ? NULL : (var = (detected_photo_information_unref (var), NULL)))
#define _photo_file_sniffer_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_sniffer_unref (var), NULL)))
typedef struct _ParamSpecPhotoFileInterrogator ParamSpecPhotoFileInterrogator;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Dimensions {
	gint width;
	gint height;
};

struct _DetectedPhotoInformation {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DetectedPhotoInformationPrivate * priv;
	PhotoFileFormat file_format;
	PhotoMetadata* metadata;
	gchar* md5;
	gchar* exif_md5;
	gchar* thumbnail_md5;
	gchar* format_name;
	Dimensions image_dim;
	GdkColorspace colorspace;
	gint channels;
	gint bits_per_channel;
};

struct _DetectedPhotoInformationClass {
	GTypeClass parent_class;
	void (*finalize) (DetectedPhotoInformation *self);
};

struct _ParamSpecDetectedPhotoInformation {
	GParamSpec parent_instance;
};

struct _PhotoFileSniffer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoFileSnifferPrivate * priv;
	GFile* file;
	PhotoFileSnifferOptions options;
	gboolean calc_md5;
};

struct _PhotoFileSnifferClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoFileSniffer *self);
	DetectedPhotoInformation* (*sniff) (PhotoFileSniffer* self, gboolean* is_corrupted, GError** error);
};

struct _ParamSpecPhotoFileSniffer {
	GParamSpec parent_instance;
};

struct _PhotoFileInterrogator {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoFileInterrogatorPrivate * priv;
};

struct _PhotoFileInterrogatorClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoFileInterrogator *self);
};

struct _PhotoFileInterrogatorPrivate {
	GFile* file;
	PhotoFileSnifferOptions options;
	DetectedPhotoInformation* detected;
	gboolean is_photo_corrupted;
};

struct _ParamSpecPhotoFileInterrogator {
	GParamSpec parent_instance;
};

static gpointer detected_photo_information_parent_class = NULL;
static gpointer photo_file_sniffer_parent_class = NULL;
static gint PhotoFileInterrogator_private_offset;
static gpointer photo_file_interrogator_parent_class = NULL;

VALA_EXTERN gpointer detected_photo_information_ref (gpointer instance);
VALA_EXTERN void detected_photo_information_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_detected_photo_information (const gchar* name,
                                                   const gchar* nick,
                                                   const gchar* blurb,
                                                   GType object_type,
                                                   GParamFlags flags);
VALA_EXTERN void value_set_detected_photo_information (GValue* value,
                                           gpointer v_object);
VALA_EXTERN void value_take_detected_photo_information (GValue* value,
                                            gpointer v_object);
VALA_EXTERN gpointer value_get_detected_photo_information (const GValue* value);
VALA_EXTERN GType detected_photo_information_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DetectedPhotoInformation, detected_photo_information_unref)
VALA_EXTERN GType photo_file_format_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType photo_metadata_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoMetadata, media_metadata_unref)
VALA_EXTERN GType dimensions_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Dimensions* dimensions_dup (const Dimensions* self);
VALA_EXTERN void dimensions_free (Dimensions* self);
VALA_EXTERN void dimensions_init (Dimensions *self,
                      gint width,
                      gint height);
VALA_EXTERN DetectedPhotoInformation* detected_photo_information_new (void);
VALA_EXTERN DetectedPhotoInformation* detected_photo_information_construct (GType object_type);
static void detected_photo_information_finalize (DetectedPhotoInformation * obj);
static GType detected_photo_information_get_type_once (void);
VALA_EXTERN gpointer photo_file_sniffer_ref (gpointer instance);
VALA_EXTERN void photo_file_sniffer_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_photo_file_sniffer (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void value_set_photo_file_sniffer (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void value_take_photo_file_sniffer (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer value_get_photo_file_sniffer (const GValue* value);
VALA_EXTERN GType photo_file_sniffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoFileSniffer, photo_file_sniffer_unref)
VALA_EXTERN GType photo_file_sniffer_options_get_type (void) G_GNUC_CONST ;
VALA_EXTERN DetectedPhotoInformation* photo_file_sniffer_sniff (PhotoFileSniffer* self,
                                                    gboolean* is_corrupted,
                                                    GError** error);
VALA_EXTERN PhotoFileSniffer* photo_file_sniffer_construct (GType object_type,
                                                GFile* file,
                                                PhotoFileSnifferOptions options);
static DetectedPhotoInformation* photo_file_sniffer_real_sniff (PhotoFileSniffer* self,
                                                         gboolean* is_corrupted,
                                                         GError** error);
VALA_EXTERN gboolean photo_file_sniffer_is_supported_bmff_with_variants (GFile* file,
                                                             gchar** variants,
                                                             gint variants_length1,
                                                             GError** error);
static void _vala_array_add46 (guint8* * array,
                        gint* length,
                        gint* size,
                        guint8 value);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void photo_file_sniffer_finalize (PhotoFileSniffer * obj);
static GType photo_file_sniffer_get_type_once (void);
VALA_EXTERN gpointer photo_file_interrogator_ref (gpointer instance);
VALA_EXTERN void photo_file_interrogator_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_photo_file_interrogator (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags);
VALA_EXTERN void value_set_photo_file_interrogator (GValue* value,
                                        gpointer v_object);
VALA_EXTERN void value_take_photo_file_interrogator (GValue* value,
                                         gpointer v_object);
VALA_EXTERN gpointer value_get_photo_file_interrogator (const GValue* value);
VALA_EXTERN GType photo_file_interrogator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoFileInterrogator, photo_file_interrogator_unref)
VALA_EXTERN PhotoFileInterrogator* photo_file_interrogator_new (GFile* file,
                                                    PhotoFileSnifferOptions options);
VALA_EXTERN PhotoFileInterrogator* photo_file_interrogator_construct (GType object_type,
                                                          GFile* file,
                                                          PhotoFileSnifferOptions options);
VALA_EXTERN DetectedPhotoInformation* photo_file_interrogator_get_detected_photo_information (PhotoFileInterrogator* self);
VALA_EXTERN gboolean photo_file_interrogator_get_is_photo_corrupted (PhotoFileInterrogator* self);
VALA_EXTERN void photo_file_interrogator_interrogate (PhotoFileInterrogator* self,
                                          GError** error);
VALA_EXTERN PhotoFileFormat* photo_file_format_get_supported (gint* result_length1);
VALA_EXTERN PhotoFileSniffer* photo_file_format_create_sniffer (PhotoFileFormat self,
                                                    GFile* file,
                                                    PhotoFileSnifferOptions options);
static void photo_file_interrogator_finalize (PhotoFileInterrogator * obj);
static GType photo_file_interrogator_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

DetectedPhotoInformation*
detected_photo_information_construct (GType object_type)
{
	DetectedPhotoInformation* self = NULL;
	self = (DetectedPhotoInformation*) g_type_create_instance (object_type);
	return self;
}

DetectedPhotoInformation*
detected_photo_information_new (void)
{
	return detected_photo_information_construct (TYPE_DETECTED_PHOTO_INFORMATION);
}

static void
value_detected_photo_information_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_detected_photo_information_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		detected_photo_information_unref (value->data[0].v_pointer);
	}
}

static void
value_detected_photo_information_copy_value (const GValue* src_value,
                                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = detected_photo_information_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_detected_photo_information_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_detected_photo_information_collect_value (GValue* value,
                                                guint n_collect_values,
                                                GTypeCValue* collect_values,
                                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		DetectedPhotoInformation * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = detected_photo_information_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_detected_photo_information_lcopy_value (const GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	DetectedPhotoInformation ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = detected_photo_information_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_detected_photo_information (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags)
{
	ParamSpecDetectedPhotoInformation* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_DETECTED_PHOTO_INFORMATION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_detected_photo_information (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DETECTED_PHOTO_INFORMATION), NULL);
	return value->data[0].v_pointer;
}

void
value_set_detected_photo_information (GValue* value,
                                      gpointer v_object)
{
	DetectedPhotoInformation * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DETECTED_PHOTO_INFORMATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DETECTED_PHOTO_INFORMATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		detected_photo_information_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		detected_photo_information_unref (old);
	}
}

void
value_take_detected_photo_information (GValue* value,
                                       gpointer v_object)
{
	DetectedPhotoInformation * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DETECTED_PHOTO_INFORMATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DETECTED_PHOTO_INFORMATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		detected_photo_information_unref (old);
	}
}

static void
detected_photo_information_class_init (DetectedPhotoInformationClass * klass,
                                       gpointer klass_data)
{
	detected_photo_information_parent_class = g_type_class_peek_parent (klass);
	((DetectedPhotoInformationClass *) klass)->finalize = detected_photo_information_finalize;
}

static void
detected_photo_information_instance_init (DetectedPhotoInformation * self,
                                          gpointer klass)
{
	self->file_format = PHOTO_FILE_FORMAT_UNKNOWN;
	self->metadata = NULL;
	self->md5 = NULL;
	self->exif_md5 = NULL;
	self->thumbnail_md5 = NULL;
	self->format_name = NULL;
	dimensions_init (&self->image_dim, 0, 0);
	self->colorspace = GDK_COLORSPACE_RGB;
	self->channels = 0;
	self->bits_per_channel = 0;
	self->ref_count = 1;
}

static void
detected_photo_information_finalize (DetectedPhotoInformation * obj)
{
	DetectedPhotoInformation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformation);
	g_signal_handlers_destroy (self);
	_media_metadata_unref0 (self->metadata);
	_g_free0 (self->md5);
	_g_free0 (self->exif_md5);
	_g_free0 (self->thumbnail_md5);
	_g_free0 (self->format_name);
}

static GType
detected_photo_information_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_detected_photo_information_init, value_detected_photo_information_free_value, value_detected_photo_information_copy_value, value_detected_photo_information_peek_pointer, "p", value_detected_photo_information_collect_value, "p", value_detected_photo_information_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (DetectedPhotoInformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) detected_photo_information_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DetectedPhotoInformation), 0, (GInstanceInitFunc) detected_photo_information_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType detected_photo_information_type_id;
	detected_photo_information_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DetectedPhotoInformation", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return detected_photo_information_type_id;
}

GType
detected_photo_information_get_type (void)
{
	static volatile gsize detected_photo_information_type_id__once = 0;
	if (g_once_init_enter (&detected_photo_information_type_id__once)) {
		GType detected_photo_information_type_id;
		detected_photo_information_type_id = detected_photo_information_get_type_once ();
		g_once_init_leave (&detected_photo_information_type_id__once, detected_photo_information_type_id);
	}
	return detected_photo_information_type_id__once;
}

gpointer
detected_photo_information_ref (gpointer instance)
{
	DetectedPhotoInformation * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
detected_photo_information_unref (gpointer instance)
{
	DetectedPhotoInformation * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		DETECTED_PHOTO_INFORMATION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static GType
photo_file_sniffer_options_get_type_once (void)
{
	static const GEnumValue values[] = {{PHOTO_FILE_SNIFFER_OPTIONS_GET_ALL, "PHOTO_FILE_SNIFFER_OPTIONS_GET_ALL", "get-all"}, {PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5, "PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5", "no-md5"}, {0, NULL, NULL}};
	GType photo_file_sniffer_options_type_id;
	photo_file_sniffer_options_type_id = g_enum_register_static ("PhotoFileSnifferOptions", values);
	return photo_file_sniffer_options_type_id;
}

GType
photo_file_sniffer_options_get_type (void)
{
	static volatile gsize photo_file_sniffer_options_type_id__once = 0;
	if (g_once_init_enter (&photo_file_sniffer_options_type_id__once)) {
		GType photo_file_sniffer_options_type_id;
		photo_file_sniffer_options_type_id = photo_file_sniffer_options_get_type_once ();
		g_once_init_leave (&photo_file_sniffer_options_type_id__once, photo_file_sniffer_options_type_id);
	}
	return photo_file_sniffer_options_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

PhotoFileSniffer*
photo_file_sniffer_construct (GType object_type,
                              GFile* file,
                              PhotoFileSnifferOptions options)
{
	PhotoFileSniffer* self = NULL;
	GFile* _tmp0_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	self = (PhotoFileSniffer*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (self->file);
	self->file = _tmp0_;
	self->options = options;
	self->calc_md5 = (options & PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5) == 0;
	return self;
}

static DetectedPhotoInformation*
photo_file_sniffer_real_sniff (PhotoFileSniffer* self,
                               gboolean* is_corrupted,
                               GError** error)
{
	g_critical ("Type `%s' does not implement abstract method `photo_file_sniffer_sniff'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

DetectedPhotoInformation*
photo_file_sniffer_sniff (PhotoFileSniffer* self,
                          gboolean* is_corrupted,
                          GError** error)
{
	PhotoFileSnifferClass* _klass_;
	g_return_val_if_fail (IS_PHOTO_FILE_SNIFFER (self), NULL);
	_klass_ = PHOTO_FILE_SNIFFER_GET_CLASS (self);
	if (_klass_->sniff) {
		return _klass_->sniff (self, is_corrupted, error);
	}
	return NULL;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static void
_vala_array_add46 (guint8* * array,
                   gint* length,
                   gint* size,
                   guint8 value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

gboolean
photo_file_sniffer_is_supported_bmff_with_variants (GFile* file,
                                                    gchar** variants,
                                                    gint variants_length1,
                                                    GError** error)
{
	GFileInputStream* instream = NULL;
	GFileInputStream* _tmp0_;
	gssize _tmp2_ = 0L;
	GFileInputStream* _tmp3_;
	guint8* buf = NULL;
	guint8* _tmp5_;
	gint buf_length1;
	gint _buf_size_;
	gssize _tmp6_ = 0L;
	GFileInputStream* _tmp7_;
	guint8* _tmp8_;
	gint _tmp8__length1;
	guint8* _tmp10_;
	gint _tmp10__length1;
	gint _tmp11_ = 0;
	guint8* _tmp12_;
	gint _tmp12__length1;
	guint8* _tmp13_;
	gint _tmp13__length1;
	gssize _tmp14_ = 0L;
	GFileInputStream* _tmp15_;
	guint8* _tmp16_;
	gint _tmp16__length1;
	guint8* _tmp18_;
	gint _tmp18__length1;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), FALSE);
	_tmp0_ = g_file_read (file, NULL, &_inner_error0_);
	instream = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp1_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp1_;
	}
	_tmp3_ = instream;
	_tmp2_ = g_input_stream_skip (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, g_input_stream_get_type (), GInputStream), (gsize) 4, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp4_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (instream);
		return _tmp4_;
	}
	if (_tmp2_ != ((gssize) 4)) {
		result = FALSE;
		_g_object_unref0 (instream);
		return result;
	}
	_tmp5_ = g_new0 (guint8, 4);
	buf = _tmp5_;
	buf_length1 = 4;
	_buf_size_ = buf_length1;
	_tmp7_ = instream;
	_tmp8_ = buf;
	_tmp8__length1 = buf_length1;
	_tmp6_ = g_input_stream_read (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, g_input_stream_get_type (), GInputStream), _tmp8_, (gsize) _tmp8__length1, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp9_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		buf = (g_free (buf), NULL);
		_g_object_unref0 (instream);
		return _tmp9_;
	}
	if (_tmp6_ != ((gssize) 4)) {
		result = FALSE;
		buf = (g_free (buf), NULL);
		_g_object_unref0 (instream);
		return result;
	}
	_tmp10_ = string_get_data ("ftyp", &_tmp11_);
	_tmp10__length1 = _tmp11_;
	_tmp12_ = _tmp10_;
	_tmp12__length1 = _tmp10__length1;
	_tmp13_ = buf;
	_tmp13__length1 = buf_length1;
	if (memcmp (_tmp12_, _tmp13_, (gsize) 4) != 0) {
		result = FALSE;
		buf = (g_free (buf), NULL);
		_g_object_unref0 (instream);
		return result;
	}
	_tmp15_ = instream;
	_tmp16_ = buf;
	_tmp16__length1 = buf_length1;
	_tmp14_ = g_input_stream_read (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, g_input_stream_get_type (), GInputStream), _tmp16_, (gsize) _tmp16__length1, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp17_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		buf = (g_free (buf), NULL);
		_g_object_unref0 (instream);
		return _tmp17_;
	}
	if (_tmp14_ != ((gssize) 4)) {
		result = FALSE;
		buf = (g_free (buf), NULL);
		_g_object_unref0 (instream);
		return result;
	}
	_vala_array_add46 (&buf, &buf_length1, &_buf_size_, (guint8) '\0');
	_tmp18_ = buf;
	_tmp18__length1 = buf_length1;
	result = _vala_string_array_contains (variants, variants_length1, (const gchar*) _tmp18_);
	buf = (g_free (buf), NULL);
	_g_object_unref0 (instream);
	return result;
}

static void
value_photo_file_sniffer_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_photo_file_sniffer_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		photo_file_sniffer_unref (value->data[0].v_pointer);
	}
}

static void
value_photo_file_sniffer_copy_value (const GValue* src_value,
                                     GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = photo_file_sniffer_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_photo_file_sniffer_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_photo_file_sniffer_collect_value (GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PhotoFileSniffer * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = photo_file_sniffer_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_photo_file_sniffer_lcopy_value (const GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	PhotoFileSniffer ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = photo_file_sniffer_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_photo_file_sniffer (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags)
{
	ParamSpecPhotoFileSniffer* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PHOTO_FILE_SNIFFER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_photo_file_sniffer (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_FILE_SNIFFER), NULL);
	return value->data[0].v_pointer;
}

void
value_set_photo_file_sniffer (GValue* value,
                              gpointer v_object)
{
	PhotoFileSniffer * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_FILE_SNIFFER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_FILE_SNIFFER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		photo_file_sniffer_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_file_sniffer_unref (old);
	}
}

void
value_take_photo_file_sniffer (GValue* value,
                               gpointer v_object)
{
	PhotoFileSniffer * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_FILE_SNIFFER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_FILE_SNIFFER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_file_sniffer_unref (old);
	}
}

static void
photo_file_sniffer_class_init (PhotoFileSnifferClass * klass,
                               gpointer klass_data)
{
	photo_file_sniffer_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileSnifferClass *) klass)->finalize = photo_file_sniffer_finalize;
	((PhotoFileSnifferClass *) klass)->sniff = (DetectedPhotoInformation* (*) (PhotoFileSniffer*, gboolean*, GError**)) photo_file_sniffer_real_sniff;
}

static void
photo_file_sniffer_instance_init (PhotoFileSniffer * self,
                                  gpointer klass)
{
	self->ref_count = 1;
}

static void
photo_file_sniffer_finalize (PhotoFileSniffer * obj)
{
	PhotoFileSniffer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->file);
}

static GType
photo_file_sniffer_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_photo_file_sniffer_init, value_photo_file_sniffer_free_value, value_photo_file_sniffer_copy_value, value_photo_file_sniffer_peek_pointer, "p", value_photo_file_sniffer_collect_value, "p", value_photo_file_sniffer_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PhotoFileSnifferClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_file_sniffer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoFileSniffer), 0, (GInstanceInitFunc) photo_file_sniffer_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType photo_file_sniffer_type_id;
	photo_file_sniffer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PhotoFileSniffer", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	return photo_file_sniffer_type_id;
}

GType
photo_file_sniffer_get_type (void)
{
	static volatile gsize photo_file_sniffer_type_id__once = 0;
	if (g_once_init_enter (&photo_file_sniffer_type_id__once)) {
		GType photo_file_sniffer_type_id;
		photo_file_sniffer_type_id = photo_file_sniffer_get_type_once ();
		g_once_init_leave (&photo_file_sniffer_type_id__once, photo_file_sniffer_type_id);
	}
	return photo_file_sniffer_type_id__once;
}

gpointer
photo_file_sniffer_ref (gpointer instance)
{
	PhotoFileSniffer * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
photo_file_sniffer_unref (gpointer instance)
{
	PhotoFileSniffer * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PHOTO_FILE_SNIFFER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
photo_file_interrogator_get_instance_private (PhotoFileInterrogator* self)
{
	return G_STRUCT_MEMBER_P (self, PhotoFileInterrogator_private_offset);
}

PhotoFileInterrogator*
photo_file_interrogator_construct (GType object_type,
                                   GFile* file,
                                   PhotoFileSnifferOptions options)
{
	PhotoFileInterrogator* self = NULL;
	GFile* _tmp0_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	self = (PhotoFileInterrogator*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp0_;
	self->priv->options = options;
	return self;
}

PhotoFileInterrogator*
photo_file_interrogator_new (GFile* file,
                             PhotoFileSnifferOptions options)
{
	return photo_file_interrogator_construct (TYPE_PHOTO_FILE_INTERROGATOR, file, options);
}

static gpointer
_detected_photo_information_ref0 (gpointer self)
{
	return self ? detected_photo_information_ref (self) : NULL;
}

DetectedPhotoInformation*
photo_file_interrogator_get_detected_photo_information (PhotoFileInterrogator* self)
{
	DetectedPhotoInformation* _tmp0_;
	DetectedPhotoInformation* _tmp1_;
	DetectedPhotoInformation* result;
	g_return_val_if_fail (IS_PHOTO_FILE_INTERROGATOR (self), NULL);
	_tmp0_ = self->priv->detected;
	_tmp1_ = _detected_photo_information_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

gboolean
photo_file_interrogator_get_is_photo_corrupted (PhotoFileInterrogator* self)
{
	gboolean result;
	g_return_val_if_fail (IS_PHOTO_FILE_INTERROGATOR (self), FALSE);
	result = self->priv->is_photo_corrupted;
	return result;
}

void
photo_file_interrogator_interrogate (PhotoFileInterrogator* self,
                                     GError** error)
{
	gint _tmp0_ = 0;
	PhotoFileFormat* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO_FILE_INTERROGATOR (self));
	_tmp1_ = photo_file_format_get_supported (&_tmp0_);
	{
		PhotoFileFormat* file_format_collection = NULL;
		gint file_format_collection_length1 = 0;
		gint _file_format_collection_size_ = 0;
		gint file_format_it = 0;
		file_format_collection = _tmp1_;
		file_format_collection_length1 = _tmp0_;
		for (file_format_it = 0; file_format_it < file_format_collection_length1; file_format_it = file_format_it + 1) {
			PhotoFileFormat file_format = 0;
			file_format = file_format_collection[file_format_it];
			{
				PhotoFileSniffer* sniffer = NULL;
				GFile* _tmp2_;
				PhotoFileSniffer* _tmp3_;
				gboolean is_corrupted = FALSE;
				DetectedPhotoInformation* _tmp4_ = NULL;
				PhotoFileSniffer* _tmp5_;
				gboolean _tmp6_ = FALSE;
				DetectedPhotoInformation* _tmp7_;
				DetectedPhotoInformation* _tmp8_;
				gboolean _tmp9_ = FALSE;
				DetectedPhotoInformation* _tmp10_;
				_tmp2_ = self->priv->file;
				_tmp3_ = photo_file_format_create_sniffer (file_format, _tmp2_, self->priv->options);
				sniffer = _tmp3_;
				_tmp5_ = sniffer;
				_tmp7_ = photo_file_sniffer_sniff (_tmp5_, &_tmp6_, &_inner_error0_);
				is_corrupted = _tmp6_;
				_tmp4_ = _tmp7_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_photo_file_sniffer_unref0 (sniffer);
					file_format_collection = (g_free (file_format_collection), NULL);
					return;
				}
				_tmp8_ = _tmp4_;
				_tmp4_ = NULL;
				_detected_photo_information_unref0 (self->priv->detected);
				self->priv->detected = _tmp8_;
				_tmp10_ = self->priv->detected;
				if (_tmp10_ != NULL) {
					_tmp9_ = !is_corrupted;
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					DetectedPhotoInformation* _tmp11_;
					_tmp11_ = self->priv->detected;
					_vala_assert (_tmp11_->file_format == file_format, "detected.file_format == file_format");
					_detected_photo_information_unref0 (_tmp4_);
					_photo_file_sniffer_unref0 (sniffer);
					break;
				} else {
					if (is_corrupted) {
						GFile* _tmp12_;
						gchar* _tmp13_;
						gchar* _tmp14_;
						_tmp12_ = self->priv->file;
						_tmp13_ = g_file_get_path (_tmp12_);
						_tmp14_ = _tmp13_;
						g_message ("PhotoFileSniffer.vala:123: Sniffing halted for %s: potentially corrupt" \
"ed image file", _tmp14_);
						_g_free0 (_tmp14_);
						self->priv->is_photo_corrupted = TRUE;
						_detected_photo_information_unref0 (self->priv->detected);
						self->priv->detected = NULL;
						_detected_photo_information_unref0 (_tmp4_);
						_photo_file_sniffer_unref0 (sniffer);
						break;
					}
				}
				_detected_photo_information_unref0 (_tmp4_);
				_photo_file_sniffer_unref0 (sniffer);
			}
		}
		file_format_collection = (g_free (file_format_collection), NULL);
	}
}

static void
value_photo_file_interrogator_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_photo_file_interrogator_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		photo_file_interrogator_unref (value->data[0].v_pointer);
	}
}

static void
value_photo_file_interrogator_copy_value (const GValue* src_value,
                                          GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = photo_file_interrogator_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_photo_file_interrogator_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_photo_file_interrogator_collect_value (GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PhotoFileInterrogator * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = photo_file_interrogator_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_photo_file_interrogator_lcopy_value (const GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	PhotoFileInterrogator ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = photo_file_interrogator_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_photo_file_interrogator (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags)
{
	ParamSpecPhotoFileInterrogator* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PHOTO_FILE_INTERROGATOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_photo_file_interrogator (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_FILE_INTERROGATOR), NULL);
	return value->data[0].v_pointer;
}

void
value_set_photo_file_interrogator (GValue* value,
                                   gpointer v_object)
{
	PhotoFileInterrogator * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_FILE_INTERROGATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_FILE_INTERROGATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		photo_file_interrogator_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_file_interrogator_unref (old);
	}
}

void
value_take_photo_file_interrogator (GValue* value,
                                    gpointer v_object)
{
	PhotoFileInterrogator * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_FILE_INTERROGATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_FILE_INTERROGATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_file_interrogator_unref (old);
	}
}

static void
photo_file_interrogator_class_init (PhotoFileInterrogatorClass * klass,
                                    gpointer klass_data)
{
	photo_file_interrogator_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileInterrogatorClass *) klass)->finalize = photo_file_interrogator_finalize;
	g_type_class_adjust_private_offset (klass, &PhotoFileInterrogator_private_offset);
}

static void
photo_file_interrogator_instance_init (PhotoFileInterrogator * self,
                                       gpointer klass)
{
	self->priv = photo_file_interrogator_get_instance_private (self);
	self->priv->detected = NULL;
	self->priv->is_photo_corrupted = FALSE;
	self->ref_count = 1;
}

static void
photo_file_interrogator_finalize (PhotoFileInterrogator * obj)
{
	PhotoFileInterrogator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_FILE_INTERROGATOR, PhotoFileInterrogator);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->file);
	_detected_photo_information_unref0 (self->priv->detected);
}

static GType
photo_file_interrogator_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_photo_file_interrogator_init, value_photo_file_interrogator_free_value, value_photo_file_interrogator_copy_value, value_photo_file_interrogator_peek_pointer, "p", value_photo_file_interrogator_collect_value, "p", value_photo_file_interrogator_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PhotoFileInterrogatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_file_interrogator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoFileInterrogator), 0, (GInstanceInitFunc) photo_file_interrogator_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType photo_file_interrogator_type_id;
	photo_file_interrogator_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PhotoFileInterrogator", &g_define_type_info, &g_define_type_fundamental_info, 0);
	PhotoFileInterrogator_private_offset = g_type_add_instance_private (photo_file_interrogator_type_id, sizeof (PhotoFileInterrogatorPrivate));
	return photo_file_interrogator_type_id;
}

GType
photo_file_interrogator_get_type (void)
{
	static volatile gsize photo_file_interrogator_type_id__once = 0;
	if (g_once_init_enter (&photo_file_interrogator_type_id__once)) {
		GType photo_file_interrogator_type_id;
		photo_file_interrogator_type_id = photo_file_interrogator_get_type_once ();
		g_once_init_leave (&photo_file_interrogator_type_id__once, photo_file_interrogator_type_id);
	}
	return photo_file_interrogator_type_id__once;
}

gpointer
photo_file_interrogator_ref (gpointer instance)
{
	PhotoFileInterrogator * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
photo_file_interrogator_unref (gpointer instance)
{
	PhotoFileInterrogator * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PHOTO_FILE_INTERROGATOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

