// python wrapper for vtkPVArrayInformation
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVArrayInformation.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVArrayInformation(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVArrayInformation_ClassNew(); }


static PyObject *
PyvtkPVArrayInformation_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVArrayInformation::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVArrayInformation_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVArrayInformation *op = static_cast<vtkPVArrayInformation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVArrayInformation::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVArrayInformation_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVArrayInformation *tempr = vtkPVArrayInformation::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVArrayInformation_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVArrayInformation *op = static_cast<vtkPVArrayInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVArrayInformation *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVArrayInformation::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVArrayInformation_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVArrayInformation::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVArrayInformation_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVArrayInformation *op = static_cast<vtkPVArrayInformation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVArrayInformation::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVArrayInformation_Initialize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Initialize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVArrayInformation *op = static_cast<vtkPVArrayInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Initialize();
    }
    else
    {
      op->vtkPVArrayInformation::Initialize();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVArrayInformation_GetDataType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVArrayInformation *op = static_cast<vtkPVArrayInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDataType() :
      op->vtkPVArrayInformation::GetDataType());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVArrayInformation_GetDataTypeAsString(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataTypeAsString");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVArrayInformation *op = static_cast<vtkPVArrayInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetDataTypeAsString() :
      op->vtkPVArrayInformation::GetDataTypeAsString());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVArrayInformation_GetRangesAsString(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRangesAsString");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVArrayInformation *op = static_cast<vtkPVArrayInformation *>(vp);

  int temp0 = -6;
  int temp1 = 20;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0, 2) &&
      (ap.NoArgsLeft() || ap.GetValue(temp0)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetRangesAsString(temp0, temp1) :
      op->vtkPVArrayInformation::GetRangesAsString(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVArrayInformation_GetName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVArrayInformation *op = static_cast<vtkPVArrayInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetName() :
      op->vtkPVArrayInformation::GetName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVArrayInformation_GetNumberOfComponents(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfComponents");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVArrayInformation *op = static_cast<vtkPVArrayInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfComponents() :
      op->vtkPVArrayInformation::GetNumberOfComponents());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVArrayInformation_GetComponentName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetComponentName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVArrayInformation *op = static_cast<vtkPVArrayInformation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetComponentName(temp0) :
      op->vtkPVArrayInformation::GetComponentName(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVArrayInformation_GetNumberOfTuples(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfTuples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVArrayInformation *op = static_cast<vtkPVArrayInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfTuples() :
      op->vtkPVArrayInformation::GetNumberOfTuples());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVArrayInformation_GetComponentRange_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetComponentRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVArrayInformation *op = static_cast<vtkPVArrayInformation *>(vp);

  int temp0;
  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const double *tempr = (ap.IsBound() ?
      op->GetComponentRange(temp0) :
      op->vtkPVArrayInformation::GetComponentRange(temp0));

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkPVArrayInformation_GetComponentRange_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetComponentRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVArrayInformation *op = static_cast<vtkPVArrayInformation *>(vp);

  int temp0;
  const size_t size1 = 2;
  double temp1[2];
  double save1[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1))
  {
    vtkPythonArgs::Save(temp1, save1, size1);

    if (ap.IsBound())
    {
      op->GetComponentRange(temp0, temp1);
    }
    else
    {
      op->vtkPVArrayInformation::GetComponentRange(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVArrayInformation_GetComponentRange(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkPVArrayInformation_GetComponentRange_s1(self, args);
    case 2:
      return PyvtkPVArrayInformation_GetComponentRange_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetComponentRange");
  return nullptr;
}


static PyObject *
PyvtkPVArrayInformation_GetComponentFiniteRange_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetComponentFiniteRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVArrayInformation *op = static_cast<vtkPVArrayInformation *>(vp);

  int temp0;
  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const double *tempr = (ap.IsBound() ?
      op->GetComponentFiniteRange(temp0) :
      op->vtkPVArrayInformation::GetComponentFiniteRange(temp0));

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkPVArrayInformation_GetComponentFiniteRange_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetComponentFiniteRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVArrayInformation *op = static_cast<vtkPVArrayInformation *>(vp);

  int temp0;
  const size_t size1 = 2;
  double temp1[2];
  double save1[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1))
  {
    vtkPythonArgs::Save(temp1, save1, size1);

    if (ap.IsBound())
    {
      op->GetComponentFiniteRange(temp0, temp1);
    }
    else
    {
      op->vtkPVArrayInformation::GetComponentFiniteRange(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVArrayInformation_GetComponentFiniteRange(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkPVArrayInformation_GetComponentFiniteRange_s1(self, args);
    case 2:
      return PyvtkPVArrayInformation_GetComponentFiniteRange_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetComponentFiniteRange");
  return nullptr;
}


static PyObject *
PyvtkPVArrayInformation_GetDataTypeRange(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataTypeRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVArrayInformation *op = static_cast<vtkPVArrayInformation *>(vp);

  const size_t size0 = 2;
  double temp0[2];
  double save0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetDataTypeRange(temp0);
    }
    else
    {
      op->vtkPVArrayInformation::GetDataTypeRange(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVArrayInformation_GetIsPartial(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetIsPartial");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVArrayInformation *op = static_cast<vtkPVArrayInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetIsPartial() :
      op->vtkPVArrayInformation::GetIsPartial());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVArrayInformation_GetNumberOfInformationKeys(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfInformationKeys");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVArrayInformation *op = static_cast<vtkPVArrayInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfInformationKeys() :
      op->vtkPVArrayInformation::GetNumberOfInformationKeys());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVArrayInformation_GetInformationKeyLocation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInformationKeyLocation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVArrayInformation *op = static_cast<vtkPVArrayInformation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetInformationKeyLocation(temp0) :
      op->vtkPVArrayInformation::GetInformationKeyLocation(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVArrayInformation_GetInformationKeyName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInformationKeyName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVArrayInformation *op = static_cast<vtkPVArrayInformation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetInformationKeyName(temp0) :
      op->vtkPVArrayInformation::GetInformationKeyName(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVArrayInformation_HasInformationKey(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HasInformationKey");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVArrayInformation *op = static_cast<vtkPVArrayInformation *>(vp);

  const char *temp0 = nullptr;
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    bool tempr = (ap.IsBound() ?
      op->HasInformationKey(temp0, temp1) :
      op->vtkPVArrayInformation::HasInformationKey(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVArrayInformation_GetNumberOfStringValues(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfStringValues");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVArrayInformation *op = static_cast<vtkPVArrayInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfStringValues() :
      op->vtkPVArrayInformation::GetNumberOfStringValues());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVArrayInformation_GetStringValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetStringValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVArrayInformation *op = static_cast<vtkPVArrayInformation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetStringValue(temp0) :
      op->vtkPVArrayInformation::GetStringValue(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVArrayInformation_CopyFromArray_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CopyFromArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVArrayInformation *op = static_cast<vtkPVArrayInformation *>(vp);

  vtkAbstractArray *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkAbstractArray"))
  {
    if (ap.IsBound())
    {
      op->CopyFromArray(temp0);
    }
    else
    {
      op->vtkPVArrayInformation::CopyFromArray(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVArrayInformation_CopyFromArray_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CopyFromArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVArrayInformation *op = static_cast<vtkPVArrayInformation *>(vp);

  vtkFieldData *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkFieldData") &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->CopyFromArray(temp0, temp1);
    }
    else
    {
      op->vtkPVArrayInformation::CopyFromArray(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVArrayInformation_CopyFromArray_s3(PyObject *self, PyObject *args)
{
  PyErr_WarnEx(PyExc_DeprecationWarning,
    "Call to deprecated method CopyFromArray."
    " (" "Please use the CopyFromArray(vtkAbstractArray*) or CopyFromArray(vtkFieldData*, int) overloads" ")"
    " -- Deprecated since version " "6.0.0" ".", 1);

  vtkPythonArgs ap(self, args, "CopyFromArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVArrayInformation *op = static_cast<vtkPVArrayInformation *>(vp);

  vtkAbstractArray *temp0 = nullptr;
  vtkFieldData *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkAbstractArray") &&
      ap.GetVTKObject(temp1, "vtkFieldData"))
  {
    if (ap.IsBound())
    {
      op->CopyFromArray(temp0, temp1);
    }
    else
    {
      op->vtkPVArrayInformation::CopyFromArray(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkPVArrayInformation_CopyFromArray_Methods[] = {
  {"CopyFromArray", PyvtkPVArrayInformation_CopyFromArray_s2, METH_VARARGS,
   "@Vi *vtkFieldData"},
  {"CopyFromArray", PyvtkPVArrayInformation_CopyFromArray_s3, METH_VARARGS,
   "@VV *vtkAbstractArray *vtkFieldData"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkPVArrayInformation_CopyFromArray(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkPVArrayInformation_CopyFromArray_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkPVArrayInformation_CopyFromArray_s1(self, args);
    case 2:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "CopyFromArray");
  return nullptr;
}


static PyObject *
PyvtkPVArrayInformation_CopyFromCellAttribute(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CopyFromCellAttribute");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVArrayInformation *op = static_cast<vtkPVArrayInformation *>(vp);

  vtkCellGrid *temp0 = nullptr;
  vtkCellAttribute *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkCellGrid") &&
      ap.GetVTKObject(temp1, "vtkCellAttribute"))
  {
    if (ap.IsBound())
    {
      op->CopyFromCellAttribute(temp0, temp1);
    }
    else
    {
      op->vtkPVArrayInformation::CopyFromCellAttribute(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVArrayInformation_CopyFromGenericAttribute(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CopyFromGenericAttribute");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVArrayInformation *op = static_cast<vtkPVArrayInformation *>(vp);

  vtkGenericAttribute *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkGenericAttribute"))
  {
    if (ap.IsBound())
    {
      op->CopyFromGenericAttribute(temp0);
    }
    else
    {
      op->vtkPVArrayInformation::CopyFromGenericAttribute(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkPVArrayInformation_Methods[] = {
  {"IsTypeOf", PyvtkPVArrayInformation_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVArrayInformation_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVArrayInformation_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVArrayInformation\nC++: static vtkPVArrayInformation *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVArrayInformation_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVArrayInformation\nC++: vtkPVArrayInformation *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVArrayInformation_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVArrayInformation_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"Initialize", PyvtkPVArrayInformation_Initialize, METH_VARARGS,
   "Initialize(self) -> None\nC++: void Initialize()\n\nResets to default state.\n"},
  {"GetDataType", PyvtkPVArrayInformation_GetDataType, METH_VARARGS,
   "GetDataType(self) -> int\nC++: virtual int GetDataType()\n\nGet the type for values in the array e.g. VTK_FLOAT, VTK_DOUBLE\netc.\n"},
  {"GetDataTypeAsString", PyvtkPVArrayInformation_GetDataTypeAsString, METH_VARARGS,
   "GetDataTypeAsString(self) -> str\nC++: const char *GetDataTypeAsString()\n\nReturns a printable string for the array value type.\n"},
  {"GetRangesAsString", PyvtkPVArrayInformation_GetRangesAsString, METH_VARARGS,
   "GetRangesAsString(self, lowExponent:int=-6, highExponent:int=20)\n    -> str\nC++: std::string GetRangesAsString(int lowExponent=-6,\n    int highExponent=20)\n\nReturns range as a string. For string arrays, this lists string\nvalues instead.\n"},
  {"GetName", PyvtkPVArrayInformation_GetName, METH_VARARGS,
   "GetName(self) -> str\nC++: const char *GetName()\n\nGet array's name\n"},
  {"GetNumberOfComponents", PyvtkPVArrayInformation_GetNumberOfComponents, METH_VARARGS,
   "GetNumberOfComponents(self) -> int\nC++: int GetNumberOfComponents()\n\nGet number of components.\n"},
  {"GetComponentName", PyvtkPVArrayInformation_GetComponentName, METH_VARARGS,
   "GetComponentName(self, component:int) -> str\nC++: const char *GetComponentName(int component)\n\nReturns the name for a component. If none present, a default\ncomponent name may be returned.\n"},
  {"GetNumberOfTuples", PyvtkPVArrayInformation_GetNumberOfTuples, METH_VARARGS,
   "GetNumberOfTuples(self) -> int\nC++: virtual vtkTypeInt64 GetNumberOfTuples()\n\nReturns the number of tuples in this array.\n"},
  {"GetComponentRange", PyvtkPVArrayInformation_GetComponentRange, METH_VARARGS,
   "GetComponentRange(self, comp:int) -> (float, float)\nC++: const double *GetComponentRange(int comp)\nGetComponentRange(self, comp:int, range:[float, float]) -> None\nC++: void GetComponentRange(int comp, double range[2])\n\nReturns component range. If component is `-1`, then the range of\nthe magnitude (L2 norm) over all components will be provided.\n\nReturns invalid range for non-numeric arrays.\n"},
  {"GetComponentFiniteRange", PyvtkPVArrayInformation_GetComponentFiniteRange, METH_VARARGS,
   "GetComponentFiniteRange(self, component:int) -> (float, float)\nC++: const double *GetComponentFiniteRange(int component)\nGetComponentFiniteRange(self, comp:int, range:[float, float])\n    -> None\nC++: void GetComponentFiniteRange(int comp, double range[2])\n\nReturns the finite range for each component. If component is\n`-1`, then the range of the magnitude (L2 norm) over all\ncomponents will be provided.\n\nReturns invalid range for non-numeric arrays.\n"},
  {"GetDataTypeRange", PyvtkPVArrayInformation_GetDataTypeRange, METH_VARARGS,
   "GetDataTypeRange(self, range:[float, float]) -> None\nC++: void GetDataTypeRange(double range[2])\n\nThis method return the Min and Max possible range of the native\ndata type. For example if a vtkScalars consists of unsigned char\ndata these will return (0,255). Nothing particular for 12bits\ndata is done\n"},
  {"GetIsPartial", PyvtkPVArrayInformation_GetIsPartial, METH_VARARGS,
   "GetIsPartial(self) -> bool\nC++: virtual bool GetIsPartial()\n\nIf IsPartial is true, this array is in only some of the parts of\na multi-block dataset. By default, IsPartial is set to 0.\n"},
  {"GetNumberOfInformationKeys", PyvtkPVArrayInformation_GetNumberOfInformationKeys, METH_VARARGS,
   "GetNumberOfInformationKeys(self) -> int\nC++: int GetNumberOfInformationKeys()\n\nGet information on the InformationKeys of this array\n"},
  {"GetInformationKeyLocation", PyvtkPVArrayInformation_GetInformationKeyLocation, METH_VARARGS,
   "GetInformationKeyLocation(self, __a:int) -> str\nC++: const char *GetInformationKeyLocation(int)\n\n"},
  {"GetInformationKeyName", PyvtkPVArrayInformation_GetInformationKeyName, METH_VARARGS,
   "GetInformationKeyName(self, __a:int) -> str\nC++: const char *GetInformationKeyName(int)\n\n"},
  {"HasInformationKey", PyvtkPVArrayInformation_HasInformationKey, METH_VARARGS,
   "HasInformationKey(self, location:str, name:str) -> bool\nC++: bool HasInformationKey(const char *location,\n    const char *name)\n\n"},
  {"GetNumberOfStringValues", PyvtkPVArrayInformation_GetNumberOfStringValues, METH_VARARGS,
   "GetNumberOfStringValues(self) -> int\nC++: int GetNumberOfStringValues()\n\nFor string arrays, this returns first few non-empty values.\n"},
  {"GetStringValue", PyvtkPVArrayInformation_GetStringValue, METH_VARARGS,
   "GetStringValue(self, __a:int) -> str\nC++: const char *GetStringValue(int)\n\n"},
  {"CopyFromArray", PyvtkPVArrayInformation_CopyFromArray, METH_VARARGS,
   "CopyFromArray(self, array:vtkAbstractArray) -> None\nC++: void CopyFromArray(vtkAbstractArray *array)\nCopyFromArray(self, fieldData:vtkFieldData, fdArrayIdx:int)\n    -> None\nC++: void CopyFromArray(vtkFieldData *fieldData, int fdArrayIdx)\nCopyFromArray(self, array:vtkAbstractArray,\n    fieldData:vtkFieldData) -> None\nC++: void CopyFromArray(vtkAbstractArray *array,\n    vtkFieldData *fieldData)\n\nCopy info from an array. Prefer the field data overload when\ncopying from a field data array.\n"},
  {"CopyFromCellAttribute", PyvtkPVArrayInformation_CopyFromCellAttribute, METH_VARARGS,
   "CopyFromCellAttribute(self, grid:vtkCellGrid,\n    attribute:vtkCellAttribute) -> None\nC++: void CopyFromCellAttribute(vtkCellGrid *grid,\n    vtkCellAttribute *attribute)\n\n"},
  {"CopyFromGenericAttribute", PyvtkPVArrayInformation_CopyFromGenericAttribute, METH_VARARGS,
   "CopyFromGenericAttribute(self, array:vtkGenericAttribute) -> None\nC++: void CopyFromGenericAttribute(vtkGenericAttribute *array)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVArrayInformation_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("is_partial"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVArrayInformation_GetIsPartial(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetIsPartial\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("data_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVArrayInformation_GetDataType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDataType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVArrayInformation_GetName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_components"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVArrayInformation_GetNumberOfComponents(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfComponents\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_tuples"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVArrayInformation_GetNumberOfTuples(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfTuples\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_information_keys"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVArrayInformation_GetNumberOfInformationKeys(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfInformationKeys\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVArrayInformation_Doc =
  "vtkPVArrayInformation - provides meta data about arrays.\n\n"
  "Superclass: vtkObject\n\n"
  "vtkPVArrayInformation provides meta-data about individual arrays. It\n"
  "is accessed through `vtkPVDataInformation` and provides information\n"
  "like ranges, component names, etc. for array present in a dataset.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVArrayInformation_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingCore.vtkPVArrayInformation", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVArrayInformation_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVArrayInformation_StaticNew()
{
  return vtkPVArrayInformation::New();
}

PyObject *PyvtkPVArrayInformation_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVArrayInformation_Type, PyvtkPVArrayInformation_Methods,
    "vtkPVArrayInformation",
 &PyvtkPVArrayInformation_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVArrayInformation_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVArrayInformation(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVArrayInformation_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVArrayInformation", o) != 0)
  {
    Py_DECREF(o);
  }

}

