#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkAdaptiveDataSetSurfaceFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkBSplineTransform_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkDepthSortPolyData_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkDSPFilterDefinition_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkDSPFilterGroup_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkEarthSource_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkFacetReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkForceTime_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkGenerateTimeSteps_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkGreedyTerrainDecimation_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkGridTransform_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageToPolyDataFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImplicitModeller_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPCAAnalysisFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPolyDataSilhouette_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkProcrustesAlignmentFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkProjectedTerrainPath_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkRenderLargeImage_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkTemporalArrayOperatorFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkTemporalDataSetCache_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkTemporalFractal_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkTemporalInterpolator_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkTemporalShiftScale_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkTemporalSnapToTimeStep_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkTransformToGrid_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkWeightedTransformFilter_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkFiltersHybridCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkAdaptiveDataSetSurfaceFilter_Init(csi);
  vtkBSplineTransform_Init(csi);
  vtkDepthSortPolyData_Init(csi);
  vtkDSPFilterDefinition_Init(csi);
  vtkDSPFilterGroup_Init(csi);
  vtkEarthSource_Init(csi);
  vtkFacetReader_Init(csi);
  vtkForceTime_Init(csi);
  vtkGenerateTimeSteps_Init(csi);
  vtkGreedyTerrainDecimation_Init(csi);
  vtkGridTransform_Init(csi);
  vtkImageToPolyDataFilter_Init(csi);
  vtkImplicitModeller_Init(csi);
  vtkPCAAnalysisFilter_Init(csi);
  vtkPolyDataSilhouette_Init(csi);
  vtkProcrustesAlignmentFilter_Init(csi);
  vtkProjectedTerrainPath_Init(csi);
  vtkRenderLargeImage_Init(csi);
  vtkTemporalArrayOperatorFilter_Init(csi);
  vtkTemporalDataSetCache_Init(csi);
  vtkTemporalFractal_Init(csi);
  vtkTemporalInterpolator_Init(csi);
  vtkTemporalShiftScale_Init(csi);
  vtkTemporalSnapToTimeStep_Init(csi);
  vtkTransformToGrid_Init(csi);
  vtkWeightedTransformFilter_Init(csi);
}
