// python wrapper for vtkSMRenderViewProxy
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkTuple.h"
#include "vtkSMRenderViewProxy.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSMRenderViewProxy(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSMRenderViewProxy_ClassNew(); }

#ifndef DECLARED_PyvtkSMViewProxy_ClassNew
extern "C" { PyObject *PyvtkSMViewProxy_ClassNew(); }
#define DECLARED_PyvtkSMViewProxy_ClassNew
#endif
#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMRenderViewProxy_CameraAdjustmentType_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkSMRenderViewProxy.CameraAdjustmentType", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkSMRenderViewProxy_CameraAdjustmentType_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkSMRenderViewProxy_CameraAdjustmentType_Type, static_cast<int>(val));
}


static PyObject *
PyvtkSMRenderViewProxy_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSMRenderViewProxy::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSMRenderViewProxy::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSMRenderViewProxy *tempr = vtkSMRenderViewProxy::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMRenderViewProxy *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSMRenderViewProxy::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSMRenderViewProxy::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSMRenderViewProxy::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_SelectSurfaceCells(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SelectSurfaceCells");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  const size_t size0 = 4;
  int temp0[4];
  vtkCollection *temp1 = nullptr;
  vtkCollection *temp2 = nullptr;
  bool temp3 = false;
  int temp4 = 0;
  bool temp5 = false;
  const char *temp6 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3, 7) &&
      ap.GetArray(temp0, size0) &&
      ap.GetVTKObject(temp1, "vtkCollection") &&
      ap.GetVTKObject(temp2, "vtkCollection") &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp4)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp5)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp6)))
  {
    bool tempr = (ap.IsBound() ?
      op->SelectSurfaceCells(temp0, temp1, temp2, temp3, temp4, temp5, temp6) :
      op->vtkSMRenderViewProxy::SelectSurfaceCells(temp0, temp1, temp2, temp3, temp4, temp5, temp6));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_SelectSurfacePoints(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SelectSurfacePoints");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  const size_t size0 = 4;
  int temp0[4];
  vtkCollection *temp1 = nullptr;
  vtkCollection *temp2 = nullptr;
  bool temp3 = false;
  int temp4 = 0;
  bool temp5 = false;
  const char *temp6 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3, 7) &&
      ap.GetArray(temp0, size0) &&
      ap.GetVTKObject(temp1, "vtkCollection") &&
      ap.GetVTKObject(temp2, "vtkCollection") &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp4)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp5)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp6)))
  {
    bool tempr = (ap.IsBound() ?
      op->SelectSurfacePoints(temp0, temp1, temp2, temp3, temp4, temp5, temp6) :
      op->vtkSMRenderViewProxy::SelectSurfacePoints(temp0, temp1, temp2, temp3, temp4, temp5, temp6));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_SelectFrustumCells(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SelectFrustumCells");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  const size_t size0 = 4;
  int temp0[4];
  vtkCollection *temp1 = nullptr;
  vtkCollection *temp2 = nullptr;
  bool temp3 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3, 4) &&
      ap.GetArray(temp0, size0) &&
      ap.GetVTKObject(temp1, "vtkCollection") &&
      ap.GetVTKObject(temp2, "vtkCollection") &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)))
  {
    bool tempr = (ap.IsBound() ?
      op->SelectFrustumCells(temp0, temp1, temp2, temp3) :
      op->vtkSMRenderViewProxy::SelectFrustumCells(temp0, temp1, temp2, temp3));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_SelectFrustumPoints(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SelectFrustumPoints");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  const size_t size0 = 4;
  int temp0[4];
  vtkCollection *temp1 = nullptr;
  vtkCollection *temp2 = nullptr;
  bool temp3 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3, 4) &&
      ap.GetArray(temp0, size0) &&
      ap.GetVTKObject(temp1, "vtkCollection") &&
      ap.GetVTKObject(temp2, "vtkCollection") &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)))
  {
    bool tempr = (ap.IsBound() ?
      op->SelectFrustumPoints(temp0, temp1, temp2, temp3) :
      op->vtkSMRenderViewProxy::SelectFrustumPoints(temp0, temp1, temp2, temp3));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_SelectPolygonPoints(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SelectPolygonPoints");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  vtkIntArray *temp0 = nullptr;
  vtkCollection *temp1 = nullptr;
  vtkCollection *temp2 = nullptr;
  bool temp3 = false;
  int temp4 = 0;
  bool temp5 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3, 6) &&
      ap.GetVTKObject(temp0, "vtkIntArray") &&
      ap.GetVTKObject(temp1, "vtkCollection") &&
      ap.GetVTKObject(temp2, "vtkCollection") &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp4)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp5)))
  {
    bool tempr = (ap.IsBound() ?
      op->SelectPolygonPoints(temp0, temp1, temp2, temp3, temp4, temp5) :
      op->vtkSMRenderViewProxy::SelectPolygonPoints(temp0, temp1, temp2, temp3, temp4, temp5));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_SelectPolygonCells(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SelectPolygonCells");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  vtkIntArray *temp0 = nullptr;
  vtkCollection *temp1 = nullptr;
  vtkCollection *temp2 = nullptr;
  bool temp3 = false;
  int temp4 = 0;
  bool temp5 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3, 6) &&
      ap.GetVTKObject(temp0, "vtkIntArray") &&
      ap.GetVTKObject(temp1, "vtkCollection") &&
      ap.GetVTKObject(temp2, "vtkCollection") &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp4)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp5)))
  {
    bool tempr = (ap.IsBound() ?
      op->SelectPolygonCells(temp0, temp1, temp2, temp3, temp4, temp5) :
      op->vtkSMRenderViewProxy::SelectPolygonCells(temp0, temp1, temp2, temp3, temp4, temp5));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_ComputeVisibleScalarRange_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ComputeVisibleScalarRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  const size_t size0 = 4;
  int temp0[4];
  int temp1;
  const char *temp2 = nullptr;
  int temp3;
  size_t size4 = ap.GetArgSize(4);
  vtkPythonArgs::Array<double> store4(2*size4);
  double *temp4 = store4.Data();
  double *save4 = (size4 == 0 ? nullptr : temp4 + size4);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(5) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetArray(temp4, size4))
  {
    vtkPythonArgs::Save(temp4, save4, size4);

    bool tempr = (ap.IsBound() ?
      op->ComputeVisibleScalarRange(temp0, temp1, temp2, temp3, temp4) :
      op->vtkSMRenderViewProxy::ComputeVisibleScalarRange(temp0, temp1, temp2, temp3, temp4));

    if (vtkPythonArgs::HasChanged(temp4, save4, size4) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(4, temp4, size4);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMRenderViewProxy_ComputeVisibleScalarRange_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ComputeVisibleScalarRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  int temp0;
  const char *temp1 = nullptr;
  int temp2;
  size_t size3 = ap.GetArgSize(3);
  vtkPythonArgs::Array<double> store3(2*size3);
  double *temp3 = store3.Data();
  double *save3 = (size3 == 0 ? nullptr : temp3 + size3);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetArray(temp3, size3))
  {
    vtkPythonArgs::Save(temp3, save3, size3);

    bool tempr = (ap.IsBound() ?
      op->ComputeVisibleScalarRange(temp0, temp1, temp2, temp3) :
      op->vtkSMRenderViewProxy::ComputeVisibleScalarRange(temp0, temp1, temp2, temp3));

    if (vtkPythonArgs::HasChanged(temp3, save3, size3) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(3, temp3, size3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMRenderViewProxy_ComputeVisibleScalarRange(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 5:
      return PyvtkSMRenderViewProxy_ComputeVisibleScalarRange_s1(self, args);
    case 4:
      return PyvtkSMRenderViewProxy_ComputeVisibleScalarRange_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "ComputeVisibleScalarRange");
  return nullptr;
}


static PyObject *
PyvtkSMRenderViewProxy_Pick(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Pick");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    vtkSMRepresentationProxy *tempr = (ap.IsBound() ?
      op->Pick(temp0, temp1) :
      op->vtkSMRenderViewProxy::Pick(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_PickBlock(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PickBlock");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  int temp0;
  int temp1;
  unsigned int temp2;
  int temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    vtkSMRepresentationProxy *tempr = (ap.IsBound() ?
      op->PickBlock(temp0, temp1, temp2, temp3) :
      op->vtkSMRenderViewProxy::PickBlock(temp0, temp1, temp2, temp3));

    if (!ap.ErrorOccurred())
    {
      ap.SetArgValue(2, temp2);
    }
    if (!ap.ErrorOccurred())
    {
      ap.SetArgValue(3, temp3);
    }
    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_ConvertDisplayToPointOnSurface(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ConvertDisplayToPointOnSurface");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  const size_t size0 = 2;
  int temp0[2];
  const size_t size1 = 3;
  double temp1[3];
  double save1[3];
  const size_t size2 = 3;
  double temp2[3];
  double save2[3];
  bool temp3 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3, 4) &&
      ap.GetArray(temp0, size0) &&
      ap.GetArray(temp1, size1) &&
      ap.GetArray(temp2, size2) &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)))
  {
    vtkPythonArgs::Save(temp1, save1, size1);
    vtkPythonArgs::Save(temp2, save2, size2);

    bool tempr = (ap.IsBound() ?
      op->ConvertDisplayToPointOnSurface(temp0, temp1, temp2, temp3) :
      op->vtkSMRenderViewProxy::ConvertDisplayToPointOnSurface(temp0, temp1, temp2, temp3));

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (vtkPythonArgs::HasChanged(temp2, save2, size2) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(2, temp2, size2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_IsSelectionAvailable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsSelectionAvailable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->IsSelectionAvailable() :
      op->vtkSMRenderViewProxy::IsSelectionAvailable());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_SynchronizeGeometryBounds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SynchronizeGeometryBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SynchronizeGeometryBounds();
    }
    else
    {
      op->vtkSMRenderViewProxy::SynchronizeGeometryBounds();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_ResetCamera_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ResetCamera");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  bool temp0 = false;
  double temp1 = 0.9;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0, 2) &&
      (ap.NoArgsLeft() || ap.GetValue(temp0)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    if (ap.IsBound())
    {
      op->ResetCamera(temp0, temp1);
    }
    else
    {
      op->vtkSMRenderViewProxy::ResetCamera(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkSMRenderViewProxy_ResetCamera_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ResetCamera");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  const size_t size0 = 6;
  double temp0[6];
  double save0[6];
  bool temp1 = false;
  double temp2 = 0.9;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 3) &&
      ap.GetArray(temp0, size0) &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->ResetCamera(temp0, temp1, temp2);
    }
    else
    {
      op->vtkSMRenderViewProxy::ResetCamera(temp0, temp1, temp2);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkSMRenderViewProxy_ResetCamera_s3(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ResetCamera");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  double temp0;
  double temp1;
  double temp2;
  double temp3;
  double temp4;
  double temp5;
  bool temp6 = false;
  double temp7 = 0.9;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(6, 8) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4) &&
      ap.GetValue(temp5) &&
      (ap.NoArgsLeft() || ap.GetValue(temp6)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp7)))
  {
    if (ap.IsBound())
    {
      op->ResetCamera(temp0, temp1, temp2, temp3, temp4, temp5, temp6, temp7);
    }
    else
    {
      op->vtkSMRenderViewProxy::ResetCamera(temp0, temp1, temp2, temp3, temp4, temp5, temp6, temp7);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkSMRenderViewProxy_ResetCamera_Methods[] = {
  {"ResetCamera", PyvtkSMRenderViewProxy_ResetCamera_s1, METH_VARARGS,
   "@|qd"},
  {"ResetCamera", PyvtkSMRenderViewProxy_ResetCamera_s2, METH_VARARGS,
   "@P|qd *d"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkSMRenderViewProxy_ResetCamera(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkSMRenderViewProxy_ResetCamera_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 0:
      return PyvtkSMRenderViewProxy_ResetCamera_s1(self, args);
    case 3:
      return PyvtkSMRenderViewProxy_ResetCamera_s2(self, args);
    case 6:
    case 7:
    case 8:
      return PyvtkSMRenderViewProxy_ResetCamera_s3(self, args);
    case 1:
    case 2:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "ResetCamera");
  return nullptr;
}


static PyObject *
PyvtkSMRenderViewProxy_ZoomTo(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ZoomTo");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  vtkSMProxy *temp0 = nullptr;
  bool temp1 = false;
  double temp2 = 0.9;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 3) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)))
  {
    if (ap.IsBound())
    {
      op->ZoomTo(temp0, temp1, temp2);
    }
    else
    {
      op->vtkSMRenderViewProxy::ZoomTo(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_IsSelectVisibleCellsAvailable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsSelectVisibleCellsAvailable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->IsSelectVisibleCellsAvailable() :
      op->vtkSMRenderViewProxy::IsSelectVisibleCellsAvailable());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_IsSelectVisiblePointsAvailable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsSelectVisiblePointsAvailable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->IsSelectVisiblePointsAvailable() :
      op->vtkSMRenderViewProxy::IsSelectVisiblePointsAvailable());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_SetupInteractor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetupInteractor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  vtkRenderWindowInteractor *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderWindowInteractor"))
  {
    if (ap.IsBound())
    {
      op->SetupInteractor(temp0);
    }
    else
    {
      op->vtkSMRenderViewProxy::SetupInteractor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_GetInteractor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInteractor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkRenderWindowInteractor *tempr = (ap.IsBound() ?
      op->GetInteractor() :
      op->vtkSMRenderViewProxy::GetInteractor());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_GetRenderer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRenderer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkRenderer *tempr = (ap.IsBound() ?
      op->GetRenderer() :
      op->vtkSMRenderViewProxy::GetRenderer());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_UpdateVTKObjects(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UpdateVTKObjects");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UpdateVTKObjects();
    }
    else
    {
      op->vtkSMRenderViewProxy::UpdateVTKObjects();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_GetActiveCamera(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetActiveCamera");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkCamera *tempr = (ap.IsBound() ?
      op->GetActiveCamera() :
      op->vtkSMRenderViewProxy::GetActiveCamera());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_AdjustActiveCamera_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AdjustActiveCamera");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  typedef vtkSMRenderViewProxy::CameraAdjustmentType temp0_type;
  temp0_type temp0;
  double temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetEnumValue(temp0, "vtkSMRenderViewProxy.CameraAdjustmentType") &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->AdjustActiveCamera(temp0, temp1);
    }
    else
    {
      op->vtkSMRenderViewProxy::AdjustActiveCamera(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkSMRenderViewProxy_AdjustActiveCamera_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AdjustActiveCamera");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  int temp0;
  double temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->AdjustActiveCamera(temp0, temp1);
    }
    else
    {
      op->vtkSMRenderViewProxy::AdjustActiveCamera(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkSMRenderViewProxy_AdjustActiveCamera_Methods[] = {
  {"AdjustActiveCamera", PyvtkSMRenderViewProxy_AdjustActiveCamera_s1, METH_VARARGS,
   "@Ed vtkSMRenderViewProxy.CameraAdjustmentType"},
  {"AdjustActiveCamera", PyvtkSMRenderViewProxy_AdjustActiveCamera_s2, METH_VARARGS,
   "@id"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkSMRenderViewProxy_AdjustActiveCamera(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkSMRenderViewProxy_AdjustActiveCamera_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "AdjustActiveCamera");
  return nullptr;
}


static PyObject *
PyvtkSMRenderViewProxy_AdjustAzimuth(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AdjustAzimuth");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->AdjustAzimuth(temp0);
    }
    else
    {
      op->vtkSMRenderViewProxy::AdjustAzimuth(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_AdjustElevation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AdjustElevation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->AdjustElevation(temp0);
    }
    else
    {
      op->vtkSMRenderViewProxy::AdjustElevation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_AdjustRoll(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AdjustRoll");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->AdjustRoll(temp0);
    }
    else
    {
      op->vtkSMRenderViewProxy::AdjustRoll(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_AdjustZoom(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AdjustZoom");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->AdjustZoom(temp0);
    }
    else
    {
      op->vtkSMRenderViewProxy::AdjustZoom(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_ApplyIsometricView(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ApplyIsometricView");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ApplyIsometricView();
    }
    else
    {
      op->vtkSMRenderViewProxy::ApplyIsometricView();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_ResetActiveCameraToDirection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ResetActiveCameraToDirection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  double temp0;
  double temp1;
  double temp2;
  double temp3;
  double temp4;
  double temp5;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(6) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4) &&
      ap.GetValue(temp5))
  {
    if (ap.IsBound())
    {
      op->ResetActiveCameraToDirection(temp0, temp1, temp2, temp3, temp4, temp5);
    }
    else
    {
      op->vtkSMRenderViewProxy::ResetActiveCameraToDirection(temp0, temp1, temp2, temp3, temp4, temp5);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_ResetActiveCameraToPositiveX(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ResetActiveCameraToPositiveX");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ResetActiveCameraToPositiveX();
    }
    else
    {
      op->vtkSMRenderViewProxy::ResetActiveCameraToPositiveX();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_ResetActiveCameraToNegativeX(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ResetActiveCameraToNegativeX");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ResetActiveCameraToNegativeX();
    }
    else
    {
      op->vtkSMRenderViewProxy::ResetActiveCameraToNegativeX();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_ResetActiveCameraToPositiveY(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ResetActiveCameraToPositiveY");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ResetActiveCameraToPositiveY();
    }
    else
    {
      op->vtkSMRenderViewProxy::ResetActiveCameraToPositiveY();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_ResetActiveCameraToNegativeY(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ResetActiveCameraToNegativeY");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ResetActiveCameraToNegativeY();
    }
    else
    {
      op->vtkSMRenderViewProxy::ResetActiveCameraToNegativeY();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_ResetActiveCameraToPositiveZ(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ResetActiveCameraToPositiveZ");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ResetActiveCameraToPositiveZ();
    }
    else
    {
      op->vtkSMRenderViewProxy::ResetActiveCameraToPositiveZ();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_ResetActiveCameraToNegativeZ(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ResetActiveCameraToNegativeZ");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ResetActiveCameraToNegativeZ();
    }
    else
    {
      op->vtkSMRenderViewProxy::ResetActiveCameraToNegativeZ();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_SynchronizeCameraProperties(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SynchronizeCameraProperties");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SynchronizeCameraProperties();
    }
    else
    {
      op->vtkSMRenderViewProxy::SynchronizeCameraProperties();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_LastRenderWasInteractive(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LastRenderWasInteractive");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->LastRenderWasInteractive() :
      op->vtkSMRenderViewProxy::LastRenderWasInteractive());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_Update(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Update");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Update();
    }
    else
    {
      op->vtkSMRenderViewProxy::Update();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_GetNeedsUpdate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNeedsUpdate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetNeedsUpdate() :
      op->vtkSMRenderViewProxy::GetNeedsUpdate());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_StreamingUpdate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "StreamingUpdate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->StreamingUpdate(temp0) :
      op->vtkSMRenderViewProxy::StreamingUpdate(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_GetRepresentationType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRepresentationType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  vtkSMSourceProxy *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMSourceProxy") &&
      ap.GetValue(temp1))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetRepresentationType(temp0, temp1) :
      op->vtkSMRenderViewProxy::GetRepresentationType(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_GetRenderWindow(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRenderWindow");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkRenderWindow *tempr = (ap.IsBound() ?
      op->GetRenderWindow() :
      op->vtkSMRenderViewProxy::GetRenderWindow());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_GetInteractorHelper(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInteractorHelper");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMViewProxyInteractorHelper *tempr = (ap.IsBound() ?
      op->GetInteractorHelper() :
      op->vtkSMRenderViewProxy::GetInteractorHelper());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_CaptureDepthBuffer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CaptureDepthBuffer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkFloatArray *tempr = (ap.IsBound() ?
      op->CaptureDepthBuffer() :
      op->vtkSMRenderViewProxy::CaptureDepthBuffer());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_GetSelectionRepresentationProxyName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSelectionRepresentationProxyName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetSelectionRepresentationProxyName() :
      op->vtkSMRenderViewProxy::GetSelectionRepresentationProxyName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_CopySelectionRepresentationProperties(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CopySelectionRepresentationProperties");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  vtkSMProxy *temp0 = nullptr;
  vtkSMProxy *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetVTKObject(temp1, "vtkSMProxy"))
  {
    if (ap.IsBound())
    {
      op->CopySelectionRepresentationProperties(temp0, temp1);
    }
    else
    {
      op->vtkSMRenderViewProxy::CopySelectionRepresentationProperties(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_ComputeVisibleBounds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ComputeVisibleBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  vtkSMProxy *temp0 = nullptr;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<double> store1(2*size1);
  double *temp1 = store1.Data();
  double *save1 = (size1 == 0 ? nullptr : temp1 + size1);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetArray(temp1, size1))
  {
    vtkPythonArgs::Save(temp1, save1, size1);

    if (ap.IsBound())
    {
      op->ComputeVisibleBounds(temp0, temp1);
    }
    else
    {
      op->vtkSMRenderViewProxy::ComputeVisibleBounds(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_ClearSelectionCache(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearSelectionCache");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0, 1) &&
      (ap.NoArgsLeft() || ap.GetValue(temp0)))
  {
    bool tempr = (ap.IsBound() ?
      op->ClearSelectionCache(temp0) :
      op->vtkSMRenderViewProxy::ClearSelectionCache(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_SetEnableSynchronizableActors(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEnableSynchronizableActors");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEnableSynchronizableActors(temp0);
    }
    else
    {
      op->vtkSMRenderViewProxy::SetEnableSynchronizableActors(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_GetEnableSynchronizableActors(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEnableSynchronizableActors");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetEnableSynchronizableActors() :
      op->vtkSMRenderViewProxy::GetEnableSynchronizableActors());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_GetIsInCAVE(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetIsInCAVE");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetIsInCAVE() :
      op->vtkSMRenderViewProxy::GetIsInCAVE());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_GetNumberOfDisplays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfDisplays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfDisplays() :
      op->vtkSMRenderViewProxy::GetNumberOfDisplays());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_GetEyeSeparation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEyeSeparation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetEyeSeparation() :
      op->vtkSMRenderViewProxy::GetEyeSeparation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_GetShowBorders(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetShowBorders");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetShowBorders() :
      op->vtkSMRenderViewProxy::GetShowBorders());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_GetFullScreen(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFullScreen");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetFullScreen() :
      op->vtkSMRenderViewProxy::GetFullScreen());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_GetGeometry(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGeometry");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkTuple<int, 4> tempr = (ap.IsBound() ?
      op->GetGeometry(temp0) :
      op->vtkSMRenderViewProxy::GetGeometry(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildSpecialObject(&tempr, "vtkTuple_IiLi4EE");
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_GetHasCorners(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetHasCorners");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetHasCorners(temp0) :
      op->vtkSMRenderViewProxy::GetHasCorners(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_GetLowerLeft(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLowerLeft");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkTuple<double, 3> tempr = (ap.IsBound() ?
      op->GetLowerLeft(temp0) :
      op->vtkSMRenderViewProxy::GetLowerLeft(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildSpecialObject(&tempr, "vtkTuple_IdLi3EE");
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_GetLowerRight(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLowerRight");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkTuple<double, 3> tempr = (ap.IsBound() ?
      op->GetLowerRight(temp0) :
      op->vtkSMRenderViewProxy::GetLowerRight(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildSpecialObject(&tempr, "vtkTuple_IdLi3EE");
    }
  }

  return result;
}


static PyObject *
PyvtkSMRenderViewProxy_GetUpperRight(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUpperRight");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRenderViewProxy *op = static_cast<vtkSMRenderViewProxy *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkTuple<double, 3> tempr = (ap.IsBound() ?
      op->GetUpperRight(temp0) :
      op->vtkSMRenderViewProxy::GetUpperRight(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildSpecialObject(&tempr, "vtkTuple_IdLi3EE");
    }
  }

  return result;
}

static PyMethodDef PyvtkSMRenderViewProxy_Methods[] = {
  {"IsTypeOf", PyvtkSMRenderViewProxy_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSMRenderViewProxy_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSMRenderViewProxy_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSMRenderViewProxy\nC++: static vtkSMRenderViewProxy *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSMRenderViewProxy_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSMRenderViewProxy\nC++: vtkSMRenderViewProxy *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSMRenderViewProxy_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSMRenderViewProxy_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SelectSurfaceCells", PyvtkSMRenderViewProxy_SelectSurfaceCells, METH_VARARGS,
   "SelectSurfaceCells(self, region:(int, int, int, int),\n    selectedRepresentations:vtkCollection,\n    selectionSources:vtkCollection,\n    multiple_selections:bool=False, modifier:int=0,\n    select_blocks:bool=False, arrayName:str=...) -> bool\nC++: bool SelectSurfaceCells(const int region[4],\n    vtkCollection *selectedRepresentations,\n    vtkCollection *selectionSources,\n    bool multiple_selections=false, int modifier=0,\n    bool select_blocks=false, const char *arrayName=nullptr)\n\nMakes a new selection source proxy.\n"},
  {"SelectSurfacePoints", PyvtkSMRenderViewProxy_SelectSurfacePoints, METH_VARARGS,
   "SelectSurfacePoints(self, region:(int, int, int, int),\n    selectedRepresentations:vtkCollection,\n    selectionSources:vtkCollection,\n    multiple_selections:bool=False, modifier:int=0,\n    select_blocks:bool=False, arrayName:str=...) -> bool\nC++: bool SelectSurfacePoints(const int region[4],\n    vtkCollection *selectedRepresentations,\n    vtkCollection *selectionSources,\n    bool multiple_selections=false, int modifier=0,\n    bool select_blocks=false, const char *arrayName=nullptr)\n\n"},
  {"SelectFrustumCells", PyvtkSMRenderViewProxy_SelectFrustumCells, METH_VARARGS,
   "SelectFrustumCells(self, region:(int, int, int, int),\n    selectedRepresentations:vtkCollection,\n    selectionSources:vtkCollection,\n    multiple_selections:bool=False) -> bool\nC++: bool SelectFrustumCells(const int region[4],\n    vtkCollection *selectedRepresentations,\n    vtkCollection *selectionSources,\n    bool multiple_selections=false)\n\n"},
  {"SelectFrustumPoints", PyvtkSMRenderViewProxy_SelectFrustumPoints, METH_VARARGS,
   "SelectFrustumPoints(self, region:(int, int, int, int),\n    selectedRepresentations:vtkCollection,\n    selectionSources:vtkCollection,\n    multiple_selections:bool=False) -> bool\nC++: bool SelectFrustumPoints(const int region[4],\n    vtkCollection *selectedRepresentations,\n    vtkCollection *selectionSources,\n    bool multiple_selections=false)\n\n"},
  {"SelectPolygonPoints", PyvtkSMRenderViewProxy_SelectPolygonPoints, METH_VARARGS,
   "SelectPolygonPoints(self, polygon:vtkIntArray,\n    selectedRepresentations:vtkCollection,\n    selectionSources:vtkCollection,\n    multiple_selections:bool=False, modifier:int=0,\n    selectBlocks:bool=False) -> bool\nC++: bool SelectPolygonPoints(vtkIntArray *polygon,\n    vtkCollection *selectedRepresentations,\n    vtkCollection *selectionSources,\n    bool multiple_selections=false, int modifier=0,\n    bool selectBlocks=false)\n\n"},
  {"SelectPolygonCells", PyvtkSMRenderViewProxy_SelectPolygonCells, METH_VARARGS,
   "SelectPolygonCells(self, polygon:vtkIntArray,\n    selectedRepresentations:vtkCollection,\n    selectionSources:vtkCollection,\n    multiple_selections:bool=False, modifier:int=0,\n    selectBlocks:bool=False) -> bool\nC++: bool SelectPolygonCells(vtkIntArray *polygon,\n    vtkCollection *selectedRepresentations,\n    vtkCollection *selectionSources,\n    bool multiple_selections=false, int modifier=0,\n    bool selectBlocks=false)\n\n"},
  {"ComputeVisibleScalarRange", PyvtkSMRenderViewProxy_ComputeVisibleScalarRange, METH_VARARGS,
   "ComputeVisibleScalarRange(self, region:(int, int, int, int),\n    fieldAssociation:int, scalarName:str, component:int,\n    range:[float, ...]) -> bool\nC++: bool ComputeVisibleScalarRange(const int region[4],\n    int fieldAssociation, const char *scalarName, int component,\n    double range[])\nComputeVisibleScalarRange(self, fieldAssociation:int,\n    scalarName:str, component:int, range:[float, ...]) -> bool\nC++: bool ComputeVisibleScalarRange(int fieldAssociation,\n    const char *scalarName, int component, double range[])\n\nReturns the range for visible elements in the current view.\n"},
  {"Pick", PyvtkSMRenderViewProxy_Pick, METH_VARARGS,
   "Pick(self, x:int, y:int) -> vtkSMRepresentationProxy\nC++: vtkSMRepresentationProxy *Pick(int x, int y)\n\nConvenience method to pick a location. Internally uses\nSelectSurfaceCells to locate the picked object. In future, we can\nmake this faster.\n"},
  {"PickBlock", PyvtkSMRenderViewProxy_PickBlock, METH_VARARGS,
   "PickBlock(self, x:int, y:int, flatIndex:int, rank:int)\n    -> vtkSMRepresentationProxy\nC++: vtkSMRepresentationProxy *PickBlock(int x, int y,\n    unsigned int &flatIndex, int &rank)\n\nConvenience method to pick a block in a multi-block data set.\nWill return the selected representation. Furthermore, if it is a\nmulti-block data set the flat index of the selected block will be\nreturned in flatIndex.\n\nWith introduction of vtkPartitionedDataSet and\nvtkPartitionedDataSetCollection, flatIndex is no longer\nconsistent across ranks and hence this method was changed to\nreturn the rank number as well.\n"},
  {"ConvertDisplayToPointOnSurface", PyvtkSMRenderViewProxy_ConvertDisplayToPointOnSurface, METH_VARARGS,
   "ConvertDisplayToPointOnSurface(self, display_position:(int, int),\n    world_position:[float, float, float], world_normal:[float,\n    float, float], snapOnMeshPoint:bool=False) -> bool\nC++: bool ConvertDisplayToPointOnSurface(\n    const int display_position[2], double world_position[3],\n    double world_normal[3], bool snapOnMeshPoint=false)\n\nGiven a location is display coordinates (pixels), tries to\ncompute and return the world location and normal on a surface, if\npossible. Returns true if the conversion was successful, else\nassigns the focal point and plane normal and returns false. If\nSnap on mesh point is true, it will return a point and normal\nfrom the mesh only. If point or normal were not available, they\nwill have a vector of std::numeric_limits::quiet_NaN().\n"},
  {"IsSelectionAvailable", PyvtkSMRenderViewProxy_IsSelectionAvailable, METH_VARARGS,
   "IsSelectionAvailable(self) -> bool\nC++: virtual bool IsSelectionAvailable()\n\nChecks if color depth is sufficient to support selection. If not,\nwill return 0 and any calls to SelectVisibleCells will quietly\nreturn an empty selection.\n"},
  {"SynchronizeGeometryBounds", PyvtkSMRenderViewProxy_SynchronizeGeometryBounds, METH_VARARGS,
   "SynchronizeGeometryBounds(self) -> None\nC++: void SynchronizeGeometryBounds()\n\nCall SynchronizeGeometryBounds server side\n"},
  {"ResetCamera", PyvtkSMRenderViewProxy_ResetCamera, METH_VARARGS,
   "ResetCamera(self, closest:bool=False, offsetRatio:float=0.9)\n    -> None\nC++: void ResetCamera(bool closest=false, double offsetRatio=0.9)\nResetCamera(self, bounds:[float, float, float, float, float,\n    float], closest:bool=False, offsetRatio:float=0.9) -> None\nC++: void ResetCamera(double bounds[6], bool closest=false,\n    double offsetRatio=0.9)\nResetCamera(self, xmin:float, xmax:float, ymin:float, ymax:float,\n    zmin:float, zmax:float, closest:bool=False,\n    offsetRatio:float=0.9) -> None\nC++: void ResetCamera(double xmin, double xmax, double ymin,\n    double ymax, double zmin, double zmax, bool closest=false,\n    double offsetRatio=0.9)\n\nFor backwards compatibility in Python scripts.\n\nOffsetRatio can be used to add a zoom offset (only applicable\nwhen closest is true).\n"},
  {"ZoomTo", PyvtkSMRenderViewProxy_ZoomTo, METH_VARARGS,
   "ZoomTo(self, representation:vtkSMProxy, closest:bool=False,\n    offsetRatio:float=0.9) -> None\nC++: virtual void ZoomTo(vtkSMProxy *representation,\n    bool closest=false, double offsetRatio=0.9)\n\nConvenience method for zooming to a representation.\n\nOffsetRatio can be used to add a zoom offset (only applicable\nwhen closest is true).\n"},
  {"IsSelectVisibleCellsAvailable", PyvtkSMRenderViewProxy_IsSelectVisibleCellsAvailable, METH_VARARGS,
   "IsSelectVisibleCellsAvailable(self) -> str\nC++: virtual const char *IsSelectVisibleCellsAvailable()\n\nSimilar to IsSelectionAvailable(), however, on failure returns\nthe error message otherwise 0.\n"},
  {"IsSelectVisiblePointsAvailable", PyvtkSMRenderViewProxy_IsSelectVisiblePointsAvailable, METH_VARARGS,
   "IsSelectVisiblePointsAvailable(self) -> str\nC++: virtual const char *IsSelectVisiblePointsAvailable()\n\n"},
  {"SetupInteractor", PyvtkSMRenderViewProxy_SetupInteractor, METH_VARARGS,
   "SetupInteractor(self, iren:vtkRenderWindowInteractor) -> None\nC++: void SetupInteractor(vtkRenderWindowInteractor *iren)\n    override;\n\nA client process need to set the interactor to enable\ninteractivity. Use this method to set the interactor and\ninitialize it as needed by the RenderView. This include changing\nthe interactor style as well as overriding VTK rendering to use\nthe Proxy/ViewProxy API instead.\n"},
  {"GetInteractor", PyvtkSMRenderViewProxy_GetInteractor, METH_VARARGS,
   "GetInteractor(self) -> vtkRenderWindowInteractor\nC++: vtkRenderWindowInteractor *GetInteractor() override;\n\nReturns the interactor.\n"},
  {"GetRenderer", PyvtkSMRenderViewProxy_GetRenderer, METH_VARARGS,
   "GetRenderer(self) -> vtkRenderer\nC++: vtkRenderer *GetRenderer()\n\nReturns the client-side renderer (composited or 3D).\n"},
  {"UpdateVTKObjects", PyvtkSMRenderViewProxy_UpdateVTKObjects, METH_VARARGS,
   "UpdateVTKObjects(self) -> None\nC++: void UpdateVTKObjects() override;\n\nFilter changes to the OSPRay rendering method, to transfer the\npathtracing materials from client to server only when they are\nacutally needed. Use this method instead of `UpdateProperty` when\nchanging the OSPRay back-end for the default materials to load\nproperly.\n"},
  {"GetActiveCamera", PyvtkSMRenderViewProxy_GetActiveCamera, METH_VARARGS,
   "GetActiveCamera(self) -> vtkCamera\nC++: vtkCamera *GetActiveCamera()\n\nReturns the client-side active camera object. Helper methods to\nadjust its orientation and position.\n"},
  {"AdjustActiveCamera", PyvtkSMRenderViewProxy_AdjustActiveCamera, METH_VARARGS,
   "AdjustActiveCamera(self, __a:CameraAdjustmentType, __b:float)\n    -> None\nC++: void AdjustActiveCamera(const CameraAdjustmentType &,\n    const double &)\nAdjustActiveCamera(self, __a:int, __b:float) -> None\nC++: void AdjustActiveCamera(const int &, const double &)\n\n"},
  {"AdjustAzimuth", PyvtkSMRenderViewProxy_AdjustAzimuth, METH_VARARGS,
   "AdjustAzimuth(self, value:float) -> None\nC++: void AdjustAzimuth(const double &value)\n\n"},
  {"AdjustElevation", PyvtkSMRenderViewProxy_AdjustElevation, METH_VARARGS,
   "AdjustElevation(self, value:float) -> None\nC++: void AdjustElevation(const double &value)\n\n"},
  {"AdjustRoll", PyvtkSMRenderViewProxy_AdjustRoll, METH_VARARGS,
   "AdjustRoll(self, value:float) -> None\nC++: void AdjustRoll(const double &value)\n\n"},
  {"AdjustZoom", PyvtkSMRenderViewProxy_AdjustZoom, METH_VARARGS,
   "AdjustZoom(self, value:float) -> None\nC++: void AdjustZoom(const double &value)\n\n"},
  {"ApplyIsometricView", PyvtkSMRenderViewProxy_ApplyIsometricView, METH_VARARGS,
   "ApplyIsometricView(self) -> None\nC++: void ApplyIsometricView()\n\n"},
  {"ResetActiveCameraToDirection", PyvtkSMRenderViewProxy_ResetActiveCameraToDirection, METH_VARARGS,
   "ResetActiveCameraToDirection(self, look_x:float, look_y:float,\n    look_z:float, up_x:float, up_y:float, up_z:float) -> None\nC++: void ResetActiveCameraToDirection(const double &look_x,\n    const double &look_y, const double &look_z,\n    const double &up_x, const double &up_y, const double &up_z)\n\n"},
  {"ResetActiveCameraToPositiveX", PyvtkSMRenderViewProxy_ResetActiveCameraToPositiveX, METH_VARARGS,
   "ResetActiveCameraToPositiveX(self) -> None\nC++: void ResetActiveCameraToPositiveX()\n\n"},
  {"ResetActiveCameraToNegativeX", PyvtkSMRenderViewProxy_ResetActiveCameraToNegativeX, METH_VARARGS,
   "ResetActiveCameraToNegativeX(self) -> None\nC++: void ResetActiveCameraToNegativeX()\n\n"},
  {"ResetActiveCameraToPositiveY", PyvtkSMRenderViewProxy_ResetActiveCameraToPositiveY, METH_VARARGS,
   "ResetActiveCameraToPositiveY(self) -> None\nC++: void ResetActiveCameraToPositiveY()\n\n"},
  {"ResetActiveCameraToNegativeY", PyvtkSMRenderViewProxy_ResetActiveCameraToNegativeY, METH_VARARGS,
   "ResetActiveCameraToNegativeY(self) -> None\nC++: void ResetActiveCameraToNegativeY()\n\n"},
  {"ResetActiveCameraToPositiveZ", PyvtkSMRenderViewProxy_ResetActiveCameraToPositiveZ, METH_VARARGS,
   "ResetActiveCameraToPositiveZ(self) -> None\nC++: void ResetActiveCameraToPositiveZ()\n\n"},
  {"ResetActiveCameraToNegativeZ", PyvtkSMRenderViewProxy_ResetActiveCameraToNegativeZ, METH_VARARGS,
   "ResetActiveCameraToNegativeZ(self) -> None\nC++: void ResetActiveCameraToNegativeZ()\n\n"},
  {"SynchronizeCameraProperties", PyvtkSMRenderViewProxy_SynchronizeCameraProperties, METH_VARARGS,
   "SynchronizeCameraProperties(self) -> None\nC++: void SynchronizeCameraProperties()\n\nThis method calls UpdateInformation on the Camera Proxy and sets\nthe Camera properties according to the info properties. This\napproach is a bit lame. We need to ensure that camera properties\nare always/automatically synchronized. Camera properties cannot\nbe treated same way as other properties.\n"},
  {"LastRenderWasInteractive", PyvtkSMRenderViewProxy_LastRenderWasInteractive, METH_VARARGS,
   "LastRenderWasInteractive(self) -> bool\nC++: virtual bool LastRenderWasInteractive()\n\nReturns true if the most recent render indeed employed low-res\nrendering.\n"},
  {"Update", PyvtkSMRenderViewProxy_Update, METH_VARARGS,
   "Update(self) -> None\nC++: void Update() override;\n\nCalled vtkPVView::Update on the server-side. Overridden to update\nthe state of NeedsUpdateLOD flag.\n"},
  {"GetNeedsUpdate", PyvtkSMRenderViewProxy_GetNeedsUpdate, METH_VARARGS,
   "GetNeedsUpdate(self) -> bool\nC++: bool GetNeedsUpdate() override;\n\nWe override that method to handle LOD and non-LOD NeedsUpdate in\ntransparent manner.\n"},
  {"StreamingUpdate", PyvtkSMRenderViewProxy_StreamingUpdate, METH_VARARGS,
   "StreamingUpdate(self, render_if_needed:bool) -> bool\nC++: bool StreamingUpdate(bool render_if_needed)\n\nCalled to render a streaming pass. Returns true if the view\n\"streamed\" some geometry.\n"},
  {"GetRepresentationType", PyvtkSMRenderViewProxy_GetRepresentationType, METH_VARARGS,
   "GetRepresentationType(self, producer:vtkSMSourceProxy,\n    outputPort:int) -> str\nC++: const char *GetRepresentationType(vtkSMSourceProxy *producer,\n     int outputPort) override;\n\nOverridden to check through the various representations that this\nview can create.\n"},
  {"GetRenderWindow", PyvtkSMRenderViewProxy_GetRenderWindow, METH_VARARGS,
   "GetRenderWindow(self) -> vtkRenderWindow\nC++: vtkRenderWindow *GetRenderWindow() override;\n\nReturns the render window used by this view.\n"},
  {"GetInteractorHelper", PyvtkSMRenderViewProxy_GetInteractorHelper, METH_VARARGS,
   "GetInteractorHelper(self) -> vtkSMViewProxyInteractorHelper\nC++: vtkSMViewProxyInteractorHelper *GetInteractorHelper()\n\nProvides access to the vtkSMViewProxyInteractorHelper object that\nhandles the interaction/view sync. We provide access to it for\napplications to monitor timer events etc.\n"},
  {"CaptureDepthBuffer", PyvtkSMRenderViewProxy_CaptureDepthBuffer, METH_VARARGS,
   "CaptureDepthBuffer(self) -> vtkFloatArray\nC++: vtkFloatArray *CaptureDepthBuffer()\n\nAccess to the Z buffer.\n"},
  {"GetSelectionRepresentationProxyName", PyvtkSMRenderViewProxy_GetSelectionRepresentationProxyName, METH_VARARGS,
   "GetSelectionRepresentationProxyName(self) -> str\nC++: virtual const char *GetSelectionRepresentationProxyName()\n\nGet the SelectionRepresentation proxy name.\n"},
  {"CopySelectionRepresentationProperties", PyvtkSMRenderViewProxy_CopySelectionRepresentationProperties, METH_VARARGS,
   "CopySelectionRepresentationProperties(self,\n    fromSelectionRep:vtkSMProxy, toSelectionRep:vtkSMProxy)\n    -> None\nC++: virtual void CopySelectionRepresentationProperties(\n    vtkSMProxy *fromSelectionRep, vtkSMProxy *toSelectionRep)\n\nFunction to copy selection representation properties.\n"},
  {"ComputeVisibleBounds", PyvtkSMRenderViewProxy_ComputeVisibleBounds, METH_VARARGS,
   "ComputeVisibleBounds(self, representation:vtkSMProxy,\n    bounds:[float, ...]) -> None\nC++: void ComputeVisibleBounds(vtkSMProxy *representation,\n    double *bounds)\n\nCompute the bounds of the visible data on the given\nrepresentation. Delegated to the server side (vtkPVRenderView).\n"},
  {"ClearSelectionCache", PyvtkSMRenderViewProxy_ClearSelectionCache, METH_VARARGS,
   "ClearSelectionCache(self, force:bool=False) -> bool\nC++: bool ClearSelectionCache(bool force=false)\n\nTries to clear the selection cache (if needed). Returns a boolean\nvalue which indicates whether the cache has been cleared.\n"},
  {"SetEnableSynchronizableActors", PyvtkSMRenderViewProxy_SetEnableSynchronizableActors, METH_VARARGS,
   "SetEnableSynchronizableActors(self, __a:bool) -> None\nC++: void SetEnableSynchronizableActors(bool)\n\nTurn on/off synchronizable actors.  This is needed for immersive\ncollaboration, (such as CAVEs) so that various types of vtkActor\ncan be synchronized to all displays.  It is off/disabled by\ndefault.\n"},
  {"GetEnableSynchronizableActors", PyvtkSMRenderViewProxy_GetEnableSynchronizableActors, METH_VARARGS,
   "GetEnableSynchronizableActors(self) -> bool\nC++: bool GetEnableSynchronizableActors()\n\n"},
  {"GetIsInCAVE", PyvtkSMRenderViewProxy_GetIsInCAVE, METH_VARARGS,
   "GetIsInCAVE(self) -> bool\nC++: bool GetIsInCAVE()\n\nGet whether system is in CAVE mode.\n\n@return bool\n"},
  {"GetNumberOfDisplays", PyvtkSMRenderViewProxy_GetNumberOfDisplays, METH_VARARGS,
   "GetNumberOfDisplays(self) -> int\nC++: int GetNumberOfDisplays()\n\nGet the number of remote displays.\n\n@return int\n"},
  {"GetEyeSeparation", PyvtkSMRenderViewProxy_GetEyeSeparation, METH_VARARGS,
   "GetEyeSeparation(self) -> float\nC++: double GetEyeSeparation()\n\nGet the remotely configured eye separation.\n\n@return int\n"},
  {"GetShowBorders", PyvtkSMRenderViewProxy_GetShowBorders, METH_VARARGS,
   "GetShowBorders(self) -> bool\nC++: bool GetShowBorders()\n\nGet whether or not remote displays show borders.\n\n@return bool\n"},
  {"GetFullScreen", PyvtkSMRenderViewProxy_GetFullScreen, METH_VARARGS,
   "GetFullScreen(self) -> bool\nC++: bool GetFullScreen()\n\nGet whether or not remote displays are fullscreen.\n\n@return bool\n"},
  {"GetGeometry", PyvtkSMRenderViewProxy_GetGeometry, METH_VARARGS,
   "GetGeometry(self, index:int) -> vtkTuple_IiLi4EE\nC++: vtkTuple<int, 4> GetGeometry(int index)\n\nGet the geometry of the screen at the given index, as\n(x, y, width, height).\n\n@return vtkTuple<int, 4>\n"},
  {"GetHasCorners", PyvtkSMRenderViewProxy_GetHasCorners, METH_VARARGS,
   "GetHasCorners(self, index:int) -> bool\nC++: bool GetHasCorners(int index)\n\nGet whether or not the given display has screen corner\nset.\n\n@return bool\n"},
  {"GetLowerLeft", PyvtkSMRenderViewProxy_GetLowerLeft, METH_VARARGS,
   "GetLowerLeft(self, index:int) -> vtkTuple_IdLi3EE\nC++: vtkTuple<double, 3> GetLowerLeft(int index)\n\nGet the lower left corner of the screen at the given\nindex, as (x, y, z).\n\n@return vtkTuple<double, 3>\n"},
  {"GetLowerRight", PyvtkSMRenderViewProxy_GetLowerRight, METH_VARARGS,
   "GetLowerRight(self, index:int) -> vtkTuple_IdLi3EE\nC++: vtkTuple<double, 3> GetLowerRight(int index)\n\nGet the lower right corner of the screen at the given\nindex, as (x, y, z).\n\n@return vtkTuple<double, 3>\n"},
  {"GetUpperRight", PyvtkSMRenderViewProxy_GetUpperRight, METH_VARARGS,
   "GetUpperRight(self, index:int) -> vtkTuple_IdLi3EE\nC++: vtkTuple<double, 3> GetUpperRight(int index)\n\nGet the upper right corner of the screen at the given\nindex, as (x, y, z).\n\n@return vtkTuple<double, 3>\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSMRenderViewProxy_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("enable_synchronizable_actors"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMRenderViewProxy_GetEnableSynchronizableActors(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMRenderViewProxy_SetEnableSynchronizableActors(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMRenderViewProxy_SetEnableSynchronizableActors(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEnableSynchronizableActors/SetEnableSynchronizableActors\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("interactor"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMRenderViewProxy_GetInteractor(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetInteractor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("renderer"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMRenderViewProxy_GetRenderer(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetRenderer\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_camera"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMRenderViewProxy_GetActiveCamera(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetActiveCamera\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("needs_update"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMRenderViewProxy_GetNeedsUpdate(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNeedsUpdate\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("render_window"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMRenderViewProxy_GetRenderWindow(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetRenderWindow\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("interactor_helper"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMRenderViewProxy_GetInteractorHelper(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetInteractorHelper\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("selection_representation_proxy_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMRenderViewProxy_GetSelectionRepresentationProxyName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetSelectionRepresentationProxyName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("is_in_cave"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMRenderViewProxy_GetIsInCAVE(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetIsInCAVE\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("eye_separation"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMRenderViewProxy_GetEyeSeparation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetEyeSeparation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("show_borders"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMRenderViewProxy_GetShowBorders(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetShowBorders\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("full_screen"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMRenderViewProxy_GetFullScreen(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetFullScreen\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_displays"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMRenderViewProxy_GetNumberOfDisplays(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfDisplays\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSMRenderViewProxy_Doc =
  "vtkSMRenderViewProxy - implementation for View that includes render\nwindow and renderers.\n\n"
  "Superclass: vtkSMViewProxy\n\n"
  "vtkSMRenderViewProxy is a 3D view consisting for a render window and\n"
  "two renderers: 1 for 3D geometry and 1 for overlaid 2D geometry.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMRenderViewProxy_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkSMRenderViewProxy", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSMRenderViewProxy_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSMRenderViewProxy_StaticNew()
{
  return vtkSMRenderViewProxy::New();
}

PyObject *PyvtkSMRenderViewProxy_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSMRenderViewProxy_Type, PyvtkSMRenderViewProxy_Methods,
    "vtkSMRenderViewProxy",
 &PyvtkSMRenderViewProxy_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkSMViewProxy_ClassNew();

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyvtkSMRenderViewProxy_CameraAdjustmentType_Type);
  // members of vtkSMRenderViewProxy::CameraAdjustmentType
  {
    PyObject *enumval;
    PyObject *enumdict = PyDict_New();
    PyvtkSMRenderViewProxy_CameraAdjustmentType_Type.tp_dict = enumdict;

    typedef vtkSMRenderViewProxy::CameraAdjustmentType cxx_enum_type;
    static const struct {
      const char *name; cxx_enum_type value;
    } constants[4] = {
      { "Roll", cxx_enum_type::Roll },
      { "Elevation", cxx_enum_type::Elevation },
      { "Azimuth", cxx_enum_type::Azimuth },
      { "Zoom", cxx_enum_type::Zoom },
    };

    for (int c = 0; c < 4; c++)
    {
      enumval = PyvtkSMRenderViewProxy_CameraAdjustmentType_FromEnum(constants[c].value);
      if (enumval)
      {
        PyDict_SetItemString(enumdict, constants[c].name, enumval);
        Py_DECREF(enumval);
      }
    }
  }

  PyVTKEnum_Add(&PyvtkSMRenderViewProxy_CameraAdjustmentType_Type, "vtkSMRenderViewProxy.CameraAdjustmentType");

  o = (PyObject *)&PyvtkSMRenderViewProxy_CameraAdjustmentType_Type;
  if (PyDict_SetItemString(d, "CameraAdjustmentType", o) != 0)
  {
    Py_DECREF(o);
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSMRenderViewProxy_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSMRenderViewProxy(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSMRenderViewProxy_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSMRenderViewProxy", o) != 0)
  {
    Py_DECREF(o);
  }

}

