// python wrapper for vtkRemotingCoreConfiguration
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkProcessModule.h"
#include "vtkRemotingCoreConfiguration.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkRemotingCoreConfiguration(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkRemotingCoreConfiguration_ClassNew(); }

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkRemotingCoreConfiguration_OpenGLWindowBackendEnum_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingCore.vtkRemotingCoreConfiguration.OpenGLWindowBackendEnum", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkRemotingCoreConfiguration_OpenGLWindowBackendEnum_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkRemotingCoreConfiguration_OpenGLWindowBackendEnum_Type, static_cast<int>(val));
}


static PyObject *
PyvtkRemotingCoreConfiguration_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkRemotingCoreConfiguration::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkRemotingCoreConfiguration::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkRemotingCoreConfiguration *tempr = vtkRemotingCoreConfiguration::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkRemotingCoreConfiguration *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkRemotingCoreConfiguration::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkRemotingCoreConfiguration::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkRemotingCoreConfiguration::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_GetInstance(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetInstance");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkRemotingCoreConfiguration *tempr = vtkRemotingCoreConfiguration::GetInstance();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_GetTellVersion(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTellVersion");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetTellVersion() :
      op->vtkRemotingCoreConfiguration::GetTellVersion());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_GetDisableRegistry(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDisableRegistry");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetDisableRegistry() :
      op->vtkRemotingCoreConfiguration::GetDisableRegistry());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_GetPrintMonitors(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPrintMonitors");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetPrintMonitors() :
      op->vtkRemotingCoreConfiguration::GetPrintMonitors());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_SetHostName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetHostName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetHostName(temp0);
    }
    else
    {
      op->vtkRemotingCoreConfiguration::SetHostName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_GetHostName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetHostName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetHostName() :
      op->vtkRemotingCoreConfiguration::GetHostName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_SetClientHostName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetClientHostName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetClientHostName(temp0);
    }
    else
    {
      op->vtkRemotingCoreConfiguration::SetClientHostName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_GetClientHostName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetClientHostName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetClientHostName() :
      op->vtkRemotingCoreConfiguration::GetClientHostName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_SetServerPort(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetServerPort");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetServerPort(temp0);
    }
    else
    {
      op->vtkRemotingCoreConfiguration::SetServerPort(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_GetServerPort(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetServerPort");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetServerPort() :
      op->vtkRemotingCoreConfiguration::GetServerPort());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_SetBindAddress(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBindAddress");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBindAddress(temp0);
    }
    else
    {
      op->vtkRemotingCoreConfiguration::SetBindAddress(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_GetBindAddress(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBindAddress");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetBindAddress() :
      op->vtkRemotingCoreConfiguration::GetBindAddress());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_SetReverseConnection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetReverseConnection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetReverseConnection(temp0);
    }
    else
    {
      op->vtkRemotingCoreConfiguration::SetReverseConnection(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_GetReverseConnection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetReverseConnection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetReverseConnection() :
      op->vtkRemotingCoreConfiguration::GetReverseConnection());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_SetConnectID(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetConnectID");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetConnectID(temp0);
    }
    else
    {
      op->vtkRemotingCoreConfiguration::SetConnectID(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_GetConnectID(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetConnectID");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetConnectID() :
      op->vtkRemotingCoreConfiguration::GetConnectID());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_SetTimeout(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTimeout");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTimeout(temp0);
    }
    else
    {
      op->vtkRemotingCoreConfiguration::SetTimeout(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_GetTimeout(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTimeout");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetTimeout() :
      op->vtkRemotingCoreConfiguration::GetTimeout());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_SetTimeoutCommand(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTimeoutCommand");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTimeoutCommand(temp0);
    }
    else
    {
      op->vtkRemotingCoreConfiguration::SetTimeoutCommand(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_GetTimeoutCommand(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTimeoutCommand");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetTimeoutCommand() :
      op->vtkRemotingCoreConfiguration::GetTimeoutCommand());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_SetTimeoutCommandInterval(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTimeoutCommandInterval");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTimeoutCommandInterval(temp0);
    }
    else
    {
      op->vtkRemotingCoreConfiguration::SetTimeoutCommandInterval(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_GetTimeoutCommandInterval(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTimeoutCommandInterval");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetTimeoutCommandInterval() :
      op->vtkRemotingCoreConfiguration::GetTimeoutCommandInterval());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_GetServerURL(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetServerURL");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetServerURL() :
      op->vtkRemotingCoreConfiguration::GetServerURL());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_GetServerResourceName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetServerResourceName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetServerResourceName() :
      op->vtkRemotingCoreConfiguration::GetServerResourceName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_GetServerConfigurationsFiles(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetServerConfigurationsFiles");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const std::vector<std::string> *tempr = (ap.IsBound() ?
      &op->GetServerConfigurationsFiles() :
      &op->vtkRemotingCoreConfiguration::GetServerConfigurationsFiles());

    if (!ap.ErrorOccurred())
    {
      if (tempr->empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr->data(), tempr->size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_GetPluginSearchPaths(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPluginSearchPaths");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const std::vector<std::string> *tempr = (ap.IsBound() ?
      &op->GetPluginSearchPaths() :
      &op->vtkRemotingCoreConfiguration::GetPluginSearchPaths());

    if (!ap.ErrorOccurred())
    {
      if (tempr->empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr->data(), tempr->size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_GetPlugins(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPlugins");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const std::vector<std::string> *tempr = (ap.IsBound() ?
      &op->GetPlugins() :
      &op->vtkRemotingCoreConfiguration::GetPlugins());

    if (!ap.ErrorOccurred())
    {
      if (tempr->empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr->data(), tempr->size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_GetUseStereoRendering(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseStereoRendering");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseStereoRendering() :
      op->vtkRemotingCoreConfiguration::GetUseStereoRendering());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_GetStereoType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetStereoType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetStereoType() :
      op->vtkRemotingCoreConfiguration::GetStereoType());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_GetStereoTypeAsString(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetStereoTypeAsString");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetStereoTypeAsString() :
      op->vtkRemotingCoreConfiguration::GetStereoTypeAsString());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_GetEyeSeparation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEyeSeparation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetEyeSeparation() :
      op->vtkRemotingCoreConfiguration::GetEyeSeparation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_GetTileMullions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTileMullions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int *tempr = (ap.IsBound() ?
      op->GetTileMullions() :
      op->vtkRemotingCoreConfiguration::GetTileMullions());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_GetTileDimensions_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTileDimensions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  const size_t size0 = 2;
  int temp0[2];
  int save0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetTileDimensions(temp0);
    }
    else
    {
      op->vtkRemotingCoreConfiguration::GetTileDimensions(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkRemotingCoreConfiguration_GetTileDimensions_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTileDimensions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const int *tempr = (ap.IsBound() ?
      op->GetTileDimensions() :
      op->vtkRemotingCoreConfiguration::GetTileDimensions());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkRemotingCoreConfiguration_GetTileDimensions(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkRemotingCoreConfiguration_GetTileDimensions_s1(self, args);
    case 0:
      return PyvtkRemotingCoreConfiguration_GetTileDimensions_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetTileDimensions");
  return nullptr;
}


static PyObject *
PyvtkRemotingCoreConfiguration_GetIsInTileDisplay(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetIsInTileDisplay");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetIsInTileDisplay() :
      op->vtkRemotingCoreConfiguration::GetIsInTileDisplay());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_GetIsInCave(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetIsInCave");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetIsInCave() :
      op->vtkRemotingCoreConfiguration::GetIsInCave());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_GetDisplayConfiguration(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDisplayConfiguration");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkDisplayConfiguration *tempr = (ap.IsBound() ?
      op->GetDisplayConfiguration() :
      op->vtkRemotingCoreConfiguration::GetDisplayConfiguration());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_GetDisableXDisplayTests(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDisableXDisplayTests");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetDisableXDisplayTests() :
      op->vtkRemotingCoreConfiguration::GetDisableXDisplayTests());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_GetForceOffscreenRendering(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetForceOffscreenRendering");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetForceOffscreenRendering() :
      op->vtkRemotingCoreConfiguration::GetForceOffscreenRendering());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_GetOpenGLWindowBackend(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOpenGLWindowBackend");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    typedef vtkRemotingCoreConfiguration::OpenGLWindowBackendEnum tempr_type;
  tempr_type tempr = (ap.IsBound() ?
      op->GetOpenGLWindowBackend() :
      op->vtkRemotingCoreConfiguration::GetOpenGLWindowBackend());

    if (!ap.ErrorOccurred())
    {
      result = PyvtkRemotingCoreConfiguration_OpenGLWindowBackendEnum_FromEnum(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_GetForceOnscreenRendering(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetForceOnscreenRendering");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetForceOnscreenRendering() :
      op->vtkRemotingCoreConfiguration::GetForceOnscreenRendering());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_GetEGLDeviceIndex(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEGLDeviceIndex");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetEGLDeviceIndex() :
      op->vtkRemotingCoreConfiguration::GetEGLDeviceIndex());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_GetDisplay(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDisplay");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetDisplay() :
      op->vtkRemotingCoreConfiguration::GetDisplay());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_GetMultiServerMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMultiServerMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetMultiServerMode() :
      op->vtkRemotingCoreConfiguration::GetMultiServerMode());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_GetMultiClientMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMultiClientMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetMultiClientMode() :
      op->vtkRemotingCoreConfiguration::GetMultiClientMode());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_GetDisableFurtherConnections(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDisableFurtherConnections");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetDisableFurtherConnections() :
      op->vtkRemotingCoreConfiguration::GetDisableFurtherConnections());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_PopulateOptions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PopulateOptions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  vtkCLIOptions *temp0 = nullptr;
  vtkProcessModule::ProcessTypes temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkCLIOptions") &&
      ap.GetEnumValue(temp1, "vtkProcessModule.ProcessTypes"))
  {
    bool tempr = (ap.IsBound() ?
      op->PopulateOptions(temp0, temp1) :
      op->vtkRemotingCoreConfiguration::PopulateOptions(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_PopulateGlobalOptions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PopulateGlobalOptions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  vtkCLIOptions *temp0 = nullptr;
  vtkProcessModule::ProcessTypes temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkCLIOptions") &&
      ap.GetEnumValue(temp1, "vtkProcessModule.ProcessTypes"))
  {
    bool tempr = (ap.IsBound() ?
      op->PopulateGlobalOptions(temp0, temp1) :
      op->vtkRemotingCoreConfiguration::PopulateGlobalOptions(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_PopulateConnectionOptions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PopulateConnectionOptions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  vtkCLIOptions *temp0 = nullptr;
  vtkProcessModule::ProcessTypes temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkCLIOptions") &&
      ap.GetEnumValue(temp1, "vtkProcessModule.ProcessTypes"))
  {
    bool tempr = (ap.IsBound() ?
      op->PopulateConnectionOptions(temp0, temp1) :
      op->vtkRemotingCoreConfiguration::PopulateConnectionOptions(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_PopulatePluginOptions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PopulatePluginOptions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  vtkCLIOptions *temp0 = nullptr;
  vtkProcessModule::ProcessTypes temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkCLIOptions") &&
      ap.GetEnumValue(temp1, "vtkProcessModule.ProcessTypes"))
  {
    bool tempr = (ap.IsBound() ?
      op->PopulatePluginOptions(temp0, temp1) :
      op->vtkRemotingCoreConfiguration::PopulatePluginOptions(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_PopulateRenderingOptions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PopulateRenderingOptions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  vtkCLIOptions *temp0 = nullptr;
  vtkProcessModule::ProcessTypes temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkCLIOptions") &&
      ap.GetEnumValue(temp1, "vtkProcessModule.ProcessTypes"))
  {
    bool tempr = (ap.IsBound() ?
      op->PopulateRenderingOptions(temp0, temp1) :
      op->vtkRemotingCoreConfiguration::PopulateRenderingOptions(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_PopulateMiscellaneousOptions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PopulateMiscellaneousOptions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  vtkCLIOptions *temp0 = nullptr;
  vtkProcessModule::ProcessTypes temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkCLIOptions") &&
      ap.GetEnumValue(temp1, "vtkProcessModule.ProcessTypes"))
  {
    bool tempr = (ap.IsBound() ?
      op->PopulateMiscellaneousOptions(temp0, temp1) :
      op->vtkRemotingCoreConfiguration::PopulateMiscellaneousOptions(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemotingCoreConfiguration_HandleDisplayEnvironment(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HandleDisplayEnvironment");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemotingCoreConfiguration *op = static_cast<vtkRemotingCoreConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->HandleDisplayEnvironment();
    }
    else
    {
      op->vtkRemotingCoreConfiguration::HandleDisplayEnvironment();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkRemotingCoreConfiguration_Methods[] = {
  {"IsTypeOf", PyvtkRemotingCoreConfiguration_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkRemotingCoreConfiguration_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkRemotingCoreConfiguration_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkRemotingCoreConfiguration\nC++: static vtkRemotingCoreConfiguration *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkRemotingCoreConfiguration_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkRemotingCoreConfiguration\nC++: vtkRemotingCoreConfiguration *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkRemotingCoreConfiguration_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkRemotingCoreConfiguration_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetInstance", PyvtkRemotingCoreConfiguration_GetInstance, METH_VARARGS,
   "GetInstance() -> vtkRemotingCoreConfiguration\nC++: static vtkRemotingCoreConfiguration *GetInstance()\n\nProvides access to the singleton.\n"},
  {"GetTellVersion", PyvtkRemotingCoreConfiguration_GetTellVersion, METH_VARARGS,
   "GetTellVersion(self) -> bool\nC++: virtual bool GetTellVersion()\n\nFlag set when user expects the executable to simply print out the\nversion number and exit.\n"},
  {"GetDisableRegistry", PyvtkRemotingCoreConfiguration_GetDisableRegistry, METH_VARARGS,
   "GetDisableRegistry(self) -> bool\nC++: virtual bool GetDisableRegistry()\n\nGet whether to load user-specific session/configuration files\nfrom previous session or start the application using default\nconfiguration.\n"},
  {"GetPrintMonitors", PyvtkRemotingCoreConfiguration_GetPrintMonitors, METH_VARARGS,
   "GetPrintMonitors(self) -> bool\nC++: virtual bool GetPrintMonitors()\n\nPrint monitor information and exit. This is currently only\nsupported on Windows.\n"},
  {"SetHostName", PyvtkRemotingCoreConfiguration_SetHostName, METH_VARARGS,
   "SetHostName(self, _arg:str) -> None\nC++: virtual void SetHostName(std::string _arg)\n\nSet/Get the hostname to use. By default, this is initialized to\nthe hostname determined automatically using system calls\n(specifically, vtksys::SystemInformation). Default is\n\"localhost\".\n"},
  {"GetHostName", PyvtkRemotingCoreConfiguration_GetHostName, METH_VARARGS,
   "GetHostName(self) -> str\nC++: virtual std::string GetHostName()\n\n"},
  {"SetClientHostName", PyvtkRemotingCoreConfiguration_SetClientHostName, METH_VARARGS,
   "SetClientHostName(self, _arg:str) -> None\nC++: virtual void SetClientHostName(std::string _arg)\n\nSet/Get the hostname for the \"client\" process. This is used by\nserver processes when in reverse-connection mode to determine\nwhere the client can be reached. Default is \"localhost\".\n"},
  {"GetClientHostName", PyvtkRemotingCoreConfiguration_GetClientHostName, METH_VARARGS,
   "GetClientHostName(self) -> str\nC++: virtual std::string GetClientHostName()\n\n"},
  {"SetServerPort", PyvtkRemotingCoreConfiguration_SetServerPort, METH_VARARGS,
   "SetServerPort(self, _arg:int) -> None\nC++: virtual void SetServerPort(int _arg)\n\nSet/Get the server-port number to use. This is the port number\nthat a server-process is expected to use as the 'listening' port.\nFor reverse-connection, this is the port number that the client\nprocess is listening on. Default is 0 but this value will be\ncomputed depending on the process type when populating options.\n"},
  {"GetServerPort", PyvtkRemotingCoreConfiguration_GetServerPort, METH_VARARGS,
   "GetServerPort(self) -> int\nC++: virtual int GetServerPort()\n\n"},
  {"SetBindAddress", PyvtkRemotingCoreConfiguration_SetBindAddress, METH_VARARGS,
   "SetBindAddress(self, _arg:str) -> None\nC++: virtual void SetBindAddress(std::string _arg)\n\nSet/Get the address the server socket is bound to. Default is\n\"0.0.0.0\"\n"},
  {"GetBindAddress", PyvtkRemotingCoreConfiguration_GetBindAddress, METH_VARARGS,
   "GetBindAddress(self) -> str\nC++: virtual std::string GetBindAddress()\n\n"},
  {"SetReverseConnection", PyvtkRemotingCoreConfiguration_SetReverseConnection, METH_VARARGS,
   "SetReverseConnection(self, _arg:bool) -> None\nC++: virtual void SetReverseConnection(bool _arg)\n\nSet/Get if the process is acting in reverse connection mode. This\nflag is only read on the server processes since client is capable\nof supported reverse and non-reverse connections in the same\nprocess. Default is false.\n"},
  {"GetReverseConnection", PyvtkRemotingCoreConfiguration_GetReverseConnection, METH_VARARGS,
   "GetReverseConnection(self) -> bool\nC++: virtual bool GetReverseConnection()\n\n"},
  {"SetConnectID", PyvtkRemotingCoreConfiguration_SetConnectID, METH_VARARGS,
   "SetConnectID(self, _arg:int) -> None\nC++: virtual void SetConnectID(int _arg)\n\nSet/Get the connection identifier used to validate client-server\nconnections. Default is 0.\n"},
  {"GetConnectID", PyvtkRemotingCoreConfiguration_GetConnectID, METH_VARARGS,
   "GetConnectID(self) -> int\nC++: virtual int GetConnectID()\n\n"},
  {"SetTimeout", PyvtkRemotingCoreConfiguration_SetTimeout, METH_VARARGS,
   "SetTimeout(self, _arg:int) -> None\nC++: virtual void SetTimeout(int _arg)\n\nSet/Get the expected infrastructure imposed timeout of the\nserver. Timeout <= 0 means no timeout. Default is 0.\n"},
  {"GetTimeout", PyvtkRemotingCoreConfiguration_GetTimeout, METH_VARARGS,
   "GetTimeout(self) -> int\nC++: virtual int GetTimeout()\n\n"},
  {"SetTimeoutCommand", PyvtkRemotingCoreConfiguration_SetTimeoutCommand, METH_VARARGS,
   "SetTimeoutCommand(self, _arg:str) -> None\nC++: virtual void SetTimeoutCommand(std::string _arg)\n\nSet/Get the timeout command, called regularly on server side and\ngiving remaining time available for server access. Default is\nempty string.\n"},
  {"GetTimeoutCommand", PyvtkRemotingCoreConfiguration_GetTimeoutCommand, METH_VARARGS,
   "GetTimeoutCommand(self) -> str\nC++: virtual std::string GetTimeoutCommand()\n\n"},
  {"SetTimeoutCommandInterval", PyvtkRemotingCoreConfiguration_SetTimeoutCommandInterval, METH_VARARGS,
   "SetTimeoutCommandInterval(self, _arg:int) -> None\nC++: virtual void SetTimeoutCommandInterval(int _arg)\n\nSet/Get the interval in seconds between consecutive calls of\n`TimeoutCommand`, on the server. Default is 60.\n"},
  {"GetTimeoutCommandInterval", PyvtkRemotingCoreConfiguration_GetTimeoutCommandInterval, METH_VARARGS,
   "GetTimeoutCommandInterval(self) -> int\nC++: virtual int GetTimeoutCommandInterval()\n\n"},
  {"GetServerURL", PyvtkRemotingCoreConfiguration_GetServerURL, METH_VARARGS,
   "GetServerURL(self) -> str\nC++: virtual std::string GetServerURL()\n\nOn client processes, this returns the server connection url to\nuse to connect to the server process(es) on startup, if any.\n\n@sa GetServerResourceName\n"},
  {"GetServerResourceName", PyvtkRemotingCoreConfiguration_GetServerResourceName, METH_VARARGS,
   "GetServerResourceName(self) -> str\nC++: virtual std::string GetServerResourceName()\n\nOn client processes, this returns the server connection resource\nname to use to connect to the server process(es) on startup, if\nany.\n"},
  {"GetServerConfigurationsFiles", PyvtkRemotingCoreConfiguration_GetServerConfigurationsFiles, METH_VARARGS,
   "GetServerConfigurationsFiles(self) -> (str, ...)\nC++: const std::vector<std::string> &GetServerConfigurationsFiles(\n    )\n\nOn client processes, this provides list of server configurations\nfiles to use instead of the default user-specific server\nconfigurations file.\n"},
  {"GetPluginSearchPaths", PyvtkRemotingCoreConfiguration_GetPluginSearchPaths, METH_VARARGS,
   "GetPluginSearchPaths(self) -> (str, ...)\nC++: const std::vector<std::string> &GetPluginSearchPaths()\n\nGet a list of paths to add to plugin search paths. Any plugin\nrequested by name will be searched under these paths.\n"},
  {"GetPlugins", PyvtkRemotingCoreConfiguration_GetPlugins, METH_VARARGS,
   "GetPlugins(self) -> (str, ...)\nC++: const std::vector<std::string> &GetPlugins()\n\nGet a list of names for plugins to load.\n"},
  {"GetUseStereoRendering", PyvtkRemotingCoreConfiguration_GetUseStereoRendering, METH_VARARGS,
   "GetUseStereoRendering(self) -> bool\nC++: virtual bool GetUseStereoRendering()\n\nGet whether stereo rendering is enabled. This is only valid on\nrendering processes.\n"},
  {"GetStereoType", PyvtkRemotingCoreConfiguration_GetStereoType, METH_VARARGS,
   "GetStereoType(self) -> int\nC++: virtual int GetStereoType()\n\nGet stereo type requested. Returned values are `VTK_STEREO_*`\ndefined in vtkRenderWindow.h.\n"},
  {"GetStereoTypeAsString", PyvtkRemotingCoreConfiguration_GetStereoTypeAsString, METH_VARARGS,
   "GetStereoTypeAsString(self) -> str\nC++: const char *GetStereoTypeAsString()\n\n"},
  {"GetEyeSeparation", PyvtkRemotingCoreConfiguration_GetEyeSeparation, METH_VARARGS,
   "GetEyeSeparation(self) -> float\nC++: double GetEyeSeparation()\n\nEye separation to use when using stereo rendering.\n"},
  {"GetTileMullions", PyvtkRemotingCoreConfiguration_GetTileMullions, METH_VARARGS,
   "GetTileMullions(self) -> (int, int)\nC++: virtual int *GetTileMullions()\n\nGet the gap in pixel between tiles in a tile display./\n"},
  {"GetTileDimensions", PyvtkRemotingCoreConfiguration_GetTileDimensions, METH_VARARGS,
   "GetTileDimensions(self, dims:[int, int]) -> None\nC++: void GetTileDimensions(int dims[2])\nGetTileDimensions(self) -> Pointer\nC++: const int *GetTileDimensions()\n\nGet the dimensions of the tile display.\n"},
  {"GetIsInTileDisplay", PyvtkRemotingCoreConfiguration_GetIsInTileDisplay, METH_VARARGS,
   "GetIsInTileDisplay(self) -> bool\nC++: bool GetIsInTileDisplay()\n\nReturns true if in tile display mode.\n"},
  {"GetIsInCave", PyvtkRemotingCoreConfiguration_GetIsInCave, METH_VARARGS,
   "GetIsInCave(self) -> bool\nC++: bool GetIsInCave()\n\nReturns true of in CAVE mode.\n"},
  {"GetDisplayConfiguration", PyvtkRemotingCoreConfiguration_GetDisplayConfiguration, METH_VARARGS,
   "GetDisplayConfiguration(self) -> vtkDisplayConfiguration\nC++: vtkDisplayConfiguration *GetDisplayConfiguration()\n\nWhen in CAVE mode, returns the display configurations.\n"},
  {"GetDisableXDisplayTests", PyvtkRemotingCoreConfiguration_GetDisableXDisplayTests, METH_VARARGS,
   "GetDisableXDisplayTests(self) -> bool\nC++: virtual bool GetDisableXDisplayTests()\n\nXDisplay test on server processes during initialization sometimes\nhappens too early and may result in remote rendering prematurely\ndisabled. When this flag is set, ParaView will skip such\nX-display tests. Note, if the display is truly inaccessible when\nParaView tries to connect to the server, we will indeed get\nruntimes errors, including segfaults.\n"},
  {"GetForceOffscreenRendering", PyvtkRemotingCoreConfiguration_GetForceOffscreenRendering, METH_VARARGS,
   "GetForceOffscreenRendering(self) -> bool\nC++: virtual bool GetForceOffscreenRendering()\n\nWhen set to true, ParaView will create headless only render\nwindows on the current process.\n"},
  {"GetOpenGLWindowBackend", PyvtkRemotingCoreConfiguration_GetOpenGLWindowBackend, METH_VARARGS,
   "GetOpenGLWindowBackend(self) -> OpenGLWindowBackendEnum\nC++: virtual OpenGLWindowBackendEnum GetOpenGLWindowBackend()\n\nGet the OpenGL window backend to use. This is only valid on\nrendering processes. The default is\n`OPENGL_WINDOW_BACKEND_DEFAULT` which means use the default\nbackend for the platform.\n"},
  {"GetForceOnscreenRendering", PyvtkRemotingCoreConfiguration_GetForceOnscreenRendering, METH_VARARGS,
   "GetForceOnscreenRendering(self) -> bool\nC++: virtual bool GetForceOnscreenRendering()\n\nWhen set to true, ParaView will create on-screen render windows.\n"},
  {"GetEGLDeviceIndex", PyvtkRemotingCoreConfiguration_GetEGLDeviceIndex, METH_VARARGS,
   "GetEGLDeviceIndex(self) -> int\nC++: int GetEGLDeviceIndex()\n\nReturns the EGL device index for the current process. This uses\n`vtkMultiProcessController::GetLocalProcessId` to determine the\nrank of the process.\n-1 indicates no index was specified.\n"},
  {"GetDisplay", PyvtkRemotingCoreConfiguration_GetDisplay, METH_VARARGS,
   "GetDisplay(self) -> str\nC++: std::string GetDisplay()\n\nReturns the display setting, if any, for the current process.\n"},
  {"GetMultiServerMode", PyvtkRemotingCoreConfiguration_GetMultiServerMode, METH_VARARGS,
   "GetMultiServerMode(self) -> bool\nC++: virtual bool GetMultiServerMode()\n\nReturns true on client process if it should enable connecting to\nmultiple servers at the same time.\n"},
  {"GetMultiClientMode", PyvtkRemotingCoreConfiguration_GetMultiClientMode, METH_VARARGS,
   "GetMultiClientMode(self) -> bool\nC++: virtual bool GetMultiClientMode()\n\nReturns true data server process if the server should allow\nconnecting to multiple clients in a collaboration mode.\n"},
  {"GetDisableFurtherConnections", PyvtkRemotingCoreConfiguration_GetDisableFurtherConnections, METH_VARARGS,
   "GetDisableFurtherConnections(self) -> bool\nC++: virtual bool GetDisableFurtherConnections()\n\nReturns if this server does not allow connection after the first\nclient. This requires MultiClientMode.\n"},
  {"PopulateOptions", PyvtkRemotingCoreConfiguration_PopulateOptions, METH_VARARGS,
   "PopulateOptions(self, app:vtkCLIOptions,\n    processType:vtkProcessModule.ProcessTypes) -> bool\nC++: bool PopulateOptions(vtkCLIOptions *app,\n    vtkProcessModule::ProcessTypes processType)\n\nPopulates vtkCLIOptions with available command line options.\n`processType` indicates which type of ParaView process the\noptions are being setup for. That may affect available options.\n"},
  {"PopulateGlobalOptions", PyvtkRemotingCoreConfiguration_PopulateGlobalOptions, METH_VARARGS,
   "PopulateGlobalOptions(self, app:vtkCLIOptions,\n    processType:vtkProcessModule.ProcessTypes) -> bool\nC++: bool PopulateGlobalOptions(vtkCLIOptions *app,\n    vtkProcessModule::ProcessTypes processType)\n\n"},
  {"PopulateConnectionOptions", PyvtkRemotingCoreConfiguration_PopulateConnectionOptions, METH_VARARGS,
   "PopulateConnectionOptions(self, app:vtkCLIOptions,\n    processType:vtkProcessModule.ProcessTypes) -> bool\nC++: bool PopulateConnectionOptions(vtkCLIOptions *app,\n    vtkProcessModule::ProcessTypes processType)\n\n"},
  {"PopulatePluginOptions", PyvtkRemotingCoreConfiguration_PopulatePluginOptions, METH_VARARGS,
   "PopulatePluginOptions(self, app:vtkCLIOptions,\n    processType:vtkProcessModule.ProcessTypes) -> bool\nC++: bool PopulatePluginOptions(vtkCLIOptions *app,\n    vtkProcessModule::ProcessTypes processType)\n\n"},
  {"PopulateRenderingOptions", PyvtkRemotingCoreConfiguration_PopulateRenderingOptions, METH_VARARGS,
   "PopulateRenderingOptions(self, app:vtkCLIOptions,\n    processType:vtkProcessModule.ProcessTypes) -> bool\nC++: bool PopulateRenderingOptions(vtkCLIOptions *app,\n    vtkProcessModule::ProcessTypes processType)\n\n"},
  {"PopulateMiscellaneousOptions", PyvtkRemotingCoreConfiguration_PopulateMiscellaneousOptions, METH_VARARGS,
   "PopulateMiscellaneousOptions(self, app:vtkCLIOptions,\n    processType:vtkProcessModule.ProcessTypes) -> bool\nC++: bool PopulateMiscellaneousOptions(vtkCLIOptions *app,\n    vtkProcessModule::ProcessTypes processType)\n\n"},
  {"HandleDisplayEnvironment", PyvtkRemotingCoreConfiguration_HandleDisplayEnvironment, METH_VARARGS,
   "HandleDisplayEnvironment(self) -> None\nC++: void HandleDisplayEnvironment()\n\nMethod to setup environment variables for display.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkRemotingCoreConfiguration_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("host_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRemotingCoreConfiguration_GetHostName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkRemotingCoreConfiguration_SetHostName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkRemotingCoreConfiguration_SetHostName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetHostName/SetHostName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("client_host_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRemotingCoreConfiguration_GetClientHostName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkRemotingCoreConfiguration_SetClientHostName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkRemotingCoreConfiguration_SetClientHostName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetClientHostName/SetClientHostName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("server_port"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRemotingCoreConfiguration_GetServerPort(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkRemotingCoreConfiguration_SetServerPort(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkRemotingCoreConfiguration_SetServerPort(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetServerPort/SetServerPort\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("bind_address"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRemotingCoreConfiguration_GetBindAddress(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkRemotingCoreConfiguration_SetBindAddress(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkRemotingCoreConfiguration_SetBindAddress(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBindAddress/SetBindAddress\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("reverse_connection"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRemotingCoreConfiguration_GetReverseConnection(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkRemotingCoreConfiguration_SetReverseConnection(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkRemotingCoreConfiguration_SetReverseConnection(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetReverseConnection/SetReverseConnection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("connect_id"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRemotingCoreConfiguration_GetConnectID(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkRemotingCoreConfiguration_SetConnectID(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkRemotingCoreConfiguration_SetConnectID(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetConnectID/SetConnectID\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("timeout"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRemotingCoreConfiguration_GetTimeout(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkRemotingCoreConfiguration_SetTimeout(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkRemotingCoreConfiguration_SetTimeout(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTimeout/SetTimeout\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("timeout_command"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRemotingCoreConfiguration_GetTimeoutCommand(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkRemotingCoreConfiguration_SetTimeoutCommand(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkRemotingCoreConfiguration_SetTimeoutCommand(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTimeoutCommand/SetTimeoutCommand\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("timeout_command_interval"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRemotingCoreConfiguration_GetTimeoutCommandInterval(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkRemotingCoreConfiguration_SetTimeoutCommandInterval(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkRemotingCoreConfiguration_SetTimeoutCommandInterval(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTimeoutCommandInterval/SetTimeoutCommandInterval\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("instance"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRemotingCoreConfiguration_GetInstance(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetInstance\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("tell_version"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRemotingCoreConfiguration_GetTellVersion(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetTellVersion\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("disable_registry"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRemotingCoreConfiguration_GetDisableRegistry(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDisableRegistry\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("print_monitors"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRemotingCoreConfiguration_GetPrintMonitors(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetPrintMonitors\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("server_url"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRemotingCoreConfiguration_GetServerURL(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetServerURL\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("server_resource_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRemotingCoreConfiguration_GetServerResourceName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetServerResourceName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("server_configurations_files"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRemotingCoreConfiguration_GetServerConfigurationsFiles(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetServerConfigurationsFiles\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("plugin_search_paths"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRemotingCoreConfiguration_GetPluginSearchPaths(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetPluginSearchPaths\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("plugins"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRemotingCoreConfiguration_GetPlugins(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetPlugins\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_stereo_rendering"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRemotingCoreConfiguration_GetUseStereoRendering(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetUseStereoRendering\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("stereo_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRemotingCoreConfiguration_GetStereoType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetStereoType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("eye_separation"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRemotingCoreConfiguration_GetEyeSeparation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetEyeSeparation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("tile_mullions"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRemotingCoreConfiguration_GetTileMullions(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetTileMullions\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("is_in_tile_display"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRemotingCoreConfiguration_GetIsInTileDisplay(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetIsInTileDisplay\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("is_in_cave"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRemotingCoreConfiguration_GetIsInCave(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetIsInCave\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("display_configuration"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRemotingCoreConfiguration_GetDisplayConfiguration(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDisplayConfiguration\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("disable_x_display_tests"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRemotingCoreConfiguration_GetDisableXDisplayTests(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDisableXDisplayTests\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("force_offscreen_rendering"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRemotingCoreConfiguration_GetForceOffscreenRendering(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetForceOffscreenRendering\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("open_gl_window_backend"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRemotingCoreConfiguration_GetOpenGLWindowBackend(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetOpenGLWindowBackend\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("force_onscreen_rendering"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRemotingCoreConfiguration_GetForceOnscreenRendering(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetForceOnscreenRendering\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("egl_device_index"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRemotingCoreConfiguration_GetEGLDeviceIndex(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetEGLDeviceIndex\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("display"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRemotingCoreConfiguration_GetDisplay(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDisplay\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("multi_server_mode"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRemotingCoreConfiguration_GetMultiServerMode(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetMultiServerMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("multi_client_mode"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRemotingCoreConfiguration_GetMultiClientMode(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetMultiClientMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("disable_further_connections"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRemotingCoreConfiguration_GetDisableFurtherConnections(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDisableFurtherConnections\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkRemotingCoreConfiguration_Doc =
  "vtkRemotingCoreConfiguration - runtime configuration options for\nvtkRemotingCore module.\n\n"
  "Superclass: vtkObject\n\n"
  "vtkRemotingCoreConfiguration is a singleton that maintains runtime\n"
  "configuration for the process. These can be thought of as options\n"
  "settable by command line arguments and hence are initialized when the\n"
  "process launches and are not changed during the lifetime of the\n"
  "process.\n\n"
  "vtkRemotingCoreConfiguration can be setup via command line arguments.\n"
  "For that, create a `vtkCLIOptions` object and populate it using\n"
  "`PopulateOptions` method. `vtkCLIOptions` can then pass command line\n"
  "arguments for parsing.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkRemotingCoreConfiguration_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingCore.vtkRemotingCoreConfiguration", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkRemotingCoreConfiguration_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

PyObject *PyvtkRemotingCoreConfiguration_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkRemotingCoreConfiguration_Type, PyvtkRemotingCoreConfiguration_Methods,
    "vtkRemotingCoreConfiguration",
 nullptr);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyvtkRemotingCoreConfiguration_OpenGLWindowBackendEnum_Type);
  PyVTKEnum_Add(&PyvtkRemotingCoreConfiguration_OpenGLWindowBackendEnum_Type, "vtkRemotingCoreConfiguration.OpenGLWindowBackendEnum");

  o = (PyObject *)&PyvtkRemotingCoreConfiguration_OpenGLWindowBackendEnum_Type;
  if (PyDict_SetItemString(d, "OpenGLWindowBackendEnum", o) != 0)
  {
    Py_DECREF(o);
  }

  for (int c = 0; c < 5; c++)
  {
    typedef vtkRemotingCoreConfiguration::OpenGLWindowBackendEnum cxx_enum_type;

    static const struct { const char *name; cxx_enum_type value; }
      constants[5] = {
        { "OPENGL_WINDOW_BACKEND_DEFAULT", vtkRemotingCoreConfiguration::OPENGL_WINDOW_BACKEND_DEFAULT },
        { "OPENGL_WINDOW_BACKEND_EGL", vtkRemotingCoreConfiguration::OPENGL_WINDOW_BACKEND_EGL },
        { "OPENGL_WINDOW_BACKEND_GLX", vtkRemotingCoreConfiguration::OPENGL_WINDOW_BACKEND_GLX },
        { "OPENGL_WINDOW_BACKEND_OSMESA", vtkRemotingCoreConfiguration::OPENGL_WINDOW_BACKEND_OSMESA },
        { "OPENGL_WINDOW_BACKEND_WIN32", vtkRemotingCoreConfiguration::OPENGL_WINDOW_BACKEND_WIN32 },
      };

    o = PyvtkRemotingCoreConfiguration_OpenGLWindowBackendEnum_FromEnum(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkRemotingCoreConfiguration_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkRemotingCoreConfiguration(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkRemotingCoreConfiguration_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkRemotingCoreConfiguration", o) != 0)
  {
    Py_DECREF(o);
  }

}

