// python wrapper for vtkMaterialInterfaceProcessRing
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkMaterialInterfaceProcessRing.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkMaterialInterfaceProcessRing(PyObject *dict); }

static PyObject *
PyvtkMaterialInterfaceProcessRing_Clear(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Clear");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkMaterialInterfaceProcessRing *op = static_cast<vtkMaterialInterfaceProcessRing *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    op->Clear();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceProcessRing_Initialize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Initialize");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkMaterialInterfaceProcessRing *op = static_cast<vtkMaterialInterfaceProcessRing *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    op->Initialize(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceProcessRing_GetNextId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNextId");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkMaterialInterfaceProcessRing *op = static_cast<vtkMaterialInterfaceProcessRing *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    long long tempr = op->GetNextId();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceProcessRing_Print(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Print");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkMaterialInterfaceProcessRing *op = static_cast<vtkMaterialInterfaceProcessRing *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    op->Print();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkMaterialInterfaceProcessRing_Methods[] = {
  {"Clear", PyvtkMaterialInterfaceProcessRing_Clear, METH_VARARGS,
   "Clear(self) -> None\nC++: void Clear()\n\nReturn the object to an empty state.\n"},
  {"Initialize", PyvtkMaterialInterfaceProcessRing_Initialize, METH_VARARGS,
   "Initialize(self, nProcs:int) -> None\nC++: void Initialize(int nProcs)\n\nSize buffer and point to first element.\n"},
  {"GetNextId", PyvtkMaterialInterfaceProcessRing_GetNextId, METH_VARARGS,
   "GetNextId(self) -> int\nC++: vtkIdType GetNextId()\n\nGet the next process id from the ring.\n"},
  {"Print", PyvtkMaterialInterfaceProcessRing_Print, METH_VARARGS,
   "Print(self) -> None\nC++: void Print()\n\nPrint the state of the ring.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkMaterialInterfaceProcessRing_GetSets[] = {
  {
    /*name=*/pystr("next_id"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMaterialInterfaceProcessRing_GetNextId(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNextId\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};

static PyObject *
PyvtkMaterialInterfaceProcessRing_vtkMaterialInterfaceProcessRing_s1(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkMaterialInterfaceProcessRing");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkMaterialInterfaceProcessRing *op = new vtkMaterialInterfaceProcessRing();

    result = PyVTKSpecialObject_New("vtkMaterialInterfaceProcessRing", op);
  }

  return result;
}

static PyObject *
PyvtkMaterialInterfaceProcessRing_vtkMaterialInterfaceProcessRing_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkMaterialInterfaceProcessRing");

  vtkMaterialInterfaceProcessRing *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkMaterialInterfaceProcessRing"))
  {
    vtkMaterialInterfaceProcessRing *op = new vtkMaterialInterfaceProcessRing(*temp0);

    result = PyVTKSpecialObject_New("vtkMaterialInterfaceProcessRing", op);
  }

  Py_XDECREF(pobj0);

  return result;
}

static PyMethodDef PyvtkMaterialInterfaceProcessRing_vtkMaterialInterfaceProcessRing_Methods[] = {
  {"vtkMaterialInterfaceProcessRing", PyvtkMaterialInterfaceProcessRing_vtkMaterialInterfaceProcessRing_s2, METH_VARARGS,
   "@W vtkMaterialInterfaceProcessRing"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkMaterialInterfaceProcessRing_vtkMaterialInterfaceProcessRing(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 0:
      return PyvtkMaterialInterfaceProcessRing_vtkMaterialInterfaceProcessRing_s1(self, args);
    case 1:
      return PyvtkMaterialInterfaceProcessRing_vtkMaterialInterfaceProcessRing_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "vtkMaterialInterfaceProcessRing");
  return nullptr;
}


static const char *PyvtkMaterialInterfaceProcessRing_Doc =

  "vtkMaterialInterfaceProcessRing() -> vtkMaterialInterfaceProcessRing\nC++: vtkMaterialInterfaceProcessRing()\nvtkMaterialInterfaceProcessRing(__a:vtkMaterialInterfaceProcessRing)\n    -> vtkMaterialInterfaceProcessRing\nC++: vtkMaterialInterfaceProcessRing(\n    const &vtkMaterialInterfaceProcessRing)\n""\n"
  "vtkMaterialInterfaceProcessRing - Data structure used to distribute\nwork amongst available processes.\n\n"
  "The buffer can be initialized from a process priority queue such that\n"
  "only those processes with loading less than a specified tolerance are\n"
  "included.\n\n";

static PyObject *
PyvtkMaterialInterfaceProcessRing_New(PyTypeObject *, PyObject *args, PyObject *kwds)
{
  if (kwds && PyDict_Size(kwds))
  {
    PyErr_SetString(PyExc_TypeError,
                    "this function takes no keyword arguments");
    return nullptr;
  }

  return PyvtkMaterialInterfaceProcessRing_vtkMaterialInterfaceProcessRing(nullptr, args);
}

static void PyvtkMaterialInterfaceProcessRing_Delete(PyObject *self)
{
  PyVTKSpecialObject *obj = (PyVTKSpecialObject *)self;
  delete static_cast<vtkMaterialInterfaceProcessRing *>(obj->vtk_ptr);
  PyObject_Del(self);
}

static Py_hash_t PyvtkMaterialInterfaceProcessRing_Hash(PyObject *self)
{
  return PyObject_HashNotImplemented(self);
}

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkMaterialInterfaceProcessRing_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsFiltersMaterialInterface.vtkMaterialInterfaceProcessRing", // tp_name
  sizeof(PyVTKSpecialObject), // tp_basicsize
  0, // tp_itemsize
  PyvtkMaterialInterfaceProcessRing_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKSpecialObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  PyvtkMaterialInterfaceProcessRing_Hash, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT, // tp_flags
  PyvtkMaterialInterfaceProcessRing_Doc, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  PyvtkMaterialInterfaceProcessRing_New, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static void *PyvtkMaterialInterfaceProcessRing_CCopy(const void *obj)
{
  if (obj)
  {
    return new vtkMaterialInterfaceProcessRing(*static_cast<const vtkMaterialInterfaceProcessRing*>(obj));
  }
  return nullptr;
}

#ifndef DECLARED_PyvtkMaterialInterfaceProcessRing_TypeNew
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkMaterialInterfaceProcessRing_TypeNew(); }
#define DECLARED_PyvtkMaterialInterfaceProcessRing_TypeNew
#endif

PyObject *PyvtkMaterialInterfaceProcessRing_TypeNew()
{
  PyTypeObject *pytype = PyVTKSpecialType_Add(
    &PyvtkMaterialInterfaceProcessRing_Type,
    PyvtkMaterialInterfaceProcessRing_Methods,
    PyvtkMaterialInterfaceProcessRing_GetSets,
    PyvtkMaterialInterfaceProcessRing_vtkMaterialInterfaceProcessRing_Methods,
    &PyvtkMaterialInterfaceProcessRing_CCopy);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkMaterialInterfaceProcessRing(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkMaterialInterfaceProcessRing_TypeNew();

  if (o && PyDict_SetItemString(dict, "vtkMaterialInterfaceProcessRing", o) != 0)
  {
    Py_DECREF(o);
  }

}

