#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkIOCellGrid_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkCellGridIOQuery_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkCellGridReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkCellGridWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkCompositeCellGridReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkDGIOResponder_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkIOCellGridCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkIOCellGrid_Init(csi);
  vtkCellGridIOQuery_Init(csi);
  vtkCellGridReader_Init(csi);
  vtkCellGridWriter_Init(csi);
  vtkCompositeCellGridReader_Init(csi);
  vtkDGIOResponder_Init(csi);
}
