// *********** THIS FILE IS GENERATED - DO NOT EDIT ***********
//     See api_dump_generator.py for modifications
// ************************************************************

// Copyright (c) 2017-2025 The Khronos Group Inc.
// Copyright (c) 2017-2019 Valve Corporation
// Copyright (c) 2017-2019 LunarG, Inc.
//
// SPDX-License-Identifier: Apache-2.0
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Author: Mark Young <marky@lunarg.com>
//

#include "xr_generated_api_dump.hpp"
#include "xr_generated_dispatch_table.h"
#include "hex_and_handles.h"

#include <cstring>
#include <mutex>
#include <sstream>
#include <iomanip>
#include <unordered_map>


std::unordered_map<XrInstance, XrGeneratedDispatchTable*> g_instance_dispatch_map;
std::mutex g_instance_dispatch_mutex;
std::unordered_map<XrSession, XrGeneratedDispatchTable*> g_session_dispatch_map;
std::mutex g_session_dispatch_mutex;
std::unordered_map<XrSpace, XrGeneratedDispatchTable*> g_space_dispatch_map;
std::mutex g_space_dispatch_mutex;
std::unordered_map<XrAction, XrGeneratedDispatchTable*> g_action_dispatch_map;
std::mutex g_action_dispatch_mutex;
std::unordered_map<XrSwapchain, XrGeneratedDispatchTable*> g_swapchain_dispatch_map;
std::mutex g_swapchain_dispatch_mutex;
std::unordered_map<XrActionSet, XrGeneratedDispatchTable*> g_actionset_dispatch_map;
std::mutex g_actionset_dispatch_mutex;
std::unordered_map<XrDebugUtilsMessengerEXT, XrGeneratedDispatchTable*> g_debugutilsmessengerext_dispatch_map;
std::mutex g_debugutilsmessengerext_dispatch_mutex;
std::unordered_map<XrSpatialAnchorMSFT, XrGeneratedDispatchTable*> g_spatialanchormsft_dispatch_map;
std::mutex g_spatialanchormsft_dispatch_mutex;
std::unordered_map<XrSpatialGraphNodeBindingMSFT, XrGeneratedDispatchTable*> g_spatialgraphnodebindingmsft_dispatch_map;
std::mutex g_spatialgraphnodebindingmsft_dispatch_mutex;
std::unordered_map<XrHandTrackerEXT, XrGeneratedDispatchTable*> g_handtrackerext_dispatch_map;
std::mutex g_handtrackerext_dispatch_mutex;
std::unordered_map<XrBodyTrackerFB, XrGeneratedDispatchTable*> g_bodytrackerfb_dispatch_map;
std::mutex g_bodytrackerfb_dispatch_mutex;
std::unordered_map<XrSceneObserverMSFT, XrGeneratedDispatchTable*> g_sceneobservermsft_dispatch_map;
std::mutex g_sceneobservermsft_dispatch_mutex;
std::unordered_map<XrSceneMSFT, XrGeneratedDispatchTable*> g_scenemsft_dispatch_map;
std::mutex g_scenemsft_dispatch_mutex;
std::unordered_map<XrFacialTrackerHTC, XrGeneratedDispatchTable*> g_facialtrackerhtc_dispatch_map;
std::mutex g_facialtrackerhtc_dispatch_mutex;
std::unordered_map<XrFoveationProfileFB, XrGeneratedDispatchTable*> g_foveationprofilefb_dispatch_map;
std::mutex g_foveationprofilefb_dispatch_mutex;
std::unordered_map<XrTriangleMeshFB, XrGeneratedDispatchTable*> g_trianglemeshfb_dispatch_map;
std::mutex g_trianglemeshfb_dispatch_mutex;
std::unordered_map<XrPassthroughFB, XrGeneratedDispatchTable*> g_passthroughfb_dispatch_map;
std::mutex g_passthroughfb_dispatch_mutex;
std::unordered_map<XrPassthroughLayerFB, XrGeneratedDispatchTable*> g_passthroughlayerfb_dispatch_map;
std::mutex g_passthroughlayerfb_dispatch_mutex;
std::unordered_map<XrGeometryInstanceFB, XrGeneratedDispatchTable*> g_geometryinstancefb_dispatch_map;
std::mutex g_geometryinstancefb_dispatch_mutex;
std::unordered_map<XrMarkerDetectorML, XrGeneratedDispatchTable*> g_markerdetectorml_dispatch_map;
std::mutex g_markerdetectorml_dispatch_mutex;
std::unordered_map<XrExportedLocalizationMapML, XrGeneratedDispatchTable*> g_exportedlocalizationmapml_dispatch_map;
std::mutex g_exportedlocalizationmapml_dispatch_mutex;
std::unordered_map<XrSpatialAnchorsStorageML, XrGeneratedDispatchTable*> g_spatialanchorsstorageml_dispatch_map;
std::mutex g_spatialanchorsstorageml_dispatch_mutex;
std::unordered_map<XrSpatialAnchorStoreConnectionMSFT, XrGeneratedDispatchTable*> g_spatialanchorstoreconnectionmsft_dispatch_map;
std::mutex g_spatialanchorstoreconnectionmsft_dispatch_mutex;
std::unordered_map<XrSpaceUserFB, XrGeneratedDispatchTable*> g_spaceuserfb_dispatch_map;
std::mutex g_spaceuserfb_dispatch_mutex;
std::unordered_map<XrFaceTrackerFB, XrGeneratedDispatchTable*> g_facetrackerfb_dispatch_map;
std::mutex g_facetrackerfb_dispatch_mutex;
std::unordered_map<XrEyeTrackerFB, XrGeneratedDispatchTable*> g_eyetrackerfb_dispatch_map;
std::mutex g_eyetrackerfb_dispatch_mutex;
std::unordered_map<XrVirtualKeyboardMETA, XrGeneratedDispatchTable*> g_virtualkeyboardmeta_dispatch_map;
std::mutex g_virtualkeyboardmeta_dispatch_mutex;
std::unordered_map<XrPassthroughColorLutMETA, XrGeneratedDispatchTable*> g_passthroughcolorlutmeta_dispatch_map;
std::mutex g_passthroughcolorlutmeta_dispatch_mutex;
std::unordered_map<XrFaceTracker2FB, XrGeneratedDispatchTable*> g_facetracker2fb_dispatch_map;
std::mutex g_facetracker2fb_dispatch_mutex;
std::unordered_map<XrEnvironmentDepthProviderMETA, XrGeneratedDispatchTable*> g_environmentdepthprovidermeta_dispatch_map;
std::mutex g_environmentdepthprovidermeta_dispatch_mutex;
std::unordered_map<XrEnvironmentDepthSwapchainMETA, XrGeneratedDispatchTable*> g_environmentdepthswapchainmeta_dispatch_map;
std::mutex g_environmentdepthswapchainmeta_dispatch_mutex;
std::unordered_map<XrRenderModelEXT, XrGeneratedDispatchTable*> g_rendermodelext_dispatch_map;
std::mutex g_rendermodelext_dispatch_mutex;
std::unordered_map<XrRenderModelAssetEXT, XrGeneratedDispatchTable*> g_rendermodelassetext_dispatch_map;
std::mutex g_rendermodelassetext_dispatch_mutex;
std::unordered_map<XrPassthroughHTC, XrGeneratedDispatchTable*> g_passthroughhtc_dispatch_map;
std::mutex g_passthroughhtc_dispatch_mutex;
std::unordered_map<XrBodyTrackerHTC, XrGeneratedDispatchTable*> g_bodytrackerhtc_dispatch_map;
std::mutex g_bodytrackerhtc_dispatch_mutex;
std::unordered_map<XrBodyTrackerBD, XrGeneratedDispatchTable*> g_bodytrackerbd_dispatch_map;
std::mutex g_bodytrackerbd_dispatch_mutex;
std::unordered_map<XrFaceTrackerBD, XrGeneratedDispatchTable*> g_facetrackerbd_dispatch_map;
std::mutex g_facetrackerbd_dispatch_mutex;
std::unordered_map<XrSenseDataProviderBD, XrGeneratedDispatchTable*> g_sensedataproviderbd_dispatch_map;
std::mutex g_sensedataproviderbd_dispatch_mutex;
std::unordered_map<XrSenseDataSnapshotBD, XrGeneratedDispatchTable*> g_sensedatasnapshotbd_dispatch_map;
std::mutex g_sensedatasnapshotbd_dispatch_mutex;
std::unordered_map<XrAnchorBD, XrGeneratedDispatchTable*> g_anchorbd_dispatch_map;
std::mutex g_anchorbd_dispatch_mutex;
std::unordered_map<XrPlaneDetectorEXT, XrGeneratedDispatchTable*> g_planedetectorext_dispatch_map;
std::mutex g_planedetectorext_dispatch_mutex;
std::unordered_map<XrTrackableTrackerANDROID, XrGeneratedDispatchTable*> g_trackabletrackerandroid_dispatch_map;
std::mutex g_trackabletrackerandroid_dispatch_mutex;
std::unordered_map<XrDeviceAnchorPersistenceANDROID, XrGeneratedDispatchTable*> g_deviceanchorpersistenceandroid_dispatch_map;
std::mutex g_deviceanchorpersistenceandroid_dispatch_mutex;
std::unordered_map<XrFaceTrackerANDROID, XrGeneratedDispatchTable*> g_facetrackerandroid_dispatch_map;
std::mutex g_facetrackerandroid_dispatch_mutex;
std::unordered_map<XrWorldMeshDetectorML, XrGeneratedDispatchTable*> g_worldmeshdetectorml_dispatch_map;
std::mutex g_worldmeshdetectorml_dispatch_mutex;
std::unordered_map<XrFacialExpressionClientML, XrGeneratedDispatchTable*> g_facialexpressionclientml_dispatch_map;
std::mutex g_facialexpressionclientml_dispatch_mutex;
std::unordered_map<XrSpatialEntityEXT, XrGeneratedDispatchTable*> g_spatialentityext_dispatch_map;
std::mutex g_spatialentityext_dispatch_mutex;
std::unordered_map<XrSpatialContextEXT, XrGeneratedDispatchTable*> g_spatialcontextext_dispatch_map;
std::mutex g_spatialcontextext_dispatch_mutex;
std::unordered_map<XrSpatialSnapshotEXT, XrGeneratedDispatchTable*> g_spatialsnapshotext_dispatch_map;
std::mutex g_spatialsnapshotext_dispatch_mutex;
std::unordered_map<XrSpatialPersistenceContextEXT, XrGeneratedDispatchTable*> g_spatialpersistencecontextext_dispatch_map;
std::mutex g_spatialpersistencecontextext_dispatch_mutex;

// Template function to reduce duplicating the map locking, searching, and deleting.`
template <typename MapType>
void eraseAllTableMapElements(MapType &search_map, std::mutex &mutex, XrGeneratedDispatchTable *search_value) {
    std::unique_lock<std::mutex> lock(mutex);
    for (auto it = search_map.begin(); it != search_map.end();) {
        if (it->second == search_value) {
            search_map.erase(it++);
        } else {
            ++it;
        }
    }
}

// Function used to clean up any residual map values that point to an instance prior to that
// instance being deleted.
void ApiDumpCleanUpMapsForTable(XrGeneratedDispatchTable *table) {
    eraseAllTableMapElements<std::unordered_map<XrInstance, XrGeneratedDispatchTable*>>(g_instance_dispatch_map, g_instance_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrSession, XrGeneratedDispatchTable*>>(g_session_dispatch_map, g_session_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrSpace, XrGeneratedDispatchTable*>>(g_space_dispatch_map, g_space_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrAction, XrGeneratedDispatchTable*>>(g_action_dispatch_map, g_action_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrSwapchain, XrGeneratedDispatchTable*>>(g_swapchain_dispatch_map, g_swapchain_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrActionSet, XrGeneratedDispatchTable*>>(g_actionset_dispatch_map, g_actionset_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrDebugUtilsMessengerEXT, XrGeneratedDispatchTable*>>(g_debugutilsmessengerext_dispatch_map, g_debugutilsmessengerext_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrSpatialAnchorMSFT, XrGeneratedDispatchTable*>>(g_spatialanchormsft_dispatch_map, g_spatialanchormsft_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrSpatialGraphNodeBindingMSFT, XrGeneratedDispatchTable*>>(g_spatialgraphnodebindingmsft_dispatch_map, g_spatialgraphnodebindingmsft_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrHandTrackerEXT, XrGeneratedDispatchTable*>>(g_handtrackerext_dispatch_map, g_handtrackerext_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrBodyTrackerFB, XrGeneratedDispatchTable*>>(g_bodytrackerfb_dispatch_map, g_bodytrackerfb_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrSceneObserverMSFT, XrGeneratedDispatchTable*>>(g_sceneobservermsft_dispatch_map, g_sceneobservermsft_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrSceneMSFT, XrGeneratedDispatchTable*>>(g_scenemsft_dispatch_map, g_scenemsft_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrFacialTrackerHTC, XrGeneratedDispatchTable*>>(g_facialtrackerhtc_dispatch_map, g_facialtrackerhtc_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrFoveationProfileFB, XrGeneratedDispatchTable*>>(g_foveationprofilefb_dispatch_map, g_foveationprofilefb_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrTriangleMeshFB, XrGeneratedDispatchTable*>>(g_trianglemeshfb_dispatch_map, g_trianglemeshfb_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrPassthroughFB, XrGeneratedDispatchTable*>>(g_passthroughfb_dispatch_map, g_passthroughfb_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrPassthroughLayerFB, XrGeneratedDispatchTable*>>(g_passthroughlayerfb_dispatch_map, g_passthroughlayerfb_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrGeometryInstanceFB, XrGeneratedDispatchTable*>>(g_geometryinstancefb_dispatch_map, g_geometryinstancefb_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrMarkerDetectorML, XrGeneratedDispatchTable*>>(g_markerdetectorml_dispatch_map, g_markerdetectorml_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrExportedLocalizationMapML, XrGeneratedDispatchTable*>>(g_exportedlocalizationmapml_dispatch_map, g_exportedlocalizationmapml_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrSpatialAnchorsStorageML, XrGeneratedDispatchTable*>>(g_spatialanchorsstorageml_dispatch_map, g_spatialanchorsstorageml_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrSpatialAnchorStoreConnectionMSFT, XrGeneratedDispatchTable*>>(g_spatialanchorstoreconnectionmsft_dispatch_map, g_spatialanchorstoreconnectionmsft_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrSpaceUserFB, XrGeneratedDispatchTable*>>(g_spaceuserfb_dispatch_map, g_spaceuserfb_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrFaceTrackerFB, XrGeneratedDispatchTable*>>(g_facetrackerfb_dispatch_map, g_facetrackerfb_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrEyeTrackerFB, XrGeneratedDispatchTable*>>(g_eyetrackerfb_dispatch_map, g_eyetrackerfb_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrVirtualKeyboardMETA, XrGeneratedDispatchTable*>>(g_virtualkeyboardmeta_dispatch_map, g_virtualkeyboardmeta_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrPassthroughColorLutMETA, XrGeneratedDispatchTable*>>(g_passthroughcolorlutmeta_dispatch_map, g_passthroughcolorlutmeta_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrFaceTracker2FB, XrGeneratedDispatchTable*>>(g_facetracker2fb_dispatch_map, g_facetracker2fb_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrEnvironmentDepthProviderMETA, XrGeneratedDispatchTable*>>(g_environmentdepthprovidermeta_dispatch_map, g_environmentdepthprovidermeta_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrEnvironmentDepthSwapchainMETA, XrGeneratedDispatchTable*>>(g_environmentdepthswapchainmeta_dispatch_map, g_environmentdepthswapchainmeta_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrRenderModelEXT, XrGeneratedDispatchTable*>>(g_rendermodelext_dispatch_map, g_rendermodelext_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrRenderModelAssetEXT, XrGeneratedDispatchTable*>>(g_rendermodelassetext_dispatch_map, g_rendermodelassetext_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrPassthroughHTC, XrGeneratedDispatchTable*>>(g_passthroughhtc_dispatch_map, g_passthroughhtc_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrBodyTrackerHTC, XrGeneratedDispatchTable*>>(g_bodytrackerhtc_dispatch_map, g_bodytrackerhtc_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrBodyTrackerBD, XrGeneratedDispatchTable*>>(g_bodytrackerbd_dispatch_map, g_bodytrackerbd_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrFaceTrackerBD, XrGeneratedDispatchTable*>>(g_facetrackerbd_dispatch_map, g_facetrackerbd_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrSenseDataProviderBD, XrGeneratedDispatchTable*>>(g_sensedataproviderbd_dispatch_map, g_sensedataproviderbd_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrSenseDataSnapshotBD, XrGeneratedDispatchTable*>>(g_sensedatasnapshotbd_dispatch_map, g_sensedatasnapshotbd_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrAnchorBD, XrGeneratedDispatchTable*>>(g_anchorbd_dispatch_map, g_anchorbd_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrPlaneDetectorEXT, XrGeneratedDispatchTable*>>(g_planedetectorext_dispatch_map, g_planedetectorext_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrTrackableTrackerANDROID, XrGeneratedDispatchTable*>>(g_trackabletrackerandroid_dispatch_map, g_trackabletrackerandroid_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrDeviceAnchorPersistenceANDROID, XrGeneratedDispatchTable*>>(g_deviceanchorpersistenceandroid_dispatch_map, g_deviceanchorpersistenceandroid_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrFaceTrackerANDROID, XrGeneratedDispatchTable*>>(g_facetrackerandroid_dispatch_map, g_facetrackerandroid_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrWorldMeshDetectorML, XrGeneratedDispatchTable*>>(g_worldmeshdetectorml_dispatch_map, g_worldmeshdetectorml_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrFacialExpressionClientML, XrGeneratedDispatchTable*>>(g_facialexpressionclientml_dispatch_map, g_facialexpressionclientml_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrSpatialEntityEXT, XrGeneratedDispatchTable*>>(g_spatialentityext_dispatch_map, g_spatialentityext_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrSpatialContextEXT, XrGeneratedDispatchTable*>>(g_spatialcontextext_dispatch_map, g_spatialcontextext_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrSpatialSnapshotEXT, XrGeneratedDispatchTable*>>(g_spatialsnapshotext_dispatch_map, g_spatialsnapshotext_dispatch_mutex, table);
    eraseAllTableMapElements<std::unordered_map<XrSpatialPersistenceContextEXT, XrGeneratedDispatchTable*>>(g_spatialpersistencecontextext_dispatch_map, g_spatialpersistencecontextext_dispatch_mutex, table);
}


// Union/Structure Output Helper functions
bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrApiLayerProperties* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string layername_prefix = prefix;
        layername_prefix += "layerName";
        contents.emplace_back("char*", layername_prefix, value->layerName);
        std::string specversion_prefix = prefix;
        specversion_prefix += "specVersion";
        std::ostringstream oss_specVersion;
        oss_specVersion << "0x" << std::hex << (value->specVersion);
        contents.emplace_back("XrVersion", specversion_prefix, oss_specVersion.str());
        std::string layerversion_prefix = prefix;
        layerversion_prefix += "layerVersion";
        std::ostringstream oss_layerVersion;
        oss_layerVersion << "0x" << std::hex << (value->layerVersion);
        contents.emplace_back("uint32_t", layerversion_prefix, oss_layerVersion.str());
        std::string description_prefix = prefix;
        description_prefix += "description";
        contents.emplace_back("char*", description_prefix, value->description);
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrExtensionProperties* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string extensionname_prefix = prefix;
        extensionname_prefix += "extensionName";
        contents.emplace_back("char*", extensionname_prefix, value->extensionName);
        std::string extensionversion_prefix = prefix;
        extensionversion_prefix += "extensionVersion";
        std::ostringstream oss_extensionVersion;
        oss_extensionVersion << "0x" << std::hex << (value->extensionVersion);
        contents.emplace_back("uint32_t", extensionversion_prefix, oss_extensionVersion.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrApplicationInfo* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string applicationname_prefix = prefix;
        applicationname_prefix += "applicationName";
        contents.emplace_back("char*", applicationname_prefix, value->applicationName);
        std::string applicationversion_prefix = prefix;
        applicationversion_prefix += "applicationVersion";
        std::ostringstream oss_applicationVersion;
        oss_applicationVersion << "0x" << std::hex << (value->applicationVersion);
        contents.emplace_back("uint32_t", applicationversion_prefix, oss_applicationVersion.str());
        std::string enginename_prefix = prefix;
        enginename_prefix += "engineName";
        contents.emplace_back("char*", enginename_prefix, value->engineName);
        std::string engineversion_prefix = prefix;
        engineversion_prefix += "engineVersion";
        std::ostringstream oss_engineVersion;
        oss_engineVersion << "0x" << std::hex << (value->engineVersion);
        contents.emplace_back("uint32_t", engineversion_prefix, oss_engineVersion.str());
        std::string apiversion_prefix = prefix;
        apiversion_prefix += "apiVersion";
        std::ostringstream oss_apiVersion;
        oss_apiVersion << "0x" << std::hex << (value->apiVersion);
        contents.emplace_back("XrVersion", apiversion_prefix, oss_apiVersion.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrInstanceCreateInfo* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string createflags_prefix = prefix;
        createflags_prefix += "createFlags";
        contents.emplace_back("XrInstanceCreateFlags", createflags_prefix, std::to_string(value->createFlags));
        std::string applicationinfo_prefix = prefix;
        applicationinfo_prefix += "applicationInfo";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->applicationInfo, applicationinfo_prefix, "XrApplicationInfo", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string enabledapilayercount_prefix = prefix;
        enabledapilayercount_prefix += "enabledApiLayerCount";
        std::ostringstream oss_enabledApiLayerCount;
        oss_enabledApiLayerCount << "0x" << std::hex << (value->enabledApiLayerCount);
        contents.emplace_back("uint32_t", enabledapilayercount_prefix, oss_enabledApiLayerCount.str());
        std::string enabledapilayernames_prefix = prefix;
        enabledapilayernames_prefix += "enabledApiLayerNames";
        std::ostringstream oss_enabledApiLayerNames_array;
        oss_enabledApiLayerNames_array << std::hex << reinterpret_cast<const void*>(value->enabledApiLayerNames);
        contents.emplace_back("const char* const*", enabledapilayernames_prefix, oss_enabledApiLayerNames_array.str());
        for (uint32_t value_enabledapilayernames_inc = 0; value_enabledapilayernames_inc < value->enabledApiLayerCount; ++value_enabledapilayernames_inc) {
            std::string enabledapilayernames_array_prefix = enabledapilayernames_prefix;
            enabledapilayernames_array_prefix += "[";
            enabledapilayernames_array_prefix += std::to_string(value_enabledapilayernames_inc);
            enabledapilayernames_array_prefix += "]";
            contents.emplace_back("const char* const*", enabledapilayernames_array_prefix, value->enabledApiLayerNames[value_enabledapilayernames_inc]);
        }
        std::string enabledextensioncount_prefix = prefix;
        enabledextensioncount_prefix += "enabledExtensionCount";
        std::ostringstream oss_enabledExtensionCount;
        oss_enabledExtensionCount << "0x" << std::hex << (value->enabledExtensionCount);
        contents.emplace_back("uint32_t", enabledextensioncount_prefix, oss_enabledExtensionCount.str());
        std::string enabledextensionnames_prefix = prefix;
        enabledextensionnames_prefix += "enabledExtensionNames";
        std::ostringstream oss_enabledExtensionNames_array;
        oss_enabledExtensionNames_array << std::hex << reinterpret_cast<const void*>(value->enabledExtensionNames);
        contents.emplace_back("const char* const*", enabledextensionnames_prefix, oss_enabledExtensionNames_array.str());
        for (uint32_t value_enabledextensionnames_inc = 0; value_enabledextensionnames_inc < value->enabledExtensionCount; ++value_enabledextensionnames_inc) {
            std::string enabledextensionnames_array_prefix = enabledextensionnames_prefix;
            enabledextensionnames_array_prefix += "[";
            enabledextensionnames_array_prefix += std::to_string(value_enabledextensionnames_inc);
            enabledextensionnames_array_prefix += "]";
            contents.emplace_back("const char* const*", enabledextensionnames_array_prefix, value->enabledExtensionNames[value_enabledextensionnames_inc]);
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrInstanceProperties* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string runtimeversion_prefix = prefix;
        runtimeversion_prefix += "runtimeVersion";
        std::ostringstream oss_runtimeVersion;
        oss_runtimeVersion << "0x" << std::hex << (value->runtimeVersion);
        contents.emplace_back("XrVersion", runtimeversion_prefix, oss_runtimeVersion.str());
        std::string runtimename_prefix = prefix;
        runtimename_prefix += "runtimeName";
        contents.emplace_back("char*", runtimename_prefix, value->runtimeName);
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEventDataBuffer* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string varying_prefix = prefix;
        varying_prefix += "varying";
        std::ostringstream oss_varying_array;
        oss_varying_array << "0x" << std::hex << (value->varying);
        contents.emplace_back("uint8_t*", varying_prefix, oss_varying_array.str());
        for (uint32_t value_varying_inc = 0; value_varying_inc < 4000; ++value_varying_inc) {
            std::string varying_array_prefix = varying_prefix;
            varying_array_prefix += "[";
            varying_array_prefix += std::to_string(value_varying_inc);
            varying_array_prefix += "]";
            std::ostringstream oss_varying;
            oss_varying << "0x" << std::hex << (value->varying[value_varying_inc]);
            contents.emplace_back("uint8_t", varying_array_prefix, oss_varying.str());
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSystemGetInfo* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string formfactor_prefix = prefix;
        formfactor_prefix += "formFactor";
        contents.emplace_back("XrFormFactor", formfactor_prefix, std::to_string(value->formFactor));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSystemGraphicsProperties* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string maxswapchainimageheight_prefix = prefix;
        maxswapchainimageheight_prefix += "maxSwapchainImageHeight";
        std::ostringstream oss_maxSwapchainImageHeight;
        oss_maxSwapchainImageHeight << "0x" << std::hex << (value->maxSwapchainImageHeight);
        contents.emplace_back("uint32_t", maxswapchainimageheight_prefix, oss_maxSwapchainImageHeight.str());
        std::string maxswapchainimagewidth_prefix = prefix;
        maxswapchainimagewidth_prefix += "maxSwapchainImageWidth";
        std::ostringstream oss_maxSwapchainImageWidth;
        oss_maxSwapchainImageWidth << "0x" << std::hex << (value->maxSwapchainImageWidth);
        contents.emplace_back("uint32_t", maxswapchainimagewidth_prefix, oss_maxSwapchainImageWidth.str());
        std::string maxlayercount_prefix = prefix;
        maxlayercount_prefix += "maxLayerCount";
        std::ostringstream oss_maxLayerCount;
        oss_maxLayerCount << "0x" << std::hex << (value->maxLayerCount);
        contents.emplace_back("uint32_t", maxlayercount_prefix, oss_maxLayerCount.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSystemTrackingProperties* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string orientationtracking_prefix = prefix;
        orientationtracking_prefix += "orientationTracking";
        std::ostringstream oss_orientationTracking;
        oss_orientationTracking << "0x" << std::hex << (value->orientationTracking);
        contents.emplace_back("XrBool32", orientationtracking_prefix, oss_orientationTracking.str());
        std::string positiontracking_prefix = prefix;
        positiontracking_prefix += "positionTracking";
        std::ostringstream oss_positionTracking;
        oss_positionTracking << "0x" << std::hex << (value->positionTracking);
        contents.emplace_back("XrBool32", positiontracking_prefix, oss_positionTracking.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSystemProperties* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string systemid_prefix = prefix;
        systemid_prefix += "systemId";
        contents.emplace_back("XrSystemId", systemid_prefix, std::to_string(value->systemId));
        std::string vendorid_prefix = prefix;
        vendorid_prefix += "vendorId";
        std::ostringstream oss_vendorId;
        oss_vendorId << "0x" << std::hex << (value->vendorId);
        contents.emplace_back("uint32_t", vendorid_prefix, oss_vendorId.str());
        std::string systemname_prefix = prefix;
        systemname_prefix += "systemName";
        contents.emplace_back("char*", systemname_prefix, value->systemName);
        std::string graphicsproperties_prefix = prefix;
        graphicsproperties_prefix += "graphicsProperties";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->graphicsProperties, graphicsproperties_prefix, "XrSystemGraphicsProperties", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string trackingproperties_prefix = prefix;
        trackingproperties_prefix += "trackingProperties";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->trackingProperties, trackingproperties_prefix, "XrSystemTrackingProperties", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSessionCreateInfo* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string createflags_prefix = prefix;
        createflags_prefix += "createFlags";
        contents.emplace_back("XrSessionCreateFlags", createflags_prefix, std::to_string(value->createFlags));
        std::string systemid_prefix = prefix;
        systemid_prefix += "systemId";
        contents.emplace_back("XrSystemId", systemid_prefix, std::to_string(value->systemId));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrVector3f* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string x_prefix = prefix;
        x_prefix += "x";
        std::ostringstream oss_x;
        oss_x << std::setprecision(32) << (value->x);
        contents.emplace_back("float", x_prefix, oss_x.str());
        std::string y_prefix = prefix;
        y_prefix += "y";
        std::ostringstream oss_y;
        oss_y << std::setprecision(32) << (value->y);
        contents.emplace_back("float", y_prefix, oss_y.str());
        std::string z_prefix = prefix;
        z_prefix += "z";
        std::ostringstream oss_z;
        oss_z << std::setprecision(32) << (value->z);
        contents.emplace_back("float", z_prefix, oss_z.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpaceVelocity* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string velocityflags_prefix = prefix;
        velocityflags_prefix += "velocityFlags";
        contents.emplace_back("XrSpaceVelocityFlags", velocityflags_prefix, std::to_string(value->velocityFlags));
        std::string linearvelocity_prefix = prefix;
        linearvelocity_prefix += "linearVelocity";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->linearVelocity, linearvelocity_prefix, "XrVector3f", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string angularvelocity_prefix = prefix;
        angularvelocity_prefix += "angularVelocity";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->angularVelocity, angularvelocity_prefix, "XrVector3f", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrQuaternionf* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string x_prefix = prefix;
        x_prefix += "x";
        std::ostringstream oss_x;
        oss_x << std::setprecision(32) << (value->x);
        contents.emplace_back("float", x_prefix, oss_x.str());
        std::string y_prefix = prefix;
        y_prefix += "y";
        std::ostringstream oss_y;
        oss_y << std::setprecision(32) << (value->y);
        contents.emplace_back("float", y_prefix, oss_y.str());
        std::string z_prefix = prefix;
        z_prefix += "z";
        std::ostringstream oss_z;
        oss_z << std::setprecision(32) << (value->z);
        contents.emplace_back("float", z_prefix, oss_z.str());
        std::string w_prefix = prefix;
        w_prefix += "w";
        std::ostringstream oss_w;
        oss_w << std::setprecision(32) << (value->w);
        contents.emplace_back("float", w_prefix, oss_w.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrPosef* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string orientation_prefix = prefix;
        orientation_prefix += "orientation";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->orientation, orientation_prefix, "XrQuaternionf", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string position_prefix = prefix;
        position_prefix += "position";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->position, position_prefix, "XrVector3f", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrReferenceSpaceCreateInfo* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string referencespacetype_prefix = prefix;
        referencespacetype_prefix += "referenceSpaceType";
        contents.emplace_back("XrReferenceSpaceType", referencespacetype_prefix, std::to_string(value->referenceSpaceType));
        std::string poseinreferencespace_prefix = prefix;
        poseinreferencespace_prefix += "poseInReferenceSpace";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->poseInReferenceSpace, poseinreferencespace_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrExtent2Df* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string width_prefix = prefix;
        width_prefix += "width";
        std::ostringstream oss_width;
        oss_width << std::setprecision(32) << (value->width);
        contents.emplace_back("float", width_prefix, oss_width.str());
        std::string height_prefix = prefix;
        height_prefix += "height";
        std::ostringstream oss_height;
        oss_height << std::setprecision(32) << (value->height);
        contents.emplace_back("float", height_prefix, oss_height.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrActionSpaceCreateInfo* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string action_prefix = prefix;
        action_prefix += "action";
        std::ostringstream oss_action;
        oss_action << std::hex << reinterpret_cast<const void*>(value->action);
        contents.emplace_back("XrAction", action_prefix, oss_action.str());
        std::string subactionpath_prefix = prefix;
        subactionpath_prefix += "subactionPath";
        contents.emplace_back("XrPath", subactionpath_prefix, std::to_string(value->subactionPath));
        std::string poseinactionspace_prefix = prefix;
        poseinactionspace_prefix += "poseInActionSpace";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->poseInActionSpace, poseinactionspace_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpaceLocation* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string locationflags_prefix = prefix;
        locationflags_prefix += "locationFlags";
        contents.emplace_back("XrSpaceLocationFlags", locationflags_prefix, std::to_string(value->locationFlags));
        std::string pose_prefix = prefix;
        pose_prefix += "pose";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->pose, pose_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrViewConfigurationProperties* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string viewconfigurationtype_prefix = prefix;
        viewconfigurationtype_prefix += "viewConfigurationType";
        contents.emplace_back("XrViewConfigurationType", viewconfigurationtype_prefix, std::to_string(value->viewConfigurationType));
        std::string fovmutable_prefix = prefix;
        fovmutable_prefix += "fovMutable";
        std::ostringstream oss_fovMutable;
        oss_fovMutable << "0x" << std::hex << (value->fovMutable);
        contents.emplace_back("XrBool32", fovmutable_prefix, oss_fovMutable.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrViewConfigurationView* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string recommendedimagerectwidth_prefix = prefix;
        recommendedimagerectwidth_prefix += "recommendedImageRectWidth";
        std::ostringstream oss_recommendedImageRectWidth;
        oss_recommendedImageRectWidth << "0x" << std::hex << (value->recommendedImageRectWidth);
        contents.emplace_back("uint32_t", recommendedimagerectwidth_prefix, oss_recommendedImageRectWidth.str());
        std::string maximagerectwidth_prefix = prefix;
        maximagerectwidth_prefix += "maxImageRectWidth";
        std::ostringstream oss_maxImageRectWidth;
        oss_maxImageRectWidth << "0x" << std::hex << (value->maxImageRectWidth);
        contents.emplace_back("uint32_t", maximagerectwidth_prefix, oss_maxImageRectWidth.str());
        std::string recommendedimagerectheight_prefix = prefix;
        recommendedimagerectheight_prefix += "recommendedImageRectHeight";
        std::ostringstream oss_recommendedImageRectHeight;
        oss_recommendedImageRectHeight << "0x" << std::hex << (value->recommendedImageRectHeight);
        contents.emplace_back("uint32_t", recommendedimagerectheight_prefix, oss_recommendedImageRectHeight.str());
        std::string maximagerectheight_prefix = prefix;
        maximagerectheight_prefix += "maxImageRectHeight";
        std::ostringstream oss_maxImageRectHeight;
        oss_maxImageRectHeight << "0x" << std::hex << (value->maxImageRectHeight);
        contents.emplace_back("uint32_t", maximagerectheight_prefix, oss_maxImageRectHeight.str());
        std::string recommendedswapchainsamplecount_prefix = prefix;
        recommendedswapchainsamplecount_prefix += "recommendedSwapchainSampleCount";
        std::ostringstream oss_recommendedSwapchainSampleCount;
        oss_recommendedSwapchainSampleCount << "0x" << std::hex << (value->recommendedSwapchainSampleCount);
        contents.emplace_back("uint32_t", recommendedswapchainsamplecount_prefix, oss_recommendedSwapchainSampleCount.str());
        std::string maxswapchainsamplecount_prefix = prefix;
        maxswapchainsamplecount_prefix += "maxSwapchainSampleCount";
        std::ostringstream oss_maxSwapchainSampleCount;
        oss_maxSwapchainSampleCount << "0x" << std::hex << (value->maxSwapchainSampleCount);
        contents.emplace_back("uint32_t", maxswapchainsamplecount_prefix, oss_maxSwapchainSampleCount.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSwapchainCreateInfo* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string createflags_prefix = prefix;
        createflags_prefix += "createFlags";
        contents.emplace_back("XrSwapchainCreateFlags", createflags_prefix, std::to_string(value->createFlags));
        std::string usageflags_prefix = prefix;
        usageflags_prefix += "usageFlags";
        contents.emplace_back("XrSwapchainUsageFlags", usageflags_prefix, std::to_string(value->usageFlags));
        std::string format_prefix = prefix;
        format_prefix += "format";
        contents.emplace_back("int64_t", format_prefix, std::to_string(value->format));
        std::string samplecount_prefix = prefix;
        samplecount_prefix += "sampleCount";
        std::ostringstream oss_sampleCount;
        oss_sampleCount << "0x" << std::hex << (value->sampleCount);
        contents.emplace_back("uint32_t", samplecount_prefix, oss_sampleCount.str());
        std::string width_prefix = prefix;
        width_prefix += "width";
        std::ostringstream oss_width;
        oss_width << "0x" << std::hex << (value->width);
        contents.emplace_back("uint32_t", width_prefix, oss_width.str());
        std::string height_prefix = prefix;
        height_prefix += "height";
        std::ostringstream oss_height;
        oss_height << "0x" << std::hex << (value->height);
        contents.emplace_back("uint32_t", height_prefix, oss_height.str());
        std::string facecount_prefix = prefix;
        facecount_prefix += "faceCount";
        std::ostringstream oss_faceCount;
        oss_faceCount << "0x" << std::hex << (value->faceCount);
        contents.emplace_back("uint32_t", facecount_prefix, oss_faceCount.str());
        std::string arraysize_prefix = prefix;
        arraysize_prefix += "arraySize";
        std::ostringstream oss_arraySize;
        oss_arraySize << "0x" << std::hex << (value->arraySize);
        contents.emplace_back("uint32_t", arraysize_prefix, oss_arraySize.str());
        std::string mipcount_prefix = prefix;
        mipcount_prefix += "mipCount";
        std::ostringstream oss_mipCount;
        oss_mipCount << "0x" << std::hex << (value->mipCount);
        contents.emplace_back("uint32_t", mipcount_prefix, oss_mipCount.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSwapchainImageBaseHeader* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
#if defined(XR_USE_GRAPHICS_API_OPENGL)
        if (value->type == XR_TYPE_SWAPCHAIN_IMAGE_OPENGL_KHR) {
            const XrSwapchainImageOpenGLKHR* new_value = reinterpret_cast<const XrSwapchainImageOpenGLKHR*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
#endif // defined(XR_USE_GRAPHICS_API_OPENGL)
#if defined(XR_USE_GRAPHICS_API_OPENGL_ES)
        if (value->type == XR_TYPE_SWAPCHAIN_IMAGE_OPENGL_ES_KHR) {
            const XrSwapchainImageOpenGLESKHR* new_value = reinterpret_cast<const XrSwapchainImageOpenGLESKHR*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
#endif // defined(XR_USE_GRAPHICS_API_OPENGL_ES)
#if defined(XR_USE_GRAPHICS_API_VULKAN)
        if (value->type == XR_TYPE_SWAPCHAIN_IMAGE_VULKAN_KHR) {
            const XrSwapchainImageVulkanKHR* new_value = reinterpret_cast<const XrSwapchainImageVulkanKHR*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
#endif // defined(XR_USE_GRAPHICS_API_VULKAN)
#if defined(XR_USE_GRAPHICS_API_D3D11)
        if (value->type == XR_TYPE_SWAPCHAIN_IMAGE_D3D11_KHR) {
            const XrSwapchainImageD3D11KHR* new_value = reinterpret_cast<const XrSwapchainImageD3D11KHR*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
#endif // defined(XR_USE_GRAPHICS_API_D3D11)
#if defined(XR_USE_GRAPHICS_API_D3D12)
        if (value->type == XR_TYPE_SWAPCHAIN_IMAGE_D3D12_KHR) {
            const XrSwapchainImageD3D12KHR* new_value = reinterpret_cast<const XrSwapchainImageD3D12KHR*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
#endif // defined(XR_USE_GRAPHICS_API_D3D12)
#if defined(XR_USE_GRAPHICS_API_METAL)
        if (value->type == XR_TYPE_SWAPCHAIN_IMAGE_METAL_KHR) {
            const XrSwapchainImageMetalKHR* new_value = reinterpret_cast<const XrSwapchainImageMetalKHR*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
#endif // defined(XR_USE_GRAPHICS_API_METAL)
        // Fallback path - Just output generic information about the base struct
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSwapchainImageAcquireInfo* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSwapchainImageWaitInfo* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string timeout_prefix = prefix;
        timeout_prefix += "timeout";
        contents.emplace_back("XrDuration", timeout_prefix, std::to_string(value->timeout));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSwapchainImageReleaseInfo* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSessionBeginInfo* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string primaryviewconfigurationtype_prefix = prefix;
        primaryviewconfigurationtype_prefix += "primaryViewConfigurationType";
        contents.emplace_back("XrViewConfigurationType", primaryviewconfigurationtype_prefix, std::to_string(value->primaryViewConfigurationType));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrFrameWaitInfo* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrFrameState* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string predicteddisplaytime_prefix = prefix;
        predicteddisplaytime_prefix += "predictedDisplayTime";
        contents.emplace_back("XrTime", predicteddisplaytime_prefix, std::to_string(value->predictedDisplayTime));
        std::string predicteddisplayperiod_prefix = prefix;
        predicteddisplayperiod_prefix += "predictedDisplayPeriod";
        contents.emplace_back("XrDuration", predicteddisplayperiod_prefix, std::to_string(value->predictedDisplayPeriod));
        std::string shouldrender_prefix = prefix;
        shouldrender_prefix += "shouldRender";
        std::ostringstream oss_shouldRender;
        oss_shouldRender << "0x" << std::hex << (value->shouldRender);
        contents.emplace_back("XrBool32", shouldrender_prefix, oss_shouldRender.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrFrameBeginInfo* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrCompositionLayerBaseHeader* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        if (value->type == XR_TYPE_COMPOSITION_LAYER_PROJECTION) {
            const XrCompositionLayerProjection* new_value = reinterpret_cast<const XrCompositionLayerProjection*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_COMPOSITION_LAYER_QUAD) {
            const XrCompositionLayerQuad* new_value = reinterpret_cast<const XrCompositionLayerQuad*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_COMPOSITION_LAYER_CUBE_KHR) {
            const XrCompositionLayerCubeKHR* new_value = reinterpret_cast<const XrCompositionLayerCubeKHR*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_COMPOSITION_LAYER_CYLINDER_KHR) {
            const XrCompositionLayerCylinderKHR* new_value = reinterpret_cast<const XrCompositionLayerCylinderKHR*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_COMPOSITION_LAYER_EQUIRECT_KHR) {
            const XrCompositionLayerEquirectKHR* new_value = reinterpret_cast<const XrCompositionLayerEquirectKHR*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_COMPOSITION_LAYER_EQUIRECT2_KHR) {
            const XrCompositionLayerEquirect2KHR* new_value = reinterpret_cast<const XrCompositionLayerEquirect2KHR*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_COMPOSITION_LAYER_PASSTHROUGH_FB) {
            const XrCompositionLayerPassthroughFB* new_value = reinterpret_cast<const XrCompositionLayerPassthroughFB*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_COMPOSITION_LAYER_PASSTHROUGH_HTC) {
            const XrCompositionLayerPassthroughHTC* new_value = reinterpret_cast<const XrCompositionLayerPassthroughHTC*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        // Fallback path - Just output generic information about the base struct
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string layerflags_prefix = prefix;
        layerflags_prefix += "layerFlags";
        contents.emplace_back("XrCompositionLayerFlags", layerflags_prefix, std::to_string(value->layerFlags));
        std::string space_prefix = prefix;
        space_prefix += "space";
        std::ostringstream oss_space;
        oss_space << std::hex << reinterpret_cast<const void*>(value->space);
        contents.emplace_back("XrSpace", space_prefix, oss_space.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrFrameEndInfo* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string displaytime_prefix = prefix;
        displaytime_prefix += "displayTime";
        contents.emplace_back("XrTime", displaytime_prefix, std::to_string(value->displayTime));
        std::string environmentblendmode_prefix = prefix;
        environmentblendmode_prefix += "environmentBlendMode";
        contents.emplace_back("XrEnvironmentBlendMode", environmentblendmode_prefix, std::to_string(value->environmentBlendMode));
        std::string layercount_prefix = prefix;
        layercount_prefix += "layerCount";
        std::ostringstream oss_layerCount;
        oss_layerCount << "0x" << std::hex << (value->layerCount);
        contents.emplace_back("uint32_t", layercount_prefix, oss_layerCount.str());
        std::string layers_prefix = prefix;
        layers_prefix += "layers";
        std::ostringstream oss_layers_array;
        oss_layers_array << std::hex << reinterpret_cast<const void*>(value->layers);
        contents.emplace_back("const XrCompositionLayerBaseHeader* const*", layers_prefix, oss_layers_array.str());
        for (uint32_t value_layers_inc = 0; value_layers_inc < value->layerCount; ++value_layers_inc) {
            std::string layers_array_prefix = layers_prefix;
            layers_array_prefix += "[";
            layers_array_prefix += std::to_string(value_layers_inc);
            layers_array_prefix += "]";
            if (nullptr == value->layers[value_layers_inc]) {
                std::ostringstream oss_layers;
                oss_layers << std::hex << reinterpret_cast<const void*>(value->layers[value_layers_inc]);
                contents.emplace_back("const XrCompositionLayerBaseHeader* const*", layers_array_prefix, oss_layers.str());
            } else if (!ApiDumpOutputXrStruct(gen_dispatch_table, value->layers[value_layers_inc], layers_array_prefix, "const XrCompositionLayerBaseHeader* const*", true, contents)) {
                throw std::invalid_argument("Invalid Operation");
            }
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrViewLocateInfo* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string viewconfigurationtype_prefix = prefix;
        viewconfigurationtype_prefix += "viewConfigurationType";
        contents.emplace_back("XrViewConfigurationType", viewconfigurationtype_prefix, std::to_string(value->viewConfigurationType));
        std::string displaytime_prefix = prefix;
        displaytime_prefix += "displayTime";
        contents.emplace_back("XrTime", displaytime_prefix, std::to_string(value->displayTime));
        std::string space_prefix = prefix;
        space_prefix += "space";
        std::ostringstream oss_space;
        oss_space << std::hex << reinterpret_cast<const void*>(value->space);
        contents.emplace_back("XrSpace", space_prefix, oss_space.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrViewState* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string viewstateflags_prefix = prefix;
        viewstateflags_prefix += "viewStateFlags";
        contents.emplace_back("XrViewStateFlags", viewstateflags_prefix, std::to_string(value->viewStateFlags));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrFovf* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string angleleft_prefix = prefix;
        angleleft_prefix += "angleLeft";
        std::ostringstream oss_angleLeft;
        oss_angleLeft << std::setprecision(32) << (value->angleLeft);
        contents.emplace_back("float", angleleft_prefix, oss_angleLeft.str());
        std::string angleright_prefix = prefix;
        angleright_prefix += "angleRight";
        std::ostringstream oss_angleRight;
        oss_angleRight << std::setprecision(32) << (value->angleRight);
        contents.emplace_back("float", angleright_prefix, oss_angleRight.str());
        std::string angleup_prefix = prefix;
        angleup_prefix += "angleUp";
        std::ostringstream oss_angleUp;
        oss_angleUp << std::setprecision(32) << (value->angleUp);
        contents.emplace_back("float", angleup_prefix, oss_angleUp.str());
        std::string angledown_prefix = prefix;
        angledown_prefix += "angleDown";
        std::ostringstream oss_angleDown;
        oss_angleDown << std::setprecision(32) << (value->angleDown);
        contents.emplace_back("float", angledown_prefix, oss_angleDown.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrView* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string pose_prefix = prefix;
        pose_prefix += "pose";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->pose, pose_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string fov_prefix = prefix;
        fov_prefix += "fov";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->fov, fov_prefix, "XrFovf", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrActionSetCreateInfo* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string actionsetname_prefix = prefix;
        actionsetname_prefix += "actionSetName";
        contents.emplace_back("char*", actionsetname_prefix, value->actionSetName);
        std::string localizedactionsetname_prefix = prefix;
        localizedactionsetname_prefix += "localizedActionSetName";
        contents.emplace_back("char*", localizedactionsetname_prefix, value->localizedActionSetName);
        std::string priority_prefix = prefix;
        priority_prefix += "priority";
        std::ostringstream oss_priority;
        oss_priority << "0x" << std::hex << (value->priority);
        contents.emplace_back("uint32_t", priority_prefix, oss_priority.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrActionCreateInfo* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string actionname_prefix = prefix;
        actionname_prefix += "actionName";
        contents.emplace_back("char*", actionname_prefix, value->actionName);
        std::string actiontype_prefix = prefix;
        actiontype_prefix += "actionType";
        contents.emplace_back("XrActionType", actiontype_prefix, std::to_string(value->actionType));
        std::string countsubactionpaths_prefix = prefix;
        countsubactionpaths_prefix += "countSubactionPaths";
        std::ostringstream oss_countSubactionPaths;
        oss_countSubactionPaths << "0x" << std::hex << (value->countSubactionPaths);
        contents.emplace_back("uint32_t", countsubactionpaths_prefix, oss_countSubactionPaths.str());
        std::string subactionpaths_prefix = prefix;
        subactionpaths_prefix += "subactionPaths";
        std::ostringstream oss_subactionPaths_array;
        oss_subactionPaths_array << std::hex << reinterpret_cast<const void*>(value->subactionPaths);
        contents.emplace_back("const XrPath*", subactionpaths_prefix, oss_subactionPaths_array.str());
        for (uint32_t value_subactionpaths_inc = 0; value_subactionpaths_inc < value->countSubactionPaths; ++value_subactionpaths_inc) {
            std::string subactionpaths_array_prefix = subactionpaths_prefix;
            subactionpaths_array_prefix += "[";
            subactionpaths_array_prefix += std::to_string(value_subactionpaths_inc);
            subactionpaths_array_prefix += "]";
            contents.emplace_back("const XrPath*", subactionpaths_array_prefix, std::to_string(value->subactionPaths[value_subactionpaths_inc]));
        }
        std::string localizedactionname_prefix = prefix;
        localizedactionname_prefix += "localizedActionName";
        contents.emplace_back("char*", localizedactionname_prefix, value->localizedActionName);
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrActionSuggestedBinding* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string action_prefix = prefix;
        action_prefix += "action";
        std::ostringstream oss_action;
        oss_action << std::hex << reinterpret_cast<const void*>(value->action);
        contents.emplace_back("XrAction", action_prefix, oss_action.str());
        std::string binding_prefix = prefix;
        binding_prefix += "binding";
        contents.emplace_back("XrPath", binding_prefix, std::to_string(value->binding));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrInteractionProfileSuggestedBinding* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string interactionprofile_prefix = prefix;
        interactionprofile_prefix += "interactionProfile";
        contents.emplace_back("XrPath", interactionprofile_prefix, std::to_string(value->interactionProfile));
        std::string countsuggestedbindings_prefix = prefix;
        countsuggestedbindings_prefix += "countSuggestedBindings";
        std::ostringstream oss_countSuggestedBindings;
        oss_countSuggestedBindings << "0x" << std::hex << (value->countSuggestedBindings);
        contents.emplace_back("uint32_t", countsuggestedbindings_prefix, oss_countSuggestedBindings.str());
        std::string suggestedbindings_prefix = prefix;
        suggestedbindings_prefix += "suggestedBindings";
        std::ostringstream oss_suggestedBindings_array;
        oss_suggestedBindings_array << std::hex << reinterpret_cast<const void*>(value->suggestedBindings);
        contents.emplace_back("const XrActionSuggestedBinding*", suggestedbindings_prefix, oss_suggestedBindings_array.str());
        for (uint32_t value_suggestedbindings_inc = 0; value_suggestedbindings_inc < value->countSuggestedBindings; ++value_suggestedbindings_inc) {
            std::string suggestedbindings_array_prefix = suggestedbindings_prefix;
            suggestedbindings_array_prefix += "[";
            suggestedbindings_array_prefix += std::to_string(value_suggestedbindings_inc);
            suggestedbindings_array_prefix += "]";
            if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->suggestedBindings[value_suggestedbindings_inc], suggestedbindings_array_prefix, "const XrActionSuggestedBinding*", false, contents)) {
                throw std::invalid_argument("Invalid Operation");
            }
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSessionActionSetsAttachInfo* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string countactionsets_prefix = prefix;
        countactionsets_prefix += "countActionSets";
        std::ostringstream oss_countActionSets;
        oss_countActionSets << "0x" << std::hex << (value->countActionSets);
        contents.emplace_back("uint32_t", countactionsets_prefix, oss_countActionSets.str());
        std::string actionsets_prefix = prefix;
        actionsets_prefix += "actionSets";
        std::ostringstream oss_actionSets_array;
        oss_actionSets_array << std::hex << reinterpret_cast<const void*>(value->actionSets);
        contents.emplace_back("const XrActionSet*", actionsets_prefix, oss_actionSets_array.str());
        for (uint32_t value_actionsets_inc = 0; value_actionsets_inc < value->countActionSets; ++value_actionsets_inc) {
            std::string actionsets_array_prefix = actionsets_prefix;
            actionsets_array_prefix += "[";
            actionsets_array_prefix += std::to_string(value_actionsets_inc);
            actionsets_array_prefix += "]";
            std::ostringstream oss_actionSets;
            oss_actionSets << std::hex << reinterpret_cast<const void*>(value->actionSets[value_actionsets_inc]);
            contents.emplace_back("const XrActionSet*", actionsets_array_prefix, oss_actionSets.str());
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrInteractionProfileState* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string interactionprofile_prefix = prefix;
        interactionprofile_prefix += "interactionProfile";
        contents.emplace_back("XrPath", interactionprofile_prefix, std::to_string(value->interactionProfile));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrActionStateGetInfo* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string action_prefix = prefix;
        action_prefix += "action";
        std::ostringstream oss_action;
        oss_action << std::hex << reinterpret_cast<const void*>(value->action);
        contents.emplace_back("XrAction", action_prefix, oss_action.str());
        std::string subactionpath_prefix = prefix;
        subactionpath_prefix += "subactionPath";
        contents.emplace_back("XrPath", subactionpath_prefix, std::to_string(value->subactionPath));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrActionStateBoolean* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string currentstate_prefix = prefix;
        currentstate_prefix += "currentState";
        std::ostringstream oss_currentState;
        oss_currentState << "0x" << std::hex << (value->currentState);
        contents.emplace_back("XrBool32", currentstate_prefix, oss_currentState.str());
        std::string changedsincelastsync_prefix = prefix;
        changedsincelastsync_prefix += "changedSinceLastSync";
        std::ostringstream oss_changedSinceLastSync;
        oss_changedSinceLastSync << "0x" << std::hex << (value->changedSinceLastSync);
        contents.emplace_back("XrBool32", changedsincelastsync_prefix, oss_changedSinceLastSync.str());
        std::string lastchangetime_prefix = prefix;
        lastchangetime_prefix += "lastChangeTime";
        contents.emplace_back("XrTime", lastchangetime_prefix, std::to_string(value->lastChangeTime));
        std::string isactive_prefix = prefix;
        isactive_prefix += "isActive";
        std::ostringstream oss_isActive;
        oss_isActive << "0x" << std::hex << (value->isActive);
        contents.emplace_back("XrBool32", isactive_prefix, oss_isActive.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrActionStateFloat* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string currentstate_prefix = prefix;
        currentstate_prefix += "currentState";
        std::ostringstream oss_currentState;
        oss_currentState << std::setprecision(32) << (value->currentState);
        contents.emplace_back("float", currentstate_prefix, oss_currentState.str());
        std::string changedsincelastsync_prefix = prefix;
        changedsincelastsync_prefix += "changedSinceLastSync";
        std::ostringstream oss_changedSinceLastSync;
        oss_changedSinceLastSync << "0x" << std::hex << (value->changedSinceLastSync);
        contents.emplace_back("XrBool32", changedsincelastsync_prefix, oss_changedSinceLastSync.str());
        std::string lastchangetime_prefix = prefix;
        lastchangetime_prefix += "lastChangeTime";
        contents.emplace_back("XrTime", lastchangetime_prefix, std::to_string(value->lastChangeTime));
        std::string isactive_prefix = prefix;
        isactive_prefix += "isActive";
        std::ostringstream oss_isActive;
        oss_isActive << "0x" << std::hex << (value->isActive);
        contents.emplace_back("XrBool32", isactive_prefix, oss_isActive.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrVector2f* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string x_prefix = prefix;
        x_prefix += "x";
        std::ostringstream oss_x;
        oss_x << std::setprecision(32) << (value->x);
        contents.emplace_back("float", x_prefix, oss_x.str());
        std::string y_prefix = prefix;
        y_prefix += "y";
        std::ostringstream oss_y;
        oss_y << std::setprecision(32) << (value->y);
        contents.emplace_back("float", y_prefix, oss_y.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrActionStateVector2f* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string currentstate_prefix = prefix;
        currentstate_prefix += "currentState";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->currentState, currentstate_prefix, "XrVector2f", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string changedsincelastsync_prefix = prefix;
        changedsincelastsync_prefix += "changedSinceLastSync";
        std::ostringstream oss_changedSinceLastSync;
        oss_changedSinceLastSync << "0x" << std::hex << (value->changedSinceLastSync);
        contents.emplace_back("XrBool32", changedsincelastsync_prefix, oss_changedSinceLastSync.str());
        std::string lastchangetime_prefix = prefix;
        lastchangetime_prefix += "lastChangeTime";
        contents.emplace_back("XrTime", lastchangetime_prefix, std::to_string(value->lastChangeTime));
        std::string isactive_prefix = prefix;
        isactive_prefix += "isActive";
        std::ostringstream oss_isActive;
        oss_isActive << "0x" << std::hex << (value->isActive);
        contents.emplace_back("XrBool32", isactive_prefix, oss_isActive.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrActionStatePose* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string isactive_prefix = prefix;
        isactive_prefix += "isActive";
        std::ostringstream oss_isActive;
        oss_isActive << "0x" << std::hex << (value->isActive);
        contents.emplace_back("XrBool32", isactive_prefix, oss_isActive.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrActiveActionSet* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string actionset_prefix = prefix;
        actionset_prefix += "actionSet";
        std::ostringstream oss_actionSet;
        oss_actionSet << std::hex << reinterpret_cast<const void*>(value->actionSet);
        contents.emplace_back("XrActionSet", actionset_prefix, oss_actionSet.str());
        std::string subactionpath_prefix = prefix;
        subactionpath_prefix += "subactionPath";
        contents.emplace_back("XrPath", subactionpath_prefix, std::to_string(value->subactionPath));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrActionsSyncInfo* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string countactiveactionsets_prefix = prefix;
        countactiveactionsets_prefix += "countActiveActionSets";
        std::ostringstream oss_countActiveActionSets;
        oss_countActiveActionSets << "0x" << std::hex << (value->countActiveActionSets);
        contents.emplace_back("uint32_t", countactiveactionsets_prefix, oss_countActiveActionSets.str());
        std::string activeactionsets_prefix = prefix;
        activeactionsets_prefix += "activeActionSets";
        std::ostringstream oss_activeActionSets_array;
        oss_activeActionSets_array << std::hex << reinterpret_cast<const void*>(value->activeActionSets);
        contents.emplace_back("const XrActiveActionSet*", activeactionsets_prefix, oss_activeActionSets_array.str());
        for (uint32_t value_activeactionsets_inc = 0; value_activeactionsets_inc < value->countActiveActionSets; ++value_activeactionsets_inc) {
            std::string activeactionsets_array_prefix = activeactionsets_prefix;
            activeactionsets_array_prefix += "[";
            activeactionsets_array_prefix += std::to_string(value_activeactionsets_inc);
            activeactionsets_array_prefix += "]";
            if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->activeActionSets[value_activeactionsets_inc], activeactionsets_array_prefix, "const XrActiveActionSet*", false, contents)) {
                throw std::invalid_argument("Invalid Operation");
            }
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrBoundSourcesForActionEnumerateInfo* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string action_prefix = prefix;
        action_prefix += "action";
        std::ostringstream oss_action;
        oss_action << std::hex << reinterpret_cast<const void*>(value->action);
        contents.emplace_back("XrAction", action_prefix, oss_action.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrInputSourceLocalizedNameGetInfo* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string sourcepath_prefix = prefix;
        sourcepath_prefix += "sourcePath";
        contents.emplace_back("XrPath", sourcepath_prefix, std::to_string(value->sourcePath));
        std::string whichcomponents_prefix = prefix;
        whichcomponents_prefix += "whichComponents";
        contents.emplace_back("XrInputSourceLocalizedNameFlags", whichcomponents_prefix, std::to_string(value->whichComponents));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrHapticActionInfo* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string action_prefix = prefix;
        action_prefix += "action";
        std::ostringstream oss_action;
        oss_action << std::hex << reinterpret_cast<const void*>(value->action);
        contents.emplace_back("XrAction", action_prefix, oss_action.str());
        std::string subactionpath_prefix = prefix;
        subactionpath_prefix += "subactionPath";
        contents.emplace_back("XrPath", subactionpath_prefix, std::to_string(value->subactionPath));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrHapticBaseHeader* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        if (value->type == XR_TYPE_HAPTIC_VIBRATION) {
            const XrHapticVibration* new_value = reinterpret_cast<const XrHapticVibration*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_HAPTIC_AMPLITUDE_ENVELOPE_VIBRATION_FB) {
            const XrHapticAmplitudeEnvelopeVibrationFB* new_value = reinterpret_cast<const XrHapticAmplitudeEnvelopeVibrationFB*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_HAPTIC_PCM_VIBRATION_FB) {
            const XrHapticPcmVibrationFB* new_value = reinterpret_cast<const XrHapticPcmVibrationFB*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        // Fallback path - Just output generic information about the base struct
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrBaseInStructure* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrBaseOutStructure* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrOffset2Di* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string x_prefix = prefix;
        x_prefix += "x";
        contents.emplace_back("int32_t", x_prefix, std::to_string(value->x));
        std::string y_prefix = prefix;
        y_prefix += "y";
        contents.emplace_back("int32_t", y_prefix, std::to_string(value->y));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrExtent2Di* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string width_prefix = prefix;
        width_prefix += "width";
        contents.emplace_back("int32_t", width_prefix, std::to_string(value->width));
        std::string height_prefix = prefix;
        height_prefix += "height";
        contents.emplace_back("int32_t", height_prefix, std::to_string(value->height));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrRect2Di* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string offset_prefix = prefix;
        offset_prefix += "offset";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->offset, offset_prefix, "XrOffset2Di", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string extent_prefix = prefix;
        extent_prefix += "extent";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->extent, extent_prefix, "XrExtent2Di", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSwapchainSubImage* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string swapchain_prefix = prefix;
        swapchain_prefix += "swapchain";
        std::ostringstream oss_swapchain;
        oss_swapchain << std::hex << reinterpret_cast<const void*>(value->swapchain);
        contents.emplace_back("XrSwapchain", swapchain_prefix, oss_swapchain.str());
        std::string imagerect_prefix = prefix;
        imagerect_prefix += "imageRect";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->imageRect, imagerect_prefix, "XrRect2Di", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string imagearrayindex_prefix = prefix;
        imagearrayindex_prefix += "imageArrayIndex";
        std::ostringstream oss_imageArrayIndex;
        oss_imageArrayIndex << "0x" << std::hex << (value->imageArrayIndex);
        contents.emplace_back("uint32_t", imagearrayindex_prefix, oss_imageArrayIndex.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrCompositionLayerProjectionView* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string pose_prefix = prefix;
        pose_prefix += "pose";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->pose, pose_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string fov_prefix = prefix;
        fov_prefix += "fov";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->fov, fov_prefix, "XrFovf", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string subimage_prefix = prefix;
        subimage_prefix += "subImage";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->subImage, subimage_prefix, "XrSwapchainSubImage", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrCompositionLayerProjection* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string layerflags_prefix = prefix;
        layerflags_prefix += "layerFlags";
        contents.emplace_back("XrCompositionLayerFlags", layerflags_prefix, std::to_string(value->layerFlags));
        std::string space_prefix = prefix;
        space_prefix += "space";
        std::ostringstream oss_space;
        oss_space << std::hex << reinterpret_cast<const void*>(value->space);
        contents.emplace_back("XrSpace", space_prefix, oss_space.str());
        std::string viewcount_prefix = prefix;
        viewcount_prefix += "viewCount";
        std::ostringstream oss_viewCount;
        oss_viewCount << "0x" << std::hex << (value->viewCount);
        contents.emplace_back("uint32_t", viewcount_prefix, oss_viewCount.str());
        std::string views_prefix = prefix;
        views_prefix += "views";
        std::ostringstream oss_views_array;
        oss_views_array << std::hex << reinterpret_cast<const void*>(value->views);
        contents.emplace_back("const XrCompositionLayerProjectionView*", views_prefix, oss_views_array.str());
        for (uint32_t value_views_inc = 0; value_views_inc < value->viewCount; ++value_views_inc) {
            std::string views_array_prefix = views_prefix;
            views_array_prefix += "[";
            views_array_prefix += std::to_string(value_views_inc);
            views_array_prefix += "]";
            if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->views[value_views_inc], views_array_prefix, "const XrCompositionLayerProjectionView*", false, contents)) {
                throw std::invalid_argument("Invalid Operation");
            }
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrCompositionLayerQuad* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string layerflags_prefix = prefix;
        layerflags_prefix += "layerFlags";
        contents.emplace_back("XrCompositionLayerFlags", layerflags_prefix, std::to_string(value->layerFlags));
        std::string space_prefix = prefix;
        space_prefix += "space";
        std::ostringstream oss_space;
        oss_space << std::hex << reinterpret_cast<const void*>(value->space);
        contents.emplace_back("XrSpace", space_prefix, oss_space.str());
        std::string eyevisibility_prefix = prefix;
        eyevisibility_prefix += "eyeVisibility";
        contents.emplace_back("XrEyeVisibility", eyevisibility_prefix, std::to_string(value->eyeVisibility));
        std::string subimage_prefix = prefix;
        subimage_prefix += "subImage";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->subImage, subimage_prefix, "XrSwapchainSubImage", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string pose_prefix = prefix;
        pose_prefix += "pose";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->pose, pose_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string size_prefix = prefix;
        size_prefix += "size";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->size, size_prefix, "XrExtent2Df", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEventDataBaseHeader* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        if (value->type == XR_TYPE_EVENT_DATA_EVENTS_LOST) {
            const XrEventDataEventsLost* new_value = reinterpret_cast<const XrEventDataEventsLost*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_INSTANCE_LOSS_PENDING) {
            const XrEventDataInstanceLossPending* new_value = reinterpret_cast<const XrEventDataInstanceLossPending*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_SESSION_STATE_CHANGED) {
            const XrEventDataSessionStateChanged* new_value = reinterpret_cast<const XrEventDataSessionStateChanged*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_REFERENCE_SPACE_CHANGE_PENDING) {
            const XrEventDataReferenceSpaceChangePending* new_value = reinterpret_cast<const XrEventDataReferenceSpaceChangePending*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_INTERACTION_PROFILE_CHANGED) {
            const XrEventDataInteractionProfileChanged* new_value = reinterpret_cast<const XrEventDataInteractionProfileChanged*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_VISIBILITY_MASK_CHANGED_KHR) {
            const XrEventDataVisibilityMaskChangedKHR* new_value = reinterpret_cast<const XrEventDataVisibilityMaskChangedKHR*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_PERF_SETTINGS_EXT) {
            const XrEventDataPerfSettingsEXT* new_value = reinterpret_cast<const XrEventDataPerfSettingsEXT*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_MAIN_SESSION_VISIBILITY_CHANGED_EXTX) {
            const XrEventDataMainSessionVisibilityChangedEXTX* new_value = reinterpret_cast<const XrEventDataMainSessionVisibilityChangedEXTX*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_DISPLAY_REFRESH_RATE_CHANGED_FB) {
            const XrEventDataDisplayRefreshRateChangedFB* new_value = reinterpret_cast<const XrEventDataDisplayRefreshRateChangedFB*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_VIVE_TRACKER_CONNECTED_HTCX) {
            const XrEventDataViveTrackerConnectedHTCX* new_value = reinterpret_cast<const XrEventDataViveTrackerConnectedHTCX*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_SPATIAL_ANCHOR_CREATE_COMPLETE_FB) {
            const XrEventDataSpatialAnchorCreateCompleteFB* new_value = reinterpret_cast<const XrEventDataSpatialAnchorCreateCompleteFB*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_SPACE_SET_STATUS_COMPLETE_FB) {
            const XrEventDataSpaceSetStatusCompleteFB* new_value = reinterpret_cast<const XrEventDataSpaceSetStatusCompleteFB*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_PASSTHROUGH_STATE_CHANGED_FB) {
            const XrEventDataPassthroughStateChangedFB* new_value = reinterpret_cast<const XrEventDataPassthroughStateChangedFB*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_MARKER_TRACKING_UPDATE_VARJO) {
            const XrEventDataMarkerTrackingUpdateVARJO* new_value = reinterpret_cast<const XrEventDataMarkerTrackingUpdateVARJO*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_LOCALIZATION_CHANGED_ML) {
            const XrEventDataLocalizationChangedML* new_value = reinterpret_cast<const XrEventDataLocalizationChangedML*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_SPACE_QUERY_RESULTS_AVAILABLE_FB) {
            const XrEventDataSpaceQueryResultsAvailableFB* new_value = reinterpret_cast<const XrEventDataSpaceQueryResultsAvailableFB*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_SPACE_QUERY_COMPLETE_FB) {
            const XrEventDataSpaceQueryCompleteFB* new_value = reinterpret_cast<const XrEventDataSpaceQueryCompleteFB*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_SPACE_SAVE_COMPLETE_FB) {
            const XrEventDataSpaceSaveCompleteFB* new_value = reinterpret_cast<const XrEventDataSpaceSaveCompleteFB*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_SPACE_ERASE_COMPLETE_FB) {
            const XrEventDataSpaceEraseCompleteFB* new_value = reinterpret_cast<const XrEventDataSpaceEraseCompleteFB*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_SPACE_SHARE_COMPLETE_FB) {
            const XrEventDataSpaceShareCompleteFB* new_value = reinterpret_cast<const XrEventDataSpaceShareCompleteFB*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_SCENE_CAPTURE_COMPLETE_FB) {
            const XrEventDataSceneCaptureCompleteFB* new_value = reinterpret_cast<const XrEventDataSceneCaptureCompleteFB*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_VIRTUAL_KEYBOARD_COMMIT_TEXT_META) {
            const XrEventDataVirtualKeyboardCommitTextMETA* new_value = reinterpret_cast<const XrEventDataVirtualKeyboardCommitTextMETA*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_VIRTUAL_KEYBOARD_BACKSPACE_META) {
            const XrEventDataVirtualKeyboardBackspaceMETA* new_value = reinterpret_cast<const XrEventDataVirtualKeyboardBackspaceMETA*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_VIRTUAL_KEYBOARD_ENTER_META) {
            const XrEventDataVirtualKeyboardEnterMETA* new_value = reinterpret_cast<const XrEventDataVirtualKeyboardEnterMETA*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_VIRTUAL_KEYBOARD_SHOWN_META) {
            const XrEventDataVirtualKeyboardShownMETA* new_value = reinterpret_cast<const XrEventDataVirtualKeyboardShownMETA*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_VIRTUAL_KEYBOARD_HIDDEN_META) {
            const XrEventDataVirtualKeyboardHiddenMETA* new_value = reinterpret_cast<const XrEventDataVirtualKeyboardHiddenMETA*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_SPACE_LIST_SAVE_COMPLETE_FB) {
            const XrEventDataSpaceListSaveCompleteFB* new_value = reinterpret_cast<const XrEventDataSpaceListSaveCompleteFB*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_SPACE_DISCOVERY_RESULTS_AVAILABLE_META) {
            const XrEventDataSpaceDiscoveryResultsAvailableMETA* new_value = reinterpret_cast<const XrEventDataSpaceDiscoveryResultsAvailableMETA*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_SPACE_DISCOVERY_COMPLETE_META) {
            const XrEventDataSpaceDiscoveryCompleteMETA* new_value = reinterpret_cast<const XrEventDataSpaceDiscoveryCompleteMETA*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_SPACES_SAVE_RESULT_META) {
            const XrEventDataSpacesSaveResultMETA* new_value = reinterpret_cast<const XrEventDataSpacesSaveResultMETA*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_SPACES_ERASE_RESULT_META) {
            const XrEventDataSpacesEraseResultMETA* new_value = reinterpret_cast<const XrEventDataSpacesEraseResultMETA*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_PASSTHROUGH_LAYER_RESUMED_META) {
            const XrEventDataPassthroughLayerResumedMETA* new_value = reinterpret_cast<const XrEventDataPassthroughLayerResumedMETA*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_SHARE_SPACES_COMPLETE_META) {
            const XrEventDataShareSpacesCompleteMETA* new_value = reinterpret_cast<const XrEventDataShareSpacesCompleteMETA*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_INTERACTION_RENDER_MODELS_CHANGED_EXT) {
            const XrEventDataInteractionRenderModelsChangedEXT* new_value = reinterpret_cast<const XrEventDataInteractionRenderModelsChangedEXT*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_SENSE_DATA_PROVIDER_STATE_CHANGED_BD) {
            const XrEventDataSenseDataProviderStateChangedBD* new_value = reinterpret_cast<const XrEventDataSenseDataProviderStateChangedBD*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_SENSE_DATA_UPDATED_BD) {
            const XrEventDataSenseDataUpdatedBD* new_value = reinterpret_cast<const XrEventDataSenseDataUpdatedBD*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_USER_PRESENCE_CHANGED_EXT) {
            const XrEventDataUserPresenceChangedEXT* new_value = reinterpret_cast<const XrEventDataUserPresenceChangedEXT*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_HEADSET_FIT_CHANGED_ML) {
            const XrEventDataHeadsetFitChangedML* new_value = reinterpret_cast<const XrEventDataHeadsetFitChangedML*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_EYE_CALIBRATION_CHANGED_ML) {
            const XrEventDataEyeCalibrationChangedML* new_value = reinterpret_cast<const XrEventDataEyeCalibrationChangedML*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_START_COLOCATION_ADVERTISEMENT_COMPLETE_META) {
            const XrEventDataStartColocationAdvertisementCompleteMETA* new_value = reinterpret_cast<const XrEventDataStartColocationAdvertisementCompleteMETA*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_STOP_COLOCATION_ADVERTISEMENT_COMPLETE_META) {
            const XrEventDataStopColocationAdvertisementCompleteMETA* new_value = reinterpret_cast<const XrEventDataStopColocationAdvertisementCompleteMETA*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_COLOCATION_ADVERTISEMENT_COMPLETE_META) {
            const XrEventDataColocationAdvertisementCompleteMETA* new_value = reinterpret_cast<const XrEventDataColocationAdvertisementCompleteMETA*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_START_COLOCATION_DISCOVERY_COMPLETE_META) {
            const XrEventDataStartColocationDiscoveryCompleteMETA* new_value = reinterpret_cast<const XrEventDataStartColocationDiscoveryCompleteMETA*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_COLOCATION_DISCOVERY_RESULT_META) {
            const XrEventDataColocationDiscoveryResultMETA* new_value = reinterpret_cast<const XrEventDataColocationDiscoveryResultMETA*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_COLOCATION_DISCOVERY_COMPLETE_META) {
            const XrEventDataColocationDiscoveryCompleteMETA* new_value = reinterpret_cast<const XrEventDataColocationDiscoveryCompleteMETA*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_STOP_COLOCATION_DISCOVERY_COMPLETE_META) {
            const XrEventDataStopColocationDiscoveryCompleteMETA* new_value = reinterpret_cast<const XrEventDataStopColocationDiscoveryCompleteMETA*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_EVENT_DATA_SPATIAL_DISCOVERY_RECOMMENDED_EXT) {
            const XrEventDataSpatialDiscoveryRecommendedEXT* new_value = reinterpret_cast<const XrEventDataSpatialDiscoveryRecommendedEXT*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        // Fallback path - Just output generic information about the base struct
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEventDataEventsLost* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string losteventcount_prefix = prefix;
        losteventcount_prefix += "lostEventCount";
        std::ostringstream oss_lostEventCount;
        oss_lostEventCount << "0x" << std::hex << (value->lostEventCount);
        contents.emplace_back("uint32_t", losteventcount_prefix, oss_lostEventCount.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEventDataInstanceLossPending* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string losstime_prefix = prefix;
        losstime_prefix += "lossTime";
        contents.emplace_back("XrTime", losstime_prefix, std::to_string(value->lossTime));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEventDataSessionStateChanged* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string session_prefix = prefix;
        session_prefix += "session";
        std::ostringstream oss_session;
        oss_session << std::hex << reinterpret_cast<const void*>(value->session);
        contents.emplace_back("XrSession", session_prefix, oss_session.str());
        std::string state_prefix = prefix;
        state_prefix += "state";
        contents.emplace_back("XrSessionState", state_prefix, std::to_string(value->state));
        std::string time_prefix = prefix;
        time_prefix += "time";
        contents.emplace_back("XrTime", time_prefix, std::to_string(value->time));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEventDataReferenceSpaceChangePending* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string session_prefix = prefix;
        session_prefix += "session";
        std::ostringstream oss_session;
        oss_session << std::hex << reinterpret_cast<const void*>(value->session);
        contents.emplace_back("XrSession", session_prefix, oss_session.str());
        std::string referencespacetype_prefix = prefix;
        referencespacetype_prefix += "referenceSpaceType";
        contents.emplace_back("XrReferenceSpaceType", referencespacetype_prefix, std::to_string(value->referenceSpaceType));
        std::string changetime_prefix = prefix;
        changetime_prefix += "changeTime";
        contents.emplace_back("XrTime", changetime_prefix, std::to_string(value->changeTime));
        std::string posevalid_prefix = prefix;
        posevalid_prefix += "poseValid";
        std::ostringstream oss_poseValid;
        oss_poseValid << "0x" << std::hex << (value->poseValid);
        contents.emplace_back("XrBool32", posevalid_prefix, oss_poseValid.str());
        std::string poseinpreviousspace_prefix = prefix;
        poseinpreviousspace_prefix += "poseInPreviousSpace";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->poseInPreviousSpace, poseinpreviousspace_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEventDataInteractionProfileChanged* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string session_prefix = prefix;
        session_prefix += "session";
        std::ostringstream oss_session;
        oss_session << std::hex << reinterpret_cast<const void*>(value->session);
        contents.emplace_back("XrSession", session_prefix, oss_session.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrHapticVibration* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string duration_prefix = prefix;
        duration_prefix += "duration";
        contents.emplace_back("XrDuration", duration_prefix, std::to_string(value->duration));
        std::string frequency_prefix = prefix;
        frequency_prefix += "frequency";
        std::ostringstream oss_frequency;
        oss_frequency << std::setprecision(32) << (value->frequency);
        contents.emplace_back("float", frequency_prefix, oss_frequency.str());
        std::string amplitude_prefix = prefix;
        amplitude_prefix += "amplitude";
        std::ostringstream oss_amplitude;
        oss_amplitude << std::setprecision(32) << (value->amplitude);
        contents.emplace_back("float", amplitude_prefix, oss_amplitude.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrOffset2Df* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string x_prefix = prefix;
        x_prefix += "x";
        std::ostringstream oss_x;
        oss_x << std::setprecision(32) << (value->x);
        contents.emplace_back("float", x_prefix, oss_x.str());
        std::string y_prefix = prefix;
        y_prefix += "y";
        std::ostringstream oss_y;
        oss_y << std::setprecision(32) << (value->y);
        contents.emplace_back("float", y_prefix, oss_y.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrRect2Df* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string offset_prefix = prefix;
        offset_prefix += "offset";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->offset, offset_prefix, "XrOffset2Df", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string extent_prefix = prefix;
        extent_prefix += "extent";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->extent, extent_prefix, "XrExtent2Df", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrVector4f* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string x_prefix = prefix;
        x_prefix += "x";
        std::ostringstream oss_x;
        oss_x << std::setprecision(32) << (value->x);
        contents.emplace_back("float", x_prefix, oss_x.str());
        std::string y_prefix = prefix;
        y_prefix += "y";
        std::ostringstream oss_y;
        oss_y << std::setprecision(32) << (value->y);
        contents.emplace_back("float", y_prefix, oss_y.str());
        std::string z_prefix = prefix;
        z_prefix += "z";
        std::ostringstream oss_z;
        oss_z << std::setprecision(32) << (value->z);
        contents.emplace_back("float", z_prefix, oss_z.str());
        std::string w_prefix = prefix;
        w_prefix += "w";
        std::ostringstream oss_w;
        oss_w << std::setprecision(32) << (value->w);
        contents.emplace_back("float", w_prefix, oss_w.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrColor4f* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string r_prefix = prefix;
        r_prefix += "r";
        std::ostringstream oss_r;
        oss_r << std::setprecision(32) << (value->r);
        contents.emplace_back("float", r_prefix, oss_r.str());
        std::string g_prefix = prefix;
        g_prefix += "g";
        std::ostringstream oss_g;
        oss_g << std::setprecision(32) << (value->g);
        contents.emplace_back("float", g_prefix, oss_g.str());
        std::string b_prefix = prefix;
        b_prefix += "b";
        std::ostringstream oss_b;
        oss_b << std::setprecision(32) << (value->b);
        contents.emplace_back("float", b_prefix, oss_b.str());
        std::string a_prefix = prefix;
        a_prefix += "a";
        std::ostringstream oss_a;
        oss_a << std::setprecision(32) << (value->a);
        contents.emplace_back("float", a_prefix, oss_a.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrColor3f* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string r_prefix = prefix;
        r_prefix += "r";
        std::ostringstream oss_r;
        oss_r << std::setprecision(32) << (value->r);
        contents.emplace_back("float", r_prefix, oss_r.str());
        std::string g_prefix = prefix;
        g_prefix += "g";
        std::ostringstream oss_g;
        oss_g << std::setprecision(32) << (value->g);
        contents.emplace_back("float", g_prefix, oss_g.str());
        std::string b_prefix = prefix;
        b_prefix += "b";
        std::ostringstream oss_b;
        oss_b << std::setprecision(32) << (value->b);
        contents.emplace_back("float", b_prefix, oss_b.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrExtent3Df* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string width_prefix = prefix;
        width_prefix += "width";
        std::ostringstream oss_width;
        oss_width << std::setprecision(32) << (value->width);
        contents.emplace_back("float", width_prefix, oss_width.str());
        std::string height_prefix = prefix;
        height_prefix += "height";
        std::ostringstream oss_height;
        oss_height << std::setprecision(32) << (value->height);
        contents.emplace_back("float", height_prefix, oss_height.str());
        std::string depth_prefix = prefix;
        depth_prefix += "depth";
        std::ostringstream oss_depth;
        oss_depth << std::setprecision(32) << (value->depth);
        contents.emplace_back("float", depth_prefix, oss_depth.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpheref* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string center_prefix = prefix;
        center_prefix += "center";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->center, center_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string radius_prefix = prefix;
        radius_prefix += "radius";
        std::ostringstream oss_radius;
        oss_radius << std::setprecision(32) << (value->radius);
        contents.emplace_back("float", radius_prefix, oss_radius.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrBoxf* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string center_prefix = prefix;
        center_prefix += "center";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->center, center_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string extents_prefix = prefix;
        extents_prefix += "extents";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->extents, extents_prefix, "XrExtent3Df", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrFrustumf* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string pose_prefix = prefix;
        pose_prefix += "pose";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->pose, pose_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string fov_prefix = prefix;
        fov_prefix += "fov";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->fov, fov_prefix, "XrFovf", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string nearz_prefix = prefix;
        nearz_prefix += "nearZ";
        std::ostringstream oss_nearZ;
        oss_nearZ << std::setprecision(32) << (value->nearZ);
        contents.emplace_back("float", nearz_prefix, oss_nearZ.str());
        std::string farz_prefix = prefix;
        farz_prefix += "farZ";
        std::ostringstream oss_farZ;
        oss_farZ << std::setprecision(32) << (value->farZ);
        contents.emplace_back("float", farz_prefix, oss_farZ.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrUuid* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string data_prefix = prefix;
        data_prefix += "data";
        std::ostringstream oss_data_array;
        oss_data_array << "0x" << std::hex << (value->data);
        contents.emplace_back("uint8_t*", data_prefix, oss_data_array.str());
        for (uint32_t value_data_inc = 0; value_data_inc < XR_UUID_SIZE; ++value_data_inc) {
            std::string data_array_prefix = data_prefix;
            data_array_prefix += "[";
            data_array_prefix += std::to_string(value_data_inc);
            data_array_prefix += "]";
            std::ostringstream oss_data;
            oss_data << "0x" << std::hex << (value->data[value_data_inc]);
            contents.emplace_back("uint8_t", data_array_prefix, oss_data.str());
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpacesLocateInfo* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string basespace_prefix = prefix;
        basespace_prefix += "baseSpace";
        std::ostringstream oss_baseSpace;
        oss_baseSpace << std::hex << reinterpret_cast<const void*>(value->baseSpace);
        contents.emplace_back("XrSpace", basespace_prefix, oss_baseSpace.str());
        std::string time_prefix = prefix;
        time_prefix += "time";
        contents.emplace_back("XrTime", time_prefix, std::to_string(value->time));
        std::string spacecount_prefix = prefix;
        spacecount_prefix += "spaceCount";
        std::ostringstream oss_spaceCount;
        oss_spaceCount << "0x" << std::hex << (value->spaceCount);
        contents.emplace_back("uint32_t", spacecount_prefix, oss_spaceCount.str());
        std::string spaces_prefix = prefix;
        spaces_prefix += "spaces";
        std::ostringstream oss_spaces_array;
        oss_spaces_array << std::hex << reinterpret_cast<const void*>(value->spaces);
        contents.emplace_back("const XrSpace*", spaces_prefix, oss_spaces_array.str());
        for (uint32_t value_spaces_inc = 0; value_spaces_inc < value->spaceCount; ++value_spaces_inc) {
            std::string spaces_array_prefix = spaces_prefix;
            spaces_array_prefix += "[";
            spaces_array_prefix += std::to_string(value_spaces_inc);
            spaces_array_prefix += "]";
            std::ostringstream oss_spaces;
            oss_spaces << std::hex << reinterpret_cast<const void*>(value->spaces[value_spaces_inc]);
            contents.emplace_back("const XrSpace*", spaces_array_prefix, oss_spaces.str());
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpaceLocationData* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string locationflags_prefix = prefix;
        locationflags_prefix += "locationFlags";
        contents.emplace_back("XrSpaceLocationFlags", locationflags_prefix, std::to_string(value->locationFlags));
        std::string pose_prefix = prefix;
        pose_prefix += "pose";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->pose, pose_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpaceLocations* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string locationcount_prefix = prefix;
        locationcount_prefix += "locationCount";
        std::ostringstream oss_locationCount;
        oss_locationCount << "0x" << std::hex << (value->locationCount);
        contents.emplace_back("uint32_t", locationcount_prefix, oss_locationCount.str());
        std::string locations_prefix = prefix;
        locations_prefix += "locations";
        std::ostringstream oss_locations;
        oss_locations << std::hex << reinterpret_cast<const void*>(value->locations);
        contents.emplace_back("XrSpaceLocationData*", locations_prefix, oss_locations.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpaceVelocityData* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string velocityflags_prefix = prefix;
        velocityflags_prefix += "velocityFlags";
        contents.emplace_back("XrSpaceVelocityFlags", velocityflags_prefix, std::to_string(value->velocityFlags));
        std::string linearvelocity_prefix = prefix;
        linearvelocity_prefix += "linearVelocity";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->linearVelocity, linearvelocity_prefix, "XrVector3f", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string angularvelocity_prefix = prefix;
        angularvelocity_prefix += "angularVelocity";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->angularVelocity, angularvelocity_prefix, "XrVector3f", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpaceVelocities* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string velocitycount_prefix = prefix;
        velocitycount_prefix += "velocityCount";
        std::ostringstream oss_velocityCount;
        oss_velocityCount << "0x" << std::hex << (value->velocityCount);
        contents.emplace_back("uint32_t", velocitycount_prefix, oss_velocityCount.str());
        std::string velocities_prefix = prefix;
        velocities_prefix += "velocities";
        std::ostringstream oss_velocities;
        oss_velocities << std::hex << reinterpret_cast<const void*>(value->velocities);
        contents.emplace_back("XrSpaceVelocityData*", velocities_prefix, oss_velocities.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrCompositionLayerCubeKHR* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string layerflags_prefix = prefix;
        layerflags_prefix += "layerFlags";
        contents.emplace_back("XrCompositionLayerFlags", layerflags_prefix, std::to_string(value->layerFlags));
        std::string space_prefix = prefix;
        space_prefix += "space";
        std::ostringstream oss_space;
        oss_space << std::hex << reinterpret_cast<const void*>(value->space);
        contents.emplace_back("XrSpace", space_prefix, oss_space.str());
        std::string eyevisibility_prefix = prefix;
        eyevisibility_prefix += "eyeVisibility";
        contents.emplace_back("XrEyeVisibility", eyevisibility_prefix, std::to_string(value->eyeVisibility));
        std::string swapchain_prefix = prefix;
        swapchain_prefix += "swapchain";
        std::ostringstream oss_swapchain;
        oss_swapchain << std::hex << reinterpret_cast<const void*>(value->swapchain);
        contents.emplace_back("XrSwapchain", swapchain_prefix, oss_swapchain.str());
        std::string imagearrayindex_prefix = prefix;
        imagearrayindex_prefix += "imageArrayIndex";
        std::ostringstream oss_imageArrayIndex;
        oss_imageArrayIndex << "0x" << std::hex << (value->imageArrayIndex);
        contents.emplace_back("uint32_t", imagearrayindex_prefix, oss_imageArrayIndex.str());
        std::string orientation_prefix = prefix;
        orientation_prefix += "orientation";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->orientation, orientation_prefix, "XrQuaternionf", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

#if defined(XR_USE_PLATFORM_ANDROID)
bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrInstanceCreateInfoAndroidKHR* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string applicationvm_prefix = prefix;
        applicationvm_prefix += "applicationVM";
        std::ostringstream oss_applicationVM;
        oss_applicationVM << std::hex << reinterpret_cast<const void*>(value->applicationVM);
        contents.emplace_back("void* XR_MAY_ALIAS", applicationvm_prefix, oss_applicationVM.str());
        std::string applicationactivity_prefix = prefix;
        applicationactivity_prefix += "applicationActivity";
        std::ostringstream oss_applicationActivity;
        oss_applicationActivity << std::hex << reinterpret_cast<const void*>(value->applicationActivity);
        contents.emplace_back("void* XR_MAY_ALIAS", applicationactivity_prefix, oss_applicationActivity.str());
        return true;
    } catch(...) {
    }
    return false;
}
#endif // defined(XR_USE_PLATFORM_ANDROID)

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrCompositionLayerDepthInfoKHR* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string subimage_prefix = prefix;
        subimage_prefix += "subImage";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->subImage, subimage_prefix, "XrSwapchainSubImage", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string mindepth_prefix = prefix;
        mindepth_prefix += "minDepth";
        std::ostringstream oss_minDepth;
        oss_minDepth << std::setprecision(32) << (value->minDepth);
        contents.emplace_back("float", mindepth_prefix, oss_minDepth.str());
        std::string maxdepth_prefix = prefix;
        maxdepth_prefix += "maxDepth";
        std::ostringstream oss_maxDepth;
        oss_maxDepth << std::setprecision(32) << (value->maxDepth);
        contents.emplace_back("float", maxdepth_prefix, oss_maxDepth.str());
        std::string nearz_prefix = prefix;
        nearz_prefix += "nearZ";
        std::ostringstream oss_nearZ;
        oss_nearZ << std::setprecision(32) << (value->nearZ);
        contents.emplace_back("float", nearz_prefix, oss_nearZ.str());
        std::string farz_prefix = prefix;
        farz_prefix += "farZ";
        std::ostringstream oss_farZ;
        oss_farZ << std::setprecision(32) << (value->farZ);
        contents.emplace_back("float", farz_prefix, oss_farZ.str());
        return true;
    } catch(...) {
    }
    return false;
}

#if defined(XR_USE_GRAPHICS_API_VULKAN)
bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrVulkanSwapchainFormatListCreateInfoKHR* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string viewformatcount_prefix = prefix;
        viewformatcount_prefix += "viewFormatCount";
        std::ostringstream oss_viewFormatCount;
        oss_viewFormatCount << "0x" << std::hex << (value->viewFormatCount);
        contents.emplace_back("uint32_t", viewformatcount_prefix, oss_viewFormatCount.str());
        std::string viewformats_prefix = prefix;
        viewformats_prefix += "viewFormats";
        std::ostringstream oss_viewFormats_array;
        oss_viewFormats_array << std::hex << reinterpret_cast<const void*>(value->viewFormats);
        contents.emplace_back("const VkFormat*", viewformats_prefix, oss_viewFormats_array.str());
        for (uint32_t value_viewformats_inc = 0; value_viewformats_inc < value->viewFormatCount; ++value_viewformats_inc) {
            std::string viewformats_array_prefix = viewformats_prefix;
            viewformats_array_prefix += "[";
            viewformats_array_prefix += std::to_string(value_viewformats_inc);
            viewformats_array_prefix += "]";
            std::ostringstream oss_viewFormats;
            oss_viewFormats << std::hex << reinterpret_cast<const void*>(value->viewFormats[value_viewformats_inc]);
            contents.emplace_back("const VkFormat*", viewformats_array_prefix, oss_viewFormats.str());
        }
        return true;
    } catch(...) {
    }
    return false;
}
#endif // defined(XR_USE_GRAPHICS_API_VULKAN)

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrCompositionLayerCylinderKHR* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string layerflags_prefix = prefix;
        layerflags_prefix += "layerFlags";
        contents.emplace_back("XrCompositionLayerFlags", layerflags_prefix, std::to_string(value->layerFlags));
        std::string space_prefix = prefix;
        space_prefix += "space";
        std::ostringstream oss_space;
        oss_space << std::hex << reinterpret_cast<const void*>(value->space);
        contents.emplace_back("XrSpace", space_prefix, oss_space.str());
        std::string eyevisibility_prefix = prefix;
        eyevisibility_prefix += "eyeVisibility";
        contents.emplace_back("XrEyeVisibility", eyevisibility_prefix, std::to_string(value->eyeVisibility));
        std::string subimage_prefix = prefix;
        subimage_prefix += "subImage";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->subImage, subimage_prefix, "XrSwapchainSubImage", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string pose_prefix = prefix;
        pose_prefix += "pose";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->pose, pose_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string radius_prefix = prefix;
        radius_prefix += "radius";
        std::ostringstream oss_radius;
        oss_radius << std::setprecision(32) << (value->radius);
        contents.emplace_back("float", radius_prefix, oss_radius.str());
        std::string centralangle_prefix = prefix;
        centralangle_prefix += "centralAngle";
        std::ostringstream oss_centralAngle;
        oss_centralAngle << std::setprecision(32) << (value->centralAngle);
        contents.emplace_back("float", centralangle_prefix, oss_centralAngle.str());
        std::string aspectratio_prefix = prefix;
        aspectratio_prefix += "aspectRatio";
        std::ostringstream oss_aspectRatio;
        oss_aspectRatio << std::setprecision(32) << (value->aspectRatio);
        contents.emplace_back("float", aspectratio_prefix, oss_aspectRatio.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrCompositionLayerEquirectKHR* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string layerflags_prefix = prefix;
        layerflags_prefix += "layerFlags";
        contents.emplace_back("XrCompositionLayerFlags", layerflags_prefix, std::to_string(value->layerFlags));
        std::string space_prefix = prefix;
        space_prefix += "space";
        std::ostringstream oss_space;
        oss_space << std::hex << reinterpret_cast<const void*>(value->space);
        contents.emplace_back("XrSpace", space_prefix, oss_space.str());
        std::string eyevisibility_prefix = prefix;
        eyevisibility_prefix += "eyeVisibility";
        contents.emplace_back("XrEyeVisibility", eyevisibility_prefix, std::to_string(value->eyeVisibility));
        std::string subimage_prefix = prefix;
        subimage_prefix += "subImage";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->subImage, subimage_prefix, "XrSwapchainSubImage", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string pose_prefix = prefix;
        pose_prefix += "pose";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->pose, pose_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string radius_prefix = prefix;
        radius_prefix += "radius";
        std::ostringstream oss_radius;
        oss_radius << std::setprecision(32) << (value->radius);
        contents.emplace_back("float", radius_prefix, oss_radius.str());
        std::string scale_prefix = prefix;
        scale_prefix += "scale";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->scale, scale_prefix, "XrVector2f", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string bias_prefix = prefix;
        bias_prefix += "bias";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->bias, bias_prefix, "XrVector2f", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

#if defined(XR_USE_GRAPHICS_API_OPENGL) && defined(XR_USE_PLATFORM_WIN32)
bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrGraphicsBindingOpenGLWin32KHR* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string hdc_prefix = prefix;
        hdc_prefix += "hDC";
        std::ostringstream oss_hDC;
        oss_hDC << std::hex << reinterpret_cast<const void*>(value->hDC);
        contents.emplace_back("HDC", hdc_prefix, oss_hDC.str());
        std::string hglrc_prefix = prefix;
        hglrc_prefix += "hGLRC";
        std::ostringstream oss_hGLRC;
        oss_hGLRC << std::hex << reinterpret_cast<const void*>(value->hGLRC);
        contents.emplace_back("HGLRC", hglrc_prefix, oss_hGLRC.str());
        return true;
    } catch(...) {
    }
    return false;
}
#endif // defined(XR_USE_GRAPHICS_API_OPENGL) && defined(XR_USE_PLATFORM_WIN32)

#if defined(XR_USE_GRAPHICS_API_OPENGL) && defined(XR_USE_PLATFORM_XLIB)
bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrGraphicsBindingOpenGLXlibKHR* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string xdisplay_prefix = prefix;
        xdisplay_prefix += "xDisplay";
        std::ostringstream oss_xDisplay;
        oss_xDisplay << std::hex << reinterpret_cast<const void*>(value->xDisplay);
        contents.emplace_back("Display*", xdisplay_prefix, oss_xDisplay.str());
        std::string visualid_prefix = prefix;
        visualid_prefix += "visualid";
        std::ostringstream oss_visualid;
        oss_visualid << "0x" << std::hex << (value->visualid);
        contents.emplace_back("uint32_t", visualid_prefix, oss_visualid.str());
        std::string glxfbconfig_prefix = prefix;
        glxfbconfig_prefix += "glxFBConfig";
        std::ostringstream oss_glxFBConfig;
        oss_glxFBConfig << std::hex << reinterpret_cast<const void*>(value->glxFBConfig);
        contents.emplace_back("GLXFBConfig", glxfbconfig_prefix, oss_glxFBConfig.str());
        std::string glxdrawable_prefix = prefix;
        glxdrawable_prefix += "glxDrawable";
        std::ostringstream oss_glxDrawable;
        oss_glxDrawable << std::hex << reinterpret_cast<const void*>(value->glxDrawable);
        contents.emplace_back("GLXDrawable", glxdrawable_prefix, oss_glxDrawable.str());
        std::string glxcontext_prefix = prefix;
        glxcontext_prefix += "glxContext";
        std::ostringstream oss_glxContext;
        oss_glxContext << std::hex << reinterpret_cast<const void*>(value->glxContext);
        contents.emplace_back("GLXContext", glxcontext_prefix, oss_glxContext.str());
        return true;
    } catch(...) {
    }
    return false;
}
#endif // defined(XR_USE_GRAPHICS_API_OPENGL) && defined(XR_USE_PLATFORM_XLIB)

#if defined(XR_USE_GRAPHICS_API_OPENGL) && defined(XR_USE_PLATFORM_XCB)
bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrGraphicsBindingOpenGLXcbKHR* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string connection_prefix = prefix;
        connection_prefix += "connection";
        std::ostringstream oss_connection;
        oss_connection << std::hex << reinterpret_cast<const void*>(value->connection);
        contents.emplace_back("xcb_connection_t*", connection_prefix, oss_connection.str());
        std::string screennumber_prefix = prefix;
        screennumber_prefix += "screenNumber";
        std::ostringstream oss_screenNumber;
        oss_screenNumber << "0x" << std::hex << (value->screenNumber);
        contents.emplace_back("uint32_t", screennumber_prefix, oss_screenNumber.str());
        std::string fbconfigid_prefix = prefix;
        fbconfigid_prefix += "fbconfigid";
        std::ostringstream oss_fbconfigid;
        oss_fbconfigid << std::hex << reinterpret_cast<const void*>(value->fbconfigid);
        contents.emplace_back("xcb_glx_fbconfig_t", fbconfigid_prefix, oss_fbconfigid.str());
        std::string visualid_prefix = prefix;
        visualid_prefix += "visualid";
        std::ostringstream oss_visualid;
        oss_visualid << std::hex << reinterpret_cast<const void*>(value->visualid);
        contents.emplace_back("xcb_visualid_t", visualid_prefix, oss_visualid.str());
        std::string glxdrawable_prefix = prefix;
        glxdrawable_prefix += "glxDrawable";
        std::ostringstream oss_glxDrawable;
        oss_glxDrawable << std::hex << reinterpret_cast<const void*>(value->glxDrawable);
        contents.emplace_back("xcb_glx_drawable_t", glxdrawable_prefix, oss_glxDrawable.str());
        std::string glxcontext_prefix = prefix;
        glxcontext_prefix += "glxContext";
        std::ostringstream oss_glxContext;
        oss_glxContext << std::hex << reinterpret_cast<const void*>(value->glxContext);
        contents.emplace_back("xcb_glx_context_t", glxcontext_prefix, oss_glxContext.str());
        return true;
    } catch(...) {
    }
    return false;
}
#endif // defined(XR_USE_GRAPHICS_API_OPENGL) && defined(XR_USE_PLATFORM_XCB)

#if defined(XR_USE_GRAPHICS_API_OPENGL) && defined(XR_USE_PLATFORM_WAYLAND)
bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrGraphicsBindingOpenGLWaylandKHR* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string display_prefix = prefix;
        display_prefix += "display";
        std::ostringstream oss_display;
        oss_display << std::hex << reinterpret_cast<const void*>(value->display);
        contents.emplace_back("struct wl_display*", display_prefix, oss_display.str());
        return true;
    } catch(...) {
    }
    return false;
}
#endif // defined(XR_USE_GRAPHICS_API_OPENGL) && defined(XR_USE_PLATFORM_WAYLAND)

#if defined(XR_USE_GRAPHICS_API_OPENGL)
bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSwapchainImageOpenGLKHR* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string image_prefix = prefix;
        image_prefix += "image";
        std::ostringstream oss_image;
        oss_image << "0x" << std::hex << (value->image);
        contents.emplace_back("uint32_t", image_prefix, oss_image.str());
        return true;
    } catch(...) {
    }
    return false;
}
#endif // defined(XR_USE_GRAPHICS_API_OPENGL)

#if defined(XR_USE_GRAPHICS_API_OPENGL)
bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrGraphicsRequirementsOpenGLKHR* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string minapiversionsupported_prefix = prefix;
        minapiversionsupported_prefix += "minApiVersionSupported";
        std::ostringstream oss_minApiVersionSupported;
        oss_minApiVersionSupported << "0x" << std::hex << (value->minApiVersionSupported);
        contents.emplace_back("XrVersion", minapiversionsupported_prefix, oss_minApiVersionSupported.str());
        std::string maxapiversionsupported_prefix = prefix;
        maxapiversionsupported_prefix += "maxApiVersionSupported";
        std::ostringstream oss_maxApiVersionSupported;
        oss_maxApiVersionSupported << "0x" << std::hex << (value->maxApiVersionSupported);
        contents.emplace_back("XrVersion", maxapiversionsupported_prefix, oss_maxApiVersionSupported.str());
        return true;
    } catch(...) {
    }
    return false;
}
#endif // defined(XR_USE_GRAPHICS_API_OPENGL)

#if defined(XR_USE_GRAPHICS_API_OPENGL_ES) && defined(XR_USE_PLATFORM_ANDROID)
bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrGraphicsBindingOpenGLESAndroidKHR* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string display_prefix = prefix;
        display_prefix += "display";
        std::ostringstream oss_display;
        oss_display << std::hex << reinterpret_cast<const void*>(value->display);
        contents.emplace_back("EGLDisplay", display_prefix, oss_display.str());
        std::string config_prefix = prefix;
        config_prefix += "config";
        std::ostringstream oss_config;
        oss_config << std::hex << reinterpret_cast<const void*>(value->config);
        contents.emplace_back("EGLConfig", config_prefix, oss_config.str());
        std::string context_prefix = prefix;
        context_prefix += "context";
        std::ostringstream oss_context;
        oss_context << std::hex << reinterpret_cast<const void*>(value->context);
        contents.emplace_back("EGLContext", context_prefix, oss_context.str());
        return true;
    } catch(...) {
    }
    return false;
}
#endif // defined(XR_USE_GRAPHICS_API_OPENGL_ES) && defined(XR_USE_PLATFORM_ANDROID)

#if defined(XR_USE_GRAPHICS_API_OPENGL_ES)
bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSwapchainImageOpenGLESKHR* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string image_prefix = prefix;
        image_prefix += "image";
        std::ostringstream oss_image;
        oss_image << "0x" << std::hex << (value->image);
        contents.emplace_back("uint32_t", image_prefix, oss_image.str());
        return true;
    } catch(...) {
    }
    return false;
}
#endif // defined(XR_USE_GRAPHICS_API_OPENGL_ES)

#if defined(XR_USE_GRAPHICS_API_OPENGL_ES)
bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrGraphicsRequirementsOpenGLESKHR* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string minapiversionsupported_prefix = prefix;
        minapiversionsupported_prefix += "minApiVersionSupported";
        std::ostringstream oss_minApiVersionSupported;
        oss_minApiVersionSupported << "0x" << std::hex << (value->minApiVersionSupported);
        contents.emplace_back("XrVersion", minapiversionsupported_prefix, oss_minApiVersionSupported.str());
        std::string maxapiversionsupported_prefix = prefix;
        maxapiversionsupported_prefix += "maxApiVersionSupported";
        std::ostringstream oss_maxApiVersionSupported;
        oss_maxApiVersionSupported << "0x" << std::hex << (value->maxApiVersionSupported);
        contents.emplace_back("XrVersion", maxapiversionsupported_prefix, oss_maxApiVersionSupported.str());
        return true;
    } catch(...) {
    }
    return false;
}
#endif // defined(XR_USE_GRAPHICS_API_OPENGL_ES)

#if defined(XR_USE_GRAPHICS_API_VULKAN)
bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrGraphicsBindingVulkanKHR* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string instance_prefix = prefix;
        instance_prefix += "instance";
        std::ostringstream oss_instance;
        oss_instance << std::hex << reinterpret_cast<const void*>(value->instance);
        contents.emplace_back("VkInstance", instance_prefix, oss_instance.str());
        std::string physicaldevice_prefix = prefix;
        physicaldevice_prefix += "physicalDevice";
        std::ostringstream oss_physicalDevice;
        oss_physicalDevice << std::hex << reinterpret_cast<const void*>(value->physicalDevice);
        contents.emplace_back("VkPhysicalDevice", physicaldevice_prefix, oss_physicalDevice.str());
        std::string device_prefix = prefix;
        device_prefix += "device";
        std::ostringstream oss_device;
        oss_device << std::hex << reinterpret_cast<const void*>(value->device);
        contents.emplace_back("VkDevice", device_prefix, oss_device.str());
        std::string queuefamilyindex_prefix = prefix;
        queuefamilyindex_prefix += "queueFamilyIndex";
        std::ostringstream oss_queueFamilyIndex;
        oss_queueFamilyIndex << "0x" << std::hex << (value->queueFamilyIndex);
        contents.emplace_back("uint32_t", queuefamilyindex_prefix, oss_queueFamilyIndex.str());
        std::string queueindex_prefix = prefix;
        queueindex_prefix += "queueIndex";
        std::ostringstream oss_queueIndex;
        oss_queueIndex << "0x" << std::hex << (value->queueIndex);
        contents.emplace_back("uint32_t", queueindex_prefix, oss_queueIndex.str());
        return true;
    } catch(...) {
    }
    return false;
}
#endif // defined(XR_USE_GRAPHICS_API_VULKAN)

#if defined(XR_USE_GRAPHICS_API_VULKAN)
bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSwapchainImageVulkanKHR* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string image_prefix = prefix;
        image_prefix += "image";
        std::ostringstream oss_image;
        oss_image << std::hex << reinterpret_cast<const void*>(value->image);
        contents.emplace_back("VkImage", image_prefix, oss_image.str());
        return true;
    } catch(...) {
    }
    return false;
}
#endif // defined(XR_USE_GRAPHICS_API_VULKAN)

#if defined(XR_USE_GRAPHICS_API_VULKAN)
bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrGraphicsRequirementsVulkanKHR* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string minapiversionsupported_prefix = prefix;
        minapiversionsupported_prefix += "minApiVersionSupported";
        std::ostringstream oss_minApiVersionSupported;
        oss_minApiVersionSupported << "0x" << std::hex << (value->minApiVersionSupported);
        contents.emplace_back("XrVersion", minapiversionsupported_prefix, oss_minApiVersionSupported.str());
        std::string maxapiversionsupported_prefix = prefix;
        maxapiversionsupported_prefix += "maxApiVersionSupported";
        std::ostringstream oss_maxApiVersionSupported;
        oss_maxApiVersionSupported << "0x" << std::hex << (value->maxApiVersionSupported);
        contents.emplace_back("XrVersion", maxapiversionsupported_prefix, oss_maxApiVersionSupported.str());
        return true;
    } catch(...) {
    }
    return false;
}
#endif // defined(XR_USE_GRAPHICS_API_VULKAN)

#if defined(XR_USE_GRAPHICS_API_D3D11)
bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrGraphicsBindingD3D11KHR* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string device_prefix = prefix;
        device_prefix += "device";
        std::ostringstream oss_device;
        oss_device << std::hex << reinterpret_cast<const void*>(value->device);
        contents.emplace_back("ID3D11Device*", device_prefix, oss_device.str());
        return true;
    } catch(...) {
    }
    return false;
}
#endif // defined(XR_USE_GRAPHICS_API_D3D11)

#if defined(XR_USE_GRAPHICS_API_D3D11)
bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSwapchainImageD3D11KHR* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string texture_prefix = prefix;
        texture_prefix += "texture";
        std::ostringstream oss_texture;
        oss_texture << std::hex << reinterpret_cast<const void*>(value->texture);
        contents.emplace_back("ID3D11Texture2D*", texture_prefix, oss_texture.str());
        return true;
    } catch(...) {
    }
    return false;
}
#endif // defined(XR_USE_GRAPHICS_API_D3D11)

#if defined(XR_USE_GRAPHICS_API_D3D11)
bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrGraphicsRequirementsD3D11KHR* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string adapterluid_prefix = prefix;
        adapterluid_prefix += "adapterLuid";
        {
            std::ostringstream oss_adapterLuid;
            oss_adapterLuid << std::uppercase;
            oss_adapterLuid.width(8);
            oss_adapterLuid << std::hex << value->adapterLuid.LowPart;
            oss_adapterLuid << std::hex << value->adapterLuid.HighPart;
            oss_adapterLuid << std::nouppercase;
            contents.emplace_back("LUID", adapterluid_prefix, oss_adapterLuid.str());
        }
        std::string minfeaturelevel_prefix = prefix;
        minfeaturelevel_prefix += "minFeatureLevel";
        contents.emplace_back("D3D_FEATURE_LEVEL", minfeaturelevel_prefix, std::to_string(value->minFeatureLevel));
        return true;
    } catch(...) {
    }
    return false;
}
#endif // defined(XR_USE_GRAPHICS_API_D3D11)

#if defined(XR_USE_GRAPHICS_API_D3D12)
bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrGraphicsBindingD3D12KHR* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string device_prefix = prefix;
        device_prefix += "device";
        std::ostringstream oss_device;
        oss_device << std::hex << reinterpret_cast<const void*>(value->device);
        contents.emplace_back("ID3D12Device*", device_prefix, oss_device.str());
        std::string queue_prefix = prefix;
        queue_prefix += "queue";
        std::ostringstream oss_queue;
        oss_queue << std::hex << reinterpret_cast<const void*>(value->queue);
        contents.emplace_back("ID3D12CommandQueue*", queue_prefix, oss_queue.str());
        return true;
    } catch(...) {
    }
    return false;
}
#endif // defined(XR_USE_GRAPHICS_API_D3D12)

#if defined(XR_USE_GRAPHICS_API_D3D12)
bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSwapchainImageD3D12KHR* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string texture_prefix = prefix;
        texture_prefix += "texture";
        std::ostringstream oss_texture;
        oss_texture << std::hex << reinterpret_cast<const void*>(value->texture);
        contents.emplace_back("ID3D12Resource*", texture_prefix, oss_texture.str());
        return true;
    } catch(...) {
    }
    return false;
}
#endif // defined(XR_USE_GRAPHICS_API_D3D12)

#if defined(XR_USE_GRAPHICS_API_D3D12)
bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrGraphicsRequirementsD3D12KHR* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string adapterluid_prefix = prefix;
        adapterluid_prefix += "adapterLuid";
        {
            std::ostringstream oss_adapterLuid;
            oss_adapterLuid << std::uppercase;
            oss_adapterLuid.width(8);
            oss_adapterLuid << std::hex << value->adapterLuid.LowPart;
            oss_adapterLuid << std::hex << value->adapterLuid.HighPart;
            oss_adapterLuid << std::nouppercase;
            contents.emplace_back("LUID", adapterluid_prefix, oss_adapterLuid.str());
        }
        std::string minfeaturelevel_prefix = prefix;
        minfeaturelevel_prefix += "minFeatureLevel";
        contents.emplace_back("D3D_FEATURE_LEVEL", minfeaturelevel_prefix, std::to_string(value->minFeatureLevel));
        return true;
    } catch(...) {
    }
    return false;
}
#endif // defined(XR_USE_GRAPHICS_API_D3D12)

#if defined(XR_USE_GRAPHICS_API_METAL)
bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrGraphicsBindingMetalKHR* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string commandqueue_prefix = prefix;
        commandqueue_prefix += "commandQueue";
        std::ostringstream oss_commandQueue;
        oss_commandQueue << std::hex << reinterpret_cast<const void*>(value->commandQueue);
        contents.emplace_back("void* XR_MAY_ALIAS", commandqueue_prefix, oss_commandQueue.str());
        return true;
    } catch(...) {
    }
    return false;
}
#endif // defined(XR_USE_GRAPHICS_API_METAL)

#if defined(XR_USE_GRAPHICS_API_METAL)
bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSwapchainImageMetalKHR* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string texture_prefix = prefix;
        texture_prefix += "texture";
        std::ostringstream oss_texture;
        oss_texture << std::hex << reinterpret_cast<const void*>(value->texture);
        contents.emplace_back("void* XR_MAY_ALIAS", texture_prefix, oss_texture.str());
        return true;
    } catch(...) {
    }
    return false;
}
#endif // defined(XR_USE_GRAPHICS_API_METAL)

#if defined(XR_USE_GRAPHICS_API_METAL)
bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrGraphicsRequirementsMetalKHR* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string metaldevice_prefix = prefix;
        metaldevice_prefix += "metalDevice";
        std::ostringstream oss_metalDevice;
        oss_metalDevice << std::hex << reinterpret_cast<const void*>(value->metalDevice);
        contents.emplace_back("void* XR_MAY_ALIAS", metaldevice_prefix, oss_metalDevice.str());
        return true;
    } catch(...) {
    }
    return false;
}
#endif // defined(XR_USE_GRAPHICS_API_METAL)

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrVisibilityMaskKHR* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string vertexcapacityinput_prefix = prefix;
        vertexcapacityinput_prefix += "vertexCapacityInput";
        std::ostringstream oss_vertexCapacityInput;
        oss_vertexCapacityInput << "0x" << std::hex << (value->vertexCapacityInput);
        contents.emplace_back("uint32_t", vertexcapacityinput_prefix, oss_vertexCapacityInput.str());
        std::string vertexcountoutput_prefix = prefix;
        vertexcountoutput_prefix += "vertexCountOutput";
        std::ostringstream oss_vertexCountOutput;
        oss_vertexCountOutput << "0x" << std::hex << (value->vertexCountOutput);
        contents.emplace_back("uint32_t", vertexcountoutput_prefix, oss_vertexCountOutput.str());
        std::string vertices_prefix = prefix;
        vertices_prefix += "vertices";
        std::ostringstream oss_vertices;
        oss_vertices << std::hex << reinterpret_cast<const void*>(value->vertices);
        contents.emplace_back("XrVector2f*", vertices_prefix, oss_vertices.str());
        std::string indexcapacityinput_prefix = prefix;
        indexcapacityinput_prefix += "indexCapacityInput";
        std::ostringstream oss_indexCapacityInput;
        oss_indexCapacityInput << "0x" << std::hex << (value->indexCapacityInput);
        contents.emplace_back("uint32_t", indexcapacityinput_prefix, oss_indexCapacityInput.str());
        std::string indexcountoutput_prefix = prefix;
        indexcountoutput_prefix += "indexCountOutput";
        std::ostringstream oss_indexCountOutput;
        oss_indexCountOutput << "0x" << std::hex << (value->indexCountOutput);
        contents.emplace_back("uint32_t", indexcountoutput_prefix, oss_indexCountOutput.str());
        std::string indices_prefix = prefix;
        indices_prefix += "indices";
        std::ostringstream oss_indices;
        oss_indices << "0x" << std::hex << (value->indices);
        contents.emplace_back("uint32_t*", indices_prefix, oss_indices.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEventDataVisibilityMaskChangedKHR* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string session_prefix = prefix;
        session_prefix += "session";
        std::ostringstream oss_session;
        oss_session << std::hex << reinterpret_cast<const void*>(value->session);
        contents.emplace_back("XrSession", session_prefix, oss_session.str());
        std::string viewconfigurationtype_prefix = prefix;
        viewconfigurationtype_prefix += "viewConfigurationType";
        contents.emplace_back("XrViewConfigurationType", viewconfigurationtype_prefix, std::to_string(value->viewConfigurationType));
        std::string viewindex_prefix = prefix;
        viewindex_prefix += "viewIndex";
        std::ostringstream oss_viewIndex;
        oss_viewIndex << "0x" << std::hex << (value->viewIndex);
        contents.emplace_back("uint32_t", viewindex_prefix, oss_viewIndex.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrCompositionLayerColorScaleBiasKHR* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string colorscale_prefix = prefix;
        colorscale_prefix += "colorScale";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->colorScale, colorscale_prefix, "XrColor4f", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string colorbias_prefix = prefix;
        colorbias_prefix += "colorBias";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->colorBias, colorbias_prefix, "XrColor4f", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrLoaderInitInfoBaseHeaderKHR* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
#if defined(XR_USE_PLATFORM_ANDROID)
        if (value->type == XR_TYPE_LOADER_INIT_INFO_ANDROID_KHR) {
            const XrLoaderInitInfoAndroidKHR* new_value = reinterpret_cast<const XrLoaderInitInfoAndroidKHR*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
#endif // defined(XR_USE_PLATFORM_ANDROID)
        if (value->type == XR_TYPE_LOADER_INIT_INFO_PROPERTIES_EXT) {
            const XrLoaderInitInfoPropertiesEXT* new_value = reinterpret_cast<const XrLoaderInitInfoPropertiesEXT*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        // Fallback path - Just output generic information about the base struct
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

#if defined(XR_USE_PLATFORM_ANDROID)
bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrLoaderInitInfoAndroidKHR* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string applicationvm_prefix = prefix;
        applicationvm_prefix += "applicationVM";
        std::ostringstream oss_applicationVM;
        oss_applicationVM << std::hex << reinterpret_cast<const void*>(value->applicationVM);
        contents.emplace_back("void* XR_MAY_ALIAS", applicationvm_prefix, oss_applicationVM.str());
        std::string applicationcontext_prefix = prefix;
        applicationcontext_prefix += "applicationContext";
        std::ostringstream oss_applicationContext;
        oss_applicationContext << std::hex << reinterpret_cast<const void*>(value->applicationContext);
        contents.emplace_back("void* XR_MAY_ALIAS", applicationcontext_prefix, oss_applicationContext.str());
        return true;
    } catch(...) {
    }
    return false;
}
#endif // defined(XR_USE_PLATFORM_ANDROID)

#if defined(XR_USE_GRAPHICS_API_VULKAN)
bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrVulkanInstanceCreateInfoKHR* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string systemid_prefix = prefix;
        systemid_prefix += "systemId";
        contents.emplace_back("XrSystemId", systemid_prefix, std::to_string(value->systemId));
        std::string createflags_prefix = prefix;
        createflags_prefix += "createFlags";
        contents.emplace_back("XrVulkanInstanceCreateFlagsKHR", createflags_prefix, std::to_string(value->createFlags));
        std::string pfngetinstanceprocaddr_prefix = prefix;
        pfngetinstanceprocaddr_prefix += "pfnGetInstanceProcAddr";
        std::ostringstream oss_pfnGetInstanceProcAddr;
        oss_pfnGetInstanceProcAddr << std::hex << reinterpret_cast<const void*>(value->pfnGetInstanceProcAddr);
        contents.emplace_back("PFN_vkGetInstanceProcAddr", pfngetinstanceprocaddr_prefix, oss_pfnGetInstanceProcAddr.str());
        std::string vulkancreateinfo_prefix = prefix;
        vulkancreateinfo_prefix += "vulkanCreateInfo";
        std::ostringstream oss_vulkanCreateInfo;
        oss_vulkanCreateInfo << std::hex << reinterpret_cast<const void*>(value->vulkanCreateInfo);
        contents.emplace_back("const VkInstanceCreateInfo*", vulkancreateinfo_prefix, oss_vulkanCreateInfo.str());
        std::string vulkanallocator_prefix = prefix;
        vulkanallocator_prefix += "vulkanAllocator";
        if (nullptr == value->vulkanAllocator) {
            std::ostringstream oss_vulkanAllocator;
            oss_vulkanAllocator << std::hex << reinterpret_cast<const void*>(value->vulkanAllocator);
            contents.emplace_back("const VkAllocationCallbacks*", vulkanallocator_prefix, oss_vulkanAllocator.str());
        } else {
            std::ostringstream oss_vulkanAllocator;
            oss_vulkanAllocator << std::hex << reinterpret_cast<const void*>(value->vulkanAllocator);
            contents.emplace_back("const VkAllocationCallbacks*", vulkanallocator_prefix, oss_vulkanAllocator.str());
        }
        return true;
    } catch(...) {
    }
    return false;
}
#endif // defined(XR_USE_GRAPHICS_API_VULKAN)

#if defined(XR_USE_GRAPHICS_API_VULKAN)
bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrVulkanDeviceCreateInfoKHR* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string systemid_prefix = prefix;
        systemid_prefix += "systemId";
        contents.emplace_back("XrSystemId", systemid_prefix, std::to_string(value->systemId));
        std::string createflags_prefix = prefix;
        createflags_prefix += "createFlags";
        contents.emplace_back("XrVulkanDeviceCreateFlagsKHR", createflags_prefix, std::to_string(value->createFlags));
        std::string pfngetinstanceprocaddr_prefix = prefix;
        pfngetinstanceprocaddr_prefix += "pfnGetInstanceProcAddr";
        std::ostringstream oss_pfnGetInstanceProcAddr;
        oss_pfnGetInstanceProcAddr << std::hex << reinterpret_cast<const void*>(value->pfnGetInstanceProcAddr);
        contents.emplace_back("PFN_vkGetInstanceProcAddr", pfngetinstanceprocaddr_prefix, oss_pfnGetInstanceProcAddr.str());
        std::string vulkanphysicaldevice_prefix = prefix;
        vulkanphysicaldevice_prefix += "vulkanPhysicalDevice";
        std::ostringstream oss_vulkanPhysicalDevice;
        oss_vulkanPhysicalDevice << std::hex << reinterpret_cast<const void*>(value->vulkanPhysicalDevice);
        contents.emplace_back("VkPhysicalDevice", vulkanphysicaldevice_prefix, oss_vulkanPhysicalDevice.str());
        std::string vulkancreateinfo_prefix = prefix;
        vulkancreateinfo_prefix += "vulkanCreateInfo";
        std::ostringstream oss_vulkanCreateInfo;
        oss_vulkanCreateInfo << std::hex << reinterpret_cast<const void*>(value->vulkanCreateInfo);
        contents.emplace_back("const VkDeviceCreateInfo*", vulkancreateinfo_prefix, oss_vulkanCreateInfo.str());
        std::string vulkanallocator_prefix = prefix;
        vulkanallocator_prefix += "vulkanAllocator";
        if (nullptr == value->vulkanAllocator) {
            std::ostringstream oss_vulkanAllocator;
            oss_vulkanAllocator << std::hex << reinterpret_cast<const void*>(value->vulkanAllocator);
            contents.emplace_back("const VkAllocationCallbacks*", vulkanallocator_prefix, oss_vulkanAllocator.str());
        } else {
            std::ostringstream oss_vulkanAllocator;
            oss_vulkanAllocator << std::hex << reinterpret_cast<const void*>(value->vulkanAllocator);
            contents.emplace_back("const VkAllocationCallbacks*", vulkanallocator_prefix, oss_vulkanAllocator.str());
        }
        return true;
    } catch(...) {
    }
    return false;
}
#endif // defined(XR_USE_GRAPHICS_API_VULKAN)

#if defined(XR_USE_GRAPHICS_API_VULKAN)
bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrVulkanGraphicsDeviceGetInfoKHR* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string systemid_prefix = prefix;
        systemid_prefix += "systemId";
        contents.emplace_back("XrSystemId", systemid_prefix, std::to_string(value->systemId));
        std::string vulkaninstance_prefix = prefix;
        vulkaninstance_prefix += "vulkanInstance";
        std::ostringstream oss_vulkanInstance;
        oss_vulkanInstance << std::hex << reinterpret_cast<const void*>(value->vulkanInstance);
        contents.emplace_back("VkInstance", vulkaninstance_prefix, oss_vulkanInstance.str());
        return true;
    } catch(...) {
    }
    return false;
}
#endif // defined(XR_USE_GRAPHICS_API_VULKAN)

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrCompositionLayerEquirect2KHR* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string layerflags_prefix = prefix;
        layerflags_prefix += "layerFlags";
        contents.emplace_back("XrCompositionLayerFlags", layerflags_prefix, std::to_string(value->layerFlags));
        std::string space_prefix = prefix;
        space_prefix += "space";
        std::ostringstream oss_space;
        oss_space << std::hex << reinterpret_cast<const void*>(value->space);
        contents.emplace_back("XrSpace", space_prefix, oss_space.str());
        std::string eyevisibility_prefix = prefix;
        eyevisibility_prefix += "eyeVisibility";
        contents.emplace_back("XrEyeVisibility", eyevisibility_prefix, std::to_string(value->eyeVisibility));
        std::string subimage_prefix = prefix;
        subimage_prefix += "subImage";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->subImage, subimage_prefix, "XrSwapchainSubImage", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string pose_prefix = prefix;
        pose_prefix += "pose";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->pose, pose_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string radius_prefix = prefix;
        radius_prefix += "radius";
        std::ostringstream oss_radius;
        oss_radius << std::setprecision(32) << (value->radius);
        contents.emplace_back("float", radius_prefix, oss_radius.str());
        std::string centralhorizontalangle_prefix = prefix;
        centralhorizontalangle_prefix += "centralHorizontalAngle";
        std::ostringstream oss_centralHorizontalAngle;
        oss_centralHorizontalAngle << std::setprecision(32) << (value->centralHorizontalAngle);
        contents.emplace_back("float", centralhorizontalangle_prefix, oss_centralHorizontalAngle.str());
        std::string upperverticalangle_prefix = prefix;
        upperverticalangle_prefix += "upperVerticalAngle";
        std::ostringstream oss_upperVerticalAngle;
        oss_upperVerticalAngle << std::setprecision(32) << (value->upperVerticalAngle);
        contents.emplace_back("float", upperverticalangle_prefix, oss_upperVerticalAngle.str());
        std::string lowerverticalangle_prefix = prefix;
        lowerverticalangle_prefix += "lowerVerticalAngle";
        std::ostringstream oss_lowerVerticalAngle;
        oss_lowerVerticalAngle << std::setprecision(32) << (value->lowerVerticalAngle);
        contents.emplace_back("float", lowerverticalangle_prefix, oss_lowerVerticalAngle.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrBindingModificationBaseHeaderKHR* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        if (value->type == XR_TYPE_INTERACTION_PROFILE_DPAD_BINDING_EXT) {
            const XrInteractionProfileDpadBindingEXT* new_value = reinterpret_cast<const XrInteractionProfileDpadBindingEXT*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_INTERACTION_PROFILE_ANALOG_THRESHOLD_VALVE) {
            const XrInteractionProfileAnalogThresholdVALVE* new_value = reinterpret_cast<const XrInteractionProfileAnalogThresholdVALVE*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        // Fallback path - Just output generic information about the base struct
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrBindingModificationsKHR* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string bindingmodificationcount_prefix = prefix;
        bindingmodificationcount_prefix += "bindingModificationCount";
        std::ostringstream oss_bindingModificationCount;
        oss_bindingModificationCount << "0x" << std::hex << (value->bindingModificationCount);
        contents.emplace_back("uint32_t", bindingmodificationcount_prefix, oss_bindingModificationCount.str());
        std::string bindingmodifications_prefix = prefix;
        bindingmodifications_prefix += "bindingModifications";
        std::ostringstream oss_bindingModifications_array;
        oss_bindingModifications_array << std::hex << reinterpret_cast<const void*>(value->bindingModifications);
        contents.emplace_back("const XrBindingModificationBaseHeaderKHR* const*", bindingmodifications_prefix, oss_bindingModifications_array.str());
        for (uint32_t value_bindingmodifications_inc = 0; value_bindingmodifications_inc < value->bindingModificationCount; ++value_bindingmodifications_inc) {
            std::string bindingmodifications_array_prefix = bindingmodifications_prefix;
            bindingmodifications_array_prefix += "[";
            bindingmodifications_array_prefix += std::to_string(value_bindingmodifications_inc);
            bindingmodifications_array_prefix += "]";
            if (nullptr == value->bindingModifications[value_bindingmodifications_inc]) {
                std::ostringstream oss_bindingModifications;
                oss_bindingModifications << std::hex << reinterpret_cast<const void*>(value->bindingModifications[value_bindingmodifications_inc]);
                contents.emplace_back("const XrBindingModificationBaseHeaderKHR* const*", bindingmodifications_array_prefix, oss_bindingModifications.str());
            } else if (!ApiDumpOutputXrStruct(gen_dispatch_table, value->bindingModifications[value_bindingmodifications_inc], bindingmodifications_array_prefix, "const XrBindingModificationBaseHeaderKHR* const*", true, contents)) {
                throw std::invalid_argument("Invalid Operation");
            }
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEventDataPerfSettingsEXT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string domain_prefix = prefix;
        domain_prefix += "domain";
        contents.emplace_back("XrPerfSettingsDomainEXT", domain_prefix, std::to_string(value->domain));
        std::string subdomain_prefix = prefix;
        subdomain_prefix += "subDomain";
        contents.emplace_back("XrPerfSettingsSubDomainEXT", subdomain_prefix, std::to_string(value->subDomain));
        std::string fromlevel_prefix = prefix;
        fromlevel_prefix += "fromLevel";
        contents.emplace_back("XrPerfSettingsNotificationLevelEXT", fromlevel_prefix, std::to_string(value->fromLevel));
        std::string tolevel_prefix = prefix;
        tolevel_prefix += "toLevel";
        contents.emplace_back("XrPerfSettingsNotificationLevelEXT", tolevel_prefix, std::to_string(value->toLevel));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrDebugUtilsObjectNameInfoEXT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string objecttype_prefix = prefix;
        objecttype_prefix += "objectType";
        contents.emplace_back("XrObjectType", objecttype_prefix, std::to_string(value->objectType));
        std::string objecthandle_prefix = prefix;
        objecthandle_prefix += "objectHandle";
        std::ostringstream oss_objectHandle;
        oss_objectHandle << "0x" << std::hex << (value->objectHandle);
        contents.emplace_back("uint64_t", objecthandle_prefix, oss_objectHandle.str());
        std::string objectname_prefix = prefix;
        objectname_prefix += "objectName";
        if (nullptr == value->objectName) {
            std::ostringstream oss_objectName_array;
            oss_objectName_array << std::hex << reinterpret_cast<const void*>(value->objectName);
            contents.emplace_back("const char*", objectname_prefix, oss_objectName_array.str());
        } else {
            std::ostringstream oss_objectName;
            oss_objectName << std::hex << reinterpret_cast<const void*>(*value->objectName);
            contents.emplace_back("const char*", objectname_prefix, oss_objectName.str());
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrDebugUtilsLabelEXT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string labelname_prefix = prefix;
        labelname_prefix += "labelName";
        std::ostringstream oss_labelName;
        oss_labelName << std::hex << reinterpret_cast<const void*>(*value->labelName);
        contents.emplace_back("const char*", labelname_prefix, oss_labelName.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrDebugUtilsMessengerCallbackDataEXT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string messageid_prefix = prefix;
        messageid_prefix += "messageId";
        if (nullptr == value->messageId) {
            std::ostringstream oss_messageId_array;
            oss_messageId_array << std::hex << reinterpret_cast<const void*>(value->messageId);
            contents.emplace_back("const char*", messageid_prefix, oss_messageId_array.str());
        } else {
            std::ostringstream oss_messageId;
            oss_messageId << std::hex << reinterpret_cast<const void*>(*value->messageId);
            contents.emplace_back("const char*", messageid_prefix, oss_messageId.str());
        }
        std::string functionname_prefix = prefix;
        functionname_prefix += "functionName";
        if (nullptr == value->functionName) {
            std::ostringstream oss_functionName_array;
            oss_functionName_array << std::hex << reinterpret_cast<const void*>(value->functionName);
            contents.emplace_back("const char*", functionname_prefix, oss_functionName_array.str());
        } else {
            std::ostringstream oss_functionName;
            oss_functionName << std::hex << reinterpret_cast<const void*>(*value->functionName);
            contents.emplace_back("const char*", functionname_prefix, oss_functionName.str());
        }
        std::string message_prefix = prefix;
        message_prefix += "message";
        std::ostringstream oss_message;
        oss_message << std::hex << reinterpret_cast<const void*>(*value->message);
        contents.emplace_back("const char*", message_prefix, oss_message.str());
        std::string objectcount_prefix = prefix;
        objectcount_prefix += "objectCount";
        std::ostringstream oss_objectCount;
        oss_objectCount << "0x" << std::hex << (value->objectCount);
        contents.emplace_back("uint32_t", objectcount_prefix, oss_objectCount.str());
        std::string objects_prefix = prefix;
        objects_prefix += "objects";
        std::ostringstream oss_objects;
        oss_objects << std::hex << reinterpret_cast<const void*>(value->objects);
        contents.emplace_back("XrDebugUtilsObjectNameInfoEXT*", objects_prefix, oss_objects.str());
        std::string sessionlabelcount_prefix = prefix;
        sessionlabelcount_prefix += "sessionLabelCount";
        std::ostringstream oss_sessionLabelCount;
        oss_sessionLabelCount << "0x" << std::hex << (value->sessionLabelCount);
        contents.emplace_back("uint32_t", sessionlabelcount_prefix, oss_sessionLabelCount.str());
        std::string sessionlabels_prefix = prefix;
        sessionlabels_prefix += "sessionLabels";
        std::ostringstream oss_sessionLabels;
        oss_sessionLabels << std::hex << reinterpret_cast<const void*>(value->sessionLabels);
        contents.emplace_back("XrDebugUtilsLabelEXT*", sessionlabels_prefix, oss_sessionLabels.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrDebugUtilsMessengerCreateInfoEXT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string messageseverities_prefix = prefix;
        messageseverities_prefix += "messageSeverities";
        contents.emplace_back("XrDebugUtilsMessageSeverityFlagsEXT", messageseverities_prefix, std::to_string(value->messageSeverities));
        std::string messagetypes_prefix = prefix;
        messagetypes_prefix += "messageTypes";
        contents.emplace_back("XrDebugUtilsMessageTypeFlagsEXT", messagetypes_prefix, std::to_string(value->messageTypes));
        std::string usercallback_prefix = prefix;
        usercallback_prefix += "userCallback";
        std::ostringstream oss_userCallback;
        oss_userCallback << std::hex << reinterpret_cast<const void*>(value->userCallback);
        contents.emplace_back("PFN_xrDebugUtilsMessengerCallbackEXT", usercallback_prefix, oss_userCallback.str());
        std::string userdata_prefix = prefix;
        userdata_prefix += "userData";
        std::ostringstream oss_userData;
        oss_userData << std::hex << reinterpret_cast<const void*>(value->userData);
        contents.emplace_back("void* XR_MAY_ALIAS", userdata_prefix, oss_userData.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSystemEyeGazeInteractionPropertiesEXT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string supportseyegazeinteraction_prefix = prefix;
        supportseyegazeinteraction_prefix += "supportsEyeGazeInteraction";
        std::ostringstream oss_supportsEyeGazeInteraction;
        oss_supportsEyeGazeInteraction << "0x" << std::hex << (value->supportsEyeGazeInteraction);
        contents.emplace_back("XrBool32", supportseyegazeinteraction_prefix, oss_supportsEyeGazeInteraction.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEyeGazeSampleTimeEXT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string time_prefix = prefix;
        time_prefix += "time";
        contents.emplace_back("XrTime", time_prefix, std::to_string(value->time));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSessionCreateInfoOverlayEXTX* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string createflags_prefix = prefix;
        createflags_prefix += "createFlags";
        contents.emplace_back("XrOverlaySessionCreateFlagsEXTX", createflags_prefix, std::to_string(value->createFlags));
        std::string sessionlayersplacement_prefix = prefix;
        sessionlayersplacement_prefix += "sessionLayersPlacement";
        std::ostringstream oss_sessionLayersPlacement;
        oss_sessionLayersPlacement << "0x" << std::hex << (value->sessionLayersPlacement);
        contents.emplace_back("uint32_t", sessionlayersplacement_prefix, oss_sessionLayersPlacement.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEventDataMainSessionVisibilityChangedEXTX* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string visible_prefix = prefix;
        visible_prefix += "visible";
        std::ostringstream oss_visible;
        oss_visible << "0x" << std::hex << (value->visible);
        contents.emplace_back("XrBool32", visible_prefix, oss_visible.str());
        std::string flags_prefix = prefix;
        flags_prefix += "flags";
        contents.emplace_back("XrOverlayMainSessionFlagsEXTX", flags_prefix, std::to_string(value->flags));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpatialAnchorCreateInfoMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string space_prefix = prefix;
        space_prefix += "space";
        std::ostringstream oss_space;
        oss_space << std::hex << reinterpret_cast<const void*>(value->space);
        contents.emplace_back("XrSpace", space_prefix, oss_space.str());
        std::string pose_prefix = prefix;
        pose_prefix += "pose";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->pose, pose_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string time_prefix = prefix;
        time_prefix += "time";
        contents.emplace_back("XrTime", time_prefix, std::to_string(value->time));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpatialAnchorSpaceCreateInfoMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string anchor_prefix = prefix;
        anchor_prefix += "anchor";
        std::ostringstream oss_anchor;
        oss_anchor << std::hex << reinterpret_cast<const void*>(value->anchor);
        contents.emplace_back("XrSpatialAnchorMSFT", anchor_prefix, oss_anchor.str());
        std::string poseinanchorspace_prefix = prefix;
        poseinanchorspace_prefix += "poseInAnchorSpace";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->poseInAnchorSpace, poseinanchorspace_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrCompositionLayerImageLayoutFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string flags_prefix = prefix;
        flags_prefix += "flags";
        contents.emplace_back("XrCompositionLayerImageLayoutFlagsFB", flags_prefix, std::to_string(value->flags));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrCompositionLayerAlphaBlendFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string srcfactorcolor_prefix = prefix;
        srcfactorcolor_prefix += "srcFactorColor";
        contents.emplace_back("XrBlendFactorFB", srcfactorcolor_prefix, std::to_string(value->srcFactorColor));
        std::string dstfactorcolor_prefix = prefix;
        dstfactorcolor_prefix += "dstFactorColor";
        contents.emplace_back("XrBlendFactorFB", dstfactorcolor_prefix, std::to_string(value->dstFactorColor));
        std::string srcfactoralpha_prefix = prefix;
        srcfactoralpha_prefix += "srcFactorAlpha";
        contents.emplace_back("XrBlendFactorFB", srcfactoralpha_prefix, std::to_string(value->srcFactorAlpha));
        std::string dstfactoralpha_prefix = prefix;
        dstfactoralpha_prefix += "dstFactorAlpha";
        contents.emplace_back("XrBlendFactorFB", dstfactoralpha_prefix, std::to_string(value->dstFactorAlpha));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrViewConfigurationDepthRangeEXT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string recommendednearz_prefix = prefix;
        recommendednearz_prefix += "recommendedNearZ";
        std::ostringstream oss_recommendedNearZ;
        oss_recommendedNearZ << std::setprecision(32) << (value->recommendedNearZ);
        contents.emplace_back("float", recommendednearz_prefix, oss_recommendedNearZ.str());
        std::string minnearz_prefix = prefix;
        minnearz_prefix += "minNearZ";
        std::ostringstream oss_minNearZ;
        oss_minNearZ << std::setprecision(32) << (value->minNearZ);
        contents.emplace_back("float", minnearz_prefix, oss_minNearZ.str());
        std::string recommendedfarz_prefix = prefix;
        recommendedfarz_prefix += "recommendedFarZ";
        std::ostringstream oss_recommendedFarZ;
        oss_recommendedFarZ << std::setprecision(32) << (value->recommendedFarZ);
        contents.emplace_back("float", recommendedfarz_prefix, oss_recommendedFarZ.str());
        std::string maxfarz_prefix = prefix;
        maxfarz_prefix += "maxFarZ";
        std::ostringstream oss_maxFarZ;
        oss_maxFarZ << std::setprecision(32) << (value->maxFarZ);
        contents.emplace_back("float", maxfarz_prefix, oss_maxFarZ.str());
        return true;
    } catch(...) {
    }
    return false;
}

#if defined(XR_USE_PLATFORM_EGL)
bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrGraphicsBindingEGLMNDX* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string getprocaddress_prefix = prefix;
        getprocaddress_prefix += "getProcAddress";
        std::ostringstream oss_getProcAddress;
        oss_getProcAddress << std::hex << reinterpret_cast<const void*>(value->getProcAddress);
        contents.emplace_back("PFN_xrEglGetProcAddressMNDX", getprocaddress_prefix, oss_getProcAddress.str());
        std::string display_prefix = prefix;
        display_prefix += "display";
        std::ostringstream oss_display;
        oss_display << std::hex << reinterpret_cast<const void*>(value->display);
        contents.emplace_back("EGLDisplay", display_prefix, oss_display.str());
        std::string config_prefix = prefix;
        config_prefix += "config";
        std::ostringstream oss_config;
        oss_config << std::hex << reinterpret_cast<const void*>(value->config);
        contents.emplace_back("EGLConfig", config_prefix, oss_config.str());
        std::string context_prefix = prefix;
        context_prefix += "context";
        std::ostringstream oss_context;
        oss_context << std::hex << reinterpret_cast<const void*>(value->context);
        contents.emplace_back("EGLContext", context_prefix, oss_context.str());
        return true;
    } catch(...) {
    }
    return false;
}
#endif // defined(XR_USE_PLATFORM_EGL)

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpatialGraphNodeSpaceCreateInfoMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string nodetype_prefix = prefix;
        nodetype_prefix += "nodeType";
        contents.emplace_back("XrSpatialGraphNodeTypeMSFT", nodetype_prefix, std::to_string(value->nodeType));
        std::string nodeid_prefix = prefix;
        nodeid_prefix += "nodeId";
        std::ostringstream oss_nodeId_array;
        oss_nodeId_array << "0x" << std::hex << (value->nodeId);
        contents.emplace_back("uint8_t*", nodeid_prefix, oss_nodeId_array.str());
        for (uint32_t value_nodeid_inc = 0; value_nodeid_inc < XR_GUID_SIZE_MSFT; ++value_nodeid_inc) {
            std::string nodeid_array_prefix = nodeid_prefix;
            nodeid_array_prefix += "[";
            nodeid_array_prefix += std::to_string(value_nodeid_inc);
            nodeid_array_prefix += "]";
            std::ostringstream oss_nodeId;
            oss_nodeId << "0x" << std::hex << (value->nodeId[value_nodeid_inc]);
            contents.emplace_back("uint8_t", nodeid_array_prefix, oss_nodeId.str());
        }
        std::string pose_prefix = prefix;
        pose_prefix += "pose";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->pose, pose_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpatialGraphStaticNodeBindingCreateInfoMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string space_prefix = prefix;
        space_prefix += "space";
        std::ostringstream oss_space;
        oss_space << std::hex << reinterpret_cast<const void*>(value->space);
        contents.emplace_back("XrSpace", space_prefix, oss_space.str());
        std::string poseinspace_prefix = prefix;
        poseinspace_prefix += "poseInSpace";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->poseInSpace, poseinspace_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string time_prefix = prefix;
        time_prefix += "time";
        contents.emplace_back("XrTime", time_prefix, std::to_string(value->time));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpatialGraphNodeBindingPropertiesGetInfoMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpatialGraphNodeBindingPropertiesMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string nodeid_prefix = prefix;
        nodeid_prefix += "nodeId";
        std::ostringstream oss_nodeId_array;
        oss_nodeId_array << "0x" << std::hex << (value->nodeId);
        contents.emplace_back("uint8_t*", nodeid_prefix, oss_nodeId_array.str());
        for (uint32_t value_nodeid_inc = 0; value_nodeid_inc < XR_GUID_SIZE_MSFT; ++value_nodeid_inc) {
            std::string nodeid_array_prefix = nodeid_prefix;
            nodeid_array_prefix += "[";
            nodeid_array_prefix += std::to_string(value_nodeid_inc);
            nodeid_array_prefix += "]";
            std::ostringstream oss_nodeId;
            oss_nodeId << "0x" << std::hex << (value->nodeId[value_nodeid_inc]);
            contents.emplace_back("uint8_t", nodeid_array_prefix, oss_nodeId.str());
        }
        std::string poseinnodespace_prefix = prefix;
        poseinnodespace_prefix += "poseInNodeSpace";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->poseInNodeSpace, poseinnodespace_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSystemHandTrackingPropertiesEXT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string supportshandtracking_prefix = prefix;
        supportshandtracking_prefix += "supportsHandTracking";
        std::ostringstream oss_supportsHandTracking;
        oss_supportsHandTracking << "0x" << std::hex << (value->supportsHandTracking);
        contents.emplace_back("XrBool32", supportshandtracking_prefix, oss_supportsHandTracking.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrHandTrackerCreateInfoEXT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string hand_prefix = prefix;
        hand_prefix += "hand";
        contents.emplace_back("XrHandEXT", hand_prefix, std::to_string(value->hand));
        std::string handjointset_prefix = prefix;
        handjointset_prefix += "handJointSet";
        contents.emplace_back("XrHandJointSetEXT", handjointset_prefix, std::to_string(value->handJointSet));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrHandJointsLocateInfoEXT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string basespace_prefix = prefix;
        basespace_prefix += "baseSpace";
        std::ostringstream oss_baseSpace;
        oss_baseSpace << std::hex << reinterpret_cast<const void*>(value->baseSpace);
        contents.emplace_back("XrSpace", basespace_prefix, oss_baseSpace.str());
        std::string time_prefix = prefix;
        time_prefix += "time";
        contents.emplace_back("XrTime", time_prefix, std::to_string(value->time));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrHandJointLocationEXT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string locationflags_prefix = prefix;
        locationflags_prefix += "locationFlags";
        contents.emplace_back("XrSpaceLocationFlags", locationflags_prefix, std::to_string(value->locationFlags));
        std::string pose_prefix = prefix;
        pose_prefix += "pose";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->pose, pose_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string radius_prefix = prefix;
        radius_prefix += "radius";
        std::ostringstream oss_radius;
        oss_radius << std::setprecision(32) << (value->radius);
        contents.emplace_back("float", radius_prefix, oss_radius.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrHandJointVelocityEXT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string velocityflags_prefix = prefix;
        velocityflags_prefix += "velocityFlags";
        contents.emplace_back("XrSpaceVelocityFlags", velocityflags_prefix, std::to_string(value->velocityFlags));
        std::string linearvelocity_prefix = prefix;
        linearvelocity_prefix += "linearVelocity";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->linearVelocity, linearvelocity_prefix, "XrVector3f", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string angularvelocity_prefix = prefix;
        angularvelocity_prefix += "angularVelocity";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->angularVelocity, angularvelocity_prefix, "XrVector3f", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrHandJointLocationsEXT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string isactive_prefix = prefix;
        isactive_prefix += "isActive";
        std::ostringstream oss_isActive;
        oss_isActive << "0x" << std::hex << (value->isActive);
        contents.emplace_back("XrBool32", isactive_prefix, oss_isActive.str());
        std::string jointcount_prefix = prefix;
        jointcount_prefix += "jointCount";
        std::ostringstream oss_jointCount;
        oss_jointCount << "0x" << std::hex << (value->jointCount);
        contents.emplace_back("uint32_t", jointcount_prefix, oss_jointCount.str());
        std::string jointlocations_prefix = prefix;
        jointlocations_prefix += "jointLocations";
        std::ostringstream oss_jointLocations;
        oss_jointLocations << std::hex << reinterpret_cast<const void*>(value->jointLocations);
        contents.emplace_back("XrHandJointLocationEXT*", jointlocations_prefix, oss_jointLocations.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrHandJointVelocitiesEXT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string jointcount_prefix = prefix;
        jointcount_prefix += "jointCount";
        std::ostringstream oss_jointCount;
        oss_jointCount << "0x" << std::hex << (value->jointCount);
        contents.emplace_back("uint32_t", jointcount_prefix, oss_jointCount.str());
        std::string jointvelocities_prefix = prefix;
        jointvelocities_prefix += "jointVelocities";
        std::ostringstream oss_jointVelocities;
        oss_jointVelocities << std::hex << reinterpret_cast<const void*>(value->jointVelocities);
        contents.emplace_back("XrHandJointVelocityEXT*", jointvelocities_prefix, oss_jointVelocities.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSystemHandTrackingMeshPropertiesMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string supportshandtrackingmesh_prefix = prefix;
        supportshandtrackingmesh_prefix += "supportsHandTrackingMesh";
        std::ostringstream oss_supportsHandTrackingMesh;
        oss_supportsHandTrackingMesh << "0x" << std::hex << (value->supportsHandTrackingMesh);
        contents.emplace_back("XrBool32", supportshandtrackingmesh_prefix, oss_supportsHandTrackingMesh.str());
        std::string maxhandmeshindexcount_prefix = prefix;
        maxhandmeshindexcount_prefix += "maxHandMeshIndexCount";
        std::ostringstream oss_maxHandMeshIndexCount;
        oss_maxHandMeshIndexCount << "0x" << std::hex << (value->maxHandMeshIndexCount);
        contents.emplace_back("uint32_t", maxhandmeshindexcount_prefix, oss_maxHandMeshIndexCount.str());
        std::string maxhandmeshvertexcount_prefix = prefix;
        maxhandmeshvertexcount_prefix += "maxHandMeshVertexCount";
        std::ostringstream oss_maxHandMeshVertexCount;
        oss_maxHandMeshVertexCount << "0x" << std::hex << (value->maxHandMeshVertexCount);
        contents.emplace_back("uint32_t", maxhandmeshvertexcount_prefix, oss_maxHandMeshVertexCount.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrHandMeshSpaceCreateInfoMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string handposetype_prefix = prefix;
        handposetype_prefix += "handPoseType";
        contents.emplace_back("XrHandPoseTypeMSFT", handposetype_prefix, std::to_string(value->handPoseType));
        std::string poseinhandmeshspace_prefix = prefix;
        poseinhandmeshspace_prefix += "poseInHandMeshSpace";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->poseInHandMeshSpace, poseinhandmeshspace_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrHandMeshUpdateInfoMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string time_prefix = prefix;
        time_prefix += "time";
        contents.emplace_back("XrTime", time_prefix, std::to_string(value->time));
        std::string handposetype_prefix = prefix;
        handposetype_prefix += "handPoseType";
        contents.emplace_back("XrHandPoseTypeMSFT", handposetype_prefix, std::to_string(value->handPoseType));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrHandMeshIndexBufferMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string indexbufferkey_prefix = prefix;
        indexbufferkey_prefix += "indexBufferKey";
        std::ostringstream oss_indexBufferKey;
        oss_indexBufferKey << "0x" << std::hex << (value->indexBufferKey);
        contents.emplace_back("uint32_t", indexbufferkey_prefix, oss_indexBufferKey.str());
        std::string indexcapacityinput_prefix = prefix;
        indexcapacityinput_prefix += "indexCapacityInput";
        std::ostringstream oss_indexCapacityInput;
        oss_indexCapacityInput << "0x" << std::hex << (value->indexCapacityInput);
        contents.emplace_back("uint32_t", indexcapacityinput_prefix, oss_indexCapacityInput.str());
        std::string indexcountoutput_prefix = prefix;
        indexcountoutput_prefix += "indexCountOutput";
        std::ostringstream oss_indexCountOutput;
        oss_indexCountOutput << "0x" << std::hex << (value->indexCountOutput);
        contents.emplace_back("uint32_t", indexcountoutput_prefix, oss_indexCountOutput.str());
        std::string indices_prefix = prefix;
        indices_prefix += "indices";
        std::ostringstream oss_indices;
        oss_indices << "0x" << std::hex << (value->indices);
        contents.emplace_back("uint32_t*", indices_prefix, oss_indices.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrHandMeshVertexMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string position_prefix = prefix;
        position_prefix += "position";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->position, position_prefix, "XrVector3f", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string normal_prefix = prefix;
        normal_prefix += "normal";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->normal, normal_prefix, "XrVector3f", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrHandMeshVertexBufferMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string vertexupdatetime_prefix = prefix;
        vertexupdatetime_prefix += "vertexUpdateTime";
        contents.emplace_back("XrTime", vertexupdatetime_prefix, std::to_string(value->vertexUpdateTime));
        std::string vertexcapacityinput_prefix = prefix;
        vertexcapacityinput_prefix += "vertexCapacityInput";
        std::ostringstream oss_vertexCapacityInput;
        oss_vertexCapacityInput << "0x" << std::hex << (value->vertexCapacityInput);
        contents.emplace_back("uint32_t", vertexcapacityinput_prefix, oss_vertexCapacityInput.str());
        std::string vertexcountoutput_prefix = prefix;
        vertexcountoutput_prefix += "vertexCountOutput";
        std::ostringstream oss_vertexCountOutput;
        oss_vertexCountOutput << "0x" << std::hex << (value->vertexCountOutput);
        contents.emplace_back("uint32_t", vertexcountoutput_prefix, oss_vertexCountOutput.str());
        std::string vertices_prefix = prefix;
        vertices_prefix += "vertices";
        std::ostringstream oss_vertices;
        oss_vertices << std::hex << reinterpret_cast<const void*>(value->vertices);
        contents.emplace_back("XrHandMeshVertexMSFT*", vertices_prefix, oss_vertices.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrHandMeshMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string isactive_prefix = prefix;
        isactive_prefix += "isActive";
        std::ostringstream oss_isActive;
        oss_isActive << "0x" << std::hex << (value->isActive);
        contents.emplace_back("XrBool32", isactive_prefix, oss_isActive.str());
        std::string indexbufferchanged_prefix = prefix;
        indexbufferchanged_prefix += "indexBufferChanged";
        std::ostringstream oss_indexBufferChanged;
        oss_indexBufferChanged << "0x" << std::hex << (value->indexBufferChanged);
        contents.emplace_back("XrBool32", indexbufferchanged_prefix, oss_indexBufferChanged.str());
        std::string vertexbufferchanged_prefix = prefix;
        vertexbufferchanged_prefix += "vertexBufferChanged";
        std::ostringstream oss_vertexBufferChanged;
        oss_vertexBufferChanged << "0x" << std::hex << (value->vertexBufferChanged);
        contents.emplace_back("XrBool32", vertexbufferchanged_prefix, oss_vertexBufferChanged.str());
        std::string indexbuffer_prefix = prefix;
        indexbuffer_prefix += "indexBuffer";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->indexBuffer, indexbuffer_prefix, "XrHandMeshIndexBufferMSFT", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string vertexbuffer_prefix = prefix;
        vertexbuffer_prefix += "vertexBuffer";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->vertexBuffer, vertexbuffer_prefix, "XrHandMeshVertexBufferMSFT", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrHandPoseTypeInfoMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string handposetype_prefix = prefix;
        handposetype_prefix += "handPoseType";
        contents.emplace_back("XrHandPoseTypeMSFT", handposetype_prefix, std::to_string(value->handPoseType));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSecondaryViewConfigurationSessionBeginInfoMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string viewconfigurationcount_prefix = prefix;
        viewconfigurationcount_prefix += "viewConfigurationCount";
        std::ostringstream oss_viewConfigurationCount;
        oss_viewConfigurationCount << "0x" << std::hex << (value->viewConfigurationCount);
        contents.emplace_back("uint32_t", viewconfigurationcount_prefix, oss_viewConfigurationCount.str());
        std::string enabledviewconfigurationtypes_prefix = prefix;
        enabledviewconfigurationtypes_prefix += "enabledViewConfigurationTypes";
        std::ostringstream oss_enabledViewConfigurationTypes_array;
        oss_enabledViewConfigurationTypes_array << std::hex << reinterpret_cast<const void*>(value->enabledViewConfigurationTypes);
        contents.emplace_back("const XrViewConfigurationType*", enabledviewconfigurationtypes_prefix, oss_enabledViewConfigurationTypes_array.str());
        for (uint32_t value_enabledviewconfigurationtypes_inc = 0; value_enabledviewconfigurationtypes_inc < value->viewConfigurationCount; ++value_enabledviewconfigurationtypes_inc) {
            std::string enabledviewconfigurationtypes_array_prefix = enabledviewconfigurationtypes_prefix;
            enabledviewconfigurationtypes_array_prefix += "[";
            enabledviewconfigurationtypes_array_prefix += std::to_string(value_enabledviewconfigurationtypes_inc);
            enabledviewconfigurationtypes_array_prefix += "]";
            contents.emplace_back("const XrViewConfigurationType*", enabledviewconfigurationtypes_array_prefix, std::to_string(value->enabledViewConfigurationTypes[value_enabledviewconfigurationtypes_inc]));
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSecondaryViewConfigurationStateMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string viewconfigurationtype_prefix = prefix;
        viewconfigurationtype_prefix += "viewConfigurationType";
        contents.emplace_back("XrViewConfigurationType", viewconfigurationtype_prefix, std::to_string(value->viewConfigurationType));
        std::string active_prefix = prefix;
        active_prefix += "active";
        std::ostringstream oss_active;
        oss_active << "0x" << std::hex << (value->active);
        contents.emplace_back("XrBool32", active_prefix, oss_active.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSecondaryViewConfigurationFrameStateMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string viewconfigurationcount_prefix = prefix;
        viewconfigurationcount_prefix += "viewConfigurationCount";
        std::ostringstream oss_viewConfigurationCount;
        oss_viewConfigurationCount << "0x" << std::hex << (value->viewConfigurationCount);
        contents.emplace_back("uint32_t", viewconfigurationcount_prefix, oss_viewConfigurationCount.str());
        std::string viewconfigurationstates_prefix = prefix;
        viewconfigurationstates_prefix += "viewConfigurationStates";
        std::ostringstream oss_viewConfigurationStates;
        oss_viewConfigurationStates << std::hex << reinterpret_cast<const void*>(value->viewConfigurationStates);
        contents.emplace_back("XrSecondaryViewConfigurationStateMSFT*", viewconfigurationstates_prefix, oss_viewConfigurationStates.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSecondaryViewConfigurationLayerInfoMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string viewconfigurationtype_prefix = prefix;
        viewconfigurationtype_prefix += "viewConfigurationType";
        contents.emplace_back("XrViewConfigurationType", viewconfigurationtype_prefix, std::to_string(value->viewConfigurationType));
        std::string environmentblendmode_prefix = prefix;
        environmentblendmode_prefix += "environmentBlendMode";
        contents.emplace_back("XrEnvironmentBlendMode", environmentblendmode_prefix, std::to_string(value->environmentBlendMode));
        std::string layercount_prefix = prefix;
        layercount_prefix += "layerCount";
        std::ostringstream oss_layerCount;
        oss_layerCount << "0x" << std::hex << (value->layerCount);
        contents.emplace_back("uint32_t", layercount_prefix, oss_layerCount.str());
        std::string layers_prefix = prefix;
        layers_prefix += "layers";
        std::ostringstream oss_layers_array;
        oss_layers_array << std::hex << reinterpret_cast<const void*>(value->layers);
        contents.emplace_back("const XrCompositionLayerBaseHeader* const*", layers_prefix, oss_layers_array.str());
        for (uint32_t value_layers_inc = 0; value_layers_inc < value->layerCount; ++value_layers_inc) {
            std::string layers_array_prefix = layers_prefix;
            layers_array_prefix += "[";
            layers_array_prefix += std::to_string(value_layers_inc);
            layers_array_prefix += "]";
            if (!ApiDumpOutputXrStruct(gen_dispatch_table, value->layers[value_layers_inc], layers_array_prefix, "const XrCompositionLayerBaseHeader* const*", true, contents)) {
                throw std::invalid_argument("Invalid Operation");
            }
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSecondaryViewConfigurationFrameEndInfoMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string viewconfigurationcount_prefix = prefix;
        viewconfigurationcount_prefix += "viewConfigurationCount";
        std::ostringstream oss_viewConfigurationCount;
        oss_viewConfigurationCount << "0x" << std::hex << (value->viewConfigurationCount);
        contents.emplace_back("uint32_t", viewconfigurationcount_prefix, oss_viewConfigurationCount.str());
        std::string viewconfigurationlayersinfo_prefix = prefix;
        viewconfigurationlayersinfo_prefix += "viewConfigurationLayersInfo";
        std::ostringstream oss_viewConfigurationLayersInfo_array;
        oss_viewConfigurationLayersInfo_array << std::hex << reinterpret_cast<const void*>(value->viewConfigurationLayersInfo);
        contents.emplace_back("const XrSecondaryViewConfigurationLayerInfoMSFT*", viewconfigurationlayersinfo_prefix, oss_viewConfigurationLayersInfo_array.str());
        for (uint32_t value_viewconfigurationlayersinfo_inc = 0; value_viewconfigurationlayersinfo_inc < value->viewConfigurationCount; ++value_viewconfigurationlayersinfo_inc) {
            std::string viewconfigurationlayersinfo_array_prefix = viewconfigurationlayersinfo_prefix;
            viewconfigurationlayersinfo_array_prefix += "[";
            viewconfigurationlayersinfo_array_prefix += std::to_string(value_viewconfigurationlayersinfo_inc);
            viewconfigurationlayersinfo_array_prefix += "]";
            if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->viewConfigurationLayersInfo[value_viewconfigurationlayersinfo_inc], viewconfigurationlayersinfo_array_prefix, "const XrSecondaryViewConfigurationLayerInfoMSFT*", false, contents)) {
                throw std::invalid_argument("Invalid Operation");
            }
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSecondaryViewConfigurationSwapchainCreateInfoMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string viewconfigurationtype_prefix = prefix;
        viewconfigurationtype_prefix += "viewConfigurationType";
        contents.emplace_back("XrViewConfigurationType", viewconfigurationtype_prefix, std::to_string(value->viewConfigurationType));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrControllerModelKeyStateMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string modelkey_prefix = prefix;
        modelkey_prefix += "modelKey";
        contents.emplace_back("XrControllerModelKeyMSFT", modelkey_prefix, std::to_string(value->modelKey));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrControllerModelNodePropertiesMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string parentnodename_prefix = prefix;
        parentnodename_prefix += "parentNodeName";
        contents.emplace_back("char*", parentnodename_prefix, value->parentNodeName);
        std::string nodename_prefix = prefix;
        nodename_prefix += "nodeName";
        contents.emplace_back("char*", nodename_prefix, value->nodeName);
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrControllerModelPropertiesMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string nodecapacityinput_prefix = prefix;
        nodecapacityinput_prefix += "nodeCapacityInput";
        std::ostringstream oss_nodeCapacityInput;
        oss_nodeCapacityInput << "0x" << std::hex << (value->nodeCapacityInput);
        contents.emplace_back("uint32_t", nodecapacityinput_prefix, oss_nodeCapacityInput.str());
        std::string nodecountoutput_prefix = prefix;
        nodecountoutput_prefix += "nodeCountOutput";
        std::ostringstream oss_nodeCountOutput;
        oss_nodeCountOutput << "0x" << std::hex << (value->nodeCountOutput);
        contents.emplace_back("uint32_t", nodecountoutput_prefix, oss_nodeCountOutput.str());
        std::string nodeproperties_prefix = prefix;
        nodeproperties_prefix += "nodeProperties";
        std::ostringstream oss_nodeProperties;
        oss_nodeProperties << std::hex << reinterpret_cast<const void*>(value->nodeProperties);
        contents.emplace_back("XrControllerModelNodePropertiesMSFT*", nodeproperties_prefix, oss_nodeProperties.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrControllerModelNodeStateMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string nodepose_prefix = prefix;
        nodepose_prefix += "nodePose";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->nodePose, nodepose_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrControllerModelStateMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string nodecapacityinput_prefix = prefix;
        nodecapacityinput_prefix += "nodeCapacityInput";
        std::ostringstream oss_nodeCapacityInput;
        oss_nodeCapacityInput << "0x" << std::hex << (value->nodeCapacityInput);
        contents.emplace_back("uint32_t", nodecapacityinput_prefix, oss_nodeCapacityInput.str());
        std::string nodecountoutput_prefix = prefix;
        nodecountoutput_prefix += "nodeCountOutput";
        std::ostringstream oss_nodeCountOutput;
        oss_nodeCountOutput << "0x" << std::hex << (value->nodeCountOutput);
        contents.emplace_back("uint32_t", nodecountoutput_prefix, oss_nodeCountOutput.str());
        std::string nodestates_prefix = prefix;
        nodestates_prefix += "nodeStates";
        std::ostringstream oss_nodeStates;
        oss_nodeStates << std::hex << reinterpret_cast<const void*>(value->nodeStates);
        contents.emplace_back("XrControllerModelNodeStateMSFT*", nodestates_prefix, oss_nodeStates.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrViewConfigurationViewFovEPIC* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string recommendedfov_prefix = prefix;
        recommendedfov_prefix += "recommendedFov";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->recommendedFov, recommendedfov_prefix, "XrFovf", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string maxmutablefov_prefix = prefix;
        maxmutablefov_prefix += "maxMutableFov";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->maxMutableFov, maxmutablefov_prefix, "XrFovf", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

#if defined(XR_USE_PLATFORM_WIN32) && defined(XR_USE_PLATFORM_WIN32)
bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrHolographicWindowAttachmentMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string holographicspace_prefix = prefix;
        holographicspace_prefix += "holographicSpace";
        std::ostringstream oss_holographicSpace;
        oss_holographicSpace << std::hex << reinterpret_cast<const void*>(value->holographicSpace);
        contents.emplace_back("IUnknown*", holographicspace_prefix, oss_holographicSpace.str());
        std::string corewindow_prefix = prefix;
        corewindow_prefix += "coreWindow";
        std::ostringstream oss_coreWindow;
        oss_coreWindow << std::hex << reinterpret_cast<const void*>(value->coreWindow);
        contents.emplace_back("IUnknown*", corewindow_prefix, oss_coreWindow.str());
        return true;
    } catch(...) {
    }
    return false;
}
#endif // defined(XR_USE_PLATFORM_WIN32) && defined(XR_USE_PLATFORM_WIN32)

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrCompositionLayerReprojectionInfoMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string reprojectionmode_prefix = prefix;
        reprojectionmode_prefix += "reprojectionMode";
        contents.emplace_back("XrReprojectionModeMSFT", reprojectionmode_prefix, std::to_string(value->reprojectionMode));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrCompositionLayerReprojectionPlaneOverrideMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string position_prefix = prefix;
        position_prefix += "position";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->position, position_prefix, "XrVector3f", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string normal_prefix = prefix;
        normal_prefix += "normal";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->normal, normal_prefix, "XrVector3f", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string velocity_prefix = prefix;
        velocity_prefix += "velocity";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->velocity, velocity_prefix, "XrVector3f", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

#if defined(XR_USE_PLATFORM_ANDROID) && defined(XR_USE_PLATFORM_ANDROID)
bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrAndroidSurfaceSwapchainCreateInfoFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string createflags_prefix = prefix;
        createflags_prefix += "createFlags";
        contents.emplace_back("XrAndroidSurfaceSwapchainFlagsFB", createflags_prefix, std::to_string(value->createFlags));
        return true;
    } catch(...) {
    }
    return false;
}
#endif // defined(XR_USE_PLATFORM_ANDROID) && defined(XR_USE_PLATFORM_ANDROID)

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSwapchainStateBaseHeaderFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        if (value->type == XR_TYPE_SWAPCHAIN_STATE_FOVEATION_FB) {
            const XrSwapchainStateFoveationFB* new_value = reinterpret_cast<const XrSwapchainStateFoveationFB*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
#if defined(XR_USE_PLATFORM_ANDROID) && defined(XR_USE_PLATFORM_ANDROID)
        if (value->type == XR_TYPE_SWAPCHAIN_STATE_ANDROID_SURFACE_DIMENSIONS_FB) {
            const XrSwapchainStateAndroidSurfaceDimensionsFB* new_value = reinterpret_cast<const XrSwapchainStateAndroidSurfaceDimensionsFB*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
#endif // defined(XR_USE_PLATFORM_ANDROID) && defined(XR_USE_PLATFORM_ANDROID)
#if defined(XR_USE_GRAPHICS_API_OPENGL_ES) && defined(XR_USE_GRAPHICS_API_OPENGL_ES)
        if (value->type == XR_TYPE_SWAPCHAIN_STATE_SAMPLER_OPENGL_ES_FB) {
            const XrSwapchainStateSamplerOpenGLESFB* new_value = reinterpret_cast<const XrSwapchainStateSamplerOpenGLESFB*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
#endif // defined(XR_USE_GRAPHICS_API_OPENGL_ES) && defined(XR_USE_GRAPHICS_API_OPENGL_ES)
#if defined(XR_USE_GRAPHICS_API_VULKAN) && defined(XR_USE_GRAPHICS_API_VULKAN)
        if (value->type == XR_TYPE_SWAPCHAIN_STATE_SAMPLER_VULKAN_FB) {
            const XrSwapchainStateSamplerVulkanFB* new_value = reinterpret_cast<const XrSwapchainStateSamplerVulkanFB*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
#endif // defined(XR_USE_GRAPHICS_API_VULKAN) && defined(XR_USE_GRAPHICS_API_VULKAN)
        // Fallback path - Just output generic information about the base struct
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrCompositionLayerSecureContentFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string flags_prefix = prefix;
        flags_prefix += "flags";
        contents.emplace_back("XrCompositionLayerSecureContentFlagsFB", flags_prefix, std::to_string(value->flags));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrBodyJointLocationFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string locationflags_prefix = prefix;
        locationflags_prefix += "locationFlags";
        contents.emplace_back("XrSpaceLocationFlags", locationflags_prefix, std::to_string(value->locationFlags));
        std::string pose_prefix = prefix;
        pose_prefix += "pose";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->pose, pose_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSystemBodyTrackingPropertiesFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string supportsbodytracking_prefix = prefix;
        supportsbodytracking_prefix += "supportsBodyTracking";
        std::ostringstream oss_supportsBodyTracking;
        oss_supportsBodyTracking << "0x" << std::hex << (value->supportsBodyTracking);
        contents.emplace_back("XrBool32", supportsbodytracking_prefix, oss_supportsBodyTracking.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrBodyTrackerCreateInfoFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string bodyjointset_prefix = prefix;
        bodyjointset_prefix += "bodyJointSet";
        contents.emplace_back("XrBodyJointSetFB", bodyjointset_prefix, std::to_string(value->bodyJointSet));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrBodySkeletonJointFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string joint_prefix = prefix;
        joint_prefix += "joint";
        contents.emplace_back("int32_t", joint_prefix, std::to_string(value->joint));
        std::string parentjoint_prefix = prefix;
        parentjoint_prefix += "parentJoint";
        contents.emplace_back("int32_t", parentjoint_prefix, std::to_string(value->parentJoint));
        std::string pose_prefix = prefix;
        pose_prefix += "pose";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->pose, pose_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrBodySkeletonFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string jointcount_prefix = prefix;
        jointcount_prefix += "jointCount";
        std::ostringstream oss_jointCount;
        oss_jointCount << "0x" << std::hex << (value->jointCount);
        contents.emplace_back("uint32_t", jointcount_prefix, oss_jointCount.str());
        std::string joints_prefix = prefix;
        joints_prefix += "joints";
        std::ostringstream oss_joints;
        oss_joints << std::hex << reinterpret_cast<const void*>(value->joints);
        contents.emplace_back("XrBodySkeletonJointFB*", joints_prefix, oss_joints.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrBodyJointsLocateInfoFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string basespace_prefix = prefix;
        basespace_prefix += "baseSpace";
        std::ostringstream oss_baseSpace;
        oss_baseSpace << std::hex << reinterpret_cast<const void*>(value->baseSpace);
        contents.emplace_back("XrSpace", basespace_prefix, oss_baseSpace.str());
        std::string time_prefix = prefix;
        time_prefix += "time";
        contents.emplace_back("XrTime", time_prefix, std::to_string(value->time));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrBodyJointLocationsFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string isactive_prefix = prefix;
        isactive_prefix += "isActive";
        std::ostringstream oss_isActive;
        oss_isActive << "0x" << std::hex << (value->isActive);
        contents.emplace_back("XrBool32", isactive_prefix, oss_isActive.str());
        std::string confidence_prefix = prefix;
        confidence_prefix += "confidence";
        std::ostringstream oss_confidence;
        oss_confidence << std::setprecision(32) << (value->confidence);
        contents.emplace_back("float", confidence_prefix, oss_confidence.str());
        std::string jointcount_prefix = prefix;
        jointcount_prefix += "jointCount";
        std::ostringstream oss_jointCount;
        oss_jointCount << "0x" << std::hex << (value->jointCount);
        contents.emplace_back("uint32_t", jointcount_prefix, oss_jointCount.str());
        std::string jointlocations_prefix = prefix;
        jointlocations_prefix += "jointLocations";
        std::ostringstream oss_jointLocations;
        oss_jointLocations << std::hex << reinterpret_cast<const void*>(value->jointLocations);
        contents.emplace_back("XrBodyJointLocationFB*", jointlocations_prefix, oss_jointLocations.str());
        std::string skeletonchangedcount_prefix = prefix;
        skeletonchangedcount_prefix += "skeletonChangedCount";
        std::ostringstream oss_skeletonChangedCount;
        oss_skeletonChangedCount << "0x" << std::hex << (value->skeletonChangedCount);
        contents.emplace_back("uint32_t", skeletonchangedcount_prefix, oss_skeletonChangedCount.str());
        std::string time_prefix = prefix;
        time_prefix += "time";
        contents.emplace_back("XrTime", time_prefix, std::to_string(value->time));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrInteractionProfileDpadBindingEXT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string binding_prefix = prefix;
        binding_prefix += "binding";
        contents.emplace_back("XrPath", binding_prefix, std::to_string(value->binding));
        std::string actionset_prefix = prefix;
        actionset_prefix += "actionSet";
        std::ostringstream oss_actionSet;
        oss_actionSet << std::hex << reinterpret_cast<const void*>(value->actionSet);
        contents.emplace_back("XrActionSet", actionset_prefix, oss_actionSet.str());
        std::string forcethreshold_prefix = prefix;
        forcethreshold_prefix += "forceThreshold";
        std::ostringstream oss_forceThreshold;
        oss_forceThreshold << std::setprecision(32) << (value->forceThreshold);
        contents.emplace_back("float", forcethreshold_prefix, oss_forceThreshold.str());
        std::string forcethresholdreleased_prefix = prefix;
        forcethresholdreleased_prefix += "forceThresholdReleased";
        std::ostringstream oss_forceThresholdReleased;
        oss_forceThresholdReleased << std::setprecision(32) << (value->forceThresholdReleased);
        contents.emplace_back("float", forcethresholdreleased_prefix, oss_forceThresholdReleased.str());
        std::string centerregion_prefix = prefix;
        centerregion_prefix += "centerRegion";
        std::ostringstream oss_centerRegion;
        oss_centerRegion << std::setprecision(32) << (value->centerRegion);
        contents.emplace_back("float", centerregion_prefix, oss_centerRegion.str());
        std::string wedgeangle_prefix = prefix;
        wedgeangle_prefix += "wedgeAngle";
        std::ostringstream oss_wedgeAngle;
        oss_wedgeAngle << std::setprecision(32) << (value->wedgeAngle);
        contents.emplace_back("float", wedgeangle_prefix, oss_wedgeAngle.str());
        std::string issticky_prefix = prefix;
        issticky_prefix += "isSticky";
        std::ostringstream oss_isSticky;
        oss_isSticky << "0x" << std::hex << (value->isSticky);
        contents.emplace_back("XrBool32", issticky_prefix, oss_isSticky.str());
        std::string onhaptic_prefix = prefix;
        onhaptic_prefix += "onHaptic";
        if (nullptr == value->onHaptic) {
            std::ostringstream oss_onHaptic;
            oss_onHaptic << std::hex << reinterpret_cast<const void*>(value->onHaptic);
            contents.emplace_back("const XrHapticBaseHeader*", onhaptic_prefix, oss_onHaptic.str());
        } else if (!ApiDumpOutputXrStruct(gen_dispatch_table, value->onHaptic, onhaptic_prefix, "const XrHapticBaseHeader*", true, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string offhaptic_prefix = prefix;
        offhaptic_prefix += "offHaptic";
        if (nullptr == value->offHaptic) {
            std::ostringstream oss_offHaptic;
            oss_offHaptic << std::hex << reinterpret_cast<const void*>(value->offHaptic);
            contents.emplace_back("const XrHapticBaseHeader*", offhaptic_prefix, oss_offHaptic.str());
        } else if (!ApiDumpOutputXrStruct(gen_dispatch_table, value->offHaptic, offhaptic_prefix, "const XrHapticBaseHeader*", true, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrInteractionProfileAnalogThresholdVALVE* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string action_prefix = prefix;
        action_prefix += "action";
        std::ostringstream oss_action;
        oss_action << std::hex << reinterpret_cast<const void*>(value->action);
        contents.emplace_back("XrAction", action_prefix, oss_action.str());
        std::string binding_prefix = prefix;
        binding_prefix += "binding";
        contents.emplace_back("XrPath", binding_prefix, std::to_string(value->binding));
        std::string onthreshold_prefix = prefix;
        onthreshold_prefix += "onThreshold";
        std::ostringstream oss_onThreshold;
        oss_onThreshold << std::setprecision(32) << (value->onThreshold);
        contents.emplace_back("float", onthreshold_prefix, oss_onThreshold.str());
        std::string offthreshold_prefix = prefix;
        offthreshold_prefix += "offThreshold";
        std::ostringstream oss_offThreshold;
        oss_offThreshold << std::setprecision(32) << (value->offThreshold);
        contents.emplace_back("float", offthreshold_prefix, oss_offThreshold.str());
        std::string onhaptic_prefix = prefix;
        onhaptic_prefix += "onHaptic";
        if (nullptr == value->onHaptic) {
            std::ostringstream oss_onHaptic;
            oss_onHaptic << std::hex << reinterpret_cast<const void*>(value->onHaptic);
            contents.emplace_back("const XrHapticBaseHeader*", onhaptic_prefix, oss_onHaptic.str());
        } else if (!ApiDumpOutputXrStruct(gen_dispatch_table, value->onHaptic, onhaptic_prefix, "const XrHapticBaseHeader*", true, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string offhaptic_prefix = prefix;
        offhaptic_prefix += "offHaptic";
        if (nullptr == value->offHaptic) {
            std::ostringstream oss_offHaptic;
            oss_offHaptic << std::hex << reinterpret_cast<const void*>(value->offHaptic);
            contents.emplace_back("const XrHapticBaseHeader*", offhaptic_prefix, oss_offHaptic.str());
        } else if (!ApiDumpOutputXrStruct(gen_dispatch_table, value->offHaptic, offhaptic_prefix, "const XrHapticBaseHeader*", true, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrHandJointsMotionRangeInfoEXT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string handjointsmotionrange_prefix = prefix;
        handjointsmotionrange_prefix += "handJointsMotionRange";
        contents.emplace_back("XrHandJointsMotionRangeEXT", handjointsmotionrange_prefix, std::to_string(value->handJointsMotionRange));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrUuidMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string bytes_prefix = prefix;
        bytes_prefix += "bytes";
        std::ostringstream oss_bytes_array;
        oss_bytes_array << "0x" << std::hex << (value->bytes);
        contents.emplace_back("uint8_t*", bytes_prefix, oss_bytes_array.str());
        for (uint32_t value_bytes_inc = 0; value_bytes_inc < 16; ++value_bytes_inc) {
            std::string bytes_array_prefix = bytes_prefix;
            bytes_array_prefix += "[";
            bytes_array_prefix += std::to_string(value_bytes_inc);
            bytes_array_prefix += "]";
            std::ostringstream oss_bytes;
            oss_bytes << "0x" << std::hex << (value->bytes[value_bytes_inc]);
            contents.emplace_back("uint8_t", bytes_array_prefix, oss_bytes.str());
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSceneObserverCreateInfoMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSceneCreateInfoMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSceneSphereBoundMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string center_prefix = prefix;
        center_prefix += "center";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->center, center_prefix, "XrVector3f", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string radius_prefix = prefix;
        radius_prefix += "radius";
        std::ostringstream oss_radius;
        oss_radius << std::setprecision(32) << (value->radius);
        contents.emplace_back("float", radius_prefix, oss_radius.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSceneOrientedBoxBoundMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string pose_prefix = prefix;
        pose_prefix += "pose";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->pose, pose_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string extents_prefix = prefix;
        extents_prefix += "extents";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->extents, extents_prefix, "XrVector3f", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSceneFrustumBoundMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string pose_prefix = prefix;
        pose_prefix += "pose";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->pose, pose_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string fov_prefix = prefix;
        fov_prefix += "fov";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->fov, fov_prefix, "XrFovf", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string fardistance_prefix = prefix;
        fardistance_prefix += "farDistance";
        std::ostringstream oss_farDistance;
        oss_farDistance << std::setprecision(32) << (value->farDistance);
        contents.emplace_back("float", fardistance_prefix, oss_farDistance.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSceneBoundsMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string space_prefix = prefix;
        space_prefix += "space";
        std::ostringstream oss_space;
        oss_space << std::hex << reinterpret_cast<const void*>(value->space);
        contents.emplace_back("XrSpace", space_prefix, oss_space.str());
        std::string time_prefix = prefix;
        time_prefix += "time";
        contents.emplace_back("XrTime", time_prefix, std::to_string(value->time));
        std::string spherecount_prefix = prefix;
        spherecount_prefix += "sphereCount";
        std::ostringstream oss_sphereCount;
        oss_sphereCount << "0x" << std::hex << (value->sphereCount);
        contents.emplace_back("uint32_t", spherecount_prefix, oss_sphereCount.str());
        std::string spheres_prefix = prefix;
        spheres_prefix += "spheres";
        std::ostringstream oss_spheres_array;
        oss_spheres_array << std::hex << reinterpret_cast<const void*>(value->spheres);
        contents.emplace_back("const XrSceneSphereBoundMSFT*", spheres_prefix, oss_spheres_array.str());
        for (uint32_t value_spheres_inc = 0; value_spheres_inc < value->sphereCount; ++value_spheres_inc) {
            std::string spheres_array_prefix = spheres_prefix;
            spheres_array_prefix += "[";
            spheres_array_prefix += std::to_string(value_spheres_inc);
            spheres_array_prefix += "]";
            if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->spheres[value_spheres_inc], spheres_array_prefix, "const XrSceneSphereBoundMSFT*", false, contents)) {
                throw std::invalid_argument("Invalid Operation");
            }
        }
        std::string boxcount_prefix = prefix;
        boxcount_prefix += "boxCount";
        std::ostringstream oss_boxCount;
        oss_boxCount << "0x" << std::hex << (value->boxCount);
        contents.emplace_back("uint32_t", boxcount_prefix, oss_boxCount.str());
        std::string boxes_prefix = prefix;
        boxes_prefix += "boxes";
        std::ostringstream oss_boxes_array;
        oss_boxes_array << std::hex << reinterpret_cast<const void*>(value->boxes);
        contents.emplace_back("const XrSceneOrientedBoxBoundMSFT*", boxes_prefix, oss_boxes_array.str());
        for (uint32_t value_boxes_inc = 0; value_boxes_inc < value->boxCount; ++value_boxes_inc) {
            std::string boxes_array_prefix = boxes_prefix;
            boxes_array_prefix += "[";
            boxes_array_prefix += std::to_string(value_boxes_inc);
            boxes_array_prefix += "]";
            if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->boxes[value_boxes_inc], boxes_array_prefix, "const XrSceneOrientedBoxBoundMSFT*", false, contents)) {
                throw std::invalid_argument("Invalid Operation");
            }
        }
        std::string frustumcount_prefix = prefix;
        frustumcount_prefix += "frustumCount";
        std::ostringstream oss_frustumCount;
        oss_frustumCount << "0x" << std::hex << (value->frustumCount);
        contents.emplace_back("uint32_t", frustumcount_prefix, oss_frustumCount.str());
        std::string frustums_prefix = prefix;
        frustums_prefix += "frustums";
        std::ostringstream oss_frustums_array;
        oss_frustums_array << std::hex << reinterpret_cast<const void*>(value->frustums);
        contents.emplace_back("const XrSceneFrustumBoundMSFT*", frustums_prefix, oss_frustums_array.str());
        for (uint32_t value_frustums_inc = 0; value_frustums_inc < value->frustumCount; ++value_frustums_inc) {
            std::string frustums_array_prefix = frustums_prefix;
            frustums_array_prefix += "[";
            frustums_array_prefix += std::to_string(value_frustums_inc);
            frustums_array_prefix += "]";
            if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->frustums[value_frustums_inc], frustums_array_prefix, "const XrSceneFrustumBoundMSFT*", false, contents)) {
                throw std::invalid_argument("Invalid Operation");
            }
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrNewSceneComputeInfoMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string requestedfeaturecount_prefix = prefix;
        requestedfeaturecount_prefix += "requestedFeatureCount";
        std::ostringstream oss_requestedFeatureCount;
        oss_requestedFeatureCount << "0x" << std::hex << (value->requestedFeatureCount);
        contents.emplace_back("uint32_t", requestedfeaturecount_prefix, oss_requestedFeatureCount.str());
        std::string requestedfeatures_prefix = prefix;
        requestedfeatures_prefix += "requestedFeatures";
        std::ostringstream oss_requestedFeatures_array;
        oss_requestedFeatures_array << std::hex << reinterpret_cast<const void*>(value->requestedFeatures);
        contents.emplace_back("const XrSceneComputeFeatureMSFT*", requestedfeatures_prefix, oss_requestedFeatures_array.str());
        for (uint32_t value_requestedfeatures_inc = 0; value_requestedfeatures_inc < value->requestedFeatureCount; ++value_requestedfeatures_inc) {
            std::string requestedfeatures_array_prefix = requestedfeatures_prefix;
            requestedfeatures_array_prefix += "[";
            requestedfeatures_array_prefix += std::to_string(value_requestedfeatures_inc);
            requestedfeatures_array_prefix += "]";
            contents.emplace_back("const XrSceneComputeFeatureMSFT*", requestedfeatures_array_prefix, std::to_string(value->requestedFeatures[value_requestedfeatures_inc]));
        }
        std::string consistency_prefix = prefix;
        consistency_prefix += "consistency";
        contents.emplace_back("XrSceneComputeConsistencyMSFT", consistency_prefix, std::to_string(value->consistency));
        std::string bounds_prefix = prefix;
        bounds_prefix += "bounds";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->bounds, bounds_prefix, "XrSceneBoundsMSFT", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrVisualMeshComputeLodInfoMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string lod_prefix = prefix;
        lod_prefix += "lod";
        contents.emplace_back("XrMeshComputeLodMSFT", lod_prefix, std::to_string(value->lod));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSceneComponentMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string componenttype_prefix = prefix;
        componenttype_prefix += "componentType";
        contents.emplace_back("XrSceneComponentTypeMSFT", componenttype_prefix, std::to_string(value->componentType));
        std::string id_prefix = prefix;
        id_prefix += "id";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->id, id_prefix, "XrUuidMSFT", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string parentid_prefix = prefix;
        parentid_prefix += "parentId";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->parentId, parentid_prefix, "XrUuidMSFT", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string updatetime_prefix = prefix;
        updatetime_prefix += "updateTime";
        contents.emplace_back("XrTime", updatetime_prefix, std::to_string(value->updateTime));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSceneComponentsMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string componentcapacityinput_prefix = prefix;
        componentcapacityinput_prefix += "componentCapacityInput";
        std::ostringstream oss_componentCapacityInput;
        oss_componentCapacityInput << "0x" << std::hex << (value->componentCapacityInput);
        contents.emplace_back("uint32_t", componentcapacityinput_prefix, oss_componentCapacityInput.str());
        std::string componentcountoutput_prefix = prefix;
        componentcountoutput_prefix += "componentCountOutput";
        std::ostringstream oss_componentCountOutput;
        oss_componentCountOutput << "0x" << std::hex << (value->componentCountOutput);
        contents.emplace_back("uint32_t", componentcountoutput_prefix, oss_componentCountOutput.str());
        std::string components_prefix = prefix;
        components_prefix += "components";
        std::ostringstream oss_components;
        oss_components << std::hex << reinterpret_cast<const void*>(value->components);
        contents.emplace_back("XrSceneComponentMSFT*", components_prefix, oss_components.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSceneComponentsGetInfoMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string componenttype_prefix = prefix;
        componenttype_prefix += "componentType";
        contents.emplace_back("XrSceneComponentTypeMSFT", componenttype_prefix, std::to_string(value->componentType));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSceneComponentLocationMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string flags_prefix = prefix;
        flags_prefix += "flags";
        contents.emplace_back("XrSpaceLocationFlags", flags_prefix, std::to_string(value->flags));
        std::string pose_prefix = prefix;
        pose_prefix += "pose";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->pose, pose_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSceneComponentLocationsMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string locationcount_prefix = prefix;
        locationcount_prefix += "locationCount";
        std::ostringstream oss_locationCount;
        oss_locationCount << "0x" << std::hex << (value->locationCount);
        contents.emplace_back("uint32_t", locationcount_prefix, oss_locationCount.str());
        std::string locations_prefix = prefix;
        locations_prefix += "locations";
        std::ostringstream oss_locations;
        oss_locations << std::hex << reinterpret_cast<const void*>(value->locations);
        contents.emplace_back("XrSceneComponentLocationMSFT*", locations_prefix, oss_locations.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSceneComponentsLocateInfoMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string basespace_prefix = prefix;
        basespace_prefix += "baseSpace";
        std::ostringstream oss_baseSpace;
        oss_baseSpace << std::hex << reinterpret_cast<const void*>(value->baseSpace);
        contents.emplace_back("XrSpace", basespace_prefix, oss_baseSpace.str());
        std::string time_prefix = prefix;
        time_prefix += "time";
        contents.emplace_back("XrTime", time_prefix, std::to_string(value->time));
        std::string componentidcount_prefix = prefix;
        componentidcount_prefix += "componentIdCount";
        std::ostringstream oss_componentIdCount;
        oss_componentIdCount << "0x" << std::hex << (value->componentIdCount);
        contents.emplace_back("uint32_t", componentidcount_prefix, oss_componentIdCount.str());
        std::string componentids_prefix = prefix;
        componentids_prefix += "componentIds";
        std::ostringstream oss_componentIds_array;
        oss_componentIds_array << std::hex << reinterpret_cast<const void*>(value->componentIds);
        contents.emplace_back("const XrUuidMSFT*", componentids_prefix, oss_componentIds_array.str());
        for (uint32_t value_componentids_inc = 0; value_componentids_inc < value->componentIdCount; ++value_componentids_inc) {
            std::string componentids_array_prefix = componentids_prefix;
            componentids_array_prefix += "[";
            componentids_array_prefix += std::to_string(value_componentids_inc);
            componentids_array_prefix += "]";
            if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->componentIds[value_componentids_inc], componentids_array_prefix, "const XrUuidMSFT*", false, contents)) {
                throw std::invalid_argument("Invalid Operation");
            }
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSceneObjectMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string objecttype_prefix = prefix;
        objecttype_prefix += "objectType";
        contents.emplace_back("XrSceneObjectTypeMSFT", objecttype_prefix, std::to_string(value->objectType));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSceneObjectsMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string sceneobjectcount_prefix = prefix;
        sceneobjectcount_prefix += "sceneObjectCount";
        std::ostringstream oss_sceneObjectCount;
        oss_sceneObjectCount << "0x" << std::hex << (value->sceneObjectCount);
        contents.emplace_back("uint32_t", sceneobjectcount_prefix, oss_sceneObjectCount.str());
        std::string sceneobjects_prefix = prefix;
        sceneobjects_prefix += "sceneObjects";
        std::ostringstream oss_sceneObjects;
        oss_sceneObjects << std::hex << reinterpret_cast<const void*>(value->sceneObjects);
        contents.emplace_back("XrSceneObjectMSFT*", sceneobjects_prefix, oss_sceneObjects.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSceneComponentParentFilterInfoMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string parentid_prefix = prefix;
        parentid_prefix += "parentId";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->parentId, parentid_prefix, "XrUuidMSFT", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSceneObjectTypesFilterInfoMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string objecttypecount_prefix = prefix;
        objecttypecount_prefix += "objectTypeCount";
        std::ostringstream oss_objectTypeCount;
        oss_objectTypeCount << "0x" << std::hex << (value->objectTypeCount);
        contents.emplace_back("uint32_t", objecttypecount_prefix, oss_objectTypeCount.str());
        std::string objecttypes_prefix = prefix;
        objecttypes_prefix += "objectTypes";
        std::ostringstream oss_objectTypes_array;
        oss_objectTypes_array << std::hex << reinterpret_cast<const void*>(value->objectTypes);
        contents.emplace_back("const XrSceneObjectTypeMSFT*", objecttypes_prefix, oss_objectTypes_array.str());
        for (uint32_t value_objecttypes_inc = 0; value_objecttypes_inc < value->objectTypeCount; ++value_objecttypes_inc) {
            std::string objecttypes_array_prefix = objecttypes_prefix;
            objecttypes_array_prefix += "[";
            objecttypes_array_prefix += std::to_string(value_objecttypes_inc);
            objecttypes_array_prefix += "]";
            contents.emplace_back("const XrSceneObjectTypeMSFT*", objecttypes_array_prefix, std::to_string(value->objectTypes[value_objecttypes_inc]));
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrScenePlaneMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string alignment_prefix = prefix;
        alignment_prefix += "alignment";
        contents.emplace_back("XrScenePlaneAlignmentTypeMSFT", alignment_prefix, std::to_string(value->alignment));
        std::string size_prefix = prefix;
        size_prefix += "size";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->size, size_prefix, "XrExtent2Df", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string meshbufferid_prefix = prefix;
        meshbufferid_prefix += "meshBufferId";
        std::ostringstream oss_meshBufferId;
        oss_meshBufferId << "0x" << std::hex << (value->meshBufferId);
        contents.emplace_back("uint64_t", meshbufferid_prefix, oss_meshBufferId.str());
        std::string supportsindicesuint16_prefix = prefix;
        supportsindicesuint16_prefix += "supportsIndicesUint16";
        std::ostringstream oss_supportsIndicesUint16;
        oss_supportsIndicesUint16 << "0x" << std::hex << (value->supportsIndicesUint16);
        contents.emplace_back("XrBool32", supportsindicesuint16_prefix, oss_supportsIndicesUint16.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrScenePlanesMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string sceneplanecount_prefix = prefix;
        sceneplanecount_prefix += "scenePlaneCount";
        std::ostringstream oss_scenePlaneCount;
        oss_scenePlaneCount << "0x" << std::hex << (value->scenePlaneCount);
        contents.emplace_back("uint32_t", sceneplanecount_prefix, oss_scenePlaneCount.str());
        std::string sceneplanes_prefix = prefix;
        sceneplanes_prefix += "scenePlanes";
        std::ostringstream oss_scenePlanes;
        oss_scenePlanes << std::hex << reinterpret_cast<const void*>(value->scenePlanes);
        contents.emplace_back("XrScenePlaneMSFT*", sceneplanes_prefix, oss_scenePlanes.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrScenePlaneAlignmentFilterInfoMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string alignmentcount_prefix = prefix;
        alignmentcount_prefix += "alignmentCount";
        std::ostringstream oss_alignmentCount;
        oss_alignmentCount << "0x" << std::hex << (value->alignmentCount);
        contents.emplace_back("uint32_t", alignmentcount_prefix, oss_alignmentCount.str());
        std::string alignments_prefix = prefix;
        alignments_prefix += "alignments";
        std::ostringstream oss_alignments_array;
        oss_alignments_array << std::hex << reinterpret_cast<const void*>(value->alignments);
        contents.emplace_back("const XrScenePlaneAlignmentTypeMSFT*", alignments_prefix, oss_alignments_array.str());
        for (uint32_t value_alignments_inc = 0; value_alignments_inc < value->alignmentCount; ++value_alignments_inc) {
            std::string alignments_array_prefix = alignments_prefix;
            alignments_array_prefix += "[";
            alignments_array_prefix += std::to_string(value_alignments_inc);
            alignments_array_prefix += "]";
            contents.emplace_back("const XrScenePlaneAlignmentTypeMSFT*", alignments_array_prefix, std::to_string(value->alignments[value_alignments_inc]));
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSceneMeshMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string meshbufferid_prefix = prefix;
        meshbufferid_prefix += "meshBufferId";
        std::ostringstream oss_meshBufferId;
        oss_meshBufferId << "0x" << std::hex << (value->meshBufferId);
        contents.emplace_back("uint64_t", meshbufferid_prefix, oss_meshBufferId.str());
        std::string supportsindicesuint16_prefix = prefix;
        supportsindicesuint16_prefix += "supportsIndicesUint16";
        std::ostringstream oss_supportsIndicesUint16;
        oss_supportsIndicesUint16 << "0x" << std::hex << (value->supportsIndicesUint16);
        contents.emplace_back("XrBool32", supportsindicesuint16_prefix, oss_supportsIndicesUint16.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSceneMeshesMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string scenemeshcount_prefix = prefix;
        scenemeshcount_prefix += "sceneMeshCount";
        std::ostringstream oss_sceneMeshCount;
        oss_sceneMeshCount << "0x" << std::hex << (value->sceneMeshCount);
        contents.emplace_back("uint32_t", scenemeshcount_prefix, oss_sceneMeshCount.str());
        std::string scenemeshes_prefix = prefix;
        scenemeshes_prefix += "sceneMeshes";
        std::ostringstream oss_sceneMeshes;
        oss_sceneMeshes << std::hex << reinterpret_cast<const void*>(value->sceneMeshes);
        contents.emplace_back("XrSceneMeshMSFT*", scenemeshes_prefix, oss_sceneMeshes.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSceneMeshBuffersGetInfoMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string meshbufferid_prefix = prefix;
        meshbufferid_prefix += "meshBufferId";
        std::ostringstream oss_meshBufferId;
        oss_meshBufferId << "0x" << std::hex << (value->meshBufferId);
        contents.emplace_back("uint64_t", meshbufferid_prefix, oss_meshBufferId.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSceneMeshBuffersMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSceneMeshVertexBufferMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string vertexcapacityinput_prefix = prefix;
        vertexcapacityinput_prefix += "vertexCapacityInput";
        std::ostringstream oss_vertexCapacityInput;
        oss_vertexCapacityInput << "0x" << std::hex << (value->vertexCapacityInput);
        contents.emplace_back("uint32_t", vertexcapacityinput_prefix, oss_vertexCapacityInput.str());
        std::string vertexcountoutput_prefix = prefix;
        vertexcountoutput_prefix += "vertexCountOutput";
        std::ostringstream oss_vertexCountOutput;
        oss_vertexCountOutput << "0x" << std::hex << (value->vertexCountOutput);
        contents.emplace_back("uint32_t", vertexcountoutput_prefix, oss_vertexCountOutput.str());
        std::string vertices_prefix = prefix;
        vertices_prefix += "vertices";
        std::ostringstream oss_vertices;
        oss_vertices << std::hex << reinterpret_cast<const void*>(value->vertices);
        contents.emplace_back("XrVector3f*", vertices_prefix, oss_vertices.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSceneMeshIndicesUint32MSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string indexcapacityinput_prefix = prefix;
        indexcapacityinput_prefix += "indexCapacityInput";
        std::ostringstream oss_indexCapacityInput;
        oss_indexCapacityInput << "0x" << std::hex << (value->indexCapacityInput);
        contents.emplace_back("uint32_t", indexcapacityinput_prefix, oss_indexCapacityInput.str());
        std::string indexcountoutput_prefix = prefix;
        indexcountoutput_prefix += "indexCountOutput";
        std::ostringstream oss_indexCountOutput;
        oss_indexCountOutput << "0x" << std::hex << (value->indexCountOutput);
        contents.emplace_back("uint32_t", indexcountoutput_prefix, oss_indexCountOutput.str());
        std::string indices_prefix = prefix;
        indices_prefix += "indices";
        std::ostringstream oss_indices;
        oss_indices << "0x" << std::hex << (value->indices);
        contents.emplace_back("uint32_t*", indices_prefix, oss_indices.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSceneMeshIndicesUint16MSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string indexcapacityinput_prefix = prefix;
        indexcapacityinput_prefix += "indexCapacityInput";
        std::ostringstream oss_indexCapacityInput;
        oss_indexCapacityInput << "0x" << std::hex << (value->indexCapacityInput);
        contents.emplace_back("uint32_t", indexcapacityinput_prefix, oss_indexCapacityInput.str());
        std::string indexcountoutput_prefix = prefix;
        indexcountoutput_prefix += "indexCountOutput";
        std::ostringstream oss_indexCountOutput;
        oss_indexCountOutput << "0x" << std::hex << (value->indexCountOutput);
        contents.emplace_back("uint32_t", indexcountoutput_prefix, oss_indexCountOutput.str());
        std::string indices_prefix = prefix;
        indices_prefix += "indices";
        std::ostringstream oss_indices;
        oss_indices << "0x" << std::hex << (value->indices);
        contents.emplace_back("uint16_t*", indices_prefix, oss_indices.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSerializedSceneFragmentDataGetInfoMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string scenefragmentid_prefix = prefix;
        scenefragmentid_prefix += "sceneFragmentId";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->sceneFragmentId, scenefragmentid_prefix, "XrUuidMSFT", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrDeserializeSceneFragmentMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string buffersize_prefix = prefix;
        buffersize_prefix += "bufferSize";
        std::ostringstream oss_bufferSize;
        oss_bufferSize << "0x" << std::hex << (value->bufferSize);
        contents.emplace_back("uint32_t", buffersize_prefix, oss_bufferSize.str());
        std::string buffer_prefix = prefix;
        buffer_prefix += "buffer";
        std::ostringstream oss_buffer_array;
        oss_buffer_array << std::hex << (value->buffer);
        contents.emplace_back("const uint8_t*", buffer_prefix, oss_buffer_array.str());
        for (uint32_t value_buffer_inc = 0; value_buffer_inc < value->bufferSize; ++value_buffer_inc) {
            std::string buffer_array_prefix = buffer_prefix;
            buffer_array_prefix += "[";
            buffer_array_prefix += std::to_string(value_buffer_inc);
            buffer_array_prefix += "]";
            std::ostringstream oss_buffer;
            oss_buffer << "0x" << std::hex << (value->buffer[value_buffer_inc]);
            contents.emplace_back("const uint8_t*", buffer_array_prefix, oss_buffer.str());
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSceneDeserializeInfoMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string fragmentcount_prefix = prefix;
        fragmentcount_prefix += "fragmentCount";
        std::ostringstream oss_fragmentCount;
        oss_fragmentCount << "0x" << std::hex << (value->fragmentCount);
        contents.emplace_back("uint32_t", fragmentcount_prefix, oss_fragmentCount.str());
        std::string fragments_prefix = prefix;
        fragments_prefix += "fragments";
        std::ostringstream oss_fragments_array;
        oss_fragments_array << std::hex << reinterpret_cast<const void*>(value->fragments);
        contents.emplace_back("const XrDeserializeSceneFragmentMSFT*", fragments_prefix, oss_fragments_array.str());
        for (uint32_t value_fragments_inc = 0; value_fragments_inc < value->fragmentCount; ++value_fragments_inc) {
            std::string fragments_array_prefix = fragments_prefix;
            fragments_array_prefix += "[";
            fragments_array_prefix += std::to_string(value_fragments_inc);
            fragments_array_prefix += "]";
            if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->fragments[value_fragments_inc], fragments_array_prefix, "const XrDeserializeSceneFragmentMSFT*", false, contents)) {
                throw std::invalid_argument("Invalid Operation");
            }
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEventDataDisplayRefreshRateChangedFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string fromdisplayrefreshrate_prefix = prefix;
        fromdisplayrefreshrate_prefix += "fromDisplayRefreshRate";
        std::ostringstream oss_fromDisplayRefreshRate;
        oss_fromDisplayRefreshRate << std::setprecision(32) << (value->fromDisplayRefreshRate);
        contents.emplace_back("float", fromdisplayrefreshrate_prefix, oss_fromDisplayRefreshRate.str());
        std::string todisplayrefreshrate_prefix = prefix;
        todisplayrefreshrate_prefix += "toDisplayRefreshRate";
        std::ostringstream oss_toDisplayRefreshRate;
        oss_toDisplayRefreshRate << std::setprecision(32) << (value->toDisplayRefreshRate);
        contents.emplace_back("float", todisplayrefreshrate_prefix, oss_toDisplayRefreshRate.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrViveTrackerPathsHTCX* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string persistentpath_prefix = prefix;
        persistentpath_prefix += "persistentPath";
        contents.emplace_back("XrPath", persistentpath_prefix, std::to_string(value->persistentPath));
        std::string rolepath_prefix = prefix;
        rolepath_prefix += "rolePath";
        contents.emplace_back("XrPath", rolepath_prefix, std::to_string(value->rolePath));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEventDataViveTrackerConnectedHTCX* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string paths_prefix = prefix;
        paths_prefix += "paths";
        std::ostringstream oss_paths;
        oss_paths << std::hex << reinterpret_cast<const void*>(value->paths);
        contents.emplace_back("XrViveTrackerPathsHTCX*", paths_prefix, oss_paths.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSystemFacialTrackingPropertiesHTC* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string supporteyefacialtracking_prefix = prefix;
        supporteyefacialtracking_prefix += "supportEyeFacialTracking";
        std::ostringstream oss_supportEyeFacialTracking;
        oss_supportEyeFacialTracking << "0x" << std::hex << (value->supportEyeFacialTracking);
        contents.emplace_back("XrBool32", supporteyefacialtracking_prefix, oss_supportEyeFacialTracking.str());
        std::string supportlipfacialtracking_prefix = prefix;
        supportlipfacialtracking_prefix += "supportLipFacialTracking";
        std::ostringstream oss_supportLipFacialTracking;
        oss_supportLipFacialTracking << "0x" << std::hex << (value->supportLipFacialTracking);
        contents.emplace_back("XrBool32", supportlipfacialtracking_prefix, oss_supportLipFacialTracking.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrFacialExpressionsHTC* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string isactive_prefix = prefix;
        isactive_prefix += "isActive";
        std::ostringstream oss_isActive;
        oss_isActive << "0x" << std::hex << (value->isActive);
        contents.emplace_back("XrBool32", isactive_prefix, oss_isActive.str());
        std::string sampletime_prefix = prefix;
        sampletime_prefix += "sampleTime";
        contents.emplace_back("XrTime", sampletime_prefix, std::to_string(value->sampleTime));
        std::string expressioncount_prefix = prefix;
        expressioncount_prefix += "expressionCount";
        std::ostringstream oss_expressionCount;
        oss_expressionCount << "0x" << std::hex << (value->expressionCount);
        contents.emplace_back("uint32_t", expressioncount_prefix, oss_expressionCount.str());
        std::string expressionweightings_prefix = prefix;
        expressionweightings_prefix += "expressionWeightings";
        std::ostringstream oss_expressionWeightings;
        oss_expressionWeightings << std::setprecision(32) << (value->expressionWeightings);
        contents.emplace_back("float*", expressionweightings_prefix, oss_expressionWeightings.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrFacialTrackerCreateInfoHTC* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string facialtrackingtype_prefix = prefix;
        facialtrackingtype_prefix += "facialTrackingType";
        contents.emplace_back("XrFacialTrackingTypeHTC", facialtrackingtype_prefix, std::to_string(value->facialTrackingType));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSystemColorSpacePropertiesFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string colorspace_prefix = prefix;
        colorspace_prefix += "colorSpace";
        contents.emplace_back("XrColorSpaceFB", colorspace_prefix, std::to_string(value->colorSpace));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrVector4sFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string x_prefix = prefix;
        x_prefix += "x";
        contents.emplace_back("int16_t", x_prefix, std::to_string(value->x));
        std::string y_prefix = prefix;
        y_prefix += "y";
        contents.emplace_back("int16_t", y_prefix, std::to_string(value->y));
        std::string z_prefix = prefix;
        z_prefix += "z";
        contents.emplace_back("int16_t", z_prefix, std::to_string(value->z));
        std::string w_prefix = prefix;
        w_prefix += "w";
        contents.emplace_back("int16_t", w_prefix, std::to_string(value->w));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrHandTrackingMeshFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string jointcapacityinput_prefix = prefix;
        jointcapacityinput_prefix += "jointCapacityInput";
        std::ostringstream oss_jointCapacityInput;
        oss_jointCapacityInput << "0x" << std::hex << (value->jointCapacityInput);
        contents.emplace_back("uint32_t", jointcapacityinput_prefix, oss_jointCapacityInput.str());
        std::string jointcountoutput_prefix = prefix;
        jointcountoutput_prefix += "jointCountOutput";
        std::ostringstream oss_jointCountOutput;
        oss_jointCountOutput << "0x" << std::hex << (value->jointCountOutput);
        contents.emplace_back("uint32_t", jointcountoutput_prefix, oss_jointCountOutput.str());
        std::string jointbindposes_prefix = prefix;
        jointbindposes_prefix += "jointBindPoses";
        std::ostringstream oss_jointBindPoses;
        oss_jointBindPoses << std::hex << reinterpret_cast<const void*>(value->jointBindPoses);
        contents.emplace_back("XrPosef*", jointbindposes_prefix, oss_jointBindPoses.str());
        std::string jointradii_prefix = prefix;
        jointradii_prefix += "jointRadii";
        std::ostringstream oss_jointRadii;
        oss_jointRadii << std::setprecision(32) << (value->jointRadii);
        contents.emplace_back("float*", jointradii_prefix, oss_jointRadii.str());
        std::string jointparents_prefix = prefix;
        jointparents_prefix += "jointParents";
        std::ostringstream oss_jointParents;
        oss_jointParents << std::hex << reinterpret_cast<const void*>(value->jointParents);
        contents.emplace_back("XrHandJointEXT*", jointparents_prefix, oss_jointParents.str());
        std::string vertexcapacityinput_prefix = prefix;
        vertexcapacityinput_prefix += "vertexCapacityInput";
        std::ostringstream oss_vertexCapacityInput;
        oss_vertexCapacityInput << "0x" << std::hex << (value->vertexCapacityInput);
        contents.emplace_back("uint32_t", vertexcapacityinput_prefix, oss_vertexCapacityInput.str());
        std::string vertexcountoutput_prefix = prefix;
        vertexcountoutput_prefix += "vertexCountOutput";
        std::ostringstream oss_vertexCountOutput;
        oss_vertexCountOutput << "0x" << std::hex << (value->vertexCountOutput);
        contents.emplace_back("uint32_t", vertexcountoutput_prefix, oss_vertexCountOutput.str());
        std::string vertexpositions_prefix = prefix;
        vertexpositions_prefix += "vertexPositions";
        std::ostringstream oss_vertexPositions;
        oss_vertexPositions << std::hex << reinterpret_cast<const void*>(value->vertexPositions);
        contents.emplace_back("XrVector3f*", vertexpositions_prefix, oss_vertexPositions.str());
        std::string vertexnormals_prefix = prefix;
        vertexnormals_prefix += "vertexNormals";
        std::ostringstream oss_vertexNormals;
        oss_vertexNormals << std::hex << reinterpret_cast<const void*>(value->vertexNormals);
        contents.emplace_back("XrVector3f*", vertexnormals_prefix, oss_vertexNormals.str());
        std::string vertexuvs_prefix = prefix;
        vertexuvs_prefix += "vertexUVs";
        std::ostringstream oss_vertexUVs;
        oss_vertexUVs << std::hex << reinterpret_cast<const void*>(value->vertexUVs);
        contents.emplace_back("XrVector2f*", vertexuvs_prefix, oss_vertexUVs.str());
        std::string vertexblendindices_prefix = prefix;
        vertexblendindices_prefix += "vertexBlendIndices";
        std::ostringstream oss_vertexBlendIndices;
        oss_vertexBlendIndices << std::hex << reinterpret_cast<const void*>(value->vertexBlendIndices);
        contents.emplace_back("XrVector4sFB*", vertexblendindices_prefix, oss_vertexBlendIndices.str());
        std::string vertexblendweights_prefix = prefix;
        vertexblendweights_prefix += "vertexBlendWeights";
        std::ostringstream oss_vertexBlendWeights;
        oss_vertexBlendWeights << std::hex << reinterpret_cast<const void*>(value->vertexBlendWeights);
        contents.emplace_back("XrVector4f*", vertexblendweights_prefix, oss_vertexBlendWeights.str());
        std::string indexcapacityinput_prefix = prefix;
        indexcapacityinput_prefix += "indexCapacityInput";
        std::ostringstream oss_indexCapacityInput;
        oss_indexCapacityInput << "0x" << std::hex << (value->indexCapacityInput);
        contents.emplace_back("uint32_t", indexcapacityinput_prefix, oss_indexCapacityInput.str());
        std::string indexcountoutput_prefix = prefix;
        indexcountoutput_prefix += "indexCountOutput";
        std::ostringstream oss_indexCountOutput;
        oss_indexCountOutput << "0x" << std::hex << (value->indexCountOutput);
        contents.emplace_back("uint32_t", indexcountoutput_prefix, oss_indexCountOutput.str());
        std::string indices_prefix = prefix;
        indices_prefix += "indices";
        std::ostringstream oss_indices;
        oss_indices << std::hex << reinterpret_cast<const void*>(value->indices);
        contents.emplace_back("int16_t*", indices_prefix, oss_indices.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrHandTrackingScaleFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string sensoroutput_prefix = prefix;
        sensoroutput_prefix += "sensorOutput";
        std::ostringstream oss_sensorOutput;
        oss_sensorOutput << std::setprecision(32) << (value->sensorOutput);
        contents.emplace_back("float", sensoroutput_prefix, oss_sensorOutput.str());
        std::string currentoutput_prefix = prefix;
        currentoutput_prefix += "currentOutput";
        std::ostringstream oss_currentOutput;
        oss_currentOutput << std::setprecision(32) << (value->currentOutput);
        contents.emplace_back("float", currentoutput_prefix, oss_currentOutput.str());
        std::string overridehandscale_prefix = prefix;
        overridehandscale_prefix += "overrideHandScale";
        std::ostringstream oss_overrideHandScale;
        oss_overrideHandScale << "0x" << std::hex << (value->overrideHandScale);
        contents.emplace_back("XrBool32", overridehandscale_prefix, oss_overrideHandScale.str());
        std::string overridevalueinput_prefix = prefix;
        overridevalueinput_prefix += "overrideValueInput";
        std::ostringstream oss_overrideValueInput;
        oss_overrideValueInput << std::setprecision(32) << (value->overrideValueInput);
        contents.emplace_back("float", overridevalueinput_prefix, oss_overrideValueInput.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrHandTrackingAimStateFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string status_prefix = prefix;
        status_prefix += "status";
        contents.emplace_back("XrHandTrackingAimFlagsFB", status_prefix, std::to_string(value->status));
        std::string aimpose_prefix = prefix;
        aimpose_prefix += "aimPose";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->aimPose, aimpose_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string pinchstrengthindex_prefix = prefix;
        pinchstrengthindex_prefix += "pinchStrengthIndex";
        std::ostringstream oss_pinchStrengthIndex;
        oss_pinchStrengthIndex << std::setprecision(32) << (value->pinchStrengthIndex);
        contents.emplace_back("float", pinchstrengthindex_prefix, oss_pinchStrengthIndex.str());
        std::string pinchstrengthmiddle_prefix = prefix;
        pinchstrengthmiddle_prefix += "pinchStrengthMiddle";
        std::ostringstream oss_pinchStrengthMiddle;
        oss_pinchStrengthMiddle << std::setprecision(32) << (value->pinchStrengthMiddle);
        contents.emplace_back("float", pinchstrengthmiddle_prefix, oss_pinchStrengthMiddle.str());
        std::string pinchstrengthring_prefix = prefix;
        pinchstrengthring_prefix += "pinchStrengthRing";
        std::ostringstream oss_pinchStrengthRing;
        oss_pinchStrengthRing << std::setprecision(32) << (value->pinchStrengthRing);
        contents.emplace_back("float", pinchstrengthring_prefix, oss_pinchStrengthRing.str());
        std::string pinchstrengthlittle_prefix = prefix;
        pinchstrengthlittle_prefix += "pinchStrengthLittle";
        std::ostringstream oss_pinchStrengthLittle;
        oss_pinchStrengthLittle << std::setprecision(32) << (value->pinchStrengthLittle);
        contents.emplace_back("float", pinchstrengthlittle_prefix, oss_pinchStrengthLittle.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrHandCapsuleFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string points_prefix = prefix;
        points_prefix += "points";
        std::ostringstream oss_points_array;
        oss_points_array << std::hex << reinterpret_cast<const void*>(value->points);
        contents.emplace_back("XrVector3f*", points_prefix, oss_points_array.str());
        for (uint32_t value_points_inc = 0; value_points_inc < XR_HAND_TRACKING_CAPSULE_POINT_COUNT_FB; ++value_points_inc) {
            std::string points_array_prefix = points_prefix;
            points_array_prefix += "[";
            points_array_prefix += std::to_string(value_points_inc);
            points_array_prefix += "]";
            if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->points[value_points_inc], points_array_prefix, "XrVector3f", false, contents)) {
                throw std::invalid_argument("Invalid Operation");
            }
        }
        std::string radius_prefix = prefix;
        radius_prefix += "radius";
        std::ostringstream oss_radius;
        oss_radius << std::setprecision(32) << (value->radius);
        contents.emplace_back("float", radius_prefix, oss_radius.str());
        std::string joint_prefix = prefix;
        joint_prefix += "joint";
        contents.emplace_back("XrHandJointEXT", joint_prefix, std::to_string(value->joint));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrHandTrackingCapsulesStateFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string capsules_prefix = prefix;
        capsules_prefix += "capsules";
        std::ostringstream oss_capsules;
        oss_capsules << std::hex << reinterpret_cast<const void*>(value->capsules);
        contents.emplace_back("XrHandCapsuleFB*", capsules_prefix, oss_capsules.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSystemSpatialEntityPropertiesFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string supportsspatialentity_prefix = prefix;
        supportsspatialentity_prefix += "supportsSpatialEntity";
        std::ostringstream oss_supportsSpatialEntity;
        oss_supportsSpatialEntity << "0x" << std::hex << (value->supportsSpatialEntity);
        contents.emplace_back("XrBool32", supportsspatialentity_prefix, oss_supportsSpatialEntity.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpatialAnchorCreateInfoFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string space_prefix = prefix;
        space_prefix += "space";
        std::ostringstream oss_space;
        oss_space << std::hex << reinterpret_cast<const void*>(value->space);
        contents.emplace_back("XrSpace", space_prefix, oss_space.str());
        std::string poseinspace_prefix = prefix;
        poseinspace_prefix += "poseInSpace";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->poseInSpace, poseinspace_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string time_prefix = prefix;
        time_prefix += "time";
        contents.emplace_back("XrTime", time_prefix, std::to_string(value->time));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpaceComponentStatusSetInfoFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string componenttype_prefix = prefix;
        componenttype_prefix += "componentType";
        contents.emplace_back("XrSpaceComponentTypeFB", componenttype_prefix, std::to_string(value->componentType));
        std::string enabled_prefix = prefix;
        enabled_prefix += "enabled";
        std::ostringstream oss_enabled;
        oss_enabled << "0x" << std::hex << (value->enabled);
        contents.emplace_back("XrBool32", enabled_prefix, oss_enabled.str());
        std::string timeout_prefix = prefix;
        timeout_prefix += "timeout";
        contents.emplace_back("XrDuration", timeout_prefix, std::to_string(value->timeout));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpaceComponentStatusFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string enabled_prefix = prefix;
        enabled_prefix += "enabled";
        std::ostringstream oss_enabled;
        oss_enabled << "0x" << std::hex << (value->enabled);
        contents.emplace_back("XrBool32", enabled_prefix, oss_enabled.str());
        std::string changepending_prefix = prefix;
        changepending_prefix += "changePending";
        std::ostringstream oss_changePending;
        oss_changePending << "0x" << std::hex << (value->changePending);
        contents.emplace_back("XrBool32", changepending_prefix, oss_changePending.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEventDataSpatialAnchorCreateCompleteFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string requestid_prefix = prefix;
        requestid_prefix += "requestId";
        contents.emplace_back("XrAsyncRequestIdFB", requestid_prefix, std::to_string(value->requestId));
        std::string result_prefix = prefix;
        result_prefix += "result";
        if (nullptr != gen_dispatch_table) {
            char result_string[XR_MAX_RESULT_STRING_SIZE] = {};
            gen_dispatch_table->ResultToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                               value->result, result_string);
            contents.emplace_back("XrResult", result_prefix, result_string);
        } else {
                        contents.emplace_back("XrResult", result_prefix, std::to_string(value->result));
        }
        std::string space_prefix = prefix;
        space_prefix += "space";
        std::ostringstream oss_space;
        oss_space << std::hex << reinterpret_cast<const void*>(value->space);
        contents.emplace_back("XrSpace", space_prefix, oss_space.str());
        std::string uuid_prefix = prefix;
        uuid_prefix += "uuid";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->uuid, uuid_prefix, "XrUuidEXT", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEventDataSpaceSetStatusCompleteFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string requestid_prefix = prefix;
        requestid_prefix += "requestId";
        contents.emplace_back("XrAsyncRequestIdFB", requestid_prefix, std::to_string(value->requestId));
        std::string result_prefix = prefix;
        result_prefix += "result";
        if (nullptr != gen_dispatch_table) {
            char result_string[XR_MAX_RESULT_STRING_SIZE] = {};
            gen_dispatch_table->ResultToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                               value->result, result_string);
            contents.emplace_back("XrResult", result_prefix, result_string);
        } else {
                        contents.emplace_back("XrResult", result_prefix, std::to_string(value->result));
        }
        std::string space_prefix = prefix;
        space_prefix += "space";
        std::ostringstream oss_space;
        oss_space << std::hex << reinterpret_cast<const void*>(value->space);
        contents.emplace_back("XrSpace", space_prefix, oss_space.str());
        std::string uuid_prefix = prefix;
        uuid_prefix += "uuid";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->uuid, uuid_prefix, "XrUuidEXT", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string componenttype_prefix = prefix;
        componenttype_prefix += "componentType";
        contents.emplace_back("XrSpaceComponentTypeFB", componenttype_prefix, std::to_string(value->componentType));
        std::string enabled_prefix = prefix;
        enabled_prefix += "enabled";
        std::ostringstream oss_enabled;
        oss_enabled << "0x" << std::hex << (value->enabled);
        contents.emplace_back("XrBool32", enabled_prefix, oss_enabled.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrFoveationProfileCreateInfoFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSwapchainCreateInfoFoveationFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string flags_prefix = prefix;
        flags_prefix += "flags";
        contents.emplace_back("XrSwapchainCreateFoveationFlagsFB", flags_prefix, std::to_string(value->flags));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSwapchainStateFoveationFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string flags_prefix = prefix;
        flags_prefix += "flags";
        contents.emplace_back("XrSwapchainStateFoveationFlagsFB", flags_prefix, std::to_string(value->flags));
        std::string profile_prefix = prefix;
        profile_prefix += "profile";
        std::ostringstream oss_profile;
        oss_profile << std::hex << reinterpret_cast<const void*>(value->profile);
        contents.emplace_back("XrFoveationProfileFB", profile_prefix, oss_profile.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrFoveationLevelProfileCreateInfoFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string level_prefix = prefix;
        level_prefix += "level";
        contents.emplace_back("XrFoveationLevelFB", level_prefix, std::to_string(value->level));
        std::string verticaloffset_prefix = prefix;
        verticaloffset_prefix += "verticalOffset";
        std::ostringstream oss_verticalOffset;
        oss_verticalOffset << std::setprecision(32) << (value->verticalOffset);
        contents.emplace_back("float", verticaloffset_prefix, oss_verticalOffset.str());
        std::string dynamic_prefix = prefix;
        dynamic_prefix += "dynamic";
        contents.emplace_back("XrFoveationDynamicFB", dynamic_prefix, std::to_string(value->dynamic));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSystemKeyboardTrackingPropertiesFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string supportskeyboardtracking_prefix = prefix;
        supportskeyboardtracking_prefix += "supportsKeyboardTracking";
        std::ostringstream oss_supportsKeyboardTracking;
        oss_supportsKeyboardTracking << "0x" << std::hex << (value->supportsKeyboardTracking);
        contents.emplace_back("XrBool32", supportskeyboardtracking_prefix, oss_supportsKeyboardTracking.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrKeyboardTrackingDescriptionFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string trackedkeyboardid_prefix = prefix;
        trackedkeyboardid_prefix += "trackedKeyboardId";
        std::ostringstream oss_trackedKeyboardId;
        oss_trackedKeyboardId << "0x" << std::hex << (value->trackedKeyboardId);
        contents.emplace_back("uint64_t", trackedkeyboardid_prefix, oss_trackedKeyboardId.str());
        std::string size_prefix = prefix;
        size_prefix += "size";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->size, size_prefix, "XrVector3f", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string flags_prefix = prefix;
        flags_prefix += "flags";
        contents.emplace_back("XrKeyboardTrackingFlagsFB", flags_prefix, std::to_string(value->flags));
        std::string name_prefix = prefix;
        name_prefix += "name";
        contents.emplace_back("char*", name_prefix, value->name);
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrKeyboardSpaceCreateInfoFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string trackedkeyboardid_prefix = prefix;
        trackedkeyboardid_prefix += "trackedKeyboardId";
        std::ostringstream oss_trackedKeyboardId;
        oss_trackedKeyboardId << "0x" << std::hex << (value->trackedKeyboardId);
        contents.emplace_back("uint64_t", trackedkeyboardid_prefix, oss_trackedKeyboardId.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrKeyboardTrackingQueryFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string flags_prefix = prefix;
        flags_prefix += "flags";
        contents.emplace_back("XrKeyboardTrackingQueryFlagsFB", flags_prefix, std::to_string(value->flags));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrTriangleMeshCreateInfoFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string flags_prefix = prefix;
        flags_prefix += "flags";
        contents.emplace_back("XrTriangleMeshFlagsFB", flags_prefix, std::to_string(value->flags));
        std::string windingorder_prefix = prefix;
        windingorder_prefix += "windingOrder";
        contents.emplace_back("XrWindingOrderFB", windingorder_prefix, std::to_string(value->windingOrder));
        std::string vertexcount_prefix = prefix;
        vertexcount_prefix += "vertexCount";
        std::ostringstream oss_vertexCount;
        oss_vertexCount << "0x" << std::hex << (value->vertexCount);
        contents.emplace_back("uint32_t", vertexcount_prefix, oss_vertexCount.str());
        std::string vertexbuffer_prefix = prefix;
        vertexbuffer_prefix += "vertexBuffer";
        if (nullptr == value->vertexBuffer) {
            std::ostringstream oss_vertexBuffer;
            oss_vertexBuffer << std::hex << reinterpret_cast<const void*>(value->vertexBuffer);
            contents.emplace_back("const XrVector3f*", vertexbuffer_prefix, oss_vertexBuffer.str());
        } else if (!ApiDumpOutputXrStruct(gen_dispatch_table, value->vertexBuffer, vertexbuffer_prefix, "const XrVector3f*", true, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string trianglecount_prefix = prefix;
        trianglecount_prefix += "triangleCount";
        std::ostringstream oss_triangleCount;
        oss_triangleCount << "0x" << std::hex << (value->triangleCount);
        contents.emplace_back("uint32_t", trianglecount_prefix, oss_triangleCount.str());
        std::string indexbuffer_prefix = prefix;
        indexbuffer_prefix += "indexBuffer";
        if (nullptr == value->indexBuffer) {
            std::ostringstream oss_indexBuffer;
            oss_indexBuffer << std::hex << (value->indexBuffer);
            contents.emplace_back("const uint32_t*", indexbuffer_prefix, oss_indexBuffer.str());
        } else {
            std::ostringstream oss_indexBuffer;
            oss_indexBuffer << std::hex << (*value->indexBuffer);
            contents.emplace_back("const uint32_t*", indexbuffer_prefix, oss_indexBuffer.str());
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSystemPassthroughPropertiesFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string supportspassthrough_prefix = prefix;
        supportspassthrough_prefix += "supportsPassthrough";
        std::ostringstream oss_supportsPassthrough;
        oss_supportsPassthrough << "0x" << std::hex << (value->supportsPassthrough);
        contents.emplace_back("XrBool32", supportspassthrough_prefix, oss_supportsPassthrough.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSystemPassthroughProperties2FB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string capabilities_prefix = prefix;
        capabilities_prefix += "capabilities";
        contents.emplace_back("XrPassthroughCapabilityFlagsFB", capabilities_prefix, std::to_string(value->capabilities));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrPassthroughCreateInfoFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string flags_prefix = prefix;
        flags_prefix += "flags";
        contents.emplace_back("XrPassthroughFlagsFB", flags_prefix, std::to_string(value->flags));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrPassthroughLayerCreateInfoFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string passthrough_prefix = prefix;
        passthrough_prefix += "passthrough";
        std::ostringstream oss_passthrough;
        oss_passthrough << std::hex << reinterpret_cast<const void*>(value->passthrough);
        contents.emplace_back("XrPassthroughFB", passthrough_prefix, oss_passthrough.str());
        std::string flags_prefix = prefix;
        flags_prefix += "flags";
        contents.emplace_back("XrPassthroughFlagsFB", flags_prefix, std::to_string(value->flags));
        std::string purpose_prefix = prefix;
        purpose_prefix += "purpose";
        contents.emplace_back("XrPassthroughLayerPurposeFB", purpose_prefix, std::to_string(value->purpose));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrCompositionLayerPassthroughFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string flags_prefix = prefix;
        flags_prefix += "flags";
        contents.emplace_back("XrCompositionLayerFlags", flags_prefix, std::to_string(value->flags));
        std::string space_prefix = prefix;
        space_prefix += "space";
        std::ostringstream oss_space;
        oss_space << std::hex << reinterpret_cast<const void*>(value->space);
        contents.emplace_back("XrSpace", space_prefix, oss_space.str());
        std::string layerhandle_prefix = prefix;
        layerhandle_prefix += "layerHandle";
        std::ostringstream oss_layerHandle;
        oss_layerHandle << std::hex << reinterpret_cast<const void*>(value->layerHandle);
        contents.emplace_back("XrPassthroughLayerFB", layerhandle_prefix, oss_layerHandle.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrGeometryInstanceCreateInfoFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string layer_prefix = prefix;
        layer_prefix += "layer";
        std::ostringstream oss_layer;
        oss_layer << std::hex << reinterpret_cast<const void*>(value->layer);
        contents.emplace_back("XrPassthroughLayerFB", layer_prefix, oss_layer.str());
        std::string mesh_prefix = prefix;
        mesh_prefix += "mesh";
        std::ostringstream oss_mesh;
        oss_mesh << std::hex << reinterpret_cast<const void*>(value->mesh);
        contents.emplace_back("XrTriangleMeshFB", mesh_prefix, oss_mesh.str());
        std::string basespace_prefix = prefix;
        basespace_prefix += "baseSpace";
        std::ostringstream oss_baseSpace;
        oss_baseSpace << std::hex << reinterpret_cast<const void*>(value->baseSpace);
        contents.emplace_back("XrSpace", basespace_prefix, oss_baseSpace.str());
        std::string pose_prefix = prefix;
        pose_prefix += "pose";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->pose, pose_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string scale_prefix = prefix;
        scale_prefix += "scale";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->scale, scale_prefix, "XrVector3f", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrGeometryInstanceTransformFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string basespace_prefix = prefix;
        basespace_prefix += "baseSpace";
        std::ostringstream oss_baseSpace;
        oss_baseSpace << std::hex << reinterpret_cast<const void*>(value->baseSpace);
        contents.emplace_back("XrSpace", basespace_prefix, oss_baseSpace.str());
        std::string time_prefix = prefix;
        time_prefix += "time";
        contents.emplace_back("XrTime", time_prefix, std::to_string(value->time));
        std::string pose_prefix = prefix;
        pose_prefix += "pose";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->pose, pose_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string scale_prefix = prefix;
        scale_prefix += "scale";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->scale, scale_prefix, "XrVector3f", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrPassthroughStyleFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string textureopacityfactor_prefix = prefix;
        textureopacityfactor_prefix += "textureOpacityFactor";
        std::ostringstream oss_textureOpacityFactor;
        oss_textureOpacityFactor << std::setprecision(32) << (value->textureOpacityFactor);
        contents.emplace_back("float", textureopacityfactor_prefix, oss_textureOpacityFactor.str());
        std::string edgecolor_prefix = prefix;
        edgecolor_prefix += "edgeColor";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->edgeColor, edgecolor_prefix, "XrColor4f", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrPassthroughColorMapMonoToRgbaFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string texturecolormap_prefix = prefix;
        texturecolormap_prefix += "textureColorMap";
        std::ostringstream oss_textureColorMap_array;
        oss_textureColorMap_array << std::hex << reinterpret_cast<const void*>(value->textureColorMap);
        contents.emplace_back("XrColor4f*", texturecolormap_prefix, oss_textureColorMap_array.str());
        for (uint32_t value_texturecolormap_inc = 0; value_texturecolormap_inc < XR_PASSTHROUGH_COLOR_MAP_MONO_SIZE_FB; ++value_texturecolormap_inc) {
            std::string texturecolormap_array_prefix = texturecolormap_prefix;
            texturecolormap_array_prefix += "[";
            texturecolormap_array_prefix += std::to_string(value_texturecolormap_inc);
            texturecolormap_array_prefix += "]";
            if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->textureColorMap[value_texturecolormap_inc], texturecolormap_array_prefix, "XrColor4f", false, contents)) {
                throw std::invalid_argument("Invalid Operation");
            }
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrPassthroughColorMapMonoToMonoFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string texturecolormap_prefix = prefix;
        texturecolormap_prefix += "textureColorMap";
        std::ostringstream oss_textureColorMap_array;
        oss_textureColorMap_array << "0x" << std::hex << (value->textureColorMap);
        contents.emplace_back("uint8_t*", texturecolormap_prefix, oss_textureColorMap_array.str());
        for (uint32_t value_texturecolormap_inc = 0; value_texturecolormap_inc < XR_PASSTHROUGH_COLOR_MAP_MONO_SIZE_FB; ++value_texturecolormap_inc) {
            std::string texturecolormap_array_prefix = texturecolormap_prefix;
            texturecolormap_array_prefix += "[";
            texturecolormap_array_prefix += std::to_string(value_texturecolormap_inc);
            texturecolormap_array_prefix += "]";
            std::ostringstream oss_textureColorMap;
            oss_textureColorMap << "0x" << std::hex << (value->textureColorMap[value_texturecolormap_inc]);
            contents.emplace_back("uint8_t", texturecolormap_array_prefix, oss_textureColorMap.str());
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrPassthroughBrightnessContrastSaturationFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string brightness_prefix = prefix;
        brightness_prefix += "brightness";
        std::ostringstream oss_brightness;
        oss_brightness << std::setprecision(32) << (value->brightness);
        contents.emplace_back("float", brightness_prefix, oss_brightness.str());
        std::string contrast_prefix = prefix;
        contrast_prefix += "contrast";
        std::ostringstream oss_contrast;
        oss_contrast << std::setprecision(32) << (value->contrast);
        contents.emplace_back("float", contrast_prefix, oss_contrast.str());
        std::string saturation_prefix = prefix;
        saturation_prefix += "saturation";
        std::ostringstream oss_saturation;
        oss_saturation << std::setprecision(32) << (value->saturation);
        contents.emplace_back("float", saturation_prefix, oss_saturation.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEventDataPassthroughStateChangedFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string flags_prefix = prefix;
        flags_prefix += "flags";
        contents.emplace_back("XrPassthroughStateChangedFlagsFB", flags_prefix, std::to_string(value->flags));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrRenderModelPathInfoFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string path_prefix = prefix;
        path_prefix += "path";
        contents.emplace_back("XrPath", path_prefix, std::to_string(value->path));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrRenderModelPropertiesFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string vendorid_prefix = prefix;
        vendorid_prefix += "vendorId";
        std::ostringstream oss_vendorId;
        oss_vendorId << "0x" << std::hex << (value->vendorId);
        contents.emplace_back("uint32_t", vendorid_prefix, oss_vendorId.str());
        std::string modelname_prefix = prefix;
        modelname_prefix += "modelName";
        contents.emplace_back("char*", modelname_prefix, value->modelName);
        std::string modelkey_prefix = prefix;
        modelkey_prefix += "modelKey";
        contents.emplace_back("XrRenderModelKeyFB", modelkey_prefix, std::to_string(value->modelKey));
        std::string modelversion_prefix = prefix;
        modelversion_prefix += "modelVersion";
        std::ostringstream oss_modelVersion;
        oss_modelVersion << "0x" << std::hex << (value->modelVersion);
        contents.emplace_back("uint32_t", modelversion_prefix, oss_modelVersion.str());
        std::string flags_prefix = prefix;
        flags_prefix += "flags";
        contents.emplace_back("XrRenderModelFlagsFB", flags_prefix, std::to_string(value->flags));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrRenderModelBufferFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string buffercapacityinput_prefix = prefix;
        buffercapacityinput_prefix += "bufferCapacityInput";
        std::ostringstream oss_bufferCapacityInput;
        oss_bufferCapacityInput << "0x" << std::hex << (value->bufferCapacityInput);
        contents.emplace_back("uint32_t", buffercapacityinput_prefix, oss_bufferCapacityInput.str());
        std::string buffercountoutput_prefix = prefix;
        buffercountoutput_prefix += "bufferCountOutput";
        std::ostringstream oss_bufferCountOutput;
        oss_bufferCountOutput << "0x" << std::hex << (value->bufferCountOutput);
        contents.emplace_back("uint32_t", buffercountoutput_prefix, oss_bufferCountOutput.str());
        std::string buffer_prefix = prefix;
        buffer_prefix += "buffer";
        std::ostringstream oss_buffer;
        oss_buffer << "0x" << std::hex << (value->buffer);
        contents.emplace_back("uint8_t*", buffer_prefix, oss_buffer.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrRenderModelLoadInfoFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string modelkey_prefix = prefix;
        modelkey_prefix += "modelKey";
        contents.emplace_back("XrRenderModelKeyFB", modelkey_prefix, std::to_string(value->modelKey));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSystemRenderModelPropertiesFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string supportsrendermodelloading_prefix = prefix;
        supportsrendermodelloading_prefix += "supportsRenderModelLoading";
        std::ostringstream oss_supportsRenderModelLoading;
        oss_supportsRenderModelLoading << "0x" << std::hex << (value->supportsRenderModelLoading);
        contents.emplace_back("XrBool32", supportsrendermodelloading_prefix, oss_supportsRenderModelLoading.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrRenderModelCapabilitiesRequestFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string flags_prefix = prefix;
        flags_prefix += "flags";
        contents.emplace_back("XrRenderModelFlagsFB", flags_prefix, std::to_string(value->flags));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrViewLocateFoveatedRenderingVARJO* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string foveatedrenderingactive_prefix = prefix;
        foveatedrenderingactive_prefix += "foveatedRenderingActive";
        std::ostringstream oss_foveatedRenderingActive;
        oss_foveatedRenderingActive << "0x" << std::hex << (value->foveatedRenderingActive);
        contents.emplace_back("XrBool32", foveatedrenderingactive_prefix, oss_foveatedRenderingActive.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrFoveatedViewConfigurationViewVARJO* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string foveatedrenderingactive_prefix = prefix;
        foveatedrenderingactive_prefix += "foveatedRenderingActive";
        std::ostringstream oss_foveatedRenderingActive;
        oss_foveatedRenderingActive << "0x" << std::hex << (value->foveatedRenderingActive);
        contents.emplace_back("XrBool32", foveatedrenderingactive_prefix, oss_foveatedRenderingActive.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSystemFoveatedRenderingPropertiesVARJO* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string supportsfoveatedrendering_prefix = prefix;
        supportsfoveatedrendering_prefix += "supportsFoveatedRendering";
        std::ostringstream oss_supportsFoveatedRendering;
        oss_supportsFoveatedRendering << "0x" << std::hex << (value->supportsFoveatedRendering);
        contents.emplace_back("XrBool32", supportsfoveatedrendering_prefix, oss_supportsFoveatedRendering.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrCompositionLayerDepthTestVARJO* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string depthtestrangenearz_prefix = prefix;
        depthtestrangenearz_prefix += "depthTestRangeNearZ";
        std::ostringstream oss_depthTestRangeNearZ;
        oss_depthTestRangeNearZ << std::setprecision(32) << (value->depthTestRangeNearZ);
        contents.emplace_back("float", depthtestrangenearz_prefix, oss_depthTestRangeNearZ.str());
        std::string depthtestrangefarz_prefix = prefix;
        depthtestrangefarz_prefix += "depthTestRangeFarZ";
        std::ostringstream oss_depthTestRangeFarZ;
        oss_depthTestRangeFarZ << std::setprecision(32) << (value->depthTestRangeFarZ);
        contents.emplace_back("float", depthtestrangefarz_prefix, oss_depthTestRangeFarZ.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSystemMarkerTrackingPropertiesVARJO* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string supportsmarkertracking_prefix = prefix;
        supportsmarkertracking_prefix += "supportsMarkerTracking";
        std::ostringstream oss_supportsMarkerTracking;
        oss_supportsMarkerTracking << "0x" << std::hex << (value->supportsMarkerTracking);
        contents.emplace_back("XrBool32", supportsmarkertracking_prefix, oss_supportsMarkerTracking.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEventDataMarkerTrackingUpdateVARJO* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string markerid_prefix = prefix;
        markerid_prefix += "markerId";
        std::ostringstream oss_markerId;
        oss_markerId << "0x" << std::hex << (value->markerId);
        contents.emplace_back("uint64_t", markerid_prefix, oss_markerId.str());
        std::string isactive_prefix = prefix;
        isactive_prefix += "isActive";
        std::ostringstream oss_isActive;
        oss_isActive << "0x" << std::hex << (value->isActive);
        contents.emplace_back("XrBool32", isactive_prefix, oss_isActive.str());
        std::string ispredicted_prefix = prefix;
        ispredicted_prefix += "isPredicted";
        std::ostringstream oss_isPredicted;
        oss_isPredicted << "0x" << std::hex << (value->isPredicted);
        contents.emplace_back("XrBool32", ispredicted_prefix, oss_isPredicted.str());
        std::string time_prefix = prefix;
        time_prefix += "time";
        contents.emplace_back("XrTime", time_prefix, std::to_string(value->time));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrMarkerSpaceCreateInfoVARJO* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string markerid_prefix = prefix;
        markerid_prefix += "markerId";
        std::ostringstream oss_markerId;
        oss_markerId << "0x" << std::hex << (value->markerId);
        contents.emplace_back("uint64_t", markerid_prefix, oss_markerId.str());
        std::string poseinmarkerspace_prefix = prefix;
        poseinmarkerspace_prefix += "poseInMarkerSpace";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->poseInMarkerSpace, poseinmarkerspace_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrFrameEndInfoML* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string focusdistance_prefix = prefix;
        focusdistance_prefix += "focusDistance";
        std::ostringstream oss_focusDistance;
        oss_focusDistance << std::setprecision(32) << (value->focusDistance);
        contents.emplace_back("float", focusdistance_prefix, oss_focusDistance.str());
        std::string flags_prefix = prefix;
        flags_prefix += "flags";
        contents.emplace_back("XrFrameEndInfoFlagsML", flags_prefix, std::to_string(value->flags));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrGlobalDimmerFrameEndInfoML* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string dimmervalue_prefix = prefix;
        dimmervalue_prefix += "dimmerValue";
        std::ostringstream oss_dimmerValue;
        oss_dimmerValue << std::setprecision(32) << (value->dimmerValue);
        contents.emplace_back("float", dimmervalue_prefix, oss_dimmerValue.str());
        std::string flags_prefix = prefix;
        flags_prefix += "flags";
        contents.emplace_back("XrGlobalDimmerFrameEndInfoFlagsML", flags_prefix, std::to_string(value->flags));
        return true;
    } catch(...) {
    }
    return false;
}

#if defined(XR_USE_PLATFORM_ML)
bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrCoordinateSpaceCreateInfoML* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string cfuid_prefix = prefix;
        cfuid_prefix += "cfuid";
        contents.emplace_back("MLCoordinateFrameUID", cfuid_prefix, std::to_string(value->cfuid));
        std::string poseincoordinatespace_prefix = prefix;
        poseincoordinatespace_prefix += "poseInCoordinateSpace";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->poseInCoordinateSpace, poseincoordinatespace_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}
#endif // defined(XR_USE_PLATFORM_ML)

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSystemMarkerUnderstandingPropertiesML* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string supportsmarkerunderstanding_prefix = prefix;
        supportsmarkerunderstanding_prefix += "supportsMarkerUnderstanding";
        std::ostringstream oss_supportsMarkerUnderstanding;
        oss_supportsMarkerUnderstanding << "0x" << std::hex << (value->supportsMarkerUnderstanding);
        contents.emplace_back("XrBool32", supportsmarkerunderstanding_prefix, oss_supportsMarkerUnderstanding.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrMarkerDetectorCreateInfoML* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string profile_prefix = prefix;
        profile_prefix += "profile";
        contents.emplace_back("XrMarkerDetectorProfileML", profile_prefix, std::to_string(value->profile));
        std::string markertype_prefix = prefix;
        markertype_prefix += "markerType";
        contents.emplace_back("XrMarkerTypeML", markertype_prefix, std::to_string(value->markerType));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrMarkerDetectorArucoInfoML* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string arucodict_prefix = prefix;
        arucodict_prefix += "arucoDict";
        contents.emplace_back("XrMarkerArucoDictML", arucodict_prefix, std::to_string(value->arucoDict));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrMarkerDetectorSizeInfoML* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string markerlength_prefix = prefix;
        markerlength_prefix += "markerLength";
        std::ostringstream oss_markerLength;
        oss_markerLength << std::setprecision(32) << (value->markerLength);
        contents.emplace_back("float", markerlength_prefix, oss_markerLength.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrMarkerDetectorAprilTagInfoML* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string apriltagdict_prefix = prefix;
        apriltagdict_prefix += "aprilTagDict";
        contents.emplace_back("XrMarkerAprilTagDictML", apriltagdict_prefix, std::to_string(value->aprilTagDict));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrMarkerDetectorCustomProfileInfoML* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string fpshint_prefix = prefix;
        fpshint_prefix += "fpsHint";
        contents.emplace_back("XrMarkerDetectorFpsML", fpshint_prefix, std::to_string(value->fpsHint));
        std::string resolutionhint_prefix = prefix;
        resolutionhint_prefix += "resolutionHint";
        contents.emplace_back("XrMarkerDetectorResolutionML", resolutionhint_prefix, std::to_string(value->resolutionHint));
        std::string camerahint_prefix = prefix;
        camerahint_prefix += "cameraHint";
        contents.emplace_back("XrMarkerDetectorCameraML", camerahint_prefix, std::to_string(value->cameraHint));
        std::string cornerrefinemethod_prefix = prefix;
        cornerrefinemethod_prefix += "cornerRefineMethod";
        contents.emplace_back("XrMarkerDetectorCornerRefineMethodML", cornerrefinemethod_prefix, std::to_string(value->cornerRefineMethod));
        std::string useedgerefinement_prefix = prefix;
        useedgerefinement_prefix += "useEdgeRefinement";
        std::ostringstream oss_useEdgeRefinement;
        oss_useEdgeRefinement << "0x" << std::hex << (value->useEdgeRefinement);
        contents.emplace_back("XrBool32", useedgerefinement_prefix, oss_useEdgeRefinement.str());
        std::string fullanalysisintervalhint_prefix = prefix;
        fullanalysisintervalhint_prefix += "fullAnalysisIntervalHint";
        contents.emplace_back("XrMarkerDetectorFullAnalysisIntervalML", fullanalysisintervalhint_prefix, std::to_string(value->fullAnalysisIntervalHint));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrMarkerDetectorSnapshotInfoML* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrMarkerDetectorStateML* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string state_prefix = prefix;
        state_prefix += "state";
        contents.emplace_back("XrMarkerDetectorStatusML", state_prefix, std::to_string(value->state));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrMarkerSpaceCreateInfoML* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string markerdetector_prefix = prefix;
        markerdetector_prefix += "markerDetector";
        std::ostringstream oss_markerDetector;
        oss_markerDetector << std::hex << reinterpret_cast<const void*>(value->markerDetector);
        contents.emplace_back("XrMarkerDetectorML", markerdetector_prefix, oss_markerDetector.str());
        std::string marker_prefix = prefix;
        marker_prefix += "marker";
        contents.emplace_back("XrMarkerML", marker_prefix, std::to_string(value->marker));
        std::string poseinmarkerspace_prefix = prefix;
        poseinmarkerspace_prefix += "poseInMarkerSpace";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->poseInMarkerSpace, poseinmarkerspace_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrLocalizationMapML* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string name_prefix = prefix;
        name_prefix += "name";
        contents.emplace_back("char*", name_prefix, value->name);
        std::string mapuuid_prefix = prefix;
        mapuuid_prefix += "mapUuid";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->mapUuid, mapuuid_prefix, "XrUuidEXT", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string maptype_prefix = prefix;
        maptype_prefix += "mapType";
        contents.emplace_back("XrLocalizationMapTypeML", maptype_prefix, std::to_string(value->mapType));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEventDataLocalizationChangedML* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string session_prefix = prefix;
        session_prefix += "session";
        std::ostringstream oss_session;
        oss_session << std::hex << reinterpret_cast<const void*>(value->session);
        contents.emplace_back("XrSession", session_prefix, oss_session.str());
        std::string state_prefix = prefix;
        state_prefix += "state";
        contents.emplace_back("XrLocalizationMapStateML", state_prefix, std::to_string(value->state));
        std::string map_prefix = prefix;
        map_prefix += "map";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->map, map_prefix, "XrLocalizationMapML", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string confidence_prefix = prefix;
        confidence_prefix += "confidence";
        contents.emplace_back("XrLocalizationMapConfidenceML", confidence_prefix, std::to_string(value->confidence));
        std::string errorflags_prefix = prefix;
        errorflags_prefix += "errorFlags";
        contents.emplace_back("XrLocalizationMapErrorFlagsML", errorflags_prefix, std::to_string(value->errorFlags));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrLocalizationMapQueryInfoBaseHeaderML* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        // Fallback path - Just output generic information about the base struct
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrMapLocalizationRequestInfoML* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string mapuuid_prefix = prefix;
        mapuuid_prefix += "mapUuid";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->mapUuid, mapuuid_prefix, "XrUuidEXT", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrLocalizationMapImportInfoML* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string size_prefix = prefix;
        size_prefix += "size";
        std::ostringstream oss_size;
        oss_size << "0x" << std::hex << (value->size);
        contents.emplace_back("uint32_t", size_prefix, oss_size.str());
        std::string data_prefix = prefix;
        data_prefix += "data";
        contents.emplace_back("char*", data_prefix, (value->data ? value->data : "(nullptr)"));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrLocalizationEnableEventsInfoML* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string enabled_prefix = prefix;
        enabled_prefix += "enabled";
        std::ostringstream oss_enabled;
        oss_enabled << "0x" << std::hex << (value->enabled);
        contents.emplace_back("XrBool32", enabled_prefix, oss_enabled.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpatialAnchorsCreateInfoBaseHeaderML* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        if (value->type == XR_TYPE_SPATIAL_ANCHORS_CREATE_INFO_FROM_POSE_ML) {
            const XrSpatialAnchorsCreateInfoFromPoseML* new_value = reinterpret_cast<const XrSpatialAnchorsCreateInfoFromPoseML*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_SPATIAL_ANCHORS_CREATE_INFO_FROM_UUIDS_ML) {
            const XrSpatialAnchorsCreateInfoFromUuidsML* new_value = reinterpret_cast<const XrSpatialAnchorsCreateInfoFromUuidsML*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        // Fallback path - Just output generic information about the base struct
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpatialAnchorsCreateInfoFromPoseML* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string basespace_prefix = prefix;
        basespace_prefix += "baseSpace";
        std::ostringstream oss_baseSpace;
        oss_baseSpace << std::hex << reinterpret_cast<const void*>(value->baseSpace);
        contents.emplace_back("XrSpace", basespace_prefix, oss_baseSpace.str());
        std::string poseinbasespace_prefix = prefix;
        poseinbasespace_prefix += "poseInBaseSpace";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->poseInBaseSpace, poseinbasespace_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string time_prefix = prefix;
        time_prefix += "time";
        contents.emplace_back("XrTime", time_prefix, std::to_string(value->time));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrCreateSpatialAnchorsCompletionML* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string futureresult_prefix = prefix;
        futureresult_prefix += "futureResult";
        if (nullptr != gen_dispatch_table) {
            char futureResult_string[XR_MAX_RESULT_STRING_SIZE] = {};
            gen_dispatch_table->ResultToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                               value->futureResult, futureResult_string);
            contents.emplace_back("XrResult", futureresult_prefix, futureResult_string);
        } else {
                        contents.emplace_back("XrResult", futureresult_prefix, std::to_string(value->futureResult));
        }
        std::string spacecount_prefix = prefix;
        spacecount_prefix += "spaceCount";
        std::ostringstream oss_spaceCount;
        oss_spaceCount << "0x" << std::hex << (value->spaceCount);
        contents.emplace_back("uint32_t", spacecount_prefix, oss_spaceCount.str());
        std::string spaces_prefix = prefix;
        spaces_prefix += "spaces";
        std::ostringstream oss_spaces;
        oss_spaces << std::hex << reinterpret_cast<const void*>(value->spaces);
        contents.emplace_back("XrSpace*", spaces_prefix, oss_spaces.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpatialAnchorStateML* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string confidence_prefix = prefix;
        confidence_prefix += "confidence";
        contents.emplace_back("XrSpatialAnchorConfidenceML", confidence_prefix, std::to_string(value->confidence));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpatialAnchorsCreateStorageInfoML* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpatialAnchorsQueryInfoBaseHeaderML* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        if (value->type == XR_TYPE_SPATIAL_ANCHORS_QUERY_INFO_RADIUS_ML) {
            const XrSpatialAnchorsQueryInfoRadiusML* new_value = reinterpret_cast<const XrSpatialAnchorsQueryInfoRadiusML*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        // Fallback path - Just output generic information about the base struct
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpatialAnchorsQueryInfoRadiusML* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string basespace_prefix = prefix;
        basespace_prefix += "baseSpace";
        std::ostringstream oss_baseSpace;
        oss_baseSpace << std::hex << reinterpret_cast<const void*>(value->baseSpace);
        contents.emplace_back("XrSpace", basespace_prefix, oss_baseSpace.str());
        std::string center_prefix = prefix;
        center_prefix += "center";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->center, center_prefix, "XrVector3f", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string time_prefix = prefix;
        time_prefix += "time";
        contents.emplace_back("XrTime", time_prefix, std::to_string(value->time));
        std::string radius_prefix = prefix;
        radius_prefix += "radius";
        std::ostringstream oss_radius;
        oss_radius << std::setprecision(32) << (value->radius);
        contents.emplace_back("float", radius_prefix, oss_radius.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpatialAnchorsQueryCompletionML* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string futureresult_prefix = prefix;
        futureresult_prefix += "futureResult";
        if (nullptr != gen_dispatch_table) {
            char futureResult_string[XR_MAX_RESULT_STRING_SIZE] = {};
            gen_dispatch_table->ResultToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                               value->futureResult, futureResult_string);
            contents.emplace_back("XrResult", futureresult_prefix, futureResult_string);
        } else {
                        contents.emplace_back("XrResult", futureresult_prefix, std::to_string(value->futureResult));
        }
        std::string uuidcapacityinput_prefix = prefix;
        uuidcapacityinput_prefix += "uuidCapacityInput";
        std::ostringstream oss_uuidCapacityInput;
        oss_uuidCapacityInput << "0x" << std::hex << (value->uuidCapacityInput);
        contents.emplace_back("uint32_t", uuidcapacityinput_prefix, oss_uuidCapacityInput.str());
        std::string uuidcountoutput_prefix = prefix;
        uuidcountoutput_prefix += "uuidCountOutput";
        std::ostringstream oss_uuidCountOutput;
        oss_uuidCountOutput << "0x" << std::hex << (value->uuidCountOutput);
        contents.emplace_back("uint32_t", uuidcountoutput_prefix, oss_uuidCountOutput.str());
        std::string uuids_prefix = prefix;
        uuids_prefix += "uuids";
        std::ostringstream oss_uuids;
        oss_uuids << std::hex << reinterpret_cast<const void*>(value->uuids);
        contents.emplace_back("XrUuidEXT*", uuids_prefix, oss_uuids.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpatialAnchorsCreateInfoFromUuidsML* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string storage_prefix = prefix;
        storage_prefix += "storage";
        std::ostringstream oss_storage;
        oss_storage << std::hex << reinterpret_cast<const void*>(value->storage);
        contents.emplace_back("XrSpatialAnchorsStorageML", storage_prefix, oss_storage.str());
        std::string uuidcount_prefix = prefix;
        uuidcount_prefix += "uuidCount";
        std::ostringstream oss_uuidCount;
        oss_uuidCount << "0x" << std::hex << (value->uuidCount);
        contents.emplace_back("uint32_t", uuidcount_prefix, oss_uuidCount.str());
        std::string uuids_prefix = prefix;
        uuids_prefix += "uuids";
        std::ostringstream oss_uuids_array;
        oss_uuids_array << std::hex << reinterpret_cast<const void*>(value->uuids);
        contents.emplace_back("const XrUuidEXT*", uuids_prefix, oss_uuids_array.str());
        for (uint32_t value_uuids_inc = 0; value_uuids_inc < value->uuidCount; ++value_uuids_inc) {
            std::string uuids_array_prefix = uuids_prefix;
            uuids_array_prefix += "[";
            uuids_array_prefix += std::to_string(value_uuids_inc);
            uuids_array_prefix += "]";
            if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->uuids[value_uuids_inc], uuids_array_prefix, "const XrUuidEXT*", false, contents)) {
                throw std::invalid_argument("Invalid Operation");
            }
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpatialAnchorsPublishInfoML* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string anchorcount_prefix = prefix;
        anchorcount_prefix += "anchorCount";
        std::ostringstream oss_anchorCount;
        oss_anchorCount << "0x" << std::hex << (value->anchorCount);
        contents.emplace_back("uint32_t", anchorcount_prefix, oss_anchorCount.str());
        std::string anchors_prefix = prefix;
        anchors_prefix += "anchors";
        std::ostringstream oss_anchors_array;
        oss_anchors_array << std::hex << reinterpret_cast<const void*>(value->anchors);
        contents.emplace_back("const XrSpace*", anchors_prefix, oss_anchors_array.str());
        for (uint32_t value_anchors_inc = 0; value_anchors_inc < value->anchorCount; ++value_anchors_inc) {
            std::string anchors_array_prefix = anchors_prefix;
            anchors_array_prefix += "[";
            anchors_array_prefix += std::to_string(value_anchors_inc);
            anchors_array_prefix += "]";
            std::ostringstream oss_anchors;
            oss_anchors << std::hex << reinterpret_cast<const void*>(value->anchors[value_anchors_inc]);
            contents.emplace_back("const XrSpace*", anchors_array_prefix, oss_anchors.str());
        }
        std::string expiration_prefix = prefix;
        expiration_prefix += "expiration";
        std::ostringstream oss_expiration;
        oss_expiration << "0x" << std::hex << (value->expiration);
        contents.emplace_back("uint64_t", expiration_prefix, oss_expiration.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpatialAnchorsPublishCompletionML* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string futureresult_prefix = prefix;
        futureresult_prefix += "futureResult";
        if (nullptr != gen_dispatch_table) {
            char futureResult_string[XR_MAX_RESULT_STRING_SIZE] = {};
            gen_dispatch_table->ResultToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                               value->futureResult, futureResult_string);
            contents.emplace_back("XrResult", futureresult_prefix, futureResult_string);
        } else {
                        contents.emplace_back("XrResult", futureresult_prefix, std::to_string(value->futureResult));
        }
        std::string uuidcount_prefix = prefix;
        uuidcount_prefix += "uuidCount";
        std::ostringstream oss_uuidCount;
        oss_uuidCount << "0x" << std::hex << (value->uuidCount);
        contents.emplace_back("uint32_t", uuidcount_prefix, oss_uuidCount.str());
        std::string uuids_prefix = prefix;
        uuids_prefix += "uuids";
        std::ostringstream oss_uuids;
        oss_uuids << std::hex << reinterpret_cast<const void*>(value->uuids);
        contents.emplace_back("XrUuidEXT*", uuids_prefix, oss_uuids.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpatialAnchorsDeleteInfoML* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string uuidcount_prefix = prefix;
        uuidcount_prefix += "uuidCount";
        std::ostringstream oss_uuidCount;
        oss_uuidCount << "0x" << std::hex << (value->uuidCount);
        contents.emplace_back("uint32_t", uuidcount_prefix, oss_uuidCount.str());
        std::string uuids_prefix = prefix;
        uuids_prefix += "uuids";
        std::ostringstream oss_uuids_array;
        oss_uuids_array << std::hex << reinterpret_cast<const void*>(value->uuids);
        contents.emplace_back("const XrUuidEXT*", uuids_prefix, oss_uuids_array.str());
        for (uint32_t value_uuids_inc = 0; value_uuids_inc < value->uuidCount; ++value_uuids_inc) {
            std::string uuids_array_prefix = uuids_prefix;
            uuids_array_prefix += "[";
            uuids_array_prefix += std::to_string(value_uuids_inc);
            uuids_array_prefix += "]";
            if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->uuids[value_uuids_inc], uuids_array_prefix, "const XrUuidEXT*", false, contents)) {
                throw std::invalid_argument("Invalid Operation");
            }
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpatialAnchorsDeleteCompletionML* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string futureresult_prefix = prefix;
        futureresult_prefix += "futureResult";
        if (nullptr != gen_dispatch_table) {
            char futureResult_string[XR_MAX_RESULT_STRING_SIZE] = {};
            gen_dispatch_table->ResultToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                               value->futureResult, futureResult_string);
            contents.emplace_back("XrResult", futureresult_prefix, futureResult_string);
        } else {
                        contents.emplace_back("XrResult", futureresult_prefix, std::to_string(value->futureResult));
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpatialAnchorsUpdateExpirationInfoML* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string uuidcount_prefix = prefix;
        uuidcount_prefix += "uuidCount";
        std::ostringstream oss_uuidCount;
        oss_uuidCount << "0x" << std::hex << (value->uuidCount);
        contents.emplace_back("uint32_t", uuidcount_prefix, oss_uuidCount.str());
        std::string uuids_prefix = prefix;
        uuids_prefix += "uuids";
        std::ostringstream oss_uuids_array;
        oss_uuids_array << std::hex << reinterpret_cast<const void*>(value->uuids);
        contents.emplace_back("const XrUuidEXT*", uuids_prefix, oss_uuids_array.str());
        for (uint32_t value_uuids_inc = 0; value_uuids_inc < value->uuidCount; ++value_uuids_inc) {
            std::string uuids_array_prefix = uuids_prefix;
            uuids_array_prefix += "[";
            uuids_array_prefix += std::to_string(value_uuids_inc);
            uuids_array_prefix += "]";
            if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->uuids[value_uuids_inc], uuids_array_prefix, "const XrUuidEXT*", false, contents)) {
                throw std::invalid_argument("Invalid Operation");
            }
        }
        std::string expiration_prefix = prefix;
        expiration_prefix += "expiration";
        std::ostringstream oss_expiration;
        oss_expiration << "0x" << std::hex << (value->expiration);
        contents.emplace_back("uint64_t", expiration_prefix, oss_expiration.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpatialAnchorsUpdateExpirationCompletionML* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string futureresult_prefix = prefix;
        futureresult_prefix += "futureResult";
        if (nullptr != gen_dispatch_table) {
            char futureResult_string[XR_MAX_RESULT_STRING_SIZE] = {};
            gen_dispatch_table->ResultToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                               value->futureResult, futureResult_string);
            contents.emplace_back("XrResult", futureresult_prefix, futureResult_string);
        } else {
                        contents.emplace_back("XrResult", futureresult_prefix, std::to_string(value->futureResult));
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpatialAnchorCompletionResultML* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string uuid_prefix = prefix;
        uuid_prefix += "uuid";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->uuid, uuid_prefix, "XrUuidEXT", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string result_prefix = prefix;
        result_prefix += "result";
        if (nullptr != gen_dispatch_table) {
            char result_string[XR_MAX_RESULT_STRING_SIZE] = {};
            gen_dispatch_table->ResultToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                               value->result, result_string);
            contents.emplace_back("XrResult", result_prefix, result_string);
        } else {
                        contents.emplace_back("XrResult", result_prefix, std::to_string(value->result));
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpatialAnchorsPublishCompletionDetailsML* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string resultcount_prefix = prefix;
        resultcount_prefix += "resultCount";
        std::ostringstream oss_resultCount;
        oss_resultCount << "0x" << std::hex << (value->resultCount);
        contents.emplace_back("uint32_t", resultcount_prefix, oss_resultCount.str());
        std::string results_prefix = prefix;
        results_prefix += "results";
        std::ostringstream oss_results;
        oss_results << std::hex << reinterpret_cast<const void*>(value->results);
        contents.emplace_back("XrSpatialAnchorCompletionResultML*", results_prefix, oss_results.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpatialAnchorsDeleteCompletionDetailsML* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string resultcount_prefix = prefix;
        resultcount_prefix += "resultCount";
        std::ostringstream oss_resultCount;
        oss_resultCount << "0x" << std::hex << (value->resultCount);
        contents.emplace_back("uint32_t", resultcount_prefix, oss_resultCount.str());
        std::string results_prefix = prefix;
        results_prefix += "results";
        std::ostringstream oss_results;
        oss_results << std::hex << reinterpret_cast<const void*>(value->results);
        contents.emplace_back("XrSpatialAnchorCompletionResultML*", results_prefix, oss_results.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpatialAnchorsUpdateExpirationCompletionDetailsML* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string resultcount_prefix = prefix;
        resultcount_prefix += "resultCount";
        std::ostringstream oss_resultCount;
        oss_resultCount << "0x" << std::hex << (value->resultCount);
        contents.emplace_back("uint32_t", resultcount_prefix, oss_resultCount.str());
        std::string results_prefix = prefix;
        results_prefix += "results";
        std::ostringstream oss_results;
        oss_results << std::hex << reinterpret_cast<const void*>(value->results);
        contents.emplace_back("XrSpatialAnchorCompletionResultML*", results_prefix, oss_results.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpatialAnchorPersistenceNameMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string name_prefix = prefix;
        name_prefix += "name";
        contents.emplace_back("char*", name_prefix, value->name);
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpatialAnchorPersistenceInfoMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string spatialanchorpersistencename_prefix = prefix;
        spatialanchorpersistencename_prefix += "spatialAnchorPersistenceName";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->spatialAnchorPersistenceName, spatialanchorpersistencename_prefix, "XrSpatialAnchorPersistenceNameMSFT", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string spatialanchor_prefix = prefix;
        spatialanchor_prefix += "spatialAnchor";
        std::ostringstream oss_spatialAnchor;
        oss_spatialAnchor << std::hex << reinterpret_cast<const void*>(value->spatialAnchor);
        contents.emplace_back("XrSpatialAnchorMSFT", spatialanchor_prefix, oss_spatialAnchor.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpatialAnchorFromPersistedAnchorCreateInfoMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string spatialanchorstore_prefix = prefix;
        spatialanchorstore_prefix += "spatialAnchorStore";
        std::ostringstream oss_spatialAnchorStore;
        oss_spatialAnchorStore << std::hex << reinterpret_cast<const void*>(value->spatialAnchorStore);
        contents.emplace_back("XrSpatialAnchorStoreConnectionMSFT", spatialanchorstore_prefix, oss_spatialAnchorStore.str());
        std::string spatialanchorpersistencename_prefix = prefix;
        spatialanchorpersistencename_prefix += "spatialAnchorPersistenceName";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->spatialAnchorPersistenceName, spatialanchorpersistencename_prefix, "XrSpatialAnchorPersistenceNameMSFT", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSceneMarkerMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string markertype_prefix = prefix;
        markertype_prefix += "markerType";
        contents.emplace_back("XrSceneMarkerTypeMSFT", markertype_prefix, std::to_string(value->markerType));
        std::string lastseentime_prefix = prefix;
        lastseentime_prefix += "lastSeenTime";
        contents.emplace_back("XrTime", lastseentime_prefix, std::to_string(value->lastSeenTime));
        std::string center_prefix = prefix;
        center_prefix += "center";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->center, center_prefix, "XrOffset2Df", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string size_prefix = prefix;
        size_prefix += "size";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->size, size_prefix, "XrExtent2Df", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSceneMarkersMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string scenemarkercapacityinput_prefix = prefix;
        scenemarkercapacityinput_prefix += "sceneMarkerCapacityInput";
        std::ostringstream oss_sceneMarkerCapacityInput;
        oss_sceneMarkerCapacityInput << "0x" << std::hex << (value->sceneMarkerCapacityInput);
        contents.emplace_back("uint32_t", scenemarkercapacityinput_prefix, oss_sceneMarkerCapacityInput.str());
        std::string scenemarkers_prefix = prefix;
        scenemarkers_prefix += "sceneMarkers";
        std::ostringstream oss_sceneMarkers;
        oss_sceneMarkers << std::hex << reinterpret_cast<const void*>(value->sceneMarkers);
        contents.emplace_back("XrSceneMarkerMSFT*", scenemarkers_prefix, oss_sceneMarkers.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSceneMarkerTypeFilterMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string markertypecount_prefix = prefix;
        markertypecount_prefix += "markerTypeCount";
        std::ostringstream oss_markerTypeCount;
        oss_markerTypeCount << "0x" << std::hex << (value->markerTypeCount);
        contents.emplace_back("uint32_t", markertypecount_prefix, oss_markerTypeCount.str());
        std::string markertypes_prefix = prefix;
        markertypes_prefix += "markerTypes";
        std::ostringstream oss_markerTypes;
        oss_markerTypes << std::hex << reinterpret_cast<const void*>(value->markerTypes);
        contents.emplace_back("XrSceneMarkerTypeMSFT*", markertypes_prefix, oss_markerTypes.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSceneMarkerQRCodeMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string symboltype_prefix = prefix;
        symboltype_prefix += "symbolType";
        contents.emplace_back("XrSceneMarkerQRCodeSymbolTypeMSFT", symboltype_prefix, std::to_string(value->symbolType));
        std::string version_prefix = prefix;
        version_prefix += "version";
        std::ostringstream oss_version;
        oss_version << "0x" << std::hex << (value->version);
        contents.emplace_back("uint8_t", version_prefix, oss_version.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSceneMarkerQRCodesMSFT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string qrcodecapacityinput_prefix = prefix;
        qrcodecapacityinput_prefix += "qrCodeCapacityInput";
        std::ostringstream oss_qrCodeCapacityInput;
        oss_qrCodeCapacityInput << "0x" << std::hex << (value->qrCodeCapacityInput);
        contents.emplace_back("uint32_t", qrcodecapacityinput_prefix, oss_qrCodeCapacityInput.str());
        std::string qrcodes_prefix = prefix;
        qrcodes_prefix += "qrCodes";
        std::ostringstream oss_qrCodes;
        oss_qrCodes << std::hex << reinterpret_cast<const void*>(value->qrCodes);
        contents.emplace_back("XrSceneMarkerQRCodeMSFT*", qrcodes_prefix, oss_qrCodes.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpaceQueryInfoBaseHeaderFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        if (value->type == XR_TYPE_SPACE_QUERY_INFO_FB) {
            const XrSpaceQueryInfoFB* new_value = reinterpret_cast<const XrSpaceQueryInfoFB*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        // Fallback path - Just output generic information about the base struct
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpaceFilterInfoBaseHeaderFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        if (value->type == XR_TYPE_SPACE_UUID_FILTER_INFO_FB) {
            const XrSpaceUuidFilterInfoFB* new_value = reinterpret_cast<const XrSpaceUuidFilterInfoFB*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_SPACE_COMPONENT_FILTER_INFO_FB) {
            const XrSpaceComponentFilterInfoFB* new_value = reinterpret_cast<const XrSpaceComponentFilterInfoFB*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        // Fallback path - Just output generic information about the base struct
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpaceQueryInfoFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string queryaction_prefix = prefix;
        queryaction_prefix += "queryAction";
        contents.emplace_back("XrSpaceQueryActionFB", queryaction_prefix, std::to_string(value->queryAction));
        std::string maxresultcount_prefix = prefix;
        maxresultcount_prefix += "maxResultCount";
        std::ostringstream oss_maxResultCount;
        oss_maxResultCount << "0x" << std::hex << (value->maxResultCount);
        contents.emplace_back("uint32_t", maxresultcount_prefix, oss_maxResultCount.str());
        std::string timeout_prefix = prefix;
        timeout_prefix += "timeout";
        contents.emplace_back("XrDuration", timeout_prefix, std::to_string(value->timeout));
        std::string filter_prefix = prefix;
        filter_prefix += "filter";
        if (nullptr == value->filter) {
            std::ostringstream oss_filter;
            oss_filter << std::hex << reinterpret_cast<const void*>(value->filter);
            contents.emplace_back("const XrSpaceFilterInfoBaseHeaderFB*", filter_prefix, oss_filter.str());
        } else if (!ApiDumpOutputXrStruct(gen_dispatch_table, value->filter, filter_prefix, "const XrSpaceFilterInfoBaseHeaderFB*", true, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string excludefilter_prefix = prefix;
        excludefilter_prefix += "excludeFilter";
        if (nullptr == value->excludeFilter) {
            std::ostringstream oss_excludeFilter;
            oss_excludeFilter << std::hex << reinterpret_cast<const void*>(value->excludeFilter);
            contents.emplace_back("const XrSpaceFilterInfoBaseHeaderFB*", excludefilter_prefix, oss_excludeFilter.str());
        } else if (!ApiDumpOutputXrStruct(gen_dispatch_table, value->excludeFilter, excludefilter_prefix, "const XrSpaceFilterInfoBaseHeaderFB*", true, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpaceStorageLocationFilterInfoFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string location_prefix = prefix;
        location_prefix += "location";
        contents.emplace_back("XrSpaceStorageLocationFB", location_prefix, std::to_string(value->location));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpaceUuidFilterInfoFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string uuidcount_prefix = prefix;
        uuidcount_prefix += "uuidCount";
        std::ostringstream oss_uuidCount;
        oss_uuidCount << "0x" << std::hex << (value->uuidCount);
        contents.emplace_back("uint32_t", uuidcount_prefix, oss_uuidCount.str());
        std::string uuids_prefix = prefix;
        uuids_prefix += "uuids";
        std::ostringstream oss_uuids;
        oss_uuids << std::hex << reinterpret_cast<const void*>(value->uuids);
        contents.emplace_back("XrUuidEXT*", uuids_prefix, oss_uuids.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpaceComponentFilterInfoFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string componenttype_prefix = prefix;
        componenttype_prefix += "componentType";
        contents.emplace_back("XrSpaceComponentTypeFB", componenttype_prefix, std::to_string(value->componentType));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpaceQueryResultFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string space_prefix = prefix;
        space_prefix += "space";
        std::ostringstream oss_space;
        oss_space << std::hex << reinterpret_cast<const void*>(value->space);
        contents.emplace_back("XrSpace", space_prefix, oss_space.str());
        std::string uuid_prefix = prefix;
        uuid_prefix += "uuid";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->uuid, uuid_prefix, "XrUuidEXT", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpaceQueryResultsFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string resultcapacityinput_prefix = prefix;
        resultcapacityinput_prefix += "resultCapacityInput";
        std::ostringstream oss_resultCapacityInput;
        oss_resultCapacityInput << "0x" << std::hex << (value->resultCapacityInput);
        contents.emplace_back("uint32_t", resultcapacityinput_prefix, oss_resultCapacityInput.str());
        std::string resultcountoutput_prefix = prefix;
        resultcountoutput_prefix += "resultCountOutput";
        std::ostringstream oss_resultCountOutput;
        oss_resultCountOutput << "0x" << std::hex << (value->resultCountOutput);
        contents.emplace_back("uint32_t", resultcountoutput_prefix, oss_resultCountOutput.str());
        std::string results_prefix = prefix;
        results_prefix += "results";
        std::ostringstream oss_results;
        oss_results << std::hex << reinterpret_cast<const void*>(value->results);
        contents.emplace_back("XrSpaceQueryResultFB*", results_prefix, oss_results.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEventDataSpaceQueryResultsAvailableFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string requestid_prefix = prefix;
        requestid_prefix += "requestId";
        contents.emplace_back("XrAsyncRequestIdFB", requestid_prefix, std::to_string(value->requestId));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEventDataSpaceQueryCompleteFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string requestid_prefix = prefix;
        requestid_prefix += "requestId";
        contents.emplace_back("XrAsyncRequestIdFB", requestid_prefix, std::to_string(value->requestId));
        std::string result_prefix = prefix;
        result_prefix += "result";
        if (nullptr != gen_dispatch_table) {
            char result_string[XR_MAX_RESULT_STRING_SIZE] = {};
            gen_dispatch_table->ResultToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                               value->result, result_string);
            contents.emplace_back("XrResult", result_prefix, result_string);
        } else {
                        contents.emplace_back("XrResult", result_prefix, std::to_string(value->result));
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpaceSaveInfoFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string space_prefix = prefix;
        space_prefix += "space";
        std::ostringstream oss_space;
        oss_space << std::hex << reinterpret_cast<const void*>(value->space);
        contents.emplace_back("XrSpace", space_prefix, oss_space.str());
        std::string location_prefix = prefix;
        location_prefix += "location";
        contents.emplace_back("XrSpaceStorageLocationFB", location_prefix, std::to_string(value->location));
        std::string persistencemode_prefix = prefix;
        persistencemode_prefix += "persistenceMode";
        contents.emplace_back("XrSpacePersistenceModeFB", persistencemode_prefix, std::to_string(value->persistenceMode));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpaceEraseInfoFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string space_prefix = prefix;
        space_prefix += "space";
        std::ostringstream oss_space;
        oss_space << std::hex << reinterpret_cast<const void*>(value->space);
        contents.emplace_back("XrSpace", space_prefix, oss_space.str());
        std::string location_prefix = prefix;
        location_prefix += "location";
        contents.emplace_back("XrSpaceStorageLocationFB", location_prefix, std::to_string(value->location));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEventDataSpaceSaveCompleteFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string requestid_prefix = prefix;
        requestid_prefix += "requestId";
        contents.emplace_back("XrAsyncRequestIdFB", requestid_prefix, std::to_string(value->requestId));
        std::string result_prefix = prefix;
        result_prefix += "result";
        if (nullptr != gen_dispatch_table) {
            char result_string[XR_MAX_RESULT_STRING_SIZE] = {};
            gen_dispatch_table->ResultToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                               value->result, result_string);
            contents.emplace_back("XrResult", result_prefix, result_string);
        } else {
                        contents.emplace_back("XrResult", result_prefix, std::to_string(value->result));
        }
        std::string space_prefix = prefix;
        space_prefix += "space";
        std::ostringstream oss_space;
        oss_space << std::hex << reinterpret_cast<const void*>(value->space);
        contents.emplace_back("XrSpace", space_prefix, oss_space.str());
        std::string uuid_prefix = prefix;
        uuid_prefix += "uuid";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->uuid, uuid_prefix, "XrUuidEXT", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string location_prefix = prefix;
        location_prefix += "location";
        contents.emplace_back("XrSpaceStorageLocationFB", location_prefix, std::to_string(value->location));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEventDataSpaceEraseCompleteFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string requestid_prefix = prefix;
        requestid_prefix += "requestId";
        contents.emplace_back("XrAsyncRequestIdFB", requestid_prefix, std::to_string(value->requestId));
        std::string result_prefix = prefix;
        result_prefix += "result";
        if (nullptr != gen_dispatch_table) {
            char result_string[XR_MAX_RESULT_STRING_SIZE] = {};
            gen_dispatch_table->ResultToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                               value->result, result_string);
            contents.emplace_back("XrResult", result_prefix, result_string);
        } else {
                        contents.emplace_back("XrResult", result_prefix, std::to_string(value->result));
        }
        std::string space_prefix = prefix;
        space_prefix += "space";
        std::ostringstream oss_space;
        oss_space << std::hex << reinterpret_cast<const void*>(value->space);
        contents.emplace_back("XrSpace", space_prefix, oss_space.str());
        std::string uuid_prefix = prefix;
        uuid_prefix += "uuid";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->uuid, uuid_prefix, "XrUuidEXT", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string location_prefix = prefix;
        location_prefix += "location";
        contents.emplace_back("XrSpaceStorageLocationFB", location_prefix, std::to_string(value->location));
        return true;
    } catch(...) {
    }
    return false;
}

#if defined(XR_USE_GRAPHICS_API_VULKAN)
bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSwapchainImageFoveationVulkanFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string image_prefix = prefix;
        image_prefix += "image";
        std::ostringstream oss_image;
        oss_image << std::hex << reinterpret_cast<const void*>(value->image);
        contents.emplace_back("VkImage", image_prefix, oss_image.str());
        std::string width_prefix = prefix;
        width_prefix += "width";
        std::ostringstream oss_width;
        oss_width << "0x" << std::hex << (value->width);
        contents.emplace_back("uint32_t", width_prefix, oss_width.str());
        std::string height_prefix = prefix;
        height_prefix += "height";
        std::ostringstream oss_height;
        oss_height << "0x" << std::hex << (value->height);
        contents.emplace_back("uint32_t", height_prefix, oss_height.str());
        return true;
    } catch(...) {
    }
    return false;
}
#endif // defined(XR_USE_GRAPHICS_API_VULKAN)

#if defined(XR_USE_PLATFORM_ANDROID) && defined(XR_USE_PLATFORM_ANDROID)
bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSwapchainStateAndroidSurfaceDimensionsFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string width_prefix = prefix;
        width_prefix += "width";
        std::ostringstream oss_width;
        oss_width << "0x" << std::hex << (value->width);
        contents.emplace_back("uint32_t", width_prefix, oss_width.str());
        std::string height_prefix = prefix;
        height_prefix += "height";
        std::ostringstream oss_height;
        oss_height << "0x" << std::hex << (value->height);
        contents.emplace_back("uint32_t", height_prefix, oss_height.str());
        return true;
    } catch(...) {
    }
    return false;
}
#endif // defined(XR_USE_PLATFORM_ANDROID) && defined(XR_USE_PLATFORM_ANDROID)

#if defined(XR_USE_GRAPHICS_API_OPENGL_ES) && defined(XR_USE_GRAPHICS_API_OPENGL_ES)
bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSwapchainStateSamplerOpenGLESFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string minfilter_prefix = prefix;
        minfilter_prefix += "minFilter";
        std::ostringstream oss_minFilter;
        oss_minFilter << std::hex << reinterpret_cast<const void*>(value->minFilter);
        contents.emplace_back("EGLenum", minfilter_prefix, oss_minFilter.str());
        std::string magfilter_prefix = prefix;
        magfilter_prefix += "magFilter";
        std::ostringstream oss_magFilter;
        oss_magFilter << std::hex << reinterpret_cast<const void*>(value->magFilter);
        contents.emplace_back("EGLenum", magfilter_prefix, oss_magFilter.str());
        std::string wrapmodes_prefix = prefix;
        wrapmodes_prefix += "wrapModeS";
        std::ostringstream oss_wrapModeS;
        oss_wrapModeS << std::hex << reinterpret_cast<const void*>(value->wrapModeS);
        contents.emplace_back("EGLenum", wrapmodes_prefix, oss_wrapModeS.str());
        std::string wrapmodet_prefix = prefix;
        wrapmodet_prefix += "wrapModeT";
        std::ostringstream oss_wrapModeT;
        oss_wrapModeT << std::hex << reinterpret_cast<const void*>(value->wrapModeT);
        contents.emplace_back("EGLenum", wrapmodet_prefix, oss_wrapModeT.str());
        std::string swizzlered_prefix = prefix;
        swizzlered_prefix += "swizzleRed";
        std::ostringstream oss_swizzleRed;
        oss_swizzleRed << std::hex << reinterpret_cast<const void*>(value->swizzleRed);
        contents.emplace_back("EGLenum", swizzlered_prefix, oss_swizzleRed.str());
        std::string swizzlegreen_prefix = prefix;
        swizzlegreen_prefix += "swizzleGreen";
        std::ostringstream oss_swizzleGreen;
        oss_swizzleGreen << std::hex << reinterpret_cast<const void*>(value->swizzleGreen);
        contents.emplace_back("EGLenum", swizzlegreen_prefix, oss_swizzleGreen.str());
        std::string swizzleblue_prefix = prefix;
        swizzleblue_prefix += "swizzleBlue";
        std::ostringstream oss_swizzleBlue;
        oss_swizzleBlue << std::hex << reinterpret_cast<const void*>(value->swizzleBlue);
        contents.emplace_back("EGLenum", swizzleblue_prefix, oss_swizzleBlue.str());
        std::string swizzlealpha_prefix = prefix;
        swizzlealpha_prefix += "swizzleAlpha";
        std::ostringstream oss_swizzleAlpha;
        oss_swizzleAlpha << std::hex << reinterpret_cast<const void*>(value->swizzleAlpha);
        contents.emplace_back("EGLenum", swizzlealpha_prefix, oss_swizzleAlpha.str());
        std::string maxanisotropy_prefix = prefix;
        maxanisotropy_prefix += "maxAnisotropy";
        std::ostringstream oss_maxAnisotropy;
        oss_maxAnisotropy << std::setprecision(32) << (value->maxAnisotropy);
        contents.emplace_back("float", maxanisotropy_prefix, oss_maxAnisotropy.str());
        std::string bordercolor_prefix = prefix;
        bordercolor_prefix += "borderColor";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->borderColor, bordercolor_prefix, "XrColor4f", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}
#endif // defined(XR_USE_GRAPHICS_API_OPENGL_ES) && defined(XR_USE_GRAPHICS_API_OPENGL_ES)

#if defined(XR_USE_GRAPHICS_API_VULKAN) && defined(XR_USE_GRAPHICS_API_VULKAN)
bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSwapchainStateSamplerVulkanFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string minfilter_prefix = prefix;
        minfilter_prefix += "minFilter";
        std::ostringstream oss_minFilter;
        oss_minFilter << std::hex << reinterpret_cast<const void*>(value->minFilter);
        contents.emplace_back("VkFilter", minfilter_prefix, oss_minFilter.str());
        std::string magfilter_prefix = prefix;
        magfilter_prefix += "magFilter";
        std::ostringstream oss_magFilter;
        oss_magFilter << std::hex << reinterpret_cast<const void*>(value->magFilter);
        contents.emplace_back("VkFilter", magfilter_prefix, oss_magFilter.str());
        std::string mipmapmode_prefix = prefix;
        mipmapmode_prefix += "mipmapMode";
        std::ostringstream oss_mipmapMode;
        oss_mipmapMode << std::hex << reinterpret_cast<const void*>(value->mipmapMode);
        contents.emplace_back("VkSamplerMipmapMode", mipmapmode_prefix, oss_mipmapMode.str());
        std::string wrapmodes_prefix = prefix;
        wrapmodes_prefix += "wrapModeS";
        std::ostringstream oss_wrapModeS;
        oss_wrapModeS << std::hex << reinterpret_cast<const void*>(value->wrapModeS);
        contents.emplace_back("VkSamplerAddressMode", wrapmodes_prefix, oss_wrapModeS.str());
        std::string wrapmodet_prefix = prefix;
        wrapmodet_prefix += "wrapModeT";
        std::ostringstream oss_wrapModeT;
        oss_wrapModeT << std::hex << reinterpret_cast<const void*>(value->wrapModeT);
        contents.emplace_back("VkSamplerAddressMode", wrapmodet_prefix, oss_wrapModeT.str());
        std::string swizzlered_prefix = prefix;
        swizzlered_prefix += "swizzleRed";
        std::ostringstream oss_swizzleRed;
        oss_swizzleRed << std::hex << reinterpret_cast<const void*>(value->swizzleRed);
        contents.emplace_back("VkComponentSwizzle", swizzlered_prefix, oss_swizzleRed.str());
        std::string swizzlegreen_prefix = prefix;
        swizzlegreen_prefix += "swizzleGreen";
        std::ostringstream oss_swizzleGreen;
        oss_swizzleGreen << std::hex << reinterpret_cast<const void*>(value->swizzleGreen);
        contents.emplace_back("VkComponentSwizzle", swizzlegreen_prefix, oss_swizzleGreen.str());
        std::string swizzleblue_prefix = prefix;
        swizzleblue_prefix += "swizzleBlue";
        std::ostringstream oss_swizzleBlue;
        oss_swizzleBlue << std::hex << reinterpret_cast<const void*>(value->swizzleBlue);
        contents.emplace_back("VkComponentSwizzle", swizzleblue_prefix, oss_swizzleBlue.str());
        std::string swizzlealpha_prefix = prefix;
        swizzlealpha_prefix += "swizzleAlpha";
        std::ostringstream oss_swizzleAlpha;
        oss_swizzleAlpha << std::hex << reinterpret_cast<const void*>(value->swizzleAlpha);
        contents.emplace_back("VkComponentSwizzle", swizzlealpha_prefix, oss_swizzleAlpha.str());
        std::string maxanisotropy_prefix = prefix;
        maxanisotropy_prefix += "maxAnisotropy";
        std::ostringstream oss_maxAnisotropy;
        oss_maxAnisotropy << std::setprecision(32) << (value->maxAnisotropy);
        contents.emplace_back("float", maxanisotropy_prefix, oss_maxAnisotropy.str());
        std::string bordercolor_prefix = prefix;
        bordercolor_prefix += "borderColor";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->borderColor, bordercolor_prefix, "XrColor4f", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}
#endif // defined(XR_USE_GRAPHICS_API_VULKAN) && defined(XR_USE_GRAPHICS_API_VULKAN)

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpaceShareInfoFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string spacecount_prefix = prefix;
        spacecount_prefix += "spaceCount";
        std::ostringstream oss_spaceCount;
        oss_spaceCount << "0x" << std::hex << (value->spaceCount);
        contents.emplace_back("uint32_t", spacecount_prefix, oss_spaceCount.str());
        std::string spaces_prefix = prefix;
        spaces_prefix += "spaces";
        std::ostringstream oss_spaces;
        oss_spaces << std::hex << reinterpret_cast<const void*>(value->spaces);
        contents.emplace_back("XrSpace*", spaces_prefix, oss_spaces.str());
        std::string usercount_prefix = prefix;
        usercount_prefix += "userCount";
        std::ostringstream oss_userCount;
        oss_userCount << "0x" << std::hex << (value->userCount);
        contents.emplace_back("uint32_t", usercount_prefix, oss_userCount.str());
        std::string users_prefix = prefix;
        users_prefix += "users";
        std::ostringstream oss_users;
        oss_users << std::hex << reinterpret_cast<const void*>(value->users);
        contents.emplace_back("XrSpaceUserFB*", users_prefix, oss_users.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEventDataSpaceShareCompleteFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string requestid_prefix = prefix;
        requestid_prefix += "requestId";
        contents.emplace_back("XrAsyncRequestIdFB", requestid_prefix, std::to_string(value->requestId));
        std::string result_prefix = prefix;
        result_prefix += "result";
        if (nullptr != gen_dispatch_table) {
            char result_string[XR_MAX_RESULT_STRING_SIZE] = {};
            gen_dispatch_table->ResultToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                               value->result, result_string);
            contents.emplace_back("XrResult", result_prefix, result_string);
        } else {
                        contents.emplace_back("XrResult", result_prefix, std::to_string(value->result));
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrCompositionLayerSpaceWarpInfoFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string layerflags_prefix = prefix;
        layerflags_prefix += "layerFlags";
        contents.emplace_back("XrCompositionLayerSpaceWarpInfoFlagsFB", layerflags_prefix, std::to_string(value->layerFlags));
        std::string motionvectorsubimage_prefix = prefix;
        motionvectorsubimage_prefix += "motionVectorSubImage";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->motionVectorSubImage, motionvectorsubimage_prefix, "XrSwapchainSubImage", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string appspacedeltapose_prefix = prefix;
        appspacedeltapose_prefix += "appSpaceDeltaPose";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->appSpaceDeltaPose, appspacedeltapose_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string depthsubimage_prefix = prefix;
        depthsubimage_prefix += "depthSubImage";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->depthSubImage, depthsubimage_prefix, "XrSwapchainSubImage", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string mindepth_prefix = prefix;
        mindepth_prefix += "minDepth";
        std::ostringstream oss_minDepth;
        oss_minDepth << std::setprecision(32) << (value->minDepth);
        contents.emplace_back("float", mindepth_prefix, oss_minDepth.str());
        std::string maxdepth_prefix = prefix;
        maxdepth_prefix += "maxDepth";
        std::ostringstream oss_maxDepth;
        oss_maxDepth << std::setprecision(32) << (value->maxDepth);
        contents.emplace_back("float", maxdepth_prefix, oss_maxDepth.str());
        std::string nearz_prefix = prefix;
        nearz_prefix += "nearZ";
        std::ostringstream oss_nearZ;
        oss_nearZ << std::setprecision(32) << (value->nearZ);
        contents.emplace_back("float", nearz_prefix, oss_nearZ.str());
        std::string farz_prefix = prefix;
        farz_prefix += "farZ";
        std::ostringstream oss_farZ;
        oss_farZ << std::setprecision(32) << (value->farZ);
        contents.emplace_back("float", farz_prefix, oss_farZ.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSystemSpaceWarpPropertiesFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string recommendedmotionvectorimagerectwidth_prefix = prefix;
        recommendedmotionvectorimagerectwidth_prefix += "recommendedMotionVectorImageRectWidth";
        std::ostringstream oss_recommendedMotionVectorImageRectWidth;
        oss_recommendedMotionVectorImageRectWidth << "0x" << std::hex << (value->recommendedMotionVectorImageRectWidth);
        contents.emplace_back("uint32_t", recommendedmotionvectorimagerectwidth_prefix, oss_recommendedMotionVectorImageRectWidth.str());
        std::string recommendedmotionvectorimagerectheight_prefix = prefix;
        recommendedmotionvectorimagerectheight_prefix += "recommendedMotionVectorImageRectHeight";
        std::ostringstream oss_recommendedMotionVectorImageRectHeight;
        oss_recommendedMotionVectorImageRectHeight << "0x" << std::hex << (value->recommendedMotionVectorImageRectHeight);
        contents.emplace_back("uint32_t", recommendedmotionvectorimagerectheight_prefix, oss_recommendedMotionVectorImageRectHeight.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrHapticAmplitudeEnvelopeVibrationFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string duration_prefix = prefix;
        duration_prefix += "duration";
        contents.emplace_back("XrDuration", duration_prefix, std::to_string(value->duration));
        std::string amplitudecount_prefix = prefix;
        amplitudecount_prefix += "amplitudeCount";
        std::ostringstream oss_amplitudeCount;
        oss_amplitudeCount << "0x" << std::hex << (value->amplitudeCount);
        contents.emplace_back("uint32_t", amplitudecount_prefix, oss_amplitudeCount.str());
        std::string amplitudes_prefix = prefix;
        amplitudes_prefix += "amplitudes";
        std::ostringstream oss_amplitudes_array;
        oss_amplitudes_array << std::setprecision(32) << (value->amplitudes);
        contents.emplace_back("const float*", amplitudes_prefix, oss_amplitudes_array.str());
        for (uint32_t value_amplitudes_inc = 0; value_amplitudes_inc < value->amplitudeCount; ++value_amplitudes_inc) {
            std::string amplitudes_array_prefix = amplitudes_prefix;
            amplitudes_array_prefix += "[";
            amplitudes_array_prefix += std::to_string(value_amplitudes_inc);
            amplitudes_array_prefix += "]";
            std::ostringstream oss_amplitudes;
            oss_amplitudes << std::setprecision(32) << (value->amplitudes[value_amplitudes_inc]);
            contents.emplace_back("const float*", amplitudes_array_prefix, oss_amplitudes.str());
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrOffset3DfFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string x_prefix = prefix;
        x_prefix += "x";
        std::ostringstream oss_x;
        oss_x << std::setprecision(32) << (value->x);
        contents.emplace_back("float", x_prefix, oss_x.str());
        std::string y_prefix = prefix;
        y_prefix += "y";
        std::ostringstream oss_y;
        oss_y << std::setprecision(32) << (value->y);
        contents.emplace_back("float", y_prefix, oss_y.str());
        std::string z_prefix = prefix;
        z_prefix += "z";
        std::ostringstream oss_z;
        oss_z << std::setprecision(32) << (value->z);
        contents.emplace_back("float", z_prefix, oss_z.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrRect3DfFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string offset_prefix = prefix;
        offset_prefix += "offset";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->offset, offset_prefix, "XrOffset3DfFB", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string extent_prefix = prefix;
        extent_prefix += "extent";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->extent, extent_prefix, "XrExtent3DfFB", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSemanticLabelsFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string buffercapacityinput_prefix = prefix;
        buffercapacityinput_prefix += "bufferCapacityInput";
        std::ostringstream oss_bufferCapacityInput;
        oss_bufferCapacityInput << "0x" << std::hex << (value->bufferCapacityInput);
        contents.emplace_back("uint32_t", buffercapacityinput_prefix, oss_bufferCapacityInput.str());
        std::string buffercountoutput_prefix = prefix;
        buffercountoutput_prefix += "bufferCountOutput";
        std::ostringstream oss_bufferCountOutput;
        oss_bufferCountOutput << "0x" << std::hex << (value->bufferCountOutput);
        contents.emplace_back("uint32_t", buffercountoutput_prefix, oss_bufferCountOutput.str());
        std::string buffer_prefix = prefix;
        buffer_prefix += "buffer";
        contents.emplace_back("char*", buffer_prefix, (value->buffer ? value->buffer : "(nullptr)"));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrRoomLayoutFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string flooruuid_prefix = prefix;
        flooruuid_prefix += "floorUuid";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->floorUuid, flooruuid_prefix, "XrUuidEXT", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string ceilinguuid_prefix = prefix;
        ceilinguuid_prefix += "ceilingUuid";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->ceilingUuid, ceilinguuid_prefix, "XrUuidEXT", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string walluuidcapacityinput_prefix = prefix;
        walluuidcapacityinput_prefix += "wallUuidCapacityInput";
        std::ostringstream oss_wallUuidCapacityInput;
        oss_wallUuidCapacityInput << "0x" << std::hex << (value->wallUuidCapacityInput);
        contents.emplace_back("uint32_t", walluuidcapacityinput_prefix, oss_wallUuidCapacityInput.str());
        std::string walluuidcountoutput_prefix = prefix;
        walluuidcountoutput_prefix += "wallUuidCountOutput";
        std::ostringstream oss_wallUuidCountOutput;
        oss_wallUuidCountOutput << "0x" << std::hex << (value->wallUuidCountOutput);
        contents.emplace_back("uint32_t", walluuidcountoutput_prefix, oss_wallUuidCountOutput.str());
        std::string walluuids_prefix = prefix;
        walluuids_prefix += "wallUuids";
        std::ostringstream oss_wallUuids;
        oss_wallUuids << std::hex << reinterpret_cast<const void*>(value->wallUuids);
        contents.emplace_back("XrUuidEXT*", walluuids_prefix, oss_wallUuids.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrBoundary2DFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string vertexcapacityinput_prefix = prefix;
        vertexcapacityinput_prefix += "vertexCapacityInput";
        std::ostringstream oss_vertexCapacityInput;
        oss_vertexCapacityInput << "0x" << std::hex << (value->vertexCapacityInput);
        contents.emplace_back("uint32_t", vertexcapacityinput_prefix, oss_vertexCapacityInput.str());
        std::string vertexcountoutput_prefix = prefix;
        vertexcountoutput_prefix += "vertexCountOutput";
        std::ostringstream oss_vertexCountOutput;
        oss_vertexCountOutput << "0x" << std::hex << (value->vertexCountOutput);
        contents.emplace_back("uint32_t", vertexcountoutput_prefix, oss_vertexCountOutput.str());
        std::string vertices_prefix = prefix;
        vertices_prefix += "vertices";
        std::ostringstream oss_vertices;
        oss_vertices << std::hex << reinterpret_cast<const void*>(value->vertices);
        contents.emplace_back("XrVector2f*", vertices_prefix, oss_vertices.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSemanticLabelsSupportInfoFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string flags_prefix = prefix;
        flags_prefix += "flags";
        contents.emplace_back("XrSemanticLabelsSupportFlagsFB", flags_prefix, std::to_string(value->flags));
        std::string recognizedlabels_prefix = prefix;
        recognizedlabels_prefix += "recognizedLabels";
        std::ostringstream oss_recognizedLabels;
        oss_recognizedLabels << std::hex << reinterpret_cast<const void*>(*value->recognizedLabels);
        contents.emplace_back("const char*", recognizedlabels_prefix, oss_recognizedLabels.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrDigitalLensControlALMALENCE* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string flags_prefix = prefix;
        flags_prefix += "flags";
        contents.emplace_back("XrDigitalLensControlFlagsALMALENCE", flags_prefix, std::to_string(value->flags));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEventDataSceneCaptureCompleteFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string requestid_prefix = prefix;
        requestid_prefix += "requestId";
        contents.emplace_back("XrAsyncRequestIdFB", requestid_prefix, std::to_string(value->requestId));
        std::string result_prefix = prefix;
        result_prefix += "result";
        if (nullptr != gen_dispatch_table) {
            char result_string[XR_MAX_RESULT_STRING_SIZE] = {};
            gen_dispatch_table->ResultToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                               value->result, result_string);
            contents.emplace_back("XrResult", result_prefix, result_string);
        } else {
                        contents.emplace_back("XrResult", result_prefix, std::to_string(value->result));
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSceneCaptureRequestInfoFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string requestbytecount_prefix = prefix;
        requestbytecount_prefix += "requestByteCount";
        std::ostringstream oss_requestByteCount;
        oss_requestByteCount << "0x" << std::hex << (value->requestByteCount);
        contents.emplace_back("uint32_t", requestbytecount_prefix, oss_requestByteCount.str());
        std::string request_prefix = prefix;
        request_prefix += "request";
        if (nullptr == value->request) {
            std::ostringstream oss_request_array;
            oss_request_array << std::hex << reinterpret_cast<const void*>(value->request);
            contents.emplace_back("const char*", request_prefix, oss_request_array.str());
        } else {
            contents.emplace_back("const char*", request_prefix, value->request);
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpaceContainerFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string uuidcapacityinput_prefix = prefix;
        uuidcapacityinput_prefix += "uuidCapacityInput";
        std::ostringstream oss_uuidCapacityInput;
        oss_uuidCapacityInput << "0x" << std::hex << (value->uuidCapacityInput);
        contents.emplace_back("uint32_t", uuidcapacityinput_prefix, oss_uuidCapacityInput.str());
        std::string uuidcountoutput_prefix = prefix;
        uuidcountoutput_prefix += "uuidCountOutput";
        std::ostringstream oss_uuidCountOutput;
        oss_uuidCountOutput << "0x" << std::hex << (value->uuidCountOutput);
        contents.emplace_back("uint32_t", uuidcountoutput_prefix, oss_uuidCountOutput.str());
        std::string uuids_prefix = prefix;
        uuids_prefix += "uuids";
        std::ostringstream oss_uuids;
        oss_uuids << std::hex << reinterpret_cast<const void*>(value->uuids);
        contents.emplace_back("XrUuidEXT*", uuids_prefix, oss_uuids.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrFoveationEyeTrackedProfileCreateInfoMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string flags_prefix = prefix;
        flags_prefix += "flags";
        contents.emplace_back("XrFoveationEyeTrackedProfileCreateFlagsMETA", flags_prefix, std::to_string(value->flags));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrFoveationEyeTrackedStateMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string foveationcenter_prefix = prefix;
        foveationcenter_prefix += "foveationCenter";
        std::ostringstream oss_foveationCenter_array;
        oss_foveationCenter_array << std::hex << reinterpret_cast<const void*>(value->foveationCenter);
        contents.emplace_back("XrVector2f*", foveationcenter_prefix, oss_foveationCenter_array.str());
        for (uint32_t value_foveationcenter_inc = 0; value_foveationcenter_inc < XR_FOVEATION_CENTER_SIZE_META; ++value_foveationcenter_inc) {
            std::string foveationcenter_array_prefix = foveationcenter_prefix;
            foveationcenter_array_prefix += "[";
            foveationcenter_array_prefix += std::to_string(value_foveationcenter_inc);
            foveationcenter_array_prefix += "]";
            if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->foveationCenter[value_foveationcenter_inc], foveationcenter_array_prefix, "XrVector2f", false, contents)) {
                throw std::invalid_argument("Invalid Operation");
            }
        }
        std::string flags_prefix = prefix;
        flags_prefix += "flags";
        contents.emplace_back("XrFoveationEyeTrackedStateFlagsMETA", flags_prefix, std::to_string(value->flags));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSystemFoveationEyeTrackedPropertiesMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string supportsfoveationeyetracked_prefix = prefix;
        supportsfoveationeyetracked_prefix += "supportsFoveationEyeTracked";
        std::ostringstream oss_supportsFoveationEyeTracked;
        oss_supportsFoveationEyeTracked << "0x" << std::hex << (value->supportsFoveationEyeTracked);
        contents.emplace_back("XrBool32", supportsfoveationeyetracked_prefix, oss_supportsFoveationEyeTracked.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSystemFaceTrackingPropertiesFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string supportsfacetracking_prefix = prefix;
        supportsfacetracking_prefix += "supportsFaceTracking";
        std::ostringstream oss_supportsFaceTracking;
        oss_supportsFaceTracking << "0x" << std::hex << (value->supportsFaceTracking);
        contents.emplace_back("XrBool32", supportsfacetracking_prefix, oss_supportsFaceTracking.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrFaceTrackerCreateInfoFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string faceexpressionset_prefix = prefix;
        faceexpressionset_prefix += "faceExpressionSet";
        contents.emplace_back("XrFaceExpressionSetFB", faceexpressionset_prefix, std::to_string(value->faceExpressionSet));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrFaceExpressionInfoFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string time_prefix = prefix;
        time_prefix += "time";
        contents.emplace_back("XrTime", time_prefix, std::to_string(value->time));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrFaceExpressionStatusFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string isvalid_prefix = prefix;
        isvalid_prefix += "isValid";
        std::ostringstream oss_isValid;
        oss_isValid << "0x" << std::hex << (value->isValid);
        contents.emplace_back("XrBool32", isvalid_prefix, oss_isValid.str());
        std::string iseyefollowingblendshapesvalid_prefix = prefix;
        iseyefollowingblendshapesvalid_prefix += "isEyeFollowingBlendshapesValid";
        std::ostringstream oss_isEyeFollowingBlendshapesValid;
        oss_isEyeFollowingBlendshapesValid << "0x" << std::hex << (value->isEyeFollowingBlendshapesValid);
        contents.emplace_back("XrBool32", iseyefollowingblendshapesvalid_prefix, oss_isEyeFollowingBlendshapesValid.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrFaceExpressionWeightsFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string weightcount_prefix = prefix;
        weightcount_prefix += "weightCount";
        std::ostringstream oss_weightCount;
        oss_weightCount << "0x" << std::hex << (value->weightCount);
        contents.emplace_back("uint32_t", weightcount_prefix, oss_weightCount.str());
        std::string weights_prefix = prefix;
        weights_prefix += "weights";
        std::ostringstream oss_weights;
        oss_weights << std::setprecision(32) << (value->weights);
        contents.emplace_back("float*", weights_prefix, oss_weights.str());
        std::string confidencecount_prefix = prefix;
        confidencecount_prefix += "confidenceCount";
        std::ostringstream oss_confidenceCount;
        oss_confidenceCount << "0x" << std::hex << (value->confidenceCount);
        contents.emplace_back("uint32_t", confidencecount_prefix, oss_confidenceCount.str());
        std::string confidences_prefix = prefix;
        confidences_prefix += "confidences";
        std::ostringstream oss_confidences;
        oss_confidences << std::setprecision(32) << (value->confidences);
        contents.emplace_back("float*", confidences_prefix, oss_confidences.str());
        std::string status_prefix = prefix;
        status_prefix += "status";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->status, status_prefix, "XrFaceExpressionStatusFB", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string time_prefix = prefix;
        time_prefix += "time";
        contents.emplace_back("XrTime", time_prefix, std::to_string(value->time));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEyeGazeFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string isvalid_prefix = prefix;
        isvalid_prefix += "isValid";
        std::ostringstream oss_isValid;
        oss_isValid << "0x" << std::hex << (value->isValid);
        contents.emplace_back("XrBool32", isvalid_prefix, oss_isValid.str());
        std::string gazepose_prefix = prefix;
        gazepose_prefix += "gazePose";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->gazePose, gazepose_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string gazeconfidence_prefix = prefix;
        gazeconfidence_prefix += "gazeConfidence";
        std::ostringstream oss_gazeConfidence;
        oss_gazeConfidence << std::setprecision(32) << (value->gazeConfidence);
        contents.emplace_back("float", gazeconfidence_prefix, oss_gazeConfidence.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEyeTrackerCreateInfoFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEyeGazesInfoFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string basespace_prefix = prefix;
        basespace_prefix += "baseSpace";
        std::ostringstream oss_baseSpace;
        oss_baseSpace << std::hex << reinterpret_cast<const void*>(value->baseSpace);
        contents.emplace_back("XrSpace", basespace_prefix, oss_baseSpace.str());
        std::string time_prefix = prefix;
        time_prefix += "time";
        contents.emplace_back("XrTime", time_prefix, std::to_string(value->time));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSystemEyeTrackingPropertiesFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string supportseyetracking_prefix = prefix;
        supportseyetracking_prefix += "supportsEyeTracking";
        std::ostringstream oss_supportsEyeTracking;
        oss_supportsEyeTracking << "0x" << std::hex << (value->supportsEyeTracking);
        contents.emplace_back("XrBool32", supportseyetracking_prefix, oss_supportsEyeTracking.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEyeGazesFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string gaze_prefix = prefix;
        gaze_prefix += "gaze";
        std::ostringstream oss_gaze_array;
        oss_gaze_array << std::hex << reinterpret_cast<const void*>(value->gaze);
        contents.emplace_back("XrEyeGazeFB*", gaze_prefix, oss_gaze_array.str());
        for (uint32_t value_gaze_inc = 0; value_gaze_inc < XR_EYE_POSITION_COUNT_FB; ++value_gaze_inc) {
            std::string gaze_array_prefix = gaze_prefix;
            gaze_array_prefix += "[";
            gaze_array_prefix += std::to_string(value_gaze_inc);
            gaze_array_prefix += "]";
            if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->gaze[value_gaze_inc], gaze_array_prefix, "XrEyeGazeFB", false, contents)) {
                throw std::invalid_argument("Invalid Operation");
            }
        }
        std::string time_prefix = prefix;
        time_prefix += "time";
        contents.emplace_back("XrTime", time_prefix, std::to_string(value->time));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrPassthroughKeyboardHandsIntensityFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string lefthandintensity_prefix = prefix;
        lefthandintensity_prefix += "leftHandIntensity";
        std::ostringstream oss_leftHandIntensity;
        oss_leftHandIntensity << std::setprecision(32) << (value->leftHandIntensity);
        contents.emplace_back("float", lefthandintensity_prefix, oss_leftHandIntensity.str());
        std::string righthandintensity_prefix = prefix;
        righthandintensity_prefix += "rightHandIntensity";
        std::ostringstream oss_rightHandIntensity;
        oss_rightHandIntensity << std::setprecision(32) << (value->rightHandIntensity);
        contents.emplace_back("float", righthandintensity_prefix, oss_rightHandIntensity.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrCompositionLayerSettingsFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string layerflags_prefix = prefix;
        layerflags_prefix += "layerFlags";
        contents.emplace_back("XrCompositionLayerSettingsFlagsFB", layerflags_prefix, std::to_string(value->layerFlags));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrHapticPcmVibrationFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string buffersize_prefix = prefix;
        buffersize_prefix += "bufferSize";
        std::ostringstream oss_bufferSize;
        oss_bufferSize << "0x" << std::hex << (value->bufferSize);
        contents.emplace_back("uint32_t", buffersize_prefix, oss_bufferSize.str());
        std::string buffer_prefix = prefix;
        buffer_prefix += "buffer";
        std::ostringstream oss_buffer_array;
        oss_buffer_array << std::setprecision(32) << (value->buffer);
        contents.emplace_back("const float*", buffer_prefix, oss_buffer_array.str());
        for (uint32_t value_buffer_inc = 0; value_buffer_inc < value->bufferSize; ++value_buffer_inc) {
            std::string buffer_array_prefix = buffer_prefix;
            buffer_array_prefix += "[";
            buffer_array_prefix += std::to_string(value_buffer_inc);
            buffer_array_prefix += "]";
            std::ostringstream oss_buffer;
            oss_buffer << std::setprecision(32) << (value->buffer[value_buffer_inc]);
            contents.emplace_back("const float*", buffer_array_prefix, oss_buffer.str());
        }
        std::string samplerate_prefix = prefix;
        samplerate_prefix += "sampleRate";
        std::ostringstream oss_sampleRate;
        oss_sampleRate << std::setprecision(32) << (value->sampleRate);
        contents.emplace_back("float", samplerate_prefix, oss_sampleRate.str());
        std::string append_prefix = prefix;
        append_prefix += "append";
        std::ostringstream oss_append;
        oss_append << "0x" << std::hex << (value->append);
        contents.emplace_back("XrBool32", append_prefix, oss_append.str());
        std::string samplesconsumed_prefix = prefix;
        samplesconsumed_prefix += "samplesConsumed";
        std::ostringstream oss_samplesConsumed;
        oss_samplesConsumed << std::hex << (value->samplesConsumed);
        contents.emplace_back("uint32_t*", samplesconsumed_prefix, oss_samplesConsumed.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrDevicePcmSampleRateStateFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string samplerate_prefix = prefix;
        samplerate_prefix += "sampleRate";
        std::ostringstream oss_sampleRate;
        oss_sampleRate << std::setprecision(32) << (value->sampleRate);
        contents.emplace_back("float", samplerate_prefix, oss_sampleRate.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrFrameSynthesisInfoEXT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string layerflags_prefix = prefix;
        layerflags_prefix += "layerFlags";
        contents.emplace_back("XrFrameSynthesisInfoFlagsEXT", layerflags_prefix, std::to_string(value->layerFlags));
        std::string motionvectorsubimage_prefix = prefix;
        motionvectorsubimage_prefix += "motionVectorSubImage";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->motionVectorSubImage, motionvectorsubimage_prefix, "XrSwapchainSubImage", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string motionvectorscale_prefix = prefix;
        motionvectorscale_prefix += "motionVectorScale";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->motionVectorScale, motionvectorscale_prefix, "XrVector4f", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string motionvectoroffset_prefix = prefix;
        motionvectoroffset_prefix += "motionVectorOffset";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->motionVectorOffset, motionvectoroffset_prefix, "XrVector4f", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string appspacedeltapose_prefix = prefix;
        appspacedeltapose_prefix += "appSpaceDeltaPose";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->appSpaceDeltaPose, appspacedeltapose_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string depthsubimage_prefix = prefix;
        depthsubimage_prefix += "depthSubImage";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->depthSubImage, depthsubimage_prefix, "XrSwapchainSubImage", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string mindepth_prefix = prefix;
        mindepth_prefix += "minDepth";
        std::ostringstream oss_minDepth;
        oss_minDepth << std::setprecision(32) << (value->minDepth);
        contents.emplace_back("float", mindepth_prefix, oss_minDepth.str());
        std::string maxdepth_prefix = prefix;
        maxdepth_prefix += "maxDepth";
        std::ostringstream oss_maxDepth;
        oss_maxDepth << std::setprecision(32) << (value->maxDepth);
        contents.emplace_back("float", maxdepth_prefix, oss_maxDepth.str());
        std::string nearz_prefix = prefix;
        nearz_prefix += "nearZ";
        std::ostringstream oss_nearZ;
        oss_nearZ << std::setprecision(32) << (value->nearZ);
        contents.emplace_back("float", nearz_prefix, oss_nearZ.str());
        std::string farz_prefix = prefix;
        farz_prefix += "farZ";
        std::ostringstream oss_farZ;
        oss_farZ << std::setprecision(32) << (value->farZ);
        contents.emplace_back("float", farz_prefix, oss_farZ.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrFrameSynthesisConfigViewEXT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string recommendedmotionvectorimagerectwidth_prefix = prefix;
        recommendedmotionvectorimagerectwidth_prefix += "recommendedMotionVectorImageRectWidth";
        std::ostringstream oss_recommendedMotionVectorImageRectWidth;
        oss_recommendedMotionVectorImageRectWidth << "0x" << std::hex << (value->recommendedMotionVectorImageRectWidth);
        contents.emplace_back("uint32_t", recommendedmotionvectorimagerectwidth_prefix, oss_recommendedMotionVectorImageRectWidth.str());
        std::string recommendedmotionvectorimagerectheight_prefix = prefix;
        recommendedmotionvectorimagerectheight_prefix += "recommendedMotionVectorImageRectHeight";
        std::ostringstream oss_recommendedMotionVectorImageRectHeight;
        oss_recommendedMotionVectorImageRectHeight << "0x" << std::hex << (value->recommendedMotionVectorImageRectHeight);
        contents.emplace_back("uint32_t", recommendedmotionvectorimagerectheight_prefix, oss_recommendedMotionVectorImageRectHeight.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrCompositionLayerDepthTestFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string depthmask_prefix = prefix;
        depthmask_prefix += "depthMask";
        std::ostringstream oss_depthMask;
        oss_depthMask << "0x" << std::hex << (value->depthMask);
        contents.emplace_back("XrBool32", depthmask_prefix, oss_depthMask.str());
        std::string compareop_prefix = prefix;
        compareop_prefix += "compareOp";
        contents.emplace_back("XrCompareOpFB", compareop_prefix, std::to_string(value->compareOp));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrLocalDimmingFrameEndInfoMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string localdimmingmode_prefix = prefix;
        localdimmingmode_prefix += "localDimmingMode";
        contents.emplace_back("XrLocalDimmingModeMETA", localdimmingmode_prefix, std::to_string(value->localDimmingMode));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrPassthroughPreferencesMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string flags_prefix = prefix;
        flags_prefix += "flags";
        contents.emplace_back("XrPassthroughPreferenceFlagsMETA", flags_prefix, std::to_string(value->flags));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSystemVirtualKeyboardPropertiesMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string supportsvirtualkeyboard_prefix = prefix;
        supportsvirtualkeyboard_prefix += "supportsVirtualKeyboard";
        std::ostringstream oss_supportsVirtualKeyboard;
        oss_supportsVirtualKeyboard << "0x" << std::hex << (value->supportsVirtualKeyboard);
        contents.emplace_back("XrBool32", supportsvirtualkeyboard_prefix, oss_supportsVirtualKeyboard.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrVirtualKeyboardCreateInfoMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrVirtualKeyboardSpaceCreateInfoMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string locationtype_prefix = prefix;
        locationtype_prefix += "locationType";
        contents.emplace_back("XrVirtualKeyboardLocationTypeMETA", locationtype_prefix, std::to_string(value->locationType));
        std::string space_prefix = prefix;
        space_prefix += "space";
        std::ostringstream oss_space;
        oss_space << std::hex << reinterpret_cast<const void*>(value->space);
        contents.emplace_back("XrSpace", space_prefix, oss_space.str());
        std::string poseinspace_prefix = prefix;
        poseinspace_prefix += "poseInSpace";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->poseInSpace, poseinspace_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrVirtualKeyboardLocationInfoMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string locationtype_prefix = prefix;
        locationtype_prefix += "locationType";
        contents.emplace_back("XrVirtualKeyboardLocationTypeMETA", locationtype_prefix, std::to_string(value->locationType));
        std::string space_prefix = prefix;
        space_prefix += "space";
        std::ostringstream oss_space;
        oss_space << std::hex << reinterpret_cast<const void*>(value->space);
        contents.emplace_back("XrSpace", space_prefix, oss_space.str());
        std::string poseinspace_prefix = prefix;
        poseinspace_prefix += "poseInSpace";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->poseInSpace, poseinspace_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string scale_prefix = prefix;
        scale_prefix += "scale";
        std::ostringstream oss_scale;
        oss_scale << std::setprecision(32) << (value->scale);
        contents.emplace_back("float", scale_prefix, oss_scale.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrVirtualKeyboardModelVisibilitySetInfoMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string visible_prefix = prefix;
        visible_prefix += "visible";
        std::ostringstream oss_visible;
        oss_visible << "0x" << std::hex << (value->visible);
        contents.emplace_back("XrBool32", visible_prefix, oss_visible.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrVirtualKeyboardAnimationStateMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string animationindex_prefix = prefix;
        animationindex_prefix += "animationIndex";
        contents.emplace_back("int32_t", animationindex_prefix, std::to_string(value->animationIndex));
        std::string fraction_prefix = prefix;
        fraction_prefix += "fraction";
        std::ostringstream oss_fraction;
        oss_fraction << std::setprecision(32) << (value->fraction);
        contents.emplace_back("float", fraction_prefix, oss_fraction.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrVirtualKeyboardModelAnimationStatesMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string statecapacityinput_prefix = prefix;
        statecapacityinput_prefix += "stateCapacityInput";
        std::ostringstream oss_stateCapacityInput;
        oss_stateCapacityInput << "0x" << std::hex << (value->stateCapacityInput);
        contents.emplace_back("uint32_t", statecapacityinput_prefix, oss_stateCapacityInput.str());
        std::string statecountoutput_prefix = prefix;
        statecountoutput_prefix += "stateCountOutput";
        std::ostringstream oss_stateCountOutput;
        oss_stateCountOutput << "0x" << std::hex << (value->stateCountOutput);
        contents.emplace_back("uint32_t", statecountoutput_prefix, oss_stateCountOutput.str());
        std::string states_prefix = prefix;
        states_prefix += "states";
        std::ostringstream oss_states;
        oss_states << std::hex << reinterpret_cast<const void*>(value->states);
        contents.emplace_back("XrVirtualKeyboardAnimationStateMETA*", states_prefix, oss_states.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrVirtualKeyboardTextureDataMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string texturewidth_prefix = prefix;
        texturewidth_prefix += "textureWidth";
        std::ostringstream oss_textureWidth;
        oss_textureWidth << "0x" << std::hex << (value->textureWidth);
        contents.emplace_back("uint32_t", texturewidth_prefix, oss_textureWidth.str());
        std::string textureheight_prefix = prefix;
        textureheight_prefix += "textureHeight";
        std::ostringstream oss_textureHeight;
        oss_textureHeight << "0x" << std::hex << (value->textureHeight);
        contents.emplace_back("uint32_t", textureheight_prefix, oss_textureHeight.str());
        std::string buffercapacityinput_prefix = prefix;
        buffercapacityinput_prefix += "bufferCapacityInput";
        std::ostringstream oss_bufferCapacityInput;
        oss_bufferCapacityInput << "0x" << std::hex << (value->bufferCapacityInput);
        contents.emplace_back("uint32_t", buffercapacityinput_prefix, oss_bufferCapacityInput.str());
        std::string buffercountoutput_prefix = prefix;
        buffercountoutput_prefix += "bufferCountOutput";
        std::ostringstream oss_bufferCountOutput;
        oss_bufferCountOutput << "0x" << std::hex << (value->bufferCountOutput);
        contents.emplace_back("uint32_t", buffercountoutput_prefix, oss_bufferCountOutput.str());
        std::string buffer_prefix = prefix;
        buffer_prefix += "buffer";
        std::ostringstream oss_buffer;
        oss_buffer << "0x" << std::hex << (value->buffer);
        contents.emplace_back("uint8_t*", buffer_prefix, oss_buffer.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrVirtualKeyboardInputInfoMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string inputsource_prefix = prefix;
        inputsource_prefix += "inputSource";
        contents.emplace_back("XrVirtualKeyboardInputSourceMETA", inputsource_prefix, std::to_string(value->inputSource));
        std::string inputspace_prefix = prefix;
        inputspace_prefix += "inputSpace";
        std::ostringstream oss_inputSpace;
        oss_inputSpace << std::hex << reinterpret_cast<const void*>(value->inputSpace);
        contents.emplace_back("XrSpace", inputspace_prefix, oss_inputSpace.str());
        std::string inputposeinspace_prefix = prefix;
        inputposeinspace_prefix += "inputPoseInSpace";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->inputPoseInSpace, inputposeinspace_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string inputstate_prefix = prefix;
        inputstate_prefix += "inputState";
        contents.emplace_back("XrVirtualKeyboardInputStateFlagsMETA", inputstate_prefix, std::to_string(value->inputState));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrVirtualKeyboardTextContextChangeInfoMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string textcontext_prefix = prefix;
        textcontext_prefix += "textContext";
        std::ostringstream oss_textContext;
        oss_textContext << std::hex << reinterpret_cast<const void*>(*value->textContext);
        contents.emplace_back("const char*", textcontext_prefix, oss_textContext.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEventDataVirtualKeyboardCommitTextMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string keyboard_prefix = prefix;
        keyboard_prefix += "keyboard";
        std::ostringstream oss_keyboard;
        oss_keyboard << std::hex << reinterpret_cast<const void*>(value->keyboard);
        contents.emplace_back("XrVirtualKeyboardMETA", keyboard_prefix, oss_keyboard.str());
        std::string text_prefix = prefix;
        text_prefix += "text";
        contents.emplace_back("char*", text_prefix, value->text);
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEventDataVirtualKeyboardBackspaceMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string keyboard_prefix = prefix;
        keyboard_prefix += "keyboard";
        std::ostringstream oss_keyboard;
        oss_keyboard << std::hex << reinterpret_cast<const void*>(value->keyboard);
        contents.emplace_back("XrVirtualKeyboardMETA", keyboard_prefix, oss_keyboard.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEventDataVirtualKeyboardEnterMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string keyboard_prefix = prefix;
        keyboard_prefix += "keyboard";
        std::ostringstream oss_keyboard;
        oss_keyboard << std::hex << reinterpret_cast<const void*>(value->keyboard);
        contents.emplace_back("XrVirtualKeyboardMETA", keyboard_prefix, oss_keyboard.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEventDataVirtualKeyboardShownMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string keyboard_prefix = prefix;
        keyboard_prefix += "keyboard";
        std::ostringstream oss_keyboard;
        oss_keyboard << std::hex << reinterpret_cast<const void*>(value->keyboard);
        contents.emplace_back("XrVirtualKeyboardMETA", keyboard_prefix, oss_keyboard.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEventDataVirtualKeyboardHiddenMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string keyboard_prefix = prefix;
        keyboard_prefix += "keyboard";
        std::ostringstream oss_keyboard;
        oss_keyboard << std::hex << reinterpret_cast<const void*>(value->keyboard);
        contents.emplace_back("XrVirtualKeyboardMETA", keyboard_prefix, oss_keyboard.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrExternalCameraIntrinsicsOCULUS* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string lastchangetime_prefix = prefix;
        lastchangetime_prefix += "lastChangeTime";
        contents.emplace_back("XrTime", lastchangetime_prefix, std::to_string(value->lastChangeTime));
        std::string fov_prefix = prefix;
        fov_prefix += "fov";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->fov, fov_prefix, "XrFovf", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string virtualnearplanedistance_prefix = prefix;
        virtualnearplanedistance_prefix += "virtualNearPlaneDistance";
        std::ostringstream oss_virtualNearPlaneDistance;
        oss_virtualNearPlaneDistance << std::setprecision(32) << (value->virtualNearPlaneDistance);
        contents.emplace_back("float", virtualnearplanedistance_prefix, oss_virtualNearPlaneDistance.str());
        std::string virtualfarplanedistance_prefix = prefix;
        virtualfarplanedistance_prefix += "virtualFarPlaneDistance";
        std::ostringstream oss_virtualFarPlaneDistance;
        oss_virtualFarPlaneDistance << std::setprecision(32) << (value->virtualFarPlaneDistance);
        contents.emplace_back("float", virtualfarplanedistance_prefix, oss_virtualFarPlaneDistance.str());
        std::string imagesensorpixelresolution_prefix = prefix;
        imagesensorpixelresolution_prefix += "imageSensorPixelResolution";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->imageSensorPixelResolution, imagesensorpixelresolution_prefix, "XrExtent2Di", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrExternalCameraExtrinsicsOCULUS* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string lastchangetime_prefix = prefix;
        lastchangetime_prefix += "lastChangeTime";
        contents.emplace_back("XrTime", lastchangetime_prefix, std::to_string(value->lastChangeTime));
        std::string camerastatusflags_prefix = prefix;
        camerastatusflags_prefix += "cameraStatusFlags";
        contents.emplace_back("XrExternalCameraStatusFlagsOCULUS", camerastatusflags_prefix, std::to_string(value->cameraStatusFlags));
        std::string attachedtodevice_prefix = prefix;
        attachedtodevice_prefix += "attachedToDevice";
        contents.emplace_back("XrExternalCameraAttachedToDeviceOCULUS", attachedtodevice_prefix, std::to_string(value->attachedToDevice));
        std::string relativepose_prefix = prefix;
        relativepose_prefix += "relativePose";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->relativePose, relativepose_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrExternalCameraOCULUS* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string name_prefix = prefix;
        name_prefix += "name";
        contents.emplace_back("char*", name_prefix, value->name);
        std::string intrinsics_prefix = prefix;
        intrinsics_prefix += "intrinsics";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->intrinsics, intrinsics_prefix, "XrExternalCameraIntrinsicsOCULUS", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string extrinsics_prefix = prefix;
        extrinsics_prefix += "extrinsics";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->extrinsics, extrinsics_prefix, "XrExternalCameraExtrinsicsOCULUS", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

#if defined(XR_USE_GRAPHICS_API_VULKAN)
bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrVulkanSwapchainCreateInfoMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string additionalcreateflags_prefix = prefix;
        additionalcreateflags_prefix += "additionalCreateFlags";
        std::ostringstream oss_additionalCreateFlags;
        oss_additionalCreateFlags << std::hex << reinterpret_cast<const void*>(value->additionalCreateFlags);
        contents.emplace_back("VkImageCreateFlags", additionalcreateflags_prefix, oss_additionalCreateFlags.str());
        std::string additionalusageflags_prefix = prefix;
        additionalusageflags_prefix += "additionalUsageFlags";
        std::ostringstream oss_additionalUsageFlags;
        oss_additionalUsageFlags << std::hex << reinterpret_cast<const void*>(value->additionalUsageFlags);
        contents.emplace_back("VkImageUsageFlags", additionalusageflags_prefix, oss_additionalUsageFlags.str());
        return true;
    } catch(...) {
    }
    return false;
}
#endif // defined(XR_USE_GRAPHICS_API_VULKAN)

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrPerformanceMetricsStateMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string enabled_prefix = prefix;
        enabled_prefix += "enabled";
        std::ostringstream oss_enabled;
        oss_enabled << "0x" << std::hex << (value->enabled);
        contents.emplace_back("XrBool32", enabled_prefix, oss_enabled.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrPerformanceMetricsCounterMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string counterflags_prefix = prefix;
        counterflags_prefix += "counterFlags";
        contents.emplace_back("XrPerformanceMetricsCounterFlagsMETA", counterflags_prefix, std::to_string(value->counterFlags));
        std::string counterunit_prefix = prefix;
        counterunit_prefix += "counterUnit";
        contents.emplace_back("XrPerformanceMetricsCounterUnitMETA", counterunit_prefix, std::to_string(value->counterUnit));
        std::string uintvalue_prefix = prefix;
        uintvalue_prefix += "uintValue";
        std::ostringstream oss_uintValue;
        oss_uintValue << "0x" << std::hex << (value->uintValue);
        contents.emplace_back("uint32_t", uintvalue_prefix, oss_uintValue.str());
        std::string floatvalue_prefix = prefix;
        floatvalue_prefix += "floatValue";
        std::ostringstream oss_floatValue;
        oss_floatValue << std::setprecision(32) << (value->floatValue);
        contents.emplace_back("float", floatvalue_prefix, oss_floatValue.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpaceListSaveInfoFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string spacecount_prefix = prefix;
        spacecount_prefix += "spaceCount";
        std::ostringstream oss_spaceCount;
        oss_spaceCount << "0x" << std::hex << (value->spaceCount);
        contents.emplace_back("uint32_t", spacecount_prefix, oss_spaceCount.str());
        std::string spaces_prefix = prefix;
        spaces_prefix += "spaces";
        std::ostringstream oss_spaces;
        oss_spaces << std::hex << reinterpret_cast<const void*>(value->spaces);
        contents.emplace_back("XrSpace*", spaces_prefix, oss_spaces.str());
        std::string location_prefix = prefix;
        location_prefix += "location";
        contents.emplace_back("XrSpaceStorageLocationFB", location_prefix, std::to_string(value->location));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEventDataSpaceListSaveCompleteFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string requestid_prefix = prefix;
        requestid_prefix += "requestId";
        contents.emplace_back("XrAsyncRequestIdFB", requestid_prefix, std::to_string(value->requestId));
        std::string result_prefix = prefix;
        result_prefix += "result";
        if (nullptr != gen_dispatch_table) {
            char result_string[XR_MAX_RESULT_STRING_SIZE] = {};
            gen_dispatch_table->ResultToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                               value->result, result_string);
            contents.emplace_back("XrResult", result_prefix, result_string);
        } else {
                        contents.emplace_back("XrResult", result_prefix, std::to_string(value->result));
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpaceUserCreateInfoFB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string userid_prefix = prefix;
        userid_prefix += "userId";
        std::ostringstream oss_userId;
        oss_userId << "0x" << std::hex << (value->userId);
        contents.emplace_back("XrSpaceUserIdFB", userid_prefix, oss_userId.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSystemHeadsetIdPropertiesMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string id_prefix = prefix;
        id_prefix += "id";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->id, id_prefix, "XrUuidEXT", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSystemSpaceDiscoveryPropertiesMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string supportsspacediscovery_prefix = prefix;
        supportsspacediscovery_prefix += "supportsSpaceDiscovery";
        std::ostringstream oss_supportsSpaceDiscovery;
        oss_supportsSpaceDiscovery << "0x" << std::hex << (value->supportsSpaceDiscovery);
        contents.emplace_back("XrBool32", supportsspacediscovery_prefix, oss_supportsSpaceDiscovery.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpaceFilterBaseHeaderMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        if (value->type == XR_TYPE_SPACE_FILTER_UUID_META) {
            const XrSpaceFilterUuidMETA* new_value = reinterpret_cast<const XrSpaceFilterUuidMETA*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        if (value->type == XR_TYPE_SPACE_FILTER_COMPONENT_META) {
            const XrSpaceFilterComponentMETA* new_value = reinterpret_cast<const XrSpaceFilterComponentMETA*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        // Fallback path - Just output generic information about the base struct
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpaceDiscoveryInfoMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string filtercount_prefix = prefix;
        filtercount_prefix += "filterCount";
        std::ostringstream oss_filterCount;
        oss_filterCount << "0x" << std::hex << (value->filterCount);
        contents.emplace_back("uint32_t", filtercount_prefix, oss_filterCount.str());
        std::string filters_prefix = prefix;
        filters_prefix += "filters";
        std::ostringstream oss_filters_array;
        oss_filters_array << std::hex << reinterpret_cast<const void*>(value->filters);
        contents.emplace_back("const XrSpaceFilterBaseHeaderMETA* const *", filters_prefix, oss_filters_array.str());
        for (uint32_t value_filters_inc = 0; value_filters_inc < value->filterCount; ++value_filters_inc) {
            std::string filters_array_prefix = filters_prefix;
            filters_array_prefix += "[";
            filters_array_prefix += std::to_string(value_filters_inc);
            filters_array_prefix += "]";
            if (nullptr == value->filters[value_filters_inc]) {
                std::ostringstream oss_filters;
                oss_filters << std::hex << reinterpret_cast<const void*>(value->filters[value_filters_inc]);
                contents.emplace_back("const XrSpaceFilterBaseHeaderMETA* const *", filters_array_prefix, oss_filters.str());
            } else if (!ApiDumpOutputXrStruct(gen_dispatch_table, value->filters[value_filters_inc], filters_array_prefix, "const XrSpaceFilterBaseHeaderMETA* const *", true, contents)) {
                throw std::invalid_argument("Invalid Operation");
            }
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpaceFilterUuidMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string uuidcount_prefix = prefix;
        uuidcount_prefix += "uuidCount";
        std::ostringstream oss_uuidCount;
        oss_uuidCount << "0x" << std::hex << (value->uuidCount);
        contents.emplace_back("uint32_t", uuidcount_prefix, oss_uuidCount.str());
        std::string uuids_prefix = prefix;
        uuids_prefix += "uuids";
        std::ostringstream oss_uuids_array;
        oss_uuids_array << std::hex << reinterpret_cast<const void*>(value->uuids);
        contents.emplace_back("const XrUuidEXT*", uuids_prefix, oss_uuids_array.str());
        for (uint32_t value_uuids_inc = 0; value_uuids_inc < value->uuidCount; ++value_uuids_inc) {
            std::string uuids_array_prefix = uuids_prefix;
            uuids_array_prefix += "[";
            uuids_array_prefix += std::to_string(value_uuids_inc);
            uuids_array_prefix += "]";
            if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->uuids[value_uuids_inc], uuids_array_prefix, "const XrUuidEXT*", false, contents)) {
                throw std::invalid_argument("Invalid Operation");
            }
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpaceFilterComponentMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string componenttype_prefix = prefix;
        componenttype_prefix += "componentType";
        contents.emplace_back("XrSpaceComponentTypeFB", componenttype_prefix, std::to_string(value->componentType));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpaceDiscoveryResultMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string space_prefix = prefix;
        space_prefix += "space";
        std::ostringstream oss_space;
        oss_space << std::hex << reinterpret_cast<const void*>(value->space);
        contents.emplace_back("XrSpace", space_prefix, oss_space.str());
        std::string uuid_prefix = prefix;
        uuid_prefix += "uuid";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->uuid, uuid_prefix, "XrUuidEXT", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpaceDiscoveryResultsMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string resultcapacityinput_prefix = prefix;
        resultcapacityinput_prefix += "resultCapacityInput";
        std::ostringstream oss_resultCapacityInput;
        oss_resultCapacityInput << "0x" << std::hex << (value->resultCapacityInput);
        contents.emplace_back("uint32_t", resultcapacityinput_prefix, oss_resultCapacityInput.str());
        std::string resultcountoutput_prefix = prefix;
        resultcountoutput_prefix += "resultCountOutput";
        std::ostringstream oss_resultCountOutput;
        oss_resultCountOutput << "0x" << std::hex << (value->resultCountOutput);
        contents.emplace_back("uint32_t", resultcountoutput_prefix, oss_resultCountOutput.str());
        std::string results_prefix = prefix;
        results_prefix += "results";
        std::ostringstream oss_results;
        oss_results << std::hex << reinterpret_cast<const void*>(value->results);
        contents.emplace_back("XrSpaceDiscoveryResultMETA*", results_prefix, oss_results.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEventDataSpaceDiscoveryResultsAvailableMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string requestid_prefix = prefix;
        requestid_prefix += "requestId";
        contents.emplace_back("XrAsyncRequestIdFB", requestid_prefix, std::to_string(value->requestId));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEventDataSpaceDiscoveryCompleteMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string requestid_prefix = prefix;
        requestid_prefix += "requestId";
        contents.emplace_back("XrAsyncRequestIdFB", requestid_prefix, std::to_string(value->requestId));
        std::string result_prefix = prefix;
        result_prefix += "result";
        if (nullptr != gen_dispatch_table) {
            char result_string[XR_MAX_RESULT_STRING_SIZE] = {};
            gen_dispatch_table->ResultToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                               value->result, result_string);
            contents.emplace_back("XrResult", result_prefix, result_string);
        } else {
                        contents.emplace_back("XrResult", result_prefix, std::to_string(value->result));
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrRecommendedLayerResolutionMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string recommendedimagedimensions_prefix = prefix;
        recommendedimagedimensions_prefix += "recommendedImageDimensions";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->recommendedImageDimensions, recommendedimagedimensions_prefix, "XrExtent2Di", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string isvalid_prefix = prefix;
        isvalid_prefix += "isValid";
        std::ostringstream oss_isValid;
        oss_isValid << "0x" << std::hex << (value->isValid);
        contents.emplace_back("XrBool32", isvalid_prefix, oss_isValid.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrRecommendedLayerResolutionGetInfoMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string layer_prefix = prefix;
        layer_prefix += "layer";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, value->layer, layer_prefix, "const XrCompositionLayerBaseHeader*", true, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string predicteddisplaytime_prefix = prefix;
        predicteddisplaytime_prefix += "predictedDisplayTime";
        contents.emplace_back("XrTime", predicteddisplaytime_prefix, std::to_string(value->predictedDisplayTime));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSystemSpacePersistencePropertiesMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string supportsspacepersistence_prefix = prefix;
        supportsspacepersistence_prefix += "supportsSpacePersistence";
        std::ostringstream oss_supportsSpacePersistence;
        oss_supportsSpacePersistence << "0x" << std::hex << (value->supportsSpacePersistence);
        contents.emplace_back("XrBool32", supportsspacepersistence_prefix, oss_supportsSpacePersistence.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpacesSaveInfoMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string spacecount_prefix = prefix;
        spacecount_prefix += "spaceCount";
        std::ostringstream oss_spaceCount;
        oss_spaceCount << "0x" << std::hex << (value->spaceCount);
        contents.emplace_back("uint32_t", spacecount_prefix, oss_spaceCount.str());
        std::string spaces_prefix = prefix;
        spaces_prefix += "spaces";
        std::ostringstream oss_spaces;
        oss_spaces << std::hex << reinterpret_cast<const void*>(value->spaces);
        contents.emplace_back("XrSpace*", spaces_prefix, oss_spaces.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEventDataSpacesSaveResultMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string requestid_prefix = prefix;
        requestid_prefix += "requestId";
        contents.emplace_back("XrAsyncRequestIdFB", requestid_prefix, std::to_string(value->requestId));
        std::string result_prefix = prefix;
        result_prefix += "result";
        if (nullptr != gen_dispatch_table) {
            char result_string[XR_MAX_RESULT_STRING_SIZE] = {};
            gen_dispatch_table->ResultToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                               value->result, result_string);
            contents.emplace_back("XrResult", result_prefix, result_string);
        } else {
                        contents.emplace_back("XrResult", result_prefix, std::to_string(value->result));
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpacesEraseInfoMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string spacecount_prefix = prefix;
        spacecount_prefix += "spaceCount";
        std::ostringstream oss_spaceCount;
        oss_spaceCount << "0x" << std::hex << (value->spaceCount);
        contents.emplace_back("uint32_t", spacecount_prefix, oss_spaceCount.str());
        std::string spaces_prefix = prefix;
        spaces_prefix += "spaces";
        std::ostringstream oss_spaces;
        oss_spaces << std::hex << reinterpret_cast<const void*>(value->spaces);
        contents.emplace_back("XrSpace*", spaces_prefix, oss_spaces.str());
        std::string uuidcount_prefix = prefix;
        uuidcount_prefix += "uuidCount";
        std::ostringstream oss_uuidCount;
        oss_uuidCount << "0x" << std::hex << (value->uuidCount);
        contents.emplace_back("uint32_t", uuidcount_prefix, oss_uuidCount.str());
        std::string uuids_prefix = prefix;
        uuids_prefix += "uuids";
        std::ostringstream oss_uuids;
        oss_uuids << std::hex << reinterpret_cast<const void*>(value->uuids);
        contents.emplace_back("XrUuidEXT*", uuids_prefix, oss_uuids.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEventDataSpacesEraseResultMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string requestid_prefix = prefix;
        requestid_prefix += "requestId";
        contents.emplace_back("XrAsyncRequestIdFB", requestid_prefix, std::to_string(value->requestId));
        std::string result_prefix = prefix;
        result_prefix += "result";
        if (nullptr != gen_dispatch_table) {
            char result_string[XR_MAX_RESULT_STRING_SIZE] = {};
            gen_dispatch_table->ResultToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                               value->result, result_string);
            contents.emplace_back("XrResult", result_prefix, result_string);
        } else {
                        contents.emplace_back("XrResult", result_prefix, std::to_string(value->result));
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrPassthroughColorLutDataMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string buffersize_prefix = prefix;
        buffersize_prefix += "bufferSize";
        std::ostringstream oss_bufferSize;
        oss_bufferSize << "0x" << std::hex << (value->bufferSize);
        contents.emplace_back("uint32_t", buffersize_prefix, oss_bufferSize.str());
        std::string buffer_prefix = prefix;
        buffer_prefix += "buffer";
        std::ostringstream oss_buffer_array;
        oss_buffer_array << std::hex << (value->buffer);
        contents.emplace_back("const uint8_t*", buffer_prefix, oss_buffer_array.str());
        for (uint32_t value_buffer_inc = 0; value_buffer_inc < value->bufferSize; ++value_buffer_inc) {
            std::string buffer_array_prefix = buffer_prefix;
            buffer_array_prefix += "[";
            buffer_array_prefix += std::to_string(value_buffer_inc);
            buffer_array_prefix += "]";
            std::ostringstream oss_buffer;
            oss_buffer << "0x" << std::hex << (value->buffer[value_buffer_inc]);
            contents.emplace_back("const uint8_t*", buffer_array_prefix, oss_buffer.str());
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrPassthroughColorLutCreateInfoMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string channels_prefix = prefix;
        channels_prefix += "channels";
        contents.emplace_back("XrPassthroughColorLutChannelsMETA", channels_prefix, std::to_string(value->channels));
        std::string resolution_prefix = prefix;
        resolution_prefix += "resolution";
        std::ostringstream oss_resolution;
        oss_resolution << "0x" << std::hex << (value->resolution);
        contents.emplace_back("uint32_t", resolution_prefix, oss_resolution.str());
        std::string data_prefix = prefix;
        data_prefix += "data";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->data, data_prefix, "XrPassthroughColorLutDataMETA", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrPassthroughColorLutUpdateInfoMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string data_prefix = prefix;
        data_prefix += "data";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->data, data_prefix, "XrPassthroughColorLutDataMETA", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrPassthroughColorMapLutMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string colorlut_prefix = prefix;
        colorlut_prefix += "colorLut";
        std::ostringstream oss_colorLut;
        oss_colorLut << std::hex << reinterpret_cast<const void*>(value->colorLut);
        contents.emplace_back("XrPassthroughColorLutMETA", colorlut_prefix, oss_colorLut.str());
        std::string weight_prefix = prefix;
        weight_prefix += "weight";
        std::ostringstream oss_weight;
        oss_weight << std::setprecision(32) << (value->weight);
        contents.emplace_back("float", weight_prefix, oss_weight.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrPassthroughColorMapInterpolatedLutMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string sourcecolorlut_prefix = prefix;
        sourcecolorlut_prefix += "sourceColorLut";
        std::ostringstream oss_sourceColorLut;
        oss_sourceColorLut << std::hex << reinterpret_cast<const void*>(value->sourceColorLut);
        contents.emplace_back("XrPassthroughColorLutMETA", sourcecolorlut_prefix, oss_sourceColorLut.str());
        std::string targetcolorlut_prefix = prefix;
        targetcolorlut_prefix += "targetColorLut";
        std::ostringstream oss_targetColorLut;
        oss_targetColorLut << std::hex << reinterpret_cast<const void*>(value->targetColorLut);
        contents.emplace_back("XrPassthroughColorLutMETA", targetcolorlut_prefix, oss_targetColorLut.str());
        std::string weight_prefix = prefix;
        weight_prefix += "weight";
        std::ostringstream oss_weight;
        oss_weight << std::setprecision(32) << (value->weight);
        contents.emplace_back("float", weight_prefix, oss_weight.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSystemPassthroughColorLutPropertiesMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string maxcolorlutresolution_prefix = prefix;
        maxcolorlutresolution_prefix += "maxColorLutResolution";
        std::ostringstream oss_maxColorLutResolution;
        oss_maxColorLutResolution << "0x" << std::hex << (value->maxColorLutResolution);
        contents.emplace_back("uint32_t", maxcolorlutresolution_prefix, oss_maxColorLutResolution.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpaceTriangleMeshGetInfoMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSpaceTriangleMeshMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string vertexcapacityinput_prefix = prefix;
        vertexcapacityinput_prefix += "vertexCapacityInput";
        std::ostringstream oss_vertexCapacityInput;
        oss_vertexCapacityInput << "0x" << std::hex << (value->vertexCapacityInput);
        contents.emplace_back("uint32_t", vertexcapacityinput_prefix, oss_vertexCapacityInput.str());
        std::string vertexcountoutput_prefix = prefix;
        vertexcountoutput_prefix += "vertexCountOutput";
        std::ostringstream oss_vertexCountOutput;
        oss_vertexCountOutput << "0x" << std::hex << (value->vertexCountOutput);
        contents.emplace_back("uint32_t", vertexcountoutput_prefix, oss_vertexCountOutput.str());
        std::string vertices_prefix = prefix;
        vertices_prefix += "vertices";
        std::ostringstream oss_vertices;
        oss_vertices << std::hex << reinterpret_cast<const void*>(value->vertices);
        contents.emplace_back("XrVector3f*", vertices_prefix, oss_vertices.str());
        std::string indexcapacityinput_prefix = prefix;
        indexcapacityinput_prefix += "indexCapacityInput";
        std::ostringstream oss_indexCapacityInput;
        oss_indexCapacityInput << "0x" << std::hex << (value->indexCapacityInput);
        contents.emplace_back("uint32_t", indexcapacityinput_prefix, oss_indexCapacityInput.str());
        std::string indexcountoutput_prefix = prefix;
        indexcountoutput_prefix += "indexCountOutput";
        std::ostringstream oss_indexCountOutput;
        oss_indexCountOutput << "0x" << std::hex << (value->indexCountOutput);
        contents.emplace_back("uint32_t", indexcountoutput_prefix, oss_indexCountOutput.str());
        std::string indices_prefix = prefix;
        indices_prefix += "indices";
        std::ostringstream oss_indices;
        oss_indices << "0x" << std::hex << (value->indices);
        contents.emplace_back("uint32_t*", indices_prefix, oss_indices.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSystemPropertiesBodyTrackingFullBodyMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string supportsfullbodytracking_prefix = prefix;
        supportsfullbodytracking_prefix += "supportsFullBodyTracking";
        std::ostringstream oss_supportsFullBodyTracking;
        oss_supportsFullBodyTracking << "0x" << std::hex << (value->supportsFullBodyTracking);
        contents.emplace_back("XrBool32", supportsfullbodytracking_prefix, oss_supportsFullBodyTracking.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEventDataPassthroughLayerResumedMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string layer_prefix = prefix;
        layer_prefix += "layer";
        std::ostringstream oss_layer;
        oss_layer << std::hex << reinterpret_cast<const void*>(value->layer);
        contents.emplace_back("XrPassthroughLayerFB", layer_prefix, oss_layer.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrBodyTrackingCalibrationStatusMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string status_prefix = prefix;
        status_prefix += "status";
        contents.emplace_back("XrBodyTrackingCalibrationStateMETA", status_prefix, std::to_string(value->status));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrBodyTrackingCalibrationInfoMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string bodyheight_prefix = prefix;
        bodyheight_prefix += "bodyHeight";
        std::ostringstream oss_bodyHeight;
        oss_bodyHeight << std::setprecision(32) << (value->bodyHeight);
        contents.emplace_back("float", bodyheight_prefix, oss_bodyHeight.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSystemPropertiesBodyTrackingCalibrationMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string supportsheightoverride_prefix = prefix;
        supportsheightoverride_prefix += "supportsHeightOverride";
        std::ostringstream oss_supportsHeightOverride;
        oss_supportsHeightOverride << "0x" << std::hex << (value->supportsHeightOverride);
        contents.emplace_back("XrBool32", supportsheightoverride_prefix, oss_supportsHeightOverride.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSystemFaceTrackingProperties2FB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string supportsvisualfacetracking_prefix = prefix;
        supportsvisualfacetracking_prefix += "supportsVisualFaceTracking";
        std::ostringstream oss_supportsVisualFaceTracking;
        oss_supportsVisualFaceTracking << "0x" << std::hex << (value->supportsVisualFaceTracking);
        contents.emplace_back("XrBool32", supportsvisualfacetracking_prefix, oss_supportsVisualFaceTracking.str());
        std::string supportsaudiofacetracking_prefix = prefix;
        supportsaudiofacetracking_prefix += "supportsAudioFaceTracking";
        std::ostringstream oss_supportsAudioFaceTracking;
        oss_supportsAudioFaceTracking << "0x" << std::hex << (value->supportsAudioFaceTracking);
        contents.emplace_back("XrBool32", supportsaudiofacetracking_prefix, oss_supportsAudioFaceTracking.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrFaceTrackerCreateInfo2FB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string faceexpressionset_prefix = prefix;
        faceexpressionset_prefix += "faceExpressionSet";
        contents.emplace_back("XrFaceExpressionSet2FB", faceexpressionset_prefix, std::to_string(value->faceExpressionSet));
        std::string requesteddatasourcecount_prefix = prefix;
        requesteddatasourcecount_prefix += "requestedDataSourceCount";
        std::ostringstream oss_requestedDataSourceCount;
        oss_requestedDataSourceCount << "0x" << std::hex << (value->requestedDataSourceCount);
        contents.emplace_back("uint32_t", requesteddatasourcecount_prefix, oss_requestedDataSourceCount.str());
        std::string requesteddatasources_prefix = prefix;
        requesteddatasources_prefix += "requestedDataSources";
        std::ostringstream oss_requestedDataSources;
        oss_requestedDataSources << std::hex << reinterpret_cast<const void*>(value->requestedDataSources);
        contents.emplace_back("XrFaceTrackingDataSource2FB*", requesteddatasources_prefix, oss_requestedDataSources.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrFaceExpressionInfo2FB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string time_prefix = prefix;
        time_prefix += "time";
        contents.emplace_back("XrTime", time_prefix, std::to_string(value->time));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrFaceExpressionWeights2FB* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string weightcount_prefix = prefix;
        weightcount_prefix += "weightCount";
        std::ostringstream oss_weightCount;
        oss_weightCount << "0x" << std::hex << (value->weightCount);
        contents.emplace_back("uint32_t", weightcount_prefix, oss_weightCount.str());
        std::string weights_prefix = prefix;
        weights_prefix += "weights";
        std::ostringstream oss_weights;
        oss_weights << std::setprecision(32) << (value->weights);
        contents.emplace_back("float*", weights_prefix, oss_weights.str());
        std::string confidencecount_prefix = prefix;
        confidencecount_prefix += "confidenceCount";
        std::ostringstream oss_confidenceCount;
        oss_confidenceCount << "0x" << std::hex << (value->confidenceCount);
        contents.emplace_back("uint32_t", confidencecount_prefix, oss_confidenceCount.str());
        std::string confidences_prefix = prefix;
        confidences_prefix += "confidences";
        std::ostringstream oss_confidences;
        oss_confidences << std::setprecision(32) << (value->confidences);
        contents.emplace_back("float*", confidences_prefix, oss_confidences.str());
        std::string isvalid_prefix = prefix;
        isvalid_prefix += "isValid";
        std::ostringstream oss_isValid;
        oss_isValid << "0x" << std::hex << (value->isValid);
        contents.emplace_back("XrBool32", isvalid_prefix, oss_isValid.str());
        std::string iseyefollowingblendshapesvalid_prefix = prefix;
        iseyefollowingblendshapesvalid_prefix += "isEyeFollowingBlendshapesValid";
        std::ostringstream oss_isEyeFollowingBlendshapesValid;
        oss_isEyeFollowingBlendshapesValid << "0x" << std::hex << (value->isEyeFollowingBlendshapesValid);
        contents.emplace_back("XrBool32", iseyefollowingblendshapesvalid_prefix, oss_isEyeFollowingBlendshapesValid.str());
        std::string datasource_prefix = prefix;
        datasource_prefix += "dataSource";
        contents.emplace_back("XrFaceTrackingDataSource2FB", datasource_prefix, std::to_string(value->dataSource));
        std::string time_prefix = prefix;
        time_prefix += "time";
        contents.emplace_back("XrTime", time_prefix, std::to_string(value->time));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSystemSpatialEntitySharingPropertiesMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string supportsspatialentitysharing_prefix = prefix;
        supportsspatialentitysharing_prefix += "supportsSpatialEntitySharing";
        std::ostringstream oss_supportsSpatialEntitySharing;
        oss_supportsSpatialEntitySharing << "0x" << std::hex << (value->supportsSpatialEntitySharing);
        contents.emplace_back("XrBool32", supportsspatialentitysharing_prefix, oss_supportsSpatialEntitySharing.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrShareSpacesRecipientBaseHeaderMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        if (value->type == XR_TYPE_SHARE_SPACES_RECIPIENT_GROUPS_META) {
            const XrShareSpacesRecipientGroupsMETA* new_value = reinterpret_cast<const XrShareSpacesRecipientGroupsMETA*>(value);
            return ApiDumpOutputXrStruct(gen_dispatch_table, new_value, prefix, type_string, is_pointer, contents);
        }
        // Fallback path - Just output generic information about the base struct
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrShareSpacesInfoMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string spacecount_prefix = prefix;
        spacecount_prefix += "spaceCount";
        std::ostringstream oss_spaceCount;
        oss_spaceCount << "0x" << std::hex << (value->spaceCount);
        contents.emplace_back("uint32_t", spacecount_prefix, oss_spaceCount.str());
        std::string spaces_prefix = prefix;
        spaces_prefix += "spaces";
        std::ostringstream oss_spaces;
        oss_spaces << std::hex << reinterpret_cast<const void*>(value->spaces);
        contents.emplace_back("XrSpace*", spaces_prefix, oss_spaces.str());
        std::string recipientinfo_prefix = prefix;
        recipientinfo_prefix += "recipientInfo";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, value->recipientInfo, recipientinfo_prefix, "const XrShareSpacesRecipientBaseHeaderMETA*", true, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEventDataShareSpacesCompleteMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string requestid_prefix = prefix;
        requestid_prefix += "requestId";
        contents.emplace_back("XrAsyncRequestIdFB", requestid_prefix, std::to_string(value->requestId));
        std::string result_prefix = prefix;
        result_prefix += "result";
        if (nullptr != gen_dispatch_table) {
            char result_string[XR_MAX_RESULT_STRING_SIZE] = {};
            gen_dispatch_table->ResultToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                               value->result, result_string);
            contents.emplace_back("XrResult", result_prefix, result_string);
        } else {
                        contents.emplace_back("XrResult", result_prefix, std::to_string(value->result));
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEnvironmentDepthProviderCreateInfoMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string createflags_prefix = prefix;
        createflags_prefix += "createFlags";
        contents.emplace_back("XrEnvironmentDepthProviderCreateFlagsMETA", createflags_prefix, std::to_string(value->createFlags));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEnvironmentDepthSwapchainCreateInfoMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string createflags_prefix = prefix;
        createflags_prefix += "createFlags";
        contents.emplace_back("XrEnvironmentDepthSwapchainCreateFlagsMETA", createflags_prefix, std::to_string(value->createFlags));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEnvironmentDepthSwapchainStateMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string width_prefix = prefix;
        width_prefix += "width";
        std::ostringstream oss_width;
        oss_width << "0x" << std::hex << (value->width);
        contents.emplace_back("uint32_t", width_prefix, oss_width.str());
        std::string height_prefix = prefix;
        height_prefix += "height";
        std::ostringstream oss_height;
        oss_height << "0x" << std::hex << (value->height);
        contents.emplace_back("uint32_t", height_prefix, oss_height.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEnvironmentDepthImageAcquireInfoMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string space_prefix = prefix;
        space_prefix += "space";
        std::ostringstream oss_space;
        oss_space << std::hex << reinterpret_cast<const void*>(value->space);
        contents.emplace_back("XrSpace", space_prefix, oss_space.str());
        std::string displaytime_prefix = prefix;
        displaytime_prefix += "displayTime";
        contents.emplace_back("XrTime", displaytime_prefix, std::to_string(value->displayTime));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEnvironmentDepthImageViewMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string fov_prefix = prefix;
        fov_prefix += "fov";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->fov, fov_prefix, "XrFovf", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string pose_prefix = prefix;
        pose_prefix += "pose";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->pose, pose_prefix, "XrPosef", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEnvironmentDepthImageMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string swapchainindex_prefix = prefix;
        swapchainindex_prefix += "swapchainIndex";
        std::ostringstream oss_swapchainIndex;
        oss_swapchainIndex << "0x" << std::hex << (value->swapchainIndex);
        contents.emplace_back("uint32_t", swapchainindex_prefix, oss_swapchainIndex.str());
        std::string nearz_prefix = prefix;
        nearz_prefix += "nearZ";
        std::ostringstream oss_nearZ;
        oss_nearZ << std::setprecision(32) << (value->nearZ);
        contents.emplace_back("float", nearz_prefix, oss_nearZ.str());
        std::string farz_prefix = prefix;
        farz_prefix += "farZ";
        std::ostringstream oss_farZ;
        oss_farZ << std::setprecision(32) << (value->farZ);
        contents.emplace_back("float", farz_prefix, oss_farZ.str());
        std::string views_prefix = prefix;
        views_prefix += "views";
        std::ostringstream oss_views_array;
        oss_views_array << std::hex << reinterpret_cast<const void*>(value->views);
        contents.emplace_back("XrEnvironmentDepthImageViewMETA*", views_prefix, oss_views_array.str());
        for (uint32_t value_views_inc = 0; value_views_inc < 2; ++value_views_inc) {
            std::string views_array_prefix = views_prefix;
            views_array_prefix += "[";
            views_array_prefix += std::to_string(value_views_inc);
            views_array_prefix += "]";
            if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->views[value_views_inc], views_array_prefix, "XrEnvironmentDepthImageViewMETA", false, contents)) {
                throw std::invalid_argument("Invalid Operation");
            }
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEnvironmentDepthImageTimestampMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string capturetime_prefix = prefix;
        capturetime_prefix += "captureTime";
        contents.emplace_back("XrTime", capturetime_prefix, std::to_string(value->captureTime));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrEnvironmentDepthHandRemovalSetInfoMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string enabled_prefix = prefix;
        enabled_prefix += "enabled";
        std::ostringstream oss_enabled;
        oss_enabled << "0x" << std::hex << (value->enabled);
        contents.emplace_back("XrBool32", enabled_prefix, oss_enabled.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrSystemEnvironmentDepthPropertiesMETA* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string supportsenvironmentdepth_prefix = prefix;
        supportsenvironmentdepth_prefix += "supportsEnvironmentDepth";
        std::ostringstream oss_supportsEnvironmentDepth;
        oss_supportsEnvironmentDepth << "0x" << std::hex << (value->supportsEnvironmentDepth);
        contents.emplace_back("XrBool32", supportsenvironmentdepth_prefix, oss_supportsEnvironmentDepth.str());
        std::string supportshandremoval_prefix = prefix;
        supportshandremoval_prefix += "supportsHandRemoval";
        std::ostringstream oss_supportsHandRemoval;
        oss_supportsHandRemoval << "0x" << std::hex << (value->supportsHandRemoval);
        contents.emplace_back("XrBool32", supportshandremoval_prefix, oss_supportsHandRemoval.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrRenderModelCreateInfoEXT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string rendermodelid_prefix = prefix;
        rendermodelid_prefix += "renderModelId";
        contents.emplace_back("XrRenderModelIdEXT", rendermodelid_prefix, std::to_string(value->renderModelId));
        std::string gltfextensioncount_prefix = prefix;
        gltfextensioncount_prefix += "gltfExtensionCount";
        std::ostringstream oss_gltfExtensionCount;
        oss_gltfExtensionCount << "0x" << std::hex << (value->gltfExtensionCount);
        contents.emplace_back("uint32_t", gltfextensioncount_prefix, oss_gltfExtensionCount.str());
        std::string gltfextensions_prefix = prefix;
        gltfextensions_prefix += "gltfExtensions";
        std::ostringstream oss_gltfExtensions_array;
        oss_gltfExtensions_array << std::hex << reinterpret_cast<const void*>(value->gltfExtensions);
        contents.emplace_back("const char* const*", gltfextensions_prefix, oss_gltfExtensions_array.str());
        for (uint32_t value_gltfextensions_inc = 0; value_gltfextensions_inc < value->gltfExtensionCount; ++value_gltfextensions_inc) {
            std::string gltfextensions_array_prefix = gltfextensions_prefix;
            gltfextensions_array_prefix += "[";
            gltfextensions_array_prefix += std::to_string(value_gltfextensions_inc);
            gltfextensions_array_prefix += "]";
            if (nullptr == value->gltfExtensions[value_gltfextensions_inc]) {
                std::ostringstream oss_gltfExtensions;
                oss_gltfExtensions << std::hex << reinterpret_cast<const void*>(value->gltfExtensions[value_gltfextensions_inc]);
                contents.emplace_back("const char* const*", gltfextensions_array_prefix, oss_gltfExtensions.str());
            } else {
                contents.emplace_back("const char* const*", gltfextensions_array_prefix, value->gltfExtensions[value_gltfextensions_inc]);
            }
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrRenderModelPropertiesGetInfoEXT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrRenderModelPropertiesEXT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string cacheid_prefix = prefix;
        cacheid_prefix += "cacheId";
        if (!ApiDumpOutputXrStruct(gen_dispatch_table, &value->cacheId, cacheid_prefix, "XrUuidEXT", false, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string animatablenodecount_prefix = prefix;
        animatablenodecount_prefix += "animatableNodeCount";
        std::ostringstream oss_animatableNodeCount;
        oss_animatableNodeCount << "0x" << std::hex << (value->animatableNodeCount);
        contents.emplace_back("uint32_t", animatablenodecount_prefix, oss_animatableNodeCount.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrRenderModelSpaceCreateInfoEXT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string rendermodel_prefix = prefix;
        rendermodel_prefix += "renderModel";
        std::ostringstream oss_renderModel;
        oss_renderModel << std::hex << reinterpret_cast<const void*>(value->renderModel);
        contents.emplace_back("XrRenderModelEXT", rendermodel_prefix, oss_renderModel.str());
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrRenderModelStateGetInfoEXT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
    (void)gen_dispatch_table;  // silence warning
    try {
        contents.emplace_back(type_string, prefix, PointerToHexString(value));
        if (is_pointer) {
            prefix += "->";
        } else {
            prefix += ".";
        }
        std::string type_prefix = prefix;
        type_prefix += "type";
        if (nullptr != gen_dispatch_table) {
            char type_string[XR_MAX_STRUCTURE_NAME_SIZE] = {};
            gen_dispatch_table->StructureTypeToString(FindInstanceFromDispatchTable(gen_dispatch_table),
                                                      value->type, type_string);
            contents.emplace_back("XrStructureType", type_prefix, type_string);
        } else {
                        contents.emplace_back("XrStructureType", type_prefix, std::to_string(value->type));
        }
        std::string next_prefix = prefix;
        next_prefix += "next";
        // Decode the next chain if it exists
        if (!ApiDumpDecodeNextChain(gen_dispatch_table, value->next, next_prefix, contents)) {
            throw std::invalid_argument("Invalid Operation");
        }
        std::string displaytime_prefix = prefix;
        displaytime_prefix += "displayTime";
        contents.emplace_back("XrTime", displaytime_prefix, std::to_string(value->displayTime));
        return true;
    } catch(...) {
    }
    return false;
}

bool ApiDumpOutputXrStruct(XrGeneratedDispatchTable* gen_dispatch_table, const XrRenderModelNodeStateEXT* value,
                           std::string prefix, std::string type_string, bool is_pointer,
                           std::vector<std::tuple<std::string, std::string, std::string>> &contents) {
