/*
 * This file is part of OpenTTD.
 * OpenTTD is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, version 2.
 * OpenTTD is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details. You should have received a copy of the GNU General Public License along with OpenTTD. If not, see <https://www.gnu.org/licenses/old-licenses/gpl-2.0>.
 */

/* THIS FILE IS AUTO-GENERATED; PLEASE DO NOT ALTER MANUALLY */

#include "../script_tile.hpp"
#include "../template/template_tile.sq.hpp"


template <> SQInteger PushClassName<ScriptTile, ScriptType::GS>(HSQUIRRELVM vm) { sq_pushstring(vm, "GSTile"); return 1; }

void SQGSTile_Register(Squirrel &engine)
{
	DefSQClass<ScriptTile, ScriptType::GS> SQGSTile("GSTile");
	SQGSTile.PreRegister(engine, "GSObject");

	SQGSTile.DefSQConst(engine, ScriptTile::ERR_TILE_BASE,               "ERR_TILE_BASE");
	SQGSTile.DefSQConst(engine, ScriptTile::ERR_TILE_TOO_HIGH,           "ERR_TILE_TOO_HIGH");
	SQGSTile.DefSQConst(engine, ScriptTile::ERR_TILE_TOO_LOW,            "ERR_TILE_TOO_LOW");
	SQGSTile.DefSQConst(engine, ScriptTile::ERR_AREA_ALREADY_FLAT,       "ERR_AREA_ALREADY_FLAT");
	SQGSTile.DefSQConst(engine, ScriptTile::ERR_EXCAVATION_WOULD_DAMAGE, "ERR_EXCAVATION_WOULD_DAMAGE");
	SQGSTile.DefSQConst(engine, ScriptTile::ERR_LIMIT_REACHED,           "ERR_LIMIT_REACHED");
	SQGSTile.DefSQConst(engine, ScriptTile::CORNER_W,                    "CORNER_W");
	SQGSTile.DefSQConst(engine, ScriptTile::CORNER_S,                    "CORNER_S");
	SQGSTile.DefSQConst(engine, ScriptTile::CORNER_E,                    "CORNER_E");
	SQGSTile.DefSQConst(engine, ScriptTile::CORNER_N,                    "CORNER_N");
	SQGSTile.DefSQConst(engine, ScriptTile::CORNER_INVALID,              "CORNER_INVALID");
	SQGSTile.DefSQConst(engine, ScriptTile::SLOPE_FLAT,                  "SLOPE_FLAT");
	SQGSTile.DefSQConst(engine, ScriptTile::SLOPE_W,                     "SLOPE_W");
	SQGSTile.DefSQConst(engine, ScriptTile::SLOPE_S,                     "SLOPE_S");
	SQGSTile.DefSQConst(engine, ScriptTile::SLOPE_E,                     "SLOPE_E");
	SQGSTile.DefSQConst(engine, ScriptTile::SLOPE_N,                     "SLOPE_N");
	SQGSTile.DefSQConst(engine, ScriptTile::SLOPE_STEEP,                 "SLOPE_STEEP");
	SQGSTile.DefSQConst(engine, ScriptTile::SLOPE_NW,                    "SLOPE_NW");
	SQGSTile.DefSQConst(engine, ScriptTile::SLOPE_SW,                    "SLOPE_SW");
	SQGSTile.DefSQConst(engine, ScriptTile::SLOPE_SE,                    "SLOPE_SE");
	SQGSTile.DefSQConst(engine, ScriptTile::SLOPE_NE,                    "SLOPE_NE");
	SQGSTile.DefSQConst(engine, ScriptTile::SLOPE_EW,                    "SLOPE_EW");
	SQGSTile.DefSQConst(engine, ScriptTile::SLOPE_NS,                    "SLOPE_NS");
	SQGSTile.DefSQConst(engine, ScriptTile::SLOPE_ELEVATED,              "SLOPE_ELEVATED");
	SQGSTile.DefSQConst(engine, ScriptTile::SLOPE_NWS,                   "SLOPE_NWS");
	SQGSTile.DefSQConst(engine, ScriptTile::SLOPE_WSE,                   "SLOPE_WSE");
	SQGSTile.DefSQConst(engine, ScriptTile::SLOPE_SEN,                   "SLOPE_SEN");
	SQGSTile.DefSQConst(engine, ScriptTile::SLOPE_ENW,                   "SLOPE_ENW");
	SQGSTile.DefSQConst(engine, ScriptTile::SLOPE_STEEP_W,               "SLOPE_STEEP_W");
	SQGSTile.DefSQConst(engine, ScriptTile::SLOPE_STEEP_S,               "SLOPE_STEEP_S");
	SQGSTile.DefSQConst(engine, ScriptTile::SLOPE_STEEP_E,               "SLOPE_STEEP_E");
	SQGSTile.DefSQConst(engine, ScriptTile::SLOPE_STEEP_N,               "SLOPE_STEEP_N");
	SQGSTile.DefSQConst(engine, ScriptTile::SLOPE_INVALID,               "SLOPE_INVALID");
	SQGSTile.DefSQConst(engine, ScriptTile::TRANSPORT_RAIL,              "TRANSPORT_RAIL");
	SQGSTile.DefSQConst(engine, ScriptTile::TRANSPORT_ROAD,              "TRANSPORT_ROAD");
	SQGSTile.DefSQConst(engine, ScriptTile::TRANSPORT_WATER,             "TRANSPORT_WATER");
	SQGSTile.DefSQConst(engine, ScriptTile::TRANSPORT_AIR,               "TRANSPORT_AIR");
	SQGSTile.DefSQConst(engine, ScriptTile::TRANSPORT_INVALID,           "TRANSPORT_INVALID");
	SQGSTile.DefSQConst(engine, ScriptTile::BT_FOUNDATION,               "BT_FOUNDATION");
	SQGSTile.DefSQConst(engine, ScriptTile::BT_TERRAFORM,                "BT_TERRAFORM");
	SQGSTile.DefSQConst(engine, ScriptTile::BT_BUILD_TREES,              "BT_BUILD_TREES");
	SQGSTile.DefSQConst(engine, ScriptTile::BT_CLEAR_GRASS,              "BT_CLEAR_GRASS");
	SQGSTile.DefSQConst(engine, ScriptTile::BT_CLEAR_ROUGH,              "BT_CLEAR_ROUGH");
	SQGSTile.DefSQConst(engine, ScriptTile::BT_CLEAR_ROCKY,              "BT_CLEAR_ROCKY");
	SQGSTile.DefSQConst(engine, ScriptTile::BT_CLEAR_FIELDS,             "BT_CLEAR_FIELDS");
	SQGSTile.DefSQConst(engine, ScriptTile::BT_CLEAR_HOUSE,              "BT_CLEAR_HOUSE");
	SQGSTile.DefSQConst(engine, ScriptTile::BT_CLEAR_WATER,              "BT_CLEAR_WATER");
	SQGSTile.DefSQConst(engine, ScriptTile::TERRAIN_NORMAL,              "TERRAIN_NORMAL");
	SQGSTile.DefSQConst(engine, ScriptTile::TERRAIN_DESERT,              "TERRAIN_DESERT");
	SQGSTile.DefSQConst(engine, ScriptTile::TERRAIN_RAINFOREST,          "TERRAIN_RAINFOREST");
	SQGSTile.DefSQConst(engine, ScriptTile::TERRAIN_SNOW,                "TERRAIN_SNOW");

	ScriptError::RegisterErrorMap(STR_ERROR_ALREADY_AT_SEA_LEVEL,     ScriptTile::ERR_TILE_TOO_HIGH);
	ScriptError::RegisterErrorMap(STR_ERROR_ALREADY_AT_SEA_LEVEL,     ScriptTile::ERR_TILE_TOO_LOW);
	ScriptError::RegisterErrorMap(STR_ERROR_ALREADY_LEVELLED,         ScriptTile::ERR_AREA_ALREADY_FLAT);
	ScriptError::RegisterErrorMap(STR_ERROR_EXCAVATION_WOULD_DAMAGE,  ScriptTile::ERR_EXCAVATION_WOULD_DAMAGE);
	ScriptError::RegisterErrorMap(STR_ERROR_TERRAFORM_LIMIT_REACHED,  ScriptTile::ERR_LIMIT_REACHED);
	ScriptError::RegisterErrorMap(STR_ERROR_CLEARING_LIMIT_REACHED,   ScriptTile::ERR_LIMIT_REACHED);
	ScriptError::RegisterErrorMap(STR_ERROR_TREE_PLANT_LIMIT_REACHED, ScriptTile::ERR_LIMIT_REACHED);

	ScriptError::RegisterErrorMapString(ScriptTile::ERR_TILE_TOO_HIGH,           "ERR_TILE_TOO_HIGH");
	ScriptError::RegisterErrorMapString(ScriptTile::ERR_TILE_TOO_LOW,            "ERR_TILE_TOO_LOW");
	ScriptError::RegisterErrorMapString(ScriptTile::ERR_AREA_ALREADY_FLAT,       "ERR_AREA_ALREADY_FLAT");
	ScriptError::RegisterErrorMapString(ScriptTile::ERR_EXCAVATION_WOULD_DAMAGE, "ERR_EXCAVATION_WOULD_DAMAGE");
	ScriptError::RegisterErrorMapString(ScriptTile::ERR_LIMIT_REACHED,           "ERR_LIMIT_REACHED");

	SQGSTile.DefSQStaticMethod(engine, &ScriptTile::IsBuildable,                "IsBuildable",                ".i");
	SQGSTile.DefSQStaticMethod(engine, &ScriptTile::IsBuildableRectangle,       "IsBuildableRectangle",       ".iii");
	SQGSTile.DefSQStaticMethod(engine, &ScriptTile::IsSeaTile,                  "IsSeaTile",                  ".i");
	SQGSTile.DefSQStaticMethod(engine, &ScriptTile::IsRiverTile,                "IsRiverTile",                ".i");
	SQGSTile.DefSQStaticMethod(engine, &ScriptTile::IsWaterTile,                "IsWaterTile",                ".i");
	SQGSTile.DefSQStaticMethod(engine, &ScriptTile::IsCoastTile,                "IsCoastTile",                ".i");
	SQGSTile.DefSQStaticMethod(engine, &ScriptTile::IsStationTile,              "IsStationTile",              ".i");
	SQGSTile.DefSQStaticMethod(engine, &ScriptTile::IsSteepSlope,               "IsSteepSlope",               ".i");
	SQGSTile.DefSQStaticMethod(engine, &ScriptTile::IsHalftileSlope,            "IsHalftileSlope",            ".i");
	SQGSTile.DefSQStaticMethod(engine, &ScriptTile::HasTreeOnTile,              "HasTreeOnTile",              ".i");
	SQGSTile.DefSQStaticMethod(engine, &ScriptTile::IsFarmTile,                 "IsFarmTile",                 ".i");
	SQGSTile.DefSQStaticMethod(engine, &ScriptTile::IsRockTile,                 "IsRockTile",                 ".i");
	SQGSTile.DefSQStaticMethod(engine, &ScriptTile::IsRoughTile,                "IsRoughTile",                ".i");
	SQGSTile.DefSQStaticMethod(engine, &ScriptTile::IsSnowTile,                 "IsSnowTile",                 ".i");
	SQGSTile.DefSQStaticMethod(engine, &ScriptTile::IsDesertTile,               "IsDesertTile",               ".i");
	SQGSTile.DefSQStaticMethod(engine, &ScriptTile::IsHouseTile,                "IsHouseTile",                ".i");
	SQGSTile.DefSQStaticMethod(engine, &ScriptTile::GetTerrainType,             "GetTerrainType",             ".i");
	SQGSTile.DefSQStaticMethod(engine, &ScriptTile::GetSlope,                   "GetSlope",                   ".i");
	SQGSTile.DefSQStaticMethod(engine, &ScriptTile::GetComplementSlope,         "GetComplementSlope",         ".i");
	SQGSTile.DefSQStaticMethod(engine, &ScriptTile::GetMinHeight,               "GetMinHeight",               ".i");
	SQGSTile.DefSQStaticMethod(engine, &ScriptTile::GetMaxHeight,               "GetMaxHeight",               ".i");
	SQGSTile.DefSQStaticMethod(engine, &ScriptTile::GetCornerHeight,            "GetCornerHeight",            ".ii");
	SQGSTile.DefSQStaticMethod(engine, &ScriptTile::GetOwner,                   "GetOwner",                   ".i");
	SQGSTile.DefSQStaticMethod(engine, &ScriptTile::HasTransportType,           "HasTransportType",           ".ii");
	SQGSTile.DefSQStaticMethod(engine, &ScriptTile::GetCargoAcceptance,         "GetCargoAcceptance",         ".iiiii");
	SQGSTile.DefSQStaticMethod(engine, &ScriptTile::GetCargoProduction,         "GetCargoProduction",         ".iiiii");
	SQGSTile.DefSQStaticMethod(engine, &ScriptTile::GetDistanceManhattanToTile, "GetDistanceManhattanToTile", ".ii");
	SQGSTile.DefSQStaticMethod(engine, &ScriptTile::GetDistanceSquareToTile,    "GetDistanceSquareToTile",    ".ii");
	SQGSTile.DefSQStaticMethod(engine, &ScriptTile::RaiseTile,                  "RaiseTile",                  ".ii");
	SQGSTile.DefSQStaticMethod(engine, &ScriptTile::LowerTile,                  "LowerTile",                  ".ii");
	SQGSTile.DefSQStaticMethod(engine, &ScriptTile::LevelTiles,                 "LevelTiles",                 ".ii");
	SQGSTile.DefSQStaticMethod(engine, &ScriptTile::DemolishTile,               "DemolishTile",               ".i");
	SQGSTile.DefSQStaticMethod(engine, &ScriptTile::PlantTree,                  "PlantTree",                  ".i");
	SQGSTile.DefSQStaticMethod(engine, &ScriptTile::PlantTreeRectangle,         "PlantTreeRectangle",         ".iii");
	SQGSTile.DefSQStaticMethod(engine, &ScriptTile::IsWithinTownInfluence,      "IsWithinTownInfluence",      ".ii");
	SQGSTile.DefSQStaticMethod(engine, &ScriptTile::GetTownAuthority,           "GetTownAuthority",           ".i");
	SQGSTile.DefSQStaticMethod(engine, &ScriptTile::GetClosestTown,             "GetClosestTown",             ".i");
	SQGSTile.DefSQStaticMethod(engine, &ScriptTile::GetBuildCost,               "GetBuildCost",               ".i");

	SQGSTile.PostRegister(engine);
}
