// Code generated by ndpgen. DO NOT EDIT.

package host

import (
	"context"
	"encoding/json"

	extism "github.com/extism/go-sdk"
)

// LibraryGetLibraryRequest is the request type for Library.GetLibrary.
type LibraryGetLibraryRequest struct {
	Id int32 `json:"id"`
}

// LibraryGetLibraryResponse is the response type for Library.GetLibrary.
type LibraryGetLibraryResponse struct {
	Result *Library `json:"result,omitempty"`
	Error  string   `json:"error,omitempty"`
}

// LibraryGetAllLibrariesResponse is the response type for Library.GetAllLibraries.
type LibraryGetAllLibrariesResponse struct {
	Result []Library `json:"result,omitempty"`
	Error  string    `json:"error,omitempty"`
}

// RegisterLibraryHostFunctions registers Library service host functions.
// The returned host functions should be added to the plugin's configuration.
func RegisterLibraryHostFunctions(service LibraryService) []extism.HostFunction {
	return []extism.HostFunction{
		newLibraryGetLibraryHostFunction(service),
		newLibraryGetAllLibrariesHostFunction(service),
	}
}

func newLibraryGetLibraryHostFunction(service LibraryService) extism.HostFunction {
	return extism.NewHostFunctionWithStack(
		"library_getlibrary",
		func(ctx context.Context, p *extism.CurrentPlugin, stack []uint64) {
			// Read JSON request from plugin memory
			reqBytes, err := p.ReadBytes(stack[0])
			if err != nil {
				libraryWriteError(p, stack, err)
				return
			}
			var req LibraryGetLibraryRequest
			if err := json.Unmarshal(reqBytes, &req); err != nil {
				libraryWriteError(p, stack, err)
				return
			}

			// Call the service method
			result, svcErr := service.GetLibrary(ctx, req.Id)
			if svcErr != nil {
				libraryWriteError(p, stack, svcErr)
				return
			}

			// Write JSON response to plugin memory
			resp := LibraryGetLibraryResponse{
				Result: result,
			}
			libraryWriteResponse(p, stack, resp)
		},
		[]extism.ValueType{extism.ValueTypePTR},
		[]extism.ValueType{extism.ValueTypePTR},
	)
}

func newLibraryGetAllLibrariesHostFunction(service LibraryService) extism.HostFunction {
	return extism.NewHostFunctionWithStack(
		"library_getalllibraries",
		func(ctx context.Context, p *extism.CurrentPlugin, stack []uint64) {

			// Call the service method
			result, svcErr := service.GetAllLibraries(ctx)
			if svcErr != nil {
				libraryWriteError(p, stack, svcErr)
				return
			}

			// Write JSON response to plugin memory
			resp := LibraryGetAllLibrariesResponse{
				Result: result,
			}
			libraryWriteResponse(p, stack, resp)
		},
		[]extism.ValueType{extism.ValueTypePTR},
		[]extism.ValueType{extism.ValueTypePTR},
	)
}

// libraryWriteResponse writes a JSON response to plugin memory.
func libraryWriteResponse(p *extism.CurrentPlugin, stack []uint64, resp any) {
	respBytes, err := json.Marshal(resp)
	if err != nil {
		libraryWriteError(p, stack, err)
		return
	}
	respPtr, err := p.WriteBytes(respBytes)
	if err != nil {
		stack[0] = 0
		return
	}
	stack[0] = respPtr
}

// libraryWriteError writes an error response to plugin memory.
func libraryWriteError(p *extism.CurrentPlugin, stack []uint64, err error) {
	errResp := struct {
		Error string `json:"error"`
	}{Error: err.Error()}
	respBytes, _ := json.Marshal(errResp)
	respPtr, _ := p.WriteBytes(respBytes)
	stack[0] = respPtr
}
