// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

var (
	protoPoolValueType = sync.Pool{
		New: func() any {
			return &otlpprofiles.ValueType{}
		},
	}
)

func NewOrigValueType() *otlpprofiles.ValueType {
	if !UseProtoPooling.IsEnabled() {
		return &otlpprofiles.ValueType{}
	}
	return protoPoolValueType.Get().(*otlpprofiles.ValueType)
}

func DeleteOrigValueType(orig *otlpprofiles.ValueType, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	orig.Reset()
	if nullable {
		protoPoolValueType.Put(orig)
	}
}

func CopyOrigValueType(dest, src *otlpprofiles.ValueType) {
	// If copying to same object, just return.
	if src == dest {
		return
	}
	dest.TypeStrindex = src.TypeStrindex
	dest.UnitStrindex = src.UnitStrindex
	dest.AggregationTemporality = src.AggregationTemporality
}

func GenTestOrigValueType() *otlpprofiles.ValueType {
	orig := NewOrigValueType()
	orig.TypeStrindex = int32(13)
	orig.UnitStrindex = int32(13)
	orig.AggregationTemporality = otlpprofiles.AggregationTemporality(1)
	return orig
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigValueType(orig *otlpprofiles.ValueType, dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.TypeStrindex != int32(0) {
		dest.WriteObjectField("typeStrindex")
		dest.WriteInt32(orig.TypeStrindex)
	}
	if orig.UnitStrindex != int32(0) {
		dest.WriteObjectField("unitStrindex")
		dest.WriteInt32(orig.UnitStrindex)
	}

	if int32(orig.AggregationTemporality) != 0 {
		dest.WriteObjectField("aggregationTemporality")
		dest.WriteInt32(int32(orig.AggregationTemporality))
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigValueType unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigValueType(orig *otlpprofiles.ValueType, iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "typeStrindex", "type_strindex":
			orig.TypeStrindex = iter.ReadInt32()
		case "unitStrindex", "unit_strindex":
			orig.UnitStrindex = iter.ReadInt32()
		case "aggregationTemporality", "aggregation_temporality":
			orig.AggregationTemporality = otlpprofiles.AggregationTemporality(iter.ReadEnumValue(otlpprofiles.AggregationTemporality_value))
		default:
			iter.Skip()
		}
	}
}

func SizeProtoOrigValueType(orig *otlpprofiles.ValueType) int {
	var n int
	var l int
	_ = l
	if orig.TypeStrindex != 0 {
		n += 1 + proto.Sov(uint64(orig.TypeStrindex))
	}
	if orig.UnitStrindex != 0 {
		n += 1 + proto.Sov(uint64(orig.UnitStrindex))
	}
	if orig.AggregationTemporality != 0 {
		n += 1 + proto.Sov(uint64(orig.AggregationTemporality))
	}
	return n
}

func MarshalProtoOrigValueType(orig *otlpprofiles.ValueType, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	if orig.TypeStrindex != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.TypeStrindex))
		pos--
		buf[pos] = 0x8
	}
	if orig.UnitStrindex != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.UnitStrindex))
		pos--
		buf[pos] = 0x10
	}
	if orig.AggregationTemporality != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.AggregationTemporality))
		pos--
		buf[pos] = 0x18
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigValueType(orig *otlpprofiles.ValueType, buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field TypeStrindex", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.TypeStrindex = int32(num)

		case 2:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field UnitStrindex", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.UnitStrindex = int32(num)

		case 3:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field AggregationTemporality", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.AggregationTemporality = otlpprofiles.AggregationTemporality(num)
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}
