#ifndef __HQ4X_LUT_DEFINE__
#define __HQ4X_LUT_DEFINE__

static const struct {
  unsigned int 	 width;
  unsigned int 	 height;
  unsigned int 	 bytes_per_pixel; /* 2:RGB16, 3:RGB, 4:RGBA */ 
  unsigned char	 pixel_data[256 * 256 * 4 + 1];
} hq4x_LUT = {
  256, 256, 4,
  {2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0
  ,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1
  ,5,3,0,0,3,0,0,1,2,0,1,1,2,0,1,1,5,3,0,0,3,0,0,1,5,3,0,0,5,0,0,3,0,0,1,1
  ,0,0,1,1,5,3,0,0,5,0,0,3,5,3,0,0,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0
  ,5,0,0,3,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,3,0,0,1,2,0,1,1,2,0,1,1
  ,5,3,0,0,3,0,0,1,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,5,3,0,0
  ,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,5,3,0,0,3,0,1,0,0,0,1,1,0,0,1,1,5,3,0,0,3,0,1,0,2,0,1,1,0,0,1,1,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3
  ,2,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,3,0,1,0,5,3,0,0,0,0,1,1
  ,5,3,0,0,3,0,1,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,3,0,0,1,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0,3,0,1,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,5,3,0,0,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,0,0,1,1,0,0,1,1
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0
  ,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,0,0,1,1
  ,0,0,1,1,5,3,0,0,5,0,0,3,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0
  ,5,0,0,3,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,2,0,1,1
  ,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,5,3,0,0,0,0,1,1,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3
  ,2,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,0,0,1,1
  ,5,3,0,0,5,0,0,3,5,3,0,0,2,0,1,1,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,1,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3
  ,0,0,3,5,0,0,3,5,5,0,1,2,5,0,1,2,3,1,0,0,1,0,0,3,5,0,1,2,5,0,1,2,3,1,0,0
  ,1,0,0,3,5,1,0,2,5,0,0,3,1,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,1
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2
  ,5,0,0,3,1,0,1,2,1,0,1,2,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,1,0,0,3,5,0,1,2,5,0,1,2,3,1,0,0,1,0,0,3,5,1,0,2,5,0,0,3,3,0,0,1
  ,1,0,0,1,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,1,0,0,1,1,0,0,1,5,1,0,2
  ,5,0,0,3,3,0,0,1,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,3,0,0,1
  ,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,1,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,1,0,0,3,5,1,0,2,5,0,0,3
  ,3,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,1,0,0,1,1,0,0,1
  ,5,1,0,2,5,0,0,3,0,0,3,5,0,0,3,5,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3
  ,3,0,0,1,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,1,0,2,5,0,0,3,1,0,1,2,1,0,1,2,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2
  ,5,0,0,3,3,0,0,1,1,0,1,2,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,0,0,1
  ,1,0,0,1,5,1,0,2,5,0,0,3,3,0,0,1,0,0,3,5,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,1,0,2
  ,5,0,0,3,3,1,0,0,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,3,1,0,0
  ,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,1,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,1,0,0,3,1,0,0,3,5,1,0,2,5,1,0,2,1,0,0,1
  ,0,0,3,5,5,0,0,3,5,0,0,3,1,0,0,1,0,0,3,5,5,1,0,2,5,1,0,2,1,0,0,1,3,1,0,0
  ,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2
  ,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2
  ,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,1,0,0,1,0,0,3,5,5,0,0,3,5,0,0,3,1,0,0,1
  ,0,0,3,5,5,1,0,2,5,1,0,2,3,0,0,1,3,0,0,1,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,1
  ,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2
  ,1,0,0,1,3,0,0,1,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,1,5,1,0,2,5,1,0,2,3,0,0,1
  ,3,0,0,1,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0
  ,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2
  ,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,3,0,0,1,3,0,0,1,5,0,0,3,5,0,0,3
  ,1,0,0,1,0,0,3,5,5,1,0,2,5,1,0,2,3,0,0,1,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,1
  ,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,1,0,0,3,1,0,0,3,5,1,0,2
  ,5,1,0,2,1,0,1,2,3,0,0,1,5,0,0,3,5,0,0,3,1,0,1,2,1,0,0,0,5,1,0,2,5,1,0,2
  ,3,0,0,1,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0
  ,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,1,0,1,2,3,0,0,1,5,0,0,3
  ,5,0,0,3,1,0,1,2,1,0,0,0,5,1,0,2,5,1,0,2,3,0,0,1,3,1,0,0,5,0,0,3,5,0,0,3
  ,1,0,1,2,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0
  ,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,1,0,0,3
  ,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,0,5,1,0,2
  ,5,1,0,2,3,0,0,1,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,3,0,0,1,3,1,0,0
  ,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3
  ,5,0,0,3,1,0,0,1,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,3,0,0,1
  ,3,0,0,1,5,3,0,0,5,3,0,0,0,0,1,1,0,0,1,1,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1
  ,5,3,0,0,5,3,0,0,0,0,1,1,5,3,0,0,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,0,0,1,1
  ,0,0,1,1,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,0,0,1,1,2,0,1,1,3,0,1,0,3,0,1,0,0,0,1,1
  ,0,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0
  ,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1
  ,5,3,0,0,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,3,0,0,1,3,0,0,1,5,3,0,0,5,3,0,0,0,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3
  ,0,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,5,3,0,0,5,0,0,3,5,0,0,3,0,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0
  ,5,3,0,0,0,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,0,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,2,0,1,1,5,3,0,0,5,0,0,3,5,0,0,3,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,2,0,1,1,2,0,1,1,5,0,3,0,3,0,0,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,3,0,1,0
  ,3,0,1,0,0,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,5,3,0,0,5,0,0,3,3,0,1,0
  ,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0
  ,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0
  ,5,3,0,0,5,3,0,0,2,0,1,1,5,3,0,0,5,0,0,3,5,0,0,3,0,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,0,0,1,1,2,0,1,1,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,1,0,1,0
  ,1,0,1,0,3,1,0,0,7,0,0,1,1,0,2,1,1,0,2,1,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,1,0,1,0,1,0,1,0,3,1,0,0
  ,7,0,0,1,3,1,0,0,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,0,0,5,3,0,0,5,3,3,1,0,0,7,0,0,1,3,0,1,0
  ,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,1,0,3,0
  ,1,0,1,0,1,0,1,0,3,1,0,0,1,0,3,0,3,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0
  ,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,1,0,3,0,3,1,0,0,1,0,1,0,3,1,0,0,1,0,3,0
  ,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0,3,1,0,0,1,0,3,0,3,1,0,0,1,0,0,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0
  ,7,0,0,1,1,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,1,0,2,1,1,0,2,1,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0
  ,1,0,1,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,0,0,5,3,0,0,5,3,3,1,0,0
  ,7,0,0,1,3,0,1,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0,0,0,5,3,3,1,0,0,7,0,0,1,3,1,0,0
  ,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,2,1,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1
  ,3,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0
  ,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,1,0,3,1,0,0,7,0,0,1
  ,3,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0
  ,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0
  ,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,1,0,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1
  ,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0
  ,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0
  ,7,0,0,1,6,0,1,1,6,0,1,1,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0
  ,6,0,1,1,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0
  ,7,0,0,1,1,0,0,0,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1
  ,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0
  ,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,1,0,0,0,6,0,1,1,7,0,0,1
  ,7,0,0,1,1,0,0,0,6,0,1,1,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,0,0,1
  ,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0
  ,7,1,0,0,7,1,0,0,1,0,0,0,6,0,1,1,7,0,0,1,7,0,0,1,1,0,0,0,6,0,1,1,7,1,0,0
  ,7,1,0,0,1,0,0,0,1,0,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,1,0,0,0,1,0,0,0
  ,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,1,0,0,0,1,0,0,0,7,0,0,1
  ,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1
  ,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0
  ,7,0,1,0,7,1,0,0,7,1,0,0,1,0,0,0,1,0,0,0,7,0,0,1,7,0,0,1,1,0,0,0,6,0,1,1
  ,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,6,0,1,1
  ,1,0,0,0,7,0,0,1,7,0,0,1,6,0,1,1,1,0,0,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0
  ,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1
  ,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1
  ,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,6,0,1,1,1,0,0,0,7,0,0,1,7,0,0,1,6,0,1,1
  ,1,0,0,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,0,0,1,6,0,1,1,1,0,0,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,1,0,0,0
  ,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0
  ,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1
  ,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,0,0,1
  ,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0
  ,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0
  ,3,1,0,0,1,0,1,0,1,0,2,1,7,0,0,1,7,0,0,1,1,0,1,0,1,0,2,1,3,1,0,0,3,1,0,0
  ,1,0,1,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0
  ,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,1,0,1,0,1,0,2,1,7,0,0,1
  ,7,0,0,1,1,0,1,0,1,0,2,1,3,1,0,0,3,1,0,0,3,0,1,0,3,0,1,0,7,0,0,1,7,0,0,1
  ,1,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0
  ,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0
  ,3,1,0,0,3,1,0,0,1,0,1,0,3,0,1,0,1,0,3,0,1,0,3,0,1,0,1,0,1,0,1,0,3,1,0,0
  ,3,1,0,0,3,0,1,0,3,0,1,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,0,1,0,3,0,1,0
  ,7,0,0,1,7,0,0,1,1,0,1,0,1,0,2,1,3,1,0,0,3,1,0,0,3,0,1,0,3,1,0,0,7,0,0,1
  ,7,0,0,1,1,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1
  ,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0
  ,5,0,3,0,3,1,0,0,3,1,0,0,0,0,5,3,3,0,1,0,7,0,0,1,7,0,0,1,0,0,5,3,1,0,0,0
  ,3,1,0,0,3,1,0,0,3,0,1,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,0,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,0,0,5,3
  ,3,0,1,0,7,0,0,1,7,0,0,1,0,0,5,3,1,0,0,0,3,1,0,0,3,1,0,0,3,0,1,0,3,1,0,0
  ,7,0,0,1,7,0,0,1,0,0,5,3,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1
  ,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1
  ,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,3,0,1,0,3,0,1,0,1,0
  ,1,0,0,0,3,1,0,0,3,1,0,0,3,0,1,0,3,1,0,0,7,0,0,1,1,0,3,0,1,0,1,0,1,0,0,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0
  ,3,0,1,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,7,0,0,1,7,0,0,1,1,0,3,0,1,0,3,0,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,1,0,1,0,0,0,5,3,1,0,1,0,3,1,0,0
  ,1,0,1,0,0,0,5,3,3,0,1,0,3,0,1,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,1,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0
  ,3,0,1,0,3,1,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,1,0,1,0,0,0,5,3,1,0,1,0,1,0,1,0,1,0,1,0,0,0,5,3,1,0,1,0,1,0,1,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,1,0
  ,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0,5,3,1,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,1,0,3,0,1,0,3,0,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,1,0,3,0,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,1,0,2,1,3,0,1,0
  ,3,0,1,0,3,1,0,0,1,0,2,1,3,0,1,0,3,0,1,0,3,1,0,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,3,1,0,0,3,1,0,0,3,0,1,0,3,1,0,0
  ,3,0,1,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,1,0,2,1,1,0,0,0,1,0,1,0,1,0,0,0,1,0,2,1,1,0,0,0
  ,1,0,2,1,1,0,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,1,0,1,0,1,0,0,0,1,0,1,0,1,0,0,0,1,0,1,0,1,0,0,0,1,0,1,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,1,0,0,0,6,0,1,1,1,0,0,0,7,1,0,0,1,0,0,0,6,0,1,1,1,0,0,0,1,0,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,7,1,0,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,6,0,1,1,1,0,0,0,1,0,0,0
  ,1,0,0,0,6,0,1,1,1,0,0,0,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1
  ,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,6,0,1,1,1,0,0,0,1,0,0,0,7,1,0,0,6,0,1,1,1,0,0,0,1,0,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,6,0,1,1,1,0,0,0
  ,1,0,0,0,1,0,0,0,6,0,1,1,1,0,0,0,6,0,1,1,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1
  ,6,0,1,1,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0
  ,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,6,0,1,1,1,0,0,0,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,1,0,0,0,6,0,1,1,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,1,0,1,0,1,0,1,0
  ,1,0,1,0,3,0,1,0,0,0,5,3,0,0,5,3,3,1,0,0,3,0,1,0,1,0,1,0,3,0,1,0,3,0,1,0
  ,3,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0,3,1,0,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,1,0,2,1,1,0,2,1,3,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,0,1,0,3,0,1,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1
  ,7,0,0,1,1,0,3,0,7,0,0,1,7,0,0,1,7,0,0,1,1,0,3,0,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,1,0,3,0,7,0,0,1,7,0,0,1
  ,7,0,0,1,1,0,3,0,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,1,0,3,0,7,0,0,1,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0,5,3,0,0,5,3,1,0,1,0,1,0,1,0,1,0,1,0
  ,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0,5,3,1,0,1,0,1,0,1,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,2,1,1,0,2,1,1,0,1,0,1,0,2,1
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3
  ,3,0,1,0,3,0,1,0,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,0,0,1,1,0,0,1,1,0,0,1,1,5,3,0,0,0,0,1,1,0,0,1,1
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,0,0,1,1
  ,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,3,0,0,1,3,0,0,1
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,0,0,1,1,0,0,1,1,0,0,1,1
  ,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,5,0,0,3,5,0,0,3,3,0,1,0,3,0,1,0,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3
  ,5,0,0,3,3,0,1,0,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0
  ,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,5,3,0,0,2,0,1,1,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,0,0,1,1,2,0,1,1,0,0,1,1,2,0,1,1,0,0,1,1,2,0,1,1,0,0,1,1,2,0,1,1
  ,3,0,0,1,3,0,0,1,5,0,3,0,3,0,0,1,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,0,0,1,1
  ,2,0,1,1,0,0,1,1,2,0,1,1,0,0,1,1,2,0,1,1,0,0,1,1,2,0,1,1,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,1,1,0,1,2
  ,1,0,0,1,3,1,0,0,1,0,0,1,1,0,1,2,3,0,0,1,3,0,0,1,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,1,3,0,0,1,3,0,0,1,3,0,0,1
  ,3,0,0,1,3,0,0,1,3,0,0,1,3,1,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,1,1,0,1,2,1,0,0,1,1,0,0,1,1,0,0,1,1,0,1,2
  ,1,0,0,1,1,0,0,1,1,0,0,3,1,0,0,3,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,1,2,1,0,0,1,1,0,0,1
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,0,0,3,5,3,0,0,1,3,0,0,1,3,1,0,0,0,0,3,5,3,0,0,1,3,0,0,1,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,0,0,1,3,1,0,0,3,0,0,1,3,1,0,0,3,1,0,0,3,1,0,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,0,0,3,5,1,0,0,0,1,0,0,1,1,0,0,0
  ,0,0,3,5,1,0,0,0,0,0,3,5,1,0,0,0,1,0,0,3,1,0,0,3,7,0,1,0,1,0,0,3,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,1,1,0,0,0,1,0,0,1,1,0,0,0,1,0,0,1,1,0,0,0
  ,1,0,0,1,1,0,0,0,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,1,0,0,1,1,0,0,1,1,0,0,1,3,0,0,1,1,0,1,2,1,0,1,2,3,1,0,0,3,0,0,1
  ,1,0,0,1,3,0,0,1,3,0,0,1,3,0,0,1,3,0,0,1,3,0,0,1,3,0,0,1,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,0,0,3,5,0,0,3,5,3,0,0,1
  ,3,0,0,1,3,0,0,1,3,0,0,1,3,1,0,0,3,1,0,0,3,1,0,0,3,0,0,1,3,0,0,1,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,3,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,3
  ,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,1,2,1,0,1,2
  ,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,1,2,1,0,0,1
  ,1,0,0,1,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,1,0,0,3,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,3,7,0,1,0,1,0,0,3,7,0,1,0,0,0,3,5
  ,0,0,3,5,1,0,0,1,0,0,3,5,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,1,0,0,1
  ,1,0,0,1,1,0,0,1,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,0,0,1,1,0,0,1,1,0,0,1,1,2,0,1,1
  ,0,0,1,1,0,0,1,1,5,3,0,0,2,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,3,0,1,0
  ,5,0,0,3,5,0,0,3,5,0,0,3,3,0,1,0,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,3,0,1,0,5,0,0,3,5,0,0,3,5,0,0,3,3,0,1,0
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,3,0,1,0,5,0,0,3
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,3,0,0,1
  ,5,0,3,0,5,0,3,0,5,0,3,0,3,0,0,1,5,0,3,0,5,0,3,0,5,0,3,0,0,0,1,1,0,0,1,1
  ,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1
  ,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,3,0,0,1,5,0,3,0,5,0,3,0,5,0,3,0,3,0,0,1
  ,5,0,3,0,3,0,0,1,5,0,3,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,3,0,0,1,2,0,1,1,2,0,1,1,5,3,0,0,3,0,0,1,5,3,0,0,5,0,0,3
  ,1,0,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0
  ,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,3,0,0,1,2,0,1,1
  ,2,0,1,1,5,3,0,0,3,0,0,1,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3
  ,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,5,3,0,0,3,0,1,0,1,0,0,0,1,0,0,0,5,3,0,0,3,0,1,0,5,3,0,0,1,0,0,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0
  ,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,3,0,1,0,5,3,0,0
  ,1,0,0,0,5,3,0,0,3,0,1,0,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,3,0,0,1,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0
  ,3,0,1,0,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0
  ,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3
  ,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0
  ,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3
  ,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0
  ,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0
  ,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2
  ,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,1,0,0,3,5,0,1,2,5,0,1,2
  ,3,1,0,0,1,0,0,3,5,1,0,2,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0
  ,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,1,0,0,3,5,0,1,2,5,0,1,2,3,1,0,0,1,0,0,3,5,1,0,2,5,0,0,3
  ,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,1,0,0,0,1,0,0,0
  ,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3
  ,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,1,0,0,3,5,1,0,2
  ,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0
  ,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2
  ,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0
  ,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3
  ,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0
  ,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3
  ,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2
  ,1,0,0,1,0,0,3,5,5,0,0,3,5,0,0,3,1,0,0,1,0,0,3,5,5,1,0,2,5,1,0,2,1,0,0,1
  ,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0
  ,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2
  ,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,1,0,0,1,0,0,3,5,5,0,0,3,5,0,0,3
  ,1,0,0,1,0,0,3,5,5,1,0,2,5,1,0,2,3,0,0,1,3,0,0,1,5,0,0,3,5,0,0,3,1,0,0,1
  ,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2
  ,5,1,0,2,1,0,0,1,3,0,0,1,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,1,5,1,0,2,5,1,0,2
  ,3,0,0,1,3,0,0,1,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0
  ,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0
  ,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,3,0,0,1,3,0,0,1,5,0,0,3
  ,5,0,0,3,1,0,0,1,0,0,3,5,5,1,0,2,5,1,0,2,3,0,0,1,3,1,0,0,5,0,0,3,5,0,0,3
  ,1,0,0,1,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0
  ,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0
  ,5,1,0,2,5,1,0,2,1,0,1,2,3,0,0,1,5,0,0,3,5,0,0,3,1,0,1,2,1,0,0,0,5,1,0,2
  ,5,1,0,2,3,0,0,1,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,1,0,1,2,3,0,0,1
  ,5,0,0,3,5,0,0,3,1,0,1,2,1,0,0,0,5,1,0,2,5,1,0,2,3,0,0,1,3,1,0,0,5,0,0,3
  ,5,0,0,3,1,0,1,2,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2
  ,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0
  ,7,0,1,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,0
  ,5,1,0,2,5,1,0,2,3,0,0,1,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,3,0,0,1
  ,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0
  ,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,0,0,1,1,0,0,1,1,5,0,0,3,5,0,0,3,0,0,1,1
  ,0,0,1,1,5,3,0,0,5,3,0,0,0,0,1,1,5,3,0,0,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0
  ,0,0,1,1,0,0,1,1,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,0,0,1,1,2,0,1,1,3,0,1,0,3,0,1,0
  ,0,0,1,1,0,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,0,0,1,1
  ,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0,5,3,0,0
  ,2,0,1,1,5,3,0,0,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,0,0,1,1,2,0,1,1,5,0,0,3
  ,5,0,0,3,0,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,5,3,0,0,5,0,0,3,5,0,0,3
  ,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0
  ,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0
  ,5,3,0,0,5,3,0,0,0,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,0,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,2,0,1,1,5,3,0,0,5,0,0,3,5,0,0,3,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,3,0,1,0,3,0,1,0,0,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,5,3,0,0,5,0,0,3
  ,3,0,1,0,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0
  ,5,0,3,0,5,3,0,0,5,3,0,0,2,0,1,1,5,3,0,0,5,0,0,3,5,0,0,3,0,0,1,1,2,0,1,1
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,0,0,1,1,2,0,1,1,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1
  ,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0
  ,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1
  ,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0
  ,1,0,3,0,1,0,0,0,1,0,0,0,3,1,0,0,1,0,3,0,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0
  ,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,1,0,3,0,3,1,0,0,1,0,0,0,3,1,0,0
  ,1,0,3,0,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,1,0,3,0,3,1,0,0
  ,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1
  ,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0
  ,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1
  ,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0
  ,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0
  ,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0
  ,7,0,0,1,3,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1
  ,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0
  ,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1
  ,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0
  ,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0
  ,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0
  ,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1
  ,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0
  ,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1
  ,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0
  ,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,1,0,0,0,6,0,1,1
  ,7,0,0,1,7,0,0,1,1,0,0,0,6,0,1,1,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1
  ,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1
  ,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0
  ,7,0,1,0,7,1,0,0,7,1,0,0,1,0,0,0,6,0,1,1,7,0,0,1,7,0,0,1,1,0,0,0,6,0,1,1
  ,7,1,0,0,7,1,0,0,1,0,0,0,1,0,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,1,0,0,0
  ,1,0,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,1,0,0,0,1,0,0,0
  ,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1
  ,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1
  ,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,1,0,0,0,1,0,0,0,7,0,0,1,7,0,0,1,1,0,0,0
  ,6,0,1,1,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0
  ,6,0,1,1,1,0,0,0,7,0,0,1,7,0,0,1,6,0,1,1,1,0,0,0,7,1,0,0,7,1,0,0,1,0,0,0
  ,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0
  ,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1
  ,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,6,0,1,1,1,0,0,0,7,0,0,1,7,0,0,1
  ,6,0,1,1,1,0,0,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,0,0,1,6,0,1,1
  ,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0
  ,1,0,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0
  ,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1
  ,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1
  ,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0
  ,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0
  ,3,1,0,0,3,1,0,0,1,0,1,0,1,0,2,1,7,0,0,1,7,0,0,1,1,0,1,0,1,0,2,1,3,1,0,0
  ,3,1,0,0,1,0,1,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,1,0,1,0,1,0,2,1
  ,7,0,0,1,7,0,0,1,1,0,1,0,1,0,2,1,3,1,0,0,3,1,0,0,3,0,1,0,3,0,1,0,7,0,0,1
  ,7,0,0,1,1,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1
  ,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0
  ,5,0,3,0,3,1,0,0,3,1,0,0,1,0,1,0,3,0,1,0,1,0,3,0,1,0,3,0,1,0,1,0,1,0,1,0
  ,3,1,0,0,3,1,0,0,3,0,1,0,3,0,1,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,1,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,0,1,0
  ,3,0,1,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,2,1,3,1,0,0,3,1,0,0,3,0,1,0,3,1,0,0
  ,7,0,0,1,7,0,0,1,1,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1
  ,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1
  ,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,0,0,5,3,3,0,1,0,7,0,0,1,7,0,0,1,0,0,5,3
  ,1,0,0,0,3,1,0,0,3,1,0,0,3,0,1,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,0,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0
  ,0,0,5,3,3,0,1,0,7,0,0,1,7,0,0,1,0,0,5,3,1,0,0,0,3,1,0,0,3,1,0,0,3,0,1,0
  ,3,1,0,0,7,0,0,1,7,0,0,1,0,0,5,3,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0
  ,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1
  ,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,3,0,1,0,3,0
  ,1,0,1,0,1,0,0,0,3,1,0,0,3,1,0,0,3,0,1,0,3,1,0,0,7,0,0,1,1,0,3,0,1,0,1,0
  ,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0
  ,3,1,0,0,3,0,1,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,0,0,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,1,0,1,0,0,0,5,3,1,0,1,0
  ,3,1,0,0,1,0,1,0,0,0,5,3,3,0,1,0,3,0,1,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,1,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0
  ,3,0,1,0,3,0,1,0,3,1,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,1,0,1,0,0,0,5,3,1,0,1,0,1,0,1,0,1,0,1,0,0,0,5,3,1,0,1,0
  ,1,0,1,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0,5,3,1,0,1,0,1,0,1,0,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,1,0,2,1
  ,3,0,1,0,3,0,1,0,3,1,0,0,1,0,2,1,3,0,1,0,3,0,1,0,3,1,0,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,3,1,0,0,3,1,0,0,3,0,1,0
  ,3,1,0,0,3,0,1,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,2,1,1,0,0,0,1,0,1,0,1,0,0,0,1,0,2,1
  ,1,0,0,0,1,0,2,1,1,0,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,1,0,1,0,1,0,0,0,1,0,1,0,1,0,0,0,1,0,1,0,1,0,0,0,1,0,1,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,1,0,0,0,6,0,1,1,1,0,0,0,7,1,0,0,1,0,0,0,6,0,1,1,1,0,0,0,1,0,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,7,1,0,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,6,0,1,1,1,0,0,0
  ,1,0,0,0,1,0,0,0,6,0,1,1,1,0,0,0,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,6,0,1,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,1,0,0,0,1,0,0,0,7,1,0,0,6,0,1,1,1,0,0,0
  ,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,6,0,1,1
  ,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,1,0,0,0,6,0,1,1,1,0,0,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,6,0,1,1,6,0,1,1,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,6,0,1,1,1,0,0,0,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,1,0,0,0,6,0,1,1,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,1,0,1,0
  ,1,0,1,0,1,0,1,0,3,0,1,0,0,0,5,3,0,0,5,3,3,1,0,0,3,0,1,0,1,0,1,0,3,0,1,0
  ,3,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0,3,1,0,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,1,0,2,1,1,0,2,1,3,0,1,0,3,0,1,0,3,0,1,0
  ,3,0,1,0,3,1,0,0,3,1,0,0,3,1,0,0,3,0,1,0,3,0,1,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,7,0,0,1,7,0,0,1,1,0,3,0,7,0,0,1,7,0,0,1,7,0,0,1,1,0,3,0,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,1,0,3,0,7,0,0,1
  ,7,0,0,1,7,0,0,1,1,0,3,0,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,1,0,3,0,7,0,0,1,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0,5,3,0,0,5,3,1,0,1,0,1,0,1,0
  ,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0,5,3,1,0,1,0,1,0,1,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,2,1,1,0,2,1,1,0,1,0
  ,1,0,2,1,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,0,0,1,1,0,0,1,1,0,0,1,1,5,3,0,0,0,0,1,1
  ,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,3,0,0,1
  ,3,0,0,1,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,0,0,1,1,0,0,1,1
  ,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,0,0,1,1,2,0,1,1,2,0,1,1
  ,5,3,0,0,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,5,3,0,0,2,0,1,1
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,0,0,1,1,2,0,1,1,0,0,1,1,2,0,1,1,0,0,1,1,2,0,1,1,0,0,1,1
  ,2,0,1,1,3,0,0,1,3,0,0,1,5,0,3,0,3,0,0,1,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,0,0,1,1,2,0,1,1,0,0,1,1,2,0,1,1,0,0,1,1,2,0,1,1,0,0,1,1,2,0,1,1,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,1
  ,1,0,1,2,1,0,0,1,3,1,0,0,1,0,0,1,1,0,1,2,3,0,0,1,3,0,0,1,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,1,3,0,0,1,3,0,0,1
  ,3,0,0,1,3,0,0,1,3,0,0,1,3,0,0,1,3,1,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,1,1,0,1,2,1,0,0,1,1,0,0,1,1,0,0,1
  ,1,0,1,2,1,0,0,1,1,0,0,1,1,0,0,3,1,0,0,3,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,1,2,1,0,0,1
  ,1,0,0,1,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,0,0,3,5,3,0,0,1,3,0,0,1,3,1,0,0,0,0,3,5,3,0,0,1,3,0,0,1,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,0,0,1,3,1,0,0,3,0,0,1,3,1,0,0,3,1,0,0,3,1,0,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,0,0,3,5,1,0,0,0,1,0,0,1
  ,1,0,0,0,0,0,3,5,1,0,0,0,0,0,3,5,1,0,0,0,1,0,0,3,1,0,0,3,7,0,1,0,1,0,0,3
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,1,1,0,0,0,1,0,0,1,1,0,0,0,1,0,0,1
  ,1,0,0,0,1,0,0,1,1,0,0,0,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,1,0,0,1,1,0,0,1,1,0,0,1,3,0,0,1,1,0,1,2,1,0,1,2,3,1,0,0
  ,3,0,0,1,1,0,0,1,3,0,0,1,3,0,0,1,3,0,0,1,3,0,0,1,3,0,0,1,3,0,0,1,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,0,0,3,5,0,0,3,5
  ,3,0,0,1,3,0,0,1,3,0,0,1,3,0,0,1,3,1,0,0,3,1,0,0,3,1,0,0,3,0,0,1,3,0,0,1
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,3,7,0,1,0,7,0,1,0,7,0,1,0
  ,1,0,0,3,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,1,2
  ,1,0,1,2,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,1,2
  ,1,0,0,1,1,0,0,1,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,1,0,0,3,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,3,7,0,1,0,1,0,0,3,7,0,1,0
  ,0,0,3,5,0,0,3,5,1,0,0,1,0,0,3,5,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1
  ,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,0,0,1,1,0,0,1,1,0,0,1,1
  ,2,0,1,1,0,0,1,1,0,0,1,1,5,3,0,0,2,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3
  ,3,0,1,0,5,0,0,3,5,0,0,3,5,0,0,3,3,0,1,0,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,3,0,1,0,5,0,0,3,5,0,0,3,5,0,0,3
  ,3,0,1,0,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,3,0,1,0
  ,5,0,0,3,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,3,0,0,1,5,0,3,0,5,0,3,0,5,0,3,0,3,0,0,1,5,0,3,0,5,0,3,0,5,0,3,0,0,0,1,1
  ,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1
  ,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,3,0,0,1,5,0,3,0,5,0,3,0,5,0,3,0
  ,3,0,0,1,5,0,3,0,3,0,0,1,5,0,3,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,5,3,0,0,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,0,0,1,1,0,0,1,1
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0
  ,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,5,3,0,0,0,0,1,1,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,0,0,1,1
  ,0,0,1,1,5,3,0,0,5,0,0,3,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0
  ,5,0,0,3,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,5,3,0,0,3,0,1,0,0,0,1,1,0,0,1,1,5,3,0,0,3,0,1,0,2,0,1,1
  ,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,3,0,1,0
  ,5,3,0,0,0,0,1,1,5,3,0,0,3,0,1,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1
  ,5,3,0,0,3,0,1,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3
  ,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0
  ,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,2,0,1,1
  ,0,0,1,1,5,3,0,0,5,0,0,3,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0
  ,5,0,0,3,2,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,5,3,0,0
  ,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,5,3,0,0,2,0,1,1,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3
  ,5,3,0,0,0,0,1,1,5,3,0,0,5,0,0,3,5,3,0,0,2,0,1,1,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,1,0,0,1,1,0,0,1
  ,5,1,0,2,5,0,0,3,0,0,3,5,0,0,3,5,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,1,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3
  ,3,1,0,0,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,1,0,2,5,0,0,3,1,0,1,2,1,0,1,2,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2
  ,5,0,0,3,3,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,1,0,0,1
  ,1,0,0,1,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,1,0,2
  ,5,0,0,3,3,0,0,1,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,1,5,1,0,2,5,0,0,3,3,1,0,0
  ,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3
  ,1,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,0,0,3,5,0,0,3,5,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1
  ,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,1,0,1,2,1,0,1,2,5,1,0,2,5,0,0,3
  ,3,0,0,1,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,1,0,2,5,0,0,3,3,0,0,1,1,0,1,2,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2
  ,5,0,0,3,3,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,3,0,0,1,0,0,3,5,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,0,0,1
  ,1,0,0,1,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,1,0,2
  ,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,1,5,1,0,2,5,0,0,3,3,1,0,0
  ,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,1,0,0,3,1,0,0,3,5,1,0,2
  ,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,1,0,2
  ,1,0,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0
  ,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3
  ,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3
  ,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0
  ,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0
  ,5,1,0,2,5,1,0,2,1,0,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2
  ,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0
  ,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3
  ,5,0,0,3,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2
  ,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,1,0,0,3
  ,1,0,0,3,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0
  ,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,3,1,0,0
  ,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0
  ,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2
  ,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2
  ,7,0,1,0,1,0,0,3,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0
  ,1,0,0,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2
  ,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,1,0,2,3,1,0,0
  ,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,3,0,0,1,3,0,0,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3
  ,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0
  ,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,1,0,0,0,5,3,0,0,3,0,1,0
  ,3,0,1,0,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3
  ,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0
  ,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,3,0,0,1,3,0,0,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3
  ,5,0,0,3,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0
  ,5,0,3,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,3,0,0,1,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,3,0,1,0,3,0,1,0,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,0,0,3,3,0,1,0,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0
  ,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0
  ,7,0,0,1,1,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,1,0,2,1,1,0,2,1,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,1,0,1,0
  ,1,0,1,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,0,0,5,3,0,0,5,3,3,1,0,0
  ,7,0,0,1,3,0,1,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,3,1,0,0
  ,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,3,1,0,0,1,0,3,0,1,0,1,0,1,0,1,0,3,1,0,0,1,0,3,0,3,0,1,0,1,0,1,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1
  ,3,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,1,0,3,0,3,1,0,0,1,0,1,0
  ,3,1,0,0,1,0,3,0,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0,3,1,0,0,1,0,3,0
  ,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,3,1,0,0,7,0,0,1,1,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,1,0,2,1,1,0,2,1
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0
  ,7,0,0,1,3,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,0,0,5,3
  ,0,0,5,3,3,1,0,0,7,0,0,1,3,0,1,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0,0,0,5,3,3,1,0,0
  ,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,3,0,1,0
  ,1,0,2,1,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,1,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1
  ,3,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,1,0
  ,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0
  ,7,0,0,1,6,0,1,1,6,0,1,1,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0
  ,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0
  ,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,1,0,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1
  ,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0
  ,7,1,0,0,7,0,0,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1
  ,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,7,1,0,0,7,0,0,1,6,0,1,1,6,0,1,1,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0
  ,7,0,0,1,1,0,0,0,6,0,1,1,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0
  ,1,0,0,0,7,1,0,0,7,0,0,1,1,0,0,0,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0
  ,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0
  ,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1
  ,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1
  ,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0
  ,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0
  ,1,0,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0
  ,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1
  ,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1
  ,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0
  ,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1
  ,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1
  ,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1
  ,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1
  ,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0
  ,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0
  ,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1
  ,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1
  ,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,1,0,3,0,1,0,3,0,1,0,0,0
  ,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0
  ,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1
  ,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1
  ,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0
  ,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0
  ,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,3,0
  ,1,0,3,0,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,1,0,3,0
  ,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0
  ,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,1,0,3,0,1,0,3,0,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,1,0,1,0,0,0,5,3
  ,1,0,1,0,3,1,0,0,1,0,1,0,0,0,5,3,3,0,1,0,3,0,1,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,1,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0
  ,3,0,1,0,3,0,1,0,3,0,1,0,3,1,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,1,0,1,0,0,0,5,3,1,0,1,0,1,0,1,0,1,0,1,0,0,0,5,3
  ,1,0,1,0,1,0,1,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0,5,3,1,0,1,0,1,0,1,0
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,1,0,3,0,1,0,3,0,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1,1,0,3,0,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,1,0,2,1,3,0,1,0,3,0,1,0,3,1,0,0,1,0,2,1,3,0,1,0,3,0,1,0,3,1,0,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,3,1,0,0,3,1,0,0
  ,3,0,1,0,3,1,0,0,3,0,1,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,2,1,1,0,0,0,1,0,1,0,1,0,0,0
  ,1,0,2,1,1,0,0,0,1,0,2,1,1,0,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,1,0,1,0,1,0,0,0,1,0,1,0,1,0,0,0,1,0,1,0,1,0,0,0
  ,1,0,1,0,1,0,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,1,0,0,0,6,0,1,1,1,0,0,0,7,1,0,0,1,0,0,0,6,0,1,1,1,0,0,0
  ,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,7,1,0,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,6,0,1,1
  ,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,1,0,0,0,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,6,0,1,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,1,0,0,0,1,0,0,0,7,1,0,0,6,0,1,1
  ,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,6,0,1,1,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,1,0,0,0,6,0,1,1,1,0,0,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,6,0,1,1,6,0,1,1,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,6,0,1,1,1,0,0,0,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,1,0,0,0,6,0,1,1,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,1,0,1,0,1,0,1,0,1,0,1,0,3,0,1,0,0,0,5,3,0,0,5,3,3,1,0,0,3,0,1,0,1,0,1,0
  ,3,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0,3,1,0,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,1,0,2,1,1,0,2,1,3,0,1,0,3,0,1,0
  ,3,0,1,0,3,0,1,0,3,1,0,0,3,1,0,0,3,1,0,0,3,0,1,0,3,0,1,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0,5,3,0,0,5,3,1,0,1,0
  ,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0,5,3,1,0,1,0,1,0,1,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,2,1,1,0,2,1
  ,1,0,1,0,1,0,2,1,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,1,0,1,0,1,0,1,0,1,0
  ,1,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,5,0,0,3,5,0,0,3,3,0,1,0,3,0,1,0,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,0,0,1,1,0,0,1,1,0,0,1,1,5,3,0,0
  ,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1
  ,3,0,0,1,3,0,0,1,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,0,0,1,1
  ,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,3,0,1,0,3,0,1,0,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,5,0,0,3,5,0,0,3,5,0,0,3,3,0,1,0,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,0,0,1,1,2,0,1,1
  ,2,0,1,1,5,3,0,0,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,5,3,0,0
  ,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,0,0,1,1,2,0,1,1,0,0,1,1,2,0,1,1,0,0,1,1,2,0,1,1
  ,0,0,1,1,2,0,1,1,3,0,0,1,3,0,0,1,5,0,3,0,3,0,0,1,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,0,0,1,1,2,0,1,1,0,0,1,1,2,0,1,1,0,0,1,1,2,0,1,1,0,0,1,1,2,0,1,1
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,1,0,0,1,1,0,1,2,1,0,0,1,3,1,0,0,1,0,0,1,1,0,1,2,3,0,0,1,3,0,0,1,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,1,3,0,0,1
  ,3,0,0,1,3,0,0,1,3,0,0,1,3,0,0,1,3,0,0,1,3,1,0,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,1,1,0,1,2,1,0,0,1,1,0,0,1
  ,1,0,0,1,1,0,1,2,1,0,0,1,1,0,0,1,1,0,0,3,1,0,0,3,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,1,2
  ,1,0,0,1,1,0,0,1,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,0,0,3,5,3,0,0,1,3,0,0,1,3,1,0,0,0,0,3,5,3,0,0,1,3,0,0,1
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,0,0,1,3,1,0,0,3,0,0,1,3,1,0,0,3,1,0,0,3,1,0,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,0,0,3,5,1,0,0,0
  ,1,0,0,1,1,0,0,0,0,0,3,5,1,0,0,0,0,0,3,5,1,0,0,0,1,0,0,3,1,0,0,3,7,0,1,0
  ,1,0,0,3,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,1,1,0,0,0,1,0,0,1,1,0,0,0
  ,1,0,0,1,1,0,0,0,1,0,0,1,1,0,0,0,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,1,1,0,0,1,1,0,0,1,3,0,0,1,1,0,1,2,1,0,1,2
  ,3,1,0,0,3,0,0,1,1,0,0,1,3,0,0,1,3,0,0,1,3,0,0,1,3,0,0,1,3,0,0,1,3,0,0,1
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,0,0,3,5
  ,0,0,3,5,3,0,0,1,3,0,0,1,3,0,0,1,3,0,0,1,3,1,0,0,3,1,0,0,3,1,0,0,3,0,0,1
  ,3,0,0,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,3,7,0,1,0,7,0,1,0
  ,7,0,1,0,1,0,0,3,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1
  ,1,0,1,2,1,0,1,2,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1
  ,1,0,1,2,1,0,0,1,1,0,0,1,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,1,0,0,3,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,3,7,0,1,0,1,0,0,3
  ,7,0,1,0,0,0,3,5,0,0,3,5,1,0,0,1,0,0,3,5,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,0,0,1,1,0,0,1,1
  ,0,0,1,1,2,0,1,1,0,0,1,1,0,0,1,1,5,3,0,0,2,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,3,0,0,1,5,0,3,0,5,0,3,0,5,0,3,0,3,0,0,1,5,0,3,0,5,0,3,0,5,0,3,0
  ,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1
  ,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,3,0,0,1,5,0,3,0,5,0,3,0
  ,5,0,3,0,3,0,0,1,5,0,3,0,3,0,0,1,5,0,3,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0
  ,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,5,3,0,0,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3
  ,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0
  ,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,3,0,1,0,1,0,0,0,1,0,0,0,5,3,0,0,3,0,1,0
  ,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0
  ,3,0,1,0,5,3,0,0,1,0,0,0,5,3,0,0,3,0,1,0,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0
  ,1,0,0,0,5,3,0,0,3,0,1,0,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0
  ,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0
  ,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3
  ,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0
  ,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3
  ,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0
  ,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0
  ,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2
  ,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0
  ,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3
  ,1,0,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0
  ,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3
  ,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2
  ,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0
  ,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2
  ,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0
  ,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3
  ,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0
  ,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3
  ,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0
  ,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0
  ,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2
  ,5,1,0,2,1,0,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0
  ,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3
  ,5,0,0,3,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2
  ,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0
  ,7,0,1,0,5,1,0,2,5,1,0,2,1,0,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0
  ,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,3,1,0,0
  ,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0
  ,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2
  ,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2
  ,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0
  ,1,0,0,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2
  ,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,1,0,2,3,1,0,0
  ,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0
  ,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2
  ,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3
  ,1,0,0,0,1,0,0,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0
  ,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2
  ,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,1,0,2
  ,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3
  ,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,0,0,3
  ,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0
  ,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,1,0,0,0,5,3,0,0
  ,3,0,1,0,3,0,1,0,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3
  ,5,0,0,3,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0
  ,5,0,3,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0
  ,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,3,0,1,0,3,0,1,0,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,0,0,3,3,0,1,0,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3
  ,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0
  ,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1
  ,1,0,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0
  ,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1
  ,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,3,1,0,0,1,0,3,0,1,0,0,0,1,0,0,0,3,1,0,0,1,0,3,0,3,1,0,0,1,0,0,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0
  ,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,1,0,3,0,3,1,0,0
  ,1,0,0,0,3,1,0,0,1,0,3,0,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0
  ,1,0,3,0,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0
  ,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1
  ,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0
  ,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1
  ,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0
  ,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0
  ,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0
  ,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1
  ,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0
  ,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1
  ,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0
  ,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0
  ,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0
  ,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1
  ,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0
  ,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1
  ,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,1,0,0,0
  ,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0
  ,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1
  ,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1
  ,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0
  ,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0
  ,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1
  ,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1
  ,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1
  ,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1
  ,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0
  ,7,0,1,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1
  ,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1
  ,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0
  ,1,0,0,0,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0
  ,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1
  ,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,1,0,3,0,1,0,3,0
  ,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0
  ,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0
  ,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1
  ,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1
  ,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0
  ,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,1,0,3,0,1,0,3,0,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1
  ,1,0,3,0,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1
  ,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0
  ,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,1,0,1,0
  ,0,0,5,3,1,0,1,0,3,1,0,0,1,0,1,0,0,0,5,3,3,0,1,0,3,0,1,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,1,0,1,0,3,0,1,0,3,0,1,0
  ,3,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0,3,1,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,1,0,0,0,5,3,1,0,1,0,1,0,1,0,1,0,1,0
  ,0,0,5,3,1,0,1,0,1,0,1,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0,5,3,1,0,1,0
  ,1,0,1,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,1,0,2,1,3,0,1,0,3,0,1,0,3,1,0,0,1,0,2,1,3,0,1,0,3,0,1,0,3,1,0,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,3,1,0,0
  ,3,1,0,0,3,0,1,0,3,1,0,0,3,0,1,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,2,1,1,0,0,0,1,0,1,0
  ,1,0,0,0,1,0,2,1,1,0,0,0,1,0,2,1,1,0,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,1,0,1,0,0,0,1,0,1,0,1,0,0,0,1,0,1,0
  ,1,0,0,0,1,0,1,0,1,0,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0,6,0,1,1,1,0,0,0,7,1,0,0,1,0,0,0,6,0,1,1
  ,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,7,1,0,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0
  ,6,0,1,1,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,1,0,0,0,1,0,0,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,6,0,1,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,1,0,0,0,1,0,0,0,7,1,0,0
  ,6,0,1,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,1,0,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,6,0,1,1,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,1,0,0,0,6,0,1,1,1,0,0,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,1,0,0,0,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,1,0,0,0,6,0,1,1,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,1,0,1,0,1,0,1,0,1,0,1,0,3,0,1,0,0,0,5,3,0,0,5,3,3,1,0,0,3,0,1,0
  ,1,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0,3,1,0,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,1,0,2,1,1,0,2,1,3,0,1,0
  ,3,0,1,0,3,0,1,0,3,0,1,0,3,1,0,0,3,1,0,0,3,1,0,0,3,0,1,0,3,0,1,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0,5,3,0,0,5,3
  ,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0,5,3,1,0,1,0
  ,1,0,1,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,2,1
  ,1,0,2,1,1,0,1,0,1,0,2,1,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,1,0,1,0,1,0
  ,1,0,1,0,1,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,0,0,1,1,0,0,1,1,0,0,1,1
  ,5,3,0,0,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1
  ,0,0,1,1,3,0,0,1,3,0,0,1,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,0,0,1,1
  ,2,0,1,1,2,0,1,1,5,3,0,0,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1
  ,5,3,0,0,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,0,0,1,1,2,0,1,1,0,0,1,1,2,0,1,1,0,0,1,1
  ,2,0,1,1,0,0,1,1,2,0,1,1,3,0,0,1,3,0,0,1,5,0,3,0,3,0,0,1,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,0,0,1,1,2,0,1,1,0,0,1,1,2,0,1,1,0,0,1,1,2,0,1,1,0,0,1,1
  ,2,0,1,1,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,1,0,0,1,1,0,1,2,1,0,0,1,3,1,0,0,1,0,0,1,1,0,1,2,3,0,0,1,3,0,0,1
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,1
  ,3,0,0,1,3,0,0,1,3,0,0,1,3,0,0,1,3,0,0,1,3,0,0,1,3,1,0,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,1,1,0,1,2,1,0,0,1
  ,1,0,0,1,1,0,0,1,1,0,1,2,1,0,0,1,1,0,0,1,1,0,0,3,1,0,0,3,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1
  ,1,0,1,2,1,0,0,1,1,0,0,1,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,0,0,3,5,3,0,0,1,3,0,0,1,3,1,0,0,0,0,3,5,3,0,0,1
  ,3,0,0,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,0,0,1,3,1,0,0,3,0,0,1,3,1,0,0,3,1,0,0,3,1,0,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,0,0,3,5
  ,1,0,0,0,1,0,0,1,1,0,0,0,0,0,3,5,1,0,0,0,0,0,3,5,1,0,0,0,1,0,0,3,1,0,0,3
  ,7,0,1,0,1,0,0,3,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,1,1,0,0,0,1,0,0,1
  ,1,0,0,0,1,0,0,1,1,0,0,0,1,0,0,1,1,0,0,0,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,1,1,0,0,1,1,0,0,1,3,0,0,1,1,0,1,2
  ,1,0,1,2,3,1,0,0,3,0,0,1,1,0,0,1,3,0,0,1,3,0,0,1,3,0,0,1,3,0,0,1,3,0,0,1
  ,3,0,0,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,0,0,3,5,0,0,3,5,3,0,0,1,3,0,0,1,3,0,0,1,3,0,0,1,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,0,0,1,3,0,0,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,3,7,0,1,0
  ,7,0,1,0,7,0,1,0,1,0,0,3,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,1,1,0,0,1,1,0,0,1
  ,1,0,0,1,1,0,1,2,1,0,1,2,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1
  ,1,0,0,1,1,0,1,2,1,0,0,1,1,0,0,1,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,3,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,3,7,0,1,0
  ,1,0,0,3,7,0,1,0,0,0,3,5,0,0,3,5,1,0,0,1,0,0,3,5,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,0,0,1,1
  ,0,0,1,1,0,0,1,1,2,0,1,1,0,0,1,1,0,0,1,1,5,3,0,0,2,0,1,1,0,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,3,0,0,1,5,0,3,0,5,0,3,0,5,0,3,0,3,0,0,1,5,0,3,0,5,0,3,0
  ,5,0,3,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1
  ,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,3,0,0,1,5,0,3,0
  ,5,0,3,0,5,0,3,0,3,0,0,1,5,0,3,0,3,0,0,1,5,0,3,0,0,0,1,1,0,0,1,1,0,0,1,1
  ,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3
  ,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,3,0,0,1,2,0,1,1,2,0,1,1,5,3,0,0
  ,3,0,0,1,5,3,0,0,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,5,3,0,0,0,0,1,1
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0
  ,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,5,3,0,0,3,0,0,1,2,0,1,1,2,0,1,1,5,3,0,0,3,0,0,1,5,3,0,0,5,0,0,3,2,0,1,1
  ,0,0,1,1,5,3,0,0,5,0,0,3,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0
  ,5,0,0,3,2,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,2,0,1,1
  ,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,5,3,0,0,5,0,0,3,5,3,0,0,0,0,1,1,5,3,0,0,5,0,0,3,5,3,0,0,2,0,1,1,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,3,0,0,1,5,3,0,0,5,0,0,3
  ,2,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,0,0,1,1,0,0,1,1
  ,5,3,0,0,5,0,0,3,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3
  ,2,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,5,3,0,0,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0
  ,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,2,0,1,1
  ,0,0,1,1,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0
  ,5,0,0,3,5,3,0,0,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,5,3,0,0
  ,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,5,3,0,0,5,0,0,3,5,3,0,0,0,0,1,1,5,3,0,0,5,0,0,3,5,3,0,0,2,0,1,1,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3
  ,1,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,0,0,3,5,0,0,3,5,5,0,1,2,5,0,1,2,3,1,0,0
  ,1,0,0,3,5,0,1,2,5,0,1,2,3,1,0,0,1,0,0,3,5,1,0,2,5,0,0,3,1,0,0,1,1,0,0,1
  ,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,1,0,1,2,1,0,1,2,5,1,0,2,5,0,0,3
  ,3,0,0,1,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,1,0,0,3,5,0,1,2,5,0,1,2,3,1,0,0
  ,1,0,0,3,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2
  ,5,0,0,3,1,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,0,0,1
  ,1,0,0,1,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,1,5,1,0,2
  ,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,1,0,0,3,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,3,1,0,0
  ,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,1,0,2,5,0,0,3,1,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,0,0,3,5,0,0,3,5,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3
  ,3,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,1,0,1,2,1,0,1,2
  ,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,0,0,1,1,0,1,2,5,1,0,2,5,0,0,3
  ,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,3,0,0,1,0,0,3,5
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2
  ,5,0,0,3,3,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,1,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,0,0,1
  ,1,0,0,1,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,1,5,1,0,2
  ,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2
  ,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,1,0,0,3
  ,1,0,0,3,5,1,0,2,5,1,0,2,1,0,0,1,0,0,3,5,5,0,0,3,5,0,0,3,1,0,0,1,0,0,3,5
  ,5,1,0,2,5,1,0,2,1,0,0,1,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,1,5,0,1,2
  ,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,1,0,0,1
  ,0,0,3,5,5,0,0,3,5,0,0,3,1,0,0,1,0,0,3,5,5,1,0,2,5,1,0,2,3,0,0,1,3,0,0,1
  ,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2
  ,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2
  ,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,1,0,0,1,3,0,0,1,5,0,0,3,5,0,0,3,1,0,0,1
  ,1,0,0,1,5,1,0,2,5,1,0,2,3,0,0,1,3,0,0,1,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,1
  ,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2
  ,3,0,0,1,3,0,0,1,5,0,0,3,5,0,0,3,1,0,0,1,0,0,3,5,5,1,0,2,5,1,0,2,3,0,0,1
  ,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0
  ,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2
  ,5,0,1,2,1,0,0,3,1,0,0,3,5,1,0,2,5,1,0,2,1,0,1,2,3,0,0,1,5,0,0,3,5,0,0,3
  ,1,0,1,2,1,0,0,0,5,1,0,2,5,1,0,2,3,0,0,1,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,1
  ,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2
  ,5,1,0,2,1,0,1,2,3,0,0,1,5,0,0,3,5,0,0,3,1,0,1,2,1,0,0,0,5,1,0,2,5,1,0,2
  ,3,0,0,1,3,1,0,0,5,0,0,3,5,0,0,3,1,0,1,2,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0
  ,5,0,1,2,5,0,1,2,7,0,1,0,1,0,0,3,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3
  ,5,0,0,3,1,0,0,1,1,0,0,0,5,1,0,2,5,1,0,2,3,0,0,1,3,1,0,0,5,0,0,3,5,0,0,3
  ,1,0,0,1,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0
  ,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0
  ,5,1,0,2,5,1,0,2,3,0,0,1,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,0,5,1,0,2
  ,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,3,0,0,1,3,0,0,1,5,3,0,0,5,3,0,0,0,0,1,1,0,0,1,1
  ,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0,5,3,0,0,0,0,1,1,5,3,0,0,5,0,0,3
  ,5,0,0,3,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0
  ,5,0,3,0,5,3,0,0,5,3,0,0,0,0,1,1,0,0,1,1,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,0,0,1,1
  ,2,0,1,1,3,0,1,0,3,0,1,0,0,0,1,1,0,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,0,0,1,1
  ,0,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,5,3,0,0,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,3,0,0,1,3,0,0,1,5,3,0,0,5,3,0,0
  ,0,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,0,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1
  ,5,3,0,0,5,0,0,3,5,0,0,3,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,0,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3
  ,0,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,5,3,0,0,5,0,0,3,5,0,0,3,0,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,3,0,0,1,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,3,0,1,0,3,0,1,0,0,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,2,0,1,1,5,3,0,0,5,0,0,3,3,0,1,0,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,2,0,1,1,5,3,0,0,5,0,0,3
  ,5,0,0,3,0,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3
  ,0,0,1,1,2,0,1,1,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,3,1,0,0,7,0,0,1,1,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,1,0,2,1,1,0,2,1
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0
  ,7,0,0,1,1,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,1,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,0,0,5,3
  ,0,0,5,3,3,1,0,0,7,0,0,1,3,0,1,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0,3,1,0,0
  ,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,1,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,3,0,1,0
  ,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1
  ,3,1,0,0,1,0,1,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0
  ,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,1,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1
  ,1,0,2,1,1,0,2,1,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0
  ,7,0,0,1,0,0,5,3,0,0,5,3,3,1,0,0,7,0,0,1,3,0,1,0,1,0,0,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0
  ,0,0,5,3,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0,3,1,0,0
  ,7,0,0,1,3,0,1,0,1,0,2,1,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,3,1,0,0
  ,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1
  ,3,1,0,0,1,0,1,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0
  ,7,1,0,0,7,0,0,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1
  ,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,7,1,0,0,7,0,0,1,6,0,1,1,6,0,1,1,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0
  ,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0
  ,1,0,0,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0
  ,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1
  ,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0
  ,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,6,0,1,1,6,0,1,1,7,1,0,0,7,0,0,1
  ,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,6,0,1,1,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0
  ,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,1,0,0,0,6,0,1,1,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0
  ,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0
  ,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0
  ,7,1,0,0,1,0,0,0,6,0,1,1,7,0,0,1,7,0,0,1,1,0,0,0,6,0,1,1,7,1,0,0,7,1,0,0
  ,1,0,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0
  ,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,1,0,0,0,6,0,1,1,7,0,0,1
  ,7,0,0,1,1,0,0,0,6,0,1,1,7,1,0,0,7,1,0,0,1,0,0,0,1,0,0,0,7,0,0,1,7,0,0,1
  ,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0
  ,7,1,0,0,7,1,0,0,1,0,0,0,1,0,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0
  ,7,1,0,0,1,0,0,0,1,0,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,1,0,0,0,1,0,0,0
  ,7,0,0,1,7,0,0,1,1,0,0,0,6,0,1,1,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1
  ,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1
  ,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0
  ,7,0,1,0,7,1,0,0,7,1,0,0,6,0,1,1,1,0,0,0,7,0,0,1,7,0,0,1,6,0,1,1,1,0,0,0
  ,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,6,0,1,1
  ,1,0,0,0,7,0,0,1,7,0,0,1,6,0,1,1,1,0,0,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0
  ,7,0,0,1,7,0,0,1,6,0,1,1,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1
  ,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1
  ,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0
  ,1,0,0,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0
  ,1,0,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0
  ,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1
  ,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,1,0,1,0,1,0,2,1,7,0,0,1,7,0,0,1
  ,1,0,1,0,1,0,2,1,3,1,0,0,3,1,0,0,1,0,1,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,1,0
  ,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0
  ,3,1,0,0,1,0,1,0,1,0,2,1,7,0,0,1,7,0,0,1,1,0,1,0,1,0,2,1,3,1,0,0,3,1,0,0
  ,3,0,1,0,3,0,1,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0
  ,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,1,0,1,0,3,0,1,0,1,0,3,0
  ,1,0,3,0,1,0,1,0,1,0,1,0,3,1,0,0,3,1,0,0,3,0,1,0,3,0,1,0,7,0,0,1,7,0,0,1
  ,1,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0
  ,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0
  ,3,1,0,0,3,1,0,0,3,0,1,0,3,0,1,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,2,1,3,1,0,0
  ,3,1,0,0,3,0,1,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,0,0,5,3,3,0,1,0
  ,7,0,0,1,7,0,0,1,0,0,5,3,1,0,0,0,3,1,0,0,3,1,0,0,3,0,1,0,3,1,0,0,7,0,0,1
  ,7,0,0,1,1,0,1,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1
  ,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0
  ,5,0,3,0,3,1,0,0,3,1,0,0,0,0,5,3,3,0,1,0,7,0,0,1,7,0,0,1,0,0,5,3,1,0,0,0
  ,3,1,0,0,3,1,0,0,3,0,1,0,3,1,0,0,7,0,0,1,7,0,0,1,0,0,5,3,1,0,0,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,1,0,3,0,1,0,3,0,1,0,1,0,1,0,0,0,3,1,0,0,3,1,0,0,3,0,1,0,3,1,0,0
  ,7,0,0,1,1,0,3,0,1,0,1,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1
  ,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1
  ,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,0,1,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,1,0
  ,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,0,0
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,1,0,3,0,1,0,3,0,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,1,0,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,1,0,3,0
  ,1,0,3,0,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1,1,0,3,0,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,1,0,0,0,1,0,0,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,1,0,0,0,6,0,1,1
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,1,0,1,0,1,0,1,0,1,0,1,0,3,0,1,0,0,0,5,3,0,0,5,3,3,1,0,0
  ,3,0,1,0,1,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0,3,1,0,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,1,0,2,1,1,0,2,1
  ,3,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0,3,1,0,0,3,1,0,0,3,1,0,0,3,0,1,0,3,0,1,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,1,0,3,0,7,0,0,1,7,0,0,1,7,0,0,1
  ,1,0,3,0,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1
  ,7,0,0,1,1,0,3,0,7,0,0,1,7,0,0,1,7,0,0,1,1,0,3,0,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,1,0,3,0,7,0,0,1,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0,5,3
  ,0,0,5,3,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0,5,3
  ,1,0,1,0,1,0,1,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,1,0,2,1,1,0,2,1,1,0,1,0,1,0,2,1,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,1,0
  ,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,3,0,1,0,3,0,1,0,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,3,0,0,1,3,0,0,1,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,3,0,1,0,3,0,1,0,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,5,0,0,3,3,0,1,0,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,3,0,0,1,3,0,0,1,5,0,3,0,3,0,0,1,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,3,1,0,0,3,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,3
  ,1,0,0,3,7,0,1,0,1,0,0,3,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,1,1,0,0,1,1,0,0,1,3,0,0,1
  ,1,0,1,2,1,0,1,2,3,1,0,0,3,0,0,1,1,0,0,1,3,0,0,1,3,0,0,1,3,0,0,1,3,0,0,1
  ,3,0,0,1,3,0,0,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,0,0,3,5,0,0,3,5,3,0,0,1,3,0,0,1,3,0,0,1,3,0,0,1,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,0,0,1,3,0,0,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,1,1,0,0,1
  ,1,0,0,1,1,0,0,1,1,0,1,2,1,0,1,2,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1
  ,1,0,0,1,1,0,0,1,1,0,1,2,1,0,0,1,1,0,0,1,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,0,0,3,5,0,0,3,5,1,0,0,1,0,0,3,5,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,0,0,1,1,0,0,1,1,0,0,1,1,2,0,1,1,0,0,1,1,0,0,1,1,5,3,0,0,2,0,1,1,0,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,5,0,0,3,5,0,0,3,3,0,1,0,5,0,0,3,5,0,0,3,5,0,0,3,3,0,1,0,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,3,0,1,0
  ,5,0,0,3,5,0,0,3,5,0,0,3,3,0,1,0,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,3,0,1,0,5,0,0,3,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1
  ,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,0,0,1,1,0,0,1,1
  ,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1
  ,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0
  ,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,3,0,0,1,2,0,1,1,2,0,1,1
  ,5,3,0,0,3,0,0,1,5,3,0,0,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0
  ,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,3,0,0,1,2,0,1,1,2,0,1,1,5,3,0,0,3,0,0,1,5,3,0,0,5,0,0,3
  ,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,1,0,0,0,1,0,0,0
  ,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3
  ,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,3,0,0,1,5,3,0,0
  ,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0
  ,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0
  ,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0
  ,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3
  ,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0
  ,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3
  ,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2
  ,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,1,0,0,3,5,0,1,2,5,0,1,2,3,1,0,0,1,0,0,3,5,1,0,2,5,0,0,3,1,0,0,0
  ,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2
  ,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,1,0,0,3,5,0,1,2,5,0,1,2
  ,3,1,0,0,1,0,0,3,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0
  ,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,1,0,2,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3
  ,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0
  ,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,1,0,0,3,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3
  ,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2
  ,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0
  ,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2
  ,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0
  ,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3
  ,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0
  ,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2
  ,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2
  ,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,1,0,0,1,0,0,3,5,5,0,0,3,5,0,0,3,1,0,0,1
  ,0,0,3,5,5,1,0,2,5,1,0,2,1,0,0,1,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,1
  ,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2
  ,1,0,0,1,0,0,3,5,5,0,0,3,5,0,0,3,1,0,0,1,0,0,3,5,5,1,0,2,5,1,0,2,3,0,0,1
  ,3,0,0,1,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0
  ,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2
  ,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,1,0,0,1,3,0,0,1,5,0,0,3,5,0,0,3
  ,1,0,0,1,1,0,0,1,5,1,0,2,5,1,0,2,3,0,0,1,3,0,0,1,5,0,0,3,5,0,0,3,1,0,0,1
  ,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2
  ,5,1,0,2,3,0,0,1,3,0,0,1,5,0,0,3,5,0,0,3,1,0,0,1,0,0,3,5,5,1,0,2,5,1,0,2
  ,3,0,0,1,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0
  ,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0
  ,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,1,0,1,2,3,0,0,1,5,0,0,3
  ,5,0,0,3,1,0,1,2,1,0,0,0,5,1,0,2,5,1,0,2,3,0,0,1,3,1,0,0,5,0,0,3,5,0,0,3
  ,1,0,0,1,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0
  ,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0
  ,5,1,0,2,5,1,0,2,1,0,1,2,3,0,0,1,5,0,0,3,5,0,0,3,1,0,1,2,1,0,0,0,5,1,0,2
  ,5,1,0,2,3,0,0,1,3,1,0,0,5,0,0,3,5,0,0,3,1,0,1,2,1,0,0,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0
  ,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,0,5,1,0,2,5,1,0,2,3,0,0,1,3,1,0,0,5,0,0,3
  ,5,0,0,3,1,0,0,1,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2
  ,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0
  ,7,0,1,0,5,1,0,2,5,1,0,2,3,0,0,1,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,0
  ,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,0,0,1,1
  ,0,0,1,1,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0,5,3,0,0,0,0,1,1,5,3,0,0
  ,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,0,0,1,1,0,0,1,1,5,0,0,3,5,0,0,3,0,0,1,1
  ,0,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0
  ,0,0,1,1,2,0,1,1,3,0,1,0,3,0,1,0,0,0,1,1,0,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3
  ,0,0,1,1,0,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,5,3,0,0,5,0,0,3,5,0,0,3,0,0,1,1
  ,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0
  ,5,3,0,0,0,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,0,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,2,0,1,1,5,3,0,0,5,0,0,3,5,0,0,3,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,0,0,1,1,2,0,1,1,5,0,0,3
  ,5,0,0,3,0,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,5,3,0,0,5,0,0,3,5,0,0,3
  ,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0
  ,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,3,0,1,0,3,0,1,0,0,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,2,0,1,1,5,3,0,0,5,0,0,3,3,0,1,0,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,2,0,1,1,5,3,0,0
  ,5,0,0,3,5,0,0,3,0,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3
  ,5,0,0,3,0,0,1,1,2,0,1,1,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0
  ,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,3,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1
  ,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0
  ,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0,7,0,0,1
  ,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0
  ,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0
  ,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0
  ,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0
  ,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1
  ,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0
  ,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1
  ,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0
  ,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0
  ,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0
  ,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1
  ,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0
  ,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1
  ,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0
  ,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0
  ,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0
  ,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1
  ,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0
  ,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1
  ,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0
  ,7,1,0,0,7,1,0,0,1,0,0,0,6,0,1,1,7,0,0,1,7,0,0,1,1,0,0,0,6,0,1,1,7,1,0,0
  ,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,1,0,0,0,6,0,1,1
  ,7,0,0,1,7,0,0,1,1,0,0,0,6,0,1,1,7,1,0,0,7,1,0,0,1,0,0,0,1,0,0,0,7,0,0,1
  ,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1
  ,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0
  ,7,0,1,0,7,1,0,0,7,1,0,0,1,0,0,0,1,0,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0
  ,7,1,0,0,7,1,0,0,1,0,0,0,1,0,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,1,0,0,0
  ,1,0,0,0,7,0,0,1,7,0,0,1,1,0,0,0,6,0,1,1,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0
  ,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1
  ,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1
  ,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,6,0,1,1,1,0,0,0,7,0,0,1,7,0,0,1,6,0,1,1
  ,1,0,0,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0
  ,6,0,1,1,1,0,0,0,7,0,0,1,7,0,0,1,6,0,1,1,1,0,0,0,7,1,0,0,7,1,0,0,1,0,0,0
  ,7,1,0,0,7,0,0,1,7,0,0,1,6,0,1,1,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0
  ,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1
  ,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1
  ,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0
  ,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0
  ,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,1,0,1,0,1,0,2,1,7,0,0,1
  ,7,0,0,1,1,0,1,0,1,0,2,1,3,1,0,0,3,1,0,0,1,0,1,0,3,1,0,0,7,0,0,1,7,0,0,1
  ,1,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0
  ,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0
  ,3,1,0,0,3,1,0,0,1,0,1,0,1,0,2,1,7,0,0,1,7,0,0,1,1,0,1,0,1,0,2,1,3,1,0,0
  ,3,1,0,0,3,0,1,0,3,0,1,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,1,0,1,0,3,0,1,0
  ,1,0,3,0,1,0,3,0,1,0,1,0,1,0,1,0,3,1,0,0,3,1,0,0,3,0,1,0,3,0,1,0,7,0,0,1
  ,7,0,0,1,1,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1
  ,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0
  ,5,0,3,0,3,1,0,0,3,1,0,0,3,0,1,0,3,0,1,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,2,1
  ,3,1,0,0,3,1,0,0,3,0,1,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,1,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,0,0,5,3
  ,3,0,1,0,7,0,0,1,7,0,0,1,0,0,5,3,1,0,0,0,3,1,0,0,3,1,0,0,3,0,1,0,3,1,0,0
  ,7,0,0,1,7,0,0,1,1,0,1,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1
  ,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1
  ,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,0,0,5,3,3,0,1,0,7,0,0,1,7,0,0,1,0,0,5,3
  ,1,0,0,0,3,1,0,0,3,1,0,0,3,0,1,0,3,1,0,0,7,0,0,1,7,0,0,1,0,0,5,3,1,0,0,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,1,0,3,0,1,0,3,0,1,0,1,0,1,0,0,0,3,1,0,0,3,1,0,0,3,0,1,0
  ,3,1,0,0,7,0,0,1,1,0,3,0,1,0,1,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0
  ,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1
  ,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,0,1,0,3,1,0,0,7,0,0,1,7,0,0,1
  ,1,0,1,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,1,0
  ,1,0,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,1,0,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,1,0,0,0,1,0,0,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,1,0,0,0
  ,6,0,1,1,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,1,0,1,0,1,0,1,0,1,0,1,0,3,0,1,0,0,0,5,3,0,0,5,3
  ,3,1,0,0,3,0,1,0,1,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0
  ,3,1,0,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,1,0,2,1
  ,1,0,2,1,3,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0,3,1,0,0,3,1,0,0,3,1,0,0,3,0,1,0
  ,3,0,1,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,1,0,3,0,7,0,0,1,7,0,0,1
  ,7,0,0,1,1,0,3,0,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,7,0,0,1,7,0,0,1,1,0,3,0,7,0,0,1,7,0,0,1,7,0,0,1,1,0,3,0,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,1,0,3,0,7,0,0,1,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0
  ,0,0,5,3,0,0,5,3,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0
  ,0,0,5,3,1,0,1,0,1,0,1,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,1,0,2,1,1,0,2,1,1,0,1,0,1,0,2,1,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,1,0,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,3,0,0,1,3,0,0,1,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,3,0,0,1,3,0,0,1,5,0,3,0,3,0,0,1
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,3,1,0,0,3
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,3,1,0,0,3,7,0,1,0,1,0,0,3,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,1,1,0,0,1,1,0,0,1
  ,3,0,0,1,1,0,1,2,1,0,1,2,3,1,0,0,3,0,0,1,1,0,0,1,3,0,0,1,3,0,0,1,3,0,0,1
  ,3,0,0,1,3,0,0,1,3,0,0,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,0,0,3,5,0,0,3,5,3,0,0,1,3,0,0,1,3,0,0,1,3,0,0,1,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,0,0,1,3,0,0,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,1
  ,1,0,0,1,1,0,0,1,1,0,0,1,1,0,1,2,1,0,1,2,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1
  ,1,0,0,1,1,0,0,1,1,0,0,1,1,0,1,2,1,0,0,1,1,0,0,1,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,0,0,3,5,0,0,3,5,1,0,0,1,0,0,3,5,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,0,0,1,1,0,0,1,1,0,0,1,1,2,0,1,1,0,0,1,1,0,0,1,1,5,3,0,0,2,0,1,1
  ,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,0,0,1,1,0,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,3,0,1,0,5,0,0,3,5,0,0,3,5,0,0,3,3,0,1,0
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3
  ,3,0,1,0,5,0,0,3,5,0,0,3,5,0,0,3,3,0,1,0,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,3,0,1,0,5,0,0,3,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1
  ,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1
  ,0,0,1,1,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,0,0,1,1
  ,0,0,1,1,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,0,0,1,1,0,0,1,1
  ,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,0,0,1,1,0,0,1,1
  ,5,3,0,0,5,0,0,3,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3
  ,5,3,0,0,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,5,3,0,0,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0
  ,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,0,0,1,1
  ,0,0,1,1,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0
  ,5,0,0,3,2,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,0,0,1,1,5,3,0,0,5,0,0,3,5,3,0,0
  ,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,5,3,0,0,2,0,1,1,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3
  ,0,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1
  ,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,5,3,0,0,2,0,1,1
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0
  ,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,2,0,1,1
  ,0,0,1,1,5,3,0,0,5,0,0,3,5,3,0,0,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0
  ,5,0,0,3,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,0,0,1,1,5,3,0,0,5,0,0,3,5,3,0,0
  ,2,0,1,1,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,1,0,2,5,0,0,3,1,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,0,0,3,5,0,0,3,5,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3
  ,1,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,1,0,1,2,1,0,1,2
  ,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3
  ,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,1,0,2,5,0,0,3,1,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2
  ,5,0,0,3,3,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0
  ,1,0,0,1,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,1,0,2
  ,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,1,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,0,0,3,5
  ,0,0,3,5,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3
  ,1,0,1,2,1,0,1,2,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,0,0,1,1,0,1,2
  ,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3
  ,3,0,0,1,0,0,3,5,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,1
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2
  ,5,0,0,3,3,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0
  ,1,0,0,1,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0
  ,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2
  ,5,0,1,2,1,0,0,3,1,0,0,3,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3
  ,1,0,0,0,1,0,0,0,5,1,0,2,5,1,0,2,1,0,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0
  ,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2
  ,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,1,0,2
  ,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0
  ,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,1,0,0,0,3,1,0,0,5,0,0,3
  ,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3
  ,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0
  ,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0
  ,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2
  ,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,3,1,0,0,5,0,1,2,5,0,1,2,1,0,0,3,1,0,0,3,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0
  ,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3
  ,5,0,0,3,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2
  ,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0
  ,7,0,1,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0
  ,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,1,0,0,3,5,1,0,2,5,1,0,2,3,1,0,0
  ,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0
  ,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2
  ,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2
  ,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0
  ,1,0,0,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,3,0,0,1,3,0,0,1,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0,1,0,0,0
  ,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3
  ,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0
  ,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0
  ,5,3,0,0,1,0,0,0,5,3,0,0,3,0,1,0,3,0,1,0,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3
  ,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3
  ,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0
  ,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,3,0,0,1,3,0,0,1
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3
  ,5,0,0,3,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0
  ,3,0,0,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,3,0,1,0,3,0,1,0,1,0,0,0,1,0,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,3,0,1,0,1,0,0,0,1,0,0,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,1,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1
  ,1,0,2,1,1,0,2,1,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,3,1,0,0,7,0,0,1,1,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,1,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0
  ,7,0,0,1,0,0,5,3,0,0,5,3,3,1,0,0,7,0,0,1,3,0,1,0,1,0,0,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0
  ,1,0,1,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,1,0,1,0,1,0,1,0,3,1,0,0
  ,7,0,0,1,3,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,3,0,1,0
  ,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,3,1,0,0,7,0,0,1,3,1,0,0,1,0,1,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1
  ,3,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,1,0,1,0,1,0,1,0
  ,3,1,0,0,7,0,0,1,1,0,2,1,1,0,2,1,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1
  ,3,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,3,1,0,0,7,0,0,1,0,0,5,3,0,0,5,3,3,1,0,0,7,0,0,1,3,0,1,0,1,0,0,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0
  ,7,0,0,1,3,0,1,0,0,0,5,3,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0
  ,1,0,1,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,2,1,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0,3,1,0,0
  ,7,0,0,1,3,1,0,0,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,3,1,0,0
  ,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,3,1,0,0,7,0,0,1,3,1,0,0,1,0,1,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1
  ,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0
  ,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,6,0,1,1,6,0,1,1,7,1,0,0,7,0,0,1
  ,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0
  ,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0
  ,1,0,0,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0
  ,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1
  ,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,6,0,1,1,7,1,0,0,7,0,0,1
  ,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,1,0,0,0,6,0,1,1
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0
  ,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0
  ,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0
  ,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1
  ,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0
  ,7,0,1,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0
  ,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1
  ,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1
  ,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0
  ,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0
  ,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1
  ,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1
  ,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0
  ,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1
  ,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1
  ,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1
  ,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1
  ,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0
  ,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,1,0,0,0
  ,3,1,0,0,1,0,3,0,1,0,3,0,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1
  ,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1
  ,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0
  ,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0
  ,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1
  ,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1
  ,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0
  ,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,1,0,3,0,1,0,3,0,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,7,0,0,1,1,0,3,0,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0
  ,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1
  ,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1
  ,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,1,0,3,0
  ,1,0,3,0,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1
  ,7,0,0,1,1,0,3,0,1,0,3,0,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,1,0,3,0,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,1,0,0,0,1,0,0,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,1,0,0,0,6,0,1,1,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,1,0,1,0,1,0,1,0,1,0,1,0,3,0,1,0,0,0,5,3
  ,0,0,5,3,3,1,0,0,3,0,1,0,1,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0
  ,3,0,1,0,3,1,0,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,1,0,2,1,1,0,2,1,3,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,0,1,0,3,0,1,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,1,0,1,0,1,0,1,0,1,0
  ,1,0,1,0,0,0,5,3,0,0,5,3,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0
  ,1,0,1,0,0,0,5,3,1,0,1,0,1,0,1,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,1,0,2,1,1,0,2,1,1,0,1,0,1,0,2,1,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,3,0,1,0,3,0,1,0,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,1,0,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,3,0,0,1,3,0,0,1,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,3,0,1,0
  ,3,0,1,0,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,5,0,0,3,3,0,1,0,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,3,0,0,1,3,0,0,1,5,0,3,0
  ,3,0,0,1,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,3
  ,1,0,0,3,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,3,1,0,0,3,7,0,1,0,1,0,0,3,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,1,1,0,0,1
  ,1,0,0,1,3,0,0,1,1,0,1,2,1,0,1,2,3,1,0,0,3,0,0,1,1,0,0,1,3,0,0,1,3,0,0,1
  ,3,0,0,1,3,0,0,1,3,0,0,1,3,0,0,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,0,0,3,5,0,0,3,5,3,0,0,1,3,0,0,1,3,0,0,1,3,0,0,1
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,0,0,1,3,0,0,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,1,2,1,0,1,2,1,0,0,1,1,0,0,1,1,0,0,1
  ,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,1,2,1,0,0,1,1,0,0,1,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,0,0,3,5,0,0,3,5,1,0,0,1,0,0,3,5
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,0,0,1,1,0,0,1,1,0,0,1,1,2,0,1,1,0,0,1,1,0,0,1,1,5,3,0,0
  ,2,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,0,0,1,1,0,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1
  ,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1
  ,0,0,1,1,0,0,1,1,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,0,0,1,1
  ,0,0,1,1,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0
  ,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0
  ,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0
  ,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3
  ,1,0,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0
  ,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3
  ,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0
  ,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0
  ,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0
  ,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0
  ,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3
  ,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0
  ,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3
  ,5,3,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2
  ,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0
  ,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2
  ,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0
  ,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3
  ,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0
  ,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3
  ,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2
  ,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0
  ,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2
  ,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0
  ,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3
  ,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0
  ,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3
  ,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,1,0,2,1,0,0,0,3,1,0,0,5,0,0,3,5,0,0,3
  ,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0
  ,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0
  ,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2
  ,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,1,0,0,0,3,1,0,0
  ,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3
  ,5,0,0,3,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2
  ,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0
  ,7,0,1,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0
  ,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,3,1,0,0
  ,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0
  ,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2
  ,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2
  ,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0
  ,1,0,0,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2
  ,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,1,0,2,3,1,0,0
  ,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0
  ,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2
  ,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3
  ,1,0,0,0,1,0,0,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0
  ,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0
  ,1,0,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3
  ,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3
  ,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0
  ,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0
  ,5,3,0,0,5,3,0,0,1,0,0,0,5,3,0,0,3,0,1,0,3,0,1,0,1,0,0,0,1,0,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3
  ,5,0,0,3,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0
  ,5,0,3,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,3,0,1,0,3,0,1,0,1,0,0,0
  ,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,3,0,1,0,1,0,0,0,1,0,0,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0
  ,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0
  ,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1
  ,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0
  ,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1
  ,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0
  ,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0
  ,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0
  ,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0
  ,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1
  ,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0
  ,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1
  ,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0
  ,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0
  ,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0
  ,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1
  ,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0
  ,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1
  ,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0
  ,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0
  ,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0
  ,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1
  ,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0
  ,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1
  ,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1
  ,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0
  ,1,0,0,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0
  ,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1
  ,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,0,0,1
  ,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0
  ,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1
  ,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1
  ,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1
  ,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1
  ,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0
  ,7,0,1,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0
  ,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1
  ,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1
  ,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0
  ,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0
  ,1,0,0,0,3,1,0,0,1,0,3,0,1,0,3,0,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0
  ,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1
  ,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1
  ,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0
  ,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0
  ,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1
  ,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1
  ,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0
  ,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,3,0,1,0,3,0,1,0,0,0,1,0,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,1,0,3,0,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1
  ,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0,1,0,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,1,0,0,0
  ,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,1,0,0,0,6,0,1,1,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,1,0,1,0,1,0,1,0,1,0,1,0,3,0,1,0
  ,0,0,5,3,0,0,5,3,3,1,0,0,3,0,1,0,1,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0
  ,3,0,1,0,3,0,1,0,3,1,0,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,1,0,2,1,1,0,2,1,3,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,0,1,0,3,0,1,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,1,0,1,0,1,0
  ,1,0,1,0,1,0,1,0,0,0,5,3,0,0,5,3,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0
  ,1,0,1,0,1,0,1,0,0,0,5,3,1,0,1,0,1,0,1,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,1,0,2,1,1,0,2,1,1,0,1,0,1,0,2,1,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,1,0,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,3,0,0,1,3,0,0,1,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,3,0,0,1,3,0,0,1
  ,5,0,3,0,3,0,0,1,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,3,1,0,0,3,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,3,1,0,0,3,7,0,1,0,1,0,0,3,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,1
  ,1,0,0,1,1,0,0,1,3,0,0,1,1,0,1,2,1,0,1,2,3,1,0,0,3,0,0,1,1,0,0,1,3,0,0,1
  ,3,0,0,1,3,0,0,1,3,0,0,1,3,0,0,1,3,0,0,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,0,0,3,5,0,0,3,5,3,0,0,1,3,0,0,1,3,0,0,1
  ,3,0,0,1,3,1,0,0,3,1,0,0,3,1,0,0,3,0,0,1,3,0,0,1,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,1,2,1,0,1,2,1,0,0,1,1,0,0,1
  ,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,1,2,1,0,0,1,1,0,0,1,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,0,0,3,5,0,0,3,5,1,0,0,1
  ,0,0,3,5,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,0,0,1,1,0,0,1,1,0,0,1,1,2,0,1,1,0,0,1,1,0,0,1,1
  ,5,3,0,0,2,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,0,0,1,1
  ,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1
  ,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1
  ,0,0,1,1,0,0,1,1,0,0,1,1,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3
  ,0,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0
  ,3,0,0,1,2,0,1,1,2,0,1,1,5,3,0,0,3,0,0,1,5,3,0,0,5,0,0,3,0,0,1,1,0,0,1,1
  ,5,3,0,0,5,0,0,3,5,3,0,0,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,3,0,0,1,2,0,1,1,2,0,1,1,5,3,0,0
  ,3,0,0,1,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,5,3,0,0,2,0,1,1
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0
  ,3,0,1,0,0,0,1,1,0,0,1,1,5,3,0,0,3,0,1,0,2,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,2,0,1,1
  ,0,0,1,1,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,3,0,1,0,5,3,0,0,0,0,1,1,5,3,0,0
  ,3,0,1,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,3,0,0,1,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0,3,0,1,0,5,3,0,0
  ,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,5,3,0,0,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,0,0,1,1,0,0,1,1,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3
  ,2,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,0,0,1,1,0,0,1,1
  ,5,3,0,0,5,0,0,3,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3
  ,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0
  ,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,5,3,0,0,0,0,1,1,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,2,0,1,1
  ,0,0,1,1,5,3,0,0,5,0,0,3,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,0,0,1,1,5,3,0,0
  ,5,0,0,3,5,3,0,0,2,0,1,1,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,1,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,0,0,3,5
  ,0,0,3,5,5,0,1,2,5,0,1,2,3,1,0,0,1,0,0,3,5,0,1,2,5,0,1,2,3,1,0,0,1,0,0,3
  ,5,1,0,2,5,0,0,3,1,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,1,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3
  ,1,0,1,2,1,0,1,2,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,1,0,0,3,5,0,1,2,5,0,1,2,3,1,0,0,1,0,0,3,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1
  ,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,1,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3
  ,3,0,0,1,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2
  ,5,0,0,3,3,1,0,0,1,0,0,1,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,1,0,0,3,5,1,0,2,5,0,0,3,3,0,0,1
  ,1,0,0,1,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,1,0,0,1,1,0,0,1,5,1,0,2
  ,5,0,0,3,0,0,3,5,0,0,3,5,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,3,0,0,1
  ,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,1,0,2,5,0,0,3,1,0,1,2,1,0,1,2,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3
  ,3,0,0,1,1,0,1,2,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1
  ,5,1,0,2,5,0,0,3,3,0,0,1,0,0,3,5,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3
  ,3,1,0,0,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2
  ,5,0,0,3,3,1,0,0,1,0,0,1,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,3,1,0,0,5,0,1,2,5,0,1,2,1,0,0,3,1,0,0,3,5,1,0,2,5,1,0,2,1,0,0,1,0,0,3,5
  ,5,0,0,3,5,0,0,3,1,0,0,1,0,0,3,5,5,1,0,2,5,1,0,2,1,0,0,1,3,1,0,0,5,0,0,3
  ,5,0,0,3,1,0,0,1,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2
  ,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0
  ,7,0,1,0,5,1,0,2,5,1,0,2,1,0,0,1,0,0,3,5,5,0,0,3,5,0,0,3,1,0,0,1,0,0,3,5
  ,5,1,0,2,5,1,0,2,3,0,0,1,3,0,0,1,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,1,5,0,1,2
  ,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,1,0,0,1
  ,3,0,0,1,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,1,5,1,0,2,5,1,0,2,3,0,0,1,3,0,0,1
  ,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2
  ,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2
  ,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,3,0,0,1,3,0,0,1,5,0,0,3,5,0,0,3,1,0,0,1
  ,0,0,3,5,5,1,0,2,5,1,0,2,3,0,0,1,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,1
  ,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,1,0,0,3,1,0,0,3,5,1,0,2,5,1,0,2
  ,1,0,1,2,3,0,0,1,5,0,0,3,5,0,0,3,1,0,1,2,1,0,0,0,5,1,0,2,5,1,0,2,3,0,0,1
  ,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0
  ,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2
  ,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,1,0,1,2,3,0,0,1,5,0,0,3,5,0,0,3
  ,1,0,1,2,1,0,0,0,5,1,0,2,5,1,0,2,3,0,0,1,3,1,0,0,5,0,0,3,5,0,0,3,1,0,1,2
  ,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,1,0,0,3,5,1,0,2
  ,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,0,5,1,0,2,5,1,0,2
  ,3,0,0,1,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0
  ,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,3,0,0,1,3,1,0,0,5,0,0,3
  ,5,0,0,3,1,0,0,1,1,0,0,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3
  ,1,0,0,1,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0
  ,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,3,0,0,1,3,0,0,1
  ,5,3,0,0,5,3,0,0,0,0,1,1,0,0,1,1,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0
  ,5,3,0,0,0,0,1,1,5,3,0,0,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,0,0,1,1,0,0,1,1
  ,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,0,3
  ,5,0,0,3,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0
  ,5,0,3,0,5,3,0,0,5,3,0,0,0,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,5,3,0,0
  ,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,3,0,0,1,3,0,0,1,5,3,0,0,5,3,0,0,0,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,0,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,5,3,0,0,5,0,0,3,5,0,0,3,0,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0
  ,0,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,0,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1
  ,5,3,0,0,5,0,0,3,5,0,0,3,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,5,0,3,0,3,0,0,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3
  ,0,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,5,3,0,0,5,0,0,3,5,0,0,3,0,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0
  ,5,3,0,0,2,0,1,1,5,3,0,0,5,0,0,3,5,0,0,3,0,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,0,0,1,1,2,0,1,1,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,1,0,1,0,1,0,1,0
  ,3,1,0,0,7,0,0,1,1,0,2,1,1,0,2,1,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,1,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1
  ,3,1,0,0,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,3,1,0,0,7,0,0,1,0,0,5,3,0,0,5,3,3,1,0,0,7,0,0,1,3,0,1,0,1,0,0,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0
  ,7,0,0,1,3,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,1,0,3,0,1,0,1,0
  ,1,0,1,0,3,1,0,0,1,0,3,0,3,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0,3,1,0,0
  ,7,0,0,1,3,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,3,1,0,0,1,0,3,0,3,1,0,0,1,0,1,0,3,1,0,0,1,0,3,0,3,1,0,0
  ,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0,3,1,0,0,1,0,3,0,3,1,0,0,1,0,0,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1
  ,1,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,1,0,2,1,1,0,2,1,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0
  ,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,0,0,5,3,0,0,5,3,3,1,0,0,7,0,0,1
  ,3,0,1,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0,0,0,5,3,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0
  ,7,0,0,1,3,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,2,1,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0
  ,1,0,1,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0,3,1,0,0
  ,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,1,0,3,1,0,0,7,0,0,1,3,1,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1
  ,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1
  ,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0
  ,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0
  ,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0
  ,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,6,0,1,1
  ,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1
  ,1,0,0,0,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0
  ,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0
  ,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0
  ,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1
  ,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,1,0,0,0,6,0,1,1,7,0,0,1,7,0,0,1
  ,1,0,0,0,6,0,1,1,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0
  ,7,1,0,0,1,0,0,0,6,0,1,1,7,0,0,1,7,0,0,1,1,0,0,0,6,0,1,1,7,1,0,0,7,1,0,0
  ,1,0,0,0,1,0,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0
  ,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,1,0,0,0,1,0,0,0,7,0,0,1
  ,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,1,0,0,0,1,0,0,0,7,0,0,1,7,0,0,1
  ,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0
  ,7,1,0,0,7,1,0,0,1,0,0,0,1,0,0,0,7,0,0,1,7,0,0,1,1,0,0,0,6,0,1,1,7,1,0,0
  ,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,6,0,1,1,1,0,0,0
  ,7,0,0,1,7,0,0,1,6,0,1,1,1,0,0,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1
  ,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1
  ,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0
  ,7,0,1,0,7,1,0,0,7,1,0,0,6,0,1,1,1,0,0,0,7,0,0,1,7,0,0,1,6,0,1,1,1,0,0,0
  ,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,0,0,1,6,0,1,1,1,0,0,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0
  ,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1
  ,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1
  ,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0
  ,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0
  ,1,0,1,0,1,0,2,1,7,0,0,1,7,0,0,1,1,0,1,0,1,0,2,1,3,1,0,0,3,1,0,0,1,0,1,0
  ,3,1,0,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0
  ,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1
  ,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,1,0,1,0,1,0,2,1,7,0,0,1,7,0,0,1
  ,1,0,1,0,1,0,2,1,3,1,0,0,3,1,0,0,3,0,1,0,3,0,1,0,7,0,0,1,7,0,0,1,1,0,1,0
  ,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0
  ,3,1,0,0,1,0,1,0,3,0,1,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,1,0,3,1,0,0,3,1,0,0
  ,3,0,1,0,3,0,1,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0
  ,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,0,1,0,3,0,1,0,7,0,0,1
  ,7,0,0,1,1,0,1,0,1,0,2,1,3,1,0,0,3,1,0,0,3,0,1,0,3,1,0,0,7,0,0,1,7,0,0,1
  ,1,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0
  ,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0
  ,3,1,0,0,3,1,0,0,0,0,5,3,3,0,1,0,7,0,0,1,7,0,0,1,0,0,5,3,1,0,0,0,3,1,0,0
  ,3,1,0,0,3,0,1,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,0,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,0,0,5,3,3,0,1,0
  ,7,0,0,1,7,0,0,1,0,0,5,3,1,0,0,0,3,1,0,0,3,1,0,0,3,0,1,0,3,1,0,0,7,0,0,1
  ,7,0,0,1,0,0,5,3,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1
  ,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0
  ,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,0,0
  ,3,1,0,0,3,1,0,0,3,0,1,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,0,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,0,1,0
  ,3,1,0,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,7,0,0,1,7,0,0,1,1,0,1,0,1,0,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1
  ,7,0,0,1,1,0,3,0,1,0,3,0,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,1,0,1,0,0,0,5,3,1,0,1,0,3,1,0,0,1,0,1,0
  ,0,0,5,3,3,0,1,0,3,0,1,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,1,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0
  ,3,1,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,1,0,1,0,0,0,5,3,1,0,1,0,1,0,1,0,1,0,1,0,0,0,5,3,1,0,1,0,1,0,1,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,1,0,1,0,1,0
  ,1,0,1,0,1,0,1,0,1,0,1,0,0,0,5,3,1,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,7,0,0,1,7,0,0,1,1,0,3,0,1,0,3,0,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,1,0,3,0,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,1,0,2,1,3,0,1,0,3,0,1,0
  ,3,1,0,0,1,0,2,1,3,0,1,0,3,0,1,0,3,1,0,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,3,1,0,0,3,1,0,0,3,0,1,0,3,1,0,0,3,0,1,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,1,0,2,1,1,0,0,0,1,0,1,0,1,0,0,0,1,0,2,1,1,0,0,0,1,0,2,1
  ,1,0,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,1,0,1,0,1,0,0,0,1,0,1,0,1,0,0,0,1,0,1,0,1,0,0,0,1,0,1,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0
  ,6,0,1,1,1,0,0,0,7,1,0,0,1,0,0,0,6,0,1,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,7,1,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,6,0,1,1,1,0,0,0,1,0,0,0,1,0,0,0
  ,6,0,1,1,1,0,0,0,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,1,0,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,6,0,1,1,1,0,0,0,1,0,0,0,7,1,0,0,6,0,1,1,1,0,0,0,1,0,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,1,0,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,6,0,1,1,1,0,0,0,1,0,0,0
  ,1,0,0,0,6,0,1,1,1,0,0,0,6,0,1,1,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,3,1,0,0,3,1,0,0,1,0,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1
  ,1,0,3,0,7,0,0,1,7,0,0,1,7,0,0,1,1,0,3,0,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,1,0,3,0,7,0,0,1,7,0,0,1,7,0,0,1
  ,1,0,3,0,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,1,0,3,0
  ,7,0,0,1,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,3,0,1,0
  ,3,0,1,0,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,0,0,1,1,0,0,1,1,0,0,1,1,5,3,0,0,0,0,1,1,0,0,1,1,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,0,0,1,1,0,0,1,1
  ,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1
  ,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3
  ,5,0,0,3,3,0,1,0,3,0,1,0,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,5,0,0,3
  ,3,0,1,0,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,0,0,1,1
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,5,3,0,0,2,0,1,1,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,0,0,1,1,2,0,1,1,0,0,1,1,2,0,1,1,0,0,1,1,2,0,1,1,0,0,1,1,2,0,1,1,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,0,0,1,1,2,0,1,1
  ,0,0,1,1,2,0,1,1,0,0,1,1,2,0,1,1,0,0,1,1,2,0,1,1,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,1,1,0,1,2,1,0,0,1
  ,3,1,0,0,1,0,0,1,1,0,1,2,3,0,0,1,3,0,0,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,1,3,0,0,1,3,0,0,1,3,0,0,1,3,0,0,1
  ,3,0,0,1,3,0,0,1,3,1,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,1,0,0,1,1,0,1,2,1,0,0,1,1,0,0,1,1,0,0,1,1,0,1,2,1,0,0,1
  ,1,0,0,1,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,1,2,1,0,0,1,1,0,0,1,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,0,0,3,5
  ,3,0,0,1,3,0,0,1,3,1,0,0,0,0,3,5,3,0,0,1,3,0,0,1,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,0,0,1
  ,3,1,0,0,3,0,0,1,3,1,0,0,3,1,0,0,3,1,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,0,0,3,5,1,0,0,0,1,0,0,1,1,0,0,0,0,0,3,5
  ,1,0,0,0,0,0,3,5,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,1,0,0,1,1,0,0,0,1,0,0,1,1,0,0,0,1,0,0,1,1,0,0,0,1,0,0,1
  ,1,0,0,0,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,3,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,3,7,0,1,0
  ,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,3
  ,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,3,7,0,1,0,1,0,0,3,7,0,1,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,1,0,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,3,0,1,0,5,0,0,3
  ,5,0,0,3,5,0,0,3,3,0,1,0,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,5,0,0,3,5,0,0,3,3,0,1,0,5,0,0,3,5,0,0,3,5,0,0,3,3,0,1,0,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,3,0,1,0,5,0,0,3,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,3,0,0,1,5,0,3,0
  ,5,0,3,0,5,0,3,0,3,0,0,1,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,3,0,0,1,5,0,3,0,5,0,3,0,5,0,3,0,3,0,0,1,5,0,3,0
  ,3,0,0,1,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0
  ,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,3,0,0,1,2,0,1,1,2,0,1,1,5,3,0,0,3,0,0,1,5,3,0,0,5,0,0,3,1,0,0,0
  ,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0
  ,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,3,0,0,1,2,0,1,1,2,0,1,1
  ,5,3,0,0,3,0,0,1,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0
  ,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,5,3,0,0,3,0,1,0,1,0,0,0,1,0,0,0,5,3,0,0,3,0,1,0,5,3,0,0,1,0,0,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3
  ,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,3,0,1,0,5,3,0,0,1,0,0,0
  ,5,3,0,0,3,0,1,0,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,3,0,0,1,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,3,0,1,0
  ,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0
  ,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0
  ,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0
  ,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0
  ,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3
  ,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0
  ,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3
  ,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,1,0,0,3,5,0,1,2,5,0,1,2,3,1,0,0
  ,1,0,0,3,5,1,0,2,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2
  ,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,1,0,0,3,5,0,1,2,5,0,1,2,3,1,0,0,1,0,0,3,5,1,0,2,5,0,0,3,3,1,0,0
  ,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2
  ,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0
  ,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,1,0,0,3,5,1,0,2,5,0,0,3
  ,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0
  ,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3
  ,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2
  ,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0
  ,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2
  ,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0
  ,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,1,0,0,1
  ,0,0,3,5,5,0,0,3,5,0,0,3,1,0,0,1,0,0,3,5,5,1,0,2,5,1,0,2,1,0,0,1,3,1,0,0
  ,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2
  ,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2
  ,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,1,0,0,1,0,0,3,5,5,0,0,3,5,0,0,3,1,0,0,1
  ,0,0,3,5,5,1,0,2,5,1,0,2,3,0,0,1,3,0,0,1,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,1
  ,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2
  ,1,0,0,1,3,0,0,1,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,1,5,1,0,2,5,1,0,2,3,0,0,1
  ,3,0,0,1,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0
  ,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2
  ,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,3,0,0,1,3,0,0,1,5,0,0,3,5,0,0,3
  ,1,0,0,1,0,0,3,5,5,1,0,2,5,1,0,2,3,0,0,1,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,1
  ,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2
  ,5,1,0,2,1,0,1,2,3,0,0,1,5,0,0,3,5,0,0,3,1,0,1,2,1,0,0,0,5,1,0,2,5,1,0,2
  ,3,0,0,1,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0
  ,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,1,0,1,2,3,0,0,1,5,0,0,3
  ,5,0,0,3,1,0,1,2,1,0,0,0,5,1,0,2,5,1,0,2,3,0,0,1,3,1,0,0,5,0,0,3,5,0,0,3
  ,1,0,1,2,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0
  ,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0
  ,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,0,5,1,0,2
  ,5,1,0,2,3,0,0,1,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,3,0,0,1,3,1,0,0
  ,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3
  ,5,0,0,3,1,0,0,1,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0
  ,5,0,3,0,5,3,0,0,5,3,0,0,0,0,1,1,0,0,1,1,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1
  ,5,3,0,0,5,3,0,0,0,0,1,1,5,3,0,0,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,0,0,1,1
  ,0,0,1,1,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,0,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,0,0,1,1
  ,0,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0
  ,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1
  ,5,3,0,0,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,0,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3
  ,0,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,5,3,0,0,5,0,0,3,5,0,0,3,0,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0
  ,5,3,0,0,0,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,0,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,2,0,1,1,5,3,0,0,5,0,0,3,5,0,0,3,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3
  ,5,0,0,3,0,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,5,3,0,0,5,0,0,3,5,0,0,3
  ,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0
  ,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0
  ,5,3,0,0,5,3,0,0,2,0,1,1,5,3,0,0,5,0,0,3,5,0,0,3,0,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,0,0,1,1,2,0,1,1,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0
  ,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0
  ,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0
  ,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,1,0,3,0
  ,1,0,0,0,1,0,0,0,3,1,0,0,1,0,3,0,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0
  ,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,1,0,3,0,3,1,0,0,1,0,0,0,3,1,0,0,1,0,3,0
  ,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,1,0,3,0,3,1,0,0,1,0,0,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0
  ,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0
  ,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0
  ,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0
  ,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1
  ,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0
  ,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1
  ,3,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0
  ,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0
  ,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0
  ,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1
  ,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0
  ,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1
  ,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0
  ,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0
  ,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0
  ,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1
  ,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0
  ,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,1,0,0,0,6,0,1,1,7,0,0,1
  ,7,0,0,1,1,0,0,0,6,0,1,1,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,0,0,1
  ,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0
  ,7,1,0,0,7,1,0,0,1,0,0,0,6,0,1,1,7,0,0,1,7,0,0,1,1,0,0,0,6,0,1,1,7,1,0,0
  ,7,1,0,0,1,0,0,0,1,0,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,1,0,0,0,1,0,0,0
  ,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,1,0,0,0,1,0,0,0,7,0,0,1
  ,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1
  ,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0
  ,7,0,1,0,7,1,0,0,7,1,0,0,1,0,0,0,1,0,0,0,7,0,0,1,7,0,0,1,1,0,0,0,6,0,1,1
  ,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,6,0,1,1
  ,1,0,0,0,7,0,0,1,7,0,0,1,6,0,1,1,1,0,0,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0
  ,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1
  ,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1
  ,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,6,0,1,1,1,0,0,0,7,0,0,1,7,0,0,1,6,0,1,1
  ,1,0,0,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,0,0,1,6,0,1,1,1,0,0,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,1,0,0,0
  ,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0
  ,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1
  ,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,0,0,1
  ,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0
  ,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0
  ,3,1,0,0,1,0,1,0,1,0,2,1,7,0,0,1,7,0,0,1,1,0,1,0,1,0,2,1,3,1,0,0,3,1,0,0
  ,1,0,1,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0
  ,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,1,0,1,0,1,0,2,1,7,0,0,1
  ,7,0,0,1,1,0,1,0,1,0,2,1,3,1,0,0,3,1,0,0,3,0,1,0,3,0,1,0,7,0,0,1,7,0,0,1
  ,1,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0
  ,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0
  ,3,1,0,0,3,1,0,0,1,0,1,0,3,0,1,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,1,0,3,1,0,0
  ,3,1,0,0,3,0,1,0,3,0,1,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,0,1,0,3,0,1,0
  ,7,0,0,1,7,0,0,1,1,0,1,0,1,0,2,1,3,1,0,0,3,1,0,0,3,0,1,0,3,1,0,0,7,0,0,1
  ,7,0,0,1,1,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1
  ,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0
  ,5,0,3,0,3,1,0,0,3,1,0,0,0,0,5,3,3,0,1,0,7,0,0,1,7,0,0,1,0,0,5,3,1,0,0,0
  ,3,1,0,0,3,1,0,0,3,0,1,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,0,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,0,0,5,3
  ,3,0,1,0,7,0,0,1,7,0,0,1,0,0,5,3,1,0,0,0,3,1,0,0,3,1,0,0,3,0,1,0,3,1,0,0
  ,7,0,0,1,7,0,0,1,0,0,5,3,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1
  ,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1
  ,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,1,0
  ,1,0,0,0,3,1,0,0,3,1,0,0,3,0,1,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,0,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0
  ,3,0,1,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,1,0,1,0,0,0,5,3,1,0,1,0,3,1,0,0
  ,1,0,1,0,0,0,5,3,3,0,1,0,3,0,1,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,1,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0
  ,3,0,1,0,3,1,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,1,0,1,0,0,0,5,3,1,0,1,0,1,0,1,0,1,0,1,0,0,0,5,3,1,0,1,0,1,0,1,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,1,0
  ,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0,5,3,1,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,1,0,2,1,3,0,1,0
  ,3,0,1,0,3,1,0,0,1,0,2,1,3,0,1,0,3,0,1,0,3,1,0,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,3,1,0,0,3,1,0,0,3,0,1,0,3,1,0,0
  ,3,0,1,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,1,0,2,1,1,0,0,0,1,0,1,0,1,0,0,0,1,0,2,1,1,0,0,0
  ,1,0,2,1,1,0,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,1,0,1,0,1,0,0,0,1,0,1,0,1,0,0,0,1,0,1,0,1,0,0,0,1,0,1,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,1,0,0,0,6,0,1,1,1,0,0,0,7,1,0,0,1,0,0,0,6,0,1,1,1,0,0,0,1,0,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,7,1,0,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,6,0,1,1,1,0,0,0,1,0,0,0
  ,1,0,0,0,6,0,1,1,1,0,0,0,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1
  ,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,6,0,1,1,1,0,0,0,1,0,0,0,7,1,0,0,6,0,1,1,1,0,0,0,1,0,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,6,0,1,1,1,0,0,0
  ,1,0,0,0,1,0,0,0,6,0,1,1,1,0,0,0,6,0,1,1,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,3,1,0,0,3,1,0,0
  ,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1
  ,7,0,0,1,1,0,3,0,7,0,0,1,7,0,0,1,7,0,0,1,1,0,3,0,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,1,0,3,0,7,0,0,1,7,0,0,1
  ,7,0,0,1,1,0,3,0,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,1,0,3,0,7,0,0,1,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,0,0,1,1,0,0,1,1,0,0,1,1,5,3,0,0,0,0,1,1,0,0,1,1
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,0,0,1,1
  ,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,0,0,1,1,0,0,1,1,0,0,1,1
  ,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0
  ,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,5,3,0,0,2,0,1,1,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,0,0,1,1,2,0,1,1,0,0,1,1,2,0,1,1,0,0,1,1,2,0,1,1,0,0,1,1,2,0,1,1
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,0,0,1,1
  ,2,0,1,1,0,0,1,1,2,0,1,1,0,0,1,1,2,0,1,1,0,0,1,1,2,0,1,1,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,1,1,0,1,2
  ,1,0,0,1,3,1,0,0,1,0,0,1,1,0,1,2,3,0,0,1,3,0,0,1,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,1,3,0,0,1,3,0,0,1,3,0,0,1
  ,3,0,0,1,3,0,0,1,3,0,0,1,3,1,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,1,1,0,1,2,1,0,0,1,1,0,0,1,1,0,0,1,1,0,1,2
  ,1,0,0,1,1,0,0,1,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,1,2,1,0,0,1,1,0,0,1
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,0,0,3,5,3,0,0,1,3,0,0,1,3,1,0,0,0,0,3,5,3,0,0,1,3,0,0,1,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,0,0,1,3,1,0,0,3,0,0,1,3,1,0,0,3,1,0,0,3,1,0,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,0,0,3,5,1,0,0,0,1,0,0,1,1,0,0,0
  ,0,0,3,5,1,0,0,0,0,0,3,5,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,1,1,0,0,0,1,0,0,1,1,0,0,0,1,0,0,1,1,0,0,0
  ,1,0,0,1,1,0,0,0,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,3,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,3
  ,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,1,0,0,3,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,3,7,0,1,0,1,0,0,3,7,0,1,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,1,0,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,3,0,1,0
  ,5,0,0,3,5,0,0,3,5,0,0,3,3,0,1,0,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,3,0,1,0,5,0,0,3,5,0,0,3,5,0,0,3,3,0,1,0
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,3,0,1,0,5,0,0,3
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,3,0,0,1
  ,5,0,3,0,5,0,3,0,5,0,3,0,3,0,0,1,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,3,0,0,1,5,0,3,0,5,0,3,0,5,0,3,0,3,0,0,1
  ,5,0,3,0,3,0,0,1,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,5,3,0,0,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,0,0,1,1,0,0,1,1,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3
  ,0,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,5,3,0,0,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,0,0,1,1,0,0,1,1
  ,5,3,0,0,5,0,0,3,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3
  ,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,5,3,0,0,3,0,1,0,0,0,1,1,0,0,1,1,5,3,0,0,3,0,1,0,2,0,1,1,0,0,1,1
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0
  ,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,3,0,1,0,5,3,0,0
  ,0,0,1,1,5,3,0,0,3,0,1,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0
  ,3,0,1,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,0,0,1,1
  ,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3
  ,0,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1
  ,5,3,0,0,5,0,0,3,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3
  ,2,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,5,3,0,0,0,0,1,1
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0
  ,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0
  ,0,0,1,1,5,3,0,0,5,0,0,3,5,3,0,0,2,0,1,1,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,1,0,0,1,1,0,0,1,5,1,0,2
  ,5,0,0,3,0,0,3,5,0,0,3,5,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,1,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,3,1,0,0
  ,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,1,0,2,5,0,0,3,1,0,1,2,1,0,1,2,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3
  ,3,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,1,0,0,1,1,0,0,1
  ,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3
  ,3,0,0,1,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,1,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2
  ,5,0,0,3,3,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,1,0,0,1
  ,1,0,0,1,5,1,0,2,5,0,0,3,0,0,3,5,0,0,3,5,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,1,0,2
  ,5,0,0,3,3,0,0,1,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,1,0,1,2,1,0,1,2,5,1,0,2,5,0,0,3,3,0,0,1
  ,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,1,0,2,5,0,0,3,3,0,0,1,1,0,1,2,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3
  ,3,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,3,0,0,1,0,0,3,5,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1
  ,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3
  ,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,1,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,1,0,0,3,1,0,0,3,5,1,0,2,5,1,0,2
  ,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,1,0,2,1,0,0,0
  ,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0
  ,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2
  ,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3
  ,1,0,0,0,1,0,0,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0
  ,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2
  ,5,1,0,2,1,0,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,1,0,2
  ,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0
  ,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3
  ,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3
  ,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0
  ,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,1,0,0,3,1,0,0,3
  ,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2
  ,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0
  ,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3
  ,5,0,0,3,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2
  ,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0
  ,1,0,0,3,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0
  ,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,3,1,0,0
  ,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0
  ,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,3,0,0,1,3,0,0,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0
  ,1,0,0,0,5,3,0,0,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,0,0,3
  ,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0
  ,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,2,0,1,1,2,0,1,1,3,0,0,1,3,0,0,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3
  ,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3
  ,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0
  ,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,3,0,0,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3
  ,5,0,0,3,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0
  ,5,0,3,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1
  ,1,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,1,0,2,1,1,0,2,1,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,1,0,1,0,1,0,1,0
  ,3,1,0,0,7,0,0,1,3,1,0,0,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,0,0,5,3,0,0,5,3,3,1,0,0,7,0,0,1
  ,3,0,1,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0
  ,1,0,3,0,1,0,1,0,1,0,1,0,3,1,0,0,1,0,3,0,3,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0
  ,1,0,1,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,1,0,3,0,3,1,0,0,1,0,1,0,3,1,0,0
  ,1,0,3,0,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0,3,1,0,0,1,0,3,0,3,1,0,0
  ,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,3,1,0,0,7,0,0,1,1,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,1,0,2,1,1,0,2,1,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1
  ,3,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,0,0,5,3,0,0,5,3
  ,3,1,0,0,7,0,0,1,3,0,1,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0,0,0,5,3,3,1,0,0,7,0,0,1
  ,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,2,1
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0
  ,7,0,0,1,3,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,1,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0
  ,1,0,1,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,1,0,3,1,0,0
  ,7,0,0,1,3,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0
  ,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1
  ,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0
  ,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0
  ,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0
  ,7,0,0,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,1,0,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,7,1,0,0,7,0,0,1,6,0,1,1,6,0,1,1,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1
  ,1,0,0,0,6,0,1,1,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0
  ,7,1,0,0,7,0,0,1,1,0,0,0,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1
  ,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0
  ,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1
  ,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1
  ,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0
  ,7,0,1,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,1,0,0,0
  ,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1
  ,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1
  ,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0
  ,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0
  ,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1
  ,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1
  ,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0
  ,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1
  ,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1
  ,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0
  ,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0
  ,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1
  ,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1
  ,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0
  ,5,0,3,0,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1
  ,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1
  ,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0
  ,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0
  ,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1
  ,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1
  ,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0
  ,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,7,0,0,1,7,0,0,1,1,0,3,0,1,0,3,0,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,1,0,1,0,0,0,5,3,1,0,1,0
  ,3,1,0,0,1,0,1,0,0,0,5,3,3,0,1,0,3,0,1,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,1,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0
  ,3,0,1,0,3,0,1,0,3,1,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,1,0,1,0,0,0,5,3,1,0,1,0,1,0,1,0,1,0,1,0,0,0,5,3,1,0,1,0
  ,1,0,1,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0,5,3,1,0,1,0,1,0,1,0,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,1,0,3,0,1,0,3,0,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1,1,0,3,0,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,1,0,2,1
  ,3,0,1,0,3,0,1,0,3,1,0,0,1,0,2,1,3,0,1,0,3,0,1,0,3,1,0,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,3,1,0,0,3,1,0,0,3,0,1,0
  ,3,1,0,0,3,0,1,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,2,1,1,0,0,0,1,0,1,0,1,0,0,0,1,0,2,1
  ,1,0,0,0,1,0,2,1,1,0,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,1,0,1,0,1,0,0,0,1,0,1,0,1,0,0,0,1,0,1,0,1,0,0,0,1,0,1,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,1,0,0,0,6,0,1,1,1,0,0,0,7,1,0,0,1,0,0,0,6,0,1,1,1,0,0,0,1,0,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,7,1,0,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,6,0,1,1,1,0,0,0
  ,1,0,0,0,1,0,0,0,6,0,1,1,1,0,0,0,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,6,0,1,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,1,0,0,0,1,0,0,0,7,1,0,0,6,0,1,1,1,0,0,0
  ,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,6,0,1,1
  ,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,1,0,0,0,6,0,1,1,1,0,0,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,3,1,0,0
  ,3,1,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3
  ,5,0,0,3,3,0,1,0,3,0,1,0,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,0,0,1,1,0,0,1,1,0,0,1,1,5,3,0,0,0,0,1,1
  ,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,0,0,1,1,0,0,1,1
  ,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,5,0,0,3,5,0,0,3,3,0,1,0,3,0,1,0,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3
  ,5,0,0,3,5,0,0,3,3,0,1,0,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,0,0,1,1,2,0,1,1,2,0,1,1
  ,5,3,0,0,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,5,3,0,0,2,0,1,1
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,0,0,1,1,2,0,1,1,0,0,1,1,2,0,1,1,0,0,1,1,2,0,1,1,0,0,1,1
  ,2,0,1,1,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,0,0,1,1,2,0,1,1,0,0,1,1,2,0,1,1,0,0,1,1,2,0,1,1,0,0,1,1,2,0,1,1,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,1
  ,1,0,1,2,1,0,0,1,3,1,0,0,1,0,0,1,1,0,1,2,3,0,0,1,3,0,0,1,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,1,3,0,0,1,3,0,0,1
  ,3,0,0,1,3,0,0,1,3,0,0,1,3,0,0,1,3,1,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,1,1,0,1,2,1,0,0,1,1,0,0,1,1,0,0,1
  ,1,0,1,2,1,0,0,1,1,0,0,1,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,1,2,1,0,0,1
  ,1,0,0,1,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,0,0,3,5,3,0,0,1,3,0,0,1,3,1,0,0,0,0,3,5,3,0,0,1,3,0,0,1,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,0,0,1,3,1,0,0,3,0,0,1,3,1,0,0,3,1,0,0,3,1,0,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,0,0,3,5,1,0,0,0,1,0,0,1
  ,1,0,0,0,0,0,3,5,1,0,0,0,0,0,3,5,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,1,1,0,0,0,1,0,0,1,1,0,0,0,1,0,0,1
  ,1,0,0,0,1,0,0,1,1,0,0,0,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,3,7,0,1,0,7,0,1,0,7,0,1,0
  ,1,0,0,3,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,1,0,0,3,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,3,7,0,1,0,1,0,0,3,7,0,1,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,1,0,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,3,0,0,1,5,0,3,0,5,0,3,0,5,0,3,0,3,0,0,1,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,3,0,0,1,5,0,3,0,5,0,3,0,5,0,3,0
  ,3,0,0,1,5,0,3,0,3,0,0,1,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0
  ,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0
  ,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0
  ,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,5,3,0,0,3,0,1,0,1,0,0,0,1,0,0,0,5,3,0,0,3,0,1,0,5,3,0,0
  ,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,3,0,1,0
  ,5,3,0,0,1,0,0,0,5,3,0,0,3,0,1,0,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0
  ,5,3,0,0,3,0,1,0,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3
  ,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0
  ,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0
  ,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0
  ,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0
  ,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3
  ,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0
  ,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,0,0,3
  ,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2
  ,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,1,0,0,0
  ,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2
  ,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0
  ,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3
  ,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0
  ,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3
  ,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2
  ,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0
  ,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2
  ,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0
  ,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2
  ,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,1,0,2
  ,1,0,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0
  ,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3
  ,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3
  ,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0
  ,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0
  ,5,1,0,2,5,1,0,2,1,0,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2
  ,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0
  ,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3
  ,5,0,0,3,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2
  ,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0
  ,7,0,1,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0
  ,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,3,1,0,0
  ,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0
  ,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2
  ,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2
  ,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0
  ,1,0,0,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2
  ,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,1,0,2,3,1,0,0
  ,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3
  ,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0
  ,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3
  ,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3
  ,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0
  ,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3
  ,5,0,0,3,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0
  ,5,0,3,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0
  ,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0
  ,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,1,0,0,0
  ,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0
  ,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0
  ,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,3,1,0,0,1,0,3,0,1,0,0,0,1,0,0,0,3,1,0,0,1,0,3,0,3,1,0,0,1,0,0,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1
  ,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,1,0,3,0,3,1,0,0,1,0,0,0
  ,3,1,0,0,1,0,3,0,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,1,0,3,0
  ,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0
  ,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0
  ,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0
  ,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0
  ,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1
  ,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0
  ,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1
  ,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0
  ,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0
  ,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0
  ,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1
  ,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0
  ,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1
  ,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0
  ,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0
  ,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0
  ,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0
  ,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1
  ,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1
  ,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0
  ,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0
  ,1,0,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0
  ,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1
  ,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1
  ,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0
  ,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1
  ,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1
  ,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1
  ,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1
  ,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0
  ,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0
  ,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1
  ,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1
  ,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0
  ,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0
  ,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1
  ,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1
  ,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0
  ,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0
  ,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1
  ,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1
  ,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0
  ,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,1,0,1,0,0,0,5,3
  ,1,0,1,0,3,1,0,0,1,0,1,0,0,0,5,3,3,0,1,0,3,0,1,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,1,0,1,0,3,0,1,0,3,0,1,0,3,0,1,0
  ,3,0,1,0,3,0,1,0,3,0,1,0,3,1,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,1,0,1,0,0,0,5,3,1,0,1,0,1,0,1,0,1,0,1,0,0,0,5,3
  ,1,0,1,0,1,0,1,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0,5,3,1,0,1,0,1,0,1,0
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,1,0,2,1,3,0,1,0,3,0,1,0,3,1,0,0,1,0,2,1,3,0,1,0,3,0,1,0,3,1,0,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,3,1,0,0,3,1,0,0
  ,3,0,1,0,3,1,0,0,3,0,1,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,2,1,1,0,0,0,1,0,1,0,1,0,0,0
  ,1,0,2,1,1,0,0,0,1,0,2,1,1,0,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,1,0,1,0,1,0,0,0,1,0,1,0,1,0,0,0,1,0,1,0,1,0,0,0
  ,1,0,1,0,1,0,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,1,0,0,0,6,0,1,1,1,0,0,0,7,1,0,0,1,0,0,0,6,0,1,1,1,0,0,0
  ,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,7,1,0,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,6,0,1,1
  ,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,1,0,0,0,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,6,0,1,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,1,0,0,0,1,0,0,0,7,1,0,0,6,0,1,1
  ,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,6,0,1,1,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,1,0,0,0,6,0,1,1,1,0,0,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,0,0,1,1,0,0,1,1,0,0,1,1,5,3,0,0
  ,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,0,0,1,1
  ,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,0,0,1,1,2,0,1,1
  ,2,0,1,1,5,3,0,0,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,5,3,0,0
  ,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,0,0,1,1,2,0,1,1,0,0,1,1,2,0,1,1,0,0,1,1,2,0,1,1
  ,0,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,0,0,1,1,2,0,1,1,0,0,1,1,2,0,1,1,0,0,1,1,2,0,1,1,0,0,1,1,2,0,1,1
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,1,0,0,1,1,0,1,2,1,0,0,1,3,1,0,0,1,0,0,1,1,0,1,2,3,0,0,1,3,0,0,1,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,1,3,0,0,1
  ,3,0,0,1,3,0,0,1,3,0,0,1,3,0,0,1,3,0,0,1,3,1,0,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,1,1,0,1,2,1,0,0,1,1,0,0,1
  ,1,0,0,1,1,0,1,2,1,0,0,1,1,0,0,1,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,1,2
  ,1,0,0,1,1,0,0,1,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,0,0,3,5,3,0,0,1,3,0,0,1,3,1,0,0,0,0,3,5,3,0,0,1,3,0,0,1
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,0,0,1,3,1,0,0,3,0,0,1,3,1,0,0,3,1,0,0,3,1,0,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,0,0,3,5,1,0,0,0
  ,1,0,0,1,1,0,0,0,0,0,3,5,1,0,0,0,0,0,3,5,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,1,1,0,0,0,1,0,0,1,1,0,0,0
  ,1,0,0,1,1,0,0,0,1,0,0,1,1,0,0,0,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,3,7,0,1,0,7,0,1,0
  ,7,0,1,0,1,0,0,3,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,1,0,0,3,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,3,7,0,1,0,1,0,0,3
  ,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,1,0,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,3,0,0,1,5,0,3,0,5,0,3,0,5,0,3,0,3,0,0,1,5,0,3,0,5,0,3,0,5,0,3,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,3,0,0,1,5,0,3,0,5,0,3,0
  ,5,0,3,0,3,0,0,1,5,0,3,0,3,0,0,1,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,0,0,1,1
  ,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,3,0,0,1,2,0,1,1,2,0,1,1,5,3,0,0,3,0,0,1
  ,5,3,0,0,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,5,3,0,0,0,0,1,1,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3
  ,0,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0
  ,3,0,0,1,2,0,1,1,2,0,1,1,5,3,0,0,3,0,0,1,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1
  ,5,3,0,0,5,0,0,3,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3
  ,2,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0
  ,5,0,0,3,5,3,0,0,0,0,1,1,5,3,0,0,5,0,0,3,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,3,0,0,1,5,3,0,0,5,0,0,3,2,0,1,1
  ,0,0,1,1,5,3,0,0,5,0,0,3,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0
  ,5,0,0,3,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,2,0,1,1
  ,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,5,3,0,0,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3
  ,2,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1
  ,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3
  ,5,3,0,0,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,5,3,0,0,2,0,1,1
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0
  ,5,0,0,3,5,3,0,0,0,0,1,1,5,3,0,0,5,0,0,3,5,3,0,0,2,0,1,1,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,1,0,0,1
  ,1,0,0,1,5,1,0,2,5,0,0,3,0,0,3,5,0,0,3,5,5,0,1,2,5,0,1,2,3,1,0,0,1,0,0,3
  ,5,0,1,2,5,0,1,2,3,1,0,0,1,0,0,3,5,1,0,2,5,0,0,3,1,0,0,1,1,0,0,1,5,1,0,2
  ,5,0,0,3,3,1,0,0,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,1,0,1,2,1,0,1,2,5,1,0,2,5,0,0,3,3,0,0,1
  ,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,1,0,0,3,5,0,1,2,5,0,1,2,3,1,0,0,1,0,0,3
  ,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3
  ,1,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1
  ,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,1,5,1,0,2,5,0,0,3
  ,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,1,0,0,3,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2
  ,5,0,0,3,1,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,0,0,3,5,0,0,3,5,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,0,0,1
  ,1,0,0,1,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,1,0,1,2,1,0,1,2,5,1,0,2
  ,5,0,0,3,3,0,0,1,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,0,0,1,1,0,1,2,5,1,0,2,5,0,0,3,3,1,0,0
  ,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,3,0,0,1,0,0,3,5,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3
  ,3,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1
  ,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,1,5,1,0,2,5,0,0,3
  ,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0
  ,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,1,0,0,3,1,0,0,3
  ,5,1,0,2,5,1,0,2,1,0,0,1,0,0,3,5,5,0,0,3,5,0,0,3,1,0,0,1,0,0,3,5,5,1,0,2
  ,5,1,0,2,1,0,0,1,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,1,5,0,1,2,5,0,1,2
  ,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,1,0,0,1,0,0,3,5
  ,5,0,0,3,5,0,0,3,1,0,0,1,0,0,3,5,5,1,0,2,5,1,0,2,3,0,0,1,3,0,0,1,5,0,0,3
  ,5,0,0,3,1,0,0,1,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2
  ,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0
  ,7,0,1,0,5,1,0,2,5,1,0,2,1,0,0,1,3,0,0,1,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,1
  ,5,1,0,2,5,1,0,2,3,0,0,1,3,0,0,1,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,1,5,0,1,2
  ,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,3,0,0,1
  ,3,0,0,1,5,0,0,3,5,0,0,3,1,0,0,1,0,0,3,5,5,1,0,2,5,1,0,2,3,0,0,1,3,1,0,0
  ,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2
  ,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2
  ,1,0,0,3,1,0,0,3,5,1,0,2,5,1,0,2,1,0,1,2,3,0,0,1,5,0,0,3,5,0,0,3,1,0,1,2
  ,1,0,0,0,5,1,0,2,5,1,0,2,3,0,0,1,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2
  ,1,0,1,2,3,0,0,1,5,0,0,3,5,0,0,3,1,0,1,2,1,0,0,0,5,1,0,2,5,1,0,2,3,0,0,1
  ,3,1,0,0,5,0,0,3,5,0,0,3,1,0,1,2,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0
  ,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2
  ,5,0,1,2,7,0,1,0,1,0,0,3,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3
  ,1,0,0,1,1,0,0,0,5,1,0,2,5,1,0,2,3,0,0,1,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,1
  ,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2
  ,5,1,0,2,3,0,0,1,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,0,5,1,0,2,5,1,0,2
  ,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,2,0,1,1,2,0,1,1,3,0,0,1,3,0,0,1,5,3,0,0,5,3,0,0,0,0,1,1,0,0,1,1,5,0,0,3
  ,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0,5,3,0,0,0,0,1,1,5,3,0,0,5,0,0,3,5,0,0,3
  ,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0
  ,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0
  ,5,3,0,0,5,3,0,0,0,0,1,1,0,0,1,1,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,0,0,1,1,2,0,1,1
  ,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,0,3
  ,5,0,0,3,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0
  ,5,0,3,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1
  ,5,3,0,0,5,3,0,0,2,0,1,1,5,3,0,0,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,3,0,0,1,3,0,0,1,5,3,0,0,5,3,0,0,0,0,1,1
  ,2,0,1,1,5,0,0,3,5,0,0,3,0,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,5,3,0,0
  ,5,0,0,3,5,0,0,3,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,0,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,0,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,5,3,0,0,5,0,0,3,5,0,0,3,0,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,3,0,0,1,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,0,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1
  ,5,3,0,0,5,0,0,3,5,0,0,3,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,2,0,1,1,5,3,0,0,5,0,0,3,5,0,0,3
  ,0,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,0,0,1,1
  ,2,0,1,1,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,3,1,0,0,7,0,0,1,1,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,1,0,2,1,1,0,2,1,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1
  ,1,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,0,0,5,3,0,0,5,3
  ,3,1,0,0,7,0,0,1,3,0,1,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1
  ,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,3,1,0,0,7,0,0,1,1,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0
  ,7,0,0,1,3,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0
  ,1,0,1,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0,3,1,0,0
  ,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,1,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,1,0,2,1
  ,1,0,2,1,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1
  ,0,0,5,3,0,0,5,3,3,1,0,0,7,0,0,1,3,0,1,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0,0,0,5,3
  ,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1
  ,3,0,1,0,1,0,2,1,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,1,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0
  ,7,0,0,1,3,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0
  ,1,0,1,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0
  ,7,0,0,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,7,1,0,0,7,0,0,1,6,0,1,1,6,0,1,1,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1
  ,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0
  ,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1
  ,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0
  ,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0
  ,1,0,0,0,7,1,0,0,7,0,0,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0
  ,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,6,0,1,1,6,0,1,1,7,1,0,0,7,0,0,1,1,0,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,7,1,0,0,7,0,0,1,1,0,0,0,6,0,1,1,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1
  ,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,1,0,0,0,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0
  ,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1
  ,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0
  ,1,0,0,0,6,0,1,1,7,0,0,1,7,0,0,1,1,0,0,0,6,0,1,1,7,1,0,0,7,1,0,0,1,0,0,0
  ,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0
  ,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1
  ,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,1,0,0,0,6,0,1,1,7,0,0,1,7,0,0,1
  ,1,0,0,0,6,0,1,1,7,1,0,0,7,1,0,0,1,0,0,0,1,0,0,0,7,0,0,1,7,0,0,1,1,0,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0
  ,7,1,0,0,1,0,0,0,1,0,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0
  ,1,0,0,0,1,0,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0
  ,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,1,0,0,0,1,0,0,0,7,0,0,1
  ,7,0,0,1,1,0,0,0,6,0,1,1,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,0,0,1
  ,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0
  ,7,1,0,0,7,1,0,0,6,0,1,1,1,0,0,0,7,0,0,1,7,0,0,1,6,0,1,1,1,0,0,0,7,1,0,0
  ,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,6,0,1,1,1,0,0,0
  ,7,0,0,1,7,0,0,1,6,0,1,1,1,0,0,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1
  ,7,0,0,1,6,0,1,1,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1
  ,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0
  ,7,0,1,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0
  ,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,1,0,0,0
  ,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1
  ,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1
  ,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,1,0,1,0,1,0,2,1,7,0,0,1,7,0,0,1,1,0,1,0
  ,1,0,2,1,3,1,0,0,3,1,0,0,1,0,1,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,1,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0
  ,1,0,1,0,1,0,2,1,7,0,0,1,7,0,0,1,1,0,1,0,1,0,2,1,3,1,0,0,3,1,0,0,3,0,1,0
  ,3,0,1,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0
  ,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1
  ,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,1,0,1,0,3,0,1,0,7,0,0,1,7,0,0,1
  ,1,0,1,0,1,0,1,0,3,1,0,0,3,1,0,0,3,0,1,0,3,0,1,0,7,0,0,1,7,0,0,1,1,0,1,0
  ,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0
  ,3,1,0,0,3,0,1,0,3,0,1,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,2,1,3,1,0,0,3,1,0,0
  ,3,0,1,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0
  ,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,0,0,5,3,3,0,1,0,7,0,0,1
  ,7,0,0,1,0,0,5,3,1,0,0,0,3,1,0,0,3,1,0,0,3,0,1,0,3,1,0,0,7,0,0,1,7,0,0,1
  ,1,0,1,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0
  ,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0
  ,3,1,0,0,3,1,0,0,0,0,5,3,3,0,1,0,7,0,0,1,7,0,0,1,0,0,5,3,1,0,0,0,3,1,0,0
  ,3,1,0,0,3,0,1,0,3,1,0,0,7,0,0,1,7,0,0,1,0,0,5,3,1,0,0,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,7,0,0,1,7,0,0,1,1,0,1,0,1,0,0,0,3,1,0,0,3,1,0,0,3,0,1,0,3,1,0,0,7,0,0,1
  ,7,0,0,1,1,0,1,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1
  ,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0
  ,5,0,3,0,3,1,0,0,3,1,0,0,3,0,1,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,0,0,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,1,0,3,0,1,0,3,0,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,3,1,0,0
  ,3,1,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,1,0,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,1,0,3,0,1,0,3,0
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1,1,0,3,0,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,1,0,3,0,7,0,0,1,7,0,0,1,7,0,0,1,1,0,3,0
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1
  ,1,0,3,0,7,0,0,1,7,0,0,1,7,0,0,1,1,0,3,0,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,1,0,3,0,7,0,0,1,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,5,0,0,3,5,0,0,3,3,0,1,0,3,0,1,0,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,1,0,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,3,0,1,0,3,0,1,0,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,5,0,0,3,5,0,0,3,5,0,0,3,3,0,1,0,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,1,0,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,5,0,0,3,5,0,0,3,3,0,1,0,5,0,0,3,5,0,0,3,5,0,0,3,3,0,1,0,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,3,0,1,0,5,0,0,3
  ,5,0,0,3,5,0,0,3,3,0,1,0,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,3,0,1,0,5,0,0,3,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3
  ,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,3,0,0,1,2,0,1,1,2,0,1,1,5,3,0,0
  ,3,0,0,1,5,3,0,0,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0
  ,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,3,0,0,1,2,0,1,1,2,0,1,1,5,3,0,0,3,0,0,1,5,3,0,0,5,0,0,3,5,3,0,0
  ,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0
  ,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0
  ,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,3,0,0,1,5,3,0,0,5,0,0,3
  ,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0
  ,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3
  ,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0
  ,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0
  ,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0
  ,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0
  ,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3
  ,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,1,0,0,3,5,0,1,2,5,0,1,2,3,1,0,0,1,0,0,3,5,1,0,2,5,0,0,3,1,0,0,0,1,0,0,0
  ,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3
  ,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,1,0,0,3,5,0,1,2,5,0,1,2,3,1,0,0
  ,1,0,0,3,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2
  ,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0
  ,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2
  ,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,1,0,0,3,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0
  ,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3
  ,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0
  ,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3
  ,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2
  ,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0
  ,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2
  ,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2
  ,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0
  ,7,0,1,0,5,1,0,2,5,1,0,2,1,0,0,1,0,0,3,5,5,0,0,3,5,0,0,3,1,0,0,1,0,0,3,5
  ,5,1,0,2,5,1,0,2,1,0,0,1,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,1,5,0,1,2
  ,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,1,0,0,1
  ,0,0,3,5,5,0,0,3,5,0,0,3,1,0,0,1,0,0,3,5,5,1,0,2,5,1,0,2,3,0,0,1,3,0,0,1
  ,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2
  ,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2
  ,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,1,0,0,1,3,0,0,1,5,0,0,3,5,0,0,3,1,0,0,1
  ,1,0,0,1,5,1,0,2,5,1,0,2,3,0,0,1,3,0,0,1,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,1
  ,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2
  ,3,0,0,1,3,0,0,1,5,0,0,3,5,0,0,3,1,0,0,1,0,0,3,5,5,1,0,2,5,1,0,2,3,0,0,1
  ,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0
  ,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2
  ,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,1,0,1,2,3,0,0,1,5,0,0,3,5,0,0,3
  ,1,0,1,2,1,0,0,0,5,1,0,2,5,1,0,2,3,0,0,1,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,1
  ,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2
  ,5,1,0,2,1,0,1,2,3,0,0,1,5,0,0,3,5,0,0,3,1,0,1,2,1,0,0,0,5,1,0,2,5,1,0,2
  ,3,0,0,1,3,1,0,0,5,0,0,3,5,0,0,3,1,0,1,2,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0
  ,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3
  ,5,0,0,3,1,0,0,1,1,0,0,0,5,1,0,2,5,1,0,2,3,0,0,1,3,1,0,0,5,0,0,3,5,0,0,3
  ,1,0,0,1,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0
  ,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0
  ,5,1,0,2,5,1,0,2,3,0,0,1,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,0,5,1,0,2
  ,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,1,1,0,0,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,0,0,1,1,0,0,1,1
  ,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0,5,3,0,0,0,0,1,1,5,3,0,0,5,0,0,3
  ,5,0,0,3,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0
  ,5,0,3,0,5,3,0,0,5,3,0,0,0,0,1,1,0,0,1,1,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,0,0,1,1
  ,2,0,1,1,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,0,0,1,1
  ,0,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,5,3,0,0,5,0,0,3,5,0,0,3,0,0,1,1,0,0,1,1
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0
  ,0,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,0,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1
  ,5,3,0,0,5,0,0,3,5,0,0,3,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,0,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3
  ,0,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,5,3,0,0,5,0,0,3,5,0,0,3,0,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,0,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,2,0,1,1,5,3,0,0,5,0,0,3,5,0,0,3,0,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,2,0,1,1,5,3,0,0,5,0,0,3
  ,5,0,0,3,0,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3
  ,0,0,1,1,2,0,1,1,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0
  ,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0
  ,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0
  ,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0
  ,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1
  ,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0
  ,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1
  ,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0
  ,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0
  ,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0
  ,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0
  ,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1
  ,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0
  ,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1
  ,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0
  ,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0
  ,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0
  ,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1
  ,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0
  ,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1
  ,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0
  ,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0
  ,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0
  ,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0
  ,7,1,0,0,1,0,0,0,6,0,1,1,7,0,0,1,7,0,0,1,1,0,0,0,6,0,1,1,7,1,0,0,7,1,0,0
  ,1,0,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0
  ,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,1,0,0,0,6,0,1,1,7,0,0,1
  ,7,0,0,1,1,0,0,0,6,0,1,1,7,1,0,0,7,1,0,0,1,0,0,0,1,0,0,0,7,0,0,1,7,0,0,1
  ,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0
  ,7,1,0,0,7,1,0,0,1,0,0,0,1,0,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0
  ,7,1,0,0,1,0,0,0,1,0,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,1,0,0,0,1,0,0,0
  ,7,0,0,1,7,0,0,1,1,0,0,0,6,0,1,1,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1
  ,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1
  ,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0
  ,7,0,1,0,7,1,0,0,7,1,0,0,6,0,1,1,1,0,0,0,7,0,0,1,7,0,0,1,6,0,1,1,1,0,0,0
  ,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,6,0,1,1
  ,1,0,0,0,7,0,0,1,7,0,0,1,6,0,1,1,1,0,0,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0
  ,7,0,0,1,7,0,0,1,6,0,1,1,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1
  ,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1
  ,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0
  ,1,0,0,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0
  ,1,0,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0
  ,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1
  ,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,1,0,1,0,1,0,2,1,7,0,0,1,7,0,0,1
  ,1,0,1,0,1,0,2,1,3,1,0,0,3,1,0,0,1,0,1,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,1,0
  ,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0
  ,3,1,0,0,1,0,1,0,1,0,2,1,7,0,0,1,7,0,0,1,1,0,1,0,1,0,2,1,3,1,0,0,3,1,0,0
  ,3,0,1,0,3,0,1,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0
  ,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,1,0,1,0,3,0,1,0,7,0,0,1
  ,7,0,0,1,1,0,1,0,1,0,1,0,3,1,0,0,3,1,0,0,3,0,1,0,3,0,1,0,7,0,0,1,7,0,0,1
  ,1,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0
  ,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0
  ,3,1,0,0,3,1,0,0,3,0,1,0,3,0,1,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,2,1,3,1,0,0
  ,3,1,0,0,3,0,1,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,0,0,5,3,3,0,1,0
  ,7,0,0,1,7,0,0,1,0,0,5,3,1,0,0,0,3,1,0,0,3,1,0,0,3,0,1,0,3,1,0,0,7,0,0,1
  ,7,0,0,1,1,0,1,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1
  ,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0
  ,5,0,3,0,3,1,0,0,3,1,0,0,0,0,5,3,3,0,1,0,7,0,0,1,7,0,0,1,0,0,5,3,1,0,0,0
  ,3,1,0,0,3,1,0,0,3,0,1,0,3,1,0,0,7,0,0,1,7,0,0,1,0,0,5,3,1,0,0,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,0,0,3,1,0,0,3,1,0,0,3,0,1,0,3,1,0,0
  ,7,0,0,1,7,0,0,1,1,0,1,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1
  ,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1
  ,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,0,1,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,1,0
  ,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,1,0,1,0,0,0
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,1,0,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,1,0,3,0,7,0,0,1,7,0,0,1,7,0,0,1
  ,1,0,3,0,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1
  ,7,0,0,1,1,0,3,0,7,0,0,1,7,0,0,1,7,0,0,1,1,0,3,0,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,1,0,3,0,7,0,0,1,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,1,0,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,5,0,0,3,5,0,0,3,3,0,1,0,5,0,0,3,5,0,0,3,5,0,0,3,3,0,1,0,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,3,0,1,0
  ,5,0,0,3,5,0,0,3,5,0,0,3,3,0,1,0,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,3,0,1,0,5,0,0,3,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0
  ,5,0,0,3,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,5,3,0,0
  ,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,5,3,0,0,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3
  ,2,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,0,0,1,1,0,0,1,1
  ,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3
  ,2,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,0,0,1,1,5,3,0,0,5,0,0,3,5,3,0,0,2,0,1,1
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0
  ,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,0,0,1,1
  ,0,0,1,1,5,3,0,0,5,0,0,3,0,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0
  ,5,0,0,3,2,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,0,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,5,3,0,0,2,0,1,1,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3
  ,2,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1
  ,5,3,0,0,5,0,0,3,5,3,0,0,0,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,2,0,1,1,0,0,1,1,5,3,0,0,5,0,0,3
  ,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,0,0,1,1,5,3,0,0,5,0,0,3,5,3,0,0,2,0,1,1
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2
  ,5,0,0,3,1,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,0,0,3,5,0,0,3,5,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,1,0,0,1
  ,1,0,0,1,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,1,0,1,2,1,0,1,2,5,1,0,2
  ,5,0,0,3,3,0,0,1,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,3,1,0,0
  ,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,1,0,2,5,0,0,3,1,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3
  ,3,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,1
  ,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3
  ,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,1,0,2,5,0,0,3,1,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,0,0,3,5,0,0,3,5
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2
  ,5,0,0,3,3,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,1,0,1,2
  ,1,0,1,2,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,0,0,1,1,0,1,2,5,1,0,2
  ,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,3,0,0,1
  ,0,0,3,5,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,1,0,2,5,0,0,3,3,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,1,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3
  ,3,0,0,1,1,0,0,1,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,1
  ,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2
  ,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2
  ,1,0,0,3,1,0,0,3,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0
  ,1,0,0,0,5,1,0,2,5,1,0,2,1,0,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2
  ,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,1,0,2,3,1,0,0
  ,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0
  ,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2
  ,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,1,0,0,0,3,1,0,0,5,0,0,3,5,0,0,3
  ,1,0,0,0,1,0,0,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0
  ,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2
  ,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,1,0,2
  ,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0
  ,5,0,1,2,5,0,1,2,1,0,0,3,1,0,0,3,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3
  ,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3
  ,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0
  ,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0
  ,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2
  ,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,1,0,0,3,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0
  ,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3
  ,5,0,0,3,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2
  ,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0
  ,7,0,1,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0
  ,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,3,0,0,1,3,0,0,1,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0,1,0,0,0,5,3,0,0
  ,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0
  ,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0
  ,1,0,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3
  ,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0
  ,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,3,0,0,1,3,0,0,1,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3
  ,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3
  ,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0
  ,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,3,0,0,1
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3
  ,5,0,0,3,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,1,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,1,0,2,1
  ,1,0,2,1,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,3,1,0,0,7,0,0,1,1,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,1,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1
  ,0,0,5,3,0,0,5,3,3,1,0,0,7,0,0,1,3,0,1,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0
  ,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,1,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1
  ,3,0,1,0,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0
  ,7,0,0,1,3,1,0,0,1,0,1,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0
  ,1,0,1,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,1,0,1,0,1,0,1,0,3,1,0,0
  ,7,0,0,1,1,0,2,1,1,0,2,1,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,3,0,1,0
  ,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,3,1,0,0,7,0,0,1,0,0,5,3,0,0,5,3,3,1,0,0,7,0,0,1,3,0,1,0,1,0,0,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1
  ,3,0,1,0,0,0,5,3,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0
  ,3,1,0,0,7,0,0,1,3,0,1,0,1,0,2,1,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1
  ,3,1,0,0,1,0,1,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,3,1,0,0,7,0,0,1,3,0,1,0,1,0,1,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0
  ,7,0,0,1,3,1,0,0,1,0,1,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0
  ,1,0,0,0,7,1,0,0,7,0,0,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0
  ,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,6,0,1,1,6,0,1,1,7,1,0,0,7,0,0,1,1,0,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1
  ,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0
  ,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1
  ,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0
  ,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0
  ,1,0,0,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,6,0,1,1,7,1,0,0,7,0,0,1,7,1,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,1,0,0,0,6,0,1,1,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1
  ,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0
  ,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1
  ,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0
  ,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1
  ,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1
  ,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0
  ,7,0,1,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1
  ,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1
  ,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0
  ,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0
  ,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1
  ,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1
  ,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0
  ,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1
  ,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,7,0,0,1
  ,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0
  ,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0
  ,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1
  ,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1
  ,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0
  ,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1
  ,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1
  ,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0
  ,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0
  ,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1
  ,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1
  ,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0
  ,1,0,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,1,0,3,0,1,0,3,0
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,1,0,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1
  ,1,0,3,0,1,0,3,0,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1,1,0,3,0
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,3,0,1,0,3,0,1,0,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,1,0,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,3,0,1,0,3,0,1,0
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,5,0,0,3,3,0,1,0,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0
  ,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0,5,0,0,3
  ,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0
  ,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,1,0,0,0
  ,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0
  ,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0
  ,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3
  ,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0
  ,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3
  ,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0
  ,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0
  ,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0
  ,5,0,0,3,5,3,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,0,3,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,0,3,0,5,3,0,0,5,0,0,3,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,3,0,0
  ,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3
  ,1,0,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0
  ,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3
  ,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,1,0,2,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2
  ,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0
  ,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2
  ,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0
  ,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0
  ,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3
  ,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0
  ,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3
  ,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2
  ,5,0,0,3,3,1,0,0,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,7,0,1,0,5,1,0,2,5,0,0,3,3,1,0,0
  ,1,0,0,0,5,1,0,2,5,0,0,3,3,1,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0
  ,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2
  ,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3
  ,1,0,0,0,1,0,0,0,5,1,0,2,5,1,0,2,1,0,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0
  ,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0
  ,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2
  ,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,1,0,2
  ,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0
  ,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,1,0,0,0,3,1,0,0,5,0,0,3
  ,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3
  ,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0
  ,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0
  ,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2
  ,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0
  ,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0
  ,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3
  ,5,0,0,3,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2
  ,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0
  ,7,0,1,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0
  ,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,0,1,2
  ,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2
  ,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,3,1,0,0
  ,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0
  ,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2
  ,5,0,1,2,7,0,1,0,7,0,1,0,5,0,1,2,5,0,1,2,3,1,0,0,3,1,0,0,5,0,1,2,5,0,1,2
  ,7,0,1,0,7,0,1,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0
  ,1,0,0,0,5,1,0,2,5,1,0,2,3,1,0,0,3,1,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0,1,0,0,0
  ,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3
  ,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0
  ,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0
  ,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0
  ,5,3,0,0,1,0,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0
  ,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3
  ,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3
  ,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0
  ,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3
  ,5,0,0,3,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0
  ,5,0,3,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,2,0,1,1,2,0,1,1
  ,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,5,0,3,0,5,0,3,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,0,0,3,5,0,0,3,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1
  ,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,3,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0
  ,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0
  ,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0
  ,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0
  ,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1
  ,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0
  ,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1
  ,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0
  ,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0
  ,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0
  ,7,0,0,1,3,1,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,0,3,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0
  ,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,0,3,0
  ,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1,3,1,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1
  ,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,1,0,0,0,1,0,0,0
  ,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1
  ,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0
  ,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0
  ,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0
  ,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1
  ,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0
  ,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1
  ,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0
  ,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0
  ,1,0,0,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,0,1,0,7,1,0,0,7,0,0,1,7,1,0,0,1,0,0,0,7,1,0,0
  ,7,0,0,1,7,1,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1
  ,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0
  ,7,0,1,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0
  ,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1
  ,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1
  ,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1
  ,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0
  ,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1
  ,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0
  ,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1
  ,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1
  ,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0
  ,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0
  ,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1
  ,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1
  ,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0
  ,7,0,1,0,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,7,0,1,0,7,0,1,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,7,0,0,1
  ,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1
  ,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0
  ,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1
  ,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,1,0,0,0
  ,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1
  ,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1
  ,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0
  ,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1
  ,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0
  ,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1
  ,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1
  ,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0
  ,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0
  ,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,1,2,0
  ,5,1,2,0,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,5,0,2,1,5,0,2,1,5,1,2,0,5,1,2,0
  ,5,0,2,1,5,0,2,1,5,0,3,0,5,0,3,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1
  ,7,0,0,1,1,0,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,7,0,0,1,7,0,0,1
  ,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,1,0,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,1,0,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0,7,1,0,0
  ,7,1,0,0,7,1,0,0,7,1,0,0,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1
  ,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,6,0,1,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0,5,1,2,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1,5,0,2,1
  ,5,0,2,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1
  ,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,7,0,0,1,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,1,0,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2,5,1,0,2
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,1,0,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,1,0,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0,3,1,0,0
  ,3,1,0,0,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2
  ,5,0,1,2,5,0,1,2,5,0,1,2,5,0,1,2,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0
  ,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,1,0,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0
  ,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,5,3,0,0,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1
  ,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,2,0,1,1,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3
  ,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,0,3,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
  ,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0}
};
#endif

