#ifndef INCLUDED_OFFICECFG_OFFICE_WRITERWEB_HXX
#define INCLUDED_OFFICECFG_OFFICE_WRITERWEB_HXX

#include "sal/config.h"

#include <optional>
#include "rtl/ustring.h"
#include "rtl/ustring.hxx"
#include "sal/types.h"
#include "comphelper/configuration.hxx"

namespace officecfg { namespace Office { namespace WriterWeb {

struct Content: public comphelper::ConfigurationGroup< Content> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Content"_ustr); return PATH; }

struct Display: public comphelper::ConfigurationGroup< Display> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Content/Display"_ustr); return PATH; }

struct GraphicObject: public comphelper::ConfigurationProperty<GraphicObject, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Content/Display/GraphicObject"_ustr); return PATH; }
private:
    GraphicObject(); // not defined
    ~GraphicObject(); // not defined
};

struct Table: public comphelper::ConfigurationProperty<Table, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Content/Display/Table"_ustr); return PATH; }
private:
    Table(); // not defined
    ~Table(); // not defined
};

struct DrawingControl: public comphelper::ConfigurationProperty<DrawingControl, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Content/Display/DrawingControl"_ustr); return PATH; }
private:
    DrawingControl(); // not defined
    ~DrawingControl(); // not defined
};

struct FieldCode: public comphelper::ConfigurationProperty<FieldCode, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Content/Display/FieldCode"_ustr); return PATH; }
private:
    FieldCode(); // not defined
    ~FieldCode(); // not defined
};

struct Note: public comphelper::ConfigurationProperty<Note, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Content/Display/Note"_ustr); return PATH; }
private:
    Note(); // not defined
    ~Note(); // not defined
};

private:
    Display(); // not defined
    ~Display(); // not defined
};

struct NonprintingCharacter: public comphelper::ConfigurationGroup< NonprintingCharacter> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Content/NonprintingCharacter"_ustr); return PATH; }

struct MetaCharacters: public comphelper::ConfigurationProperty<MetaCharacters, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Content/NonprintingCharacter/MetaCharacters"_ustr); return PATH; }
private:
    MetaCharacters(); // not defined
    ~MetaCharacters(); // not defined
};

struct ParagraphEnd: public comphelper::ConfigurationProperty<ParagraphEnd, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Content/NonprintingCharacter/ParagraphEnd"_ustr); return PATH; }
private:
    ParagraphEnd(); // not defined
    ~ParagraphEnd(); // not defined
};

struct OptionalHyphen: public comphelper::ConfigurationProperty<OptionalHyphen, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Content/NonprintingCharacter/OptionalHyphen"_ustr); return PATH; }
private:
    OptionalHyphen(); // not defined
    ~OptionalHyphen(); // not defined
};

struct Space: public comphelper::ConfigurationProperty<Space, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Content/NonprintingCharacter/Space"_ustr); return PATH; }
private:
    Space(); // not defined
    ~Space(); // not defined
};

struct ProtectedSpace: public comphelper::ConfigurationProperty<ProtectedSpace, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Content/NonprintingCharacter/ProtectedSpace"_ustr); return PATH; }
private:
    ProtectedSpace(); // not defined
    ~ProtectedSpace(); // not defined
};

struct Break: public comphelper::ConfigurationProperty<Break, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Content/NonprintingCharacter/Break"_ustr); return PATH; }
private:
    Break(); // not defined
    ~Break(); // not defined
};

private:
    NonprintingCharacter(); // not defined
    ~NonprintingCharacter(); // not defined
};

struct Highlighting: public comphelper::ConfigurationGroup< Highlighting> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Content/Highlighting"_ustr); return PATH; }

struct Field: public comphelper::ConfigurationProperty<Field, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Content/Highlighting/Field"_ustr); return PATH; }
private:
    Field(); // not defined
    ~Field(); // not defined
};

private:
    Highlighting(); // not defined
    ~Highlighting(); // not defined
};

private:
    Content(); // not defined
    ~Content(); // not defined
};

struct Layout: public comphelper::ConfigurationGroup< Layout> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Layout"_ustr); return PATH; }

struct Line: public comphelper::ConfigurationGroup< Line> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Layout/Line"_ustr); return PATH; }

struct Guide: public comphelper::ConfigurationProperty<Guide, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Layout/Line/Guide"_ustr); return PATH; }
private:
    Guide(); // not defined
    ~Guide(); // not defined
};

private:
    Line(); // not defined
    ~Line(); // not defined
};

struct Window: public comphelper::ConfigurationGroup< Window> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Layout/Window"_ustr); return PATH; }

struct HorizontalScroll: public comphelper::ConfigurationProperty<HorizontalScroll, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Layout/Window/HorizontalScroll"_ustr); return PATH; }
private:
    HorizontalScroll(); // not defined
    ~HorizontalScroll(); // not defined
};

struct VerticalScroll: public comphelper::ConfigurationProperty<VerticalScroll, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Layout/Window/VerticalScroll"_ustr); return PATH; }
private:
    VerticalScroll(); // not defined
    ~VerticalScroll(); // not defined
};

struct ShowRulers: public comphelper::ConfigurationProperty<ShowRulers, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Layout/Window/ShowRulers"_ustr); return PATH; }
private:
    ShowRulers(); // not defined
    ~ShowRulers(); // not defined
};

struct HorizontalRuler: public comphelper::ConfigurationProperty<HorizontalRuler, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Layout/Window/HorizontalRuler"_ustr); return PATH; }
private:
    HorizontalRuler(); // not defined
    ~HorizontalRuler(); // not defined
};

struct HorizontalRulerUnit: public comphelper::ConfigurationProperty<HorizontalRulerUnit, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Layout/Window/HorizontalRulerUnit"_ustr); return PATH; }
private:
    HorizontalRulerUnit(); // not defined
    ~HorizontalRulerUnit(); // not defined
};

struct VerticalRuler: public comphelper::ConfigurationProperty<VerticalRuler, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Layout/Window/VerticalRuler"_ustr); return PATH; }
private:
    VerticalRuler(); // not defined
    ~VerticalRuler(); // not defined
};

struct VerticalRulerUnit: public comphelper::ConfigurationProperty<VerticalRulerUnit, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Layout/Window/VerticalRulerUnit"_ustr); return PATH; }
private:
    VerticalRulerUnit(); // not defined
    ~VerticalRulerUnit(); // not defined
};

struct SmoothScroll: public comphelper::ConfigurationProperty<SmoothScroll, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Layout/Window/SmoothScroll"_ustr); return PATH; }
private:
    SmoothScroll(); // not defined
    ~SmoothScroll(); // not defined
};

private:
    Window(); // not defined
    ~Window(); // not defined
};

struct Other: public comphelper::ConfigurationGroup< Other> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Layout/Other"_ustr); return PATH; }

struct IsAlignMathObjectsToBaseline: public comphelper::ConfigurationProperty<IsAlignMathObjectsToBaseline, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Layout/Other/IsAlignMathObjectsToBaseline"_ustr); return PATH; }
private:
    IsAlignMathObjectsToBaseline(); // not defined
    ~IsAlignMathObjectsToBaseline(); // not defined
};

struct MeasureUnit: public comphelper::ConfigurationProperty<MeasureUnit, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Layout/Other/MeasureUnit"_ustr); return PATH; }
private:
    MeasureUnit(); // not defined
    ~MeasureUnit(); // not defined
};

private:
    Other(); // not defined
    ~Other(); // not defined
};

struct Zoom: public comphelper::ConfigurationGroup< Zoom> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Layout/Zoom"_ustr); return PATH; }

struct Type: public comphelper::ConfigurationProperty<Type, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Layout/Zoom/Type"_ustr); return PATH; }
private:
    Type(); // not defined
    ~Type(); // not defined
};

struct Value: public comphelper::ConfigurationProperty<Value, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Layout/Zoom/Value"_ustr); return PATH; }
private:
    Value(); // not defined
    ~Value(); // not defined
};

private:
    Zoom(); // not defined
    ~Zoom(); // not defined
};

private:
    Layout(); // not defined
    ~Layout(); // not defined
};

struct Grid: public comphelper::ConfigurationGroup< Grid> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Grid"_ustr); return PATH; }

struct Option: public comphelper::ConfigurationGroup< Option> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Grid/Option"_ustr); return PATH; }

struct SnapToGrid: public comphelper::ConfigurationProperty<SnapToGrid, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Grid/Option/SnapToGrid"_ustr); return PATH; }
private:
    SnapToGrid(); // not defined
    ~SnapToGrid(); // not defined
};

struct VisibleGrid: public comphelper::ConfigurationProperty<VisibleGrid, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Grid/Option/VisibleGrid"_ustr); return PATH; }
private:
    VisibleGrid(); // not defined
    ~VisibleGrid(); // not defined
};

struct Synchronize: public comphelper::ConfigurationProperty<Synchronize, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Grid/Option/Synchronize"_ustr); return PATH; }
private:
    Synchronize(); // not defined
    ~Synchronize(); // not defined
};

private:
    Option(); // not defined
    ~Option(); // not defined
};

struct Resolution: public comphelper::ConfigurationGroup< Resolution> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Grid/Resolution"_ustr); return PATH; }

struct XAxis: public comphelper::ConfigurationProperty<XAxis, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Grid/Resolution/XAxis"_ustr); return PATH; }
private:
    XAxis(); // not defined
    ~XAxis(); // not defined
};

struct YAxis: public comphelper::ConfigurationProperty<YAxis, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Grid/Resolution/YAxis"_ustr); return PATH; }
private:
    YAxis(); // not defined
    ~YAxis(); // not defined
};

private:
    Resolution(); // not defined
    ~Resolution(); // not defined
};

struct Subdivision: public comphelper::ConfigurationGroup< Subdivision> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Grid/Subdivision"_ustr); return PATH; }

struct XAxis: public comphelper::ConfigurationProperty<XAxis, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Grid/Subdivision/XAxis"_ustr); return PATH; }
private:
    XAxis(); // not defined
    ~XAxis(); // not defined
};

struct YAxis: public comphelper::ConfigurationProperty<YAxis, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Grid/Subdivision/YAxis"_ustr); return PATH; }
private:
    YAxis(); // not defined
    ~YAxis(); // not defined
};

private:
    Subdivision(); // not defined
    ~Subdivision(); // not defined
};

private:
    Grid(); // not defined
    ~Grid(); // not defined
};

struct Print: public comphelper::ConfigurationGroup< Print> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Print"_ustr); return PATH; }

struct Content: public comphelper::ConfigurationGroup< Content> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Print/Content"_ustr); return PATH; }

struct Graphic: public comphelper::ConfigurationProperty<Graphic, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Print/Content/Graphic"_ustr); return PATH; }
private:
    Graphic(); // not defined
    ~Graphic(); // not defined
};

struct Table: public comphelper::ConfigurationProperty<Table, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Print/Content/Table"_ustr); return PATH; }
private:
    Table(); // not defined
    ~Table(); // not defined
};

struct Control: public comphelper::ConfigurationProperty<Control, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Print/Content/Control"_ustr); return PATH; }
private:
    Control(); // not defined
    ~Control(); // not defined
};

struct Background: public comphelper::ConfigurationProperty<Background, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Print/Content/Background"_ustr); return PATH; }
private:
    Background(); // not defined
    ~Background(); // not defined
};

struct PrintBlack: public comphelper::ConfigurationProperty<PrintBlack, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Print/Content/PrintBlack"_ustr); return PATH; }
private:
    PrintBlack(); // not defined
    ~PrintBlack(); // not defined
};

struct Note: public comphelper::ConfigurationProperty<Note, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Print/Content/Note"_ustr); return PATH; }
private:
    Note(); // not defined
    ~Note(); // not defined
};

private:
    Content(); // not defined
    ~Content(); // not defined
};

struct Page: public comphelper::ConfigurationGroup< Page> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Print/Page"_ustr); return PATH; }

struct Reversed: public comphelper::ConfigurationProperty<Reversed, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Print/Page/Reversed"_ustr); return PATH; }
private:
    Reversed(); // not defined
    ~Reversed(); // not defined
};

struct Brochure: public comphelper::ConfigurationProperty<Brochure, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Print/Page/Brochure"_ustr); return PATH; }
private:
    Brochure(); // not defined
    ~Brochure(); // not defined
};

struct BrochureRightToLeft: public comphelper::ConfigurationProperty<BrochureRightToLeft, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Print/Page/BrochureRightToLeft"_ustr); return PATH; }
private:
    BrochureRightToLeft(); // not defined
    ~BrochureRightToLeft(); // not defined
};

private:
    Page(); // not defined
    ~Page(); // not defined
};

struct Output: public comphelper::ConfigurationGroup< Output> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Print/Output"_ustr); return PATH; }

struct Fax: public comphelper::ConfigurationProperty<Fax, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Print/Output/Fax"_ustr); return PATH; }
private:
    Fax(); // not defined
    ~Fax(); // not defined
};

private:
    Output(); // not defined
    ~Output(); // not defined
};

struct Papertray: public comphelper::ConfigurationGroup< Papertray> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Print/Papertray"_ustr); return PATH; }

struct FromPrinterSetup: public comphelper::ConfigurationProperty<FromPrinterSetup, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Print/Papertray/FromPrinterSetup"_ustr); return PATH; }
private:
    FromPrinterSetup(); // not defined
    ~FromPrinterSetup(); // not defined
};

private:
    Papertray(); // not defined
    ~Papertray(); // not defined
};

private:
    Print(); // not defined
    ~Print(); // not defined
};

struct Table: public comphelper::ConfigurationGroup< Table> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Table"_ustr); return PATH; }

struct Shift: public comphelper::ConfigurationGroup< Shift> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Table/Shift"_ustr); return PATH; }

struct Row: public comphelper::ConfigurationProperty<Row, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Table/Shift/Row"_ustr); return PATH; }
private:
    Row(); // not defined
    ~Row(); // not defined
};

struct Column: public comphelper::ConfigurationProperty<Column, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Table/Shift/Column"_ustr); return PATH; }
private:
    Column(); // not defined
    ~Column(); // not defined
};

private:
    Shift(); // not defined
    ~Shift(); // not defined
};

struct Insert: public comphelper::ConfigurationGroup< Insert> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Table/Insert"_ustr); return PATH; }

struct Row: public comphelper::ConfigurationProperty<Row, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Table/Insert/Row"_ustr); return PATH; }
private:
    Row(); // not defined
    ~Row(); // not defined
};

struct Column: public comphelper::ConfigurationProperty<Column, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Table/Insert/Column"_ustr); return PATH; }
private:
    Column(); // not defined
    ~Column(); // not defined
};

private:
    Insert(); // not defined
    ~Insert(); // not defined
};

struct Change: public comphelper::ConfigurationGroup< Change> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Table/Change"_ustr); return PATH; }

struct Effect: public comphelper::ConfigurationProperty<Effect, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Table/Change/Effect"_ustr); return PATH; }
private:
    Effect(); // not defined
    ~Effect(); // not defined
};

private:
    Change(); // not defined
    ~Change(); // not defined
};

struct Input: public comphelper::ConfigurationGroup< Input> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Table/Input"_ustr); return PATH; }

struct NumberRecognition: public comphelper::ConfigurationProperty<NumberRecognition, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Table/Input/NumberRecognition"_ustr); return PATH; }
private:
    NumberRecognition(); // not defined
    ~NumberRecognition(); // not defined
};

struct NumberFormatRecognition: public comphelper::ConfigurationProperty<NumberFormatRecognition, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Table/Input/NumberFormatRecognition"_ustr); return PATH; }
private:
    NumberFormatRecognition(); // not defined
    ~NumberFormatRecognition(); // not defined
};

struct Alignment: public comphelper::ConfigurationProperty<Alignment, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Table/Input/Alignment"_ustr); return PATH; }
private:
    Alignment(); // not defined
    ~Alignment(); // not defined
};

struct SplitVerticalByDefault: public comphelper::ConfigurationProperty<SplitVerticalByDefault, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Table/Input/SplitVerticalByDefault"_ustr); return PATH; }
private:
    SplitVerticalByDefault(); // not defined
    ~SplitVerticalByDefault(); // not defined
};

private:
    Input(); // not defined
    ~Input(); // not defined
};

private:
    Table(); // not defined
    ~Table(); // not defined
};

struct Insert: public comphelper::ConfigurationGroup< Insert> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Insert"_ustr); return PATH; }

struct Table: public comphelper::ConfigurationGroup< Table> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Insert/Table"_ustr); return PATH; }

struct Header: public comphelper::ConfigurationProperty<Header, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Insert/Table/Header"_ustr); return PATH; }
private:
    Header(); // not defined
    ~Header(); // not defined
};

struct RepeatHeader: public comphelper::ConfigurationProperty<RepeatHeader, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Insert/Table/RepeatHeader"_ustr); return PATH; }
private:
    RepeatHeader(); // not defined
    ~RepeatHeader(); // not defined
};

struct Border: public comphelper::ConfigurationProperty<Border, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Insert/Table/Border"_ustr); return PATH; }
private:
    Border(); // not defined
    ~Border(); // not defined
};

private:
    Table(); // not defined
    ~Table(); // not defined
};

private:
    Insert(); // not defined
    ~Insert(); // not defined
};

struct ObjectBar: public comphelper::ConfigurationGroup< ObjectBar> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/ObjectBar"_ustr); return PATH; }

struct Selection: public comphelper::ConfigurationGroup< Selection> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/ObjectBar/Selection"_ustr); return PATH; }

struct Graphic: public comphelper::ConfigurationProperty<Graphic, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/ObjectBar/Selection/Graphic"_ustr); return PATH; }
private:
    Graphic(); // not defined
    ~Graphic(); // not defined
};

struct Table: public comphelper::ConfigurationProperty<Table, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/ObjectBar/Selection/Table"_ustr); return PATH; }
private:
    Table(); // not defined
    ~Table(); // not defined
};

struct NumberedList: public comphelper::ConfigurationProperty<NumberedList, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/ObjectBar/Selection/NumberedList"_ustr); return PATH; }
private:
    NumberedList(); // not defined
    ~NumberedList(); // not defined
};

struct NumberedList_InTable: public comphelper::ConfigurationProperty<NumberedList_InTable, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/ObjectBar/Selection/NumberedList_InTable"_ustr); return PATH; }
private:
    NumberedList_InTable(); // not defined
    ~NumberedList_InTable(); // not defined
};

struct BezierObject: public comphelper::ConfigurationProperty<BezierObject, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/ObjectBar/Selection/BezierObject"_ustr); return PATH; }
private:
    BezierObject(); // not defined
    ~BezierObject(); // not defined
};

private:
    Selection(); // not defined
    ~Selection(); // not defined
};

private:
    ObjectBar(); // not defined
    ~ObjectBar(); // not defined
};

struct Background: public comphelper::ConfigurationGroup< Background> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Background"_ustr); return PATH; }

struct Color: public comphelper::ConfigurationProperty<Color, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Background/Color"_ustr); return PATH; }
private:
    Color(); // not defined
    ~Color(); // not defined
};

private:
    Background(); // not defined
    ~Background(); // not defined
};

struct Gallery: public comphelper::ConfigurationGroup< Gallery> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Gallery"_ustr); return PATH; }

struct AddGraphic: public comphelper::ConfigurationProperty<AddGraphic, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.WriterWeb/Gallery/AddGraphic"_ustr); return PATH; }
private:
    AddGraphic(); // not defined
    ~AddGraphic(); // not defined
};

private:
    Gallery(); // not defined
    ~Gallery(); // not defined
};

} } }

#endif
