
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kmultitabbartab_wrapper.h"

// Wrappers providing overrides
#include "ksplittercollapserbutton_wrapper.h"
#include "kxyselector_wrapper.h"
#include "ktimecombobox_wrapper.h"

// Argument includes
#include <kmultitabbar.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qevent.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpoint.h>
#include <qsize.h>
#include <qstyleoption.h>
#include <qvariant.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KMultiTabBarTab_Type = nullptr;
static PyTypeObject *Sbk_KMultiTabBarTab_TypeF(void)
{
    return _Sbk_KMultiTabBarTab_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KMultiTabBarTabWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

void KMultiTabBarTabWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    KXYSelectorWrapper::sbk_o_actionEvent("KMultiTabBarTab", funcName, gil, pyOverride, event);
}

void KMultiTabBarTabWrapper::changeEvent(::QEvent * e)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractButton::changeEvent(e);
    }
    KXYSelectorWrapper::sbk_o_changeEvent("KMultiTabBarTab", funcName, gil, pyOverride, e);
}

void KMultiTabBarTabWrapper::checkStateSet()
{
    static const char *funcName = "checkStateSet";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractButton::checkStateSet();
    }
    KTimeComboBoxWrapper::sbk_o_hidePopup("KMultiTabBarTab", funcName, gil, pyOverride);
}

void KMultiTabBarTabWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KMultiTabBarTab", funcName, gil, pyOverride, event);
}

void KMultiTabBarTabWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_closeEvent("KMultiTabBarTab", funcName, gil, pyOverride, event);
}

void KMultiTabBarTabWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KMultiTabBarTab", funcName, gil, pyOverride, signal);
}

void KMultiTabBarTabWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::contextMenuEvent(event);
    }
    KXYSelectorWrapper::sbk_o_contextMenuEvent("KMultiTabBarTab", funcName, gil, pyOverride, event);
}

void KMultiTabBarTabWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KMultiTabBarTab", funcName, gil, pyOverride, event);
}

int KMultiTabBarTabWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return KXYSelectorWrapper::sbk_o_devType("KMultiTabBarTab", funcName, gil, pyOverride);
}

void KMultiTabBarTabWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KMultiTabBarTab", funcName, gil, pyOverride, signal);
}

void KMultiTabBarTabWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragEnterEvent("KMultiTabBarTab", funcName, gil, pyOverride, event);
}

void KMultiTabBarTabWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragLeaveEvent("KMultiTabBarTab", funcName, gil, pyOverride, event);
}

void KMultiTabBarTabWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragMoveEvent("KMultiTabBarTab", funcName, gil, pyOverride, event);
}

void KMultiTabBarTabWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dropEvent("KMultiTabBarTab", funcName, gil, pyOverride, event);
}

void KMultiTabBarTabWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_enterEvent("KMultiTabBarTab", funcName, gil, pyOverride, event);
}

bool KMultiTabBarTabWrapper::event(::QEvent * e)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QPushButton::event(e);
    }
    return KXYSelectorWrapper::sbk_o_event("KMultiTabBarTab", funcName, gil, pyOverride, e);
}

bool KMultiTabBarTabWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KMultiTabBarTab", funcName, gil, pyOverride, watched, event);
}

void KMultiTabBarTabWrapper::focusInEvent(::QFocusEvent * arg__1)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QPushButton::focusInEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_focusInEvent("KMultiTabBarTab", funcName, gil, pyOverride, arg__1);
}

bool KMultiTabBarTabWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return KXYSelectorWrapper::sbk_o_focusNextPrevChild("KMultiTabBarTab", funcName, gil, pyOverride, next);
}

void KMultiTabBarTabWrapper::focusOutEvent(::QFocusEvent * arg__1)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QPushButton::focusOutEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_focusOutEvent("KMultiTabBarTab", funcName, gil, pyOverride, arg__1);
}

bool KMultiTabBarTabWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return KXYSelectorWrapper::sbk_o_hasHeightForWidth("KMultiTabBarTab", funcName, gil, pyOverride);
}

int KMultiTabBarTabWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_heightForWidth("KMultiTabBarTab", funcName, gil, pyOverride, arg__1);
}

void KMultiTabBarTabWrapper::hideEvent(::QHideEvent * arg__1)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::KMultiTabBarButton::hideEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_hideEvent("KMultiTabBarTab", funcName, gil, pyOverride, arg__1);
}

bool KMultiTabBarTabWrapper::hitButton(const ::QPoint & pos) const
{
    static const char *funcName = "hitButton";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QPushButton::hitButton(pos);
    }
    return KSplitterCollapserButtonWrapper::sbk_o_hitButton("KMultiTabBarTab", funcName, gil, pyOverride, pos);
}

void KMultiTabBarTabWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    KXYSelectorWrapper::sbk_o_drawContents("KMultiTabBarTab", funcName, gil, pyOverride, painter);
}

void KMultiTabBarTabWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    KXYSelectorWrapper::sbk_o_inputMethodEvent("KMultiTabBarTab", funcName, gil, pyOverride, event);
}

::QVariant KMultiTabBarTabWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_inputMethodQuery("KMultiTabBarTab", funcName, gil, pyOverride, arg__1);
}

void KMultiTabBarTabWrapper::keyPressEvent(::QKeyEvent * arg__1)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QPushButton::keyPressEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_keyPressEvent("KMultiTabBarTab", funcName, gil, pyOverride, arg__1);
}

void KMultiTabBarTabWrapper::keyReleaseEvent(::QKeyEvent * e)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractButton::keyReleaseEvent(e);
    }
    KXYSelectorWrapper::sbk_o_keyReleaseEvent("KMultiTabBarTab", funcName, gil, pyOverride, e);
}

void KMultiTabBarTabWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_leaveEvent("KMultiTabBarTab", funcName, gil, pyOverride, event);
}

int KMultiTabBarTabWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_metric("KMultiTabBarTab", funcName, gil, pyOverride, arg__1);
}

::QSize KMultiTabBarTabWrapper::minimumSizeHint() const
{
    static const char *funcName = "minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::KMultiTabBarTab::minimumSizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KMultiTabBarTab", funcName, gil, pyOverride);
}

void KMultiTabBarTabWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseDoubleClickEvent("KMultiTabBarTab", funcName, gil, pyOverride, event);
}

void KMultiTabBarTabWrapper::mouseMoveEvent(::QMouseEvent * arg__1)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QPushButton::mouseMoveEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_mouseMoveEvent("KMultiTabBarTab", funcName, gil, pyOverride, arg__1);
}

void KMultiTabBarTabWrapper::mousePressEvent(::QMouseEvent * e)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractButton::mousePressEvent(e);
    }
    KXYSelectorWrapper::sbk_o_mousePressEvent("KMultiTabBarTab", funcName, gil, pyOverride, e);
}

void KMultiTabBarTabWrapper::mouseReleaseEvent(::QMouseEvent * e)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractButton::mouseReleaseEvent(e);
    }
    KXYSelectorWrapper::sbk_o_mouseReleaseEvent("KMultiTabBarTab", funcName, gil, pyOverride, e);
}

void KMultiTabBarTabWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_moveEvent("KMultiTabBarTab", funcName, gil, pyOverride, event);
}

bool KMultiTabBarTabWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return KXYSelectorWrapper::sbk_o_nativeEvent("KMultiTabBarTab", funcName, gil, pyOverride, eventType, message, result);
}

void KMultiTabBarTabWrapper::nextCheckState()
{
    static const char *funcName = "nextCheckState";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractButton::nextCheckState();
    }
    KTimeComboBoxWrapper::sbk_o_hidePopup("KMultiTabBarTab", funcName, gil, pyOverride);
}

::QPaintEngine * KMultiTabBarTabWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return KXYSelectorWrapper::sbk_o_paintEngine("KMultiTabBarTab", funcName, gil, pyOverride);
}

void KMultiTabBarTabWrapper::paintEvent(::QPaintEvent * arg__1)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::KMultiTabBarTab::paintEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_paintEvent("KMultiTabBarTab", funcName, gil, pyOverride, arg__1);
}

::QPaintDevice * KMultiTabBarTabWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return KXYSelectorWrapper::sbk_o_redirected("KMultiTabBarTab", funcName, gil, pyOverride, offset);
}

void KMultiTabBarTabWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::resizeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_resizeEvent("KMultiTabBarTab", funcName, gil, pyOverride, event);
}

void KMultiTabBarTabWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    KXYSelectorWrapper::sbk_o_setVisible("KMultiTabBarTab", funcName, gil, pyOverride, visible);
}

::QPainter * KMultiTabBarTabWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return KXYSelectorWrapper::sbk_o_sharedPainter("KMultiTabBarTab", funcName, gil, pyOverride);
}

void KMultiTabBarTabWrapper::showEvent(::QShowEvent * arg__1)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::KMultiTabBarButton::showEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_showEvent("KMultiTabBarTab", funcName, gil, pyOverride, arg__1);
}

::QSize KMultiTabBarTabWrapper::sizeHint() const
{
    static const char *funcName = "sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::KMultiTabBarTab::sizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KMultiTabBarTab", funcName, gil, pyOverride);
}

void KMultiTabBarTabWrapper::slotClicked()
{
    static const char *funcName = "slotClicked";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[47], nameCache));
    if (pyOverride.isNull()) {
        return this->::KMultiTabBarButton::slotClicked();
    }
    KTimeComboBoxWrapper::sbk_o_hidePopup("KMultiTabBarTab", funcName, gil, pyOverride);
}

void KMultiTabBarTabWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[48], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    KXYSelectorWrapper::sbk_o_tabletEvent("KMultiTabBarTab", funcName, gil, pyOverride, event);
}

void KMultiTabBarTabWrapper::timerEvent(::QTimerEvent * e)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[49], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractButton::timerEvent(e);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KMultiTabBarTab", funcName, gil, pyOverride, e);
}

void KMultiTabBarTabWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMultiTabBarTab_TypeF(), gil, funcName, m_PyMethodCache[50], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    KXYSelectorWrapper::sbk_o_wheelEvent("KMultiTabBarTab", funcName, gil, pyOverride, event);
}

const QMetaObject *KMultiTabBarTabWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KMultiTabBarTab::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KMultiTabBarTabWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KMultiTabBarTab::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KMultiTabBarTabWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KMultiTabBarTabWrapper *>(this));
    }
    return KMultiTabBarTab::qt_metacast(_clname);
}

KMultiTabBarTabWrapper::~KMultiTabBarTabWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KMultiTabBarTab_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int Sbk_KMultiTabBarTab_Init(PyObject *, PyObject *, PyObject *)
{
    Shiboken::Errors::setInstantiateNonConstructible("KMultiTabBarTab");
    return -1;
}

static PyObject *Sbk_KMultiTabBarTabFunc_minimumSizeHint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMultiTabBarTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBarTab_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // minimumSizeHint()const
        QSize cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? const_cast<const ::KMultiTabBarTab *>(cppSelf)->::KMultiTabBarTab::minimumSizeHint()
            : const_cast<const ::KMultiTabBarTab *>(cppSelf)->minimumSizeHint();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSize_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMultiTabBarTabFunc_paintEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMultiTabBarTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBarTab_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::paintEvent(QPaintEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintEvent_IDX]), (pyArg)))) {
        overloadId = 0; // paintEvent(QPaintEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "paintEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBarTab_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPaintEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // paintEvent(QPaintEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KMultiTabBarTab::paintEvent(cppArg0)
                : cppSelf->paintEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMultiTabBarTabFunc_setPosition(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMultiTabBarTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBarTab_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KMultiTabBarTab::setPosition(KMultiTabBar::KMultiTabBarPosition)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_KMultiTabBarPosition_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setPosition(KMultiTabBar::KMultiTabBarPosition)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setPosition", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBarTab_IDX]);

    // Call function/method
    {
        ::KMultiTabBar::KMultiTabBarPosition cppArg0{KMultiTabBar::Left};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setPosition(KMultiTabBar::KMultiTabBarPosition)
            cppSelf->setPosition(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMultiTabBarTabFunc_setState(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMultiTabBarTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBarTab_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KMultiTabBarTab::setState(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setState(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setState", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBarTab_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setState(bool)
            cppSelf->setState(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMultiTabBarTabFunc_setStyle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMultiTabBarTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBarTab_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KMultiTabBarTab::setStyle(KMultiTabBar::KMultiTabBarStyle)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_KMultiTabBarStyle_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setStyle(KMultiTabBar::KMultiTabBarStyle)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setStyle", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBarTab_IDX]);

    // Call function/method
    {
        ::KMultiTabBar::KMultiTabBarStyle cppArg0{KMultiTabBar::VSNET};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setStyle(KMultiTabBar::KMultiTabBarStyle)
            cppSelf->setStyle(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMultiTabBarTabFunc_sizeHint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMultiTabBarTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBarTab_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // sizeHint()const
        QSize cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? const_cast<const ::KMultiTabBarTab *>(cppSelf)->::KMultiTabBarTab::sizeHint()
            : const_cast<const ::KMultiTabBarTab *>(cppSelf)->sizeHint();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSize_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KMultiTabBarTab_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KMultiTabBarTab_methods[] = {
    {"minimumSizeHint", reinterpret_cast<PyCFunction>(Sbk_KMultiTabBarTabFunc_minimumSizeHint), METH_NOARGS, nullptr},
    {"paintEvent", reinterpret_cast<PyCFunction>(Sbk_KMultiTabBarTabFunc_paintEvent), METH_O, nullptr},
    {"setPosition", reinterpret_cast<PyCFunction>(Sbk_KMultiTabBarTabFunc_setPosition), METH_O, nullptr},
    {"setState", reinterpret_cast<PyCFunction>(Sbk_KMultiTabBarTabFunc_setState), METH_O, nullptr},
    {"setStyle", reinterpret_cast<PyCFunction>(Sbk_KMultiTabBarTabFunc_setStyle), METH_O, nullptr},
    {"sizeHint", reinterpret_cast<PyCFunction>(Sbk_KMultiTabBarTabFunc_sizeHint), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KMultiTabBarTab_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KMultiTabBarTab *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBarTab_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KMultiTabBarTabWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KMultiTabBarTab_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KMultiTabBarTab_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KMultiTabBarTabSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KMultiTabBarTab *>(obj);
    if (desiredType == Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBarButton_IDX]))
        return static_cast< ::KMultiTabBarButton *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QPushButton_IDX]))
        return static_cast< ::QPushButton *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QAbstractButton_IDX]))
        return static_cast< ::QAbstractButton *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KMultiTabBarTab_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KMultiTabBarTab_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KMultiTabBarTab_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KMultiTabBarTab_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KMultiTabBarTab_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KMultiTabBarTab_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkDummyNew /* PYSIDE-595: Prevent replacement of "0" with base->tp_new. */)},
    {0, nullptr}
};
static PyType_Spec Sbk_KMultiTabBarTab_spec = {
    "1:KWidgetsAddons.KMultiTabBarTab",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KMultiTabBarTab_slots
};

} //extern "C"

static void *Sbk_KMultiTabBarTab_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::KMultiTabBarTab *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KMultiTabBarTab *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::KMultiTabBarTab *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KMultiTabBarTab_PythonToCpp_KMultiTabBarTab_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KMultiTabBarTab_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KMultiTabBarTab_PythonToCpp_KMultiTabBarTab_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KMultiTabBarTab_TypeF()))
        return KMultiTabBarTab_PythonToCpp_KMultiTabBarTab_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KMultiTabBarTab_PTR_CppToPython_KMultiTabBarTab(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KMultiTabBarTab *>(const_cast<void *>(cppIn)), Sbk_KMultiTabBarTab_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KMultiTabBarTab_SignatureStrings[] = {
    "KWidgetsAddons.KMultiTabBarTab.minimumSizeHint(self)->PySide6.QtCore.QSize",
    "KWidgetsAddons.KMultiTabBarTab.paintEvent(self,arg__1:PySide6.QtGui.QPaintEvent)",
    "KWidgetsAddons.KMultiTabBarTab.setPosition(self,arg__1:KWidgetsAddons.KMultiTabBar.KMultiTabBarPosition)",
    "KWidgetsAddons.KMultiTabBarTab.setState(self,state:bool)",
    "KWidgetsAddons.KMultiTabBarTab.setStyle(self,arg__1:KWidgetsAddons.KMultiTabBar.KMultiTabBarStyle)",
    "KWidgetsAddons.KMultiTabBarTab.sizeHint(self)->PySide6.QtCore.QSize",
    nullptr}; // Sentinel
#else
static constexpr size_t KMultiTabBarTab_SignatureByteSize = 165;
static constexpr uint8_t KMultiTabBarTab_SignatureBytes[165] = {
    0x78, 0xda, 0xf3, 0x0e, 0xcf, 0x4c, 0x49, 0x4f, 0x2d, 0x29, 0x76, 0x4c, 0x49, 0xc9, 0xcf, 0x2b,
    0xd6, 0xf3, 0xf6, 0x2d, 0xcd, 0x29, 0xc9, 0x0c, 0x49, 0x4c, 0x72, 0x4a, 0x2c, 0x02, 0x92, 0x7a,
    0xb9, 0x99, 0x79, 0x99, 0xb9, 0xa5, 0xb9, 0xc1, 0x99, 0x55, 0xa9, 0x1e, 0x99, 0x79, 0x25, 0x1a,
    0xc5, 0xa9, 0x39, 0x69, 0x9a, 0xba, 0x76, 0x01, 0x95, 0xc1, 0x99, 0x29, 0xa9, 0x66, 0x7a, 0x81,
    0x25, 0xce, 0xf9, 0x45, 0xa9, 0x7a, 0x81, 0x20, 0x79, 0x2e, 0x6f, 0xfc, 0x46, 0x15, 0x24, 0x02,
    0x0d, 0x70, 0x2d, 0x4b, 0x85, 0x9a, 0xa2, 0x93, 0x58, 0x94, 0x1e, 0x1f, 0x6f, 0x68, 0x85, 0x30,
    0xca, 0xbd, 0x34, 0x53, 0x2f, 0x30, 0x00, 0xae, 0x4a, 0x93, 0x90, 0x81, 0xc5, 0xa9, 0x25, 0x01,
    0xf9, 0xc5, 0x99, 0x25, 0x99, 0xf9, 0x79, 0x28, 0x26, 0xe2, 0xd1, 0x86, 0xc2, 0x81, 0x69, 0x26,
    0xc6, 0xa2, 0xe0, 0x92, 0xc4, 0x92, 0x54, 0x88, 0x2d, 0xc5, 0x20, 0xa6, 0x55, 0x52, 0x7e, 0x7e,
    0x0e, 0x71, 0x1a, 0x2b, 0x73, 0x52, 0xc9, 0x72, 0x1e, 0x58, 0x27, 0x61, 0x2b, 0x88, 0x89, 0x19,
    0x00, 0x68, 0x63, 0xb0, 0xbf
};
#endif

PyTypeObject *init_KMultiTabBarTab(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBarTab_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBarTab_IDX].type;

    Shiboken::AutoDecRef Sbk_KMultiTabBarTab_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBarButton_IDX]))));

    _Sbk_KMultiTabBarTab_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KMultiTabBarTab",
        "KMultiTabBarTab*",
        &Sbk_KMultiTabBarTab_spec,
        &Shiboken::callCppDestructor< KMultiTabBarTab >,
        Sbk_KMultiTabBarTab_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = _Sbk_KMultiTabBarTab_Type; // references _Sbk_KMultiTabBarTab_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KMultiTabBarTab_SignatureStrings);
#else
    InitSignatureBytes(pyType, KMultiTabBarTab_SignatureBytes, KMultiTabBarTab_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KMultiTabBarTab_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBarTab_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KMultiTabBarTab_PythonToCpp_KMultiTabBarTab_PTR,
        is_KMultiTabBarTab_PythonToCpp_KMultiTabBarTab_PTR_Convertible,
        KMultiTabBarTab_PTR_CppToPython_KMultiTabBarTab);

    Shiboken::Conversions::registerConverterName(converter, "KMultiTabBarTab");
    Shiboken::Conversions::registerConverterName(converter, "KMultiTabBarTab*");
    Shiboken::Conversions::registerConverterName(converter, "KMultiTabBarTab&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KMultiTabBarTab).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KMultiTabBarTabWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KMultiTabBarTab_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KMultiTabBarTab_TypeF(), &Sbk_KMultiTabBarTabSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KMultiTabBarTab_TypeF(), &Sbk_KMultiTabBarTab_typeDiscovery);

    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KMultiTabBarTab::staticMetaObject, sizeof(KMultiTabBarTabWrapper));

    return pyType;
}
