
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "ktogglefullscreenaction_wrapper.h"

// Wrappers providing overrides
#include "kxyselector_wrapper.h"

// Argument includes
#include <qcoreevent.h>
#include <qmetaobject.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qwidget.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KToggleFullScreenAction_Type = nullptr;
static PyTypeObject *Sbk_KToggleFullScreenAction_TypeF(void)
{
    return _Sbk_KToggleFullScreenAction_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KToggleFullScreenActionWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KToggleFullScreenActionWrapper::KToggleFullScreenActionWrapper(::QObject * parent) : KToggleFullScreenAction(parent)
{
}

KToggleFullScreenActionWrapper::KToggleFullScreenActionWrapper(::QWidget * window, ::QObject * parent) : KToggleFullScreenAction(window, parent)
{
}

void KToggleFullScreenActionWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToggleFullScreenAction_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KToggleFullScreenAction", funcName, gil, pyOverride, event);
}

void KToggleFullScreenActionWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToggleFullScreenAction_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KToggleFullScreenAction", funcName, gil, pyOverride, signal);
}

void KToggleFullScreenActionWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToggleFullScreenAction_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KToggleFullScreenAction", funcName, gil, pyOverride, event);
}

void KToggleFullScreenActionWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToggleFullScreenAction_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KToggleFullScreenAction", funcName, gil, pyOverride, signal);
}

bool KToggleFullScreenActionWrapper::event(::QEvent * arg__1)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToggleFullScreenAction_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAction::event(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_event("KToggleFullScreenAction", funcName, gil, pyOverride, arg__1);
}

bool KToggleFullScreenActionWrapper::eventFilter(::QObject * object, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToggleFullScreenAction_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::KToggleFullScreenAction::eventFilter(object, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KToggleFullScreenAction", funcName, gil, pyOverride, object, event);
}

void KToggleFullScreenActionWrapper::slotToggled(bool checked)
{
    static const char *funcName = "slotToggled";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToggleFullScreenAction_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::KToggleFullScreenAction::slotToggled(checked);
    }
    KXYSelectorWrapper::sbk_o_setVisible("KToggleFullScreenAction", funcName, gil, pyOverride, checked);
}

void KToggleFullScreenActionWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToggleFullScreenAction_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KToggleFullScreenAction", funcName, gil, pyOverride, event);
}

const QMetaObject *KToggleFullScreenActionWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KToggleFullScreenAction::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KToggleFullScreenActionWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KToggleFullScreenAction::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KToggleFullScreenActionWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KToggleFullScreenActionWrapper *>(this));
    }
    return KToggleFullScreenAction::qt_metacast(_clname);
}

KToggleFullScreenActionWrapper::~KToggleFullScreenActionWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KToggleFullScreenAction_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KToggleFullScreenAction_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KToggleFullScreenAction >()))
        return -1;

    KToggleFullScreenActionWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "KToggleFullScreenAction", 1, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KToggleFullScreenAction::KToggleFullScreenAction(QObject*)
    // 1: KToggleFullScreenAction::KToggleFullScreenAction(QWidget*,QObject*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1])))) {
        overloadId = 1; // KToggleFullScreenAction(QWidget*,QObject*)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KToggleFullScreenAction(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KToggleFullScreenAction_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KToggleFullScreenAction_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KToggleFullScreenAction(QObject *parent)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KToggleFullScreenAction(QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KToggleFullScreenActionWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KToggleFullScreenActionWrapper(cppArg0);
                }

            }
            break;
        }
        case 1: // KToggleFullScreenAction(QWidget *window, QObject *parent)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QWidget *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QObject *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KToggleFullScreenAction(QWidget*,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KToggleFullScreenActionWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KToggleFullScreenActionWrapper(cppArg0, cppArg1);
                }

            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KToggleFullScreenAction >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KToggleFullScreenAction_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KToggleFullScreenAction_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KToggleFullScreenActionFunc_eventFilter(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KToggleFullScreenAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KToggleFullScreenAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "eventFilter", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QObject::eventFilter(QObject*,QEvent*)->bool
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), (pyArgs[1])))) {
        overloadId = 0; // eventFilter(QObject*,QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "eventFilter", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KToggleFullScreenAction_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QEvent *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // eventFilter(QObject*,QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KToggleFullScreenAction::eventFilter(cppArg0, cppArg1)
                : cppSelf->eventFilter(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KToggleFullScreenActionFunc_setFullScreen(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setFullScreen", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KToggleFullScreenAction::setFullScreen(QWidget*,bool)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
        overloadId = 0; // setFullScreen(QWidget*,bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setFullScreen", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KToggleFullScreenAction_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setFullScreen(QWidget*,bool)
            ::KToggleFullScreenAction::setFullScreen(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KToggleFullScreenActionFunc_setWindow(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KToggleFullScreenAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KToggleFullScreenAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KToggleFullScreenAction::setWindow(QWidget*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArg)))) {
        overloadId = 0; // setWindow(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setWindow", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KToggleFullScreenAction_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setWindow(QWidget*)
            cppSelf->setWindow(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KToggleFullScreenActionFunc_slotToggled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KToggleFullScreenAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KToggleFullScreenAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KToggleAction::slotToggled(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // slotToggled(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "slotToggled", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KToggleFullScreenAction_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // slotToggled(bool)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KToggleFullScreenAction::slotToggled(cppArg0)
                : cppSelf->slotToggled(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KToggleFullScreenAction_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KToggleFullScreenAction_methods[] = {
    {"eventFilter", reinterpret_cast<PyCFunction>(Sbk_KToggleFullScreenActionFunc_eventFilter), METH_VARARGS, nullptr},
    {"setFullScreen", reinterpret_cast<PyCFunction>(Sbk_KToggleFullScreenActionFunc_setFullScreen), METH_VARARGS|METH_STATIC, nullptr},
    {"setWindow", reinterpret_cast<PyCFunction>(Sbk_KToggleFullScreenActionFunc_setWindow), METH_O, nullptr},
    {"slotToggled", reinterpret_cast<PyCFunction>(Sbk_KToggleFullScreenActionFunc_slotToggled), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KToggleFullScreenAction_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KToggleFullScreenAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KToggleFullScreenAction_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KToggleFullScreenActionWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KToggleFullScreenAction_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KToggleFullScreenAction_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KToggleFullScreenAction_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KToggleFullScreenAction_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KToggleFullScreenAction_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KToggleFullScreenAction_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KToggleFullScreenAction_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KToggleFullScreenAction_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KToggleFullScreenAction_spec = {
    "1:KWidgetsAddons.KToggleFullScreenAction",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KToggleFullScreenAction_slots
};

} //extern "C"

static void *Sbk_KToggleFullScreenAction_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KToggleFullScreenAction *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KToggleFullScreenAction_PythonToCpp_KToggleFullScreenAction_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KToggleFullScreenAction_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KToggleFullScreenAction_PythonToCpp_KToggleFullScreenAction_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KToggleFullScreenAction_TypeF()))
        return KToggleFullScreenAction_PythonToCpp_KToggleFullScreenAction_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KToggleFullScreenAction_PTR_CppToPython_KToggleFullScreenAction(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KToggleFullScreenAction *>(const_cast<void *>(cppIn)), Sbk_KToggleFullScreenAction_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KToggleFullScreenAction_SignatureStrings[] = {
    "1:KWidgetsAddons.KToggleFullScreenAction(self,parent:PySide6.QtCore.QObject)",
    "0:KWidgetsAddons.KToggleFullScreenAction(self,window:PySide6.QtWidgets.QWidget,parent:PySide6.QtCore.QObject)",
    "KWidgetsAddons.KToggleFullScreenAction.eventFilter(self,object:PySide6.QtCore.QObject,event:PySide6.QtCore.QEvent)->bool",
    "KWidgetsAddons.KToggleFullScreenAction.setFullScreen(window:PySide6.QtWidgets.QWidget,set:bool)",
    "KWidgetsAddons.KToggleFullScreenAction.setWindow(self,window:PySide6.QtWidgets.QWidget)",
    "KWidgetsAddons.KToggleFullScreenAction.slotToggled(self,checked:bool)",
    nullptr}; // Sentinel
#else
static constexpr size_t KToggleFullScreenAction_SignatureByteSize = 180;
static constexpr uint8_t KToggleFullScreenAction_SignatureBytes[180] = {
    0x78, 0xda, 0x95, 0xd0, 0xcf, 0x0b, 0x82, 0x30, 0x14, 0x07, 0xf0, 0x7b, 0x7f, 0x89, 0x82, 0x8d,
    0xba, 0x74, 0xf0, 0x10, 0x48, 0xe4, 0xc5, 0x43, 0x89, 0x81, 0xe7, 0xdc, 0x5e, 0x36, 0x1b, 0x7b,
    0xb1, 0xbd, 0x92, 0xfe, 0xfb, 0xd4, 0x09, 0x05, 0x11, 0xce, 0xdb, 0x78, 0x3f, 0x3e, 0xdf, 0x6d,
    0xeb, 0x38, 0x2b, 0xa5, 0xa8, 0x81, 0x6c, 0x22, 0x04, 0x6a, 0xcb, 0xb2, 0x13, 0xd6, 0xb5, 0x82,
    0xf4, 0xa1, 0x54, 0xc1, 0x0d, 0x80, 0x4e, 0x38, 0x49, 0xd4, 0x81, 0x05, 0x75, 0x89, 0xee, 0x67,
    0x03, 0x9a, 0xe2, 0xe3, 0xab, 0x90, 0x02, 0x36, 0x2c, 0xa7, 0x1d, 0x1a, 0x60, 0xf9, 0xa1, 0x6a,
    0x80, 0x53, 0xb8, 0x58, 0xcd, 0xc2, 0x5a, 0xa9, 0x05, 0xb6, 0x5f, 0xd8, 0xb8, 0xcb, 0x72, 0x77,
    0x98, 0x4a, 0xf3, 0xcb, 0x62, 0xf0, 0xec, 0x90, 0x54, 0x2a, 0x02, 0xe3, 0x72, 0x71, 0xd8, 0xff,
    0xc3, 0x46, 0xc3, 0xf8, 0x4f, 0x73, 0xdf, 0x57, 0xc3, 0xe5, 0xb6, 0x42, 0x54, 0xbe, 0xc1, 0x16,
    0xe8, 0x53, 0x0b, 0x26, 0x5f, 0xdb, 0x8d, 0xc7, 0x3d, 0x1f, 0xce, 0xf0, 0xcb, 0x01, 0xf5, 0xfb,
    0x4e, 0x7f, 0x57, 0x21, 0xb9, 0x96, 0x70, 0x32, 0xbf, 0x02, 0xbf, 0x81, 0x18, 0x6f, 0xf7, 0x06,
    0xda, 0x19, 0xce, 0xf6
};
#endif

PyTypeObject *init_KToggleFullScreenAction(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KToggleFullScreenAction_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KToggleFullScreenAction_IDX].type;

    Shiboken::AutoDecRef Sbk_KToggleFullScreenAction_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KToggleAction_IDX]))));

    _Sbk_KToggleFullScreenAction_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KToggleFullScreenAction",
        "KToggleFullScreenAction*",
        &Sbk_KToggleFullScreenAction_spec,
        &Shiboken::callCppDestructor< KToggleFullScreenAction >,
        Sbk_KToggleFullScreenAction_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KToggleFullScreenAction_Type; // references _Sbk_KToggleFullScreenAction_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KToggleFullScreenAction_SignatureStrings);
#else
    InitSignatureBytes(pyType, KToggleFullScreenAction_SignatureBytes, KToggleFullScreenAction_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KToggleFullScreenAction_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KToggleFullScreenAction_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KToggleFullScreenAction_PythonToCpp_KToggleFullScreenAction_PTR,
        is_KToggleFullScreenAction_PythonToCpp_KToggleFullScreenAction_PTR_Convertible,
        KToggleFullScreenAction_PTR_CppToPython_KToggleFullScreenAction);

    Shiboken::Conversions::registerConverterName(converter, "KToggleFullScreenAction");
    Shiboken::Conversions::registerConverterName(converter, "KToggleFullScreenAction*");
    Shiboken::Conversions::registerConverterName(converter, "KToggleFullScreenAction&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KToggleFullScreenAction).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KToggleFullScreenActionWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KToggleFullScreenAction_TypeF(), &Sbk_KToggleFullScreenAction_typeDiscovery);

    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KToggleFullScreenAction::staticMetaObject, sizeof(KToggleFullScreenActionWrapper));

    return pyType;
}
