{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Displays a popup when clicked.
-- 
-- \<picture>
--   \<source srcset=\"menu-button-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkMenuButton\" src=\"menu-button.png\">
-- \<\/picture>
-- 
-- This popup can be provided either as a @GtkPopover@ or as an abstract
-- @GMenuModel@.
-- 
-- The @GtkMenuButton@ widget can show either an icon (set with the
-- [MenuButton:iconName]("GI.Gtk.Objects.MenuButton#g:attr:iconName") property) or a label (set with the
-- [MenuButton:label]("GI.Gtk.Objects.MenuButton#g:attr:label") property). If neither is explicitly set,
-- a t'GI.Gtk.Objects.Image.Image' is automatically created, using an arrow image oriented
-- according to [MenuButton:direction]("GI.Gtk.Objects.MenuButton#g:attr:direction") or the generic
-- “open-menu-symbolic” icon if the direction is not set.
-- 
-- The positioning of the popup is determined by the
-- [MenuButton:direction]("GI.Gtk.Objects.MenuButton#g:attr:direction") property of the menu button.
-- 
-- For menus, the [Widget:halign]("GI.Gtk.Objects.Widget#g:attr:halign") and [Widget:valign]("GI.Gtk.Objects.Widget#g:attr:valign")
-- properties of the menu are also taken into account. For example, when the
-- direction is 'GI.Gtk.Enums.ArrowTypeDown' and the horizontal alignment is 'GI.Gtk.Enums.AlignStart',
-- the menu will be positioned below the button, with the starting edge
-- (depending on the text direction) of the menu aligned with the starting
-- edge of the button. If there is not enough space below the button, the
-- menu is popped up above the button instead. If the alignment would move
-- part of the menu offscreen, it is “pushed in”.
-- 
-- |           | start                | center                | end                |
-- | -         | ---                  | ---                   | ---                |
-- | __down__  | <<https://docs.gtk.org/gtk4/down-start.png>>  | <<https://docs.gtk.org/gtk4/down-center.png>>  | <<https://docs.gtk.org/gtk4/down-end.png>>  |
-- | __up__    | <<https://docs.gtk.org/gtk4/up-start.png>>    | <<https://docs.gtk.org/gtk4/up-center.png>>    | <<https://docs.gtk.org/gtk4/up-end.png>>    |
-- | __left__  | <<https://docs.gtk.org/gtk4/left-start.png>>  | <<https://docs.gtk.org/gtk4/left-center.png>>  | <<https://docs.gtk.org/gtk4/left-end.png>>  |
-- | __right__ | <<https://docs.gtk.org/gtk4/right-start.png>> | <<https://docs.gtk.org/gtk4/right-center.png>> | <<https://docs.gtk.org/gtk4/right-end.png>> |
-- 
-- = CSS nodes
-- 
-- 
-- 	
-- >menubutton
-- >╰── button.toggle
-- >    ╰── <content>
-- >         ╰── [arrow]
-- 
-- 
-- @GtkMenuButton@ has a single CSS node with name @menubutton@
-- which contains a @button@ node with a @.toggle@ style class.
-- 
-- If the button contains an icon, it will have the @.image-button@ style class,
-- if it contains text, it will have @.text-button@ style class. If an arrow is
-- visible in addition to an icon, text or a custom child, it will also have
-- @.arrow-button@ style class.
-- 
-- Inside the toggle button content, there is an @arrow@ node for
-- the indicator, which will carry one of the @.none@, @.up@, @.down@,
-- @.left@ or @.right@ style classes to indicate the direction that
-- the menu will appear in. The CSS is expected to provide a suitable
-- image for each of these cases using the @-gtk-icon-source@ property.
-- 
-- Optionally, the @menubutton@ node can carry the @.circular@ style class
-- to request a round appearance.
-- 
-- = Accessibility
-- 
-- @GtkMenuButton@ uses the 'GI.Gtk.Enums.AccessibleRoleButton' role.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.MenuButton
    ( 

-- * Exported types
    MenuButton(..)                          ,
    IsMenuButton                            ,
    toMenuButton                            ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [popdown]("GI.Gtk.Objects.MenuButton#g:method:popdown"), [popup]("GI.Gtk.Objects.MenuButton#g:method:popup"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getActive]("GI.Gtk.Objects.MenuButton#g:method:getActive"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAlwaysShowArrow]("GI.Gtk.Objects.MenuButton#g:method:getAlwaysShowArrow"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanShrink]("GI.Gtk.Objects.MenuButton#g:method:getCanShrink"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChild]("GI.Gtk.Objects.MenuButton#g:method:getChild"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.MenuButton#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasFrame]("GI.Gtk.Objects.MenuButton#g:method:getHasFrame"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getIconName]("GI.Gtk.Objects.MenuButton#g:method:getIconName"), [getLabel]("GI.Gtk.Objects.MenuButton#g:method:getLabel"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getMenuModel]("GI.Gtk.Objects.MenuButton#g:method:getMenuModel"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPopover]("GI.Gtk.Objects.MenuButton#g:method:getPopover"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimary]("GI.Gtk.Objects.MenuButton#g:method:getPrimary"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getUseUnderline]("GI.Gtk.Objects.MenuButton#g:method:getUseUnderline"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setActive]("GI.Gtk.Objects.MenuButton#g:method:setActive"), [setAlwaysShowArrow]("GI.Gtk.Objects.MenuButton#g:method:setAlwaysShowArrow"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanShrink]("GI.Gtk.Objects.MenuButton#g:method:setCanShrink"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChild]("GI.Gtk.Objects.MenuButton#g:method:setChild"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCreatePopupFunc]("GI.Gtk.Objects.MenuButton#g:method:setCreatePopupFunc"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.MenuButton#g:method:setDirection"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasFrame]("GI.Gtk.Objects.MenuButton#g:method:setHasFrame"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setIconName]("GI.Gtk.Objects.MenuButton#g:method:setIconName"), [setLabel]("GI.Gtk.Objects.MenuButton#g:method:setLabel"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setMenuModel]("GI.Gtk.Objects.MenuButton#g:method:setMenuModel"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setPopover]("GI.Gtk.Objects.MenuButton#g:method:setPopover"), [setPrimary]("GI.Gtk.Objects.MenuButton#g:method:setPrimary"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setUseUnderline]("GI.Gtk.Objects.MenuButton#g:method:setUseUnderline"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveMenuButtonMethod                 ,
#endif

-- ** getActive #method:getActive#

#if defined(ENABLE_OVERLOADING)
    MenuButtonGetActiveMethodInfo           ,
#endif
    menuButtonGetActive                     ,


-- ** getAlwaysShowArrow #method:getAlwaysShowArrow#

#if defined(ENABLE_OVERLOADING)
    MenuButtonGetAlwaysShowArrowMethodInfo  ,
#endif
    menuButtonGetAlwaysShowArrow            ,


-- ** getCanShrink #method:getCanShrink#

#if defined(ENABLE_OVERLOADING)
    MenuButtonGetCanShrinkMethodInfo        ,
#endif
    menuButtonGetCanShrink                  ,


-- ** getChild #method:getChild#

#if defined(ENABLE_OVERLOADING)
    MenuButtonGetChildMethodInfo            ,
#endif
    menuButtonGetChild                      ,


-- ** getDirection #method:getDirection#

#if defined(ENABLE_OVERLOADING)
    MenuButtonGetDirectionMethodInfo        ,
#endif
    menuButtonGetDirection                  ,


-- ** getHasFrame #method:getHasFrame#

#if defined(ENABLE_OVERLOADING)
    MenuButtonGetHasFrameMethodInfo         ,
#endif
    menuButtonGetHasFrame                   ,


-- ** getIconName #method:getIconName#

#if defined(ENABLE_OVERLOADING)
    MenuButtonGetIconNameMethodInfo         ,
#endif
    menuButtonGetIconName                   ,


-- ** getLabel #method:getLabel#

#if defined(ENABLE_OVERLOADING)
    MenuButtonGetLabelMethodInfo            ,
#endif
    menuButtonGetLabel                      ,


-- ** getMenuModel #method:getMenuModel#

#if defined(ENABLE_OVERLOADING)
    MenuButtonGetMenuModelMethodInfo        ,
#endif
    menuButtonGetMenuModel                  ,


-- ** getPopover #method:getPopover#

#if defined(ENABLE_OVERLOADING)
    MenuButtonGetPopoverMethodInfo          ,
#endif
    menuButtonGetPopover                    ,


-- ** getPrimary #method:getPrimary#

#if defined(ENABLE_OVERLOADING)
    MenuButtonGetPrimaryMethodInfo          ,
#endif
    menuButtonGetPrimary                    ,


-- ** getUseUnderline #method:getUseUnderline#

#if defined(ENABLE_OVERLOADING)
    MenuButtonGetUseUnderlineMethodInfo     ,
#endif
    menuButtonGetUseUnderline               ,


-- ** new #method:new#

    menuButtonNew                           ,


-- ** popdown #method:popdown#

#if defined(ENABLE_OVERLOADING)
    MenuButtonPopdownMethodInfo             ,
#endif
    menuButtonPopdown                       ,


-- ** popup #method:popup#

#if defined(ENABLE_OVERLOADING)
    MenuButtonPopupMethodInfo               ,
#endif
    menuButtonPopup                         ,


-- ** setActive #method:setActive#

#if defined(ENABLE_OVERLOADING)
    MenuButtonSetActiveMethodInfo           ,
#endif
    menuButtonSetActive                     ,


-- ** setAlwaysShowArrow #method:setAlwaysShowArrow#

#if defined(ENABLE_OVERLOADING)
    MenuButtonSetAlwaysShowArrowMethodInfo  ,
#endif
    menuButtonSetAlwaysShowArrow            ,


-- ** setCanShrink #method:setCanShrink#

#if defined(ENABLE_OVERLOADING)
    MenuButtonSetCanShrinkMethodInfo        ,
#endif
    menuButtonSetCanShrink                  ,


-- ** setChild #method:setChild#

#if defined(ENABLE_OVERLOADING)
    MenuButtonSetChildMethodInfo            ,
#endif
    menuButtonSetChild                      ,


-- ** setCreatePopupFunc #method:setCreatePopupFunc#

#if defined(ENABLE_OVERLOADING)
    MenuButtonSetCreatePopupFuncMethodInfo  ,
#endif
    menuButtonSetCreatePopupFunc            ,


-- ** setDirection #method:setDirection#

#if defined(ENABLE_OVERLOADING)
    MenuButtonSetDirectionMethodInfo        ,
#endif
    menuButtonSetDirection                  ,


-- ** setHasFrame #method:setHasFrame#

#if defined(ENABLE_OVERLOADING)
    MenuButtonSetHasFrameMethodInfo         ,
#endif
    menuButtonSetHasFrame                   ,


-- ** setIconName #method:setIconName#

#if defined(ENABLE_OVERLOADING)
    MenuButtonSetIconNameMethodInfo         ,
#endif
    menuButtonSetIconName                   ,


-- ** setLabel #method:setLabel#

#if defined(ENABLE_OVERLOADING)
    MenuButtonSetLabelMethodInfo            ,
#endif
    menuButtonSetLabel                      ,


-- ** setMenuModel #method:setMenuModel#

#if defined(ENABLE_OVERLOADING)
    MenuButtonSetMenuModelMethodInfo        ,
#endif
    menuButtonSetMenuModel                  ,


-- ** setPopover #method:setPopover#

#if defined(ENABLE_OVERLOADING)
    MenuButtonSetPopoverMethodInfo          ,
#endif
    menuButtonSetPopover                    ,


-- ** setPrimary #method:setPrimary#

#if defined(ENABLE_OVERLOADING)
    MenuButtonSetPrimaryMethodInfo          ,
#endif
    menuButtonSetPrimary                    ,


-- ** setUseUnderline #method:setUseUnderline#

#if defined(ENABLE_OVERLOADING)
    MenuButtonSetUseUnderlineMethodInfo     ,
#endif
    menuButtonSetUseUnderline               ,




 -- * Properties


-- ** active #attr:active#
-- | Whether the menu button is active.
-- 
-- /Since: 4.10/

#if defined(ENABLE_OVERLOADING)
    MenuButtonActivePropertyInfo            ,
#endif
    constructMenuButtonActive               ,
    getMenuButtonActive                     ,
#if defined(ENABLE_OVERLOADING)
    menuButtonActive                        ,
#endif
    setMenuButtonActive                     ,


-- ** alwaysShowArrow #attr:alwaysShowArrow#
-- | Whether to show a dropdown arrow even when using an icon or a custom child.
-- 
-- /Since: 4.4/

#if defined(ENABLE_OVERLOADING)
    MenuButtonAlwaysShowArrowPropertyInfo   ,
#endif
    constructMenuButtonAlwaysShowArrow      ,
    getMenuButtonAlwaysShowArrow            ,
#if defined(ENABLE_OVERLOADING)
    menuButtonAlwaysShowArrow               ,
#endif
    setMenuButtonAlwaysShowArrow            ,


-- ** canShrink #attr:canShrink#
-- | Whether the size of the button can be made smaller than the natural
-- size of its contents.
-- 
-- /Since: 4.12/

#if defined(ENABLE_OVERLOADING)
    MenuButtonCanShrinkPropertyInfo         ,
#endif
    constructMenuButtonCanShrink            ,
    getMenuButtonCanShrink                  ,
#if defined(ENABLE_OVERLOADING)
    menuButtonCanShrink                     ,
#endif
    setMenuButtonCanShrink                  ,


-- ** child #attr:child#
-- | The child widget.
-- 
-- /Since: 4.6/

#if defined(ENABLE_OVERLOADING)
    MenuButtonChildPropertyInfo             ,
#endif
    clearMenuButtonChild                    ,
    constructMenuButtonChild                ,
    getMenuButtonChild                      ,
#if defined(ENABLE_OVERLOADING)
    menuButtonChild                         ,
#endif
    setMenuButtonChild                      ,


-- ** direction #attr:direction#
-- | The @GtkArrowType@ representing the direction in which the
-- menu or popover will be popped out.

#if defined(ENABLE_OVERLOADING)
    MenuButtonDirectionPropertyInfo         ,
#endif
    constructMenuButtonDirection            ,
    getMenuButtonDirection                  ,
#if defined(ENABLE_OVERLOADING)
    menuButtonDirection                     ,
#endif
    setMenuButtonDirection                  ,


-- ** hasFrame #attr:hasFrame#
-- | Whether the button has a frame.

#if defined(ENABLE_OVERLOADING)
    MenuButtonHasFramePropertyInfo          ,
#endif
    constructMenuButtonHasFrame             ,
    getMenuButtonHasFrame                   ,
#if defined(ENABLE_OVERLOADING)
    menuButtonHasFrame                      ,
#endif
    setMenuButtonHasFrame                   ,


-- ** iconName #attr:iconName#
-- | The name of the icon used to automatically populate the button.

#if defined(ENABLE_OVERLOADING)
    MenuButtonIconNamePropertyInfo          ,
#endif
    constructMenuButtonIconName             ,
    getMenuButtonIconName                   ,
#if defined(ENABLE_OVERLOADING)
    menuButtonIconName                      ,
#endif
    setMenuButtonIconName                   ,


-- ** label #attr:label#
-- | The label for the button.

#if defined(ENABLE_OVERLOADING)
    MenuButtonLabelPropertyInfo             ,
#endif
    constructMenuButtonLabel                ,
    getMenuButtonLabel                      ,
#if defined(ENABLE_OVERLOADING)
    menuButtonLabel                         ,
#endif
    setMenuButtonLabel                      ,


-- ** menuModel #attr:menuModel#
-- | The @GMenuModel@ from which the popup will be created.
-- 
-- See 'GI.Gtk.Objects.MenuButton.menuButtonSetMenuModel' for the interaction
-- with the [MenuButton:popover]("GI.Gtk.Objects.MenuButton#g:attr:popover") property.

#if defined(ENABLE_OVERLOADING)
    MenuButtonMenuModelPropertyInfo         ,
#endif
    clearMenuButtonMenuModel                ,
    constructMenuButtonMenuModel            ,
    getMenuButtonMenuModel                  ,
#if defined(ENABLE_OVERLOADING)
    menuButtonMenuModel                     ,
#endif
    setMenuButtonMenuModel                  ,


-- ** popover #attr:popover#
-- | The @GtkPopover@ that will be popped up when the button is clicked.

#if defined(ENABLE_OVERLOADING)
    MenuButtonPopoverPropertyInfo           ,
#endif
    clearMenuButtonPopover                  ,
    constructMenuButtonPopover              ,
    getMenuButtonPopover                    ,
#if defined(ENABLE_OVERLOADING)
    menuButtonPopover                       ,
#endif
    setMenuButtonPopover                    ,


-- ** primary #attr:primary#
-- | Whether the menu button acts as a primary menu.
-- 
-- Primary menus can be opened using the \<kbd>F10\<\/kbd> key
-- 
-- /Since: 4.4/

#if defined(ENABLE_OVERLOADING)
    MenuButtonPrimaryPropertyInfo           ,
#endif
    constructMenuButtonPrimary              ,
    getMenuButtonPrimary                    ,
#if defined(ENABLE_OVERLOADING)
    menuButtonPrimary                       ,
#endif
    setMenuButtonPrimary                    ,


-- ** useUnderline #attr:useUnderline#
-- | If set an underscore in the text indicates a mnemonic.

#if defined(ENABLE_OVERLOADING)
    MenuButtonUseUnderlinePropertyInfo      ,
#endif
    constructMenuButtonUseUnderline         ,
    getMenuButtonUseUnderline               ,
#if defined(ENABLE_OVERLOADING)
    menuButtonUseUnderline                  ,
#endif
    setMenuButtonUseUnderline               ,




 -- * Signals


-- ** activate #signal:activate#

    MenuButtonActivateCallback              ,
#if defined(ENABLE_OVERLOADING)
    MenuButtonActivateSignalInfo            ,
#endif
    afterMenuButtonActivate                 ,
    onMenuButtonActivate                    ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Objects.MenuModel as Gio.MenuModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ShortcutManager as Gtk.ShortcutManager
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Popover as Gtk.Popover
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Objects.MenuModel as Gio.MenuModel
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Popover as Gtk.Popover
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype MenuButton = MenuButton (SP.ManagedPtr MenuButton)
    deriving (Eq)

instance SP.ManagedPtrNewtype MenuButton where
    toManagedPtr (MenuButton p) = p

foreign import ccall "gtk_menu_button_get_type"
    c_gtk_menu_button_get_type :: IO B.Types.GType

instance B.Types.TypedObject MenuButton where
    glibType = c_gtk_menu_button_get_type

instance B.Types.GObject MenuButton

-- | Type class for types which can be safely cast to t'MenuButton', for instance with `toMenuButton`.
class (SP.GObject o, O.IsDescendantOf MenuButton o) => IsMenuButton o
instance (SP.GObject o, O.IsDescendantOf MenuButton o) => IsMenuButton o

instance O.HasParentTypes MenuButton
type instance O.ParentTypes MenuButton = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget]

-- | Cast to t'MenuButton', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toMenuButton :: (MIO.MonadIO m, IsMenuButton o) => o -> m MenuButton
toMenuButton = MIO.liftIO . B.ManagedPtr.unsafeCastTo MenuButton

-- | Convert t'MenuButton' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe MenuButton) where
    gvalueGType_ = c_gtk_menu_button_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr MenuButton)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr MenuButton)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject MenuButton ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveMenuButtonMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveMenuButtonMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveMenuButtonMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveMenuButtonMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveMenuButtonMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveMenuButtonMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveMenuButtonMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveMenuButtonMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveMenuButtonMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveMenuButtonMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveMenuButtonMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveMenuButtonMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveMenuButtonMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveMenuButtonMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveMenuButtonMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveMenuButtonMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveMenuButtonMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveMenuButtonMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveMenuButtonMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveMenuButtonMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveMenuButtonMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveMenuButtonMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveMenuButtonMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveMenuButtonMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveMenuButtonMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveMenuButtonMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveMenuButtonMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveMenuButtonMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveMenuButtonMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveMenuButtonMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveMenuButtonMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveMenuButtonMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveMenuButtonMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveMenuButtonMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveMenuButtonMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveMenuButtonMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveMenuButtonMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveMenuButtonMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveMenuButtonMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveMenuButtonMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveMenuButtonMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveMenuButtonMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveMenuButtonMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveMenuButtonMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveMenuButtonMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveMenuButtonMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveMenuButtonMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveMenuButtonMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveMenuButtonMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveMenuButtonMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveMenuButtonMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveMenuButtonMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveMenuButtonMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveMenuButtonMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveMenuButtonMethod "popdown" o = MenuButtonPopdownMethodInfo
    ResolveMenuButtonMethod "popup" o = MenuButtonPopupMethodInfo
    ResolveMenuButtonMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveMenuButtonMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveMenuButtonMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveMenuButtonMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveMenuButtonMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveMenuButtonMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveMenuButtonMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveMenuButtonMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveMenuButtonMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveMenuButtonMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveMenuButtonMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveMenuButtonMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveMenuButtonMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveMenuButtonMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveMenuButtonMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveMenuButtonMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveMenuButtonMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveMenuButtonMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveMenuButtonMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveMenuButtonMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveMenuButtonMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveMenuButtonMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveMenuButtonMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveMenuButtonMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveMenuButtonMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveMenuButtonMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveMenuButtonMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveMenuButtonMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveMenuButtonMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveMenuButtonMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveMenuButtonMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveMenuButtonMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveMenuButtonMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveMenuButtonMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveMenuButtonMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveMenuButtonMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveMenuButtonMethod "getActive" o = MenuButtonGetActiveMethodInfo
    ResolveMenuButtonMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveMenuButtonMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveMenuButtonMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveMenuButtonMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveMenuButtonMethod "getAlwaysShowArrow" o = MenuButtonGetAlwaysShowArrowMethodInfo
    ResolveMenuButtonMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveMenuButtonMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveMenuButtonMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveMenuButtonMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveMenuButtonMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveMenuButtonMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveMenuButtonMethod "getCanShrink" o = MenuButtonGetCanShrinkMethodInfo
    ResolveMenuButtonMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveMenuButtonMethod "getChild" o = MenuButtonGetChildMethodInfo
    ResolveMenuButtonMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveMenuButtonMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveMenuButtonMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveMenuButtonMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveMenuButtonMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveMenuButtonMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveMenuButtonMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveMenuButtonMethod "getDirection" o = MenuButtonGetDirectionMethodInfo
    ResolveMenuButtonMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveMenuButtonMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveMenuButtonMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveMenuButtonMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveMenuButtonMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveMenuButtonMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveMenuButtonMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveMenuButtonMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveMenuButtonMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveMenuButtonMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveMenuButtonMethod "getHasFrame" o = MenuButtonGetHasFrameMethodInfo
    ResolveMenuButtonMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveMenuButtonMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveMenuButtonMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveMenuButtonMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveMenuButtonMethod "getIconName" o = MenuButtonGetIconNameMethodInfo
    ResolveMenuButtonMethod "getLabel" o = MenuButtonGetLabelMethodInfo
    ResolveMenuButtonMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveMenuButtonMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveMenuButtonMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveMenuButtonMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveMenuButtonMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveMenuButtonMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveMenuButtonMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveMenuButtonMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveMenuButtonMethod "getMenuModel" o = MenuButtonGetMenuModelMethodInfo
    ResolveMenuButtonMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveMenuButtonMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveMenuButtonMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveMenuButtonMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveMenuButtonMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveMenuButtonMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveMenuButtonMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveMenuButtonMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveMenuButtonMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveMenuButtonMethod "getPopover" o = MenuButtonGetPopoverMethodInfo
    ResolveMenuButtonMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveMenuButtonMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveMenuButtonMethod "getPrimary" o = MenuButtonGetPrimaryMethodInfo
    ResolveMenuButtonMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveMenuButtonMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveMenuButtonMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveMenuButtonMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveMenuButtonMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveMenuButtonMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveMenuButtonMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveMenuButtonMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveMenuButtonMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveMenuButtonMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveMenuButtonMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveMenuButtonMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveMenuButtonMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveMenuButtonMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveMenuButtonMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveMenuButtonMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveMenuButtonMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveMenuButtonMethod "getUseUnderline" o = MenuButtonGetUseUnderlineMethodInfo
    ResolveMenuButtonMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveMenuButtonMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveMenuButtonMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveMenuButtonMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveMenuButtonMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveMenuButtonMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveMenuButtonMethod "setActive" o = MenuButtonSetActiveMethodInfo
    ResolveMenuButtonMethod "setAlwaysShowArrow" o = MenuButtonSetAlwaysShowArrowMethodInfo
    ResolveMenuButtonMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveMenuButtonMethod "setCanShrink" o = MenuButtonSetCanShrinkMethodInfo
    ResolveMenuButtonMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveMenuButtonMethod "setChild" o = MenuButtonSetChildMethodInfo
    ResolveMenuButtonMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveMenuButtonMethod "setCreatePopupFunc" o = MenuButtonSetCreatePopupFuncMethodInfo
    ResolveMenuButtonMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveMenuButtonMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveMenuButtonMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveMenuButtonMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveMenuButtonMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveMenuButtonMethod "setDirection" o = MenuButtonSetDirectionMethodInfo
    ResolveMenuButtonMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveMenuButtonMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveMenuButtonMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveMenuButtonMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveMenuButtonMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveMenuButtonMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveMenuButtonMethod "setHasFrame" o = MenuButtonSetHasFrameMethodInfo
    ResolveMenuButtonMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveMenuButtonMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveMenuButtonMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveMenuButtonMethod "setIconName" o = MenuButtonSetIconNameMethodInfo
    ResolveMenuButtonMethod "setLabel" o = MenuButtonSetLabelMethodInfo
    ResolveMenuButtonMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveMenuButtonMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveMenuButtonMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveMenuButtonMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveMenuButtonMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveMenuButtonMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveMenuButtonMethod "setMenuModel" o = MenuButtonSetMenuModelMethodInfo
    ResolveMenuButtonMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveMenuButtonMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveMenuButtonMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveMenuButtonMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveMenuButtonMethod "setPopover" o = MenuButtonSetPopoverMethodInfo
    ResolveMenuButtonMethod "setPrimary" o = MenuButtonSetPrimaryMethodInfo
    ResolveMenuButtonMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveMenuButtonMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveMenuButtonMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveMenuButtonMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveMenuButtonMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveMenuButtonMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveMenuButtonMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveMenuButtonMethod "setUseUnderline" o = MenuButtonSetUseUnderlineMethodInfo
    ResolveMenuButtonMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveMenuButtonMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveMenuButtonMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveMenuButtonMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveMenuButtonMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveMenuButtonMethod t MenuButton, O.OverloadedMethod info MenuButton p) => OL.IsLabel t (MenuButton -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveMenuButtonMethod t MenuButton, O.OverloadedMethod info MenuButton p, R.HasField t MenuButton p) => R.HasField t MenuButton p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveMenuButtonMethod t MenuButton, O.OverloadedMethodInfo info MenuButton) => OL.IsLabel t (O.MethodProxy info MenuButton) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal MenuButton::activate
-- | Emitted to when the menu button is activated.
-- 
-- The @::activate@ signal on @GtkMenuButton@ is an action signal and
-- emitting it causes the button to pop up its menu.
-- 
-- /Since: 4.4/
type MenuButtonActivateCallback =
    IO ()

type C_MenuButtonActivateCallback =
    Ptr MenuButton ->                       -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_MenuButtonActivateCallback`.
foreign import ccall "wrapper"
    mk_MenuButtonActivateCallback :: C_MenuButtonActivateCallback -> IO (FunPtr C_MenuButtonActivateCallback)

wrap_MenuButtonActivateCallback :: 
    GObject a => (a -> MenuButtonActivateCallback) ->
    C_MenuButtonActivateCallback
wrap_MenuButtonActivateCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [activate](#signal:activate) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' menuButton #activate callback
-- @
-- 
-- 
onMenuButtonActivate :: (IsMenuButton a, MonadIO m) => a -> ((?self :: a) => MenuButtonActivateCallback) -> m SignalHandlerId
onMenuButtonActivate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_MenuButtonActivateCallback wrapped
    wrapped'' <- mk_MenuButtonActivateCallback wrapped'
    connectSignalFunPtr obj "activate" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [activate](#signal:activate) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' menuButton #activate callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterMenuButtonActivate :: (IsMenuButton a, MonadIO m) => a -> ((?self :: a) => MenuButtonActivateCallback) -> m SignalHandlerId
afterMenuButtonActivate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_MenuButtonActivateCallback wrapped
    wrapped'' <- mk_MenuButtonActivateCallback wrapped'
    connectSignalFunPtr obj "activate" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data MenuButtonActivateSignalInfo
instance SignalInfo MenuButtonActivateSignalInfo where
    type HaskellCallbackType MenuButtonActivateSignalInfo = MenuButtonActivateCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_MenuButtonActivateCallback cb
        cb'' <- mk_MenuButtonActivateCallback cb'
        connectSignalFunPtr obj "activate" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MenuButton::activate"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MenuButton.html#g:signal:activate"})

#endif

-- VVV Prop "active"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@active@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' menuButton #active
-- @
getMenuButtonActive :: (MonadIO m, IsMenuButton o) => o -> m Bool
getMenuButtonActive obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "active"

-- | Set the value of the “@active@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' menuButton [ #active 'Data.GI.Base.Attributes.:=' value ]
-- @
setMenuButtonActive :: (MonadIO m, IsMenuButton o) => o -> Bool -> m ()
setMenuButtonActive obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "active" val

-- | Construct a t'GValueConstruct' with valid value for the “@active@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMenuButtonActive :: (IsMenuButton o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructMenuButtonActive val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "active" val

#if defined(ENABLE_OVERLOADING)
data MenuButtonActivePropertyInfo
instance AttrInfo MenuButtonActivePropertyInfo where
    type AttrAllowedOps MenuButtonActivePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint MenuButtonActivePropertyInfo = IsMenuButton
    type AttrSetTypeConstraint MenuButtonActivePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint MenuButtonActivePropertyInfo = (~) Bool
    type AttrTransferType MenuButtonActivePropertyInfo = Bool
    type AttrGetType MenuButtonActivePropertyInfo = Bool
    type AttrLabel MenuButtonActivePropertyInfo = "active"
    type AttrOrigin MenuButtonActivePropertyInfo = MenuButton
    attrGet = getMenuButtonActive
    attrSet = setMenuButtonActive
    attrPut = setMenuButtonActive
    attrTransfer _ v = do
        return v
    attrConstruct = constructMenuButtonActive
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MenuButton.active"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MenuButton.html#g:attr:active"
        })
#endif

-- VVV Prop "always-show-arrow"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@always-show-arrow@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' menuButton #alwaysShowArrow
-- @
getMenuButtonAlwaysShowArrow :: (MonadIO m, IsMenuButton o) => o -> m Bool
getMenuButtonAlwaysShowArrow obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "always-show-arrow"

-- | Set the value of the “@always-show-arrow@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' menuButton [ #alwaysShowArrow 'Data.GI.Base.Attributes.:=' value ]
-- @
setMenuButtonAlwaysShowArrow :: (MonadIO m, IsMenuButton o) => o -> Bool -> m ()
setMenuButtonAlwaysShowArrow obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "always-show-arrow" val

-- | Construct a t'GValueConstruct' with valid value for the “@always-show-arrow@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMenuButtonAlwaysShowArrow :: (IsMenuButton o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructMenuButtonAlwaysShowArrow val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "always-show-arrow" val

#if defined(ENABLE_OVERLOADING)
data MenuButtonAlwaysShowArrowPropertyInfo
instance AttrInfo MenuButtonAlwaysShowArrowPropertyInfo where
    type AttrAllowedOps MenuButtonAlwaysShowArrowPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint MenuButtonAlwaysShowArrowPropertyInfo = IsMenuButton
    type AttrSetTypeConstraint MenuButtonAlwaysShowArrowPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint MenuButtonAlwaysShowArrowPropertyInfo = (~) Bool
    type AttrTransferType MenuButtonAlwaysShowArrowPropertyInfo = Bool
    type AttrGetType MenuButtonAlwaysShowArrowPropertyInfo = Bool
    type AttrLabel MenuButtonAlwaysShowArrowPropertyInfo = "always-show-arrow"
    type AttrOrigin MenuButtonAlwaysShowArrowPropertyInfo = MenuButton
    attrGet = getMenuButtonAlwaysShowArrow
    attrSet = setMenuButtonAlwaysShowArrow
    attrPut = setMenuButtonAlwaysShowArrow
    attrTransfer _ v = do
        return v
    attrConstruct = constructMenuButtonAlwaysShowArrow
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MenuButton.alwaysShowArrow"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MenuButton.html#g:attr:alwaysShowArrow"
        })
#endif

-- VVV Prop "can-shrink"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@can-shrink@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' menuButton #canShrink
-- @
getMenuButtonCanShrink :: (MonadIO m, IsMenuButton o) => o -> m Bool
getMenuButtonCanShrink obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "can-shrink"

-- | Set the value of the “@can-shrink@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' menuButton [ #canShrink 'Data.GI.Base.Attributes.:=' value ]
-- @
setMenuButtonCanShrink :: (MonadIO m, IsMenuButton o) => o -> Bool -> m ()
setMenuButtonCanShrink obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "can-shrink" val

-- | Construct a t'GValueConstruct' with valid value for the “@can-shrink@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMenuButtonCanShrink :: (IsMenuButton o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructMenuButtonCanShrink val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "can-shrink" val

#if defined(ENABLE_OVERLOADING)
data MenuButtonCanShrinkPropertyInfo
instance AttrInfo MenuButtonCanShrinkPropertyInfo where
    type AttrAllowedOps MenuButtonCanShrinkPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint MenuButtonCanShrinkPropertyInfo = IsMenuButton
    type AttrSetTypeConstraint MenuButtonCanShrinkPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint MenuButtonCanShrinkPropertyInfo = (~) Bool
    type AttrTransferType MenuButtonCanShrinkPropertyInfo = Bool
    type AttrGetType MenuButtonCanShrinkPropertyInfo = Bool
    type AttrLabel MenuButtonCanShrinkPropertyInfo = "can-shrink"
    type AttrOrigin MenuButtonCanShrinkPropertyInfo = MenuButton
    attrGet = getMenuButtonCanShrink
    attrSet = setMenuButtonCanShrink
    attrPut = setMenuButtonCanShrink
    attrTransfer _ v = do
        return v
    attrConstruct = constructMenuButtonCanShrink
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MenuButton.canShrink"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MenuButton.html#g:attr:canShrink"
        })
#endif

-- VVV Prop "child"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Widget"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' menuButton #child
-- @
getMenuButtonChild :: (MonadIO m, IsMenuButton o) => o -> m (Maybe Gtk.Widget.Widget)
getMenuButtonChild obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "child" Gtk.Widget.Widget

-- | Set the value of the “@child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' menuButton [ #child 'Data.GI.Base.Attributes.:=' value ]
-- @
setMenuButtonChild :: (MonadIO m, IsMenuButton o, Gtk.Widget.IsWidget a) => o -> a -> m ()
setMenuButtonChild obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "child" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@child@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMenuButtonChild :: (IsMenuButton o, MIO.MonadIO m, Gtk.Widget.IsWidget a) => a -> m (GValueConstruct o)
constructMenuButtonChild val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "child" (P.Just val)

-- | Set the value of the “@child@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #child
-- @
clearMenuButtonChild :: (MonadIO m, IsMenuButton o) => o -> m ()
clearMenuButtonChild obj = liftIO $ B.Properties.setObjectPropertyObject obj "child" (Nothing :: Maybe Gtk.Widget.Widget)

#if defined(ENABLE_OVERLOADING)
data MenuButtonChildPropertyInfo
instance AttrInfo MenuButtonChildPropertyInfo where
    type AttrAllowedOps MenuButtonChildPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint MenuButtonChildPropertyInfo = IsMenuButton
    type AttrSetTypeConstraint MenuButtonChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferTypeConstraint MenuButtonChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferType MenuButtonChildPropertyInfo = Gtk.Widget.Widget
    type AttrGetType MenuButtonChildPropertyInfo = (Maybe Gtk.Widget.Widget)
    type AttrLabel MenuButtonChildPropertyInfo = "child"
    type AttrOrigin MenuButtonChildPropertyInfo = MenuButton
    attrGet = getMenuButtonChild
    attrSet = setMenuButtonChild
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gtk.Widget.Widget v
    attrConstruct = constructMenuButtonChild
    attrClear = clearMenuButtonChild
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MenuButton.child"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MenuButton.html#g:attr:child"
        })
#endif

-- VVV Prop "direction"
   -- Type: TInterface (Name {namespace = "Gtk", name = "ArrowType"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@direction@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' menuButton #direction
-- @
getMenuButtonDirection :: (MonadIO m, IsMenuButton o) => o -> m Gtk.Enums.ArrowType
getMenuButtonDirection obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "direction"

-- | Set the value of the “@direction@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' menuButton [ #direction 'Data.GI.Base.Attributes.:=' value ]
-- @
setMenuButtonDirection :: (MonadIO m, IsMenuButton o) => o -> Gtk.Enums.ArrowType -> m ()
setMenuButtonDirection obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "direction" val

-- | Construct a t'GValueConstruct' with valid value for the “@direction@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMenuButtonDirection :: (IsMenuButton o, MIO.MonadIO m) => Gtk.Enums.ArrowType -> m (GValueConstruct o)
constructMenuButtonDirection val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "direction" val

#if defined(ENABLE_OVERLOADING)
data MenuButtonDirectionPropertyInfo
instance AttrInfo MenuButtonDirectionPropertyInfo where
    type AttrAllowedOps MenuButtonDirectionPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint MenuButtonDirectionPropertyInfo = IsMenuButton
    type AttrSetTypeConstraint MenuButtonDirectionPropertyInfo = (~) Gtk.Enums.ArrowType
    type AttrTransferTypeConstraint MenuButtonDirectionPropertyInfo = (~) Gtk.Enums.ArrowType
    type AttrTransferType MenuButtonDirectionPropertyInfo = Gtk.Enums.ArrowType
    type AttrGetType MenuButtonDirectionPropertyInfo = Gtk.Enums.ArrowType
    type AttrLabel MenuButtonDirectionPropertyInfo = "direction"
    type AttrOrigin MenuButtonDirectionPropertyInfo = MenuButton
    attrGet = getMenuButtonDirection
    attrSet = setMenuButtonDirection
    attrPut = setMenuButtonDirection
    attrTransfer _ v = do
        return v
    attrConstruct = constructMenuButtonDirection
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MenuButton.direction"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MenuButton.html#g:attr:direction"
        })
#endif

-- VVV Prop "has-frame"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@has-frame@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' menuButton #hasFrame
-- @
getMenuButtonHasFrame :: (MonadIO m, IsMenuButton o) => o -> m Bool
getMenuButtonHasFrame obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "has-frame"

-- | Set the value of the “@has-frame@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' menuButton [ #hasFrame 'Data.GI.Base.Attributes.:=' value ]
-- @
setMenuButtonHasFrame :: (MonadIO m, IsMenuButton o) => o -> Bool -> m ()
setMenuButtonHasFrame obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "has-frame" val

-- | Construct a t'GValueConstruct' with valid value for the “@has-frame@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMenuButtonHasFrame :: (IsMenuButton o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructMenuButtonHasFrame val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "has-frame" val

#if defined(ENABLE_OVERLOADING)
data MenuButtonHasFramePropertyInfo
instance AttrInfo MenuButtonHasFramePropertyInfo where
    type AttrAllowedOps MenuButtonHasFramePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint MenuButtonHasFramePropertyInfo = IsMenuButton
    type AttrSetTypeConstraint MenuButtonHasFramePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint MenuButtonHasFramePropertyInfo = (~) Bool
    type AttrTransferType MenuButtonHasFramePropertyInfo = Bool
    type AttrGetType MenuButtonHasFramePropertyInfo = Bool
    type AttrLabel MenuButtonHasFramePropertyInfo = "has-frame"
    type AttrOrigin MenuButtonHasFramePropertyInfo = MenuButton
    attrGet = getMenuButtonHasFrame
    attrSet = setMenuButtonHasFrame
    attrPut = setMenuButtonHasFrame
    attrTransfer _ v = do
        return v
    attrConstruct = constructMenuButtonHasFrame
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MenuButton.hasFrame"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MenuButton.html#g:attr:hasFrame"
        })
#endif

-- VVV Prop "icon-name"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just False)

-- | Get the value of the “@icon-name@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' menuButton #iconName
-- @
getMenuButtonIconName :: (MonadIO m, IsMenuButton o) => o -> m (Maybe T.Text)
getMenuButtonIconName obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "icon-name"

-- | Set the value of the “@icon-name@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' menuButton [ #iconName 'Data.GI.Base.Attributes.:=' value ]
-- @
setMenuButtonIconName :: (MonadIO m, IsMenuButton o) => o -> T.Text -> m ()
setMenuButtonIconName obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "icon-name" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@icon-name@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMenuButtonIconName :: (IsMenuButton o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructMenuButtonIconName val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "icon-name" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data MenuButtonIconNamePropertyInfo
instance AttrInfo MenuButtonIconNamePropertyInfo where
    type AttrAllowedOps MenuButtonIconNamePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint MenuButtonIconNamePropertyInfo = IsMenuButton
    type AttrSetTypeConstraint MenuButtonIconNamePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint MenuButtonIconNamePropertyInfo = (~) T.Text
    type AttrTransferType MenuButtonIconNamePropertyInfo = T.Text
    type AttrGetType MenuButtonIconNamePropertyInfo = (Maybe T.Text)
    type AttrLabel MenuButtonIconNamePropertyInfo = "icon-name"
    type AttrOrigin MenuButtonIconNamePropertyInfo = MenuButton
    attrGet = getMenuButtonIconName
    attrSet = setMenuButtonIconName
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructMenuButtonIconName
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MenuButton.iconName"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MenuButton.html#g:attr:iconName"
        })
#endif

-- VVV Prop "label"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just False)

-- | Get the value of the “@label@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' menuButton #label
-- @
getMenuButtonLabel :: (MonadIO m, IsMenuButton o) => o -> m (Maybe T.Text)
getMenuButtonLabel obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "label"

-- | Set the value of the “@label@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' menuButton [ #label 'Data.GI.Base.Attributes.:=' value ]
-- @
setMenuButtonLabel :: (MonadIO m, IsMenuButton o) => o -> T.Text -> m ()
setMenuButtonLabel obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "label" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@label@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMenuButtonLabel :: (IsMenuButton o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructMenuButtonLabel val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "label" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data MenuButtonLabelPropertyInfo
instance AttrInfo MenuButtonLabelPropertyInfo where
    type AttrAllowedOps MenuButtonLabelPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint MenuButtonLabelPropertyInfo = IsMenuButton
    type AttrSetTypeConstraint MenuButtonLabelPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint MenuButtonLabelPropertyInfo = (~) T.Text
    type AttrTransferType MenuButtonLabelPropertyInfo = T.Text
    type AttrGetType MenuButtonLabelPropertyInfo = (Maybe T.Text)
    type AttrLabel MenuButtonLabelPropertyInfo = "label"
    type AttrOrigin MenuButtonLabelPropertyInfo = MenuButton
    attrGet = getMenuButtonLabel
    attrSet = setMenuButtonLabel
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructMenuButtonLabel
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MenuButton.label"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MenuButton.html#g:attr:label"
        })
#endif

-- VVV Prop "menu-model"
   -- Type: TInterface (Name {namespace = "Gio", name = "MenuModel"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@menu-model@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' menuButton #menuModel
-- @
getMenuButtonMenuModel :: (MonadIO m, IsMenuButton o) => o -> m (Maybe Gio.MenuModel.MenuModel)
getMenuButtonMenuModel obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "menu-model" Gio.MenuModel.MenuModel

-- | Set the value of the “@menu-model@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' menuButton [ #menuModel 'Data.GI.Base.Attributes.:=' value ]
-- @
setMenuButtonMenuModel :: (MonadIO m, IsMenuButton o, Gio.MenuModel.IsMenuModel a) => o -> a -> m ()
setMenuButtonMenuModel obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "menu-model" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@menu-model@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMenuButtonMenuModel :: (IsMenuButton o, MIO.MonadIO m, Gio.MenuModel.IsMenuModel a) => a -> m (GValueConstruct o)
constructMenuButtonMenuModel val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "menu-model" (P.Just val)

-- | Set the value of the “@menu-model@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #menuModel
-- @
clearMenuButtonMenuModel :: (MonadIO m, IsMenuButton o) => o -> m ()
clearMenuButtonMenuModel obj = liftIO $ B.Properties.setObjectPropertyObject obj "menu-model" (Nothing :: Maybe Gio.MenuModel.MenuModel)

#if defined(ENABLE_OVERLOADING)
data MenuButtonMenuModelPropertyInfo
instance AttrInfo MenuButtonMenuModelPropertyInfo where
    type AttrAllowedOps MenuButtonMenuModelPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint MenuButtonMenuModelPropertyInfo = IsMenuButton
    type AttrSetTypeConstraint MenuButtonMenuModelPropertyInfo = Gio.MenuModel.IsMenuModel
    type AttrTransferTypeConstraint MenuButtonMenuModelPropertyInfo = Gio.MenuModel.IsMenuModel
    type AttrTransferType MenuButtonMenuModelPropertyInfo = Gio.MenuModel.MenuModel
    type AttrGetType MenuButtonMenuModelPropertyInfo = (Maybe Gio.MenuModel.MenuModel)
    type AttrLabel MenuButtonMenuModelPropertyInfo = "menu-model"
    type AttrOrigin MenuButtonMenuModelPropertyInfo = MenuButton
    attrGet = getMenuButtonMenuModel
    attrSet = setMenuButtonMenuModel
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gio.MenuModel.MenuModel v
    attrConstruct = constructMenuButtonMenuModel
    attrClear = clearMenuButtonMenuModel
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MenuButton.menuModel"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MenuButton.html#g:attr:menuModel"
        })
#endif

-- VVV Prop "popover"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Popover"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@popover@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' menuButton #popover
-- @
getMenuButtonPopover :: (MonadIO m, IsMenuButton o) => o -> m (Maybe Gtk.Popover.Popover)
getMenuButtonPopover obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "popover" Gtk.Popover.Popover

-- | Set the value of the “@popover@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' menuButton [ #popover 'Data.GI.Base.Attributes.:=' value ]
-- @
setMenuButtonPopover :: (MonadIO m, IsMenuButton o, Gtk.Popover.IsPopover a) => o -> a -> m ()
setMenuButtonPopover obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "popover" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@popover@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMenuButtonPopover :: (IsMenuButton o, MIO.MonadIO m, Gtk.Popover.IsPopover a) => a -> m (GValueConstruct o)
constructMenuButtonPopover val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "popover" (P.Just val)

-- | Set the value of the “@popover@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #popover
-- @
clearMenuButtonPopover :: (MonadIO m, IsMenuButton o) => o -> m ()
clearMenuButtonPopover obj = liftIO $ B.Properties.setObjectPropertyObject obj "popover" (Nothing :: Maybe Gtk.Popover.Popover)

#if defined(ENABLE_OVERLOADING)
data MenuButtonPopoverPropertyInfo
instance AttrInfo MenuButtonPopoverPropertyInfo where
    type AttrAllowedOps MenuButtonPopoverPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint MenuButtonPopoverPropertyInfo = IsMenuButton
    type AttrSetTypeConstraint MenuButtonPopoverPropertyInfo = Gtk.Popover.IsPopover
    type AttrTransferTypeConstraint MenuButtonPopoverPropertyInfo = Gtk.Popover.IsPopover
    type AttrTransferType MenuButtonPopoverPropertyInfo = Gtk.Popover.Popover
    type AttrGetType MenuButtonPopoverPropertyInfo = (Maybe Gtk.Popover.Popover)
    type AttrLabel MenuButtonPopoverPropertyInfo = "popover"
    type AttrOrigin MenuButtonPopoverPropertyInfo = MenuButton
    attrGet = getMenuButtonPopover
    attrSet = setMenuButtonPopover
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gtk.Popover.Popover v
    attrConstruct = constructMenuButtonPopover
    attrClear = clearMenuButtonPopover
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MenuButton.popover"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MenuButton.html#g:attr:popover"
        })
#endif

-- VVV Prop "primary"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@primary@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' menuButton #primary
-- @
getMenuButtonPrimary :: (MonadIO m, IsMenuButton o) => o -> m Bool
getMenuButtonPrimary obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "primary"

-- | Set the value of the “@primary@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' menuButton [ #primary 'Data.GI.Base.Attributes.:=' value ]
-- @
setMenuButtonPrimary :: (MonadIO m, IsMenuButton o) => o -> Bool -> m ()
setMenuButtonPrimary obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "primary" val

-- | Construct a t'GValueConstruct' with valid value for the “@primary@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMenuButtonPrimary :: (IsMenuButton o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructMenuButtonPrimary val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "primary" val

#if defined(ENABLE_OVERLOADING)
data MenuButtonPrimaryPropertyInfo
instance AttrInfo MenuButtonPrimaryPropertyInfo where
    type AttrAllowedOps MenuButtonPrimaryPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint MenuButtonPrimaryPropertyInfo = IsMenuButton
    type AttrSetTypeConstraint MenuButtonPrimaryPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint MenuButtonPrimaryPropertyInfo = (~) Bool
    type AttrTransferType MenuButtonPrimaryPropertyInfo = Bool
    type AttrGetType MenuButtonPrimaryPropertyInfo = Bool
    type AttrLabel MenuButtonPrimaryPropertyInfo = "primary"
    type AttrOrigin MenuButtonPrimaryPropertyInfo = MenuButton
    attrGet = getMenuButtonPrimary
    attrSet = setMenuButtonPrimary
    attrPut = setMenuButtonPrimary
    attrTransfer _ v = do
        return v
    attrConstruct = constructMenuButtonPrimary
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MenuButton.primary"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MenuButton.html#g:attr:primary"
        })
#endif

-- VVV Prop "use-underline"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@use-underline@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' menuButton #useUnderline
-- @
getMenuButtonUseUnderline :: (MonadIO m, IsMenuButton o) => o -> m Bool
getMenuButtonUseUnderline obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "use-underline"

-- | Set the value of the “@use-underline@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' menuButton [ #useUnderline 'Data.GI.Base.Attributes.:=' value ]
-- @
setMenuButtonUseUnderline :: (MonadIO m, IsMenuButton o) => o -> Bool -> m ()
setMenuButtonUseUnderline obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "use-underline" val

-- | Construct a t'GValueConstruct' with valid value for the “@use-underline@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMenuButtonUseUnderline :: (IsMenuButton o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructMenuButtonUseUnderline val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "use-underline" val

#if defined(ENABLE_OVERLOADING)
data MenuButtonUseUnderlinePropertyInfo
instance AttrInfo MenuButtonUseUnderlinePropertyInfo where
    type AttrAllowedOps MenuButtonUseUnderlinePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint MenuButtonUseUnderlinePropertyInfo = IsMenuButton
    type AttrSetTypeConstraint MenuButtonUseUnderlinePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint MenuButtonUseUnderlinePropertyInfo = (~) Bool
    type AttrTransferType MenuButtonUseUnderlinePropertyInfo = Bool
    type AttrGetType MenuButtonUseUnderlinePropertyInfo = Bool
    type AttrLabel MenuButtonUseUnderlinePropertyInfo = "use-underline"
    type AttrOrigin MenuButtonUseUnderlinePropertyInfo = MenuButton
    attrGet = getMenuButtonUseUnderline
    attrSet = setMenuButtonUseUnderline
    attrPut = setMenuButtonUseUnderline
    attrTransfer _ v = do
        return v
    attrConstruct = constructMenuButtonUseUnderline
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MenuButton.useUnderline"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MenuButton.html#g:attr:useUnderline"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList MenuButton
type instance O.AttributeList MenuButton = MenuButtonAttributeList
type MenuButtonAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("active", MenuButtonActivePropertyInfo), '("alwaysShowArrow", MenuButtonAlwaysShowArrowPropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canShrink", MenuButtonCanShrinkPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("child", MenuButtonChildPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("direction", MenuButtonDirectionPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasFrame", MenuButtonHasFramePropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("iconName", MenuButtonIconNamePropertyInfo), '("label", MenuButtonLabelPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("menuModel", MenuButtonMenuModelPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("popover", MenuButtonPopoverPropertyInfo), '("primary", MenuButtonPrimaryPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("useUnderline", MenuButtonUseUnderlinePropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
menuButtonActive :: AttrLabelProxy "active"
menuButtonActive = AttrLabelProxy

menuButtonAlwaysShowArrow :: AttrLabelProxy "alwaysShowArrow"
menuButtonAlwaysShowArrow = AttrLabelProxy

menuButtonCanShrink :: AttrLabelProxy "canShrink"
menuButtonCanShrink = AttrLabelProxy

menuButtonChild :: AttrLabelProxy "child"
menuButtonChild = AttrLabelProxy

menuButtonDirection :: AttrLabelProxy "direction"
menuButtonDirection = AttrLabelProxy

menuButtonHasFrame :: AttrLabelProxy "hasFrame"
menuButtonHasFrame = AttrLabelProxy

menuButtonIconName :: AttrLabelProxy "iconName"
menuButtonIconName = AttrLabelProxy

menuButtonLabel :: AttrLabelProxy "label"
menuButtonLabel = AttrLabelProxy

menuButtonMenuModel :: AttrLabelProxy "menuModel"
menuButtonMenuModel = AttrLabelProxy

menuButtonPopover :: AttrLabelProxy "popover"
menuButtonPopover = AttrLabelProxy

menuButtonPrimary :: AttrLabelProxy "primary"
menuButtonPrimary = AttrLabelProxy

menuButtonUseUnderline :: AttrLabelProxy "useUnderline"
menuButtonUseUnderline = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList MenuButton = MenuButtonSignalList
type MenuButtonSignalList = ('[ '("activate", MenuButtonActivateSignalInfo), '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method MenuButton::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "MenuButton" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_menu_button_new" gtk_menu_button_new :: 
    IO (Ptr MenuButton)

-- | Creates a new @GtkMenuButton@ widget with downwards-pointing
-- arrow as the only child.
-- 
-- You can replace the child widget with another @GtkWidget@
-- should you wish to.
menuButtonNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m MenuButton
    -- ^ __Returns:__ The newly created @GtkMenuButton@
menuButtonNew  = liftIO $ do
    result <- gtk_menu_button_new
    checkUnexpectedReturnNULL "menuButtonNew" result
    result' <- (newObject MenuButton) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method MenuButton::get_active
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "menu_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MenuButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMenuButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_menu_button_get_active" gtk_menu_button_get_active :: 
    Ptr MenuButton ->                       -- menu_button : TInterface (Name {namespace = "Gtk", name = "MenuButton"})
    IO CInt

-- | Returns whether the menu button is active.
-- 
-- /Since: 4.10/
menuButtonGetActive ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuButton a) =>
    a
    -- ^ /@menuButton@/: a @GtkMenuButton@
    -> m Bool
    -- ^ __Returns:__ TRUE if the button is active
menuButtonGetActive menuButton = liftIO $ do
    menuButton' <- unsafeManagedPtrCastPtr menuButton
    result <- gtk_menu_button_get_active menuButton'
    let result' = (/= 0) result
    touchManagedPtr menuButton
    return result'

#if defined(ENABLE_OVERLOADING)
data MenuButtonGetActiveMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsMenuButton a) => O.OverloadedMethod MenuButtonGetActiveMethodInfo a signature where
    overloadedMethod = menuButtonGetActive

instance O.OverloadedMethodInfo MenuButtonGetActiveMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MenuButton.menuButtonGetActive",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MenuButton.html#v:menuButtonGetActive"
        })


#endif

-- method MenuButton::get_always_show_arrow
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "menu_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MenuButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMenuButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_menu_button_get_always_show_arrow" gtk_menu_button_get_always_show_arrow :: 
    Ptr MenuButton ->                       -- menu_button : TInterface (Name {namespace = "Gtk", name = "MenuButton"})
    IO CInt

-- | Gets whether to show a dropdown arrow even when using an icon or a custom
-- child.
-- 
-- /Since: 4.4/
menuButtonGetAlwaysShowArrow ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuButton a) =>
    a
    -- ^ /@menuButton@/: a @GtkMenuButton@
    -> m Bool
    -- ^ __Returns:__ whether to show a dropdown arrow even when using an icon or a custom
    -- child.
menuButtonGetAlwaysShowArrow menuButton = liftIO $ do
    menuButton' <- unsafeManagedPtrCastPtr menuButton
    result <- gtk_menu_button_get_always_show_arrow menuButton'
    let result' = (/= 0) result
    touchManagedPtr menuButton
    return result'

#if defined(ENABLE_OVERLOADING)
data MenuButtonGetAlwaysShowArrowMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsMenuButton a) => O.OverloadedMethod MenuButtonGetAlwaysShowArrowMethodInfo a signature where
    overloadedMethod = menuButtonGetAlwaysShowArrow

instance O.OverloadedMethodInfo MenuButtonGetAlwaysShowArrowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MenuButton.menuButtonGetAlwaysShowArrow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MenuButton.html#v:menuButtonGetAlwaysShowArrow"
        })


#endif

-- method MenuButton::get_can_shrink
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "menu_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MenuButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a button" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_menu_button_get_can_shrink" gtk_menu_button_get_can_shrink :: 
    Ptr MenuButton ->                       -- menu_button : TInterface (Name {namespace = "Gtk", name = "MenuButton"})
    IO CInt

-- | Retrieves whether the button can be smaller than the natural
-- size of its contents.
-- 
-- /Since: 4.12/
menuButtonGetCanShrink ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuButton a) =>
    a
    -- ^ /@menuButton@/: a button
    -> m Bool
    -- ^ __Returns:__ true if the button can shrink, and false otherwise
menuButtonGetCanShrink menuButton = liftIO $ do
    menuButton' <- unsafeManagedPtrCastPtr menuButton
    result <- gtk_menu_button_get_can_shrink menuButton'
    let result' = (/= 0) result
    touchManagedPtr menuButton
    return result'

#if defined(ENABLE_OVERLOADING)
data MenuButtonGetCanShrinkMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsMenuButton a) => O.OverloadedMethod MenuButtonGetCanShrinkMethodInfo a signature where
    overloadedMethod = menuButtonGetCanShrink

instance O.OverloadedMethodInfo MenuButtonGetCanShrinkMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MenuButton.menuButtonGetCanShrink",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MenuButton.html#v:menuButtonGetCanShrink"
        })


#endif

-- method MenuButton::get_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "menu_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MenuButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMenuButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_menu_button_get_child" gtk_menu_button_get_child :: 
    Ptr MenuButton ->                       -- menu_button : TInterface (Name {namespace = "Gtk", name = "MenuButton"})
    IO (Ptr Gtk.Widget.Widget)

-- | Gets the child widget of /@menuButton@/.
-- 
-- /Since: 4.6/
menuButtonGetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuButton a) =>
    a
    -- ^ /@menuButton@/: a @GtkMenuButton@
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ the child widget of /@menuButton@/
menuButtonGetChild menuButton = liftIO $ do
    menuButton' <- unsafeManagedPtrCastPtr menuButton
    result <- gtk_menu_button_get_child menuButton'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr menuButton
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data MenuButtonGetChildMethodInfo
instance (signature ~ (m (Maybe Gtk.Widget.Widget)), MonadIO m, IsMenuButton a) => O.OverloadedMethod MenuButtonGetChildMethodInfo a signature where
    overloadedMethod = menuButtonGetChild

instance O.OverloadedMethodInfo MenuButtonGetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MenuButton.menuButtonGetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MenuButton.html#v:menuButtonGetChild"
        })


#endif

-- method MenuButton::get_direction
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "menu_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MenuButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMenuButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "ArrowType" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_menu_button_get_direction" gtk_menu_button_get_direction :: 
    Ptr MenuButton ->                       -- menu_button : TInterface (Name {namespace = "Gtk", name = "MenuButton"})
    IO CUInt

-- | Returns the direction the popup will be pointing at when popped up.
menuButtonGetDirection ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuButton a) =>
    a
    -- ^ /@menuButton@/: a @GtkMenuButton@
    -> m Gtk.Enums.ArrowType
    -- ^ __Returns:__ a @GtkArrowType@ value
menuButtonGetDirection menuButton = liftIO $ do
    menuButton' <- unsafeManagedPtrCastPtr menuButton
    result <- gtk_menu_button_get_direction menuButton'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr menuButton
    return result'

#if defined(ENABLE_OVERLOADING)
data MenuButtonGetDirectionMethodInfo
instance (signature ~ (m Gtk.Enums.ArrowType), MonadIO m, IsMenuButton a) => O.OverloadedMethod MenuButtonGetDirectionMethodInfo a signature where
    overloadedMethod = menuButtonGetDirection

instance O.OverloadedMethodInfo MenuButtonGetDirectionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MenuButton.menuButtonGetDirection",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MenuButton.html#v:menuButtonGetDirection"
        })


#endif

-- method MenuButton::get_has_frame
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "menu_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MenuButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMenuButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_menu_button_get_has_frame" gtk_menu_button_get_has_frame :: 
    Ptr MenuButton ->                       -- menu_button : TInterface (Name {namespace = "Gtk", name = "MenuButton"})
    IO CInt

-- | Returns whether the button has a frame.
menuButtonGetHasFrame ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuButton a) =>
    a
    -- ^ /@menuButton@/: a @GtkMenuButton@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the button has a frame
menuButtonGetHasFrame menuButton = liftIO $ do
    menuButton' <- unsafeManagedPtrCastPtr menuButton
    result <- gtk_menu_button_get_has_frame menuButton'
    let result' = (/= 0) result
    touchManagedPtr menuButton
    return result'

#if defined(ENABLE_OVERLOADING)
data MenuButtonGetHasFrameMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsMenuButton a) => O.OverloadedMethod MenuButtonGetHasFrameMethodInfo a signature where
    overloadedMethod = menuButtonGetHasFrame

instance O.OverloadedMethodInfo MenuButtonGetHasFrameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MenuButton.menuButtonGetHasFrame",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MenuButton.html#v:menuButtonGetHasFrame"
        })


#endif

-- method MenuButton::get_icon_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "menu_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MenuButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMenuButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_menu_button_get_icon_name" gtk_menu_button_get_icon_name :: 
    Ptr MenuButton ->                       -- menu_button : TInterface (Name {namespace = "Gtk", name = "MenuButton"})
    IO CString

-- | Gets the name of the icon shown in the button.
menuButtonGetIconName ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuButton a) =>
    a
    -- ^ /@menuButton@/: a @GtkMenuButton@
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the name of the icon shown in the button
menuButtonGetIconName menuButton = liftIO $ do
    menuButton' <- unsafeManagedPtrCastPtr menuButton
    result <- gtk_menu_button_get_icon_name menuButton'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr menuButton
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data MenuButtonGetIconNameMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsMenuButton a) => O.OverloadedMethod MenuButtonGetIconNameMethodInfo a signature where
    overloadedMethod = menuButtonGetIconName

instance O.OverloadedMethodInfo MenuButtonGetIconNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MenuButton.menuButtonGetIconName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MenuButton.html#v:menuButtonGetIconName"
        })


#endif

-- method MenuButton::get_label
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "menu_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MenuButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMenuButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_menu_button_get_label" gtk_menu_button_get_label :: 
    Ptr MenuButton ->                       -- menu_button : TInterface (Name {namespace = "Gtk", name = "MenuButton"})
    IO CString

-- | Gets the label shown in the button
menuButtonGetLabel ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuButton a) =>
    a
    -- ^ /@menuButton@/: a @GtkMenuButton@
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the label shown in the button
menuButtonGetLabel menuButton = liftIO $ do
    menuButton' <- unsafeManagedPtrCastPtr menuButton
    result <- gtk_menu_button_get_label menuButton'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr menuButton
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data MenuButtonGetLabelMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsMenuButton a) => O.OverloadedMethod MenuButtonGetLabelMethodInfo a signature where
    overloadedMethod = menuButtonGetLabel

instance O.OverloadedMethodInfo MenuButtonGetLabelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MenuButton.menuButtonGetLabel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MenuButton.html#v:menuButtonGetLabel"
        })


#endif

-- method MenuButton::get_menu_model
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "menu_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MenuButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMenuButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "MenuModel" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_menu_button_get_menu_model" gtk_menu_button_get_menu_model :: 
    Ptr MenuButton ->                       -- menu_button : TInterface (Name {namespace = "Gtk", name = "MenuButton"})
    IO (Ptr Gio.MenuModel.MenuModel)

-- | Returns the @GMenuModel@ used to generate the popup.
menuButtonGetMenuModel ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuButton a) =>
    a
    -- ^ /@menuButton@/: a @GtkMenuButton@
    -> m (Maybe Gio.MenuModel.MenuModel)
    -- ^ __Returns:__ a @GMenuModel@
menuButtonGetMenuModel menuButton = liftIO $ do
    menuButton' <- unsafeManagedPtrCastPtr menuButton
    result <- gtk_menu_button_get_menu_model menuButton'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gio.MenuModel.MenuModel) result'
        return result''
    touchManagedPtr menuButton
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data MenuButtonGetMenuModelMethodInfo
instance (signature ~ (m (Maybe Gio.MenuModel.MenuModel)), MonadIO m, IsMenuButton a) => O.OverloadedMethod MenuButtonGetMenuModelMethodInfo a signature where
    overloadedMethod = menuButtonGetMenuModel

instance O.OverloadedMethodInfo MenuButtonGetMenuModelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MenuButton.menuButtonGetMenuModel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MenuButton.html#v:menuButtonGetMenuModel"
        })


#endif

-- method MenuButton::get_popover
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "menu_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MenuButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMenuButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Popover" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_menu_button_get_popover" gtk_menu_button_get_popover :: 
    Ptr MenuButton ->                       -- menu_button : TInterface (Name {namespace = "Gtk", name = "MenuButton"})
    IO (Ptr Gtk.Popover.Popover)

-- | Returns the @GtkPopover@ that pops out of the button.
-- 
-- If the button is not using a @GtkPopover@, this function
-- returns 'P.Nothing'.
menuButtonGetPopover ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuButton a) =>
    a
    -- ^ /@menuButton@/: a @GtkMenuButton@
    -> m (Maybe Gtk.Popover.Popover)
    -- ^ __Returns:__ a @GtkPopover@ or 'P.Nothing'
menuButtonGetPopover menuButton = liftIO $ do
    menuButton' <- unsafeManagedPtrCastPtr menuButton
    result <- gtk_menu_button_get_popover menuButton'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Popover.Popover) result'
        return result''
    touchManagedPtr menuButton
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data MenuButtonGetPopoverMethodInfo
instance (signature ~ (m (Maybe Gtk.Popover.Popover)), MonadIO m, IsMenuButton a) => O.OverloadedMethod MenuButtonGetPopoverMethodInfo a signature where
    overloadedMethod = menuButtonGetPopover

instance O.OverloadedMethodInfo MenuButtonGetPopoverMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MenuButton.menuButtonGetPopover",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MenuButton.html#v:menuButtonGetPopover"
        })


#endif

-- method MenuButton::get_primary
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "menu_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MenuButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMenuButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_menu_button_get_primary" gtk_menu_button_get_primary :: 
    Ptr MenuButton ->                       -- menu_button : TInterface (Name {namespace = "Gtk", name = "MenuButton"})
    IO CInt

-- | Returns whether the menu button acts as a primary menu.
-- 
-- /Since: 4.4/
menuButtonGetPrimary ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuButton a) =>
    a
    -- ^ /@menuButton@/: a @GtkMenuButton@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the button is a primary menu
menuButtonGetPrimary menuButton = liftIO $ do
    menuButton' <- unsafeManagedPtrCastPtr menuButton
    result <- gtk_menu_button_get_primary menuButton'
    let result' = (/= 0) result
    touchManagedPtr menuButton
    return result'

#if defined(ENABLE_OVERLOADING)
data MenuButtonGetPrimaryMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsMenuButton a) => O.OverloadedMethod MenuButtonGetPrimaryMethodInfo a signature where
    overloadedMethod = menuButtonGetPrimary

instance O.OverloadedMethodInfo MenuButtonGetPrimaryMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MenuButton.menuButtonGetPrimary",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MenuButton.html#v:menuButtonGetPrimary"
        })


#endif

-- method MenuButton::get_use_underline
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "menu_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MenuButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMenuButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_menu_button_get_use_underline" gtk_menu_button_get_use_underline :: 
    Ptr MenuButton ->                       -- menu_button : TInterface (Name {namespace = "Gtk", name = "MenuButton"})
    IO CInt

-- | Returns whether an embedded underline in the text indicates a
-- mnemonic.
menuButtonGetUseUnderline ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuButton a) =>
    a
    -- ^ /@menuButton@/: a @GtkMenuButton@
    -> m Bool
    -- ^ __Returns:__ 'P.True' whether an embedded underline in the text indicates
    --   the mnemonic accelerator keys.
menuButtonGetUseUnderline menuButton = liftIO $ do
    menuButton' <- unsafeManagedPtrCastPtr menuButton
    result <- gtk_menu_button_get_use_underline menuButton'
    let result' = (/= 0) result
    touchManagedPtr menuButton
    return result'

#if defined(ENABLE_OVERLOADING)
data MenuButtonGetUseUnderlineMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsMenuButton a) => O.OverloadedMethod MenuButtonGetUseUnderlineMethodInfo a signature where
    overloadedMethod = menuButtonGetUseUnderline

instance O.OverloadedMethodInfo MenuButtonGetUseUnderlineMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MenuButton.menuButtonGetUseUnderline",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MenuButton.html#v:menuButtonGetUseUnderline"
        })


#endif

-- method MenuButton::popdown
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "menu_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MenuButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMenuButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_menu_button_popdown" gtk_menu_button_popdown :: 
    Ptr MenuButton ->                       -- menu_button : TInterface (Name {namespace = "Gtk", name = "MenuButton"})
    IO ()

-- | Dismiss the menu.
menuButtonPopdown ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuButton a) =>
    a
    -- ^ /@menuButton@/: a @GtkMenuButton@
    -> m ()
menuButtonPopdown menuButton = liftIO $ do
    menuButton' <- unsafeManagedPtrCastPtr menuButton
    gtk_menu_button_popdown menuButton'
    touchManagedPtr menuButton
    return ()

#if defined(ENABLE_OVERLOADING)
data MenuButtonPopdownMethodInfo
instance (signature ~ (m ()), MonadIO m, IsMenuButton a) => O.OverloadedMethod MenuButtonPopdownMethodInfo a signature where
    overloadedMethod = menuButtonPopdown

instance O.OverloadedMethodInfo MenuButtonPopdownMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MenuButton.menuButtonPopdown",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MenuButton.html#v:menuButtonPopdown"
        })


#endif

-- method MenuButton::popup
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "menu_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MenuButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMenuButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_menu_button_popup" gtk_menu_button_popup :: 
    Ptr MenuButton ->                       -- menu_button : TInterface (Name {namespace = "Gtk", name = "MenuButton"})
    IO ()

-- | Pop up the menu.
menuButtonPopup ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuButton a) =>
    a
    -- ^ /@menuButton@/: a @GtkMenuButton@
    -> m ()
menuButtonPopup menuButton = liftIO $ do
    menuButton' <- unsafeManagedPtrCastPtr menuButton
    gtk_menu_button_popup menuButton'
    touchManagedPtr menuButton
    return ()

#if defined(ENABLE_OVERLOADING)
data MenuButtonPopupMethodInfo
instance (signature ~ (m ()), MonadIO m, IsMenuButton a) => O.OverloadedMethod MenuButtonPopupMethodInfo a signature where
    overloadedMethod = menuButtonPopup

instance O.OverloadedMethodInfo MenuButtonPopupMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MenuButton.menuButtonPopup",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MenuButton.html#v:menuButtonPopup"
        })


#endif

-- method MenuButton::set_active
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "menu_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MenuButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMenuButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "active"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether the menu button is active"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_menu_button_set_active" gtk_menu_button_set_active :: 
    Ptr MenuButton ->                       -- menu_button : TInterface (Name {namespace = "Gtk", name = "MenuButton"})
    CInt ->                                 -- active : TBasicType TBoolean
    IO ()

-- | Sets whether the menu button is active.
-- 
-- /Since: 4.10/
menuButtonSetActive ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuButton a) =>
    a
    -- ^ /@menuButton@/: a @GtkMenuButton@
    -> Bool
    -- ^ /@active@/: whether the menu button is active
    -> m ()
menuButtonSetActive menuButton active = liftIO $ do
    menuButton' <- unsafeManagedPtrCastPtr menuButton
    let active' = (P.fromIntegral . P.fromEnum) active
    gtk_menu_button_set_active menuButton' active'
    touchManagedPtr menuButton
    return ()

#if defined(ENABLE_OVERLOADING)
data MenuButtonSetActiveMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsMenuButton a) => O.OverloadedMethod MenuButtonSetActiveMethodInfo a signature where
    overloadedMethod = menuButtonSetActive

instance O.OverloadedMethodInfo MenuButtonSetActiveMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MenuButton.menuButtonSetActive",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MenuButton.html#v:menuButtonSetActive"
        })


#endif

-- method MenuButton::set_always_show_arrow
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "menu_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MenuButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMenuButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "always_show_arrow"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "whether to show a dropdown arrow even when using an icon\nor a custom child"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_menu_button_set_always_show_arrow" gtk_menu_button_set_always_show_arrow :: 
    Ptr MenuButton ->                       -- menu_button : TInterface (Name {namespace = "Gtk", name = "MenuButton"})
    CInt ->                                 -- always_show_arrow : TBasicType TBoolean
    IO ()

-- | Sets whether to show a dropdown arrow even when using an icon or a custom
-- child.
-- 
-- /Since: 4.4/
menuButtonSetAlwaysShowArrow ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuButton a) =>
    a
    -- ^ /@menuButton@/: a @GtkMenuButton@
    -> Bool
    -- ^ /@alwaysShowArrow@/: whether to show a dropdown arrow even when using an icon
    -- or a custom child
    -> m ()
menuButtonSetAlwaysShowArrow menuButton alwaysShowArrow = liftIO $ do
    menuButton' <- unsafeManagedPtrCastPtr menuButton
    let alwaysShowArrow' = (P.fromIntegral . P.fromEnum) alwaysShowArrow
    gtk_menu_button_set_always_show_arrow menuButton' alwaysShowArrow'
    touchManagedPtr menuButton
    return ()

#if defined(ENABLE_OVERLOADING)
data MenuButtonSetAlwaysShowArrowMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsMenuButton a) => O.OverloadedMethod MenuButtonSetAlwaysShowArrowMethodInfo a signature where
    overloadedMethod = menuButtonSetAlwaysShowArrow

instance O.OverloadedMethodInfo MenuButtonSetAlwaysShowArrowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MenuButton.menuButtonSetAlwaysShowArrow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MenuButton.html#v:menuButtonSetAlwaysShowArrow"
        })


#endif

-- method MenuButton::set_can_shrink
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "menu_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MenuButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a menu button" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "can_shrink"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether the button can shrink"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_menu_button_set_can_shrink" gtk_menu_button_set_can_shrink :: 
    Ptr MenuButton ->                       -- menu_button : TInterface (Name {namespace = "Gtk", name = "MenuButton"})
    CInt ->                                 -- can_shrink : TBasicType TBoolean
    IO ()

-- | Sets whether the button size can be smaller than the natural size of
-- its contents.
-- 
-- For text buttons, setting /@canShrink@/ to true will ellipsize the label.
-- 
-- For icon buttons, this function has no effect.
-- 
-- /Since: 4.12/
menuButtonSetCanShrink ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuButton a) =>
    a
    -- ^ /@menuButton@/: a menu button
    -> Bool
    -- ^ /@canShrink@/: whether the button can shrink
    -> m ()
menuButtonSetCanShrink menuButton canShrink = liftIO $ do
    menuButton' <- unsafeManagedPtrCastPtr menuButton
    let canShrink' = (P.fromIntegral . P.fromEnum) canShrink
    gtk_menu_button_set_can_shrink menuButton' canShrink'
    touchManagedPtr menuButton
    return ()

#if defined(ENABLE_OVERLOADING)
data MenuButtonSetCanShrinkMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsMenuButton a) => O.OverloadedMethod MenuButtonSetCanShrinkMethodInfo a signature where
    overloadedMethod = menuButtonSetCanShrink

instance O.OverloadedMethodInfo MenuButtonSetCanShrinkMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MenuButton.menuButtonSetCanShrink",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MenuButton.html#v:menuButtonSetCanShrink"
        })


#endif

-- method MenuButton::set_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "menu_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MenuButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMenuButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the child widget" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_menu_button_set_child" gtk_menu_button_set_child :: 
    Ptr MenuButton ->                       -- menu_button : TInterface (Name {namespace = "Gtk", name = "MenuButton"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Sets the child widget of /@menuButton@/.
-- 
-- Setting a child resets [MenuButton:label]("GI.Gtk.Objects.MenuButton#g:attr:label") and
-- [MenuButton:iconName]("GI.Gtk.Objects.MenuButton#g:attr:iconName").
-- 
-- If [MenuButton:alwaysShowArrow]("GI.Gtk.Objects.MenuButton#g:attr:alwaysShowArrow") is set to @TRUE@ and
-- [MenuButton:direction]("GI.Gtk.Objects.MenuButton#g:attr:direction") is not @GTK_ARROW_NONE@, a dropdown arrow
-- will be shown next to the child.
-- 
-- /Since: 4.6/
menuButtonSetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuButton a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@menuButton@/: a @GtkMenuButton@
    -> Maybe (b)
    -- ^ /@child@/: the child widget
    -> m ()
menuButtonSetChild menuButton child = liftIO $ do
    menuButton' <- unsafeManagedPtrCastPtr menuButton
    maybeChild <- case child of
        Nothing -> return FP.nullPtr
        Just jChild -> do
            jChild' <- unsafeManagedPtrCastPtr jChild
            return jChild'
    gtk_menu_button_set_child menuButton' maybeChild
    touchManagedPtr menuButton
    whenJust child touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data MenuButtonSetChildMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsMenuButton a, Gtk.Widget.IsWidget b) => O.OverloadedMethod MenuButtonSetChildMethodInfo a signature where
    overloadedMethod = menuButtonSetChild

instance O.OverloadedMethodInfo MenuButtonSetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MenuButton.menuButtonSetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MenuButton.html#v:menuButtonSetChild"
        })


#endif

-- method MenuButton::set_create_popup_func
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "menu_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MenuButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMenuButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "func"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "MenuButtonCreatePopupFunc" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "function\n  to call when a popup is about to be shown, but none has been provided via other means,\n  or %NULL to reset to default behavior"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeNotified
--           , argClosure = 2
--           , argDestroy = 3
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data to pass to @func"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "destroy_notify"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "destroy notify for @user_data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_menu_button_set_create_popup_func" gtk_menu_button_set_create_popup_func :: 
    Ptr MenuButton ->                       -- menu_button : TInterface (Name {namespace = "Gtk", name = "MenuButton"})
    FunPtr Gtk.Callbacks.C_MenuButtonCreatePopupFunc -> -- func : TInterface (Name {namespace = "Gtk", name = "MenuButtonCreatePopupFunc"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- destroy_notify : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO ()

-- | Sets /@func@/ to be called when a popup is about to be shown.
-- 
-- /@func@/ should use one of
-- 
-- * 'GI.Gtk.Objects.MenuButton.menuButtonSetPopover'
-- * 'GI.Gtk.Objects.MenuButton.menuButtonSetMenuModel'
-- 
-- 
-- to set a popup for /@menuButton@/.
-- If /@func@/ is non-'P.Nothing', /@menuButton@/ will always be sensitive.
-- 
-- Using this function will not reset the menu widget attached to
-- /@menuButton@/. Instead, this can be done manually in /@func@/.
menuButtonSetCreatePopupFunc ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuButton a) =>
    a
    -- ^ /@menuButton@/: a @GtkMenuButton@
    -> Maybe (Gtk.Callbacks.MenuButtonCreatePopupFunc)
    -- ^ /@func@/: function
    --   to call when a popup is about to be shown, but none has been provided via other means,
    --   or 'P.Nothing' to reset to default behavior
    -> m ()
menuButtonSetCreatePopupFunc menuButton func = liftIO $ do
    menuButton' <- unsafeManagedPtrCastPtr menuButton
    maybeFunc <- case func of
        Nothing -> return FP.nullFunPtr
        Just jFunc -> do
            jFunc' <- Gtk.Callbacks.mk_MenuButtonCreatePopupFunc (Gtk.Callbacks.wrap_MenuButtonCreatePopupFunc Nothing (Gtk.Callbacks.drop_closures_MenuButtonCreatePopupFunc jFunc))
            return jFunc'
    let userData = castFunPtrToPtr maybeFunc
    let destroyNotify = SP.safeFreeFunPtrPtr
    gtk_menu_button_set_create_popup_func menuButton' maybeFunc userData destroyNotify
    touchManagedPtr menuButton
    return ()

#if defined(ENABLE_OVERLOADING)
data MenuButtonSetCreatePopupFuncMethodInfo
instance (signature ~ (Maybe (Gtk.Callbacks.MenuButtonCreatePopupFunc) -> m ()), MonadIO m, IsMenuButton a) => O.OverloadedMethod MenuButtonSetCreatePopupFuncMethodInfo a signature where
    overloadedMethod = menuButtonSetCreatePopupFunc

instance O.OverloadedMethodInfo MenuButtonSetCreatePopupFuncMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MenuButton.menuButtonSetCreatePopupFunc",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MenuButton.html#v:menuButtonSetCreatePopupFunc"
        })


#endif

-- method MenuButton::set_direction
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "menu_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MenuButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMenuButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "direction"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ArrowType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkArrowType`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_menu_button_set_direction" gtk_menu_button_set_direction :: 
    Ptr MenuButton ->                       -- menu_button : TInterface (Name {namespace = "Gtk", name = "MenuButton"})
    CUInt ->                                -- direction : TInterface (Name {namespace = "Gtk", name = "ArrowType"})
    IO ()

-- | Sets the direction in which the popup will be popped up.
-- 
-- If the button is automatically populated with an arrow icon,
-- its direction will be changed to match.
-- 
-- If the does not fit in the available space in the given direction,
-- GTK will its best to keep it inside the screen and fully visible.
-- 
-- If you pass 'GI.Gtk.Enums.ArrowTypeNone' for a /@direction@/, the popup will behave
-- as if you passed 'GI.Gtk.Enums.ArrowTypeDown' (although you won’t see any arrows).
menuButtonSetDirection ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuButton a) =>
    a
    -- ^ /@menuButton@/: a @GtkMenuButton@
    -> Gtk.Enums.ArrowType
    -- ^ /@direction@/: a @GtkArrowType@
    -> m ()
menuButtonSetDirection menuButton direction = liftIO $ do
    menuButton' <- unsafeManagedPtrCastPtr menuButton
    let direction' = (fromIntegral . fromEnum) direction
    gtk_menu_button_set_direction menuButton' direction'
    touchManagedPtr menuButton
    return ()

#if defined(ENABLE_OVERLOADING)
data MenuButtonSetDirectionMethodInfo
instance (signature ~ (Gtk.Enums.ArrowType -> m ()), MonadIO m, IsMenuButton a) => O.OverloadedMethod MenuButtonSetDirectionMethodInfo a signature where
    overloadedMethod = menuButtonSetDirection

instance O.OverloadedMethodInfo MenuButtonSetDirectionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MenuButton.menuButtonSetDirection",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MenuButton.html#v:menuButtonSetDirection"
        })


#endif

-- method MenuButton::set_has_frame
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "menu_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MenuButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMenuButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "has_frame"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "whether the button should have a visible frame"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_menu_button_set_has_frame" gtk_menu_button_set_has_frame :: 
    Ptr MenuButton ->                       -- menu_button : TInterface (Name {namespace = "Gtk", name = "MenuButton"})
    CInt ->                                 -- has_frame : TBasicType TBoolean
    IO ()

-- | Sets the style of the button.
menuButtonSetHasFrame ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuButton a) =>
    a
    -- ^ /@menuButton@/: a @GtkMenuButton@
    -> Bool
    -- ^ /@hasFrame@/: whether the button should have a visible frame
    -> m ()
menuButtonSetHasFrame menuButton hasFrame = liftIO $ do
    menuButton' <- unsafeManagedPtrCastPtr menuButton
    let hasFrame' = (P.fromIntegral . P.fromEnum) hasFrame
    gtk_menu_button_set_has_frame menuButton' hasFrame'
    touchManagedPtr menuButton
    return ()

#if defined(ENABLE_OVERLOADING)
data MenuButtonSetHasFrameMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsMenuButton a) => O.OverloadedMethod MenuButtonSetHasFrameMethodInfo a signature where
    overloadedMethod = menuButtonSetHasFrame

instance O.OverloadedMethodInfo MenuButtonSetHasFrameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MenuButton.menuButtonSetHasFrame",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MenuButton.html#v:menuButtonSetHasFrame"
        })


#endif

-- method MenuButton::set_icon_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "menu_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MenuButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMenuButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "icon_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the icon name" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_menu_button_set_icon_name" gtk_menu_button_set_icon_name :: 
    Ptr MenuButton ->                       -- menu_button : TInterface (Name {namespace = "Gtk", name = "MenuButton"})
    CString ->                              -- icon_name : TBasicType TUTF8
    IO ()

-- | Sets the name of an icon to show inside the menu button.
-- 
-- Setting icon name resets [MenuButton:label]("GI.Gtk.Objects.MenuButton#g:attr:label") and
-- [MenuButton:child]("GI.Gtk.Objects.MenuButton#g:attr:child").
-- 
-- If [MenuButton:alwaysShowArrow]("GI.Gtk.Objects.MenuButton#g:attr:alwaysShowArrow") is set to @TRUE@ and
-- [MenuButton:direction]("GI.Gtk.Objects.MenuButton#g:attr:direction") is not @GTK_ARROW_NONE@, a dropdown arrow
-- will be shown next to the icon.
menuButtonSetIconName ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuButton a) =>
    a
    -- ^ /@menuButton@/: a @GtkMenuButton@
    -> T.Text
    -- ^ /@iconName@/: the icon name
    -> m ()
menuButtonSetIconName menuButton iconName = liftIO $ do
    menuButton' <- unsafeManagedPtrCastPtr menuButton
    iconName' <- textToCString iconName
    gtk_menu_button_set_icon_name menuButton' iconName'
    touchManagedPtr menuButton
    freeMem iconName'
    return ()

#if defined(ENABLE_OVERLOADING)
data MenuButtonSetIconNameMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsMenuButton a) => O.OverloadedMethod MenuButtonSetIconNameMethodInfo a signature where
    overloadedMethod = menuButtonSetIconName

instance O.OverloadedMethodInfo MenuButtonSetIconNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MenuButton.menuButtonSetIconName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MenuButton.html#v:menuButtonSetIconName"
        })


#endif

-- method MenuButton::set_label
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "menu_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MenuButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMenuButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "label"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the label" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_menu_button_set_label" gtk_menu_button_set_label :: 
    Ptr MenuButton ->                       -- menu_button : TInterface (Name {namespace = "Gtk", name = "MenuButton"})
    CString ->                              -- label : TBasicType TUTF8
    IO ()

-- | Sets the label to show inside the menu button.
-- 
-- Setting a label resets [MenuButton:iconName]("GI.Gtk.Objects.MenuButton#g:attr:iconName") and
-- [MenuButton:child]("GI.Gtk.Objects.MenuButton#g:attr:child").
-- 
-- If [MenuButton:direction]("GI.Gtk.Objects.MenuButton#g:attr:direction") is not @GTK_ARROW_NONE@, a dropdown
-- arrow will be shown next to the label.
menuButtonSetLabel ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuButton a) =>
    a
    -- ^ /@menuButton@/: a @GtkMenuButton@
    -> T.Text
    -- ^ /@label@/: the label
    -> m ()
menuButtonSetLabel menuButton label = liftIO $ do
    menuButton' <- unsafeManagedPtrCastPtr menuButton
    label' <- textToCString label
    gtk_menu_button_set_label menuButton' label'
    touchManagedPtr menuButton
    freeMem label'
    return ()

#if defined(ENABLE_OVERLOADING)
data MenuButtonSetLabelMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsMenuButton a) => O.OverloadedMethod MenuButtonSetLabelMethodInfo a signature where
    overloadedMethod = menuButtonSetLabel

instance O.OverloadedMethodInfo MenuButtonSetLabelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MenuButton.menuButtonSetLabel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MenuButton.html#v:menuButtonSetLabel"
        })


#endif

-- method MenuButton::set_menu_model
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "menu_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MenuButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMenuButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "menu_model"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "MenuModel" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a `GMenuModel`, or %NULL to unset and disable the\n  button"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_menu_button_set_menu_model" gtk_menu_button_set_menu_model :: 
    Ptr MenuButton ->                       -- menu_button : TInterface (Name {namespace = "Gtk", name = "MenuButton"})
    Ptr Gio.MenuModel.MenuModel ->          -- menu_model : TInterface (Name {namespace = "Gio", name = "MenuModel"})
    IO ()

-- | Sets the @GMenuModel@ from which the popup will be constructed.
-- 
-- If /@menuModel@/ is 'P.Nothing', the button is disabled.
-- 
-- A t'GI.Gtk.Objects.Popover.Popover' will be created from the menu model with
-- 'GI.Gtk.Objects.PopoverMenu.popoverMenuNewFromModel'. Actions will be connected
-- as documented for this function.
-- 
-- If [MenuButton:popover]("GI.Gtk.Objects.MenuButton#g:attr:popover") is already set, it will be
-- dissociated from the /@menuButton@/, and the property is set to 'P.Nothing'.
menuButtonSetMenuModel ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuButton a, Gio.MenuModel.IsMenuModel b) =>
    a
    -- ^ /@menuButton@/: a @GtkMenuButton@
    -> Maybe (b)
    -- ^ /@menuModel@/: a @GMenuModel@, or 'P.Nothing' to unset and disable the
    --   button
    -> m ()
menuButtonSetMenuModel menuButton menuModel = liftIO $ do
    menuButton' <- unsafeManagedPtrCastPtr menuButton
    maybeMenuModel <- case menuModel of
        Nothing -> return FP.nullPtr
        Just jMenuModel -> do
            jMenuModel' <- unsafeManagedPtrCastPtr jMenuModel
            return jMenuModel'
    gtk_menu_button_set_menu_model menuButton' maybeMenuModel
    touchManagedPtr menuButton
    whenJust menuModel touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data MenuButtonSetMenuModelMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsMenuButton a, Gio.MenuModel.IsMenuModel b) => O.OverloadedMethod MenuButtonSetMenuModelMethodInfo a signature where
    overloadedMethod = menuButtonSetMenuModel

instance O.OverloadedMethodInfo MenuButtonSetMenuModelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MenuButton.menuButtonSetMenuModel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MenuButton.html#v:menuButtonSetMenuModel"
        })


#endif

-- method MenuButton::set_popover
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "menu_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MenuButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMenuButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "popover"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Popover" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a `GtkPopover`, or %NULL to unset and\n  disable the button"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_menu_button_set_popover" gtk_menu_button_set_popover :: 
    Ptr MenuButton ->                       -- menu_button : TInterface (Name {namespace = "Gtk", name = "MenuButton"})
    Ptr Gtk.Popover.Popover ->              -- popover : TInterface (Name {namespace = "Gtk", name = "Popover"})
    IO ()

-- | Sets the @GtkPopover@ that will be popped up when the /@menuButton@/ is clicked.
-- 
-- If /@popover@/ is 'P.Nothing', the button is disabled.
-- 
-- If [MenuButton:menuModel]("GI.Gtk.Objects.MenuButton#g:attr:menuModel") is set, the menu model is dissociated
-- from the /@menuButton@/, and the property is set to 'P.Nothing'.
menuButtonSetPopover ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuButton a, Gtk.Popover.IsPopover b) =>
    a
    -- ^ /@menuButton@/: a @GtkMenuButton@
    -> Maybe (b)
    -- ^ /@popover@/: a @GtkPopover@, or 'P.Nothing' to unset and
    --   disable the button
    -> m ()
menuButtonSetPopover menuButton popover = liftIO $ do
    menuButton' <- unsafeManagedPtrCastPtr menuButton
    maybePopover <- case popover of
        Nothing -> return FP.nullPtr
        Just jPopover -> do
            jPopover' <- unsafeManagedPtrCastPtr jPopover
            return jPopover'
    gtk_menu_button_set_popover menuButton' maybePopover
    touchManagedPtr menuButton
    whenJust popover touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data MenuButtonSetPopoverMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsMenuButton a, Gtk.Popover.IsPopover b) => O.OverloadedMethod MenuButtonSetPopoverMethodInfo a signature where
    overloadedMethod = menuButtonSetPopover

instance O.OverloadedMethodInfo MenuButtonSetPopoverMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MenuButton.menuButtonSetPopover",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MenuButton.html#v:menuButtonSetPopover"
        })


#endif

-- method MenuButton::set_primary
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "menu_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MenuButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMenuButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "primary"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "whether the menubutton should act as a primary menu"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_menu_button_set_primary" gtk_menu_button_set_primary :: 
    Ptr MenuButton ->                       -- menu_button : TInterface (Name {namespace = "Gtk", name = "MenuButton"})
    CInt ->                                 -- primary : TBasicType TBoolean
    IO ()

-- | Sets whether menu button acts as a primary menu.
-- 
-- Primary menus can be opened with the \<kbd>F10\<\/kbd> key.
-- 
-- /Since: 4.4/
menuButtonSetPrimary ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuButton a) =>
    a
    -- ^ /@menuButton@/: a @GtkMenuButton@
    -> Bool
    -- ^ /@primary@/: whether the menubutton should act as a primary menu
    -> m ()
menuButtonSetPrimary menuButton primary = liftIO $ do
    menuButton' <- unsafeManagedPtrCastPtr menuButton
    let primary' = (P.fromIntegral . P.fromEnum) primary
    gtk_menu_button_set_primary menuButton' primary'
    touchManagedPtr menuButton
    return ()

#if defined(ENABLE_OVERLOADING)
data MenuButtonSetPrimaryMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsMenuButton a) => O.OverloadedMethod MenuButtonSetPrimaryMethodInfo a signature where
    overloadedMethod = menuButtonSetPrimary

instance O.OverloadedMethodInfo MenuButtonSetPrimaryMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MenuButton.menuButtonSetPrimary",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MenuButton.html#v:menuButtonSetPrimary"
        })


#endif

-- method MenuButton::set_use_underline
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "menu_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MenuButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMenuButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "use_underline"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "%TRUE if underlines in the text indicate mnemonics"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_menu_button_set_use_underline" gtk_menu_button_set_use_underline :: 
    Ptr MenuButton ->                       -- menu_button : TInterface (Name {namespace = "Gtk", name = "MenuButton"})
    CInt ->                                 -- use_underline : TBasicType TBoolean
    IO ()

-- | If true, an underline in the text indicates a mnemonic.
menuButtonSetUseUnderline ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuButton a) =>
    a
    -- ^ /@menuButton@/: a @GtkMenuButton@
    -> Bool
    -- ^ /@useUnderline@/: 'P.True' if underlines in the text indicate mnemonics
    -> m ()
menuButtonSetUseUnderline menuButton useUnderline = liftIO $ do
    menuButton' <- unsafeManagedPtrCastPtr menuButton
    let useUnderline' = (P.fromIntegral . P.fromEnum) useUnderline
    gtk_menu_button_set_use_underline menuButton' useUnderline'
    touchManagedPtr menuButton
    return ()

#if defined(ENABLE_OVERLOADING)
data MenuButtonSetUseUnderlineMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsMenuButton a) => O.OverloadedMethod MenuButtonSetUseUnderlineMethodInfo a signature where
    overloadedMethod = menuButtonSetUseUnderline

instance O.OverloadedMethodInfo MenuButtonSetUseUnderlineMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MenuButton.menuButtonSetUseUnderline",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MenuButton.html#v:menuButtonSetUseUnderline"
        })


#endif


