/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, qtgui, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_qtgui_time_raster_sink_f = R"doc(A graphical sink to display multiple signals on a time_raster plot.

This is a QT-based graphical sink that takes set of a floating point streams and plots a time_raster (spectrogram) plot.


The sink supports plotting streaming float data or messages. The message port is named \"in\". The two modes cannot be used simultaneously, and  should be set to 0 when using the message mode. GRC handles this issue by providing the \"Float Message\" type that removes the streaming port(s).


This sink can plot messages that contain either uniform vectors of float 32 values (pmt::is_f32vector) or PDUs where the data is a uniform vector of float 32 values.

Constructor Specific Documentation:

Build a floating point time raster sink.

Args:
    samp_rate : sample rate of signal
    cols : number of cols to plot
    rows : number of rows to plot
    mult : vector of floats as a scaling multiplier for each input stream
    offset : vector of floats as an offset for each input stream
    name : title for the plot
    nconnections : number of streams connected
    parent : a QWidget parent object, if any)doc";


static const char* __doc_gr_qtgui_time_raster_sink_f_time_raster_sink_f_0 = R"doc()doc";


static const char* __doc_gr_qtgui_time_raster_sink_f_time_raster_sink_f_1 = R"doc()doc";


static const char* __doc_gr_qtgui_time_raster_sink_f_make = R"doc(A graphical sink to display multiple signals on a time_raster plot.

This is a QT-based graphical sink that takes set of a floating point streams and plots a time_raster (spectrogram) plot.


The sink supports plotting streaming float data or messages. The message port is named \"in\". The two modes cannot be used simultaneously, and  should be set to 0 when using the message mode. GRC handles this issue by providing the \"Float Message\" type that removes the streaming port(s).


This sink can plot messages that contain either uniform vectors of float 32 values (pmt::is_f32vector) or PDUs where the data is a uniform vector of float 32 values.

Constructor Specific Documentation:

Build a floating point time raster sink.

Args:
    samp_rate : sample rate of signal
    cols : number of cols to plot
    rows : number of rows to plot
    mult : vector of floats as a scaling multiplier for each input stream
    offset : vector of floats as an offset for each input stream
    name : title for the plot
    nconnections : number of streams connected
    parent : a QWidget parent object, if any)doc";


static const char* __doc_gr_qtgui_time_raster_sink_f_exec_ = R"doc()doc";


static const char* __doc_gr_qtgui_time_raster_sink_f_qwidget = R"doc()doc";


static const char* __doc_gr_qtgui_time_raster_sink_f_set_x_label = R"doc()doc";


static const char* __doc_gr_qtgui_time_raster_sink_f_set_x_range = R"doc()doc";


static const char* __doc_gr_qtgui_time_raster_sink_f_set_y_label = R"doc()doc";


static const char* __doc_gr_qtgui_time_raster_sink_f_set_y_range = R"doc()doc";


static const char* __doc_gr_qtgui_time_raster_sink_f_set_update_time = R"doc()doc";


static const char* __doc_gr_qtgui_time_raster_sink_f_set_title = R"doc()doc";


static const char* __doc_gr_qtgui_time_raster_sink_f_set_line_label = R"doc()doc";


static const char* __doc_gr_qtgui_time_raster_sink_f_set_line_color = R"doc()doc";


static const char* __doc_gr_qtgui_time_raster_sink_f_set_line_width = R"doc()doc";


static const char* __doc_gr_qtgui_time_raster_sink_f_set_line_style = R"doc()doc";


static const char* __doc_gr_qtgui_time_raster_sink_f_set_line_marker = R"doc()doc";


static const char* __doc_gr_qtgui_time_raster_sink_f_set_line_alpha = R"doc()doc";


static const char* __doc_gr_qtgui_time_raster_sink_f_set_color_map = R"doc()doc";


static const char* __doc_gr_qtgui_time_raster_sink_f_title = R"doc()doc";


static const char* __doc_gr_qtgui_time_raster_sink_f_line_label = R"doc()doc";


static const char* __doc_gr_qtgui_time_raster_sink_f_line_color = R"doc()doc";


static const char* __doc_gr_qtgui_time_raster_sink_f_line_width = R"doc()doc";


static const char* __doc_gr_qtgui_time_raster_sink_f_line_style = R"doc()doc";


static const char* __doc_gr_qtgui_time_raster_sink_f_line_marker = R"doc()doc";


static const char* __doc_gr_qtgui_time_raster_sink_f_line_alpha = R"doc()doc";


static const char* __doc_gr_qtgui_time_raster_sink_f_color_map = R"doc()doc";


static const char* __doc_gr_qtgui_time_raster_sink_f_set_size = R"doc()doc";


static const char* __doc_gr_qtgui_time_raster_sink_f_set_samp_rate = R"doc()doc";


static const char* __doc_gr_qtgui_time_raster_sink_f_set_num_rows = R"doc()doc";


static const char* __doc_gr_qtgui_time_raster_sink_f_set_num_cols = R"doc()doc";


static const char* __doc_gr_qtgui_time_raster_sink_f_num_rows = R"doc()doc";


static const char* __doc_gr_qtgui_time_raster_sink_f_num_cols = R"doc()doc";


static const char* __doc_gr_qtgui_time_raster_sink_f_set_multiplier = R"doc()doc";


static const char* __doc_gr_qtgui_time_raster_sink_f_set_offset = R"doc()doc";


static const char* __doc_gr_qtgui_time_raster_sink_f_set_intensity_range = R"doc()doc";


static const char* __doc_gr_qtgui_time_raster_sink_f_enable_menu = R"doc()doc";


static const char* __doc_gr_qtgui_time_raster_sink_f_enable_grid = R"doc()doc";


static const char* __doc_gr_qtgui_time_raster_sink_f_enable_autoscale = R"doc()doc";


static const char* __doc_gr_qtgui_time_raster_sink_f_enable_axis_labels = R"doc()doc";


static const char* __doc_gr_qtgui_time_raster_sink_f_reset = R"doc()doc";
