/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_stream_to_tagged_stream = R"doc(Converts a regular stream into a tagged stream.

All this block does is add length tags in regular intervals. It can be used to connect a regular stream to a gr::tagged_stream_block.


 This block is meant to be connected directly to a tagged stream block. If there are blocks between this block and a tagged stream block, make sure they either don't change the rate, or modify the tag value to make sure the length tags actually represent the packet length.

Constructor Specific Documentation:



Args:
    itemsize : Item size
    vlen : Vector length of the input items. Note that one vector is one item.
    packet_len : Number of items per tagged stream packet. One tag is written every  items.
    len_tag_key : Key of the length tag.)doc";


static const char* __doc_gr_blocks_stream_to_tagged_stream_stream_to_tagged_stream_0 =
    R"doc()doc";


static const char* __doc_gr_blocks_stream_to_tagged_stream_stream_to_tagged_stream_1 =
    R"doc()doc";


static const char* __doc_gr_blocks_stream_to_tagged_stream_make = R"doc(Converts a regular stream into a tagged stream.

All this block does is add length tags in regular intervals. It can be used to connect a regular stream to a gr::tagged_stream_block.


 This block is meant to be connected directly to a tagged stream block. If there are blocks between this block and a tagged stream block, make sure they either don't change the rate, or modify the tag value to make sure the length tags actually represent the packet length.

Constructor Specific Documentation:



Args:
    itemsize : Item size
    vlen : Vector length of the input items. Note that one vector is one item.
    packet_len : Number of items per tagged stream packet. One tag is written every  items.
    len_tag_key : Key of the length tag.)doc";


static const char* __doc_gr_blocks_stream_to_tagged_stream_set_packet_len = R"doc()doc";


static const char* __doc_gr_blocks_stream_to_tagged_stream_set_packet_len_pmt =
    R"doc()doc";
