/* Zoom.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Zoom.vala, do not modify */

/*
 * Copyright 2022 elementary, Inc. (https://elementary.io)
 * Copyright 2013 Tom Beckmann
 * Copyright 2013 Rico Tzschichholz
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include <glib-object.h>
#include "gala.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <meta/display.h>
#include <meta/meta-plugin.h>
#include <meta/prefs.h>
#include <meta/window.h>
#include <clutter/clutter.h>
#include <meta/keybindings.h>
#include <meta/compositor-mutter.h>
#include <graphene-gobject.h>
#include <meta/meta-cursor-tracker.h>
#include <string.h>

#define GALA_ZOOM_MIN_ZOOM 1.0f
#define GALA_ZOOM_MAX_ZOOM 10.0f
#define GALA_ZOOM_SHORTCUT_DELTA 0.5f
#define GALA_ZOOM_MOUSE_POLL_TIME ((guint) 50)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_ZOOM (gala_zoom_get_type ())
#define GALA_ZOOM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_ZOOM, GalaZoom))
#define GALA_ZOOM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_ZOOM, GalaZoomClass))
#define GALA_IS_ZOOM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_ZOOM))
#define GALA_IS_ZOOM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_ZOOM))
#define GALA_ZOOM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_ZOOM, GalaZoomClass))

typedef struct _GalaZoom GalaZoom;
typedef struct _GalaZoomClass GalaZoomClass;
typedef struct _GalaZoomPrivate GalaZoomPrivate;
enum  {
	GALA_ZOOM_0_PROPERTY,
	GALA_ZOOM_WM_PROPERTY,
	GALA_ZOOM_ACTOR_PROPERTY,
	GALA_ZOOM_NUM_PROPERTIES
};
static GParamSpec* gala_zoom_properties[GALA_ZOOM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GALA_TYPE_SUPER_SCROLL_ACTION (gala_super_scroll_action_get_type ())
#define GALA_SUPER_SCROLL_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_SUPER_SCROLL_ACTION, GalaSuperScrollAction))
#define GALA_SUPER_SCROLL_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_SUPER_SCROLL_ACTION, GalaSuperScrollActionClass))
#define GALA_IS_SUPER_SCROLL_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_SUPER_SCROLL_ACTION))
#define GALA_IS_SUPER_SCROLL_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_SUPER_SCROLL_ACTION))
#define GALA_SUPER_SCROLL_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_SUPER_SCROLL_ACTION, GalaSuperScrollActionClass))

typedef struct _GalaSuperScrollAction GalaSuperScrollAction;
typedef struct _GalaSuperScrollActionClass GalaSuperScrollActionClass;
typedef struct _Block31Data Block31Data;
#define __vala_graphene_point_t_free0(var) ((var == NULL) ? NULL : (var = (_vala_graphene_point_t_free (var), NULL)))

struct _GalaZoom {
	GObject parent_instance;
	GalaZoomPrivate * priv;
};

struct _GalaZoomClass {
	GObjectClass parent_class;
};

struct _GalaZoomPrivate {
	GalaWindowManager* _wm;
	guint mouse_poll_timer;
	gfloat current_zoom;
	gulong wins_handler_id;
	GalaGestureController* gesture_controller;
	gdouble current_commit;
	GSettings* behavior_settings;
};

struct _Block31Data {
	int _ref_count_;
	GalaZoom* self;
	ClutterActor* wins;
};

static gint GalaZoom_private_offset;
static gpointer gala_zoom_parent_class = NULL;
static GalaGestureTargetIface * gala_zoom_gala_gesture_target_parent_iface = NULL;
static GalaRootTargetIface * gala_zoom_gala_root_target_parent_iface = NULL;

VALA_EXTERN GType gala_zoom_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaZoom, g_object_unref)
VALA_EXTERN GalaWindowManager* gala_zoom_get_wm (GalaZoom* self);
VALA_EXTERN GalaZoom* gala_zoom_new (GalaWindowManager* wm);
VALA_EXTERN GalaZoom* gala_zoom_construct (GType object_type,
                               GalaWindowManager* wm);
static void gala_zoom_zoom_in (GalaZoom* self,
                        MetaDisplay* display,
                        MetaWindow* window,
                        ClutterKeyEvent* event,
                        MetaKeyBinding* binding);
static void _gala_zoom_zoom_in_meta_key_handler_func (MetaDisplay* display,
                                               MetaWindow* window,
                                               const ClutterKeyEvent* event,
                                               MetaKeyBinding* binding,
                                               gpointer self);
static void gala_zoom_zoom_out (GalaZoom* self,
                         MetaDisplay* display,
                         MetaWindow* window,
                         ClutterKeyEvent* event,
                         MetaKeyBinding* binding);
static void _gala_zoom_zoom_out_meta_key_handler_func (MetaDisplay* display,
                                                MetaWindow* window,
                                                const ClutterKeyEvent* event,
                                                MetaKeyBinding* binding,
                                                gpointer self);
VALA_EXTERN GType gala_super_scroll_action_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaSuperScrollAction, g_object_unref)
VALA_EXTERN GalaSuperScrollAction* gala_super_scroll_action_new (MetaDisplay* display);
VALA_EXTERN GalaSuperScrollAction* gala_super_scroll_action_construct (GType object_type,
                                                           MetaDisplay* display);
static gboolean gala_zoom_handle_super_scroll (GalaZoom* self,
                                        guint32 timestamp,
                                        gdouble dx,
                                        gdouble dy);
static gboolean _gala_zoom_handle_super_scroll_gala_super_scroll_action_triggered (GalaSuperScrollAction* _sender,
                                                                            guint32 timestamp,
                                                                            gdouble dx,
                                                                            gdouble dy,
                                                                            gpointer self);
static void gala_zoom_zoom (GalaZoom* self,
                     gfloat delta,
                     gboolean play_sound);
VALA_EXTERN void gala_internal_utils_bell_notify (MetaDisplay* display);
static void gala_zoom_real_propagate (GalaGestureTarget* base,
                               GalaGestureTargetUpdateType update_type,
                               GalaGestureAction action,
                               gdouble progress);
static void gala_zoom_update_ui (GalaZoom* self);
static inline void gala_zoom_compute_new_pivot_point (GalaZoom* self,
                                        graphene_point_t* result);
static Block31Data* block31_data_ref (Block31Data* _data31_);
static void block31_data_unref (void * _userdata_);
static gboolean ___lambda107_ (Block31Data* _data31_);
static void _vala_graphene_point_t_free (graphene_point_t* self);
static gboolean ____lambda107__gsource_func (gpointer self);
static void gala_zoom_set_wm (GalaZoom* self,
                       GalaWindowManager* value);
static void gala_zoom_finalize (GObject * obj);
static GType gala_zoom_get_type_once (void);
static void _vala_gala_zoom_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec);
static void _vala_gala_zoom_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec);

static inline gpointer
gala_zoom_get_instance_private (GalaZoom* self)
{
	return G_STRUCT_MEMBER_P (self, GalaZoom_private_offset);
}

static void
_gala_zoom_zoom_in_meta_key_handler_func (MetaDisplay* display,
                                          MetaWindow* window,
                                          const ClutterKeyEvent* event,
                                          MetaKeyBinding* binding,
                                          gpointer self)
{
	gala_zoom_zoom_in ((GalaZoom*) self, display, window, event, binding);
}

static void
_gala_zoom_zoom_out_meta_key_handler_func (MetaDisplay* display,
                                           MetaWindow* window,
                                           const ClutterKeyEvent* event,
                                           MetaKeyBinding* binding,
                                           gpointer self)
{
	gala_zoom_zoom_out ((GalaZoom*) self, display, window, event, binding);
}

static gboolean
_gala_zoom_handle_super_scroll_gala_super_scroll_action_triggered (GalaSuperScrollAction* _sender,
                                                                   guint32 timestamp,
                                                                   gdouble dx,
                                                                   gdouble dy,
                                                                   gpointer self)
{
	gboolean result;
	result = gala_zoom_handle_super_scroll ((GalaZoom*) self, timestamp, dx, dy);
	return result;
}

GalaZoom*
gala_zoom_construct (GType object_type,
                     GalaWindowManager* wm)
{
	GalaZoom * self = NULL;
	MetaDisplay* display = NULL;
	MetaDisplay* _tmp0_;
	GSettings* schema = NULL;
	GSettings* _tmp1_;
	GalaGestureController* _tmp2_ = NULL;
	GalaGestureController* _tmp3_;
	ClutterStage* _tmp4_;
	ClutterStage* _tmp5_;
	GalaGestureController* _tmp6_;
	GSettings* _tmp7_;
	GalaSuperScrollAction* scroll_action = NULL;
	GalaSuperScrollAction* _tmp8_;
	ClutterActor* _tmp9_;
	g_return_val_if_fail (wm != NULL, NULL);
	self = (GalaZoom*) g_object_new (object_type, "wm", wm, NULL);
	_tmp0_ = meta_plugin_get_display ((MetaPlugin*) wm);
	display = _tmp0_;
	_tmp1_ = g_settings_new ("io.elementary.desktop.wm.keybindings");
	schema = _tmp1_;
	meta_display_add_keybinding (display, "zoom-in", schema, META_KEY_BINDING_NONE, _gala_zoom_zoom_in_meta_key_handler_func, g_object_ref (self), g_object_unref);
	meta_display_add_keybinding (display, "zoom-out", schema, META_KEY_BINDING_NONE, _gala_zoom_zoom_out_meta_key_handler_func, g_object_ref (self), g_object_unref);
	_tmp2_ = gala_gesture_controller_new (GALA_GESTURE_ACTION_ZOOM, wm, GALA_GESTURE_CONTROLLER_GROUP_NONE);
	gala_gesture_controller_set_snap (_tmp2_, FALSE);
	_g_object_unref0 (self->priv->gesture_controller);
	self->priv->gesture_controller = _tmp2_;
	_tmp3_ = self->priv->gesture_controller;
	_tmp4_ = gala_window_manager_get_stage (wm);
	_tmp5_ = _tmp4_;
	gala_gesture_controller_enable_touchpad (_tmp3_, (ClutterActor*) _tmp5_);
	_tmp6_ = self->priv->gesture_controller;
	gala_root_target_add_gesture_controller ((GalaRootTarget*) self, _tmp6_);
	_tmp7_ = g_settings_new ("io.elementary.desktop.wm.behavior");
	_g_object_unref0 (self->priv->behavior_settings);
	self->priv->behavior_settings = _tmp7_;
	_tmp8_ = gala_super_scroll_action_new (display);
	g_object_ref_sink (_tmp8_);
	scroll_action = _tmp8_;
	g_signal_connect_object (scroll_action, "triggered", (GCallback) _gala_zoom_handle_super_scroll_gala_super_scroll_action_triggered, self, 0);
	_tmp9_ = meta_get_stage_for_display (display);
	clutter_actor_add_action_full (_tmp9_, "zoom-super-scroll-action", CLUTTER_PHASE_CAPTURE, (ClutterAction*) scroll_action);
	_g_object_unref0 (scroll_action);
	_g_object_unref0 (schema);
	return self;
}

GalaZoom*
gala_zoom_new (GalaWindowManager* wm)
{
	return gala_zoom_construct (GALA_TYPE_ZOOM, wm);
}

static void
gala_zoom_zoom_in (GalaZoom* self,
                   MetaDisplay* display,
                   MetaWindow* window,
                   ClutterKeyEvent* event,
                   MetaKeyBinding* binding)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (display != NULL);
	g_return_if_fail (binding != NULL);
	gala_zoom_zoom (self, GALA_ZOOM_SHORTCUT_DELTA, TRUE);
}

static void
gala_zoom_zoom_out (GalaZoom* self,
                    MetaDisplay* display,
                    MetaWindow* window,
                    ClutterKeyEvent* event,
                    MetaKeyBinding* binding)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (display != NULL);
	g_return_if_fail (binding != NULL);
	gala_zoom_zoom (self, -GALA_ZOOM_SHORTCUT_DELTA, TRUE);
}

static gboolean
gala_zoom_handle_super_scroll (GalaZoom* self,
                               guint32 timestamp,
                               gdouble dx,
                               gdouble dy)
{
	GSettings* _tmp0_;
	gdouble _tmp1_ = 0.0;
	gdouble d = 0.0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->behavior_settings;
	if (g_settings_get_enum (_tmp0_, "super-scroll-action") != 2) {
		result = CLUTTER_EVENT_PROPAGATE;
		return result;
	}
	if (fabs (dx) > fabs (dy)) {
		_tmp1_ = dx;
	} else {
		_tmp1_ = dy;
	}
	d = _tmp1_;
	if (d > ((gdouble) 0)) {
		gala_zoom_zoom (self, GALA_ZOOM_SHORTCUT_DELTA, TRUE);
	} else {
		if (d < ((gdouble) 0)) {
			gala_zoom_zoom (self, -GALA_ZOOM_SHORTCUT_DELTA, TRUE);
		}
	}
	result = CLUTTER_EVENT_STOP;
	return result;
}

static void
gala_zoom_zoom (GalaZoom* self,
                gfloat delta,
                gboolean play_sound)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GalaGestureController* _tmp5_;
	g_return_if_fail (self != NULL);
	if (self->priv->current_zoom <= GALA_ZOOM_MIN_ZOOM) {
		_tmp1_ = delta < ((gfloat) 0);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		if (self->priv->current_zoom >= GALA_ZOOM_MAX_ZOOM) {
			_tmp2_ = delta >= ((gfloat) 0);
		} else {
			_tmp2_ = FALSE;
		}
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		if (play_sound) {
			GalaWindowManager* _tmp3_;
			MetaDisplay* _tmp4_;
			_tmp3_ = self->priv->_wm;
			_tmp4_ = meta_plugin_get_display ((MetaPlugin*) _tmp3_);
			gala_internal_utils_bell_notify (_tmp4_);
		}
		return;
	}
	_tmp5_ = self->priv->gesture_controller;
	gala_gesture_controller_goto (_tmp5_, self->priv->current_commit + (delta / 10));
}

static void
gala_zoom_real_propagate (GalaGestureTarget* base,
                          GalaGestureTargetUpdateType update_type,
                          GalaGestureAction action,
                          gdouble progress)
{
	GalaZoom * self;
	self = (GalaZoom*) base;
	switch (update_type) {
		case GALA_GESTURE_TARGET_UPDATE_TYPE_COMMIT:
		{
			self->priv->current_commit = progress;
			break;
		}
		case GALA_GESTURE_TARGET_UPDATE_TYPE_UPDATE:
		{
			gfloat target_zoom = 0.0F;
			target_zoom = (((gfloat) progress) * 10) + 1;
			if (!meta_prefs_get_gnome_animations ()) {
				gfloat delta = 0.0F;
				delta = target_zoom - self->priv->current_zoom;
				if (fabsf (delta) >= (GALA_ZOOM_SHORTCUT_DELTA - FLT_EPSILON)) {
					gfloat _tmp0_ = 0.0F;
					if (delta > ((gfloat) 0)) {
						_tmp0_ = GALA_ZOOM_SHORTCUT_DELTA;
					} else {
						_tmp0_ = -GALA_ZOOM_SHORTCUT_DELTA;
					}
					target_zoom = self->priv->current_zoom + _tmp0_;
				} else {
					return;
				}
			}
			self->priv->current_zoom = target_zoom;
			gala_zoom_update_ui (self);
			break;
		}
		default:
		{
			break;
		}
	}
}

static inline void
gala_zoom_compute_new_pivot_point (GalaZoom* self,
                                   graphene_point_t* result)
{
	ClutterActor* wins = NULL;
	GalaWindowManager* _tmp0_;
	ClutterActor* _tmp1_;
	ClutterActor* _tmp2_;
	graphene_point_t coords = {0};
	MetaCursorTracker* tracker = NULL;
	GalaWindowManager* _tmp3_;
	MetaDisplay* _tmp4_;
	MetaCursorTracker* _tmp5_;
	graphene_point_t _tmp6_ = {0};
	graphene_point_t new_pivot = {0};
	graphene_point_t _tmp7_;
	gfloat _tmp8_;
	gfloat _tmp9_;
	graphene_point_t _tmp10_;
	gfloat _tmp11_;
	gfloat _tmp12_;
	graphene_point_t _tmp13_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = gala_window_manager_get_ui_group (_tmp0_);
	_tmp2_ = _tmp1_;
	wins = _tmp2_;
	_tmp3_ = self->priv->_wm;
	_tmp4_ = meta_plugin_get_display ((MetaPlugin*) _tmp3_);
	_tmp5_ = meta_cursor_tracker_get_for_display (_tmp4_);
	tracker = _tmp5_;
	meta_cursor_tracker_get_pointer (tracker, &_tmp6_, NULL);
	coords = _tmp6_;
	_tmp7_ = coords;
	_tmp8_ = clutter_actor_get_width (wins);
	_tmp9_ = _tmp8_;
	_tmp10_ = coords;
	_tmp11_ = clutter_actor_get_height (wins);
	_tmp12_ = _tmp11_;
	memset (&_tmp13_, 0, sizeof (graphene_point_t));
	_tmp13_.x = _tmp7_.x / _tmp9_;
	_tmp13_.y = _tmp10_.y / _tmp12_;
	new_pivot = _tmp13_;
	*result = new_pivot;
	return;
}

static Block31Data*
block31_data_ref (Block31Data* _data31_)
{
	g_atomic_int_inc (&_data31_->_ref_count_);
	return _data31_;
}

static void
block31_data_unref (void * _userdata_)
{
	Block31Data* _data31_;
	_data31_ = (Block31Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data31_->_ref_count_)) {
		GalaZoom* self;
		self = _data31_->self;
		_g_object_unref0 (self);
		g_slice_free (Block31Data, _data31_);
	}
}

static void
_vala_graphene_point_t_free (graphene_point_t* self)
{
	g_boxed_free (graphene_point_get_type (), self);
}

static gboolean
___lambda107_ (Block31Data* _data31_)
{
	GalaZoom* self;
	graphene_point_t new_pivot = {0};
	graphene_point_t _tmp0_ = {0};
	ClutterActor* _tmp1_;
	graphene_point_t* _tmp2_;
	graphene_point_t* _tmp3_;
	graphene_point_t* _tmp4_;
	graphene_point_t _tmp5_;
	gboolean _tmp6_;
	ClutterActor* _tmp7_;
	ClutterActor* _tmp8_;
	ClutterActor* _tmp9_;
	ClutterActor* _tmp10_;
	graphene_point_t _tmp11_;
	ClutterActor* _tmp12_;
	gboolean result;
	self = _data31_->self;
	gala_zoom_compute_new_pivot_point (self, &_tmp0_);
	new_pivot = _tmp0_;
	_tmp1_ = _data31_->wins;
	g_object_get (_tmp1_, "pivot-point", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = new_pivot;
	_tmp6_ = graphene_point_equal (_tmp4_, &_tmp5_);
	__vala_graphene_point_t_free0 (_tmp4_);
	if (_tmp6_) {
		result = TRUE;
		return result;
	}
	_tmp7_ = _data31_->wins;
	clutter_actor_save_easing_state (_tmp7_);
	_tmp8_ = _data31_->wins;
	clutter_actor_set_easing_mode (_tmp8_, CLUTTER_LINEAR);
	_tmp9_ = _data31_->wins;
	clutter_actor_set_easing_duration (_tmp9_, GALA_ZOOM_MOUSE_POLL_TIME);
	_tmp10_ = _data31_->wins;
	_tmp11_ = new_pivot;
	g_object_set (_tmp10_, "pivot-point", &_tmp11_, NULL);
	_tmp12_ = _data31_->wins;
	clutter_actor_restore_easing_state (_tmp12_);
	result = TRUE;
	return result;
}

static gboolean
____lambda107__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda107_ (self);
	return result;
}

static void
gala_zoom_update_ui (GalaZoom* self)
{
	Block31Data* _data31_;
	GalaWindowManager* _tmp0_;
	ClutterActor* _tmp1_;
	ClutterActor* _tmp2_;
	ClutterActor* _tmp8_;
	g_return_if_fail (self != NULL);
	_data31_ = g_slice_new0 (Block31Data);
	_data31_->_ref_count_ = 1;
	_data31_->self = g_object_ref (self);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = gala_window_manager_get_ui_group (_tmp0_);
	_tmp2_ = _tmp1_;
	_data31_->wins = _tmp2_;
	if (self->priv->mouse_poll_timer == ((guint) 0)) {
		ClutterActor* _tmp3_;
		graphene_point_t _tmp4_ = {0};
		_tmp3_ = _data31_->wins;
		gala_zoom_compute_new_pivot_point (self, &_tmp4_);
		g_object_set (_tmp3_, "pivot-point", &_tmp4_, NULL);
		self->priv->mouse_poll_timer = g_timeout_add_full (G_PRIORITY_DEFAULT, GALA_ZOOM_MOUSE_POLL_TIME, ____lambda107__gsource_func, block31_data_ref (_data31_), block31_data_unref);
	}
	if (self->priv->wins_handler_id > ((gulong) 0)) {
		ClutterActor* _tmp5_;
		_tmp5_ = _data31_->wins;
		g_signal_handler_disconnect ((GObject*) _tmp5_, self->priv->wins_handler_id);
		self->priv->wins_handler_id = (gulong) 0;
	}
	if (self->priv->current_zoom <= GALA_ZOOM_MIN_ZOOM) {
		ClutterActor* _tmp6_;
		ClutterActor* _tmp7_;
		self->priv->current_zoom = GALA_ZOOM_MIN_ZOOM;
		if (self->priv->mouse_poll_timer > ((guint) 0)) {
			g_source_remove (self->priv->mouse_poll_timer);
			self->priv->mouse_poll_timer = (guint) 0;
		}
		_tmp6_ = _data31_->wins;
		clutter_actor_set_scale (_tmp6_, (gdouble) GALA_ZOOM_MIN_ZOOM, (gdouble) GALA_ZOOM_MIN_ZOOM);
		_tmp7_ = _data31_->wins;
		clutter_actor_set_pivot_point (_tmp7_, 0.0f, 0.0f);
		block31_data_unref (_data31_);
		_data31_ = NULL;
		return;
	}
	_tmp8_ = _data31_->wins;
	clutter_actor_set_scale (_tmp8_, (gdouble) self->priv->current_zoom, (gdouble) self->priv->current_zoom);
	block31_data_unref (_data31_);
	_data31_ = NULL;
}

GalaWindowManager*
gala_zoom_get_wm (GalaZoom* self)
{
	GalaWindowManager* result;
	GalaWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gala_zoom_set_wm (GalaZoom* self,
                  GalaWindowManager* value)
{
	GalaWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_zoom_get_wm (self);
	if (old_value != value) {
		GalaWindowManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_zoom_properties[GALA_ZOOM_WM_PROPERTY]);
	}
}

static ClutterActor*
gala_zoom_real_get_actor (GalaRootTarget* base)
{
	ClutterActor* result;
	GalaZoom* self;
	GalaWindowManager* _tmp0_;
	ClutterActor* _tmp1_;
	ClutterActor* _tmp2_;
	self = (GalaZoom*) base;
	_tmp0_ = self->priv->_wm;
	_tmp1_ = gala_window_manager_get_ui_group (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
gala_zoom_class_init (GalaZoomClass * klass,
                      gpointer klass_data)
{
	gala_zoom_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaZoom_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_zoom_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_zoom_set_property;
	G_OBJECT_CLASS (klass)->finalize = gala_zoom_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_ZOOM_WM_PROPERTY, gala_zoom_properties[GALA_ZOOM_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GALA_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_ZOOM_ACTOR_PROPERTY, gala_zoom_properties[GALA_ZOOM_ACTOR_PROPERTY] = g_param_spec_object ("actor", "actor", "actor", clutter_actor_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
gala_zoom_gala_gesture_target_interface_init (GalaGestureTargetIface * iface,
                                              gpointer iface_data)
{
	gala_zoom_gala_gesture_target_parent_iface = g_type_interface_peek_parent (iface);
	iface->propagate = (void (*) (GalaGestureTarget*, GalaGestureTargetUpdateType, GalaGestureAction, gdouble)) gala_zoom_real_propagate;
}

static void
gala_zoom_gala_root_target_interface_init (GalaRootTargetIface * iface,
                                           gpointer iface_data)
{
	gala_zoom_gala_root_target_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_actor = gala_zoom_real_get_actor;
}

static void
gala_zoom_instance_init (GalaZoom * self,
                         gpointer klass)
{
	self->priv = gala_zoom_get_instance_private (self);
	self->priv->mouse_poll_timer = (guint) 0;
	self->priv->current_zoom = GALA_ZOOM_MIN_ZOOM;
	self->priv->wins_handler_id = 0UL;
	self->priv->current_commit = (gdouble) 0;
}

static void
gala_zoom_finalize (GObject * obj)
{
	GalaZoom * self;
	GalaWindowManager* _tmp0_;
	MetaDisplay* display = NULL;
	GalaWindowManager* _tmp1_;
	MetaDisplay* _tmp2_;
	MetaDisplay* _tmp3_;
	MetaDisplay* _tmp4_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_ZOOM, GalaZoom);
	_tmp0_ = self->priv->_wm;
	if (_tmp0_ == NULL) {
		goto _return;
	}
	_tmp1_ = self->priv->_wm;
	_tmp2_ = meta_plugin_get_display ((MetaPlugin*) _tmp1_);
	display = _tmp2_;
	_tmp3_ = display;
	meta_display_remove_keybinding (_tmp3_, "zoom-in");
	_tmp4_ = display;
	meta_display_remove_keybinding (_tmp4_, "zoom-out");
	if (self->priv->mouse_poll_timer > ((guint) 0)) {
		g_source_remove (self->priv->mouse_poll_timer);
		self->priv->mouse_poll_timer = (guint) 0;
	}
	_return:
	_g_object_unref0 (self->priv->_wm);
	_g_object_unref0 (self->priv->gesture_controller);
	_g_object_unref0 (self->priv->behavior_settings);
	G_OBJECT_CLASS (gala_zoom_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gala_zoom_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaZoomClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_zoom_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaZoom), 0, (GInstanceInitFunc) gala_zoom_instance_init, NULL };
	static const GInterfaceInfo gala_gesture_target_info = { (GInterfaceInitFunc) gala_zoom_gala_gesture_target_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gala_root_target_info = { (GInterfaceInitFunc) gala_zoom_gala_root_target_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gala_zoom_type_id;
	gala_zoom_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaZoom", &g_define_type_info, 0);
	g_type_add_interface_static (gala_zoom_type_id, GALA_TYPE_GESTURE_TARGET, &gala_gesture_target_info);
	g_type_add_interface_static (gala_zoom_type_id, GALA_TYPE_ROOT_TARGET, &gala_root_target_info);
	GalaZoom_private_offset = g_type_add_instance_private (gala_zoom_type_id, sizeof (GalaZoomPrivate));
	return gala_zoom_type_id;
}

GType
gala_zoom_get_type (void)
{
	static gsize gala_zoom_type_id__once = 0;
	if (g_once_init_enter (&gala_zoom_type_id__once)) {
		GType gala_zoom_type_id;
		gala_zoom_type_id = gala_zoom_get_type_once ();
		g_once_init_leave (&gala_zoom_type_id__once, gala_zoom_type_id);
	}
	return gala_zoom_type_id__once;
}

static void
_vala_gala_zoom_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec)
{
	GalaZoom * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_ZOOM, GalaZoom);
	switch (property_id) {
		case GALA_ZOOM_WM_PROPERTY:
		g_value_set_object (value, gala_zoom_get_wm (self));
		break;
		case GALA_ZOOM_ACTOR_PROPERTY:
		g_value_set_object (value, gala_root_target_get_actor ((GalaRootTarget*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_zoom_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec)
{
	GalaZoom * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_ZOOM, GalaZoom);
	switch (property_id) {
		case GALA_ZOOM_WM_PROPERTY:
		gala_zoom_set_wm (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

