/* StyleManager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from StyleManager.vala, do not modify */

/*
 * Copyright 2024 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 * Authored by: Leonhard Kargl <leo.kargl@proton.me>
 */

#include "gala.h"
#include <clutter/clutter.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define GALA_DRAWING_STYLE_MANAGER_FDO_ACCOUNTS_NAME "org.freedesktop.Accounts"
#define GALA_DRAWING_STYLE_MANAGER_FDO_ACCOUNTS_PATH "/org/freedesktop/Accounts"
#define GALA_DRAWING_STYLE_MANAGER_ACCENT_COLOR_ALPHA ((guint8) 64)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GALA_DRAWING_STYLE_MANAGER_TYPE_PANTHEON_ACCOUNTS_SERVICE (gala_drawing_style_manager_pantheon_accounts_service_get_type ())
#define GALA_DRAWING_STYLE_MANAGER_PANTHEON_ACCOUNTS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_DRAWING_STYLE_MANAGER_TYPE_PANTHEON_ACCOUNTS_SERVICE, GalaDrawingStyleManagerPantheonAccountsService))
#define GALA_DRAWING_STYLE_MANAGER_IS_PANTHEON_ACCOUNTS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_DRAWING_STYLE_MANAGER_TYPE_PANTHEON_ACCOUNTS_SERVICE))
#define GALA_DRAWING_STYLE_MANAGER_PANTHEON_ACCOUNTS_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GALA_DRAWING_STYLE_MANAGER_TYPE_PANTHEON_ACCOUNTS_SERVICE, GalaDrawingStyleManagerPantheonAccountsServiceIface))

typedef struct _GalaDrawingStyleManagerPantheonAccountsService GalaDrawingStyleManagerPantheonAccountsService;
typedef struct _GalaDrawingStyleManagerPantheonAccountsServiceIface GalaDrawingStyleManagerPantheonAccountsServiceIface;

#define GALA_DRAWING_STYLE_MANAGER_TYPE_PANTHEON_ACCOUNTS_SERVICE_PROXY (gala_drawing_style_manager_pantheon_accounts_service_proxy_get_type ())

#define GALA_DRAWING_STYLE_MANAGER_TYPE_SETTINGS_DAEMON_ACCOUNTS_SERVICE (gala_drawing_style_manager_settings_daemon_accounts_service_get_type ())
#define GALA_DRAWING_STYLE_MANAGER_SETTINGS_DAEMON_ACCOUNTS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_DRAWING_STYLE_MANAGER_TYPE_SETTINGS_DAEMON_ACCOUNTS_SERVICE, GalaDrawingStyleManagerSettingsDaemonAccountsService))
#define GALA_DRAWING_STYLE_MANAGER_IS_SETTINGS_DAEMON_ACCOUNTS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_DRAWING_STYLE_MANAGER_TYPE_SETTINGS_DAEMON_ACCOUNTS_SERVICE))
#define GALA_DRAWING_STYLE_MANAGER_SETTINGS_DAEMON_ACCOUNTS_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GALA_DRAWING_STYLE_MANAGER_TYPE_SETTINGS_DAEMON_ACCOUNTS_SERVICE, GalaDrawingStyleManagerSettingsDaemonAccountsServiceIface))

typedef struct _GalaDrawingStyleManagerSettingsDaemonAccountsService GalaDrawingStyleManagerSettingsDaemonAccountsService;
typedef struct _GalaDrawingStyleManagerSettingsDaemonAccountsServiceIface GalaDrawingStyleManagerSettingsDaemonAccountsServiceIface;

#define GALA_DRAWING_STYLE_MANAGER_TYPE_SETTINGS_DAEMON_ACCOUNTS_SERVICE_PROXY (gala_drawing_style_manager_settings_daemon_accounts_service_proxy_get_type ())
enum  {
	GALA_DRAWING_STYLE_MANAGER_0_PROPERTY,
	GALA_DRAWING_STYLE_MANAGER_PREFERS_COLOR_SCHEME_PROPERTY,
	GALA_DRAWING_STYLE_MANAGER_THEME_ACCENT_COLOR_PROPERTY,
	GALA_DRAWING_STYLE_MANAGER_NUM_PROPERTIES
};
static GParamSpec* gala_drawing_style_manager_properties[GALA_DRAWING_STYLE_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GALA_DRAWING_STYLE_MANAGER_TYPE_ACCOUNTS (gala_drawing_style_manager_accounts_get_type ())
#define GALA_DRAWING_STYLE_MANAGER_ACCOUNTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_DRAWING_STYLE_MANAGER_TYPE_ACCOUNTS, GalaDrawingStyleManagerAccounts))
#define GALA_DRAWING_STYLE_MANAGER_IS_ACCOUNTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_DRAWING_STYLE_MANAGER_TYPE_ACCOUNTS))
#define GALA_DRAWING_STYLE_MANAGER_ACCOUNTS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GALA_DRAWING_STYLE_MANAGER_TYPE_ACCOUNTS, GalaDrawingStyleManagerAccountsIface))

typedef struct _GalaDrawingStyleManagerAccounts GalaDrawingStyleManagerAccounts;
typedef struct _GalaDrawingStyleManagerAccountsIface GalaDrawingStyleManagerAccountsIface;

#define GALA_DRAWING_STYLE_MANAGER_TYPE_ACCOUNTS_PROXY (gala_drawing_style_manager_accounts_proxy_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _GalaDrawingStyleManagerConnectToAccountsServiceData GalaDrawingStyleManagerConnectToAccountsServiceData;
typedef GDBusProxy GalaDrawingStyleManagerAccountsProxy;
typedef GDBusProxyClass GalaDrawingStyleManagerAccountsProxyClass;
typedef struct _GalaDrawingStyleManagerAccountsFindUserByNameReadyData GalaDrawingStyleManagerAccountsFindUserByNameReadyData;
typedef GDBusProxy GalaDrawingStyleManagerPantheonAccountsServiceProxy;
typedef GDBusProxyClass GalaDrawingStyleManagerPantheonAccountsServiceProxyClass;
typedef GDBusProxy GalaDrawingStyleManagerSettingsDaemonAccountsServiceProxy;
typedef GDBusProxyClass GalaDrawingStyleManagerSettingsDaemonAccountsServiceProxyClass;

struct _GalaDrawingStyleManagerPantheonAccountsServiceIface {
	GTypeInterface parent_iface;
	gint (*get_prefers_color_scheme) (GalaDrawingStyleManagerPantheonAccountsService* self);
	void (*set_prefers_color_scheme) (GalaDrawingStyleManagerPantheonAccountsService* self, gint value);
	gint (*get_prefers_accent_color) (GalaDrawingStyleManagerPantheonAccountsService* self);
	void (*set_prefers_accent_color) (GalaDrawingStyleManagerPantheonAccountsService* self, gint value);
};

struct _GalaDrawingStyleManagerSettingsDaemonAccountsServiceIface {
	GTypeInterface parent_iface;
	gint (*get_accent_color) (GalaDrawingStyleManagerSettingsDaemonAccountsService* self);
	void (*set_accent_color) (GalaDrawingStyleManagerSettingsDaemonAccountsService* self, gint value);
};

struct _GalaDrawingStyleManagerPrivate {
	GalaDrawingStyleManagerColorScheme _prefers_color_scheme;
	ClutterColor _theme_accent_color;
	GalaDrawingStyleManagerPantheonAccountsService* pantheon_proxy;
	GalaDrawingStyleManagerSettingsDaemonAccountsService* settings_daemon_proxy;
};

struct _GalaDrawingStyleManagerAccountsIface {
	GTypeInterface parent_iface;
	void (*find_user_by_name) (GalaDrawingStyleManagerAccounts* self, const gchar* name, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar* (*find_user_by_name_finish) (GalaDrawingStyleManagerAccounts* self, GAsyncResult* _res_, GError** error);
};

struct _GalaDrawingStyleManagerConnectToAccountsServiceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GalaDrawingStyleManager* self;
	GalaDrawingStyleManagerAccounts* accounts;
	GalaDrawingStyleManagerAccounts* _tmp0_;
	gchar* path;
	GalaDrawingStyleManagerAccounts* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GalaDrawingStyleManagerPantheonAccountsService* _tmp4_;
	const gchar* _tmp5_;
	GalaDrawingStyleManagerPantheonAccountsService* _tmp6_;
	GalaDrawingStyleManagerPantheonAccountsService* _tmp7_;
	GalaDrawingStyleManagerSettingsDaemonAccountsService* _tmp8_;
	const gchar* _tmp9_;
	GalaDrawingStyleManagerSettingsDaemonAccountsService* _tmp10_;
	GalaDrawingStyleManagerSettingsDaemonAccountsService* _tmp11_;
	GalaDrawingStyleManagerPantheonAccountsService* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	GalaDrawingStyleManagerSettingsDaemonAccountsService* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	GalaDrawingStyleManagerPantheonAccountsService* _tmp18_;
	GalaDrawingStyleManagerSettingsDaemonAccountsService* _tmp19_;
	GError* _inner_error0_;
};

struct _GalaDrawingStyleManagerAccountsFindUserByNameReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar* name;
};

static gint GalaDrawingStyleManager_private_offset;
static gpointer gala_drawing_style_manager_parent_class = NULL;
static GOnce gala_drawing_style_manager_instance;
static GOnce gala_drawing_style_manager_instance = G_ONCE_INIT;

static GType gala_drawing_style_manager_pantheon_accounts_service_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
VALA_EXTERN GType gala_drawing_style_manager_pantheon_accounts_service_proxy_get_type (void) G_GNUC_CONST ;
static guint gala_drawing_style_manager_pantheon_accounts_service_register_object (void* object,
                                                                            GDBusConnection* connection,
                                                                            const gchar* path,
                                                                            GError** error);
static GType gala_drawing_style_manager_settings_daemon_accounts_service_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
VALA_EXTERN GType gala_drawing_style_manager_settings_daemon_accounts_service_proxy_get_type (void) G_GNUC_CONST ;
static guint gala_drawing_style_manager_settings_daemon_accounts_service_register_object (void* object,
                                                                                   GDBusConnection* connection,
                                                                                   const gchar* path,
                                                                                   GError** error);
static GalaDrawingStyleManager* __lambda16_ (void);
static gpointer ___lambda16__gthread_func (gpointer self);
static void gala_drawing_style_manager_connect_to_accounts_service_data_free (gpointer _data);
static void gala_drawing_style_manager_connect_to_accounts_service (GalaDrawingStyleManager* self,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
static void gala_drawing_style_manager_connect_to_accounts_service_finish (GalaDrawingStyleManager* self,
                                                                    GAsyncResult* _res_);
static gboolean gala_drawing_style_manager_connect_to_accounts_service_co (GalaDrawingStyleManagerConnectToAccountsServiceData* _data_);
VALA_EXTERN GType gala_drawing_style_manager_accounts_proxy_get_type (void) G_GNUC_CONST ;
static guint gala_drawing_style_manager_accounts_register_object (void* object,
                                                           GDBusConnection* connection,
                                                           const gchar* path,
                                                           GError** error);
static GType gala_drawing_style_manager_accounts_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void gala_drawing_style_manager_connect_to_accounts_service_ready (GObject* source_object,
                                                                   GAsyncResult* _res_,
                                                                   gpointer _user_data_);
static void gala_drawing_style_manager_accounts_find_user_by_name (GalaDrawingStyleManagerAccounts* self,
                                                            const gchar* name,
                                                            GAsyncReadyCallback _callback_,
                                                            gpointer _user_data_);
static gchar* gala_drawing_style_manager_accounts_find_user_by_name_finish (GalaDrawingStyleManagerAccounts* self,
                                                                     GAsyncResult* _res_,
                                                                     GError** error);
static void gala_drawing_style_manager_update_color_scheme (GalaDrawingStyleManager* self,
                                                     gint color_scheme);
 G_GNUC_INTERNAL gint gala_drawing_style_manager_pantheon_accounts_service_get_prefers_color_scheme (GalaDrawingStyleManagerPantheonAccountsService* self);
static void gala_drawing_style_manager_update_color (GalaDrawingStyleManager* self,
                                              gint color);
 G_GNUC_INTERNAL gint gala_drawing_style_manager_settings_daemon_accounts_service_get_accent_color (GalaDrawingStyleManagerSettingsDaemonAccountsService* self);
static void __lambda17_ (GalaDrawingStyleManager* self,
                  GVariant* changed,
                  gchar** invalid);
static void ___lambda17__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                     GVariant* changed_properties,
                                                     gchar** invalidated_properties,
                                                     gpointer self);
static void __lambda18_ (GalaDrawingStyleManager* self,
                  GVariant* changed,
                  gchar** invalid);
static void ___lambda18__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                     GVariant* changed_properties,
                                                     gchar** invalidated_properties,
                                                     gpointer self);
static void gala_drawing_style_manager_set_prefers_color_scheme (GalaDrawingStyleManager* self,
                                                          GalaDrawingStyleManagerColorScheme value);
static gint gala_drawing_style_manager_get_color (GalaDrawingStyleManager* self,
                                           gint color);
static void gala_drawing_style_manager_set_theme_accent_color (GalaDrawingStyleManager* self,
                                                        ClutterColor * value);
static gboolean _clutter_color_equal (const ClutterColor * s1,
                               const ClutterColor * s2);
static GType gala_drawing_style_manager_accounts_get_type_once (void);
static void gala_drawing_style_manager_accounts_proxy_g_signal (GDBusProxy* proxy,
                                                         const gchar* sender_name,
                                                         const gchar* signal_name,
                                                         GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object,
                                   GAsyncResult *res,
                                   void *user_data);
static void gala_drawing_style_manager_accounts_proxy_find_user_by_name_async (GalaDrawingStyleManagerAccounts* self,
                                                                        const gchar* name,
                                                                        GAsyncReadyCallback _callback_,
                                                                        gpointer _user_data_);
static gchar* gala_drawing_style_manager_accounts_proxy_find_user_by_name_finish (GalaDrawingStyleManagerAccounts* self,
                                                                           GAsyncResult* _res_,
                                                                           GError** error);
static void gala_drawing_style_manager_accounts_proxy_gala_drawing_style_manager_accounts_interface_init (GalaDrawingStyleManagerAccountsIface* iface);
static void _dbus_gala_drawing_style_manager_accounts_find_user_by_name (GalaDrawingStyleManagerAccounts* self,
                                                                  GVariant* _parameters_,
                                                                  GDBusMethodInvocation* invocation);
static void _dbus_gala_drawing_style_manager_accounts_find_user_by_name_ready (GObject * source_object,
                                                                        GAsyncResult * _res_,
                                                                        gpointer _user_data_);
static void gala_drawing_style_manager_accounts_dbus_interface_method_call (GDBusConnection* connection,
                                                                     const gchar* sender,
                                                                     const gchar* object_path,
                                                                     const gchar* interface_name,
                                                                     const gchar* method_name,
                                                                     GVariant* parameters,
                                                                     GDBusMethodInvocation* invocation,
                                                                     gpointer user_data);
static GVariant* gala_drawing_style_manager_accounts_dbus_interface_get_property (GDBusConnection* connection,
                                                                           const gchar* sender,
                                                                           const gchar* object_path,
                                                                           const gchar* interface_name,
                                                                           const gchar* property_name,
                                                                           GError** error,
                                                                           gpointer user_data);
static gboolean gala_drawing_style_manager_accounts_dbus_interface_set_property (GDBusConnection* connection,
                                                                          const gchar* sender,
                                                                          const gchar* object_path,
                                                                          const gchar* interface_name,
                                                                          const gchar* property_name,
                                                                          GVariant* value,
                                                                          GError** error,
                                                                          gpointer user_data);
static void _gala_drawing_style_manager_accounts_unregister_object (gpointer user_data);
 G_GNUC_INTERNAL void gala_drawing_style_manager_pantheon_accounts_service_set_prefers_color_scheme (GalaDrawingStyleManagerPantheonAccountsService* self,
                                                                                    gint value);
 G_GNUC_INTERNAL gint gala_drawing_style_manager_pantheon_accounts_service_get_prefers_accent_color (GalaDrawingStyleManagerPantheonAccountsService* self);
 G_GNUC_INTERNAL void gala_drawing_style_manager_pantheon_accounts_service_set_prefers_accent_color (GalaDrawingStyleManagerPantheonAccountsService* self,
                                                                                    gint value);
static GType gala_drawing_style_manager_pantheon_accounts_service_get_type_once (void);
static void gala_drawing_style_manager_pantheon_accounts_service_proxy_g_signal (GDBusProxy* proxy,
                                                                          const gchar* sender_name,
                                                                          const gchar* signal_name,
                                                                          GVariant* parameters);
static gint gala_drawing_style_manager_pantheon_accounts_service_dbus_proxy_get_prefers_color_scheme (GalaDrawingStyleManagerPantheonAccountsService* self);
static void gala_drawing_style_manager_pantheon_accounts_service_dbus_proxy_set_prefers_color_scheme (GalaDrawingStyleManagerPantheonAccountsService* self,
                                                                                               gint value);
static gint gala_drawing_style_manager_pantheon_accounts_service_dbus_proxy_get_prefers_accent_color (GalaDrawingStyleManagerPantheonAccountsService* self);
static void gala_drawing_style_manager_pantheon_accounts_service_dbus_proxy_set_prefers_accent_color (GalaDrawingStyleManagerPantheonAccountsService* self,
                                                                                               gint value);
static void gala_drawing_style_manager_pantheon_accounts_service_proxy_gala_drawing_style_manager_pantheon_accounts_service_interface_init (GalaDrawingStyleManagerPantheonAccountsServiceIface* iface);
static void gala_drawing_style_manager_pantheon_accounts_service_dbus_interface_method_call (GDBusConnection* connection,
                                                                                      const gchar* sender,
                                                                                      const gchar* object_path,
                                                                                      const gchar* interface_name,
                                                                                      const gchar* method_name,
                                                                                      GVariant* parameters,
                                                                                      GDBusMethodInvocation* invocation,
                                                                                      gpointer user_data);
static GVariant* gala_drawing_style_manager_pantheon_accounts_service_dbus_interface_get_property (GDBusConnection* connection,
                                                                                            const gchar* sender,
                                                                                            const gchar* object_path,
                                                                                            const gchar* interface_name,
                                                                                            const gchar* property_name,
                                                                                            GError** error,
                                                                                            gpointer user_data);
static GVariant* _dbus_gala_drawing_style_manager_pantheon_accounts_service_get_prefers_color_scheme (GalaDrawingStyleManagerPantheonAccountsService* self);
static GVariant* _dbus_gala_drawing_style_manager_pantheon_accounts_service_get_prefers_accent_color (GalaDrawingStyleManagerPantheonAccountsService* self);
static gboolean gala_drawing_style_manager_pantheon_accounts_service_dbus_interface_set_property (GDBusConnection* connection,
                                                                                           const gchar* sender,
                                                                                           const gchar* object_path,
                                                                                           const gchar* interface_name,
                                                                                           const gchar* property_name,
                                                                                           GVariant* value,
                                                                                           GError** error,
                                                                                           gpointer user_data);
static void _dbus_gala_drawing_style_manager_pantheon_accounts_service_set_prefers_color_scheme (GalaDrawingStyleManagerPantheonAccountsService* self,
                                                                                          GVariant* _value);
static void _dbus_gala_drawing_style_manager_pantheon_accounts_service_set_prefers_accent_color (GalaDrawingStyleManagerPantheonAccountsService* self,
                                                                                          GVariant* _value);
static void _gala_drawing_style_manager_pantheon_accounts_service_unregister_object (gpointer user_data);
 G_GNUC_INTERNAL void gala_drawing_style_manager_settings_daemon_accounts_service_set_accent_color (GalaDrawingStyleManagerSettingsDaemonAccountsService* self,
                                                                                   gint value);
static GType gala_drawing_style_manager_settings_daemon_accounts_service_get_type_once (void);
static void gala_drawing_style_manager_settings_daemon_accounts_service_proxy_g_signal (GDBusProxy* proxy,
                                                                                 const gchar* sender_name,
                                                                                 const gchar* signal_name,
                                                                                 GVariant* parameters);
static gint gala_drawing_style_manager_settings_daemon_accounts_service_dbus_proxy_get_accent_color (GalaDrawingStyleManagerSettingsDaemonAccountsService* self);
static void gala_drawing_style_manager_settings_daemon_accounts_service_dbus_proxy_set_accent_color (GalaDrawingStyleManagerSettingsDaemonAccountsService* self,
                                                                                              gint value);
static void gala_drawing_style_manager_settings_daemon_accounts_service_proxy_gala_drawing_style_manager_settings_daemon_accounts_service_interface_init (GalaDrawingStyleManagerSettingsDaemonAccountsServiceIface* iface);
static void gala_drawing_style_manager_settings_daemon_accounts_service_dbus_interface_method_call (GDBusConnection* connection,
                                                                                             const gchar* sender,
                                                                                             const gchar* object_path,
                                                                                             const gchar* interface_name,
                                                                                             const gchar* method_name,
                                                                                             GVariant* parameters,
                                                                                             GDBusMethodInvocation* invocation,
                                                                                             gpointer user_data);
static GVariant* gala_drawing_style_manager_settings_daemon_accounts_service_dbus_interface_get_property (GDBusConnection* connection,
                                                                                                   const gchar* sender,
                                                                                                   const gchar* object_path,
                                                                                                   const gchar* interface_name,
                                                                                                   const gchar* property_name,
                                                                                                   GError** error,
                                                                                                   gpointer user_data);
static GVariant* _dbus_gala_drawing_style_manager_settings_daemon_accounts_service_get_accent_color (GalaDrawingStyleManagerSettingsDaemonAccountsService* self);
static gboolean gala_drawing_style_manager_settings_daemon_accounts_service_dbus_interface_set_property (GDBusConnection* connection,
                                                                                                  const gchar* sender,
                                                                                                  const gchar* object_path,
                                                                                                  const gchar* interface_name,
                                                                                                  const gchar* property_name,
                                                                                                  GVariant* value,
                                                                                                  GError** error,
                                                                                                  gpointer user_data);
static void _dbus_gala_drawing_style_manager_settings_daemon_accounts_service_set_accent_color (GalaDrawingStyleManagerSettingsDaemonAccountsService* self,
                                                                                         GVariant* _value);
static void _gala_drawing_style_manager_settings_daemon_accounts_service_unregister_object (gpointer user_data);
static GObject * gala_drawing_style_manager_constructor (GType type,
                                                  guint n_construct_properties,
                                                  GObjectConstructParam * construct_properties);
static void _gala_drawing_style_manager___lambda19_ (GalaDrawingStyleManager* self);
static void __gala_drawing_style_manager___lambda19__gbus_name_appeared_callback (GDBusConnection* connection,
                                                                           const gchar* name,
                                                                           const gchar* name_owner,
                                                                           gpointer self);
static void _gala_drawing_style_manager___lambda20_ (GalaDrawingStyleManager* self);
static void __gala_drawing_style_manager___lambda20__gbus_name_vanished_callback (GDBusConnection* connection,
                                                                           const gchar* name,
                                                                           gpointer self);
static void gala_drawing_style_manager_finalize (GObject * obj);
static GType gala_drawing_style_manager_get_type_once (void);
static void _vala_gala_drawing_style_manager_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_gala_drawing_style_manager_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);

static const GDBusArgInfo _gala_drawing_style_manager_accounts_dbus_arg_info_find_user_by_name_name = {-1, "name", "s", NULL};
static const GDBusArgInfo _gala_drawing_style_manager_accounts_dbus_arg_info_find_user_by_name_result = {-1, "result", "s", NULL};
static const GDBusArgInfo * const _gala_drawing_style_manager_accounts_dbus_arg_info_find_user_by_name_in[] = {&_gala_drawing_style_manager_accounts_dbus_arg_info_find_user_by_name_name, NULL};
static const GDBusArgInfo * const _gala_drawing_style_manager_accounts_dbus_arg_info_find_user_by_name_out[] = {&_gala_drawing_style_manager_accounts_dbus_arg_info_find_user_by_name_result, NULL};
static const GDBusMethodInfo _gala_drawing_style_manager_accounts_dbus_method_info_find_user_by_name = {-1, "FindUserByName", (GDBusArgInfo **) (&_gala_drawing_style_manager_accounts_dbus_arg_info_find_user_by_name_in), (GDBusArgInfo **) (&_gala_drawing_style_manager_accounts_dbus_arg_info_find_user_by_name_out), NULL};
static const GDBusMethodInfo * const _gala_drawing_style_manager_accounts_dbus_method_info[] = {&_gala_drawing_style_manager_accounts_dbus_method_info_find_user_by_name, NULL};
static const GDBusSignalInfo * const _gala_drawing_style_manager_accounts_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _gala_drawing_style_manager_accounts_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _gala_drawing_style_manager_accounts_dbus_interface_info = {-1, "org.freedesktop.Accounts", (GDBusMethodInfo **) (&_gala_drawing_style_manager_accounts_dbus_method_info), (GDBusSignalInfo **) (&_gala_drawing_style_manager_accounts_dbus_signal_info), (GDBusPropertyInfo **) (&_gala_drawing_style_manager_accounts_dbus_property_info), NULL};
static const GDBusInterfaceVTable _gala_drawing_style_manager_accounts_dbus_interface_vtable = {gala_drawing_style_manager_accounts_dbus_interface_method_call, gala_drawing_style_manager_accounts_dbus_interface_get_property, gala_drawing_style_manager_accounts_dbus_interface_set_property};
static const GDBusMethodInfo * const _gala_drawing_style_manager_pantheon_accounts_service_dbus_method_info[] = {NULL};
static const GDBusSignalInfo * const _gala_drawing_style_manager_pantheon_accounts_service_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _gala_drawing_style_manager_pantheon_accounts_service_dbus_property_info_prefers_color_scheme = {-1, "PrefersColorScheme", "i", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo _gala_drawing_style_manager_pantheon_accounts_service_dbus_property_info_prefers_accent_color = {-1, "PrefersAccentColor", "i", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo * const _gala_drawing_style_manager_pantheon_accounts_service_dbus_property_info[] = {&_gala_drawing_style_manager_pantheon_accounts_service_dbus_property_info_prefers_color_scheme, &_gala_drawing_style_manager_pantheon_accounts_service_dbus_property_info_prefers_accent_color, NULL};
static const GDBusInterfaceInfo _gala_drawing_style_manager_pantheon_accounts_service_dbus_interface_info = {-1, "io.elementary.pantheon.AccountsService", (GDBusMethodInfo **) (&_gala_drawing_style_manager_pantheon_accounts_service_dbus_method_info), (GDBusSignalInfo **) (&_gala_drawing_style_manager_pantheon_accounts_service_dbus_signal_info), (GDBusPropertyInfo **) (&_gala_drawing_style_manager_pantheon_accounts_service_dbus_property_info), NULL};
static const GDBusInterfaceVTable _gala_drawing_style_manager_pantheon_accounts_service_dbus_interface_vtable = {gala_drawing_style_manager_pantheon_accounts_service_dbus_interface_method_call, gala_drawing_style_manager_pantheon_accounts_service_dbus_interface_get_property, gala_drawing_style_manager_pantheon_accounts_service_dbus_interface_set_property};
static const GDBusMethodInfo * const _gala_drawing_style_manager_settings_daemon_accounts_service_dbus_method_info[] = {NULL};
static const GDBusSignalInfo * const _gala_drawing_style_manager_settings_daemon_accounts_service_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _gala_drawing_style_manager_settings_daemon_accounts_service_dbus_property_info_accent_color = {-1, "AccentColor", "i", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo * const _gala_drawing_style_manager_settings_daemon_accounts_service_dbus_property_info[] = {&_gala_drawing_style_manager_settings_daemon_accounts_service_dbus_property_info_accent_color, NULL};
static const GDBusInterfaceInfo _gala_drawing_style_manager_settings_daemon_accounts_service_dbus_interface_info = {-1, "io.elementary.SettingsDaemon.AccountsService", (GDBusMethodInfo **) (&_gala_drawing_style_manager_settings_daemon_accounts_service_dbus_method_info), (GDBusSignalInfo **) (&_gala_drawing_style_manager_settings_daemon_accounts_service_dbus_signal_info), (GDBusPropertyInfo **) (&_gala_drawing_style_manager_settings_daemon_accounts_service_dbus_property_info), NULL};
static const GDBusInterfaceVTable _gala_drawing_style_manager_settings_daemon_accounts_service_dbus_interface_vtable = {gala_drawing_style_manager_settings_daemon_accounts_service_dbus_interface_method_call, gala_drawing_style_manager_settings_daemon_accounts_service_dbus_interface_get_property, gala_drawing_style_manager_settings_daemon_accounts_service_dbus_interface_set_property};

static inline gpointer
gala_drawing_style_manager_get_instance_private (GalaDrawingStyleManager* self)
{
	return G_STRUCT_MEMBER_P (self, GalaDrawingStyleManager_private_offset);
}

 G_GNUC_NO_INLINE static GType
gala_drawing_style_manager_color_scheme_get_type_once (void)
{
	static const GEnumValue values[] = {{GALA_DRAWING_STYLE_MANAGER_COLOR_SCHEME_NO_PREFERENCE, "GALA_DRAWING_STYLE_MANAGER_COLOR_SCHEME_NO_PREFERENCE", "no-preference"}, {GALA_DRAWING_STYLE_MANAGER_COLOR_SCHEME_DARK, "GALA_DRAWING_STYLE_MANAGER_COLOR_SCHEME_DARK", "dark"}, {GALA_DRAWING_STYLE_MANAGER_COLOR_SCHEME_LIGHT, "GALA_DRAWING_STYLE_MANAGER_COLOR_SCHEME_LIGHT", "light"}, {0, NULL, NULL}};
	GType gala_drawing_style_manager_color_scheme_type_id;
	gala_drawing_style_manager_color_scheme_type_id = g_enum_register_static ("GalaDrawingStyleManagerColorScheme", values);
	return gala_drawing_style_manager_color_scheme_type_id;
}

GType
gala_drawing_style_manager_color_scheme_get_type (void)
{
	static gsize gala_drawing_style_manager_color_scheme_type_id__once = 0;
	if (g_once_init_enter (&gala_drawing_style_manager_color_scheme_type_id__once)) {
		GType gala_drawing_style_manager_color_scheme_type_id;
		gala_drawing_style_manager_color_scheme_type_id = gala_drawing_style_manager_color_scheme_get_type_once ();
		g_once_init_leave (&gala_drawing_style_manager_color_scheme_type_id__once, gala_drawing_style_manager_color_scheme_type_id);
	}
	return gala_drawing_style_manager_color_scheme_type_id__once;
}

static GalaDrawingStyleManager*
__lambda16_ (void)
{
	GalaDrawingStyleManager* _tmp0_;
	GalaDrawingStyleManager* result;
	_tmp0_ = gala_drawing_style_manager_new ();
	result = _tmp0_;
	return result;
}

static gpointer
___lambda16__gthread_func (gpointer self)
{
	gpointer result;
	result = __lambda16_ ();
	return result;
}

GalaDrawingStyleManager*
gala_drawing_style_manager_get_instance (void)
{
	gconstpointer _tmp0_;
	GalaDrawingStyleManager* result;
	_tmp0_ = g_once (&gala_drawing_style_manager_instance, ___lambda16__gthread_func, NULL);
	result = (GalaDrawingStyleManager*) _tmp0_;
	return result;
}

static void
gala_drawing_style_manager_connect_to_accounts_service_data_free (gpointer _data)
{
	GalaDrawingStyleManagerConnectToAccountsServiceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GalaDrawingStyleManagerConnectToAccountsServiceData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gala_drawing_style_manager_connect_to_accounts_service (GalaDrawingStyleManager* self,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_)
{
	GalaDrawingStyleManagerConnectToAccountsServiceData* _data_;
	GalaDrawingStyleManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GalaDrawingStyleManagerConnectToAccountsServiceData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gala_drawing_style_manager_connect_to_accounts_service_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	gala_drawing_style_manager_connect_to_accounts_service_co (_data_);
}

static void
gala_drawing_style_manager_connect_to_accounts_service_finish (GalaDrawingStyleManager* self,
                                                               GAsyncResult* _res_)
{
	GalaDrawingStyleManagerConnectToAccountsServiceData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
gala_drawing_style_manager_connect_to_accounts_service_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_)
{
	GalaDrawingStyleManagerConnectToAccountsServiceData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gala_drawing_style_manager_connect_to_accounts_service_co (_data_);
}

static void
__lambda17_ (GalaDrawingStyleManager* self,
             GVariant* changed,
             gchar** invalid)
{
	GVariant* value = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	g_return_if_fail (changed != NULL);
	_tmp0_ = g_variant_type_new ("i");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_lookup_value (changed, "PrefersColorScheme", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	value = _tmp3_;
	_tmp4_ = value;
	if (_tmp4_ != NULL) {
		GVariant* _tmp5_;
		_tmp5_ = value;
		gala_drawing_style_manager_update_color_scheme (self, (gint) g_variant_get_int32 (_tmp5_));
	}
	_g_variant_unref0 (value);
}

static void
___lambda17__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                GVariant* changed_properties,
                                                gchar** invalidated_properties,
                                                gpointer self)
{
	__lambda17_ ((GalaDrawingStyleManager*) self, changed_properties, invalidated_properties);
}

static void
__lambda18_ (GalaDrawingStyleManager* self,
             GVariant* changed,
             gchar** invalid)
{
	GVariant* value = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	g_return_if_fail (changed != NULL);
	_tmp0_ = g_variant_type_new ("i");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_lookup_value (changed, "AccentColor", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	value = _tmp3_;
	_tmp4_ = value;
	if (_tmp4_ != NULL) {
		GVariant* _tmp5_;
		_tmp5_ = value;
		gala_drawing_style_manager_update_color (self, (gint) g_variant_get_int32 (_tmp5_));
	}
	_g_variant_unref0 (value);
}

static void
___lambda18__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                GVariant* changed_properties,
                                                gchar** invalidated_properties,
                                                gpointer self)
{
	__lambda18_ ((GalaDrawingStyleManager*) self, changed_properties, invalidated_properties);
}

static gboolean
gala_drawing_style_manager_connect_to_accounts_service_co (GalaDrawingStyleManagerConnectToAccountsServiceData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		g_async_initable_new_async (GALA_DRAWING_STYLE_MANAGER_TYPE_ACCOUNTS_PROXY, 0, NULL, gala_drawing_style_manager_connect_to_accounts_service_ready, _data_, "g-flags", 0, "g-name", GALA_DRAWING_STYLE_MANAGER_FDO_ACCOUNTS_NAME, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", GALA_DRAWING_STYLE_MANAGER_FDO_ACCOUNTS_PATH, "g-interface-name", "org.freedesktop.Accounts", NULL);
		return FALSE;
		_state_1:
		_data_->_tmp0_ = (GalaDrawingStyleManagerAccounts*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->accounts = (GalaDrawingStyleManagerAccounts*) _data_->_tmp0_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp1_ = _data_->accounts;
		_data_->_tmp2_ = g_get_user_name ();
		_data_->_state_ = 2;
		gala_drawing_style_manager_accounts_find_user_by_name (_data_->_tmp1_, _data_->_tmp2_, gala_drawing_style_manager_connect_to_accounts_service_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp3_ = gala_drawing_style_manager_accounts_find_user_by_name_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
		_data_->path = _data_->_tmp3_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->accounts);
			goto __catch0_g_error;
		}
		_data_->_tmp5_ = _data_->path;
		_data_->_state_ = 3;
		g_async_initable_new_async (GALA_DRAWING_STYLE_MANAGER_TYPE_PANTHEON_ACCOUNTS_SERVICE_PROXY, 0, NULL, gala_drawing_style_manager_connect_to_accounts_service_ready, _data_, "g-flags", G_DBUS_PROXY_FLAGS_GET_INVALIDATED_PROPERTIES, "g-name", GALA_DRAWING_STYLE_MANAGER_FDO_ACCOUNTS_NAME, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", _data_->_tmp5_, "g-interface-name", "io.elementary.pantheon.AccountsService", NULL);
		return FALSE;
		_state_3:
		_data_->_tmp6_ = (GalaDrawingStyleManagerPantheonAccountsService*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp4_ = (GalaDrawingStyleManagerPantheonAccountsService*) _data_->_tmp6_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_free0 (_data_->path);
			_g_object_unref0 (_data_->accounts);
			goto __catch0_g_error;
		}
		_data_->_tmp7_ = _data_->_tmp4_;
		_data_->_tmp4_ = NULL;
		_g_object_unref0 (_data_->self->priv->pantheon_proxy);
		_data_->self->priv->pantheon_proxy = _data_->_tmp7_;
		_data_->_tmp9_ = _data_->path;
		_data_->_state_ = 4;
		g_async_initable_new_async (GALA_DRAWING_STYLE_MANAGER_TYPE_SETTINGS_DAEMON_ACCOUNTS_SERVICE_PROXY, 0, NULL, gala_drawing_style_manager_connect_to_accounts_service_ready, _data_, "g-flags", G_DBUS_PROXY_FLAGS_GET_INVALIDATED_PROPERTIES, "g-name", GALA_DRAWING_STYLE_MANAGER_FDO_ACCOUNTS_NAME, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", _data_->_tmp9_, "g-interface-name", "io.elementary.SettingsDaemon.AccountsService", NULL);
		return FALSE;
		_state_4:
		_data_->_tmp10_ = (GalaDrawingStyleManagerSettingsDaemonAccountsService*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp8_ = (GalaDrawingStyleManagerSettingsDaemonAccountsService*) _data_->_tmp10_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->_tmp4_);
			_g_free0 (_data_->path);
			_g_object_unref0 (_data_->accounts);
			goto __catch0_g_error;
		}
		_data_->_tmp11_ = _data_->_tmp8_;
		_data_->_tmp8_ = NULL;
		_g_object_unref0 (_data_->self->priv->settings_daemon_proxy);
		_data_->self->priv->settings_daemon_proxy = _data_->_tmp11_;
		_g_object_unref0 (_data_->_tmp8_);
		_g_object_unref0 (_data_->_tmp4_);
		_g_free0 (_data_->path);
		_g_object_unref0 (_data_->accounts);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
		g_warning ("StyleManager.vala:70: Could not connect to AccountsService. Default ac" \
"cent color will be used");
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp12_ = _data_->self->priv->pantheon_proxy;
	_data_->_tmp13_ = gala_drawing_style_manager_pantheon_accounts_service_get_prefers_color_scheme (_data_->_tmp12_);
	_data_->_tmp14_ = _data_->_tmp13_;
	gala_drawing_style_manager_update_color_scheme (_data_->self, _data_->_tmp14_);
	_data_->_tmp15_ = _data_->self->priv->settings_daemon_proxy;
	_data_->_tmp16_ = gala_drawing_style_manager_settings_daemon_accounts_service_get_accent_color (_data_->_tmp15_);
	_data_->_tmp17_ = _data_->_tmp16_;
	gala_drawing_style_manager_update_color (_data_->self, _data_->_tmp17_);
	_data_->_tmp18_ = _data_->self->priv->pantheon_proxy;
	g_signal_connect_object ((GDBusProxy*) _data_->_tmp18_, "g-properties-changed", (GCallback) ___lambda17__g_dbus_proxy_g_properties_changed, _data_->self, 0);
	_data_->_tmp19_ = _data_->self->priv->settings_daemon_proxy;
	g_signal_connect_object ((GDBusProxy*) _data_->_tmp19_, "g-properties-changed", (GCallback) ___lambda18__g_dbus_proxy_g_properties_changed, _data_->self, 0);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gala_drawing_style_manager_update_color_scheme (GalaDrawingStyleManager* self,
                                                gint color_scheme)
{
	g_return_if_fail (self != NULL);
	gala_drawing_style_manager_set_prefers_color_scheme (self, (GalaDrawingStyleManagerColorScheme) color_scheme);
}

static void
gala_drawing_style_manager_update_color (GalaDrawingStyleManager* self,
                                         gint color)
{
	gint rgb = 0;
	guint8 r = 0U;
	guint8 g = 0U;
	guint8 b = 0U;
	ClutterColor _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	rgb = gala_drawing_style_manager_get_color (self, color);
	r = (guint8) ((rgb >> 16) & 255);
	g = (guint8) ((rgb >> 8) & 255);
	b = (guint8) (rgb & 255);
	_tmp0_.red = r;
	_tmp0_.green = g;
	_tmp0_.blue = b;
	_tmp0_.alpha = GALA_DRAWING_STYLE_MANAGER_ACCENT_COLOR_ALPHA;
	gala_drawing_style_manager_set_theme_accent_color (self, &_tmp0_);
}

static gint
gala_drawing_style_manager_get_color (GalaDrawingStyleManager* self,
                                      gint color)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	switch (color) {
		case 1:
		{
			result = 0xed5353;
			return result;
		}
		case 2:
		{
			result = 0xffa154;
			return result;
		}
		case 3:
		{
			result = 0xf9c440;
			return result;
		}
		case 4:
		{
			result = 0x68b723;
			return result;
		}
		case 5:
		{
			result = 0x28bca3;
			return result;
		}
		case 6:
		{
			result = 0x3689e6;
			return result;
		}
		case 7:
		{
			result = 0xa56de2;
			return result;
		}
		case 8:
		{
			result = 0xde3e80;
			return result;
		}
		case 9:
		{
			result = 0x8a715e;
			return result;
		}
		case 10:
		{
			result = 0x667885;
			return result;
		}
		case 11:
		{
			result = 0xe7c591;
			return result;
		}
		default:
		break;
	}
	result = 0;
	return result;
}

GalaDrawingStyleManager*
gala_drawing_style_manager_construct (GType object_type)
{
	GalaDrawingStyleManager * self = NULL;
	self = (GalaDrawingStyleManager*) g_object_new (object_type, NULL);
	return self;
}

GalaDrawingStyleManager*
gala_drawing_style_manager_new (void)
{
	return gala_drawing_style_manager_construct (GALA_DRAWING_TYPE_STYLE_MANAGER);
}

GalaDrawingStyleManagerColorScheme
gala_drawing_style_manager_get_prefers_color_scheme (GalaDrawingStyleManager* self)
{
	GalaDrawingStyleManagerColorScheme result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_prefers_color_scheme;
	return result;
}

static void
gala_drawing_style_manager_set_prefers_color_scheme (GalaDrawingStyleManager* self,
                                                     GalaDrawingStyleManagerColorScheme value)
{
	GalaDrawingStyleManagerColorScheme old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_drawing_style_manager_get_prefers_color_scheme (self);
	if (old_value != value) {
		self->priv->_prefers_color_scheme = value;
		g_object_notify_by_pspec ((GObject *) self, gala_drawing_style_manager_properties[GALA_DRAWING_STYLE_MANAGER_PREFERS_COLOR_SCHEME_PROPERTY]);
	}
}

void
gala_drawing_style_manager_get_theme_accent_color (GalaDrawingStyleManager* self,
                                                   ClutterColor * result)
{
	ClutterColor _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_theme_accent_color;
	*result = _tmp0_;
	return;
}

static gboolean
_clutter_color_equal (const ClutterColor * s1,
                      const ClutterColor * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->red != s2->red) {
		return FALSE;
	}
	if (s1->green != s2->green) {
		return FALSE;
	}
	if (s1->blue != s2->blue) {
		return FALSE;
	}
	if (s1->alpha != s2->alpha) {
		return FALSE;
	}
	return TRUE;
}

static void
gala_drawing_style_manager_set_theme_accent_color (GalaDrawingStyleManager* self,
                                                   ClutterColor * value)
{
	ClutterColor old_value;
	g_return_if_fail (self != NULL);
	gala_drawing_style_manager_get_theme_accent_color (self, &old_value);
	if (_clutter_color_equal (value, &old_value) != TRUE) {
		ClutterColor _tmp0_;
		_tmp0_ = *value;
		self->priv->_theme_accent_color = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_drawing_style_manager_properties[GALA_DRAWING_STYLE_MANAGER_THEME_ACCENT_COLOR_PROPERTY]);
	}
}

void
gala_drawing_style_manager_accounts_find_user_by_name (GalaDrawingStyleManagerAccounts* self,
                                                       const gchar* name,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_)
{
	GalaDrawingStyleManagerAccountsIface* _iface_;
	_iface_ = GALA_DRAWING_STYLE_MANAGER_ACCOUNTS_GET_INTERFACE (self);
	if (_iface_->find_user_by_name) {
		_iface_->find_user_by_name (self, name, _callback_, _user_data_);
	}
}

gchar*
gala_drawing_style_manager_accounts_find_user_by_name_finish (GalaDrawingStyleManagerAccounts* self,
                                                              GAsyncResult* _res_,
                                                              GError** error)
{
	GalaDrawingStyleManagerAccountsIface* _iface_;
	_iface_ = GALA_DRAWING_STYLE_MANAGER_ACCOUNTS_GET_INTERFACE (self);
	if (_iface_->find_user_by_name_finish) {
		return _iface_->find_user_by_name_finish (self, _res_, error);
	}
	return NULL;
}

static void
gala_drawing_style_manager_accounts_default_init (GalaDrawingStyleManagerAccountsIface * iface,
                                                  gpointer iface_data)
{
}

 G_GNUC_NO_INLINE static GType
gala_drawing_style_manager_accounts_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaDrawingStyleManagerAccountsIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_drawing_style_manager_accounts_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType gala_drawing_style_manager_accounts_type_id;
	gala_drawing_style_manager_accounts_type_id = g_type_register_static (G_TYPE_INTERFACE, "GalaDrawingStyleManagerAccounts", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (gala_drawing_style_manager_accounts_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (gala_drawing_style_manager_accounts_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) gala_drawing_style_manager_accounts_proxy_get_type);
	g_type_set_qdata (gala_drawing_style_manager_accounts_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.Accounts");
	g_type_set_qdata (gala_drawing_style_manager_accounts_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_gala_drawing_style_manager_accounts_dbus_interface_info));
	g_type_set_qdata (gala_drawing_style_manager_accounts_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) gala_drawing_style_manager_accounts_register_object);
	return gala_drawing_style_manager_accounts_type_id;
}

static GType
gala_drawing_style_manager_accounts_get_type (void)
{
	static gsize gala_drawing_style_manager_accounts_type_id__once = 0;
	if (g_once_init_enter (&gala_drawing_style_manager_accounts_type_id__once)) {
		GType gala_drawing_style_manager_accounts_type_id;
		gala_drawing_style_manager_accounts_type_id = gala_drawing_style_manager_accounts_get_type_once ();
		g_once_init_leave (&gala_drawing_style_manager_accounts_type_id__once, gala_drawing_style_manager_accounts_type_id);
	}
	return gala_drawing_style_manager_accounts_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (GalaDrawingStyleManagerAccountsProxy, gala_drawing_style_manager_accounts_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (GALA_DRAWING_STYLE_MANAGER_TYPE_ACCOUNTS, gala_drawing_style_manager_accounts_proxy_gala_drawing_style_manager_accounts_interface_init) )
static void
gala_drawing_style_manager_accounts_proxy_class_init (GalaDrawingStyleManagerAccountsProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = gala_drawing_style_manager_accounts_proxy_g_signal;
}

static void
gala_drawing_style_manager_accounts_proxy_g_signal (GDBusProxy* proxy,
                                                    const gchar* sender_name,
                                                    const gchar* signal_name,
                                                    GVariant* parameters)
{
}

static void
gala_drawing_style_manager_accounts_proxy_init (GalaDrawingStyleManagerAccountsProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_gala_drawing_style_manager_accounts_dbus_interface_info));
}

static void
_vala_g_async_ready_callback (GObject *source_object,
                              GAsyncResult *res,
                              void *user_data)
{
	g_task_return_pointer (user_data, g_object_ref (res), g_object_unref);
	g_object_unref (user_data);
}

static void
gala_drawing_style_manager_accounts_proxy_find_user_by_name_async (GalaDrawingStyleManagerAccounts* self,
                                                                   const gchar* name,
                                                                   GAsyncReadyCallback _callback_,
                                                                   gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.Accounts", "FindUserByName");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (name));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static gchar*
gala_drawing_style_manager_accounts_proxy_find_user_by_name_finish (GalaDrawingStyleManagerAccounts* self,
                                                                    GAsyncResult* _res_,
                                                                    GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result = NULL;
	GVariant* _tmp0_;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp0_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp0_, NULL);
	g_variant_unref (_tmp0_);
	g_object_unref (_reply_message);
	return _result;
}

static void
gala_drawing_style_manager_accounts_proxy_gala_drawing_style_manager_accounts_interface_init (GalaDrawingStyleManagerAccountsIface* iface)
{
	iface->find_user_by_name = gala_drawing_style_manager_accounts_proxy_find_user_by_name_async;
	iface->find_user_by_name_finish = gala_drawing_style_manager_accounts_proxy_find_user_by_name_finish;
}

static void
_dbus_gala_drawing_style_manager_accounts_find_user_by_name (GalaDrawingStyleManagerAccounts* self,
                                                             GVariant* _parameters_,
                                                             GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	GalaDrawingStyleManagerAccountsFindUserByNameReadyData* _ready_data;
	GVariant* _tmp1_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (GalaDrawingStyleManagerAccountsFindUserByNameReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->name = g_variant_dup_string (_tmp1_, NULL);
	g_variant_unref (_tmp1_);
	gala_drawing_style_manager_accounts_find_user_by_name (self, _ready_data->name, (GAsyncReadyCallback) _dbus_gala_drawing_style_manager_accounts_find_user_by_name_ready, _ready_data);
	_error:
	;
}

static void
_dbus_gala_drawing_style_manager_accounts_find_user_by_name_ready (GObject * source_object,
                                                                   GAsyncResult * _res_,
                                                                   gpointer _user_data_)
{
	GalaDrawingStyleManagerAccountsFindUserByNameReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = gala_drawing_style_manager_accounts_find_user_by_name_finish ((GalaDrawingStyleManagerAccounts*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->name);
	g_slice_free (GalaDrawingStyleManagerAccountsFindUserByNameReadyData, _ready_data);
}

static void
gala_drawing_style_manager_accounts_dbus_interface_method_call (GDBusConnection* connection,
                                                                const gchar* sender,
                                                                const gchar* object_path,
                                                                const gchar* interface_name,
                                                                const gchar* method_name,
                                                                GVariant* parameters,
                                                                GDBusMethodInvocation* invocation,
                                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "FindUserByName") == 0) {
		_dbus_gala_drawing_style_manager_accounts_find_user_by_name (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
gala_drawing_style_manager_accounts_dbus_interface_get_property (GDBusConnection* connection,
                                                                 const gchar* sender,
                                                                 const gchar* object_path,
                                                                 const gchar* interface_name,
                                                                 const gchar* property_name,
                                                                 GError** error,
                                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
gala_drawing_style_manager_accounts_dbus_interface_set_property (GDBusConnection* connection,
                                                                 const gchar* sender,
                                                                 const gchar* object_path,
                                                                 const gchar* interface_name,
                                                                 const gchar* property_name,
                                                                 GVariant* value,
                                                                 GError** error,
                                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static guint
gala_drawing_style_manager_accounts_register_object (gpointer object,
                                                     GDBusConnection* connection,
                                                     const gchar* path,
                                                     GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_gala_drawing_style_manager_accounts_dbus_interface_info), &_gala_drawing_style_manager_accounts_dbus_interface_vtable, data, _gala_drawing_style_manager_accounts_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_gala_drawing_style_manager_accounts_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

 G_GNUC_INTERNAL gint
gala_drawing_style_manager_pantheon_accounts_service_get_prefers_color_scheme (GalaDrawingStyleManagerPantheonAccountsService* self)
{
	GalaDrawingStyleManagerPantheonAccountsServiceIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = GALA_DRAWING_STYLE_MANAGER_PANTHEON_ACCOUNTS_SERVICE_GET_INTERFACE (self);
	if (_iface_->get_prefers_color_scheme) {
		return _iface_->get_prefers_color_scheme (self);
	}
	return -1;
}

 G_GNUC_INTERNAL void
gala_drawing_style_manager_pantheon_accounts_service_set_prefers_color_scheme (GalaDrawingStyleManagerPantheonAccountsService* self,
                                                                               gint value)
{
	GalaDrawingStyleManagerPantheonAccountsServiceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GALA_DRAWING_STYLE_MANAGER_PANTHEON_ACCOUNTS_SERVICE_GET_INTERFACE (self);
	if (_iface_->set_prefers_color_scheme) {
		_iface_->set_prefers_color_scheme (self, value);
	}
}

 G_GNUC_INTERNAL gint
gala_drawing_style_manager_pantheon_accounts_service_get_prefers_accent_color (GalaDrawingStyleManagerPantheonAccountsService* self)
{
	GalaDrawingStyleManagerPantheonAccountsServiceIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = GALA_DRAWING_STYLE_MANAGER_PANTHEON_ACCOUNTS_SERVICE_GET_INTERFACE (self);
	if (_iface_->get_prefers_accent_color) {
		return _iface_->get_prefers_accent_color (self);
	}
	return -1;
}

 G_GNUC_INTERNAL void
gala_drawing_style_manager_pantheon_accounts_service_set_prefers_accent_color (GalaDrawingStyleManagerPantheonAccountsService* self,
                                                                               gint value)
{
	GalaDrawingStyleManagerPantheonAccountsServiceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GALA_DRAWING_STYLE_MANAGER_PANTHEON_ACCOUNTS_SERVICE_GET_INTERFACE (self);
	if (_iface_->set_prefers_accent_color) {
		_iface_->set_prefers_accent_color (self, value);
	}
}

static void
gala_drawing_style_manager_pantheon_accounts_service_default_init (GalaDrawingStyleManagerPantheonAccountsServiceIface * iface,
                                                                   gpointer iface_data)
{
}

 G_GNUC_NO_INLINE static GType
gala_drawing_style_manager_pantheon_accounts_service_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaDrawingStyleManagerPantheonAccountsServiceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_drawing_style_manager_pantheon_accounts_service_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType gala_drawing_style_manager_pantheon_accounts_service_type_id;
	gala_drawing_style_manager_pantheon_accounts_service_type_id = g_type_register_static (G_TYPE_INTERFACE, "GalaDrawingStyleManagerPantheonAccountsService", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (gala_drawing_style_manager_pantheon_accounts_service_type_id, g_dbus_proxy_get_type ());
	g_type_set_qdata (gala_drawing_style_manager_pantheon_accounts_service_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) gala_drawing_style_manager_pantheon_accounts_service_proxy_get_type);
	g_type_set_qdata (gala_drawing_style_manager_pantheon_accounts_service_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "io.elementary.pantheon.AccountsService");
	g_type_set_qdata (gala_drawing_style_manager_pantheon_accounts_service_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_gala_drawing_style_manager_pantheon_accounts_service_dbus_interface_info));
	g_type_set_qdata (gala_drawing_style_manager_pantheon_accounts_service_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) gala_drawing_style_manager_pantheon_accounts_service_register_object);
	return gala_drawing_style_manager_pantheon_accounts_service_type_id;
}

static GType
gala_drawing_style_manager_pantheon_accounts_service_get_type (void)
{
	static gsize gala_drawing_style_manager_pantheon_accounts_service_type_id__once = 0;
	if (g_once_init_enter (&gala_drawing_style_manager_pantheon_accounts_service_type_id__once)) {
		GType gala_drawing_style_manager_pantheon_accounts_service_type_id;
		gala_drawing_style_manager_pantheon_accounts_service_type_id = gala_drawing_style_manager_pantheon_accounts_service_get_type_once ();
		g_once_init_leave (&gala_drawing_style_manager_pantheon_accounts_service_type_id__once, gala_drawing_style_manager_pantheon_accounts_service_type_id);
	}
	return gala_drawing_style_manager_pantheon_accounts_service_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (GalaDrawingStyleManagerPantheonAccountsServiceProxy, gala_drawing_style_manager_pantheon_accounts_service_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (GALA_DRAWING_STYLE_MANAGER_TYPE_PANTHEON_ACCOUNTS_SERVICE, gala_drawing_style_manager_pantheon_accounts_service_proxy_gala_drawing_style_manager_pantheon_accounts_service_interface_init) )
static void
gala_drawing_style_manager_pantheon_accounts_service_proxy_class_init (GalaDrawingStyleManagerPantheonAccountsServiceProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = gala_drawing_style_manager_pantheon_accounts_service_proxy_g_signal;
}

static void
gala_drawing_style_manager_pantheon_accounts_service_proxy_g_signal (GDBusProxy* proxy,
                                                                     const gchar* sender_name,
                                                                     const gchar* signal_name,
                                                                     GVariant* parameters)
{
}

static void
gala_drawing_style_manager_pantheon_accounts_service_proxy_init (GalaDrawingStyleManagerPantheonAccountsServiceProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_gala_drawing_style_manager_pantheon_accounts_service_dbus_interface_info));
}

static gint
gala_drawing_style_manager_pantheon_accounts_service_dbus_proxy_get_prefers_color_scheme (GalaDrawingStyleManagerPantheonAccountsService* self)
{
	GVariant *_inner_reply;
	gint _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "PrefersColorScheme");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("io.elementary.pantheon.AccountsService"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("PrefersColorScheme"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gint _tmp2_ = 0;
			return _tmp2_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_int32 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
gala_drawing_style_manager_pantheon_accounts_service_dbus_proxy_set_prefers_color_scheme (GalaDrawingStyleManagerPantheonAccountsService* self,
                                                                                          gint value)
{
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("io.elementary.pantheon.AccountsService"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("PrefersColorScheme"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}

static gint
gala_drawing_style_manager_pantheon_accounts_service_dbus_proxy_get_prefers_accent_color (GalaDrawingStyleManagerPantheonAccountsService* self)
{
	GVariant *_inner_reply;
	gint _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "PrefersAccentColor");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("io.elementary.pantheon.AccountsService"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("PrefersAccentColor"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gint _tmp3_ = 0;
			return _tmp3_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_int32 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
gala_drawing_style_manager_pantheon_accounts_service_dbus_proxy_set_prefers_accent_color (GalaDrawingStyleManagerPantheonAccountsService* self,
                                                                                          gint value)
{
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("io.elementary.pantheon.AccountsService"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("PrefersAccentColor"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}

static void
gala_drawing_style_manager_pantheon_accounts_service_proxy_gala_drawing_style_manager_pantheon_accounts_service_interface_init (GalaDrawingStyleManagerPantheonAccountsServiceIface* iface)
{
	iface->get_prefers_color_scheme = gala_drawing_style_manager_pantheon_accounts_service_dbus_proxy_get_prefers_color_scheme;
	iface->set_prefers_color_scheme = gala_drawing_style_manager_pantheon_accounts_service_dbus_proxy_set_prefers_color_scheme;
	iface->get_prefers_accent_color = gala_drawing_style_manager_pantheon_accounts_service_dbus_proxy_get_prefers_accent_color;
	iface->set_prefers_accent_color = gala_drawing_style_manager_pantheon_accounts_service_dbus_proxy_set_prefers_accent_color;
}

static void
gala_drawing_style_manager_pantheon_accounts_service_dbus_interface_method_call (GDBusConnection* connection,
                                                                                 const gchar* sender,
                                                                                 const gchar* object_path,
                                                                                 const gchar* interface_name,
                                                                                 const gchar* method_name,
                                                                                 GVariant* parameters,
                                                                                 GDBusMethodInvocation* invocation,
                                                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}

static GVariant*
_dbus_gala_drawing_style_manager_pantheon_accounts_service_get_prefers_color_scheme (GalaDrawingStyleManagerPantheonAccountsService* self)
{
	gint result;
	GVariant* _reply;
	result = gala_drawing_style_manager_pantheon_accounts_service_get_prefers_color_scheme (self);
	_reply = g_variant_new_int32 (result);
	return _reply;
}

static GVariant*
_dbus_gala_drawing_style_manager_pantheon_accounts_service_get_prefers_accent_color (GalaDrawingStyleManagerPantheonAccountsService* self)
{
	gint result;
	GVariant* _reply;
	result = gala_drawing_style_manager_pantheon_accounts_service_get_prefers_accent_color (self);
	_reply = g_variant_new_int32 (result);
	return _reply;
}

static GVariant*
gala_drawing_style_manager_pantheon_accounts_service_dbus_interface_get_property (GDBusConnection* connection,
                                                                                  const gchar* sender,
                                                                                  const gchar* object_path,
                                                                                  const gchar* interface_name,
                                                                                  const gchar* property_name,
                                                                                  GError** error,
                                                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "PrefersColorScheme") == 0) {
		return _dbus_gala_drawing_style_manager_pantheon_accounts_service_get_prefers_color_scheme (object);
	} else if (strcmp (property_name, "PrefersAccentColor") == 0) {
		return _dbus_gala_drawing_style_manager_pantheon_accounts_service_get_prefers_accent_color (object);
	}
	return NULL;
}

static void
_dbus_gala_drawing_style_manager_pantheon_accounts_service_set_prefers_color_scheme (GalaDrawingStyleManagerPantheonAccountsService* self,
                                                                                     GVariant* _value)
{
	gint value = 0;
	value = g_variant_get_int32 (_value);
	gala_drawing_style_manager_pantheon_accounts_service_set_prefers_color_scheme (self, value);
}

static void
_dbus_gala_drawing_style_manager_pantheon_accounts_service_set_prefers_accent_color (GalaDrawingStyleManagerPantheonAccountsService* self,
                                                                                     GVariant* _value)
{
	gint value = 0;
	value = g_variant_get_int32 (_value);
	gala_drawing_style_manager_pantheon_accounts_service_set_prefers_accent_color (self, value);
}

static gboolean
gala_drawing_style_manager_pantheon_accounts_service_dbus_interface_set_property (GDBusConnection* connection,
                                                                                  const gchar* sender,
                                                                                  const gchar* object_path,
                                                                                  const gchar* interface_name,
                                                                                  const gchar* property_name,
                                                                                  GVariant* value,
                                                                                  GError** error,
                                                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "PrefersColorScheme") == 0) {
		_dbus_gala_drawing_style_manager_pantheon_accounts_service_set_prefers_color_scheme (object, value);
		return TRUE;
	} else if (strcmp (property_name, "PrefersAccentColor") == 0) {
		_dbus_gala_drawing_style_manager_pantheon_accounts_service_set_prefers_accent_color (object, value);
		return TRUE;
	}
	return FALSE;
}

static guint
gala_drawing_style_manager_pantheon_accounts_service_register_object (gpointer object,
                                                                      GDBusConnection* connection,
                                                                      const gchar* path,
                                                                      GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_gala_drawing_style_manager_pantheon_accounts_service_dbus_interface_info), &_gala_drawing_style_manager_pantheon_accounts_service_dbus_interface_vtable, data, _gala_drawing_style_manager_pantheon_accounts_service_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_gala_drawing_style_manager_pantheon_accounts_service_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

 G_GNUC_INTERNAL gint
gala_drawing_style_manager_settings_daemon_accounts_service_get_accent_color (GalaDrawingStyleManagerSettingsDaemonAccountsService* self)
{
	GalaDrawingStyleManagerSettingsDaemonAccountsServiceIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = GALA_DRAWING_STYLE_MANAGER_SETTINGS_DAEMON_ACCOUNTS_SERVICE_GET_INTERFACE (self);
	if (_iface_->get_accent_color) {
		return _iface_->get_accent_color (self);
	}
	return -1;
}

 G_GNUC_INTERNAL void
gala_drawing_style_manager_settings_daemon_accounts_service_set_accent_color (GalaDrawingStyleManagerSettingsDaemonAccountsService* self,
                                                                              gint value)
{
	GalaDrawingStyleManagerSettingsDaemonAccountsServiceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GALA_DRAWING_STYLE_MANAGER_SETTINGS_DAEMON_ACCOUNTS_SERVICE_GET_INTERFACE (self);
	if (_iface_->set_accent_color) {
		_iface_->set_accent_color (self, value);
	}
}

static void
gala_drawing_style_manager_settings_daemon_accounts_service_default_init (GalaDrawingStyleManagerSettingsDaemonAccountsServiceIface * iface,
                                                                          gpointer iface_data)
{
}

 G_GNUC_NO_INLINE static GType
gala_drawing_style_manager_settings_daemon_accounts_service_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaDrawingStyleManagerSettingsDaemonAccountsServiceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_drawing_style_manager_settings_daemon_accounts_service_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType gala_drawing_style_manager_settings_daemon_accounts_service_type_id;
	gala_drawing_style_manager_settings_daemon_accounts_service_type_id = g_type_register_static (G_TYPE_INTERFACE, "GalaDrawingStyleManagerSettingsDaemonAccountsService", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (gala_drawing_style_manager_settings_daemon_accounts_service_type_id, g_dbus_proxy_get_type ());
	g_type_set_qdata (gala_drawing_style_manager_settings_daemon_accounts_service_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) gala_drawing_style_manager_settings_daemon_accounts_service_proxy_get_type);
	g_type_set_qdata (gala_drawing_style_manager_settings_daemon_accounts_service_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "io.elementary.SettingsDaemon.AccountsService");
	g_type_set_qdata (gala_drawing_style_manager_settings_daemon_accounts_service_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_gala_drawing_style_manager_settings_daemon_accounts_service_dbus_interface_info));
	g_type_set_qdata (gala_drawing_style_manager_settings_daemon_accounts_service_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) gala_drawing_style_manager_settings_daemon_accounts_service_register_object);
	return gala_drawing_style_manager_settings_daemon_accounts_service_type_id;
}

static GType
gala_drawing_style_manager_settings_daemon_accounts_service_get_type (void)
{
	static gsize gala_drawing_style_manager_settings_daemon_accounts_service_type_id__once = 0;
	if (g_once_init_enter (&gala_drawing_style_manager_settings_daemon_accounts_service_type_id__once)) {
		GType gala_drawing_style_manager_settings_daemon_accounts_service_type_id;
		gala_drawing_style_manager_settings_daemon_accounts_service_type_id = gala_drawing_style_manager_settings_daemon_accounts_service_get_type_once ();
		g_once_init_leave (&gala_drawing_style_manager_settings_daemon_accounts_service_type_id__once, gala_drawing_style_manager_settings_daemon_accounts_service_type_id);
	}
	return gala_drawing_style_manager_settings_daemon_accounts_service_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (GalaDrawingStyleManagerSettingsDaemonAccountsServiceProxy, gala_drawing_style_manager_settings_daemon_accounts_service_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (GALA_DRAWING_STYLE_MANAGER_TYPE_SETTINGS_DAEMON_ACCOUNTS_SERVICE, gala_drawing_style_manager_settings_daemon_accounts_service_proxy_gala_drawing_style_manager_settings_daemon_accounts_service_interface_init) )
static void
gala_drawing_style_manager_settings_daemon_accounts_service_proxy_class_init (GalaDrawingStyleManagerSettingsDaemonAccountsServiceProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = gala_drawing_style_manager_settings_daemon_accounts_service_proxy_g_signal;
}

static void
gala_drawing_style_manager_settings_daemon_accounts_service_proxy_g_signal (GDBusProxy* proxy,
                                                                            const gchar* sender_name,
                                                                            const gchar* signal_name,
                                                                            GVariant* parameters)
{
}

static void
gala_drawing_style_manager_settings_daemon_accounts_service_proxy_init (GalaDrawingStyleManagerSettingsDaemonAccountsServiceProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_gala_drawing_style_manager_settings_daemon_accounts_service_dbus_interface_info));
}

static gint
gala_drawing_style_manager_settings_daemon_accounts_service_dbus_proxy_get_accent_color (GalaDrawingStyleManagerSettingsDaemonAccountsService* self)
{
	GVariant *_inner_reply;
	gint _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "AccentColor");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("io.elementary.SettingsDaemon.AccountsService"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("AccentColor"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gint _tmp4_ = 0;
			return _tmp4_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_int32 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
gala_drawing_style_manager_settings_daemon_accounts_service_dbus_proxy_set_accent_color (GalaDrawingStyleManagerSettingsDaemonAccountsService* self,
                                                                                         gint value)
{
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("io.elementary.SettingsDaemon.AccountsService"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("AccentColor"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}

static void
gala_drawing_style_manager_settings_daemon_accounts_service_proxy_gala_drawing_style_manager_settings_daemon_accounts_service_interface_init (GalaDrawingStyleManagerSettingsDaemonAccountsServiceIface* iface)
{
	iface->get_accent_color = gala_drawing_style_manager_settings_daemon_accounts_service_dbus_proxy_get_accent_color;
	iface->set_accent_color = gala_drawing_style_manager_settings_daemon_accounts_service_dbus_proxy_set_accent_color;
}

static void
gala_drawing_style_manager_settings_daemon_accounts_service_dbus_interface_method_call (GDBusConnection* connection,
                                                                                        const gchar* sender,
                                                                                        const gchar* object_path,
                                                                                        const gchar* interface_name,
                                                                                        const gchar* method_name,
                                                                                        GVariant* parameters,
                                                                                        GDBusMethodInvocation* invocation,
                                                                                        gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}

static GVariant*
_dbus_gala_drawing_style_manager_settings_daemon_accounts_service_get_accent_color (GalaDrawingStyleManagerSettingsDaemonAccountsService* self)
{
	gint result;
	GVariant* _reply;
	result = gala_drawing_style_manager_settings_daemon_accounts_service_get_accent_color (self);
	_reply = g_variant_new_int32 (result);
	return _reply;
}

static GVariant*
gala_drawing_style_manager_settings_daemon_accounts_service_dbus_interface_get_property (GDBusConnection* connection,
                                                                                         const gchar* sender,
                                                                                         const gchar* object_path,
                                                                                         const gchar* interface_name,
                                                                                         const gchar* property_name,
                                                                                         GError** error,
                                                                                         gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "AccentColor") == 0) {
		return _dbus_gala_drawing_style_manager_settings_daemon_accounts_service_get_accent_color (object);
	}
	return NULL;
}

static void
_dbus_gala_drawing_style_manager_settings_daemon_accounts_service_set_accent_color (GalaDrawingStyleManagerSettingsDaemonAccountsService* self,
                                                                                    GVariant* _value)
{
	gint value = 0;
	value = g_variant_get_int32 (_value);
	gala_drawing_style_manager_settings_daemon_accounts_service_set_accent_color (self, value);
}

static gboolean
gala_drawing_style_manager_settings_daemon_accounts_service_dbus_interface_set_property (GDBusConnection* connection,
                                                                                         const gchar* sender,
                                                                                         const gchar* object_path,
                                                                                         const gchar* interface_name,
                                                                                         const gchar* property_name,
                                                                                         GVariant* value,
                                                                                         GError** error,
                                                                                         gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "AccentColor") == 0) {
		_dbus_gala_drawing_style_manager_settings_daemon_accounts_service_set_accent_color (object, value);
		return TRUE;
	}
	return FALSE;
}

static guint
gala_drawing_style_manager_settings_daemon_accounts_service_register_object (gpointer object,
                                                                             GDBusConnection* connection,
                                                                             const gchar* path,
                                                                             GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_gala_drawing_style_manager_settings_daemon_accounts_service_dbus_interface_info), &_gala_drawing_style_manager_settings_daemon_accounts_service_dbus_interface_vtable, data, _gala_drawing_style_manager_settings_daemon_accounts_service_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_gala_drawing_style_manager_settings_daemon_accounts_service_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
_gala_drawing_style_manager___lambda19_ (GalaDrawingStyleManager* self)
{
	gala_drawing_style_manager_connect_to_accounts_service (self, NULL, NULL);
}

static void
__gala_drawing_style_manager___lambda19__gbus_name_appeared_callback (GDBusConnection* connection,
                                                                      const gchar* name,
                                                                      const gchar* name_owner,
                                                                      gpointer self)
{
	_gala_drawing_style_manager___lambda19_ ((GalaDrawingStyleManager*) self);
}

static void
_gala_drawing_style_manager___lambda20_ (GalaDrawingStyleManager* self)
{
	_g_object_unref0 (self->priv->pantheon_proxy);
	self->priv->pantheon_proxy = NULL;
	_g_object_unref0 (self->priv->settings_daemon_proxy);
	self->priv->settings_daemon_proxy = NULL;
}

static void
__gala_drawing_style_manager___lambda20__gbus_name_vanished_callback (GDBusConnection* connection,
                                                                      const gchar* name,
                                                                      gpointer self)
{
	_gala_drawing_style_manager___lambda20_ ((GalaDrawingStyleManager*) self);
}

static GObject *
gala_drawing_style_manager_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaDrawingStyleManager * self;
	parent_class = G_OBJECT_CLASS (gala_drawing_style_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_DRAWING_TYPE_STYLE_MANAGER, GalaDrawingStyleManager);
	g_bus_watch_name_with_closures (G_BUS_TYPE_SYSTEM, GALA_DRAWING_STYLE_MANAGER_FDO_ACCOUNTS_NAME, G_BUS_NAME_WATCHER_FLAGS_NONE, (GClosure*) ((__gala_drawing_style_manager___lambda19__gbus_name_appeared_callback == NULL) ? NULL : g_cclosure_new ((GCallback) __gala_drawing_style_manager___lambda19__gbus_name_appeared_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((__gala_drawing_style_manager___lambda20__gbus_name_vanished_callback == NULL) ? NULL : g_cclosure_new ((GCallback) __gala_drawing_style_manager___lambda20__gbus_name_vanished_callback, g_object_ref (self), (GClosureNotify) g_object_unref)));
	return obj;
}

static void
gala_drawing_style_manager_class_init (GalaDrawingStyleManagerClass * klass,
                                       gpointer klass_data)
{
	gala_drawing_style_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaDrawingStyleManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_drawing_style_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_drawing_style_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_drawing_style_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_drawing_style_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_DRAWING_STYLE_MANAGER_PREFERS_COLOR_SCHEME_PROPERTY, gala_drawing_style_manager_properties[GALA_DRAWING_STYLE_MANAGER_PREFERS_COLOR_SCHEME_PROPERTY] = g_param_spec_enum ("prefers-color-scheme", "prefers-color-scheme", "prefers-color-scheme", GALA_DRAWING_STYLE_MANAGER_TYPE_COLOR_SCHEME, GALA_DRAWING_STYLE_MANAGER_COLOR_SCHEME_LIGHT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_DRAWING_STYLE_MANAGER_THEME_ACCENT_COLOR_PROPERTY, gala_drawing_style_manager_properties[GALA_DRAWING_STYLE_MANAGER_THEME_ACCENT_COLOR_PROPERTY] = g_param_spec_boxed ("theme-accent-color", "theme-accent-color", "theme-accent-color", clutter_color_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
gala_drawing_style_manager_instance_init (GalaDrawingStyleManager * self,
                                          gpointer klass)
{
	self->priv = gala_drawing_style_manager_get_instance_private (self);
	self->priv->_prefers_color_scheme = GALA_DRAWING_STYLE_MANAGER_COLOR_SCHEME_LIGHT;
	self->priv->_theme_accent_color = (ClutterColor) {(guint8) 0, (guint8) 0, (guint8) 0, GALA_DRAWING_STYLE_MANAGER_ACCENT_COLOR_ALPHA};
}

static void
gala_drawing_style_manager_finalize (GObject * obj)
{
	GalaDrawingStyleManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_DRAWING_TYPE_STYLE_MANAGER, GalaDrawingStyleManager);
	_g_object_unref0 (self->priv->pantheon_proxy);
	_g_object_unref0 (self->priv->settings_daemon_proxy);
	G_OBJECT_CLASS (gala_drawing_style_manager_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gala_drawing_style_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaDrawingStyleManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_drawing_style_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaDrawingStyleManager), 0, (GInstanceInitFunc) gala_drawing_style_manager_instance_init, NULL };
	GType gala_drawing_style_manager_type_id;
	gala_drawing_style_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaDrawingStyleManager", &g_define_type_info, 0);
	GalaDrawingStyleManager_private_offset = g_type_add_instance_private (gala_drawing_style_manager_type_id, sizeof (GalaDrawingStyleManagerPrivate));
	return gala_drawing_style_manager_type_id;
}

GType
gala_drawing_style_manager_get_type (void)
{
	static gsize gala_drawing_style_manager_type_id__once = 0;
	if (g_once_init_enter (&gala_drawing_style_manager_type_id__once)) {
		GType gala_drawing_style_manager_type_id;
		gala_drawing_style_manager_type_id = gala_drawing_style_manager_get_type_once ();
		g_once_init_leave (&gala_drawing_style_manager_type_id__once, gala_drawing_style_manager_type_id);
	}
	return gala_drawing_style_manager_type_id__once;
}

static void
_vala_gala_drawing_style_manager_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	GalaDrawingStyleManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_DRAWING_TYPE_STYLE_MANAGER, GalaDrawingStyleManager);
	switch (property_id) {
		case GALA_DRAWING_STYLE_MANAGER_PREFERS_COLOR_SCHEME_PROPERTY:
		g_value_set_enum (value, gala_drawing_style_manager_get_prefers_color_scheme (self));
		break;
		case GALA_DRAWING_STYLE_MANAGER_THEME_ACCENT_COLOR_PROPERTY:
		{
			ClutterColor boxed;
			gala_drawing_style_manager_get_theme_accent_color (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_drawing_style_manager_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	GalaDrawingStyleManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_DRAWING_TYPE_STYLE_MANAGER, GalaDrawingStyleManager);
	switch (property_id) {
		case GALA_DRAWING_STYLE_MANAGER_PREFERS_COLOR_SCHEME_PROPERTY:
		gala_drawing_style_manager_set_prefers_color_scheme (self, g_value_get_enum (value));
		break;
		case GALA_DRAWING_STYLE_MANAGER_THEME_ACCENT_COLOR_PROPERTY:
		gala_drawing_style_manager_set_theme_accent_color (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

