/// AUTO GENERATED BY build.rs

use std::collections::HashMap;

use webrender_build::shader::ShaderVersion;

pub struct SourceWithDigest {
    pub source: &'static str,
    pub digest: &'static str,
}

pub struct OptimizedSourceWithDigest {
    pub vert_source: &'static str,
    pub frag_source: &'static str,
    pub digest: &'static str,
}

lazy_static! {
  pub static ref UNOPTIMIZED_SHADERS: HashMap<&'static str, SourceWithDigest> = {
    let mut shaders = HashMap::new();
    shaders.insert("base", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/base.glsl"), digest: "d5ae695bab268b7d"});
    shaders.insert("blend", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/blend.glsl"), digest: "632e49345a7b9212"});
    shaders.insert("brush", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/brush.glsl"), digest: "25d75cc503d5110f"});
    shaders.insert("brush_blend", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/brush_blend.glsl"), digest: "3dda969bed37fc0b"});
    shaders.insert("brush_image", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/brush_image.glsl"), digest: "f4b6cf65196bc546"});
    shaders.insert("brush_linear_gradient", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/brush_linear_gradient.glsl"), digest: "41778d8acab3c229"});
    shaders.insert("brush_mix_blend", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/brush_mix_blend.glsl"), digest: "d9fa7c7187d374f4"});
    shaders.insert("brush_opacity", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/brush_opacity.glsl"), digest: "795c82f6ac7aa483"});
    shaders.insert("brush_solid", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/brush_solid.glsl"), digest: "82a70a87b8a9c60b"});
    shaders.insert("brush_yuv_image", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/brush_yuv_image.glsl"), digest: "42c874906abf3e65"});
    shaders.insert("clip_shared", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/clip_shared.glsl"), digest: "d1c80f797792dd3c"});
    shaders.insert("composite", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/composite.glsl"), digest: "7cd9992d7fe3c8bb"});
    shaders.insert("cs_blur", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/cs_blur.glsl"), digest: "7218541c47c6c6f1"});
    shaders.insert("cs_border_segment", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/cs_border_segment.glsl"), digest: "c8e71ab0082eda8a"});
    shaders.insert("cs_border_solid", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/cs_border_solid.glsl"), digest: "b5b914af8b69233d"});
    shaders.insert("cs_clip_box_shadow", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/cs_clip_box_shadow.glsl"), digest: "7ed0a329b043adc2"});
    shaders.insert("cs_clip_rectangle", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/cs_clip_rectangle.glsl"), digest: "e07e61e9073719ac"});
    shaders.insert("cs_conic_gradient", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/cs_conic_gradient.glsl"), digest: "fc6177f5f3c6ac8b"});
    shaders.insert("cs_fast_linear_gradient", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/cs_fast_linear_gradient.glsl"), digest: "d61c63a203671fbf"});
    shaders.insert("cs_line_decoration", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/cs_line_decoration.glsl"), digest: "8b8301f98084aa89"});
    shaders.insert("cs_linear_gradient", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/cs_linear_gradient.glsl"), digest: "46ce0a81a5e44370"});
    shaders.insert("cs_radial_gradient", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/cs_radial_gradient.glsl"), digest: "ce2eb7e38f7a7a45"});
    shaders.insert("cs_scale", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/cs_scale.glsl"), digest: "f1261b7accba411"});
    shaders.insert("cs_svg_filter_node", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/cs_svg_filter_node.glsl"), digest: "951ea5c8117b5eb6"});
    shaders.insert("debug_color", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/debug_color.glsl"), digest: "51948a4e62ec49ef"});
    shaders.insert("debug_font", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/debug_font.glsl"), digest: "9546b37587d9114e"});
    shaders.insert("dithering", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/dithering.glsl"), digest: "546e054502d20aa0"});
    shaders.insert("ellipse", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/ellipse.glsl"), digest: "951dc637533b8416"});
    shaders.insert("gpu_buffer", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/gpu_buffer.glsl"), digest: "55c6bea60ba278bb"});
    shaders.insert("gpu_cache_update", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/gpu_cache_update.glsl"), digest: "4ad2e4e46e03b7c2"});
    shaders.insert("gradient", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/gradient.glsl"), digest: "d72f0a3d2c7310b4"});
    shaders.insert("gradient_shared", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/gradient_shared.glsl"), digest: "b6da23e10d3de9c1"});
    shaders.insert("image_source", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/image_source.glsl"), digest: "d5bdfbfd6d833887"});
    shaders.insert("prim_shared", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/prim_shared.glsl"), digest: "1ff308278dbfca72"});
    shaders.insert("ps_clear", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/ps_clear.glsl"), digest: "44180e904e9ec507"});
    shaders.insert("ps_copy", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/ps_copy.glsl"), digest: "f0e76514309bd9fa"});
    shaders.insert("ps_quad", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/ps_quad.glsl"), digest: "eb5d5924a5f90830"});
    shaders.insert("ps_quad_conic_gradient", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/ps_quad_conic_gradient.glsl"), digest: "ccd0bb366985d1f9"});
    shaders.insert("ps_quad_gradient", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/ps_quad_gradient.glsl"), digest: "a4e55c8293e7d8e7"});
    shaders.insert("ps_quad_mask", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/ps_quad_mask.glsl"), digest: "64b097a8555b6f33"});
    shaders.insert("ps_quad_radial_gradient", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/ps_quad_radial_gradient.glsl"), digest: "5f39e15215df4e93"});
    shaders.insert("ps_quad_textured", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/ps_quad_textured.glsl"), digest: "3bfb7f79beb3d916"});
    shaders.insert("ps_split_composite", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/ps_split_composite.glsl"), digest: "c3b9e4b169c053a4"});
    shaders.insert("ps_text_run", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/ps_text_run.glsl"), digest: "c4e1aa2c4915a237"});
    shaders.insert("rect", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/rect.glsl"), digest: "fc8ccaeee104d458"});
    shaders.insert("render_task", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/render_task.glsl"), digest: "e63b52526d4047fd"});
    shaders.insert("sample_color0", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/sample_color0.glsl"), digest: "a2c2acd5c7727200"});
    shaders.insert("shared", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/shared.glsl"), digest: "abc76c7c94e87e5e"});
    shaders.insert("shared_other", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/shared_other.glsl"), digest: "9f6298a27dfe79c6"});
    shaders.insert("transform", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/transform.glsl"), digest: "19d18cb3634fb3d7"});
    shaders.insert("yuv", SourceWithDigest { source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/gfx/wr/webrender/res/yuv.glsl"), digest: "2a842da0f4efcbe2"});
    shaders
  };

  pub static ref OPTIMIZED_SHADERS: HashMap<(ShaderVersion, &'static str), OptimizedSourceWithDigest> = {
    let mut shaders = HashMap::new();
    shaders.insert((ShaderVersion::Gl, "brush_blend"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_blend_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_blend_Gl.frag"),
        digest: "1ea0317b85dc5ee2",
    });
    shaders.insert((ShaderVersion::Gl, "brush_blend_ALPHA_PASS"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_blend_ALPHA_PASS_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_blend_ALPHA_PASS_Gl.frag"),
        digest: "666ec5593d2f0003",
    });
    shaders.insert((ShaderVersion::Gl, "brush_blend_DEBUG_OVERDRAW"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_blend_DEBUG_OVERDRAW_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_blend_DEBUG_OVERDRAW_Gl.frag"),
        digest: "3dc9b0e2c4badb3a",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ADVANCED_BLEND_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_image_ADVANCED_BLEND_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_image_ADVANCED_BLEND_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_2D_Gl.frag"),
        digest: "1946d5cd1e9ff9a1",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ADVANCED_BLEND_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_RECT"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_image_ADVANCED_BLEND_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_RECT_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_image_ADVANCED_BLEND_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_RECT_Gl.frag"),
        digest: "37f00786a4f6988c",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ADVANCED_BLEND_ALPHA_PASS_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_image_ADVANCED_BLEND_ALPHA_PASS_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_image_ADVANCED_BLEND_ALPHA_PASS_TEXTURE_2D_Gl.frag"),
        digest: "e309788612aa4548",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ADVANCED_BLEND_ALPHA_PASS_TEXTURE_RECT"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_image_ADVANCED_BLEND_ALPHA_PASS_TEXTURE_RECT_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_image_ADVANCED_BLEND_ALPHA_PASS_TEXTURE_RECT_Gl.frag"),
        digest: "9ed7e2d4861f1bc7",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ALPHA_PASS_ANTIALIASING_DUAL_SOURCE_BLENDING_REPETITION_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_image_ALPHA_PASS_ANTIALIASING_DUAL_SOURCE_BLENDING_REPETITION_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_image_ALPHA_PASS_ANTIALIASING_DUAL_SOURCE_BLENDING_REPETITION_TEXTURE_2D_Gl.frag"),
        digest: "2e07776d57f00f85",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ALPHA_PASS_ANTIALIASING_DUAL_SOURCE_BLENDING_REPETITION_TEXTURE_RECT"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_image_ALPHA_PASS_ANTIALIASING_DUAL_SOURCE_BLENDING_REPETITION_TEXTURE_RECT_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_image_ALPHA_PASS_ANTIALIASING_DUAL_SOURCE_BLENDING_REPETITION_TEXTURE_RECT_Gl.frag"),
        digest: "f666a911a3db94ba",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_image_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_image_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_2D_Gl.frag"),
        digest: "566f8f724db311c4",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_RECT"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_image_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_RECT_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_image_ALPHA_PASS_ANTIALIASING_REPETITION_TEXTURE_RECT_Gl.frag"),
        digest: "3f42b215cbd87d35",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ALPHA_PASS_DUAL_SOURCE_BLENDING_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_image_ALPHA_PASS_DUAL_SOURCE_BLENDING_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_image_ALPHA_PASS_DUAL_SOURCE_BLENDING_TEXTURE_2D_Gl.frag"),
        digest: "a5372295d04e8116",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ALPHA_PASS_DUAL_SOURCE_BLENDING_TEXTURE_RECT"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_image_ALPHA_PASS_DUAL_SOURCE_BLENDING_TEXTURE_RECT_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_image_ALPHA_PASS_DUAL_SOURCE_BLENDING_TEXTURE_RECT_Gl.frag"),
        digest: "66c3b06c69ae0897",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ALPHA_PASS_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_image_ALPHA_PASS_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_image_ALPHA_PASS_TEXTURE_2D_Gl.frag"),
        digest: "5764c5a963ce2414",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ALPHA_PASS_TEXTURE_RECT"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_image_ALPHA_PASS_TEXTURE_RECT_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_image_ALPHA_PASS_TEXTURE_RECT_Gl.frag"),
        digest: "9b55d6f63fc126b3",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ANTIALIASING_DEBUG_OVERDRAW_REPETITION_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_image_ANTIALIASING_DEBUG_OVERDRAW_REPETITION_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_image_ANTIALIASING_DEBUG_OVERDRAW_REPETITION_TEXTURE_2D_Gl.frag"),
        digest: "d407afbb3a3fe2a7",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ANTIALIASING_DEBUG_OVERDRAW_REPETITION_TEXTURE_RECT"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_image_ANTIALIASING_DEBUG_OVERDRAW_REPETITION_TEXTURE_RECT_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_image_ANTIALIASING_DEBUG_OVERDRAW_REPETITION_TEXTURE_RECT_Gl.frag"),
        digest: "390ea63412a1c39e",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ANTIALIASING_REPETITION_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_image_ANTIALIASING_REPETITION_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_image_ANTIALIASING_REPETITION_TEXTURE_2D_Gl.frag"),
        digest: "88ad528d3c08a612",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_ANTIALIASING_REPETITION_TEXTURE_RECT"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_image_ANTIALIASING_REPETITION_TEXTURE_RECT_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_image_ANTIALIASING_REPETITION_TEXTURE_RECT_Gl.frag"),
        digest: "e70cde8442eb56a0",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_DEBUG_OVERDRAW_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_image_DEBUG_OVERDRAW_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_image_DEBUG_OVERDRAW_TEXTURE_2D_Gl.frag"),
        digest: "ba051c504bebf7e4",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_DEBUG_OVERDRAW_TEXTURE_RECT"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_image_DEBUG_OVERDRAW_TEXTURE_RECT_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_image_DEBUG_OVERDRAW_TEXTURE_RECT_Gl.frag"),
        digest: "cc397f7a6299887e",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_image_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_image_TEXTURE_2D_Gl.frag"),
        digest: "91bc86e6cc92308e",
    });
    shaders.insert((ShaderVersion::Gl, "brush_image_TEXTURE_RECT"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_image_TEXTURE_RECT_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_image_TEXTURE_RECT_Gl.frag"),
        digest: "3af7762ac6af50b3",
    });
    shaders.insert((ShaderVersion::Gl, "brush_linear_gradient"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_linear_gradient_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_linear_gradient_Gl.frag"),
        digest: "f088b3024dd5326b",
    });
    shaders.insert((ShaderVersion::Gl, "brush_linear_gradient_ALPHA_PASS"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_linear_gradient_ALPHA_PASS_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_linear_gradient_ALPHA_PASS_Gl.frag"),
        digest: "3beb715dd3d567ff",
    });
    shaders.insert((ShaderVersion::Gl, "brush_linear_gradient_DEBUG_OVERDRAW"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_linear_gradient_DEBUG_OVERDRAW_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_linear_gradient_DEBUG_OVERDRAW_Gl.frag"),
        digest: "2722df3aca54f819",
    });
    shaders.insert((ShaderVersion::Gl, "brush_mix_blend"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_mix_blend_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_mix_blend_Gl.frag"),
        digest: "b408ab2733a2da0e",
    });
    shaders.insert((ShaderVersion::Gl, "brush_mix_blend_ALPHA_PASS"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_mix_blend_ALPHA_PASS_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_mix_blend_ALPHA_PASS_Gl.frag"),
        digest: "10b2b8634bb83681",
    });
    shaders.insert((ShaderVersion::Gl, "brush_mix_blend_DEBUG_OVERDRAW"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_mix_blend_DEBUG_OVERDRAW_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_mix_blend_DEBUG_OVERDRAW_Gl.frag"),
        digest: "3a145ef1abaa829",
    });
    shaders.insert((ShaderVersion::Gl, "brush_opacity"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_opacity_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_opacity_Gl.frag"),
        digest: "bca1b0cb43d554e",
    });
    shaders.insert((ShaderVersion::Gl, "brush_opacity_ALPHA_PASS"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_opacity_ALPHA_PASS_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_opacity_ALPHA_PASS_Gl.frag"),
        digest: "da17c158ca65de5e",
    });
    shaders.insert((ShaderVersion::Gl, "brush_opacity_ALPHA_PASS_ANTIALIASING"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_opacity_ALPHA_PASS_ANTIALIASING_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_opacity_ALPHA_PASS_ANTIALIASING_Gl.frag"),
        digest: "89978297d6ad54b5",
    });
    shaders.insert((ShaderVersion::Gl, "brush_opacity_ANTIALIASING"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_opacity_ANTIALIASING_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_opacity_ANTIALIASING_Gl.frag"),
        digest: "327f39239e8c40be",
    });
    shaders.insert((ShaderVersion::Gl, "brush_opacity_ANTIALIASING_DEBUG_OVERDRAW"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_opacity_ANTIALIASING_DEBUG_OVERDRAW_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_opacity_ANTIALIASING_DEBUG_OVERDRAW_Gl.frag"),
        digest: "6b85269b85a02b6",
    });
    shaders.insert((ShaderVersion::Gl, "brush_opacity_DEBUG_OVERDRAW"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_opacity_DEBUG_OVERDRAW_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_opacity_DEBUG_OVERDRAW_Gl.frag"),
        digest: "28e8e5111ac61809",
    });
    shaders.insert((ShaderVersion::Gl, "brush_solid"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_solid_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_solid_Gl.frag"),
        digest: "3920ff8fae8ad120",
    });
    shaders.insert((ShaderVersion::Gl, "brush_solid_ALPHA_PASS"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_solid_ALPHA_PASS_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_solid_ALPHA_PASS_Gl.frag"),
        digest: "37585c9d551f791e",
    });
    shaders.insert((ShaderVersion::Gl, "brush_solid_DEBUG_OVERDRAW"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_solid_DEBUG_OVERDRAW_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_solid_DEBUG_OVERDRAW_Gl.frag"),
        digest: "a74bae49b91f2683",
    });
    shaders.insert((ShaderVersion::Gl, "brush_yuv_image_ALPHA_PASS_TEXTURE_2D_YUV"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_yuv_image_ALPHA_PASS_TEXTURE_2D_YUV_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_yuv_image_ALPHA_PASS_TEXTURE_2D_YUV_Gl.frag"),
        digest: "7626ca25fa3c2615",
    });
    shaders.insert((ShaderVersion::Gl, "brush_yuv_image_ALPHA_PASS_TEXTURE_RECT_YUV"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_yuv_image_ALPHA_PASS_TEXTURE_RECT_YUV_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_yuv_image_ALPHA_PASS_TEXTURE_RECT_YUV_Gl.frag"),
        digest: "285859573da9bcac",
    });
    shaders.insert((ShaderVersion::Gl, "brush_yuv_image_DEBUG_OVERDRAW_TEXTURE_2D_YUV"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_yuv_image_DEBUG_OVERDRAW_TEXTURE_2D_YUV_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_yuv_image_DEBUG_OVERDRAW_TEXTURE_2D_YUV_Gl.frag"),
        digest: "7da832fda1a4d325",
    });
    shaders.insert((ShaderVersion::Gl, "brush_yuv_image_DEBUG_OVERDRAW_TEXTURE_RECT_YUV"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_yuv_image_DEBUG_OVERDRAW_TEXTURE_RECT_YUV_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_yuv_image_DEBUG_OVERDRAW_TEXTURE_RECT_YUV_Gl.frag"),
        digest: "f5236400daf26353",
    });
    shaders.insert((ShaderVersion::Gl, "brush_yuv_image_TEXTURE_2D_YUV"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_yuv_image_TEXTURE_2D_YUV_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_yuv_image_TEXTURE_2D_YUV_Gl.frag"),
        digest: "c9d620008e83b7aa",
    });
    shaders.insert((ShaderVersion::Gl, "brush_yuv_image_TEXTURE_RECT_YUV"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_yuv_image_TEXTURE_RECT_YUV_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/brush_yuv_image_TEXTURE_RECT_YUV_Gl.frag"),
        digest: "d0cc047d2691d0bf",
    });
    shaders.insert((ShaderVersion::Gl, "composite_FAST_PATH_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/composite_FAST_PATH_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/composite_FAST_PATH_TEXTURE_2D_Gl.frag"),
        digest: "38337df702db9563",
    });
    shaders.insert((ShaderVersion::Gl, "composite_FAST_PATH_TEXTURE_2D_YUV"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/composite_FAST_PATH_TEXTURE_2D_YUV_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/composite_FAST_PATH_TEXTURE_2D_YUV_Gl.frag"),
        digest: "b110320ae45549f4",
    });
    shaders.insert((ShaderVersion::Gl, "composite_FAST_PATH_TEXTURE_RECT"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/composite_FAST_PATH_TEXTURE_RECT_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/composite_FAST_PATH_TEXTURE_RECT_Gl.frag"),
        digest: "9b2aaced4f63da7a",
    });
    shaders.insert((ShaderVersion::Gl, "composite_FAST_PATH_TEXTURE_RECT_YUV"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/composite_FAST_PATH_TEXTURE_RECT_YUV_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/composite_FAST_PATH_TEXTURE_RECT_YUV_Gl.frag"),
        digest: "59af6a9ec94e3c8",
    });
    shaders.insert((ShaderVersion::Gl, "composite_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/composite_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/composite_TEXTURE_2D_Gl.frag"),
        digest: "b32d10135c3b408c",
    });
    shaders.insert((ShaderVersion::Gl, "composite_TEXTURE_2D_YUV"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/composite_TEXTURE_2D_YUV_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/composite_TEXTURE_2D_YUV_Gl.frag"),
        digest: "f6074057f0d78cc0",
    });
    shaders.insert((ShaderVersion::Gl, "composite_TEXTURE_RECT"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/composite_TEXTURE_RECT_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/composite_TEXTURE_RECT_Gl.frag"),
        digest: "daedc68c52f634ec",
    });
    shaders.insert((ShaderVersion::Gl, "composite_TEXTURE_RECT_YUV"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/composite_TEXTURE_RECT_YUV_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/composite_TEXTURE_RECT_YUV_Gl.frag"),
        digest: "3343284f00e49354",
    });
    shaders.insert((ShaderVersion::Gl, "cs_blur_ALPHA_TARGET"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/cs_blur_ALPHA_TARGET_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/cs_blur_ALPHA_TARGET_Gl.frag"),
        digest: "1b00c373598eba4c",
    });
    shaders.insert((ShaderVersion::Gl, "cs_blur_COLOR_TARGET"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/cs_blur_COLOR_TARGET_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/cs_blur_COLOR_TARGET_Gl.frag"),
        digest: "c15f1f64491e4156",
    });
    shaders.insert((ShaderVersion::Gl, "cs_border_segment"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/cs_border_segment_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/cs_border_segment_Gl.frag"),
        digest: "8495134f5ed37bf5",
    });
    shaders.insert((ShaderVersion::Gl, "cs_border_solid"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/cs_border_solid_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/cs_border_solid_Gl.frag"),
        digest: "9fd688a8c266d2da",
    });
    shaders.insert((ShaderVersion::Gl, "cs_clip_box_shadow_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/cs_clip_box_shadow_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/cs_clip_box_shadow_TEXTURE_2D_Gl.frag"),
        digest: "78cf272a52dca764",
    });
    shaders.insert((ShaderVersion::Gl, "cs_clip_rectangle"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/cs_clip_rectangle_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/cs_clip_rectangle_Gl.frag"),
        digest: "cabc2ef7edf7bd12",
    });
    shaders.insert((ShaderVersion::Gl, "cs_clip_rectangle_FAST_PATH"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/cs_clip_rectangle_FAST_PATH_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/cs_clip_rectangle_FAST_PATH_Gl.frag"),
        digest: "34a6b9252197cd36",
    });
    shaders.insert((ShaderVersion::Gl, "cs_conic_gradient"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/cs_conic_gradient_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/cs_conic_gradient_Gl.frag"),
        digest: "62367e600dc704f2",
    });
    shaders.insert((ShaderVersion::Gl, "cs_fast_linear_gradient"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/cs_fast_linear_gradient_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/cs_fast_linear_gradient_Gl.frag"),
        digest: "3d4ec20a2b40f905",
    });
    shaders.insert((ShaderVersion::Gl, "cs_line_decoration"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/cs_line_decoration_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/cs_line_decoration_Gl.frag"),
        digest: "7943c68da0973c69",
    });
    shaders.insert((ShaderVersion::Gl, "cs_linear_gradient"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/cs_linear_gradient_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/cs_linear_gradient_Gl.frag"),
        digest: "efc10ff6f6cc1952",
    });
    shaders.insert((ShaderVersion::Gl, "cs_radial_gradient"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/cs_radial_gradient_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/cs_radial_gradient_Gl.frag"),
        digest: "7336dc777aa9329c",
    });
    shaders.insert((ShaderVersion::Gl, "cs_scale_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/cs_scale_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/cs_scale_TEXTURE_2D_Gl.frag"),
        digest: "287afd7873f6d6b2",
    });
    shaders.insert((ShaderVersion::Gl, "cs_scale_TEXTURE_RECT"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/cs_scale_TEXTURE_RECT_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/cs_scale_TEXTURE_RECT_Gl.frag"),
        digest: "4fbbb7c5d7cb368e",
    });
    shaders.insert((ShaderVersion::Gl, "cs_svg_filter_node"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/cs_svg_filter_node_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/cs_svg_filter_node_Gl.frag"),
        digest: "df4294d835bdbea6",
    });
    shaders.insert((ShaderVersion::Gl, "debug_color"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/debug_color_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/debug_color_Gl.frag"),
        digest: "f458fe7ea40bd77e",
    });
    shaders.insert((ShaderVersion::Gl, "debug_font"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/debug_font_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/debug_font_Gl.frag"),
        digest: "503ec56c19b6bd2c",
    });
    shaders.insert((ShaderVersion::Gl, "ps_clear"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/ps_clear_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/ps_clear_Gl.frag"),
        digest: "9ef2acc3bbd621e8",
    });
    shaders.insert((ShaderVersion::Gl, "ps_copy"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/ps_copy_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/ps_copy_Gl.frag"),
        digest: "514726576460ee72",
    });
    shaders.insert((ShaderVersion::Gl, "ps_quad_conic_gradient"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/ps_quad_conic_gradient_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/ps_quad_conic_gradient_Gl.frag"),
        digest: "9a94176a19b247f",
    });
    shaders.insert((ShaderVersion::Gl, "ps_quad_gradient"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/ps_quad_gradient_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/ps_quad_gradient_Gl.frag"),
        digest: "90f1eb5a658e2bd2",
    });
    shaders.insert((ShaderVersion::Gl, "ps_quad_mask"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/ps_quad_mask_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/ps_quad_mask_Gl.frag"),
        digest: "e3126822e21fc71e",
    });
    shaders.insert((ShaderVersion::Gl, "ps_quad_mask_FAST_PATH"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/ps_quad_mask_FAST_PATH_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/ps_quad_mask_FAST_PATH_Gl.frag"),
        digest: "2b00f48fed69918b",
    });
    shaders.insert((ShaderVersion::Gl, "ps_quad_radial_gradient"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/ps_quad_radial_gradient_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/ps_quad_radial_gradient_Gl.frag"),
        digest: "dd72e8d71eda26c6",
    });
    shaders.insert((ShaderVersion::Gl, "ps_quad_textured"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/ps_quad_textured_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/ps_quad_textured_Gl.frag"),
        digest: "88d8b639eb5fe549",
    });
    shaders.insert((ShaderVersion::Gl, "ps_split_composite"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/ps_split_composite_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/ps_split_composite_Gl.frag"),
        digest: "700963f17f4b1bc8",
    });
    shaders.insert((ShaderVersion::Gl, "ps_text_run_ALPHA_PASS_DUAL_SOURCE_BLENDING_GLYPH_TRANSFORM_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/ps_text_run_ALPHA_PASS_DUAL_SOURCE_BLENDING_GLYPH_TRANSFORM_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/ps_text_run_ALPHA_PASS_DUAL_SOURCE_BLENDING_GLYPH_TRANSFORM_TEXTURE_2D_Gl.frag"),
        digest: "96d12f022a5bb163",
    });
    shaders.insert((ShaderVersion::Gl, "ps_text_run_ALPHA_PASS_DUAL_SOURCE_BLENDING_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/ps_text_run_ALPHA_PASS_DUAL_SOURCE_BLENDING_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/ps_text_run_ALPHA_PASS_DUAL_SOURCE_BLENDING_TEXTURE_2D_Gl.frag"),
        digest: "f51bd2bc4aea8ec8",
    });
    shaders.insert((ShaderVersion::Gl, "ps_text_run_ALPHA_PASS_GLYPH_TRANSFORM_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/ps_text_run_ALPHA_PASS_GLYPH_TRANSFORM_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/ps_text_run_ALPHA_PASS_GLYPH_TRANSFORM_TEXTURE_2D_Gl.frag"),
        digest: "fd5784dc5f9910f9",
    });
    shaders.insert((ShaderVersion::Gl, "ps_text_run_ALPHA_PASS_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/ps_text_run_ALPHA_PASS_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/ps_text_run_ALPHA_PASS_TEXTURE_2D_Gl.frag"),
        digest: "591ead476586336f",
    });
    shaders.insert((ShaderVersion::Gl, "ps_text_run_DEBUG_OVERDRAW_DUAL_SOURCE_BLENDING_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/ps_text_run_DEBUG_OVERDRAW_DUAL_SOURCE_BLENDING_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/ps_text_run_DEBUG_OVERDRAW_DUAL_SOURCE_BLENDING_TEXTURE_2D_Gl.frag"),
        digest: "b3c83bdedd0ad148",
    });
    shaders.insert((ShaderVersion::Gl, "ps_text_run_DEBUG_OVERDRAW_TEXTURE_2D"), OptimizedSourceWithDigest {
        vert_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/ps_text_run_DEBUG_OVERDRAW_TEXTURE_2D_Gl.vert"),
        frag_source: include_str!("/build/firefox-developer-edition/src/firefox-148.0/obj/x86_64-unknown-linux-gnu/release/build/webrender-4ba8c3805d4e1604/out/ps_text_run_DEBUG_OVERDRAW_TEXTURE_2D_Gl.frag"),
        digest: "e7a11c5f589a6e38",
    });
    shaders
  };
}
