
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "tabbar_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"

// Wrappers
#include "combotabbar_wrapper.h"

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_TabBar_Type = nullptr;
static PyTypeObject *Sbk_TabBar_TypeF(void)
{
    return _Sbk_TabBar_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void TabBarWrapper::pysideInitQtMetaTypes()
{
}

void TabBarWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

TabBarWrapper::TabBarWrapper(::BrowserWindow * window, ::TabWidget * tabWidget) : TabBar(window, tabWidget)
{
}

void TabBarWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabBar_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    WebViewWrapper::sbk_o_actionEvent("TabBar", funcName, gil, pyOverride, event);
}

void TabBarWrapper::changeEvent(::QEvent * event)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabBar_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::changeEvent(event);
    }
    WebViewWrapper::sbk_o_changeEvent("TabBar", funcName, gil, pyOverride, event);
}

void TabBarWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabBar_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("TabBar", funcName, gil, pyOverride, event);
}

void TabBarWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabBar_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    WebViewWrapper::sbk_o_closeEvent("TabBar", funcName, gil, pyOverride, event);
}

void TabBarWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabBar_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("TabBar", funcName, gil, pyOverride, signal);
}

void TabBarWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabBar_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("TabBar", funcName, gil, pyOverride, event);
}

int TabBarWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabBar_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return WebViewWrapper::sbk_o_devType("TabBar", funcName, gil, pyOverride);
}

void TabBarWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabBar_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("TabBar", funcName, gil, pyOverride, signal);
}

void TabBarWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabBar_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    WebViewWrapper::sbk_o_enterEvent("TabBar", funcName, gil, pyOverride, event);
}

bool TabBarWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabBar_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::ComboTabBar::event(event);
    }
    return WebViewWrapper::sbk_o_event("TabBar", funcName, gil, pyOverride, event);
}

bool TabBarWrapper::eventFilter(::QObject * obj, ::QEvent * ev)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabBar_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::ComboTabBar::eventFilter(obj, ev);
    }
    return WebViewWrapper::sbk_o_eventFilter("TabBar", funcName, gil, pyOverride, obj, ev);
}

void TabBarWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabBar_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    WebViewWrapper::sbk_o_focusInEvent("TabBar", funcName, gil, pyOverride, event);
}

bool TabBarWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabBar_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return WebViewWrapper::sbk_o_focusNextPrevChild("TabBar", funcName, gil, pyOverride, next);
}

void TabBarWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabBar_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    WebViewWrapper::sbk_o_focusOutEvent("TabBar", funcName, gil, pyOverride, event);
}

bool TabBarWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabBar_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return WebViewWrapper::sbk_o_hasHeightForWidth("TabBar", funcName, gil, pyOverride);
}

int TabBarWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabBar_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return WebViewWrapper::sbk_o_heightForWidth("TabBar", funcName, gil, pyOverride, arg__1);
}

void TabBarWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabBar_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    WebViewWrapper::sbk_o_hideEvent("TabBar", funcName, gil, pyOverride, event);
}

void TabBarWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabBar_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    WebViewWrapper::sbk_o_initPainter("TabBar", funcName, gil, pyOverride, painter);
}

void TabBarWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabBar_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    WebViewWrapper::sbk_o_inputMethodEvent("TabBar", funcName, gil, pyOverride, event);
}

::QVariant TabBarWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabBar_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return WebViewWrapper::sbk_o_inputMethodQuery("TabBar", funcName, gil, pyOverride, arg__1);
}

void TabBarWrapper::keyPressEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabBar_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyPressEvent(event);
    }
    WebViewWrapper::sbk_o_keyPressEvent("TabBar", funcName, gil, pyOverride, event);
}

void TabBarWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabBar_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    WebViewWrapper::sbk_o_keyReleaseEvent("TabBar", funcName, gil, pyOverride, event);
}

void TabBarWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabBar_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    WebViewWrapper::sbk_o_leaveEvent("TabBar", funcName, gil, pyOverride, event);
}

int TabBarWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabBar_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return WebViewWrapper::sbk_o_metric("TabBar", funcName, gil, pyOverride, arg__1);
}

::QSize TabBarWrapper::minimumSizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabBar_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::minimumSizeHint();
    }
    return WebViewWrapper::sbk_o_minimumSizeHint("TabBar", funcName, gil, pyOverride);
}

void TabBarWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabBar_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    WebViewWrapper::sbk_o_moveEvent("TabBar", funcName, gil, pyOverride, event);
}

bool TabBarWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabBar_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return WebViewWrapper::sbk_o_nativeEvent("TabBar", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * TabBarWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabBar_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return WebViewWrapper::sbk_o_paintEngine("TabBar", funcName, gil, pyOverride);
}

void TabBarWrapper::paintEvent(::QPaintEvent * ev)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabBar_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::ComboTabBar::paintEvent(ev);
    }
    WebViewWrapper::sbk_o_paintEvent("TabBar", funcName, gil, pyOverride, ev);
}

::QPaintDevice * TabBarWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabBar_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return WebViewWrapper::sbk_o_redirected("TabBar", funcName, gil, pyOverride, offset);
}

void TabBarWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabBar_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::resizeEvent(event);
    }
    WebViewWrapper::sbk_o_resizeEvent("TabBar", funcName, gil, pyOverride, event);
}

void TabBarWrapper::setVisible(bool visible)
{
    static const char *funcName = "setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabBar_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::TabBar::setVisible(visible);
    }
    WebViewWrapper::sbk_o_requestFullScreen("TabBar", funcName, gil, pyOverride, visible);
}

::QPainter * TabBarWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabBar_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return WebViewWrapper::sbk_o_sharedPainter("TabBar", funcName, gil, pyOverride);
}

void TabBarWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabBar_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    WebViewWrapper::sbk_o_showEvent("TabBar", funcName, gil, pyOverride, event);
}

::QSize TabBarWrapper::sizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabBar_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sizeHint();
    }
    return WebViewWrapper::sbk_o_minimumSizeHint("TabBar", funcName, gil, pyOverride);
}

void TabBarWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabBar_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    WebViewWrapper::sbk_o_tabletEvent("TabBar", funcName, gil, pyOverride, event);
}

void TabBarWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabBar_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    WebViewWrapper::sbk_o_timerEvent("TabBar", funcName, gil, pyOverride, event);
}

void TabBarWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabBar_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::TabBar::wheelEvent(event);
    }
    WebViewWrapper::sbk_o_wheelEvent("TabBar", funcName, gil, pyOverride, event);
}

const QMetaObject *TabBarWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return TabBar::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int TabBarWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = TabBar::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *TabBarWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< TabBarWrapper *>(this));
    }
    return TabBar::qt_metacast(_clname);
}

TabBarWrapper::~TabBarWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_TabBar_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_TabBar_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::TabBar >()))
        return -1;

    TabBarWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "TabBar", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: TabBar::TabBar(BrowserWindow*,TabWidget*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), (pyArgs[1])))) {
        overloadId = 0; // TabBar(BrowserWindow*,TabWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_TabBar_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_TabBar_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::BrowserWindow *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return -1;
        ::TabWidget *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // TabBar(BrowserWindow*,TabWidget*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) TabBarWrapper(cppArg0, cppArg1);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new TabBarWrapper(cppArg0, cppArg1);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< TabBar >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_TabBar_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_TabBar_IDX]);
    };


    return 1;
}

static PyObject *Sbk_TabBarFunc_comboTabBarPixelMetric(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabBarWrapper *>(reinterpret_cast< ::TabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ComboTabBar::comboTabBarPixelMetric(ComboTabBar::SizeType)const->int
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_SizeType_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // comboTabBarPixelMetric(ComboTabBar::SizeType)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "comboTabBarPixelMetric", errInfo, SbkPyFalkonTypeStructs[SBK_TabBar_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("comboTabBarPixelMetric(ComboTabBar.SizeType sizeType) const");
        return {};
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabBarFunc_contextMenuEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabBarWrapper *>(reinterpret_cast< ::TabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::contextMenuEvent(QContextMenuEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QContextMenuEvent_IDX]), (pyArg)))) {
        overloadId = 0; // contextMenuEvent(QContextMenuEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "contextMenuEvent", errInfo, SbkPyFalkonTypeStructs[SBK_TabBar_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("contextMenuEvent(QContextMenuEvent *event)");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabBarFunc_dragEnterEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabBarWrapper *>(reinterpret_cast< ::TabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::dragEnterEvent(QDragEnterEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QDragEnterEvent_IDX]), (pyArg)))) {
        overloadId = 0; // dragEnterEvent(QDragEnterEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "dragEnterEvent", errInfo, SbkPyFalkonTypeStructs[SBK_TabBar_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("dragEnterEvent(QDragEnterEvent *event)");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabBarFunc_dragLeaveEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabBarWrapper *>(reinterpret_cast< ::TabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::dragLeaveEvent(QDragLeaveEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QDragLeaveEvent_IDX]), (pyArg)))) {
        overloadId = 0; // dragLeaveEvent(QDragLeaveEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "dragLeaveEvent", errInfo, SbkPyFalkonTypeStructs[SBK_TabBar_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("dragLeaveEvent(QDragLeaveEvent *event)");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabBarFunc_dragMoveEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabBarWrapper *>(reinterpret_cast< ::TabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::dragMoveEvent(QDragMoveEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QDragMoveEvent_IDX]), (pyArg)))) {
        overloadId = 0; // dragMoveEvent(QDragMoveEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "dragMoveEvent", errInfo, SbkPyFalkonTypeStructs[SBK_TabBar_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("dragMoveEvent(QDragMoveEvent *event)");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabBarFunc_dropEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabBarWrapper *>(reinterpret_cast< ::TabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::dropEvent(QDropEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QDropEvent_IDX]), (pyArg)))) {
        overloadId = 0; // dropEvent(QDropEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "dropEvent", errInfo, SbkPyFalkonTypeStructs[SBK_TabBar_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("dropEvent(QDropEvent *event)");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabBarFunc_isRestoring(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabBarWrapper *>(reinterpret_cast< ::TabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isRestoring()
        bool cppResult = cppSelf->isRestoring();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabBarFunc_loadSettings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabBarWrapper *>(reinterpret_cast< ::TabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // loadSettings()
        cppSelf->loadSettings();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabBarFunc_mouseDoubleClickEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabBarWrapper *>(reinterpret_cast< ::TabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::mouseDoubleClickEvent(QMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QMouseEvent_IDX]), (pyArg)))) {
        overloadId = 0; // mouseDoubleClickEvent(QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "mouseDoubleClickEvent", errInfo, SbkPyFalkonTypeStructs[SBK_TabBar_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("mouseDoubleClickEvent(QMouseEvent *event)");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabBarFunc_mouseMoveEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabBarWrapper *>(reinterpret_cast< ::TabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::mouseMoveEvent(QMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QMouseEvent_IDX]), (pyArg)))) {
        overloadId = 0; // mouseMoveEvent(QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "mouseMoveEvent", errInfo, SbkPyFalkonTypeStructs[SBK_TabBar_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("mouseMoveEvent(QMouseEvent *event)");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabBarFunc_mousePressEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabBarWrapper *>(reinterpret_cast< ::TabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::mousePressEvent(QMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QMouseEvent_IDX]), (pyArg)))) {
        overloadId = 0; // mousePressEvent(QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "mousePressEvent", errInfo, SbkPyFalkonTypeStructs[SBK_TabBar_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("mousePressEvent(QMouseEvent *event)");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabBarFunc_mouseReleaseEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabBarWrapper *>(reinterpret_cast< ::TabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::mouseReleaseEvent(QMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QMouseEvent_IDX]), (pyArg)))) {
        overloadId = 0; // mouseReleaseEvent(QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "mouseReleaseEvent", errInfo, SbkPyFalkonTypeStructs[SBK_TabBar_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("mouseReleaseEvent(QMouseEvent *event)");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabBarFunc_setForceHidden(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabBarWrapper *>(reinterpret_cast< ::TabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TabBar::setForceHidden(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setForceHidden(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setForceHidden", errInfo, SbkPyFalkonTypeStructs[SBK_TabBar_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setForceHidden(bool)
            cppSelf->setForceHidden(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabBarFunc_setIsRestoring(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabBarWrapper *>(reinterpret_cast< ::TabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TabBar::setIsRestoring(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setIsRestoring(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setIsRestoring", errInfo, SbkPyFalkonTypeStructs[SBK_TabBar_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setIsRestoring(bool)
            cppSelf->setIsRestoring(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabBarFunc_setTabText(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabBarWrapper *>(reinterpret_cast< ::TabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setTabText", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: ComboTabBar::setTabText(int,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // setTabText(int,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setTabText", errInfo, SbkPyFalkonTypeStructs[SBK_TabBar_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setTabText(int,QString)
            cppSelf->setTabText(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabBarFunc_setVisible(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabBarWrapper *>(reinterpret_cast< ::TabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::setVisible(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setVisible(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setVisible", errInfo, SbkPyFalkonTypeStructs[SBK_TabBar_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setVisible(bool)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::TabBar::setVisible(cppArg0)
                : cppSelf->setVisible(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabBarFunc_tabInserted(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabBarWrapper *>(reinterpret_cast< ::TabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ComboTabBar::tabInserted(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // tabInserted(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "tabInserted", errInfo, SbkPyFalkonTypeStructs[SBK_TabBar_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("tabInserted(int index)");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabBarFunc_tabRemoved(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabBarWrapper *>(reinterpret_cast< ::TabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ComboTabBar::tabRemoved(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // tabRemoved(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "tabRemoved", errInfo, SbkPyFalkonTypeStructs[SBK_TabBar_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("tabRemoved(int index)");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabBarFunc_tabSizeHint(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabBarWrapper *>(reinterpret_cast< ::TabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "tabSizeHint", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: ComboTabBar::tabSizeHint(int,bool)const->QSize
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
        overloadId = 0; // tabSizeHint(int,bool)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "tabSizeHint", errInfo, SbkPyFalkonTypeStructs[SBK_TabBar_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("tabSizeHint(int index, bool fast) const");
        return {};
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabBarFunc_tabWidget(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabBarWrapper *>(reinterpret_cast< ::TabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // tabWidget()const
        TabWidget * cppResult = const_cast<const TabBarWrapper *>(cppSelf)->tabWidget();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabWidget_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabBarFunc_validIndex(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabBarWrapper *>(reinterpret_cast< ::TabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ComboTabBar::validIndex(int)const->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // validIndex(int)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "validIndex", errInfo, SbkPyFalkonTypeStructs[SBK_TabBar_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("validIndex(int index) const");
        return {};
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabBarFunc_wheelEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabBarWrapper *>(reinterpret_cast< ::TabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::wheelEvent(QWheelEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QWheelEvent_IDX]), (pyArg)))) {
        overloadId = 0; // wheelEvent(QWheelEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "wheelEvent", errInfo, SbkPyFalkonTypeStructs[SBK_TabBar_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWheelEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // wheelEvent(QWheelEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::TabBar::wheelEvent(cppArg0)
                : cppSelf->wheelEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_TabBar_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_TabBar_methods[] = {
    {"comboTabBarPixelMetric", reinterpret_cast<PyCFunction>(Sbk_TabBarFunc_comboTabBarPixelMetric), METH_O, nullptr},
    {"contextMenuEvent", reinterpret_cast<PyCFunction>(Sbk_TabBarFunc_contextMenuEvent), METH_O, nullptr},
    {"dragEnterEvent", reinterpret_cast<PyCFunction>(Sbk_TabBarFunc_dragEnterEvent), METH_O, nullptr},
    {"dragLeaveEvent", reinterpret_cast<PyCFunction>(Sbk_TabBarFunc_dragLeaveEvent), METH_O, nullptr},
    {"dragMoveEvent", reinterpret_cast<PyCFunction>(Sbk_TabBarFunc_dragMoveEvent), METH_O, nullptr},
    {"dropEvent", reinterpret_cast<PyCFunction>(Sbk_TabBarFunc_dropEvent), METH_O, nullptr},
    {"isRestoring", reinterpret_cast<PyCFunction>(Sbk_TabBarFunc_isRestoring), METH_NOARGS, nullptr},
    {"loadSettings", reinterpret_cast<PyCFunction>(Sbk_TabBarFunc_loadSettings), METH_NOARGS, nullptr},
    {"mouseDoubleClickEvent", reinterpret_cast<PyCFunction>(Sbk_TabBarFunc_mouseDoubleClickEvent), METH_O, nullptr},
    {"mouseMoveEvent", reinterpret_cast<PyCFunction>(Sbk_TabBarFunc_mouseMoveEvent), METH_O, nullptr},
    {"mousePressEvent", reinterpret_cast<PyCFunction>(Sbk_TabBarFunc_mousePressEvent), METH_O, nullptr},
    {"mouseReleaseEvent", reinterpret_cast<PyCFunction>(Sbk_TabBarFunc_mouseReleaseEvent), METH_O, nullptr},
    {"setForceHidden", reinterpret_cast<PyCFunction>(Sbk_TabBarFunc_setForceHidden), METH_O, nullptr},
    {"setIsRestoring", reinterpret_cast<PyCFunction>(Sbk_TabBarFunc_setIsRestoring), METH_O, nullptr},
    {"setTabText", reinterpret_cast<PyCFunction>(Sbk_TabBarFunc_setTabText), METH_VARARGS, nullptr},
    {"setVisible", reinterpret_cast<PyCFunction>(Sbk_TabBarFunc_setVisible), METH_O, nullptr},
    {"tabInserted", reinterpret_cast<PyCFunction>(Sbk_TabBarFunc_tabInserted), METH_O, nullptr},
    {"tabRemoved", reinterpret_cast<PyCFunction>(Sbk_TabBarFunc_tabRemoved), METH_O, nullptr},
    {"tabSizeHint", reinterpret_cast<PyCFunction>(Sbk_TabBarFunc_tabSizeHint), METH_VARARGS, nullptr},
    {"tabWidget", reinterpret_cast<PyCFunction>(Sbk_TabBarFunc_tabWidget), METH_NOARGS, nullptr},
    {"validIndex", reinterpret_cast<PyCFunction>(Sbk_TabBarFunc_validIndex), METH_O, nullptr},
    {"wheelEvent", reinterpret_cast<PyCFunction>(Sbk_TabBarFunc_wheelEvent), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_TabBar_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::TabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabBar_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<TabBarWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_TabBar_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_TabBar_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_TabBarSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::TabBar *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]))
        return static_cast< ::ComboTabBar *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_TabBar_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_TabBar_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_TabBar_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_TabBar_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_TabBar_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_TabBar_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_TabBar_spec = {
    "1:PyFalkon.TabBar",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_TabBar_slots
};

} //extern "C"

static void *Sbk_TabBar_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::TabBar *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::TabBar *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::TabBar *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void TabBar_PythonToCpp_TabBar_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_TabBar_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_TabBar_PythonToCpp_TabBar_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_TabBar_TypeF()))
        return TabBar_PythonToCpp_TabBar_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *TabBar_PTR_CppToPython_TabBar(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::TabBar *>(const_cast<void *>(cppIn)), Sbk_TabBar_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *TabBar_SignatureStrings[] = {
    "PyFalkon.TabBar(self,window:PyFalkon.BrowserWindow,tabWidget:PyFalkon.TabWidget)",
    "PyFalkon.TabBar.comboTabBarPixelMetric(self,sizeType:PyFalkon.ComboTabBar.SizeType)->int",
    "PyFalkon.TabBar.contextMenuEvent(self,event:PySide6.QtGui.QContextMenuEvent)",
    "PyFalkon.TabBar.dragEnterEvent(self,event:PySide6.QtGui.QDragEnterEvent)",
    "PyFalkon.TabBar.dragLeaveEvent(self,event:PySide6.QtGui.QDragLeaveEvent)",
    "PyFalkon.TabBar.dragMoveEvent(self,event:PySide6.QtGui.QDragMoveEvent)",
    "PyFalkon.TabBar.dropEvent(self,event:PySide6.QtGui.QDropEvent)",
    "PyFalkon.TabBar.isRestoring(self)->bool",
    "PyFalkon.TabBar.loadSettings(self)",
    "PyFalkon.TabBar.mouseDoubleClickEvent(self,event:PySide6.QtGui.QMouseEvent)",
    "PyFalkon.TabBar.mouseMoveEvent(self,event:PySide6.QtGui.QMouseEvent)",
    "PyFalkon.TabBar.mousePressEvent(self,event:PySide6.QtGui.QMouseEvent)",
    "PyFalkon.TabBar.mouseReleaseEvent(self,event:PySide6.QtGui.QMouseEvent)",
    "PyFalkon.TabBar.setForceHidden(self,hidden:bool)",
    "PyFalkon.TabBar.setIsRestoring(self,restoring:bool)",
    "PyFalkon.TabBar.setTabText(self,index:int,text:QString)",
    "PyFalkon.TabBar.setVisible(self,visible:bool)",
    "PyFalkon.TabBar.tabInserted(self,index:int)",
    "PyFalkon.TabBar.tabRemoved(self,index:int)",
    "PyFalkon.TabBar.tabSizeHint(self,index:int,fast:bool)->PySide6.QtCore.QSize",
    "PyFalkon.TabBar.tabWidget(self)->PyFalkon.TabWidget",
    "PyFalkon.TabBar.validIndex(self,index:int)->bool",
    "PyFalkon.TabBar.wheelEvent(self,event:PySide6.QtGui.QWheelEvent)",
    nullptr}; // Sentinel
#else
static constexpr size_t TabBar_SignatureByteSize = 389;
static constexpr uint8_t TabBar_SignatureBytes[389] = {
    0x78, 0xda, 0xa5, 0x94, 0x4d, 0x8f, 0x82, 0x30, 0x10, 0x40, 0xef, 0xfb, 0x4b, 0xd6, 0x04, 0x39,
    0xee, 0x81, 0x83, 0x07, 0x51, 0x57, 0x93, 0x25, 0x01, 0x21, 0xeb, 0xb9, 0xd0, 0x51, 0x1b, 0x6b,
    0x6b, 0xda, 0x02, 0xba, 0xbf, 0x7e, 0x0b, 0x15, 0x89, 0x52, 0x02, 0x89, 0xb7, 0x7e, 0xbc, 0x79,
    0x9d, 0xb4, 0x9d, 0x09, 0x6f, 0x2b, 0x44, 0x4f, 0x9c, 0xb9, 0x09, 0x4a, 0xe7, 0x48, 0x7c, 0x4a,
    0xa0, 0x7b, 0xa7, 0x24, 0x0c, 0xf3, 0xd2, 0x0b, 0x9b, 0xbd, 0xb9, 0xe0, 0xa5, 0x04, 0xb1, 0xab,
    0x97, 0x1d, 0x85, 0xd2, 0x1d, 0xc1, 0x07, 0x50, 0x2d, 0x90, 0x34, 0x4b, 0x93, 0x8f, 0xf0, 0x59,
    0xe8, 0x66, 0xfc, 0x9c, 0x72, 0x33, 0x0e, 0xc9, 0x15, 0x68, 0x00, 0x4a, 0x90, 0xcc, 0x9c, 0x23,
    0xc9, 0x1f, 0x24, 0xb7, 0x0b, 0xb4, 0x22, 0xbf, 0xa5, 0xdd, 0xf8, 0xbe, 0x3b, 0x99, 0xce, 0x08,
    0x53, 0x16, 0x31, 0x53, 0x70, 0x55, 0x01, 0xb0, 0x7c, 0x59, 0x00, 0x53, 0x46, 0x09, 0xd5, 0x50,
    0xfb, 0x62, 0x82, 0xe1, 0xcb, 0x8d, 0xd4, 0x77, 0x4e, 0xdc, 0xc8, 0x7f, 0x41, 0xbb, 0x59, 0x62,
    0x81, 0x0e, 0x4b, 0x0d, 0x89, 0x21, 0xd5, 0xe2, 0x09, 0xb4, 0x8b, 0x7e, 0x00, 0x15, 0x30, 0x46,
    0xd4, 0x82, 0x76, 0x51, 0xc0, 0xc7, 0x79, 0x1e, 0x9c, 0x4d, 0xc3, 0x2f, 0xc3, 0x8a, 0x3b, 0xd3,
    0x0d, 0x27, 0x72, 0x0b, 0x52, 0x71, 0x41, 0xd8, 0xa1, 0x16, 0xe8, 0xb7, 0x48, 0x39, 0xa7, 0x1d,
    0x8e, 0x72, 0x84, 0x63, 0x50, 0x4a, 0x73, 0xd2, 0x80, 0x1d, 0xe4, 0xcc, 0x73, 0x09, 0x0b, 0x9e,
    0xa7, 0x14, 0x7c, 0x4a, 0xb2, 0xd3, 0x50, 0x56, 0x41, 0xc5, 0xf7, 0xa4, 0x55, 0xbb, 0xc6, 0xdc,
    0xce, 0xa0, 0x24, 0x14, 0x20, 0xe5, 0xdb, 0x96, 0x2d, 0x50, 0x40, 0xf2, 0xad, 0x6c, 0x24, 0xa8,
    0x15, 0x17, 0x19, 0xac, 0x09, 0xc6, 0xc0, 0x8c, 0xe4, 0x58, 0x8f, 0xbd, 0xea, 0xc6, 0xad, 0x01,
    0x9b, 0x97, 0xd7, 0x71, 0x44, 0x33, 0xed, 0x8f, 0xd1, 0xa3, 0x44, 0xd7, 0x82, 0xe1, 0x75, 0x41,
    0xc3, 0xd5, 0xd3, 0xd5, 0xe5, 0x54, 0xf5, 0xe1, 0x45, 0xb1, 0xaa, 0x82, 0xad, 0x71, 0xbf, 0x44,
    0x12, 0xfd, 0x74, 0x26, 0xae, 0x30, 0x93, 0x9e, 0x53, 0x74, 0x83, 0xd8, 0x30, 0xdd, 0x2f, 0x14,
    0xe0, 0x97, 0x63, 0xac, 0xec, 0x16, 0xce, 0xfa, 0x25, 0x47, 0xa1, 0x55, 0x4b, 0x58, 0x13, 0xd6,
    0xc9, 0x7e, 0x8f, 0xa4, 0x32, 0xc9, 0x4c, 0x67, 0xed, 0x9d, 0xfb, 0x5c, 0x80, 0x1b, 0x55, 0x31,
    0x36, 0x97, 0x69, 0x58, 0xcd, 0xaf, 0xee, 0xb6, 0xb2, 0x4e, 0x4c, 0x81, 0x28, 0xc1, 0x9b, 0xea,
    0xcc, 0xd7, 0x54, 0x7b, 0x8a, 0xa2, 0x3c, 0x02, 0xd0, 0xa1, 0x3f, 0xb1, 0x7b, 0x40, 0x93, 0x8f,
    0x7f, 0xff, 0x58, 0x04, 0x70
};
#endif

PyTypeObject *init_TabBar(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_TabBar_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_TabBar_IDX].type;

    Shiboken::AutoDecRef Sbk_TabBar_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]))));

    _Sbk_TabBar_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "TabBar",
        "TabBar*",
        &Sbk_TabBar_spec,
        &Shiboken::callCppDestructor< TabBar >,
        Sbk_TabBar_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = _Sbk_TabBar_Type; // references _Sbk_TabBar_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, TabBar_SignatureStrings);
#else
    InitSignatureBytes(pyType, TabBar_SignatureBytes, TabBar_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_TabBar_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_TabBar_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        TabBar_PythonToCpp_TabBar_PTR,
        is_TabBar_PythonToCpp_TabBar_PTR_Convertible,
        TabBar_PTR_CppToPython_TabBar);

    Shiboken::Conversions::registerConverterName(converter, "TabBar");
    Shiboken::Conversions::registerConverterName(converter, "TabBar*");
    Shiboken::Conversions::registerConverterName(converter, "TabBar&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::TabBar).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(TabBarWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_TabBar_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_TabBar_TypeF(), &Sbk_TabBarSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_TabBar_TypeF(), &Sbk_TabBar_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::TabBar::staticMetaObject);
    TabBarWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::TabBar::staticMetaObject, sizeof(TabBarWrapper));

    return pyType;
}
