/* windowing.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from windowing.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "budgie-windowing.h"
#include <libxfce4windowing/libxfce4windowing.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <gio/gdesktopappinfo.h>

#define BUDGIE_WINDOWING_NOTIFICATIONS_DBUS_NAME "org.budgie_desktop.Notifications"
#define BUDGIE_WINDOWING_NOTIFICATIONS_DBUS_OBJECT_PATH "/org/budgie_desktop/Notifications"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BUDGIE_WINDOWING_WINDOWING_0_PROPERTY,
	BUDGIE_WINDOWING_WINDOWING_HAS_WINDOWS_PROPERTY,
	BUDGIE_WINDOWING_WINDOWING_WINDOWS_PROPERTY,
	BUDGIE_WINDOWING_WINDOWING_NUM_PROPERTIES
};
static GParamSpec* budgie_windowing_windowing_properties[BUDGIE_WINDOWING_WINDOWING_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	BUDGIE_WINDOWING_WINDOWING_ACTIVE_WINDOW_CHANGED_SIGNAL,
	BUDGIE_WINDOWING_WINDOWING_ACTIVE_WORKSPACE_CHANGED_SIGNAL,
	BUDGIE_WINDOWING_WINDOWING_WINDOW_GROUP_ADDED_SIGNAL,
	BUDGIE_WINDOWING_WINDOWING_WINDOW_GROUP_REMOVED_SIGNAL,
	BUDGIE_WINDOWING_WINDOWING_WINDOW_ADDED_SIGNAL,
	BUDGIE_WINDOWING_WINDOWING_WINDOW_REMOVED_SIGNAL,
	BUDGIE_WINDOWING_WINDOWING_WINDOW_STATE_CHANGED_SIGNAL,
	BUDGIE_WINDOWING_WINDOWING_WORKSPACE_CREATED_SIGNAL,
	BUDGIE_WINDOWING_WINDOWING_WORKSPACE_DESTROYED_SIGNAL,
	BUDGIE_WINDOWING_WINDOWING_NUM_SIGNALS
};
static guint budgie_windowing_windowing_signals[BUDGIE_WINDOWING_WINDOWING_NUM_SIGNALS] = {0};

struct _BudgieWindowingWindowingPrivate {
	XfwScreen* screen;
	XfwWorkspaceManager* workspace_manager;
	GHashTable* applications;
	GList* fullscreen_windows;
	XfwWindow* last_active_window;
	BudgieWindowingNotificationDispatcher* dispatcher;
	GSettings* color_settings;
	GSettings* wm_settings;
	gulong night_light_setting_handler;
	gboolean pause_night_light;
	gboolean pause_notifications;
	gboolean previous_color_setting;
	gboolean _has_windows;
};

static gint BudgieWindowingWindowing_private_offset;
static gpointer budgie_windowing_windowing_parent_class = NULL;

static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void budgie_windowing_windowing_on_dbus_get (BudgieWindowingWindowing* self,
                                             GObject* object,
                                             GAsyncResult* _result_);
static void budgie_windowing_windowing_setup_workspace_listener (BudgieWindowingWindowing* self);
static void budgie_windowing_windowing_on_active_workspace_changed (BudgieWindowingWindowing* self,
                                                             XfwWorkspace* previous_workspace);
static void _budgie_windowing_windowing_on_active_workspace_changed_libxfce4windowing_workspace_group_active_workspace_changed (XfwWorkspaceGroup* _sender,
                                                                                                                         XfwWorkspace* previously_active_workspace,
                                                                                                                         gpointer self);
static void budgie_windowing_windowing_on_workspace_created (BudgieWindowingWindowing* self,
                                                      XfwWorkspace* workspace);
static void _budgie_windowing_windowing_on_workspace_created_libxfce4windowing_workspace_group_workspace_added (XfwWorkspaceGroup* _sender,
                                                                                                         XfwWorkspace* workspace,
                                                                                                         gpointer self);
static void budgie_windowing_windowing_on_workspace_destroyed (BudgieWindowingWindowing* self,
                                                        XfwWorkspace* workspace);
static void _budgie_windowing_windowing_on_workspace_destroyed_libxfce4windowing_workspace_group_workspace_removed (XfwWorkspaceGroup* _sender,
                                                                                                             XfwWorkspace* workspace,
                                                                                                             gpointer self);
static void budgie_windowing_windowing_on_active_window_changed (BudgieWindowingWindowing* self,
                                                          XfwWindow* old_window);
static void budgie_windowing_windowing_on_window_added (BudgieWindowingWindowing* self,
                                                 XfwWindow* window);
static void budgie_windowing_windowing_set_has_windows (BudgieWindowingWindowing* self,
                                                 gboolean value);
static void budgie_windowing_windowing_on_window_state_changed (BudgieWindowingWindowing* self,
                                                         XfwWindow* window,
                                                         XfwWindowState changed_mask,
                                                         XfwWindowState new_state);
static void _budgie_windowing_windowing_on_window_state_changed_budgie_windowing_window_group_window_state_changed (BudgieWindowingWindowGroup* _sender,
                                                                                                             XfwWindow* window,
                                                                                                             XfwWindowState changed_mask,
                                                                                                             XfwWindowState new_state,
                                                                                                             gpointer self);
static void budgie_windowing_windowing_on_window_removed (BudgieWindowingWindowing* self,
                                                   XfwWindow* window);
static void budgie_windowing_windowing_handle_fullscreen_changed (BudgieWindowingWindowing* self,
                                                           gboolean fullscreen);
static void budgie_windowing_windowing_night_light_enabled_changed (BudgieWindowingWindowing* self,
                                                             const gchar* key);
static void budgie_windowing_windowing_wm_settings_changed (BudgieWindowingWindowing* self,
                                                     const gchar* key);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__OBJECT_FLAGS_FLAGS (GClosure * closure,
                                                       GValue * return_value,
                                                       guint n_param_values,
                                                       const GValue * param_values,
                                                       gpointer invocation_hint,
                                                       gpointer marshal_data);
static GObject * budgie_windowing_windowing_constructor (GType type,
                                                  guint n_construct_properties,
                                                  GObjectConstructParam * construct_properties);
static void _budgie_windowing_windowing_on_dbus_get_gasync_ready_callback (GObject* source_object,
                                                                    GAsyncResult* res,
                                                                    gpointer self);
static void _budgie_windowing_windowing_on_window_added_gfunc (gconstpointer data,
                                                        gpointer self);
static void _budgie_windowing_windowing_on_active_window_changed_libxfce4windowing_screen_active_window_changed (XfwScreen* _sender,
                                                                                                          XfwWindow* window,
                                                                                                          gpointer self);
static void _budgie_windowing_windowing_on_window_added_libxfce4windowing_screen_window_opened (XfwScreen* _sender,
                                                                                         XfwWindow* window,
                                                                                         gpointer self);
static void _budgie_windowing_windowing_on_window_removed_libxfce4windowing_screen_window_closed (XfwScreen* _sender,
                                                                                           XfwWindow* window,
                                                                                           gpointer self);
static void _budgie_windowing_windowing_night_light_enabled_changed_g_settings_changed (GSettings* _sender,
                                                                                 const gchar* key,
                                                                                 gpointer self);
static void _budgie_windowing_windowing_wm_settings_changed_g_settings_changed (GSettings* _sender,
                                                                         const gchar* key,
                                                                         gpointer self);
static void budgie_windowing_windowing_finalize (GObject * obj);
static GType budgie_windowing_windowing_get_type_once (void);
static void _vala_budgie_windowing_windowing_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_budgie_windowing_windowing_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);

static inline gpointer
budgie_windowing_windowing_get_instance_private (BudgieWindowingWindowing* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieWindowingWindowing_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

/**
 * Creates a new Windowing object. This is the entry point into
 * this library.
 */
BudgieWindowingWindowing*
budgie_windowing_windowing_construct (GType object_type)
{
	BudgieWindowingWindowing * self = NULL;
	self = (BudgieWindowingWindowing*) g_object_new (object_type, NULL);
	return self;
}

BudgieWindowingWindowing*
budgie_windowing_windowing_new (void)
{
	return budgie_windowing_windowing_construct (BUDGIE_WINDOWING_TYPE_WINDOWING);
}

static void
budgie_windowing_windowing_on_dbus_get (BudgieWindowingWindowing* self,
                                        GObject* object,
                                        GAsyncResult* _result_)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		BudgieWindowingNotificationDispatcher* _tmp0_ = NULL;
		BudgieWindowingNotificationDispatcher* _tmp1_;
		BudgieWindowingNotificationDispatcher* _tmp2_;
		BudgieWindowingNotificationDispatcher* _tmp3_;
		_tmp1_ = g_async_result_get_source_object (_result_);
		_tmp2_ = (BudgieWindowingNotificationDispatcher*) g_async_initable_new_finish ((GAsyncInitable *) _tmp1_, _result_, &_inner_error0_);
		g_object_unref (_tmp1_);
		_tmp0_ = (BudgieWindowingNotificationDispatcher*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->dispatcher);
		self->priv->dispatcher = _tmp3_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_critical ("windowing.vala:136: Error getting notification dispatcher: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

/**
 * Get the first workspace group. X11 has no concept of
 * workspace groups, so the first one is guaranteed to
 * be the only one.
 */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

XfwWorkspaceGroup*
budgie_windowing_windowing_get_workspace_group (BudgieWindowingWindowing* self)
{
	GList* groups = NULL;
	XfwWorkspaceManager* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	GList* element = NULL;
	GList* _tmp3_;
	GList* _tmp4_;
	GList* _tmp5_;
	gconstpointer _tmp6_;
	XfwWorkspaceGroup* _tmp7_;
	XfwWorkspaceGroup* _tmp8_;
	XfwWorkspaceGroup* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->workspace_manager;
	_tmp1_ = xfw_workspace_manager_list_workspace_groups (_tmp0_);
	groups = _tmp1_;
	_tmp2_ = groups;
	if (_tmp2_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp3_ = groups;
	_tmp4_ = g_list_first (_tmp3_);
	element = _tmp4_;
	_tmp5_ = element;
	_tmp6_ = _tmp5_->data;
	_tmp7_ = (XfwWorkspaceGroup*) _tmp6_;
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, xfw_workspace_group_get_type ()) ? ((XfwWorkspaceGroup*) _tmp7_) : NULL);
	result = _tmp8_;
	return result;
}

static void
_budgie_windowing_windowing_on_active_workspace_changed_libxfce4windowing_workspace_group_active_workspace_changed (XfwWorkspaceGroup* _sender,
                                                                                                                    XfwWorkspace* previously_active_workspace,
                                                                                                                    gpointer self)
{
	budgie_windowing_windowing_on_active_workspace_changed ((BudgieWindowingWindowing*) self, previously_active_workspace);
}

static void
_budgie_windowing_windowing_on_workspace_created_libxfce4windowing_workspace_group_workspace_added (XfwWorkspaceGroup* _sender,
                                                                                                    XfwWorkspace* workspace,
                                                                                                    gpointer self)
{
	budgie_windowing_windowing_on_workspace_created ((BudgieWindowingWindowing*) self, workspace);
}

static void
_budgie_windowing_windowing_on_workspace_destroyed_libxfce4windowing_workspace_group_workspace_removed (XfwWorkspaceGroup* _sender,
                                                                                                        XfwWorkspace* workspace,
                                                                                                        gpointer self)
{
	budgie_windowing_windowing_on_workspace_destroyed ((BudgieWindowingWindowing*) self, workspace);
}

static void
budgie_windowing_windowing_setup_workspace_listener (BudgieWindowingWindowing* self)
{
	XfwScreen* _tmp0_;
	XfwWorkspaceManager* _tmp1_;
	XfwWorkspaceManager* _tmp2_;
	XfwWorkspaceGroup* group = NULL;
	XfwWorkspaceGroup* _tmp3_;
	XfwWorkspaceGroup* _tmp4_;
	XfwWorkspaceGroup* _tmp5_;
	XfwWorkspaceGroup* _tmp6_;
	XfwWorkspaceGroup* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->screen;
	_tmp1_ = xfw_screen_get_workspace_manager (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->workspace_manager);
	self->priv->workspace_manager = _tmp2_;
	_tmp3_ = budgie_windowing_windowing_get_workspace_group (self);
	group = _tmp3_;
	_tmp4_ = group;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (group);
		return;
	}
	_tmp5_ = group;
	g_signal_connect_object (_tmp5_, "active-workspace-changed", (GCallback) _budgie_windowing_windowing_on_active_workspace_changed_libxfce4windowing_workspace_group_active_workspace_changed, self, 0);
	_tmp6_ = group;
	g_signal_connect_object (_tmp6_, "workspace-added", (GCallback) _budgie_windowing_windowing_on_workspace_created_libxfce4windowing_workspace_group_workspace_added, self, 0);
	_tmp7_ = group;
	g_signal_connect_object (_tmp7_, "workspace-removed", (GCallback) _budgie_windowing_windowing_on_workspace_destroyed_libxfce4windowing_workspace_group_workspace_removed, self, 0);
	_g_object_unref0 (group);
}

static void
budgie_windowing_windowing_on_active_window_changed (BudgieWindowingWindowing* self,
                                                     XfwWindow* old_window)
{
	XfwWindow* new_window = NULL;
	XfwScreen* _tmp0_;
	XfwWindow* _tmp1_;
	XfwWindow* _tmp2_;
	GHashTable* _tmp3_;
	GList* _tmp4_;
	XfwWindow* _tmp12_;
	XfwWindow* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->screen;
	_tmp1_ = xfw_screen_get_active_window (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	new_window = _tmp2_;
	_tmp3_ = self->priv->applications;
	_tmp4_ = g_hash_table_get_values (_tmp3_);
	{
		GList* group_collection = NULL;
		GList* group_it = NULL;
		group_collection = _tmp4_;
		for (group_it = group_collection; group_it != NULL; group_it = group_it->next) {
			BudgieWindowingWindowGroup* group = NULL;
			group = (BudgieWindowingWindowGroup*) group_it->data;
			{
				BudgieWindowingWindowGroup* _tmp5_;
				XfwWindow* _tmp6_;
				gboolean _tmp9_ = FALSE;
				_tmp5_ = group;
				_tmp6_ = new_window;
				if (budgie_windowing_window_group_has_window (_tmp5_, _tmp6_)) {
					BudgieWindowingWindowGroup* _tmp7_;
					XfwWindow* _tmp8_;
					_tmp7_ = group;
					_tmp8_ = new_window;
					budgie_windowing_window_group_set_active_window (_tmp7_, _tmp8_);
				}
				if (old_window != NULL) {
					BudgieWindowingWindowGroup* _tmp10_;
					_tmp10_ = group;
					_tmp9_ = budgie_windowing_window_group_has_window (_tmp10_, old_window);
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					BudgieWindowingWindowGroup* _tmp11_;
					_tmp11_ = group;
					budgie_windowing_window_group_set_last_active_window (_tmp11_, old_window);
				}
			}
		}
		(group_collection == NULL) ? NULL : (group_collection = (g_list_free (group_collection), NULL));
	}
	_tmp12_ = _g_object_ref0 (old_window);
	_g_object_unref0 (self->priv->last_active_window);
	self->priv->last_active_window = _tmp12_;
	_tmp13_ = new_window;
	g_signal_emit (self, budgie_windowing_windowing_signals[BUDGIE_WINDOWING_WINDOWING_ACTIVE_WINDOW_CHANGED_SIGNAL], 0, old_window, _tmp13_);
	_g_object_unref0 (new_window);
}

static void
budgie_windowing_windowing_on_active_workspace_changed (BudgieWindowingWindowing* self,
                                                        XfwWorkspace* previous_workspace)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, budgie_windowing_windowing_signals[BUDGIE_WINDOWING_WINDOWING_ACTIVE_WORKSPACE_CHANGED_SIGNAL], 0, previous_workspace);
}

static void
budgie_windowing_windowing_on_workspace_created (BudgieWindowingWindowing* self,
                                                 XfwWorkspace* workspace)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (workspace != NULL);
	g_signal_emit (self, budgie_windowing_windowing_signals[BUDGIE_WINDOWING_WINDOWING_WORKSPACE_CREATED_SIGNAL], 0, workspace);
}

static void
budgie_windowing_windowing_on_workspace_destroyed (BudgieWindowingWindowing* self,
                                                   XfwWorkspace* workspace)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (workspace != NULL);
	g_signal_emit (self, budgie_windowing_windowing_signals[BUDGIE_WINDOWING_WINDOWING_WORKSPACE_DESTROYED_SIGNAL], 0, workspace);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
_budgie_windowing_windowing_on_window_state_changed_budgie_windowing_window_group_window_state_changed (BudgieWindowingWindowGroup* _sender,
                                                                                                        XfwWindow* window,
                                                                                                        XfwWindowState changed_mask,
                                                                                                        XfwWindowState new_state,
                                                                                                        gpointer self)
{
	budgie_windowing_windowing_on_window_state_changed ((BudgieWindowingWindowing*) self, window, changed_mask, new_state);
}

static void
budgie_windowing_windowing_on_window_added (BudgieWindowingWindowing* self,
                                            XfwWindow* window)
{
	XfwApplication* application = NULL;
	XfwApplication* _tmp0_;
	XfwApplication* _tmp1_;
	BudgieWindowingWindowGroup* group = NULL;
	GHashTable* _tmp2_;
	XfwApplication* _tmp3_;
	gconstpointer _tmp4_;
	BudgieWindowingWindowGroup* _tmp5_;
	BudgieWindowingWindowGroup* _tmp6_;
	XfwApplication* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* app_id = NULL;
	XfwApplication* _tmp13_;
	const gchar* _tmp14_;
	GDesktopAppInfo* app_info = NULL;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GDesktopAppInfo* _tmp18_;
	GDesktopAppInfo* _tmp19_;
	XfwApplication* _tmp20_;
	GDesktopAppInfo* _tmp21_;
	BudgieWindowingWindowGroup* _tmp22_;
	BudgieWindowingWindowGroup* _tmp23_;
	BudgieWindowingWindowGroup* _tmp24_;
	GHashTable* _tmp25_;
	XfwApplication* _tmp26_;
	XfwApplication* _tmp27_;
	BudgieWindowingWindowGroup* _tmp28_;
	BudgieWindowingWindowGroup* _tmp29_;
	BudgieWindowingWindowGroup* _tmp30_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	if (xfw_window_is_skip_tasklist (window)) {
		return;
	}
	g_signal_emit (self, budgie_windowing_windowing_signals[BUDGIE_WINDOWING_WINDOWING_WINDOW_ADDED_SIGNAL], 0, window);
	budgie_windowing_windowing_set_has_windows (self, TRUE);
	_tmp0_ = xfw_window_get_application (window);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	application = _tmp1_;
	_tmp2_ = self->priv->applications;
	_tmp3_ = application;
	_tmp4_ = g_hash_table_lookup (_tmp2_, _tmp3_);
	_tmp5_ = _g_object_ref0 ((BudgieWindowingWindowGroup*) _tmp4_);
	group = _tmp5_;
	_tmp6_ = group;
	if (_tmp6_ != NULL) {
		BudgieWindowingWindowGroup* _tmp7_;
		_tmp7_ = group;
		budgie_windowing_window_group_add_window (_tmp7_, window);
		_g_object_unref0 (group);
		_g_object_unref0 (application);
		return;
	}
	_tmp8_ = application;
	_tmp9_ = xfw_application_get_name (_tmp8_);
	_tmp10_ = string_to_string (_tmp9_);
	_tmp11_ = g_strconcat ("creating new WindowGroup for application: ", _tmp10_, NULL);
	_tmp12_ = _tmp11_;
	g_debug ("windowing.vala:212: %s", _tmp12_);
	_g_free0 (_tmp12_);
	_tmp13_ = application;
	_tmp14_ = xfw_application_get_class_id (_tmp13_);
	app_id = _tmp14_;
	_tmp15_ = app_id;
	_tmp16_ = g_strconcat (_tmp15_, ".desktop", NULL);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_desktop_app_info_new (_tmp17_);
	_tmp19_ = _tmp18_;
	_g_free0 (_tmp17_);
	app_info = _tmp19_;
	_tmp20_ = application;
	_tmp21_ = app_info;
	_tmp22_ = budgie_windowing_window_group_new (_tmp20_, _tmp21_);
	_g_object_unref0 (group);
	group = _tmp22_;
	_tmp23_ = group;
	budgie_windowing_window_group_add_window (_tmp23_, window);
	_tmp24_ = group;
	g_signal_connect_object (_tmp24_, "window-state-changed", (GCallback) _budgie_windowing_windowing_on_window_state_changed_budgie_windowing_window_group_window_state_changed, self, 0);
	_tmp25_ = self->priv->applications;
	_tmp26_ = application;
	_tmp27_ = _g_object_ref0 (_tmp26_);
	_tmp28_ = group;
	_tmp29_ = _g_object_ref0 (_tmp28_);
	g_hash_table_insert (_tmp25_, _tmp27_, _tmp29_);
	_tmp30_ = group;
	g_signal_emit (self, budgie_windowing_windowing_signals[BUDGIE_WINDOWING_WINDOWING_WINDOW_GROUP_ADDED_SIGNAL], 0, _tmp30_);
	_g_object_unref0 (app_info);
	_g_object_unref0 (group);
	_g_object_unref0 (application);
}

static GList*
vala_g_list_remove_full (GList* self,
                         gconstpointer data,
                         GFreeFunc func)
{
	GList* l = NULL;
	GList* result;
	l = self;
	while (TRUE) {
		GList* _tmp0_;
		GList* _tmp1_;
		gconstpointer _tmp2_;
		_tmp0_ = l;
		if (!(_tmp0_ != NULL)) {
			break;
		}
		_tmp1_ = l;
		_tmp2_ = ((GList*) _tmp1_)->data;
		if (_tmp2_ != data) {
			GList* _tmp3_;
			GList* _tmp4_;
			_tmp3_ = l;
			_tmp4_ = ((GList*) _tmp3_)->next;
			l = _tmp4_;
		} else {
			GList* _tmp5_;
			gconstpointer _tmp6_;
			GList* _tmp7_;
			_tmp5_ = l;
			_tmp6_ = ((GList*) _tmp5_)->data;
			func (_tmp6_);
			_tmp7_ = l;
			self = g_list_delete_link (self, (GList*) _tmp7_);
			break;
		}
	}
	result = self;
	return result;
}

static void
budgie_windowing_windowing_on_window_removed (BudgieWindowingWindowing* self,
                                              XfwWindow* window)
{
	XfwScreen* _tmp0_;
	GList* _tmp1_;
	XfwApplication* application = NULL;
	XfwApplication* _tmp2_;
	XfwApplication* _tmp3_;
	BudgieWindowingWindowGroup* group = NULL;
	GHashTable* _tmp4_;
	XfwApplication* _tmp5_;
	gconstpointer _tmp6_;
	BudgieWindowingWindowGroup* _tmp7_;
	BudgieWindowingWindowGroup* _tmp8_;
	BudgieWindowingWindowGroup* _tmp9_;
	BudgieWindowingWindowGroup* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->screen;
	_tmp1_ = xfw_screen_get_windows (_tmp0_);
	budgie_windowing_windowing_set_has_windows (self, g_list_length (_tmp1_) > ((guint) 0));
	if (xfw_window_is_skip_tasklist (window)) {
		return;
	}
	g_signal_emit (self, budgie_windowing_windowing_signals[BUDGIE_WINDOWING_WINDOWING_WINDOW_REMOVED_SIGNAL], 0, window);
	_tmp2_ = xfw_window_get_application (window);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	application = _tmp3_;
	_tmp4_ = self->priv->applications;
	_tmp5_ = application;
	_tmp6_ = g_hash_table_lookup (_tmp4_, _tmp5_);
	_tmp7_ = _g_object_ref0 ((BudgieWindowingWindowGroup*) _tmp6_);
	group = _tmp7_;
	_tmp8_ = group;
	if (_tmp8_ == NULL) {
		_g_object_unref0 (group);
		_g_object_unref0 (application);
		return;
	}
	_tmp9_ = group;
	budgie_windowing_window_group_remove_window (_tmp9_, window);
	self->priv->fullscreen_windows = vala_g_list_remove_full (self->priv->fullscreen_windows, window, _g_object_unref0_);
	_tmp10_ = group;
	if (!budgie_windowing_window_group_has_windows (_tmp10_)) {
		XfwApplication* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		BudgieWindowingWindowGroup* _tmp16_;
		GHashTable* _tmp17_;
		XfwApplication* _tmp18_;
		_tmp11_ = application;
		_tmp12_ = xfw_application_get_name (_tmp11_);
		_tmp13_ = string_to_string (_tmp12_);
		_tmp14_ = g_strconcat ("removing WindowGroup for application: ", _tmp13_, NULL);
		_tmp15_ = _tmp14_;
		g_debug ("windowing.vala:245: %s", _tmp15_);
		_g_free0 (_tmp15_);
		_tmp16_ = group;
		g_signal_emit (self, budgie_windowing_windowing_signals[BUDGIE_WINDOWING_WINDOWING_WINDOW_GROUP_REMOVED_SIGNAL], 0, _tmp16_);
		_tmp17_ = self->priv->applications;
		_tmp18_ = application;
		g_hash_table_remove (_tmp17_, _tmp18_);
	}
	_g_object_unref0 (group);
	_g_object_unref0 (application);
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

static void
budgie_windowing_windowing_on_window_state_changed (BudgieWindowingWindowing* self,
                                                    XfwWindow* window,
                                                    XfwWindowState changed_mask,
                                                    XfwWindowState new_state)
{
	gboolean _tmp0_ = FALSE;
	gboolean is_fullscreen = FALSE;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	XfwWindow* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	g_signal_emit (self, budgie_windowing_windowing_signals[BUDGIE_WINDOWING_WINDOWING_WINDOW_STATE_CHANGED_SIGNAL], 0, window, changed_mask, new_state);
	if (!((changed_mask & XFW_WINDOW_STATE_FULLSCREEN) == XFW_WINDOW_STATE_FULLSCREEN)) {
		return;
	}
	if ((new_state & XFW_WINDOW_STATE_FULLSCREEN) == XFW_WINDOW_STATE_FULLSCREEN) {
		gboolean _tmp1_ = FALSE;
		if ((new_state & XFW_WINDOW_STATE_MINIMIZED) == XFW_WINDOW_STATE_MINIMIZED) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = (new_state & XFW_WINDOW_STATE_SHADED) == XFW_WINDOW_STATE_SHADED;
		}
		_tmp0_ = !_tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	is_fullscreen = _tmp0_;
	_tmp2_ = xfw_window_get_name (window);
	_tmp3_ = string_to_string (_tmp2_);
	_tmp4_ = bool_to_string (is_fullscreen);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat ("window '", _tmp3_, "' fullscreen changed: is fullscreen = ", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	g_debug ("windowing.vala:260: %s", _tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	budgie_windowing_windowing_handle_fullscreen_changed (self, is_fullscreen);
	if (!is_fullscreen) {
		self->priv->fullscreen_windows = vala_g_list_remove_full (self->priv->fullscreen_windows, window, _g_object_unref0_);
		return;
	}
	_tmp8_ = _g_object_ref0 (window);
	self->priv->fullscreen_windows = g_list_append (self->priv->fullscreen_windows, _tmp8_);
}

static void
budgie_windowing_windowing_handle_fullscreen_changed (BudgieWindowingWindowing* self,
                                                      gboolean fullscreen)
{
	GSettings* _tmp0_;
	GSettings* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->color_settings;
	g_signal_handler_block (_tmp0_, self->priv->night_light_setting_handler);
	if (fullscreen) {
		if (self->priv->pause_night_light) {
			GSettings* _tmp1_;
			_tmp1_ = self->priv->color_settings;
			g_settings_set_boolean (_tmp1_, "night-light-enabled", FALSE);
		}
		if (self->priv->pause_notifications) {
			BudgieWindowingNotificationDispatcher* _tmp2_;
			_tmp2_ = self->priv->dispatcher;
			budgie_windowing_notification_dispatcher_set_notifications_paused (_tmp2_, TRUE);
		}
	} else {
		if (self->priv->pause_night_light) {
			GSettings* _tmp3_;
			_tmp3_ = self->priv->color_settings;
			g_settings_set_boolean (_tmp3_, "night-light-enabled", self->priv->previous_color_setting);
		}
		if (self->priv->pause_notifications) {
			BudgieWindowingNotificationDispatcher* _tmp4_;
			_tmp4_ = self->priv->dispatcher;
			budgie_windowing_notification_dispatcher_set_notifications_paused (_tmp4_, FALSE);
		}
	}
	_tmp5_ = self->priv->color_settings;
	g_signal_handler_unblock (_tmp5_, self->priv->night_light_setting_handler);
}

static void
budgie_windowing_windowing_night_light_enabled_changed (BudgieWindowingWindowing* self,
                                                        const gchar* key)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->color_settings;
	self->priv->previous_color_setting = g_settings_get_boolean (_tmp0_, key);
}

static void
budgie_windowing_windowing_wm_settings_changed (BudgieWindowingWindowing* self,
                                                const gchar* key)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = key;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("disable-night-light-on-fullscreen")))) {
		switch (0) {
			default:
			{
				GSettings* _tmp3_;
				_tmp3_ = self->priv->wm_settings;
				self->priv->pause_night_light = g_settings_get_boolean (_tmp3_, key);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("pause-notifications-on-fullscreen")))) {
		switch (0) {
			default:
			{
				GSettings* _tmp4_;
				_tmp4_ = self->priv->wm_settings;
				self->priv->pause_notifications = g_settings_get_boolean (_tmp4_, key);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_warning ("windowing.vala:316: Unknown setting changed: %s", key);
				break;
			}
		}
	}
}

/**
 * Get the currently active window.
 *
 * Returns: the active window, or NULL
 */
XfwWindow*
budgie_windowing_windowing_get_active_window (BudgieWindowingWindowing* self)
{
	XfwScreen* _tmp0_;
	XfwWindow* _tmp1_;
	XfwWindow* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->screen;
	_tmp1_ = xfw_screen_get_active_window (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
 * Get a list of all current #WindowGroups.
 *
 * Returns: the list of window groups
 */
GList*
budgie_windowing_windowing_get_window_groups (BudgieWindowingWindowing* self)
{
	GHashTable* _tmp0_;
	GList* _tmp1_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->applications;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
 * Get the currently active workspace.
 *
 * Returns: the active workspace, or NULL
 */
XfwWorkspace*
budgie_windowing_windowing_get_active_workspace (BudgieWindowingWindowing* self)
{
	XfwWorkspaceGroup* group = NULL;
	XfwWorkspaceGroup* _tmp0_;
	XfwWorkspaceGroup* _tmp1_;
	XfwWorkspaceGroup* _tmp2_;
	XfwWorkspace* _tmp3_;
	XfwWorkspace* _tmp4_;
	XfwWorkspace* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = budgie_windowing_windowing_get_workspace_group (self);
	group = _tmp0_;
	_tmp1_ = group;
	if (_tmp1_ == NULL) {
		result = NULL;
		_g_object_unref0 (group);
		return result;
	}
	_tmp2_ = group;
	_tmp3_ = xfw_workspace_group_get_active_workspace (_tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	result = _tmp4_;
	_g_object_unref0 (group);
	return result;
}

gboolean
budgie_windowing_windowing_get_has_windows (BudgieWindowingWindowing* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_windows;
	return result;
}

static void
budgie_windowing_windowing_set_has_windows (BudgieWindowingWindowing* self,
                                            gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_windowing_windowing_get_has_windows (self);
	if (old_value != value) {
		self->priv->_has_windows = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_windowing_windowing_properties[BUDGIE_WINDOWING_WINDOWING_HAS_WINDOWS_PROPERTY]);
	}
}

GList*
budgie_windowing_windowing_get_windows (BudgieWindowingWindowing* self)
{
	GList* result;
	XfwScreen* _tmp0_;
	GList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->screen;
	_tmp1_ = xfw_screen_get_windows (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static void
g_cclosure_user_marshal_VOID__OBJECT_FLAGS_FLAGS (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_FLAGS_FLAGS) (gpointer data1, gpointer arg_1, guint arg_2, guint arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_FLAGS_FLAGS callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_FLAGS_FLAGS) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_flags (param_values + 2), g_value_get_flags (param_values + 3), data2);
}

static void
_budgie_windowing_windowing_on_dbus_get_gasync_ready_callback (GObject* source_object,
                                                               GAsyncResult* res,
                                                               gpointer self)
{
	budgie_windowing_windowing_on_dbus_get ((BudgieWindowingWindowing*) self, source_object, res);
	g_object_unref (self);
}

static void
_budgie_windowing_windowing_on_window_added_gfunc (gconstpointer data,
                                                   gpointer self)
{
	budgie_windowing_windowing_on_window_added ((BudgieWindowingWindowing*) self, (XfwWindow*) data);
}

static void
_budgie_windowing_windowing_on_active_window_changed_libxfce4windowing_screen_active_window_changed (XfwScreen* _sender,
                                                                                                     XfwWindow* window,
                                                                                                     gpointer self)
{
	budgie_windowing_windowing_on_active_window_changed ((BudgieWindowingWindowing*) self, window);
}

static void
_budgie_windowing_windowing_on_window_added_libxfce4windowing_screen_window_opened (XfwScreen* _sender,
                                                                                    XfwWindow* window,
                                                                                    gpointer self)
{
	budgie_windowing_windowing_on_window_added ((BudgieWindowingWindowing*) self, window);
}

static void
_budgie_windowing_windowing_on_window_removed_libxfce4windowing_screen_window_closed (XfwScreen* _sender,
                                                                                      XfwWindow* window,
                                                                                      gpointer self)
{
	budgie_windowing_windowing_on_window_removed ((BudgieWindowingWindowing*) self, window);
}

static void
_budgie_windowing_windowing_night_light_enabled_changed_g_settings_changed (GSettings* _sender,
                                                                            const gchar* key,
                                                                            gpointer self)
{
	budgie_windowing_windowing_night_light_enabled_changed ((BudgieWindowingWindowing*) self, key);
}

static void
_budgie_windowing_windowing_wm_settings_changed_g_settings_changed (GSettings* _sender,
                                                                    const gchar* key,
                                                                    gpointer self)
{
	budgie_windowing_windowing_wm_settings_changed ((BudgieWindowingWindowing*) self, key);
}

static GObject *
budgie_windowing_windowing_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BudgieWindowingWindowing * self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	GHashTable* _tmp4_;
	XfwScreen* _tmp5_;
	XfwScreen* _tmp6_;
	GList* _tmp7_;
	XfwScreen* _tmp8_;
	XfwScreen* _tmp9_;
	XfwScreen* _tmp10_;
	GSettings* _tmp11_;
	GSettings* _tmp12_;
	gulong _tmp13_;
	GSettings* _tmp14_;
	GSettings* _tmp15_;
	GSettings* _tmp16_;
	GSettings* _tmp17_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (budgie_windowing_windowing_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_WINDOWING_TYPE_WINDOWING, BudgieWindowingWindowing);
	_tmp0_ = g_settings_new ("org.gnome.settings-daemon.plugins.color");
	_g_object_unref0 (self->priv->color_settings);
	self->priv->color_settings = _tmp0_;
	_tmp1_ = g_settings_new ("com.solus-project.budgie-wm");
	_g_object_unref0 (self->priv->wm_settings);
	self->priv->wm_settings = _tmp1_;
	g_async_initable_new_async (BUDGIE_WINDOWING_TYPE_NOTIFICATION_DISPATCHER_PROXY, 0, NULL, _budgie_windowing_windowing_on_dbus_get_gasync_ready_callback, g_object_ref (self), "g-flags", G_DBUS_PROXY_FLAGS_NONE, "g-name", BUDGIE_WINDOWING_NOTIFICATIONS_DBUS_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", BUDGIE_WINDOWING_NOTIFICATIONS_DBUS_OBJECT_PATH, "g-interface-name", "org.buddiesofbudgie.budgie.Dispatcher", NULL);
	_tmp2_ = g_direct_hash;
	_tmp3_ = g_direct_equal;
	_tmp4_ = g_hash_table_new_full (_tmp2_, _tmp3_, _g_object_unref0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->applications);
	self->priv->applications = _tmp4_;
	(self->priv->fullscreen_windows == NULL) ? NULL : (self->priv->fullscreen_windows = (_g_list_free__g_object_unref0_ (self->priv->fullscreen_windows), NULL));
	self->priv->fullscreen_windows = NULL;
	_tmp5_ = xfw_screen_get_default ();
	_g_object_unref0 (self->priv->screen);
	self->priv->screen = _tmp5_;
	_tmp6_ = self->priv->screen;
	_tmp7_ = xfw_screen_get_windows (_tmp6_);
	g_list_foreach (_tmp7_, _budgie_windowing_windowing_on_window_added_gfunc, self);
	_tmp8_ = self->priv->screen;
	g_signal_connect_object (_tmp8_, "active-window-changed", (GCallback) _budgie_windowing_windowing_on_active_window_changed_libxfce4windowing_screen_active_window_changed, self, 0);
	_tmp9_ = self->priv->screen;
	g_signal_connect_object (_tmp9_, "window-opened", (GCallback) _budgie_windowing_windowing_on_window_added_libxfce4windowing_screen_window_opened, self, 0);
	_tmp10_ = self->priv->screen;
	g_signal_connect_object (_tmp10_, "window-closed", (GCallback) _budgie_windowing_windowing_on_window_removed_libxfce4windowing_screen_window_closed, self, 0);
	budgie_windowing_windowing_setup_workspace_listener (self);
	_tmp11_ = self->priv->color_settings;
	self->priv->previous_color_setting = g_settings_get_boolean (_tmp11_, "night-light-enabled");
	_tmp12_ = self->priv->color_settings;
	_tmp13_ = g_signal_connect_object (_tmp12_, "changed::night-light-enabled", (GCallback) _budgie_windowing_windowing_night_light_enabled_changed_g_settings_changed, self, 0);
	self->priv->night_light_setting_handler = _tmp13_;
	_tmp14_ = self->priv->wm_settings;
	self->priv->pause_night_light = g_settings_get_boolean (_tmp14_, "disable-night-light-on-fullscreen");
	_tmp15_ = self->priv->wm_settings;
	self->priv->pause_notifications = g_settings_get_boolean (_tmp15_, "pause-notifications-on-fullscreen");
	_tmp16_ = self->priv->wm_settings;
	g_signal_connect_object (_tmp16_, "changed::disable-night-light-on-fullscreen", (GCallback) _budgie_windowing_windowing_wm_settings_changed_g_settings_changed, self, 0);
	_tmp17_ = self->priv->wm_settings;
	g_signal_connect_object (_tmp17_, "changed::pause-notifications-on-fullscreen", (GCallback) _budgie_windowing_windowing_wm_settings_changed_g_settings_changed, self, 0);
	return obj;
}

static void
budgie_windowing_windowing_class_init (BudgieWindowingWindowingClass * klass,
                                       gpointer klass_data)
{
	budgie_windowing_windowing_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieWindowingWindowing_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_windowing_windowing_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_windowing_windowing_set_property;
	G_OBJECT_CLASS (klass)->constructor = budgie_windowing_windowing_constructor;
	G_OBJECT_CLASS (klass)->finalize = budgie_windowing_windowing_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_WINDOWING_WINDOWING_HAS_WINDOWS_PROPERTY, budgie_windowing_windowing_properties[BUDGIE_WINDOWING_WINDOWING_HAS_WINDOWS_PROPERTY] = g_param_spec_boolean ("has-windows", "has-windows", "has-windows", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_WINDOWING_WINDOWING_WINDOWS_PROPERTY, budgie_windowing_windowing_properties[BUDGIE_WINDOWING_WINDOWING_WINDOWS_PROPERTY] = g_param_spec_pointer ("windows", "windows", "windows", G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Emitted when the currently active window has changed.
	 */
	budgie_windowing_windowing_signals[BUDGIE_WINDOWING_WINDOWING_ACTIVE_WINDOW_CHANGED_SIGNAL] = g_signal_new ("active-window-changed", BUDGIE_WINDOWING_TYPE_WINDOWING, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, xfw_window_get_type (), xfw_window_get_type ());
	/**
	 * Emitted when the currently active workspace has changed.
	 */
	budgie_windowing_windowing_signals[BUDGIE_WINDOWING_WINDOWING_ACTIVE_WORKSPACE_CHANGED_SIGNAL] = g_signal_new ("active-workspace-changed", BUDGIE_WINDOWING_TYPE_WINDOWING, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, xfw_workspace_get_type ());
	/**
	 * Emitted when a WindowGroup has been created.
	 */
	budgie_windowing_windowing_signals[BUDGIE_WINDOWING_WINDOWING_WINDOW_GROUP_ADDED_SIGNAL] = g_signal_new ("window-group-added", BUDGIE_WINDOWING_TYPE_WINDOWING, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, BUDGIE_WINDOWING_TYPE_WINDOW_GROUP);
	/**
	 * Emitted when a WindowGroup has been removed.
	 */
	budgie_windowing_windowing_signals[BUDGIE_WINDOWING_WINDOWING_WINDOW_GROUP_REMOVED_SIGNAL] = g_signal_new ("window-group-removed", BUDGIE_WINDOWING_TYPE_WINDOWING, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, BUDGIE_WINDOWING_TYPE_WINDOW_GROUP);
	/**
	 * Emitted when a window is added to the windowing system.
	 */
	budgie_windowing_windowing_signals[BUDGIE_WINDOWING_WINDOWING_WINDOW_ADDED_SIGNAL] = g_signal_new ("window-added", BUDGIE_WINDOWING_TYPE_WINDOWING, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, xfw_window_get_type ());
	/**
	 * Emitted when a window is removed from the windowing system.
	 */
	budgie_windowing_windowing_signals[BUDGIE_WINDOWING_WINDOWING_WINDOW_REMOVED_SIGNAL] = g_signal_new ("window-removed", BUDGIE_WINDOWING_TYPE_WINDOWING, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, xfw_window_get_type ());
	/**
	 * Emitted when the state of a window has changed.
	 */
	budgie_windowing_windowing_signals[BUDGIE_WINDOWING_WINDOWING_WINDOW_STATE_CHANGED_SIGNAL] = g_signal_new ("window-state-changed", BUDGIE_WINDOWING_TYPE_WINDOWING, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_FLAGS_FLAGS, G_TYPE_NONE, 3, xfw_window_get_type (), xfw_window_state_get_type (), xfw_window_state_get_type ());
	/**
	 * Emitted when a Workspace has been created.
	 */
	budgie_windowing_windowing_signals[BUDGIE_WINDOWING_WINDOWING_WORKSPACE_CREATED_SIGNAL] = g_signal_new ("workspace-created", BUDGIE_WINDOWING_TYPE_WINDOWING, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, xfw_workspace_get_type ());
	/**
	 * Emitted when a Workspace has been destroyed.
	 */
	budgie_windowing_windowing_signals[BUDGIE_WINDOWING_WINDOWING_WORKSPACE_DESTROYED_SIGNAL] = g_signal_new ("workspace-destroyed", BUDGIE_WINDOWING_TYPE_WINDOWING, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, xfw_workspace_get_type ());
}

static void
budgie_windowing_windowing_instance_init (BudgieWindowingWindowing * self,
                                          gpointer klass)
{
	self->priv = budgie_windowing_windowing_get_instance_private (self);
}

static void
budgie_windowing_windowing_finalize (GObject * obj)
{
	BudgieWindowingWindowing * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_WINDOWING_TYPE_WINDOWING, BudgieWindowingWindowing);
	_g_object_unref0 (self->priv->screen);
	_g_object_unref0 (self->priv->workspace_manager);
	_g_hash_table_unref0 (self->priv->applications);
	(self->priv->fullscreen_windows == NULL) ? NULL : (self->priv->fullscreen_windows = (_g_list_free__g_object_unref0_ (self->priv->fullscreen_windows), NULL));
	_g_object_unref0 (self->priv->last_active_window);
	_g_object_unref0 (self->priv->dispatcher);
	_g_object_unref0 (self->priv->color_settings);
	_g_object_unref0 (self->priv->wm_settings);
	G_OBJECT_CLASS (budgie_windowing_windowing_parent_class)->finalize (obj);
}

/**
 * This object keeps track of WindowGroups. It serves as the main part
 * of the Budgie windowing library.
 */
static GType
budgie_windowing_windowing_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieWindowingWindowingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_windowing_windowing_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieWindowingWindowing), 0, (GInstanceInitFunc) budgie_windowing_windowing_instance_init, NULL };
	GType budgie_windowing_windowing_type_id;
	budgie_windowing_windowing_type_id = g_type_register_static (G_TYPE_OBJECT, "BudgieWindowingWindowing", &g_define_type_info, 0);
	BudgieWindowingWindowing_private_offset = g_type_add_instance_private (budgie_windowing_windowing_type_id, sizeof (BudgieWindowingWindowingPrivate));
	return budgie_windowing_windowing_type_id;
}

GType
budgie_windowing_windowing_get_type (void)
{
	static volatile gsize budgie_windowing_windowing_type_id__once = 0;
	if (g_once_init_enter (&budgie_windowing_windowing_type_id__once)) {
		GType budgie_windowing_windowing_type_id;
		budgie_windowing_windowing_type_id = budgie_windowing_windowing_get_type_once ();
		g_once_init_leave (&budgie_windowing_windowing_type_id__once, budgie_windowing_windowing_type_id);
	}
	return budgie_windowing_windowing_type_id__once;
}

static void
_vala_budgie_windowing_windowing_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	BudgieWindowingWindowing * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_WINDOWING_TYPE_WINDOWING, BudgieWindowingWindowing);
	switch (property_id) {
		case BUDGIE_WINDOWING_WINDOWING_HAS_WINDOWS_PROPERTY:
		g_value_set_boolean (value, budgie_windowing_windowing_get_has_windows (self));
		break;
		case BUDGIE_WINDOWING_WINDOWING_WINDOWS_PROPERTY:
		g_value_set_pointer (value, budgie_windowing_windowing_get_windows (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_budgie_windowing_windowing_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	BudgieWindowingWindowing * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_WINDOWING_TYPE_WINDOWING, BudgieWindowingWindowing);
	switch (property_id) {
		case BUDGIE_WINDOWING_WINDOWING_HAS_WINDOWS_PROPERTY:
		budgie_windowing_windowing_set_has_windows (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

