
/* Automatically generated struct definitions for the Data API.
 * Do not edit manually, changes will be overwritten.           */

#define RNA_RUNTIME

#include <float.h>
#include <stdio.h>
#include <limits.h>
#include <limits>
#include <string.h>

#include <stddef.h>

#include <algorithm>

#include "MEM_guardedalloc.h"

#include "DNA_ID.h"
#include "DNA_scene_types.h"
#include "DNA_node_types.h"
#include "BLI_fileops.h"

#include "BLI_listbase.h"

#include "BLI_path_utils.hh"

#include "BLI_rect.h"

#include "BLI_string.h"

#include "BLI_string_utf8.h"

#include "BLI_utildefines.h"

#include "BKE_context.hh"
#include "BKE_lib_id.hh"
#include "BKE_main.hh"
#include "BKE_report.hh"
#include "RNA_define.hh"
#include "RNA_types.hh"
#include "rna_internal.hh"

#include "rna_prototypes_gen.hh"

#include "rna_asset.cc"

#pragma GCC diagnostic ignored "-Wunused-parameter"

/* Auto-generated Functions. */


extern PropertyRNA &rna_AssetTag_rna_properties;
extern PropertyRNA &rna_AssetTag_rna_type;
extern PropertyRNA &rna_AssetTag_name;


extern PropertyRNA &rna_AssetMetaData_rna_properties;
extern PropertyRNA &rna_AssetMetaData_rna_type;
extern PropertyRNA &rna_AssetMetaData_author;
extern PropertyRNA &rna_AssetMetaData_description;
extern PropertyRNA &rna_AssetMetaData_copyright;
extern PropertyRNA &rna_AssetMetaData_license;
extern PropertyRNA &rna_AssetMetaData_tags;
extern PropertyRNA &rna_AssetMetaData_active_tag;
extern PropertyRNA &rna_AssetMetaData_catalog_id;
extern PropertyRNA &rna_AssetMetaData_catalog_simple_name;


extern PropertyRNA &rna_AssetTags_rna_properties;
extern PropertyRNA &rna_AssetTags_rna_type;

extern FunctionRNA rna_AssetTags_new_func;
extern PropertyRNA &rna_AssetTags_new_name;
extern PropertyRNA &rna_AssetTags_new_skip_if_exists;
extern PropertyRNA &rna_AssetTags_new_tag;

extern FunctionRNA rna_AssetTags_remove_func;
extern PropertyRNA &rna_AssetTags_remove_tag;



extern PropertyRNA &rna_AssetLibraryReference_rna_properties;
extern PropertyRNA &rna_AssetLibraryReference_rna_type;


extern PropertyRNA &rna_AssetRepresentation_rna_properties;
extern PropertyRNA &rna_AssetRepresentation_rna_type;
extern PropertyRNA &rna_AssetRepresentation_name;
extern PropertyRNA &rna_AssetRepresentation_metadata;
extern PropertyRNA &rna_AssetRepresentation_id_type;
extern PropertyRNA &rna_AssetRepresentation_local_id;
extern PropertyRNA &rna_AssetRepresentation_full_library_path;
extern PropertyRNA &rna_AssetRepresentation_full_path;


extern PropertyRNA &rna_AssetWeakReference_rna_properties;
extern PropertyRNA &rna_AssetWeakReference_rna_type;
extern PropertyRNA &rna_AssetWeakReference_asset_library_type;
extern PropertyRNA &rna_AssetWeakReference_asset_library_identifier;
extern PropertyRNA &rna_AssetWeakReference_relative_asset_identifier;

static PointerRNA AssetTag_rna_properties_get(CollectionPropertyIterator *iter)
{
    PropCollectionGetFunc fn = rna_builtin_properties_get;
    return fn(iter);
}

extern void AssetTag_rna_properties_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_AssetTag_rna_properties;

    PropCollectionBeginFunc fn = rna_builtin_properties_begin;
    fn(iter, ptr);

    if (iter->valid) {
        iter->ptr = AssetTag_rna_properties_get(iter);
    }
}

extern void AssetTag_rna_properties_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_builtin_properties_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = AssetTag_rna_properties_get(iter);
    }
}

extern void AssetTag_rna_properties_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool AssetTag_rna_properties_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr)
{
    PropCollectionLookupStringFunc fn = rna_builtin_properties_lookup_string;
    return fn(ptr, key, r_ptr);
}

extern PointerRNA AssetTag_rna_type_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_builtin_type_get;
    return fn(ptr);
}

extern void AssetTag_name_get(PointerRNA *ptr, char *value)
{
    AssetTag *data = (AssetTag *)(ptr->data);
    strcpy(value, data->name);
}

extern int AssetTag_name_length(PointerRNA *ptr)
{
    AssetTag *data = (AssetTag *)(ptr->data);
    return strlen(data->name);
}

extern void AssetTag_name_set(PointerRNA *ptr, const char *value)
{
    AssetTag *data = (AssetTag *)(ptr->data);
    BLI_strncpy_utf8(data->name, value, 64);
}

static PointerRNA AssetMetaData_rna_properties_get(CollectionPropertyIterator *iter)
{
    PropCollectionGetFunc fn = rna_builtin_properties_get;
    return fn(iter);
}

extern void AssetMetaData_rna_properties_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_AssetMetaData_rna_properties;

    PropCollectionBeginFunc fn = rna_builtin_properties_begin;
    fn(iter, ptr);

    if (iter->valid) {
        iter->ptr = AssetMetaData_rna_properties_get(iter);
    }
}

extern void AssetMetaData_rna_properties_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_builtin_properties_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = AssetMetaData_rna_properties_get(iter);
    }
}

extern void AssetMetaData_rna_properties_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool AssetMetaData_rna_properties_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr)
{
    PropCollectionLookupStringFunc fn = rna_builtin_properties_lookup_string;
    return fn(ptr, key, r_ptr);
}

extern PointerRNA AssetMetaData_rna_type_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_builtin_type_get;
    return fn(ptr);
}

extern void AssetMetaData_author_get(PointerRNA *ptr, char *value)
{
    PropStringGetFunc fn = rna_AssetMetaData_author_get;
    fn(ptr, value);
}

extern int AssetMetaData_author_length(PointerRNA *ptr)
{
    PropStringLengthFunc fn = rna_AssetMetaData_author_length;
    return fn(ptr);
}

extern void AssetMetaData_author_set(PointerRNA *ptr, const char *value)
{
    PropStringSetFunc fn = rna_AssetMetaData_author_set;
    fn(ptr, value);
}

extern void AssetMetaData_description_get(PointerRNA *ptr, char *value)
{
    PropStringGetFunc fn = rna_AssetMetaData_description_get;
    fn(ptr, value);
}

extern int AssetMetaData_description_length(PointerRNA *ptr)
{
    PropStringLengthFunc fn = rna_AssetMetaData_description_length;
    return fn(ptr);
}

extern void AssetMetaData_description_set(PointerRNA *ptr, const char *value)
{
    PropStringSetFunc fn = rna_AssetMetaData_description_set;
    fn(ptr, value);
}

extern void AssetMetaData_copyright_get(PointerRNA *ptr, char *value)
{
    PropStringGetFunc fn = rna_AssetMetaData_copyright_get;
    fn(ptr, value);
}

extern int AssetMetaData_copyright_length(PointerRNA *ptr)
{
    PropStringLengthFunc fn = rna_AssetMetaData_copyright_length;
    return fn(ptr);
}

extern void AssetMetaData_copyright_set(PointerRNA *ptr, const char *value)
{
    PropStringSetFunc fn = rna_AssetMetaData_copyright_set;
    fn(ptr, value);
}

extern void AssetMetaData_license_get(PointerRNA *ptr, char *value)
{
    PropStringGetFunc fn = rna_AssetMetaData_license_get;
    fn(ptr, value);
}

extern int AssetMetaData_license_length(PointerRNA *ptr)
{
    PropStringLengthFunc fn = rna_AssetMetaData_license_length;
    return fn(ptr);
}

extern void AssetMetaData_license_set(PointerRNA *ptr, const char *value)
{
    PropStringSetFunc fn = rna_AssetMetaData_license_set;
    fn(ptr, value);
}

static PointerRNA AssetMetaData_tags_get(CollectionPropertyIterator *iter)
{
    return RNA_pointer_create_with_parent(iter->parent, &RNA_AssetTag, rna_iterator_listbase_get(iter));
}

extern void AssetMetaData_tags_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{
    AssetMetaData *data = (AssetMetaData *)(ptr->data);

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_AssetMetaData_tags;

    rna_iterator_listbase_begin(iter, ptr, &data->tags, nullptr);

    if (iter->valid) {
        iter->ptr = AssetMetaData_tags_get(iter);
    }
}

extern void AssetMetaData_tags_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_iterator_listbase_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = AssetMetaData_tags_get(iter);
    }
}

extern void AssetMetaData_tags_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool AssetMetaData_tags_lookup_int(PointerRNA *ptr, int index, PointerRNA *r_ptr)
{
    bool found = false;
    CollectionPropertyIterator iter;

    AssetMetaData_tags_begin(&iter, ptr);

    if (iter.valid) {
        ListBaseIterator *internal = &iter.internal.listbase;
        if (internal->skip) {
            while (index-- > 0 && iter.valid) {
                rna_iterator_listbase_next(&iter);
            }
            found = (index == -1 && iter.valid);
        }
        else {
            while (index-- > 0 && internal->link) {
                internal->link = internal->link->next;
            }
            found = (index == -1 && internal->link);
        }
        if (found) { *r_ptr = AssetMetaData_tags_get(&iter); }
    }

    AssetMetaData_tags_end(&iter);

    return found;
}

extern int AssetTag_name_length(PointerRNA *);
extern void AssetTag_name_get(PointerRNA *, char *);

extern bool AssetMetaData_tags_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr)
{
    bool found = false;
    CollectionPropertyIterator iter;
    char namebuf[1024];
    char *name;

    AssetMetaData_tags_begin(&iter, ptr);

    while (iter.valid) {
        if (iter.ptr.data) {
            int namelen = AssetTag_name_length(&iter.ptr);
            if (namelen < 1024) {
                AssetTag_name_get(&iter.ptr, namebuf);
                if (strcmp(namebuf, key) == 0) {
                    found = true;
                    *r_ptr = iter.ptr;
                    break;
                }
            }
            else {
                name = MEM_malloc_arrayN<char>(size_t(namelen) + 1,
                                               "name string");
                AssetTag_name_get(&iter.ptr, name);
                if (strcmp(name, key) == 0) {
                    MEM_freeN(name);

                    found = true;
                    *r_ptr = iter.ptr;
                    break;
                }
                else {
                    MEM_freeN(name);
                }
            }
        }
        AssetMetaData_tags_next(&iter);
    }
    AssetMetaData_tags_end(&iter);

    return found;
}

extern int AssetMetaData_active_tag_get(PointerRNA *ptr)
{
    AssetMetaData *data = (AssetMetaData *)(ptr->data);
    return (int)(data->active_tag);
}

extern void AssetMetaData_active_tag_set(PointerRNA *ptr, int value)
{
    AssetMetaData *data = (AssetMetaData *)(ptr->data);
    int prop_clamp_min = INT_MIN, prop_clamp_max = INT_MAX, prop_soft_min, prop_soft_max;
    rna_AssetMetaData_active_tag_range(ptr, &prop_clamp_min, &prop_clamp_max, &prop_soft_min, &prop_soft_max);
#ifdef __cplusplus
    data->active_tag = (std::remove_reference_t<decltype(data->active_tag)>)std::clamp(value, prop_clamp_min, prop_clamp_max);
#else
    data->active_tag = std::clamp(value, prop_clamp_min, prop_clamp_max);
#endif
}

extern void AssetMetaData_catalog_id_get(PointerRNA *ptr, char *value)
{
    PropStringGetFunc fn = rna_AssetMetaData_catalog_id_get;
    fn(ptr, value);
}

extern int AssetMetaData_catalog_id_length(PointerRNA *ptr)
{
    PropStringLengthFunc fn = rna_AssetMetaData_catalog_id_length;
    return fn(ptr);
}

extern void AssetMetaData_catalog_id_set(PointerRNA *ptr, const char *value)
{
    PropStringSetFunc fn = rna_AssetMetaData_catalog_id_set;
    fn(ptr, value);
}

extern void AssetMetaData_catalog_simple_name_get(PointerRNA *ptr, char *value)
{
    AssetMetaData *data = (AssetMetaData *)(ptr->data);
    strcpy(value, data->catalog_simple_name);
}

extern int AssetMetaData_catalog_simple_name_length(PointerRNA *ptr)
{
    AssetMetaData *data = (AssetMetaData *)(ptr->data);
    return strlen(data->catalog_simple_name);
}

static PointerRNA AssetTags_rna_properties_get(CollectionPropertyIterator *iter)
{
    PropCollectionGetFunc fn = rna_builtin_properties_get;
    return fn(iter);
}

extern void AssetTags_rna_properties_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_AssetTags_rna_properties;

    PropCollectionBeginFunc fn = rna_builtin_properties_begin;
    fn(iter, ptr);

    if (iter->valid) {
        iter->ptr = AssetTags_rna_properties_get(iter);
    }
}

extern void AssetTags_rna_properties_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_builtin_properties_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = AssetTags_rna_properties_get(iter);
    }
}

extern void AssetTags_rna_properties_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool AssetTags_rna_properties_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr)
{
    PropCollectionLookupStringFunc fn = rna_builtin_properties_lookup_string;
    return fn(ptr, key, r_ptr);
}

extern PointerRNA AssetTags_rna_type_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_builtin_type_get;
    return fn(ptr);
}

static PointerRNA AssetLibraryReference_rna_properties_get(CollectionPropertyIterator *iter)
{
    PropCollectionGetFunc fn = rna_builtin_properties_get;
    return fn(iter);
}

extern void AssetLibraryReference_rna_properties_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_AssetLibraryReference_rna_properties;

    PropCollectionBeginFunc fn = rna_builtin_properties_begin;
    fn(iter, ptr);

    if (iter->valid) {
        iter->ptr = AssetLibraryReference_rna_properties_get(iter);
    }
}

extern void AssetLibraryReference_rna_properties_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_builtin_properties_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = AssetLibraryReference_rna_properties_get(iter);
    }
}

extern void AssetLibraryReference_rna_properties_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool AssetLibraryReference_rna_properties_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr)
{
    PropCollectionLookupStringFunc fn = rna_builtin_properties_lookup_string;
    return fn(ptr, key, r_ptr);
}

extern PointerRNA AssetLibraryReference_rna_type_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_builtin_type_get;
    return fn(ptr);
}

static PointerRNA AssetRepresentation_rna_properties_get(CollectionPropertyIterator *iter)
{
    PropCollectionGetFunc fn = rna_builtin_properties_get;
    return fn(iter);
}

extern void AssetRepresentation_rna_properties_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_AssetRepresentation_rna_properties;

    PropCollectionBeginFunc fn = rna_builtin_properties_begin;
    fn(iter, ptr);

    if (iter->valid) {
        iter->ptr = AssetRepresentation_rna_properties_get(iter);
    }
}

extern void AssetRepresentation_rna_properties_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_builtin_properties_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = AssetRepresentation_rna_properties_get(iter);
    }
}

extern void AssetRepresentation_rna_properties_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool AssetRepresentation_rna_properties_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr)
{
    PropCollectionLookupStringFunc fn = rna_builtin_properties_lookup_string;
    return fn(ptr, key, r_ptr);
}

extern PointerRNA AssetRepresentation_rna_type_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_builtin_type_get;
    return fn(ptr);
}

extern void AssetRepresentation_name_get(PointerRNA *ptr, char *value)
{
    PropStringGetFunc fn = rna_AssetRepresentation_name_get;
    fn(ptr, value);
}

extern int AssetRepresentation_name_length(PointerRNA *ptr)
{
    PropStringLengthFunc fn = rna_AssetRepresentation_name_length;
    return fn(ptr);
}

extern PointerRNA AssetRepresentation_metadata_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_AssetRepresentation_metadata_get;
    return fn(ptr);
}

extern int AssetRepresentation_id_type_get(PointerRNA *ptr)
{
    PropEnumGetFunc fn = rna_AssetRepresentation_id_type_get;
    return fn(ptr);
}

extern PointerRNA AssetRepresentation_local_id_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_AssetRepresentation_local_id_get;
    return fn(ptr);
}

extern void AssetRepresentation_full_library_path_get(PointerRNA *ptr, char *value)
{
    PropStringGetFunc fn = rna_AssetRepresentation_full_library_path_get;
    fn(ptr, value);
}

extern int AssetRepresentation_full_library_path_length(PointerRNA *ptr)
{
    PropStringLengthFunc fn = rna_AssetRepresentation_full_library_path_length;
    return fn(ptr);
}

extern void AssetRepresentation_full_path_get(PointerRNA *ptr, char *value)
{
    PropStringGetFunc fn = rna_AssetRepresentation_full_path_get;
    fn(ptr, value);
}

extern int AssetRepresentation_full_path_length(PointerRNA *ptr)
{
    PropStringLengthFunc fn = rna_AssetRepresentation_full_path_length;
    return fn(ptr);
}

static PointerRNA AssetWeakReference_rna_properties_get(CollectionPropertyIterator *iter)
{
    PropCollectionGetFunc fn = rna_builtin_properties_get;
    return fn(iter);
}

extern void AssetWeakReference_rna_properties_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_AssetWeakReference_rna_properties;

    PropCollectionBeginFunc fn = rna_builtin_properties_begin;
    fn(iter, ptr);

    if (iter->valid) {
        iter->ptr = AssetWeakReference_rna_properties_get(iter);
    }
}

extern void AssetWeakReference_rna_properties_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_builtin_properties_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = AssetWeakReference_rna_properties_get(iter);
    }
}

extern void AssetWeakReference_rna_properties_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool AssetWeakReference_rna_properties_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr)
{
    PropCollectionLookupStringFunc fn = rna_builtin_properties_lookup_string;
    return fn(ptr, key, r_ptr);
}

extern PointerRNA AssetWeakReference_rna_type_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_builtin_type_get;
    return fn(ptr);
}

extern int AssetWeakReference_asset_library_type_get(PointerRNA *ptr)
{
    AssetWeakReference *data = (AssetWeakReference *)(ptr->data);
    return (int)(data->asset_library_type);
}

extern void AssetWeakReference_asset_library_identifier_get(PointerRNA *ptr, char *value)
{
    AssetWeakReference *data = (AssetWeakReference *)(ptr->data);
    if (data->asset_library_identifier == nullptr) {
        *value = '\0';
        return;
    }
    strcpy(value, data->asset_library_identifier);
}

extern int AssetWeakReference_asset_library_identifier_length(PointerRNA *ptr)
{
    AssetWeakReference *data = (AssetWeakReference *)(ptr->data);
    return (data->asset_library_identifier == nullptr) ? 0 : strlen(data->asset_library_identifier);
}

extern void AssetWeakReference_relative_asset_identifier_get(PointerRNA *ptr, char *value)
{
    AssetWeakReference *data = (AssetWeakReference *)(ptr->data);
    if (data->relative_asset_identifier == nullptr) {
        *value = '\0';
        return;
    }
    strcpy(value, data->relative_asset_identifier);
}

extern int AssetWeakReference_relative_asset_identifier_length(PointerRNA *ptr)
{
    AssetWeakReference *data = (AssetWeakReference *)(ptr->data);
    return (data->relative_asset_identifier == nullptr) ? 0 : strlen(data->relative_asset_identifier);
}



extern struct AssetTag *AssetTags_new_func(struct ID *_selfid, struct AssetMetaData *_self, ReportList *reports, const char * name, bool skip_if_exists)
{
	return rna_AssetMetaData_tag_new(_selfid, _self, reports, name, skip_if_exists);
}

static void AssetTags_new_call(bContext *C, ReportList *reports, PointerRNA *_ptr, ParameterList *_parms)
{
	struct ID *_selfid;
	struct AssetMetaData *_self;
	const char * name;
	bool skip_if_exists;
	struct AssetTag *tag;
	char *_data, *_retdata;
	
	_selfid = (struct ID *)_ptr->owner_id;
	_self = (struct AssetMetaData *)_ptr->data;
	_data = (char *)_parms->data;
	name = *((const char * *)_data);
	_data += 8;
	skip_if_exists = *((bool *)_data);
	_data += 8;
	_retdata = _data;
	
	tag = rna_AssetMetaData_tag_new(_selfid, _self, reports, name, skip_if_exists);
	*((struct AssetTag **)_retdata) = tag;
}

extern void AssetTags_remove_func(struct ID *_selfid, struct AssetMetaData *_self, ReportList *reports, struct PointerRNA *tag)
{
	rna_AssetMetaData_tag_remove(_selfid, _self, reports, tag);
}

static void AssetTags_remove_call(bContext *C, ReportList *reports, PointerRNA *_ptr, ParameterList *_parms)
{
	struct ID *_selfid;
	struct AssetMetaData *_self;
	struct PointerRNA *tag;
	char *_data;
	
	_selfid = (struct ID *)_ptr->owner_id;
	_self = (struct AssetMetaData *)_ptr->data;
	_data = (char *)_parms->data;
	tag = *((struct PointerRNA **)_data);
	
	rna_AssetMetaData_tag_remove(_selfid, _self, reports, tag);
}

/* Repeated prototypes to detect errors */

struct AssetTag *rna_AssetMetaData_tag_new(struct ID *_selfid, struct AssetMetaData *_self, ReportList *reports, const char * name, bool skip_if_exists);
void rna_AssetMetaData_tag_remove(struct ID *_selfid, struct AssetMetaData *_self, ReportList *reports, struct PointerRNA *tag);




/* Asset Tag */
static CollectionPropertyRNA rna_AssetTag_rna_properties_ = {
	{&rna_AssetTag_rna_type, nullptr,
	-1, "rna_properties", 0, 0, 0, 1, 0, PropertyPathTemplateType(0), "Properties",
	"RNA property collection",
	0, "*",
	nullptr,
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	AssetTag_rna_properties_begin, AssetTag_rna_properties_next, AssetTag_rna_properties_end, AssetTag_rna_properties_get, nullptr, nullptr, AssetTag_rna_properties_lookup_string, nullptr, &RNA_Property
};
PropertyRNA &rna_AssetTag_rna_properties = reinterpret_cast<PropertyRNA &>(rna_AssetTag_rna_properties_);

static PointerPropertyRNA rna_AssetTag_rna_type_ = {
	{&rna_AssetTag_name, &rna_AssetTag_rna_properties,
	-1, "rna_type", 8912896, 0, 0, 0, 0, PropertyPathTemplateType(0), "RNA",
	"RNA type definition",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	AssetTag_rna_type_get, nullptr, nullptr, nullptr,&RNA_Struct
};
PropertyRNA &rna_AssetTag_rna_type = reinterpret_cast<PropertyRNA &>(rna_AssetTag_rna_type_);

static StringPropertyRNA rna_AssetTag_name_ = {
	{nullptr, &rna_AssetTag_rna_type,
	-1, "name", 262145, 0, 0, 0, 0, PropertyPathTemplateType(0), "Name",
	"The identifier that makes up this tag",
	0, "*",
	nullptr,
	PROP_STRING, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {64, 0, 0}, 0,
	nullptr, 0, rna_AssetTag_editable, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	AssetTag_name_get, AssetTag_name_length, AssetTag_name_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, eStringPropertySearchFlag(0), nullptr, 64, ""
};
PropertyRNA &rna_AssetTag_name = reinterpret_cast<PropertyRNA &>(rna_AssetTag_name_);

StructRNA RNA_AssetTag = {
	{(ContainerRNA *)&RNA_AssetMetaData, (ContainerRNA *)&RNA_AttributeGroupGreasePencilDrawing,
	nullptr,
	{&rna_AssetTag_rna_properties, &rna_AssetTag_name}},
	"AssetTag", nullptr, nullptr, 516, nullptr, "Asset Tag",
	"User defined tag (name token)",
	"*", 63,
	&rna_AssetTag_name, &rna_AssetTag_rna_properties,
	nullptr,
	nullptr,
	nullptr,
	rna_AssetTag_path,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{nullptr, nullptr}
};

/* Asset Data */
static CollectionPropertyRNA rna_AssetMetaData_rna_properties_ = {
	{&rna_AssetMetaData_rna_type, nullptr,
	-1, "rna_properties", 0, 0, 0, 1, 0, PropertyPathTemplateType(0), "Properties",
	"RNA property collection",
	0, "*",
	nullptr,
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	AssetMetaData_rna_properties_begin, AssetMetaData_rna_properties_next, AssetMetaData_rna_properties_end, AssetMetaData_rna_properties_get, nullptr, nullptr, AssetMetaData_rna_properties_lookup_string, nullptr, &RNA_Property
};
PropertyRNA &rna_AssetMetaData_rna_properties = reinterpret_cast<PropertyRNA &>(rna_AssetMetaData_rna_properties_);

static PointerPropertyRNA rna_AssetMetaData_rna_type_ = {
	{&rna_AssetMetaData_author, &rna_AssetMetaData_rna_properties,
	-1, "rna_type", 8912896, 0, 0, 0, 0, PropertyPathTemplateType(0), "RNA",
	"RNA type definition",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	AssetMetaData_rna_type_get, nullptr, nullptr, nullptr,&RNA_Struct
};
PropertyRNA &rna_AssetMetaData_rna_type = reinterpret_cast<PropertyRNA &>(rna_AssetMetaData_rna_type_);

static StringPropertyRNA rna_AssetMetaData_author_ = {
	{&rna_AssetMetaData_description, &rna_AssetMetaData_rna_type,
	-1, "author", 262145, 0, 0, 0, 0, PropertyPathTemplateType(0), "Author",
	"Name of the creator of the asset",
	0, "*",
	nullptr,
	PROP_STRING, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, rna_AssetMetaData_editable, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	AssetMetaData_author_get, AssetMetaData_author_length, AssetMetaData_author_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, eStringPropertySearchFlag(0), nullptr, 0, ""
};
PropertyRNA &rna_AssetMetaData_author = reinterpret_cast<PropertyRNA &>(rna_AssetMetaData_author_);

static StringPropertyRNA rna_AssetMetaData_description_ = {
	{&rna_AssetMetaData_copyright, &rna_AssetMetaData_author,
	-1, "description", 262145, 0, 0, 0, 0, PropertyPathTemplateType(0), "Description",
	"A description of the asset to be displayed for the user",
	0, "*",
	nullptr,
	PROP_STRING, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, rna_AssetMetaData_editable, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	AssetMetaData_description_get, AssetMetaData_description_length, AssetMetaData_description_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, eStringPropertySearchFlag(0), nullptr, 0, ""
};
PropertyRNA &rna_AssetMetaData_description = reinterpret_cast<PropertyRNA &>(rna_AssetMetaData_description_);

static StringPropertyRNA rna_AssetMetaData_copyright_ = {
	{&rna_AssetMetaData_license, &rna_AssetMetaData_description,
	-1, "copyright", 262145, 0, 0, 0, 0, PropertyPathTemplateType(0), "Copyright",
	"Copyright notice for this asset. An empty copyright notice does not necessarily indicate that this is copyright-free. Contact the author if any clarification is needed.",
	0, "*",
	nullptr,
	PROP_STRING, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, rna_AssetMetaData_editable, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	AssetMetaData_copyright_get, AssetMetaData_copyright_length, AssetMetaData_copyright_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, eStringPropertySearchFlag(0), nullptr, 0, ""
};
PropertyRNA &rna_AssetMetaData_copyright = reinterpret_cast<PropertyRNA &>(rna_AssetMetaData_copyright_);

static StringPropertyRNA rna_AssetMetaData_license_ = {
	{&rna_AssetMetaData_tags, &rna_AssetMetaData_copyright,
	-1, "license", 262145, 0, 0, 0, 0, PropertyPathTemplateType(0), "License",
	"The type of license this asset is distributed under. An empty license name does not necessarily indicate that this is free of licensing terms. Contact the author if any clarification is needed.",
	0, "*",
	nullptr,
	PROP_STRING, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, rna_AssetMetaData_editable, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	AssetMetaData_license_get, AssetMetaData_license_length, AssetMetaData_license_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, eStringPropertySearchFlag(0), nullptr, 0, ""
};
PropertyRNA &rna_AssetMetaData_license = reinterpret_cast<PropertyRNA &>(rna_AssetMetaData_license_);

static CollectionPropertyRNA rna_AssetMetaData_tags_ = {
	{&rna_AssetMetaData_active_tag, &rna_AssetMetaData_license,
	-1, "tags", 0, 0, 0, 0, 0, PropertyPathTemplateType(0), "Tags",
	"Custom tags (name tokens) for the asset, used for filtering and general asset management",
	0, "*",
	nullptr,
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, rna_AssetMetaData_editable, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, &RNA_AssetTags},
	AssetMetaData_tags_begin, AssetMetaData_tags_next, AssetMetaData_tags_end, AssetMetaData_tags_get, nullptr, AssetMetaData_tags_lookup_int, AssetMetaData_tags_lookup_string, nullptr, &RNA_AssetTag
};
PropertyRNA &rna_AssetMetaData_tags = reinterpret_cast<PropertyRNA &>(rna_AssetMetaData_tags_);

static IntPropertyRNA rna_AssetMetaData_active_tag_ = {
	{&rna_AssetMetaData_catalog_id, &rna_AssetMetaData_tags,
	-1, "active_tag", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Active Tag",
	"Index of the tag set for editing",
	0, "*",
	nullptr,
	PROP_INT, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(AssetMetaData, active_tag), RawPropertyType(1), nullptr},
	AssetMetaData_active_tag_get, AssetMetaData_active_tag_set, nullptr, nullptr, rna_AssetMetaData_active_tag_range, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	PROP_SCALE_LINEAR, -32768, 32767, -32768, 32767, 1, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_AssetMetaData_active_tag = reinterpret_cast<PropertyRNA &>(rna_AssetMetaData_active_tag_);

static StringPropertyRNA rna_AssetMetaData_catalog_id_ = {
	{&rna_AssetMetaData_catalog_simple_name, &rna_AssetMetaData_active_tag,
	-1, "catalog_id", 4456449, 0, 0, 0, 0, PropertyPathTemplateType(0), "Catalog UUID",
	"Identifier for the asset\'s catalog, used by Blender to look up the asset\'s catalog path. Must be a UUID according to RFC4122.",
	0, "*",
	nullptr,
	PROP_STRING, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	(UpdateFunc)(void *)rna_AssetMetaData_catalog_id_update, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	AssetMetaData_catalog_id_get, AssetMetaData_catalog_id_length, AssetMetaData_catalog_id_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, eStringPropertySearchFlag(0), nullptr, 0, ""
};
PropertyRNA &rna_AssetMetaData_catalog_id = reinterpret_cast<PropertyRNA &>(rna_AssetMetaData_catalog_id_);

static StringPropertyRNA rna_AssetMetaData_catalog_simple_name_ = {
	{nullptr, &rna_AssetMetaData_catalog_id,
	-1, "catalog_simple_name", 262144, 0, 0, 0, 0, PropertyPathTemplateType(0), "Catalog Simple Name",
	"Simple name of the asset\'s catalog, for debugging and data recovery purposes",
	0, "*",
	nullptr,
	PROP_STRING, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {64, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	AssetMetaData_catalog_simple_name_get, AssetMetaData_catalog_simple_name_length, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, eStringPropertySearchFlag(0), nullptr, 64, ""
};
PropertyRNA &rna_AssetMetaData_catalog_simple_name = reinterpret_cast<PropertyRNA &>(rna_AssetMetaData_catalog_simple_name_);

StructRNA RNA_AssetMetaData = {
	{(ContainerRNA *)&RNA_AssetTags, (ContainerRNA *)&RNA_AssetTag,
	nullptr,
	{&rna_AssetMetaData_rna_properties, &rna_AssetMetaData_catalog_simple_name}},
	"AssetMetaData", nullptr, nullptr, 644, nullptr, "Asset Data",
	"Additional data stored for an asset data-block",
	"*", 63,
	nullptr, &rna_AssetMetaData_rna_properties,
	nullptr,
	nullptr,
	nullptr,
	rna_AssetMetaData_path,
	nullptr,
	nullptr,
	nullptr,
	rna_AssetMetaData_idprops,
	nullptr,
	{nullptr, nullptr}
};

/* Asset Tags */
static CollectionPropertyRNA rna_AssetTags_rna_properties_ = {
	{&rna_AssetTags_rna_type, nullptr,
	-1, "rna_properties", 0, 0, 0, 1, 0, PropertyPathTemplateType(0), "Properties",
	"RNA property collection",
	0, "*",
	nullptr,
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	AssetTags_rna_properties_begin, AssetTags_rna_properties_next, AssetTags_rna_properties_end, AssetTags_rna_properties_get, nullptr, nullptr, AssetTags_rna_properties_lookup_string, nullptr, &RNA_Property
};
PropertyRNA &rna_AssetTags_rna_properties = reinterpret_cast<PropertyRNA &>(rna_AssetTags_rna_properties_);

static PointerPropertyRNA rna_AssetTags_rna_type_ = {
	{nullptr, &rna_AssetTags_rna_properties,
	-1, "rna_type", 8912896, 0, 0, 0, 0, PropertyPathTemplateType(0), "RNA",
	"RNA type definition",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	AssetTags_rna_type_get, nullptr, nullptr, nullptr,&RNA_Struct
};
PropertyRNA &rna_AssetTags_rna_type = reinterpret_cast<PropertyRNA &>(rna_AssetTags_rna_type_);

static StringPropertyRNA rna_AssetTags_new_name_ = {
	{&rna_AssetTags_new_skip_if_exists, nullptr,
	-1, "name", 262145, 0, 1, 0, 0, PropertyPathTemplateType(0), "Name",
	"",
	0, "*",
	nullptr,
	PROP_STRING, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, eStringPropertySearchFlag(0), nullptr, 64, ""
};
PropertyRNA &rna_AssetTags_new_name = reinterpret_cast<PropertyRNA &>(rna_AssetTags_new_name_);

static BoolPropertyRNA rna_AssetTags_new_skip_if_exists_ = {
	{&rna_AssetTags_new_tag, &rna_AssetTags_new_name,
	-1, "skip_if_exists", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Skip if Exists",
	"Do not add a new tag if one of the same type already exists",
	0, "*",
	nullptr,
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_AssetTags_new_skip_if_exists = reinterpret_cast<PropertyRNA &>(rna_AssetTags_new_skip_if_exists_);

static PointerPropertyRNA rna_AssetTags_new_tag_ = {
	{nullptr, &rna_AssetTags_new_skip_if_exists,
	-1, "tag", 8388608, 0, 2, 0, 0, PropertyPathTemplateType(0), "",
	"New tag",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr,&RNA_AssetTag
};
PropertyRNA &rna_AssetTags_new_tag = reinterpret_cast<PropertyRNA &>(rna_AssetTags_new_tag_);

FunctionRNA rna_AssetTags_new_func = {
	{(FunctionRNA *)&rna_AssetTags_remove_func, nullptr,
	nullptr,
	{&rna_AssetTags_new_name, &rna_AssetTags_new_tag}},
	"new", 2064, "Add a new tag to this asset",
	AssetTags_new_call,
	&rna_AssetTags_new_tag
};

static PointerPropertyRNA rna_AssetTags_remove_tag_ = {
	{nullptr, nullptr,
	-1, "tag", 262144, 0, 5, 0, 0, PropertyPathTemplateType(0), "",
	"Removed tag",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr,&RNA_AssetTag
};
PropertyRNA &rna_AssetTags_remove_tag = reinterpret_cast<PropertyRNA &>(rna_AssetTags_remove_tag_);

FunctionRNA rna_AssetTags_remove_func = {
	{nullptr, (FunctionRNA *)&rna_AssetTags_new_func,
	nullptr,
	{&rna_AssetTags_remove_tag, &rna_AssetTags_remove_tag}},
	"remove", 2064, "Remove an existing tag from this asset",
	AssetTags_remove_call,
	nullptr
};

StructRNA RNA_AssetTags = {
	{(ContainerRNA *)&RNA_AssetLibraryReference, (ContainerRNA *)&RNA_AssetMetaData,
	nullptr,
	{&rna_AssetTags_rna_properties, &rna_AssetTags_rna_type}},
	"AssetTags", nullptr, nullptr, 516, nullptr, "Asset Tags",
	"Collection of custom asset tags",
	"*", 63,
	nullptr, &rna_AssetTags_rna_properties,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{(FunctionRNA *)&rna_AssetTags_new_func, (FunctionRNA *)&rna_AssetTags_remove_func}
};

/* Asset Library Reference */
static CollectionPropertyRNA rna_AssetLibraryReference_rna_properties_ = {
	{&rna_AssetLibraryReference_rna_type, nullptr,
	-1, "rna_properties", 0, 0, 0, 1, 0, PropertyPathTemplateType(0), "Properties",
	"RNA property collection",
	0, "*",
	nullptr,
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	AssetLibraryReference_rna_properties_begin, AssetLibraryReference_rna_properties_next, AssetLibraryReference_rna_properties_end, AssetLibraryReference_rna_properties_get, nullptr, nullptr, AssetLibraryReference_rna_properties_lookup_string, nullptr, &RNA_Property
};
PropertyRNA &rna_AssetLibraryReference_rna_properties = reinterpret_cast<PropertyRNA &>(rna_AssetLibraryReference_rna_properties_);

static PointerPropertyRNA rna_AssetLibraryReference_rna_type_ = {
	{nullptr, &rna_AssetLibraryReference_rna_properties,
	-1, "rna_type", 8912896, 0, 0, 0, 0, PropertyPathTemplateType(0), "RNA",
	"RNA type definition",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	AssetLibraryReference_rna_type_get, nullptr, nullptr, nullptr,&RNA_Struct
};
PropertyRNA &rna_AssetLibraryReference_rna_type = reinterpret_cast<PropertyRNA &>(rna_AssetLibraryReference_rna_type_);

StructRNA RNA_AssetLibraryReference = {
	{(ContainerRNA *)&RNA_AssetRepresentation, (ContainerRNA *)&RNA_AssetTags,
	nullptr,
	{&rna_AssetLibraryReference_rna_properties, &rna_AssetLibraryReference_rna_type}},
	"AssetLibraryReference", nullptr, nullptr, 516, nullptr, "Asset Library Reference",
	"Identifier to refer to the asset library",
	"*", 63,
	nullptr, &rna_AssetLibraryReference_rna_properties,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{nullptr, nullptr}
};

/* Asset Representation */
static CollectionPropertyRNA rna_AssetRepresentation_rna_properties_ = {
	{&rna_AssetRepresentation_rna_type, nullptr,
	-1, "rna_properties", 0, 0, 0, 1, 0, PropertyPathTemplateType(0), "Properties",
	"RNA property collection",
	0, "*",
	nullptr,
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	AssetRepresentation_rna_properties_begin, AssetRepresentation_rna_properties_next, AssetRepresentation_rna_properties_end, AssetRepresentation_rna_properties_get, nullptr, nullptr, AssetRepresentation_rna_properties_lookup_string, nullptr, &RNA_Property
};
PropertyRNA &rna_AssetRepresentation_rna_properties = reinterpret_cast<PropertyRNA &>(rna_AssetRepresentation_rna_properties_);

static PointerPropertyRNA rna_AssetRepresentation_rna_type_ = {
	{&rna_AssetRepresentation_name, &rna_AssetRepresentation_rna_properties,
	-1, "rna_type", 8912896, 0, 0, 0, 0, PropertyPathTemplateType(0), "RNA",
	"RNA type definition",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	AssetRepresentation_rna_type_get, nullptr, nullptr, nullptr,&RNA_Struct
};
PropertyRNA &rna_AssetRepresentation_rna_type = reinterpret_cast<PropertyRNA &>(rna_AssetRepresentation_rna_type_);

static StringPropertyRNA rna_AssetRepresentation_name_ = {
	{&rna_AssetRepresentation_metadata, &rna_AssetRepresentation_rna_type,
	-1, "name", 262144, 0, 0, 0, 0, PropertyPathTemplateType(0), "Name",
	"",
	0, "*",
	nullptr,
	PROP_STRING, PropertySubType(int(PROP_FILENAME) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	AssetRepresentation_name_get, AssetRepresentation_name_length, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, eStringPropertySearchFlag(0), nullptr, 0, ""
};
PropertyRNA &rna_AssetRepresentation_name = reinterpret_cast<PropertyRNA &>(rna_AssetRepresentation_name_);

static PointerPropertyRNA rna_AssetRepresentation_metadata_ = {
	{&rna_AssetRepresentation_id_type, &rna_AssetRepresentation_name,
	-1, "metadata", 8388608, 0, 0, 0, 0, PropertyPathTemplateType(0), "Asset Metadata",
	"Additional information about the asset",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	AssetRepresentation_metadata_get, nullptr, nullptr, nullptr,&RNA_AssetMetaData
};
PropertyRNA &rna_AssetRepresentation_metadata = reinterpret_cast<PropertyRNA &>(rna_AssetRepresentation_metadata_);

static EnumPropertyRNA rna_AssetRepresentation_id_type_ = {
	{&rna_AssetRepresentation_local_id, &rna_AssetRepresentation_metadata,
	-1, "id_type", 0, 0, 0, 0, 0, PropertyPathTemplateType(0), "Data-block Type",
	"The type of the data-block, if the asset represents one (\'NONE\' otherwise)",
	0, "ID",
	nullptr,
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	AssetRepresentation_id_type_get, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, rna_enum_id_type_items, 39, 17217
};
PropertyRNA &rna_AssetRepresentation_id_type = reinterpret_cast<PropertyRNA &>(rna_AssetRepresentation_id_type_);

static PointerPropertyRNA rna_AssetRepresentation_local_id_ = {
	{&rna_AssetRepresentation_full_library_path, &rna_AssetRepresentation_id_type,
	-1, "local_id", 8388736, 0, 0, 0, 0, PropertyPathTemplateType(0), "",
	"The local data-block this asset represents; only valid if that is a data-block in this file",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	AssetRepresentation_local_id_get, nullptr, nullptr, nullptr,&RNA_ID
};
PropertyRNA &rna_AssetRepresentation_local_id = reinterpret_cast<PropertyRNA &>(rna_AssetRepresentation_local_id_);

static StringPropertyRNA rna_AssetRepresentation_full_library_path_ = {
	{&rna_AssetRepresentation_full_path, &rna_AssetRepresentation_local_id,
	-1, "full_library_path", 262144, 0, 0, 0, 0, PropertyPathTemplateType(0), "Full Library Path",
	"Absolute path to the .blend file containing this asset",
	0, "*",
	nullptr,
	PROP_STRING, PropertySubType(int(PROP_FILENAME) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	AssetRepresentation_full_library_path_get, AssetRepresentation_full_library_path_length, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, eStringPropertySearchFlag(0), nullptr, 0, ""
};
PropertyRNA &rna_AssetRepresentation_full_library_path = reinterpret_cast<PropertyRNA &>(rna_AssetRepresentation_full_library_path_);

static StringPropertyRNA rna_AssetRepresentation_full_path_ = {
	{nullptr, &rna_AssetRepresentation_full_library_path,
	-1, "full_path", 262144, 0, 0, 0, 0, PropertyPathTemplateType(0), "Full Path",
	"Absolute path to the .blend file containing this asset extended with the path of the asset inside the file",
	0, "*",
	nullptr,
	PROP_STRING, PropertySubType(int(PROP_FILENAME) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	AssetRepresentation_full_path_get, AssetRepresentation_full_path_length, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, eStringPropertySearchFlag(0), nullptr, 0, ""
};
PropertyRNA &rna_AssetRepresentation_full_path = reinterpret_cast<PropertyRNA &>(rna_AssetRepresentation_full_path_);

StructRNA RNA_AssetRepresentation = {
	{(ContainerRNA *)&RNA_AssetWeakReference, (ContainerRNA *)&RNA_AssetLibraryReference,
	nullptr,
	{&rna_AssetRepresentation_rna_properties, &rna_AssetRepresentation_full_path}},
	"AssetRepresentation", nullptr, nullptr, 516, nullptr, "Asset Representation",
	"Information about an entity that makes it possible for the asset system to deal with the entity as asset",
	"*", 63,
	&rna_AssetRepresentation_name, &rna_AssetRepresentation_rna_properties,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{nullptr, nullptr}
};

/* Asset Weak Reference */
static CollectionPropertyRNA rna_AssetWeakReference_rna_properties_ = {
	{&rna_AssetWeakReference_rna_type, nullptr,
	-1, "rna_properties", 0, 0, 0, 1, 0, PropertyPathTemplateType(0), "Properties",
	"RNA property collection",
	0, "*",
	nullptr,
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	AssetWeakReference_rna_properties_begin, AssetWeakReference_rna_properties_next, AssetWeakReference_rna_properties_end, AssetWeakReference_rna_properties_get, nullptr, nullptr, AssetWeakReference_rna_properties_lookup_string, nullptr, &RNA_Property
};
PropertyRNA &rna_AssetWeakReference_rna_properties = reinterpret_cast<PropertyRNA &>(rna_AssetWeakReference_rna_properties_);

static PointerPropertyRNA rna_AssetWeakReference_rna_type_ = {
	{&rna_AssetWeakReference_asset_library_type, &rna_AssetWeakReference_rna_properties,
	-1, "rna_type", 8912896, 0, 0, 0, 0, PropertyPathTemplateType(0), "RNA",
	"RNA type definition",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	AssetWeakReference_rna_type_get, nullptr, nullptr, nullptr,&RNA_Struct
};
PropertyRNA &rna_AssetWeakReference_rna_type = reinterpret_cast<PropertyRNA &>(rna_AssetWeakReference_rna_type_);

static const EnumPropertyItem rna_AssetWeakReference_asset_library_type_items[5] = {
	{2, "ALL", 0, "All Libraries", "Show assets from all of the listed asset libraries"},
	{1, "LOCAL", 0, "Current File", "Show the assets currently available in this Blender session"},
	{3, "ESSENTIALS", 0, "Essentials", "Show the basic building blocks and utilities coming with Blender"},
	{100, "CUSTOM", 0, "Custom", "Show assets from the asset libraries configured in the Preferences"},
	{0, nullptr, 0, nullptr, nullptr}
};

static EnumPropertyRNA rna_AssetWeakReference_asset_library_type_ = {
	{&rna_AssetWeakReference_asset_library_identifier, &rna_AssetWeakReference_rna_type,
	-1, "asset_library_type", 0, 0, 0, 4, 0, PropertyPathTemplateType(0), "asset_library_type",
	"",
	0, "*",
	nullptr,
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(AssetWeakReference, asset_library_type), RawPropertyType(1), nullptr},
	AssetWeakReference_asset_library_type_get, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, rna_AssetWeakReference_asset_library_type_items, 4, 2
};
PropertyRNA &rna_AssetWeakReference_asset_library_type = reinterpret_cast<PropertyRNA &>(rna_AssetWeakReference_asset_library_type_);

static StringPropertyRNA rna_AssetWeakReference_asset_library_identifier_ = {
	{&rna_AssetWeakReference_relative_asset_identifier, &rna_AssetWeakReference_asset_library_type,
	-1, "asset_library_identifier", 262144, 0, 0, 0, 0, PropertyPathTemplateType(0), "asset_library_identifier",
	"",
	0, "*",
	nullptr,
	PROP_STRING, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	AssetWeakReference_asset_library_identifier_get, AssetWeakReference_asset_library_identifier_length, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, eStringPropertySearchFlag(0), nullptr, 0, ""
};
PropertyRNA &rna_AssetWeakReference_asset_library_identifier = reinterpret_cast<PropertyRNA &>(rna_AssetWeakReference_asset_library_identifier_);

static StringPropertyRNA rna_AssetWeakReference_relative_asset_identifier_ = {
	{nullptr, &rna_AssetWeakReference_asset_library_identifier,
	-1, "relative_asset_identifier", 262144, 0, 0, 0, 0, PropertyPathTemplateType(0), "relative_asset_identifier",
	"",
	0, "*",
	nullptr,
	PROP_STRING, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	AssetWeakReference_relative_asset_identifier_get, AssetWeakReference_relative_asset_identifier_length, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, eStringPropertySearchFlag(0), nullptr, 0, ""
};
PropertyRNA &rna_AssetWeakReference_relative_asset_identifier = reinterpret_cast<PropertyRNA &>(rna_AssetWeakReference_relative_asset_identifier_);

StructRNA RNA_AssetWeakReference = {
	{(ContainerRNA *)&RNA_BoidRule, (ContainerRNA *)&RNA_AssetRepresentation,
	nullptr,
	{&rna_AssetWeakReference_rna_properties, &rna_AssetWeakReference_relative_asset_identifier}},
	"AssetWeakReference", nullptr, nullptr, 516, nullptr, "Asset Weak Reference",
	"Weak reference to some asset",
	"*", 63,
	nullptr, &rna_AssetWeakReference_rna_properties,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{nullptr, nullptr}
};

