/* src/bazaar.p/bz-verification-status.h
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#pragma once

#include <glib-object.h>


G_BEGIN_DECLS



#define BZ_TYPE_VERIFICATION_STATUS (bz_verification_status_get_type ())
G_DECLARE_FINAL_TYPE (BzVerificationStatus, bz_verification_status, BZ, VERIFICATION_STATUS, GObject)

BzVerificationStatus *
bz_verification_status_new (void);

gboolean
bz_verification_status_get_verified (BzVerificationStatus *self);

const char *
bz_verification_status_get_method (BzVerificationStatus *self);

const char *
bz_verification_status_get_website (BzVerificationStatus *self);

const char *
bz_verification_status_get_login_name (BzVerificationStatus *self);

const char *
bz_verification_status_get_login_provider (BzVerificationStatus *self);

const char *
bz_verification_status_get_timestamp (BzVerificationStatus *self);

gboolean
bz_verification_status_get_login_is_organization (BzVerificationStatus *self);

void
bz_verification_status_set_verified (BzVerificationStatus *self,
    gboolean verified);

void
bz_verification_status_set_method (BzVerificationStatus *self,
    const char *method);

void
bz_verification_status_set_website (BzVerificationStatus *self,
    const char *website);

void
bz_verification_status_set_login_name (BzVerificationStatus *self,
    const char *login_name);

void
bz_verification_status_set_login_provider (BzVerificationStatus *self,
    const char *login_provider);

void
bz_verification_status_set_timestamp (BzVerificationStatus *self,
    const char *timestamp);

void
bz_verification_status_set_login_is_organization (BzVerificationStatus *self,
    gboolean login_is_organization);

G_END_DECLS

/* End of src/bazaar.p/bz-verification-status.h */
