// This file is generated by kconfig_compiler_kf6 from amarokconfig.kcfg.
// All changes you do to this file will be lost.
#ifndef AMAROKCONFIG_H
#define AMAROKCONFIG_H

#include <amarok_export.h>

#include <kconfigskeleton.h>
#include <QCoreApplication>
#include <QDebug>

#include <qdir.h>

class AMAROK_EXPORT AmarokConfig : public KConfigSkeleton
{
  public:
    class EnumFavorTracks
    {
      public:
      enum type { Off, HigherScores, HigherRatings, LessRecentlyPlayed, COUNT };
    };
    class EnumTrackProgression
    {
      public:
      enum type { Normal, OnlyQueue, RepeatTrack, RepeatAlbum, RepeatPlaylist, RandomTrack, RandomAlbum, COUNT };
    };
    class EnumReplayGainMode
    {
      public:
      enum type { Off, Track, Album, COUNT };
    };
    class EnumOsdAlignment
    {
      public:
      enum type { Left, Middle, Center, Right, COUNT };
    };

    static AmarokConfig *self();
    static void instance(const QString& cfgfilename);
    static void instance(KSharedConfig::Ptr config);
    ~AmarokConfig() override;

    /**
      Set Whether to display a second, left time label.
    */
    static
    void setLeftTimeDisplayEnabled( bool v )
    {
      if (!self()->isLeftTimeDisplayEnabledImmutable())
        self()->mLeftTimeDisplayEnabled = v;
    }

    /**
      Get Whether to display a second, left time label.
    */
    static
    bool leftTimeDisplayEnabled()
    {
      return self()->mLeftTimeDisplayEnabled;
    }

    /**
      Is Whether to display a second, left time label. Immutable
    */
    static
    bool isLeftTimeDisplayEnabledImmutable()
    {
      return self()->isImmutable( QStringLiteral( "LeftTimeDisplayEnabled" ) );
    }

    /**
      Set Whether to display remaining track time in the left time label.
    */
    static
    void setLeftTimeDisplayRemaining( bool v )
    {
      if (!self()->isLeftTimeDisplayRemainingImmutable())
        self()->mLeftTimeDisplayRemaining = v;
    }

    /**
      Get Whether to display remaining track time in the left time label.
    */
    static
    bool leftTimeDisplayRemaining()
    {
      return self()->mLeftTimeDisplayRemaining;
    }

    /**
      Is Whether to display remaining track time in the left time label. Immutable
    */
    static
    bool isLeftTimeDisplayRemainingImmutable()
    {
      return self()->isImmutable( QStringLiteral( "LeftTimeDisplayRemaining" ) );
    }

    /**
      Set Which tracks or albums to favor in Random Mode
    */
    static
    void setFavorTracks( int v )
    {
      if (!self()->isFavorTracksImmutable())
        self()->mFavorTracks = v;
    }

    /**
      Get Which tracks or albums to favor in Random Mode
    */
    static
    int favorTracks()
    {
      return self()->mFavorTracks;
    }

    /**
      Is Which tracks or albums to favor in Random Mode Immutable
    */
    static
    bool isFavorTracksImmutable()
    {
      return self()->isImmutable( QStringLiteral( "FavorTracks" ) );
    }

    /**
      Set How to progress through tracks in the playlist
    */
    static
    void setTrackProgression( int v )
    {
      if (!self()->isTrackProgressionImmutable())
        self()->mTrackProgression = v;
    }

    /**
      Get How to progress through tracks in the playlist
    */
    static
    int trackProgression()
    {
      return self()->mTrackProgression;
    }

    /**
      Is How to progress through tracks in the playlist Immutable
    */
    static
    bool isTrackProgressionImmutable()
    {
      return self()->isImmutable( QStringLiteral( "TrackProgression" ) );
    }

    /**
      Set The status of dynamic mode.
    */
    static
    void setDynamicMode( bool v )
    {
      if (!self()->isDynamicModeImmutable())
        self()->mDynamicMode = v;
    }

    /**
      Get The status of dynamic mode.
    */
    static
    bool dynamicMode()
    {
      return self()->mDynamicMode;
    }

    /**
      Is The status of dynamic mode. Immutable
    */
    static
    bool isDynamicModeImmutable()
    {
      return self()->isImmutable( QStringLiteral( "DynamicMode" ) );
    }

    /**
      Set Duplicate tracks in dynamic mode.
    */
    static
    void setDynamicDuplicates( bool v )
    {
      if (!self()->isDynamicDuplicatesImmutable())
        self()->mDynamicDuplicates = v;
    }

    /**
      Get Duplicate tracks in dynamic mode.
    */
    static
    bool dynamicDuplicates()
    {
      return self()->mDynamicDuplicates;
    }

    /**
      Is Duplicate tracks in dynamic mode. Immutable
    */
    static
    bool isDynamicDuplicatesImmutable()
    {
      return self()->isImmutable( QStringLiteral( "DynamicDuplicates" ) );
    }

    /**
      Set Previous tracks count.
    */
    static
    void setPreviousTracks( int v )
    {
      if (!self()->isPreviousTracksImmutable())
        self()->mPreviousTracks = v;
    }

    /**
      Get Previous tracks count.
    */
    static
    int previousTracks()
    {
      return self()->mPreviousTracks;
    }

    /**
      Is Previous tracks count. Immutable
    */
    static
    bool isPreviousTracksImmutable()
    {
      return self()->isImmutable( QStringLiteral( "PreviousTracks" ) );
    }

    /**
      Set Upcoming tracks count.
    */
    static
    void setUpcomingTracks( int v )
    {
      if (!self()->isUpcomingTracksImmutable())
        self()->mUpcomingTracks = v;
    }

    /**
      Get Upcoming tracks count.
    */
    static
    int upcomingTracks()
    {
      return self()->mUpcomingTracks;
    }

    /**
      Is Upcoming tracks count. Immutable
    */
    static
    bool isUpcomingTracksImmutable()
    {
      return self()->isImmutable( QStringLiteral( "UpcomingTracks" ) );
    }

    /**
      Set Whether to show icon in system tray
    */
    static
    void setShowTrayIcon( bool v )
    {
      if (!self()->isShowTrayIconImmutable())
        self()->mShowTrayIcon = v;
    }

    /**
      Get Whether to show icon in system tray
    */
    static
    bool showTrayIcon()
    {
      return self()->mShowTrayIcon;
    }

    /**
      Is Whether to show icon in system tray Immutable
    */
    static
    bool isShowTrayIconImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ShowTrayIcon" ) );
    }

    /**
      Set Whether to hide the context view.
    */
    static
    void setHideContextView( bool v )
    {
      if (!self()->isHideContextViewImmutable())
        self()->mHideContextView = v;
    }

    /**
      Get Whether to hide the context view.
    */
    static
    bool hideContextView()
    {
      return self()->mHideContextView;
    }

    /**
      Is Whether to hide the context view. Immutable
    */
    static
    bool isHideContextViewImmutable()
    {
      return self()->isImmutable( QStringLiteral( "HideContextView" ) );
    }

    /**
      Set Number of undo levels in playlist
    */
    static
    void setUndoLevels( int v )
    {
      if (!self()->isUndoLevelsImmutable())
        self()->mUndoLevels = v;
    }

    /**
      Get Number of undo levels in playlist
    */
    static
    int undoLevels()
    {
      return self()->mUndoLevels;
    }

    /**
      Is Number of undo levels in playlist Immutable
    */
    static
    bool isUndoLevelsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "UndoLevels" ) );
    }

    /**
      Set Whether playlists store relative path
    */
    static
    void setRelativePlaylist( bool v )
    {
      if (!self()->isRelativePlaylistImmutable())
        self()->mRelativePlaylist = v;
    }

    /**
      Get Whether playlists store relative path
    */
    static
    bool relativePlaylist()
    {
      return self()->mRelativePlaylist;
    }

    /**
      Is Whether playlists store relative path Immutable
    */
    static
    bool isRelativePlaylistImmutable()
    {
      return self()->isImmutable( QStringLiteral( "RelativePlaylist" ) );
    }

    /**
      Set Filename of the external web browser to be invoked by Amarok.
    */
    static
    void setExternalBrowser( const QString & v )
    {
      if (!self()->isExternalBrowserImmutable())
        self()->mExternalBrowser = v;
    }

    /**
      Get Filename of the external web browser to be invoked by Amarok.
    */
    static
    QString externalBrowser()
    {
      return self()->mExternalBrowser;
    }

    /**
      Is Filename of the external web browser to be invoked by Amarok. Immutable
    */
    static
    bool isExternalBrowserImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ExternalBrowser" ) );
    }

    /**
      Set Whether to automatically attempt to fetch cover art as needed
    */
    static
    void setAutoGetCoverArt( bool v )
    {
      if (!self()->isAutoGetCoverArtImmutable())
        self()->mAutoGetCoverArt = v;
    }

    /**
      Get Whether to automatically attempt to fetch cover art as needed
    */
    static
    bool autoGetCoverArt()
    {
      return self()->mAutoGetCoverArt;
    }

    /**
      Is Whether to automatically attempt to fetch cover art as needed Immutable
    */
    static
    bool isAutoGetCoverArtImmutable()
    {
      return self()->isImmutable( QStringLiteral( "AutoGetCoverArt" ) );
    }

    /**
      Set Whether to show background images in the browser pane
    */
    static
    void setShowBrowserBackgroundImage( bool v )
    {
      if (!self()->isShowBrowserBackgroundImageImmutable())
        self()->mShowBrowserBackgroundImage = v;
    }

    /**
      Get Whether to show background images in the browser pane
    */
    static
    bool showBrowserBackgroundImage()
    {
      return self()->mShowBrowserBackgroundImage;
    }

    /**
      Is Whether to show background images in the browser pane Immutable
    */
    static
    bool isShowBrowserBackgroundImageImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ShowBrowserBackgroundImage" ) );
    }

    /**
      Set Automatically scroll the playlist to make the currently playing track visible
    */
    static
    void setAutoScrollPlaylist( bool v )
    {
      if (!self()->isAutoScrollPlaylistImmutable())
        self()->mAutoScrollPlaylist = v;
    }

    /**
      Get Automatically scroll the playlist to make the currently playing track visible
    */
    static
    bool autoScrollPlaylist()
    {
      return self()->mAutoScrollPlaylist;
    }

    /**
      Is Automatically scroll the playlist to make the currently playing track visible Immutable
    */
    static
    bool isAutoScrollPlaylistImmutable()
    {
      return self()->isImmutable( QStringLiteral( "AutoScrollPlaylist" ) );
    }

    /**
      Set Show Album art in the Collection Browser
    */
    static
    void setShowAlbumArt( bool v )
    {
      if (!self()->isShowAlbumArtImmutable())
        self()->mShowAlbumArt = v;
    }

    /**
      Get Show Album art in the Collection Browser
    */
    static
    bool showAlbumArt()
    {
      return self()->mShowAlbumArt;
    }

    /**
      Is Show Album art in the Collection Browser Immutable
    */
    static
    bool isShowAlbumArtImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ShowAlbumArt" ) );
    }

    /**
      Set Show the Context View
    */
    static
    void setLockLayout( bool v )
    {
      if (!self()->isLockLayoutImmutable())
        self()->mLockLayout = v;
    }

    /**
      Get Show the Context View
    */
    static
    bool lockLayout()
    {
      return self()->mLockLayout;
    }

    /**
      Is Show the Context View Immutable
    */
    static
    bool isLockLayoutImmutable()
    {
      return self()->isImmutable( QStringLiteral( "LockLayout" ) );
    }

    /**
      Set Play the first run jingle
    */
    static
    void setPlayFirstRunJingle( bool v )
    {
      if (!self()->isPlayFirstRunJingleImmutable())
        self()->mPlayFirstRunJingle = v;
    }

    /**
      Get Play the first run jingle
    */
    static
    bool playFirstRunJingle()
    {
      return self()->mPlayFirstRunJingle;
    }

    /**
      Is Play the first run jingle Immutable
    */
    static
    bool isPlayFirstRunJingleImmutable()
    {
      return self()->isImmutable( QStringLiteral( "PlayFirstRunJingle" ) );
    }

    /**
      Set Enable context applets collapse animations
    */
    static
    void setAnimateAppletCollapse( bool v )
    {
      if (!self()->isAnimateAppletCollapseImmutable())
        self()->mAnimateAppletCollapse = v;
    }

    /**
      Get Enable context applets collapse animations
    */
    static
    bool animateAppletCollapse()
    {
      return self()->mAnimateAppletCollapse;
    }

    /**
      Is Enable context applets collapse animations Immutable
    */
    static
    bool isAnimateAppletCollapseImmutable()
    {
      return self()->isImmutable( QStringLiteral( "AnimateAppletCollapse" ) );
    }

    /**
      Set Show track's artist in Collection Browser if different from album artist
    */
    static
    void setShowArtistForVarious( bool v )
    {
      if (!self()->isShowArtistForVariousImmutable())
        self()->mShowArtistForVarious = v;
    }

    /**
      Get Show track's artist in Collection Browser if different from album artist
    */
    static
    bool showArtistForVarious()
    {
      return self()->mShowArtistForVarious;
    }

    /**
      Is Show track's artist in Collection Browser if different from album artist Immutable
    */
    static
    bool isShowArtistForVariousImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ShowArtistForVarious" ) );
    }

    /**
      Set Whether organize files will overwrite existing files.
    */
    static
    void setOverwriteFiles( bool v )
    {
      if (!self()->isOverwriteFilesImmutable())
        self()->mOverwriteFiles = v;
    }

    /**
      Get Whether organize files will overwrite existing files.
    */
    static
    bool overwriteFiles()
    {
      return self()->mOverwriteFiles;
    }

    /**
      Is Whether organize files will overwrite existing files. Immutable
    */
    static
    bool isOverwriteFilesImmutable()
    {
      return self()->isImmutable( QStringLiteral( "OverwriteFiles" ) );
    }

    /**
      Set Whether organize files will move The in artist names to the end.
    */
    static
    void setIgnoreThe( bool v )
    {
      if (!self()->isIgnoreTheImmutable())
        self()->mIgnoreThe = v;
    }

    /**
      Get Whether organize files will move The in artist names to the end.
    */
    static
    bool ignoreThe()
    {
      return self()->mIgnoreThe;
    }

    /**
      Is Whether organize files will move The in artist names to the end. Immutable
    */
    static
    bool isIgnoreTheImmutable()
    {
      return self()->isImmutable( QStringLiteral( "IgnoreThe" ) );
    }

    /**
      Set Whether organize files will replace spaces in filenames with underscores.
    */
    static
    void setReplaceSpace( bool v )
    {
      if (!self()->isReplaceSpaceImmutable())
        self()->mReplaceSpace = v;
    }

    /**
      Get Whether organize files will replace spaces in filenames with underscores.
    */
    static
    bool replaceSpace()
    {
      return self()->mReplaceSpace;
    }

    /**
      Is Whether organize files will replace spaces in filenames with underscores. Immutable
    */
    static
    bool isReplaceSpaceImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ReplaceSpace" ) );
    }

    /**
      Set Whether organize files will use cover art as folder icons.
    */
    static
    void setCoverIcons( bool v )
    {
      if (!self()->isCoverIconsImmutable())
        self()->mCoverIcons = v;
    }

    /**
      Get Whether organize files will use cover art as folder icons.
    */
    static
    bool coverIcons()
    {
      return self()->mCoverIcons;
    }

    /**
      Is Whether organize files will use cover art as folder icons. Immutable
    */
    static
    bool isCoverIconsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "CoverIcons" ) );
    }

    /**
      Set Collection folder path destination for Organize files.
    */
    static
    void setOrganizeDirectory( const QString & v )
    {
      if (!self()->isOrganizeDirectoryImmutable())
        self()->mOrganizeDirectory = v;
    }

    /**
      Get Collection folder path destination for Organize files.
    */
    static
    QString organizeDirectory()
    {
      return self()->mOrganizeDirectory;
    }

    /**
      Is Collection folder path destination for Organize files. Immutable
    */
    static
    bool isOrganizeDirectoryImmutable()
    {
      return self()->isImmutable( QStringLiteral( "OrganizeDirectory" ) );
    }

    /**
      Set Whether organize files will rename files in a manner compatible with vfat filesystems.
    */
    static
    void setVfatCompatible( bool v )
    {
      if (!self()->isVfatCompatibleImmutable())
        self()->mVfatCompatible = v;
    }

    /**
      Get Whether organize files will rename files in a manner compatible with vfat filesystems.
    */
    static
    bool vfatCompatible()
    {
      return self()->mVfatCompatible;
    }

    /**
      Is Whether organize files will rename files in a manner compatible with vfat filesystems. Immutable
    */
    static
    bool isVfatCompatibleImmutable()
    {
      return self()->isImmutable( QStringLiteral( "VfatCompatible" ) );
    }

    /**
      Set Whether organize files will rename files such that they only contain 7-bit ASCII characters.
    */
    static
    void setAsciiOnly( bool v )
    {
      if (!self()->isAsciiOnlyImmutable())
        self()->mAsciiOnly = v;
    }

    /**
      Get Whether organize files will rename files such that they only contain 7-bit ASCII characters.
    */
    static
    bool asciiOnly()
    {
      return self()->mAsciiOnly;
    }

    /**
      Is Whether organize files will rename files such that they only contain 7-bit ASCII characters. Immutable
    */
    static
    bool isAsciiOnlyImmutable()
    {
      return self()->isImmutable( QStringLiteral( "AsciiOnly" ) );
    }

    /**
      Set Whether organize files will use a custom file naming scheme.
    */
    static
    void setUseCustomScheme( bool v )
    {
      if (!self()->isUseCustomSchemeImmutable())
        self()->mUseCustomScheme = v;
    }

    /**
      Get Whether organize files will use a custom file naming scheme.
    */
    static
    bool useCustomScheme()
    {
      return self()->mUseCustomScheme;
    }

    /**
      Is Whether organize files will use a custom file naming scheme. Immutable
    */
    static
    bool isUseCustomSchemeImmutable()
    {
      return self()->isImmutable( QStringLiteral( "UseCustomScheme" ) );
    }

    /**
      Set Format string for Organize files, if a custom naming scheme is used.
    */
    static
    void setCustomScheme( const QString & v )
    {
      if (!self()->isCustomSchemeImmutable())
        self()->mCustomScheme = v;
    }

    /**
      Get Format string for Organize files, if a custom naming scheme is used.
    */
    static
    QString customScheme()
    {
      return self()->mCustomScheme;
    }

    /**
      Is Format string for Organize files, if a custom naming scheme is used. Immutable
    */
    static
    bool isCustomSchemeImmutable()
    {
      return self()->isImmutable( QStringLiteral( "CustomScheme" ) );
    }

    /**
      Set Regular expression that is to be replaced.
    */
    static
    void setReplacementRegexp( const QString & v )
    {
      if (!self()->isReplacementRegexpImmutable())
        self()->mReplacementRegexp = v;
    }

    /**
      Get Regular expression that is to be replaced.
    */
    static
    QString replacementRegexp()
    {
      return self()->mReplacementRegexp;
    }

    /**
      Is Regular expression that is to be replaced. Immutable
    */
    static
    bool isReplacementRegexpImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ReplacementRegexp" ) );
    }

    /**
      Set Replacing string.
    */
    static
    void setReplacementString( const QString & v )
    {
      if (!self()->isReplacementStringImmutable())
        self()->mReplacementString = v;
    }

    /**
      Get Replacing string.
    */
    static
    QString replacementString()
    {
      return self()->mReplacementString;
    }

    /**
      Is Replacing string. Immutable
    */
    static
    bool isReplacementStringImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ReplacementString" ) );
    }

    /**
      Set Basic or Advanced Mode
    */
    static
    void setMode( const QString & v )
    {
      if (!self()->isModeImmutable())
        self()->mMode = v;
    }

    /**
      Get Basic or Advanced Mode
    */
    static
    QString mode()
    {
      return self()->mMode;
    }

    /**
      Is Basic or Advanced Mode Immutable
    */
    static
    bool isModeImmutable()
    {
      return self()->isImmutable( QStringLiteral( "Mode" ) );
    }

    /**
      Set Format Presets
    */
    static
    void setFormatPresets( const QStringList & v )
    {
      if (!self()->isFormatPresetsImmutable())
        self()->mFormatPresets = v;
    }

    /**
      Get Format Presets
    */
    static
    QStringList formatPresets()
    {
      return self()->mFormatPresets;
    }

    /**
      Is Format Presets Immutable
    */
    static
    bool isFormatPresetsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "FormatPresets" ) );
    }

    /**
      Set Master volume
    */
    static
    void setMasterVolume( int v )
    {
      if (v < 0)
      {
        qDebug() << "setMasterVolume: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 100)
      {
        qDebug() << "setMasterVolume: value " << v << " is greater than the maximum value of 100";
        v = 100;
      }

      if (!self()->isMasterVolumeImmutable())
        self()->mMasterVolume = v;
    }

    /**
      Get Master volume
    */
    static
    int masterVolume()
    {
      return self()->mMasterVolume;
    }

    /**
      Is Master volume Immutable
    */
    static
    bool isMasterVolumeImmutable()
    {
      return self()->isImmutable( QStringLiteral( "MasterVolume" ) );
    }

    /**
      Set Mute state
    */
    static
    void setMuteState( bool v )
    {
      if (!self()->isMuteStateImmutable())
        self()->mMuteState = v;
    }

    /**
      Get Mute state
    */
    static
    bool muteState()
    {
      return self()->mMuteState;
    }

    /**
      Is Mute state Immutable
    */
    static
    bool isMuteStateImmutable()
    {
      return self()->isImmutable( QStringLiteral( "MuteState" ) );
    }

    /**
      Set Whether to fade out tracks when pressing stop.
    */
    static
    void setFadeoutOnStop( bool v )
    {
      if (!self()->isFadeoutOnStopImmutable())
        self()->mFadeoutOnStop = v;
    }

    /**
      Get Whether to fade out tracks when pressing stop.
    */
    static
    bool fadeoutOnStop()
    {
      return self()->mFadeoutOnStop;
    }

    /**
      Is Whether to fade out tracks when pressing stop. Immutable
    */
    static
    bool isFadeoutOnStopImmutable()
    {
      return self()->isImmutable( QStringLiteral( "FadeoutOnStop" ) );
    }

    /**
      Set Whether to fade out tracks when pressing pause.
    */
    static
    void setFadeoutOnPause( bool v )
    {
      if (!self()->isFadeoutOnPauseImmutable())
        self()->mFadeoutOnPause = v;
    }

    /**
      Get Whether to fade out tracks when pressing pause.
    */
    static
    bool fadeoutOnPause()
    {
      return self()->mFadeoutOnPause;
    }

    /**
      Is Whether to fade out tracks when pressing pause. Immutable
    */
    static
    bool isFadeoutOnPauseImmutable()
    {
      return self()->isImmutable( QStringLiteral( "FadeoutOnPause" ) );
    }

    /**
      Set Length of fadeout, in milliseconds
    */
    static
    void setFadeoutLength( int v )
    {
      if (v < 400)
      {
        qDebug() << "setFadeoutLength: value " << v << " is less than the minimum value of 400";
        v = 400;
      }
      if (!self()->isFadeoutLengthImmutable())
        self()->mFadeoutLength = v;
    }

    /**
      Get Length of fadeout, in milliseconds
    */
    static
    int fadeoutLength()
    {
      return self()->mFadeoutLength;
    }

    /**
      Is Length of fadeout, in milliseconds Immutable
    */
    static
    bool isFadeoutLengthImmutable()
    {
      return self()->isImmutable( QStringLiteral( "FadeoutLength" ) );
    }

    /**
      Set Equalizer mode - 0 = off, 1 to n = preset no
    */
    static
    void setEqualizerMode( int v )
    {
      if (!self()->isEqualizerModeImmutable())
        self()->mEqualizerMode = v;
    }

    /**
      Get Equalizer mode - 0 = off, 1 to n = preset no
    */
    static
    int equalizerMode()
    {
      return self()->mEqualizerMode;
    }

    /**
      Is Equalizer mode - 0 = off, 1 to n = preset no Immutable
    */
    static
    bool isEqualizerModeImmutable()
    {
      return self()->isImmutable( QStringLiteral( "EqualizerMode" ) );
    }

    /**
      Set 11 Equalizer gains including pre-amp, range -100..100, 0 is normal.
    */
    static
    void setEqualizerGains( const QList<int> & v )
    {
      if (!self()->isEqualizerGainsImmutable())
        self()->mEqualizerGains = v;
    }

    /**
      Get 11 Equalizer gains including pre-amp, range -100..100, 0 is normal.
    */
    static
    QList<int> equalizerGains()
    {
      return self()->mEqualizerGains;
    }

    /**
      Is 11 Equalizer gains including pre-amp, range -100..100, 0 is normal. Immutable
    */
    static
    bool isEqualizerGainsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "EqualizerGains" ) );
    }

    /**
      Set List with user equalizer preset names
    */
    static
    void setEqualizerPresetsNames( const QStringList & v )
    {
      if (!self()->isEqualizerPresetsNamesImmutable())
        self()->mEqualizerPresetsNames = v;
    }

    /**
      Get List with user equalizer preset names
    */
    static
    QStringList equalizerPresetsNames()
    {
      return self()->mEqualizerPresetsNames;
    }

    /**
      Is List with user equalizer preset names Immutable
    */
    static
    bool isEqualizerPresetsNamesImmutable()
    {
      return self()->isImmutable( QStringLiteral( "EqualizerPresetsNames" ) );
    }

    /**
      Set List with user presets values
    */
    static
    void setEqualizerPresestValues( const QList<int> & v )
    {
      if (!self()->isEqualizerPresestValuesImmutable())
        self()->mEqualizerPresestValues = v;
    }

    /**
      Get List with user presets values
    */
    static
    QList<int> equalizerPresestValues()
    {
      return self()->mEqualizerPresestValues;
    }

    /**
      Is List with user presets values Immutable
    */
    static
    bool isEqualizerPresestValuesImmutable()
    {
      return self()->isImmutable( QStringLiteral( "EqualizerPresestValues" ) );
    }

    /**
      Set The mode for adjusting playback volume.
    */
    static
    void setReplayGainMode( int v )
    {
      if (!self()->isReplayGainModeImmutable())
        self()->mReplayGainMode = v;
    }

    /**
      Get The mode for adjusting playback volume.
    */
    static
    int replayGainMode()
    {
      return self()->mReplayGainMode;
    }

    /**
      Is The mode for adjusting playback volume. Immutable
    */
    static
    bool isReplayGainModeImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ReplayGainMode" ) );
    }

    /**
      Set The length of a short seek, in seconds.
    */
    static
    void setSeekShort( int v )
    {
      if (v < 1)
      {
        qDebug() << "setSeekShort: value " << v << " is less than the minimum value of 1";
        v = 1;
      }
      if (!self()->isSeekShortImmutable())
        self()->mSeekShort = v;
    }

    /**
      Get The length of a short seek, in seconds.
    */
    static
    int seekShort()
    {
      return self()->mSeekShort;
    }

    /**
      Is The length of a short seek, in seconds. Immutable
    */
    static
    bool isSeekShortImmutable()
    {
      return self()->isImmutable( QStringLiteral( "SeekShort" ) );
    }

    /**
      Set The length of a medium seek, in seconds.
    */
    static
    void setSeekMedium( int v )
    {
      if (v < 1)
      {
        qDebug() << "setSeekMedium: value " << v << " is less than the minimum value of 1";
        v = 1;
      }
      if (!self()->isSeekMediumImmutable())
        self()->mSeekMedium = v;
    }

    /**
      Get The length of a medium seek, in seconds.
    */
    static
    int seekMedium()
    {
      return self()->mSeekMedium;
    }

    /**
      Is The length of a medium seek, in seconds. Immutable
    */
    static
    bool isSeekMediumImmutable()
    {
      return self()->isImmutable( QStringLiteral( "SeekMedium" ) );
    }

    /**
      Set The length of a long seek, in seconds.
    */
    static
    void setSeekLong( int v )
    {
      if (v < 1)
      {
        qDebug() << "setSeekLong: value " << v << " is less than the minimum value of 1";
        v = 1;
      }
      if (!self()->isSeekLongImmutable())
        self()->mSeekLong = v;
    }

    /**
      Get The length of a long seek, in seconds.
    */
    static
    int seekLong()
    {
      return self()->mSeekLong;
    }

    /**
      Is The length of a long seek, in seconds. Immutable
    */
    static
    bool isSeekLongImmutable()
    {
      return self()->isImmutable( QStringLiteral( "SeekLong" ) );
    }

    /**
      Set Whether Amarok should pause the currently playing track on suspend.
    */
    static
    void setPauseOnSuspend( bool v )
    {
      if (!self()->isPauseOnSuspendImmutable())
        self()->mPauseOnSuspend = v;
    }

    /**
      Get Whether Amarok should pause the currently playing track on suspend.
    */
    static
    bool pauseOnSuspend()
    {
      return self()->mPauseOnSuspend;
    }

    /**
      Is Whether Amarok should pause the currently playing track on suspend. Immutable
    */
    static
    bool isPauseOnSuspendImmutable()
    {
      return self()->isImmutable( QStringLiteral( "PauseOnSuspend" ) );
    }

    /**
      Set Whether Amarok should prevent the system from sleeping if it is playing a track.
    */
    static
    void setInhibitSuspend( bool v )
    {
      if (!self()->isInhibitSuspendImmutable())
        self()->mInhibitSuspend = v;
    }

    /**
      Get Whether Amarok should prevent the system from sleeping if it is playing a track.
    */
    static
    bool inhibitSuspend()
    {
      return self()->mInhibitSuspend;
    }

    /**
      Is Whether Amarok should prevent the system from sleeping if it is playing a track. Immutable
    */
    static
    bool isInhibitSuspendImmutable()
    {
      return self()->isImmutable( QStringLiteral( "InhibitSuspend" ) );
    }

    /**
      Set Whether Amarok should start playing if a track is added to playlist (and nothing else is playing).
    */
    static
    void setStartPlayingOnAdd( bool v )
    {
      if (!self()->isStartPlayingOnAddImmutable())
        self()->mStartPlayingOnAdd = v;
    }

    /**
      Get Whether Amarok should start playing if a track is added to playlist (and nothing else is playing).
    */
    static
    bool startPlayingOnAdd()
    {
      return self()->mStartPlayingOnAdd;
    }

    /**
      Is Whether Amarok should start playing if a track is added to playlist (and nothing else is playing). Immutable
    */
    static
    bool isStartPlayingOnAddImmutable()
    {
      return self()->isImmutable( QStringLiteral( "StartPlayingOnAdd" ) );
    }

    /**
      Set Amazon locale for cover retrieval
    */
    static
    void setAmazonLocale( const QString & v )
    {
      if (!self()->isAmazonLocaleImmutable())
        self()->mAmazonLocale = v;
    }

    /**
      Get Amazon locale for cover retrieval
    */
    static
    QString amazonLocale()
    {
      return self()->mAmazonLocale;
    }

    /**
      Is Amazon locale for cover retrieval Immutable
    */
    static
    bool isAmazonLocaleImmutable()
    {
      return self()->isImmutable( QStringLiteral( "AmazonLocale" ) );
    }

    /**
      Set Wikipedia locale for information retrieval
    */
    static
    void setWikipediaLocale( const QString & v )
    {
      if (!self()->isWikipediaLocaleImmutable())
        self()->mWikipediaLocale = v;
    }

    /**
      Get Wikipedia locale for information retrieval
    */
    static
    QString wikipediaLocale()
    {
      return self()->mWikipediaLocale;
    }

    /**
      Is Wikipedia locale for information retrieval Immutable
    */
    static
    bool isWikipediaLocaleImmutable()
    {
      return self()->isImmutable( QStringLiteral( "WikipediaLocale" ) );
    }

    /**
      Set Use KNotify support
    */
    static
    void setKNotifyEnabled( bool v )
    {
      if (!self()->isKNotifyEnabledImmutable())
        self()->mKNotifyEnabled = v;
    }

    /**
      Get Use KNotify support
    */
    static
    bool kNotifyEnabled()
    {
      return self()->mKNotifyEnabled;
    }

    /**
      Is Use KNotify support Immutable
    */
    static
    bool isKNotifyEnabledImmutable()
    {
      return self()->isImmutable( QStringLiteral( "KNotifyEnabled" ) );
    }

    /**
      Set Use On-Screen Display
    */
    static
    void setOsdEnabled( bool v )
    {
      if (!self()->isOsdEnabledImmutable())
        self()->mOsdEnabled = v;
    }

    /**
      Get Use On-Screen Display
    */
    static
    bool osdEnabled()
    {
      return self()->mOsdEnabled;
    }

    /**
      Is Use On-Screen Display Immutable
    */
    static
    bool isOsdEnabledImmutable()
    {
      return self()->isImmutable( QStringLiteral( "OsdEnabled" ) );
    }

    /**
      Set Use Growl for notifications
    */
    static
    void setGrowlEnabled( bool v )
    {
      if (!self()->isGrowlEnabledImmutable())
        self()->mGrowlEnabled = v;
    }

    /**
      Get Use Growl for notifications
    */
    static
    bool growlEnabled()
    {
      return self()->mGrowlEnabled;
    }

    /**
      Is Use Growl for notifications Immutable
    */
    static
    bool isGrowlEnabledImmutable()
    {
      return self()->isImmutable( QStringLiteral( "GrowlEnabled" ) );
    }

    /**
      Set Translucency Toggle
    */
    static
    void setOsdUseTranslucency( bool v )
    {
      if (!self()->isOsdUseTranslucencyImmutable())
        self()->mOsdUseTranslucency = v;
    }

    /**
      Get Translucency Toggle
    */
    static
    bool osdUseTranslucency()
    {
      return self()->mOsdUseTranslucency;
    }

    /**
      Is Translucency Toggle Immutable
    */
    static
    bool isOsdUseTranslucencyImmutable()
    {
      return self()->isImmutable( QStringLiteral( "OsdUseTranslucency" ) );
    }

    /**
      Set Whether to use custom colors for the OSD
    */
    static
    void setOsdUseCustomColors( bool v )
    {
      if (!self()->isOsdUseCustomColorsImmutable())
        self()->mOsdUseCustomColors = v;
    }

    /**
      Get Whether to use custom colors for the OSD
    */
    static
    bool osdUseCustomColors()
    {
      return self()->mOsdUseCustomColors;
    }

    /**
      Is Whether to use custom colors for the OSD Immutable
    */
    static
    bool isOsdUseCustomColorsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "OsdUseCustomColors" ) );
    }

    /**
      Set Font color for OSD
    */
    static
    void setOsdTextColor( const QColor & v )
    {
      if (!self()->isOsdTextColorImmutable())
        self()->mOsdTextColor = v;
    }

    /**
      Get Font color for OSD
    */
    static
    QColor osdTextColor()
    {
      return self()->mOsdTextColor;
    }

    /**
      Is Font color for OSD Immutable
    */
    static
    bool isOsdTextColorImmutable()
    {
      return self()->isImmutable( QStringLiteral( "OsdTextColor" ) );
    }

    /**
      Set Font scaling for OSD
    */
    static
    void setOsdFontScaling( int v )
    {
      if (v < 0)
      {
        qDebug() << "setOsdFontScaling: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 1000)
      {
        qDebug() << "setOsdFontScaling: value " << v << " is greater than the maximum value of 1000";
        v = 1000;
      }

      if (!self()->isOsdFontScalingImmutable())
        self()->mOsdFontScaling = v;
    }

    /**
      Get Font scaling for OSD
    */
    static
    int osdFontScaling()
    {
      return self()->mOsdFontScaling;
    }

    /**
      Is Font scaling for OSD Immutable
    */
    static
    bool isOsdFontScalingImmutable()
    {
      return self()->isImmutable( QStringLiteral( "OsdFontScaling" ) );
    }

    /**
      Set How many milliseconds the text should be displayed for
    */
    static
    void setOsdDuration( int v )
    {
      if (v < 0)
      {
        qDebug() << "setOsdDuration: value " << v << " is less than the minimum value of 0";
        v = 0;
      }
      if (!self()->isOsdDurationImmutable())
        self()->mOsdDuration = v;
    }

    /**
      Get How many milliseconds the text should be displayed for
    */
    static
    int osdDuration()
    {
      return self()->mOsdDuration;
    }

    /**
      Is How many milliseconds the text should be displayed for Immutable
    */
    static
    bool isOsdDurationImmutable()
    {
      return self()->isImmutable( QStringLiteral( "OsdDuration" ) );
    }

    /**
      Set Y position offset
    */
    static
    void setOsdYOffset( int v )
    {
      if (v < 0)
      {
        qDebug() << "setOsdYOffset: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 10000)
      {
        qDebug() << "setOsdYOffset: value " << v << " is greater than the maximum value of 10000";
        v = 10000;
      }

      if (!self()->isOsdYOffsetImmutable())
        self()->mOsdYOffset = v;
    }

    /**
      Get Y position offset
    */
    static
    int osdYOffset()
    {
      return self()->mOsdYOffset;
    }

    /**
      Is Y position offset Immutable
    */
    static
    bool isOsdYOffsetImmutable()
    {
      return self()->isImmutable( QStringLiteral( "OsdYOffset" ) );
    }

    /**
      Set OSD screen
    */
    static
    void setOsdScreen( int v )
    {
      if (!self()->isOsdScreenImmutable())
        self()->mOsdScreen = v;
    }

    /**
      Get OSD screen
    */
    static
    int osdScreen()
    {
      return self()->mOsdScreen;
    }

    /**
      Is OSD screen Immutable
    */
    static
    bool isOsdScreenImmutable()
    {
      return self()->isImmutable( QStringLiteral( "OsdScreen" ) );
    }

    /**
      Set Align OSD to
    */
    static
    void setOsdAlignment( int v )
    {
      if (!self()->isOsdAlignmentImmutable())
        self()->mOsdAlignment = v;
    }

    /**
      Get Align OSD to
    */
    static
    int osdAlignment()
    {
      return self()->mOsdAlignment;
    }

    /**
      Is Align OSD to Immutable
    */
    static
    bool isOsdAlignmentImmutable()
    {
      return self()->isImmutable( QStringLiteral( "OsdAlignment" ) );
    }

    /**
      Set Don't show when a fullscreen application is active
    */
    static
    void setOsdHideOnFullscreen( bool v )
    {
      if (!self()->isOsdHideOnFullscreenImmutable())
        self()->mOsdHideOnFullscreen = v;
    }

    /**
      Get Don't show when a fullscreen application is active
    */
    static
    bool osdHideOnFullscreen()
    {
      return self()->mOsdHideOnFullscreen;
    }

    /**
      Is Don't show when a fullscreen application is active Immutable
    */
    static
    bool isOsdHideOnFullscreenImmutable()
    {
      return self()->isImmutable( QStringLiteral( "OsdHideOnFullscreen" ) );
    }

    /**
      Set Resume playback of last played track on startup
    */
    static
    void setResumePlayback( bool v )
    {
      if (!self()->isResumePlaybackImmutable())
        self()->mResumePlayback = v;
    }

    /**
      Get Resume playback of last played track on startup
    */
    static
    bool resumePlayback()
    {
      return self()->mResumePlayback;
    }

    /**
      Is Resume playback of last played track on startup Immutable
    */
    static
    bool isResumePlaybackImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ResumePlayback" ) );
    }

    /**
      Set Track URL to resume upon startup
    */
    static
    void setResumeTrack( const QString & v )
    {
      if (!self()->isResumeTrackImmutable())
        self()->mResumeTrack = v;
    }

    /**
      Get Track URL to resume upon startup
    */
    static
    QString resumeTrack()
    {
      return self()->mResumeTrack;
    }

    /**
      Is Track URL to resume upon startup Immutable
    */
    static
    bool isResumeTrackImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ResumeTrack" ) );
    }

    /**
      Set Internal: Resume playback in paused state
    */
    static
    void setResumePaused( bool v )
    {
      if (!self()->isResumePausedImmutable())
        self()->mResumePaused = v;
    }

    /**
      Get Internal: Resume playback in paused state
    */
    static
    bool resumePaused()
    {
      return self()->mResumePaused;
    }

    /**
      Is Internal: Resume playback in paused state Immutable
    */
    static
    bool isResumePausedImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ResumePaused" ) );
    }

    /**
      Set Time to resume at, in milliseconds
    */
    static
    void setResumeTime( int v )
    {
      if (!self()->isResumeTimeImmutable())
        self()->mResumeTime = v;
    }

    /**
      Get Time to resume at, in milliseconds
    */
    static
    int resumeTime()
    {
      return self()->mResumeTime;
    }

    /**
      Is Time to resume at, in milliseconds Immutable
    */
    static
    bool isResumeTimeImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ResumeTime" ) );
    }

    /**
      Set List of bools describing which browsers are visible, from top to bottom.
    */
    static
    void setVisibleBrowsers( const QList<int> & v )
    {
      if (!self()->isVisibleBrowsersImmutable())
        self()->mVisibleBrowsers = v;
    }

    /**
      Get List of bools describing which browsers are visible, from top to bottom.
    */
    static
    QList<int> visibleBrowsers()
    {
      return self()->mVisibleBrowsers;
    }

    /**
      Is List of bools describing which browsers are visible, from top to bottom. Immutable
    */
    static
    bool isVisibleBrowsersImmutable()
    {
      return self()->isImmutable( QStringLiteral( "VisibleBrowsers" ) );
    }

    /**
      Set Track playing on last exit. Value is -1 if no track was playing.
    */
    static
    void setLastPlaying( int v )
    {
      if (!self()->isLastPlayingImmutable())
        self()->mLastPlaying = v;
    }

    /**
      Get Track playing on last exit. Value is -1 if no track was playing.
    */
    static
    int lastPlaying()
    {
      return self()->mLastPlaying;
    }

    /**
      Is Track playing on last exit. Value is -1 if no track was playing. Immutable
    */
    static
    bool isLastPlayingImmutable()
    {
      return self()->isImmutable( QStringLiteral( "LastPlaying" ) );
    }

    /**
      Set Number (from the top) of the last active browser.
    */
    static
    void setActiveBrowser( int v )
    {
      if (!self()->isActiveBrowserImmutable())
        self()->mActiveBrowser = v;
    }

    /**
      Get Number (from the top) of the last active browser.
    */
    static
    int activeBrowser()
    {
      return self()->mActiveBrowser;
    }

    /**
      Is Number (from the top) of the last active browser. Immutable
    */
    static
    bool isActiveBrowserImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ActiveBrowser" ) );
    }

    /**
      Set Whether Collections folders are scanned recursively
    */
    static
    void setScanRecursively( bool v )
    {
      if (!self()->isScanRecursivelyImmutable())
        self()->mScanRecursively = v;
    }

    /**
      Get Whether Collections folders are scanned recursively
    */
    static
    bool scanRecursively()
    {
      return self()->mScanRecursively;
    }

    /**
      Is Whether Collections folders are scanned recursively Immutable
    */
    static
    bool isScanRecursivelyImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ScanRecursively" ) );
    }

    /**
      Set Whether Collection folders are rescanned on change
    */
    static
    void setMonitorChanges( bool v )
    {
      if (!self()->isMonitorChangesImmutable())
        self()->mMonitorChanges = v;
    }

    /**
      Get Whether Collection folders are rescanned on change
    */
    static
    bool monitorChanges()
    {
      return self()->mMonitorChanges;
    }

    /**
      Is Whether Collection folders are rescanned on change Immutable
    */
    static
    bool isMonitorChangesImmutable()
    {
      return self()->isImmutable( QStringLiteral( "MonitorChanges" ) );
    }

    /**
      Set Whether meta data changes are written back
    */
    static
    void setWriteBack( bool v )
    {
      if (!self()->isWriteBackImmutable())
        self()->mWriteBack = v;
    }

    /**
      Get Whether meta data changes are written back
    */
    static
    bool writeBack()
    {
      return self()->mWriteBack;
    }

    /**
      Is Whether meta data changes are written back Immutable
    */
    static
    bool isWriteBackImmutable()
    {
      return self()->isImmutable( QStringLiteral( "WriteBack" ) );
    }

    /**
      Set Whether changes to the track statistics are written back
    */
    static
    void setWriteBackStatistics( bool v )
    {
      if (!self()->isWriteBackStatisticsImmutable())
        self()->mWriteBackStatistics = v;
    }

    /**
      Get Whether changes to the track statistics are written back
    */
    static
    bool writeBackStatistics()
    {
      return self()->mWriteBackStatistics;
    }

    /**
      Is Whether changes to the track statistics are written back Immutable
    */
    static
    bool isWriteBackStatisticsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "WriteBackStatistics" ) );
    }

    /**
      Set Whether changes to the album cover are written back
    */
    static
    void setWriteBackCover( bool v )
    {
      if (!self()->isWriteBackCoverImmutable())
        self()->mWriteBackCover = v;
    }

    /**
      Get Whether changes to the album cover are written back
    */
    static
    bool writeBackCover()
    {
      return self()->mWriteBackCover;
    }

    /**
      Is Whether changes to the album cover are written back Immutable
    */
    static
    bool isWriteBackCoverImmutable()
    {
      return self()->isImmutable( QStringLiteral( "WriteBackCover" ) );
    }

    /**
      Set Maximum embedded cover dimensions
    */
    static
    void setWriteBackCoverDimensions( int v )
    {
      if (!self()->isWriteBackCoverDimensionsImmutable())
        self()->mWriteBackCoverDimensions = v;
    }

    /**
      Get Maximum embedded cover dimensions
    */
    static
    int writeBackCoverDimensions()
    {
      return self()->mWriteBackCoverDimensions;
    }

    /**
      Is Maximum embedded cover dimensions Immutable
    */
    static
    bool isWriteBackCoverDimensionsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "WriteBackCoverDimensions" ) );
    }

    /**
      Set List of folders in the Collection
    */
    static
    void setCollectionFolders( const QStringList & v )
    {
      if (!self()->isCollectionFoldersImmutable())
        self()->mCollectionFolders = v;
    }

    /**
      Get List of folders in the Collection
    */
    static
    QStringList collectionFolders()
    {
      return self()->mCollectionFolders;
    }

    /**
      Is List of folders in the Collection Immutable
    */
    static
    bool isCollectionFoldersImmutable()
    {
      return self()->isImmutable( QStringLiteral( "CollectionFolders" ) );
    }

    /**
      Set Whether track numbers are shown in the collection browser.
    */
    static
    void setShowTrackNumbers( bool v )
    {
      if (!self()->isShowTrackNumbersImmutable())
        self()->mShowTrackNumbers = v;
    }

    /**
      Get Whether track numbers are shown in the collection browser.
    */
    static
    bool showTrackNumbers()
    {
      return self()->mShowTrackNumbers;
    }

    /**
      Is Whether track numbers are shown in the collection browser. Immutable
    */
    static
    bool isShowTrackNumbersImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ShowTrackNumbers" ) );
    }

    /**
      Set Whether years are shown in the collection browser.
    */
    static
    void setShowYears( bool v )
    {
      if (!self()->isShowYearsImmutable())
        self()->mShowYears = v;
    }

    /**
      Get Whether years are shown in the collection browser.
    */
    static
    bool showYears()
    {
      return self()->mShowYears;
    }

    /**
      Is Whether years are shown in the collection browser. Immutable
    */
    static
    bool isShowYearsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ShowYears" ) );
    }

    /**
      Set Whether to use Mozilla's Character Set Detector to try to guess ID3 tag encodings.
    */
    static
    void setUseCharsetDetector( bool v )
    {
      if (!self()->isUseCharsetDetectorImmutable())
        self()->mUseCharsetDetector = v;
    }

    /**
      Get Whether to use Mozilla's Character Set Detector to try to guess ID3 tag encodings.
    */
    static
    bool useCharsetDetector()
    {
      return self()->mUseCharsetDetector;
    }

    /**
      Is Whether to use Mozilla's Character Set Detector to try to guess ID3 tag encodings. Immutable
    */
    static
    bool isUseCharsetDetectorImmutable()
    {
      return self()->isImmutable( QStringLiteral( "UseCharsetDetector" ) );
    }

    /**
      Set Submit played tracks
    */
    static
    void setSubmitPlayedSongs( bool v )
    {
      if (!self()->isSubmitPlayedSongsImmutable())
        self()->mSubmitPlayedSongs = v;
    }

    /**
      Get Submit played tracks
    */
    static
    bool submitPlayedSongs()
    {
      return self()->mSubmitPlayedSongs;
    }

    /**
      Is Submit played tracks Immutable
    */
    static
    bool isSubmitPlayedSongsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "SubmitPlayedSongs" ) );
    }

    /**
      Set Username
    */
    static
    void setScrobblerUsername( const QString & v )
    {
      if (!self()->isScrobblerUsernameImmutable())
        self()->mScrobblerUsername = v;
    }

    /**
      Get Username
    */
    static
    QString scrobblerUsername()
    {
      return self()->mScrobblerUsername;
    }

    /**
      Is Username Immutable
    */
    static
    bool isScrobblerUsernameImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ScrobblerUsername" ) );
    }

    /**
      Set Password
    */
    static
    void setScrobblerPassword( const QString & v )
    {
      if (!self()->isScrobblerPasswordImmutable())
        self()->mScrobblerPassword = v;
    }

    /**
      Get Password
    */
    static
    QString scrobblerPassword()
    {
      return self()->mScrobblerPassword;
    }

    /**
      Is Password Immutable
    */
    static
    bool isScrobblerPasswordImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ScrobblerPassword" ) );
    }

    /**
      Set Send composer data
    */
    static
    void setScrobbleComposer( bool v )
    {
      if (!self()->isScrobbleComposerImmutable())
        self()->mScrobbleComposer = v;
    }

    /**
      Get Send composer data
    */
    static
    bool scrobbleComposer()
    {
      return self()->mScrobbleComposer;
    }

    /**
      Is Send composer data Immutable
    */
    static
    bool isScrobbleComposerImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ScrobbleComposer" ) );
    }

    /**
      Set Retrieve similar artists
    */
    static
    void setRetrieveSimilarArtists( bool v )
    {
      if (!self()->isRetrieveSimilarArtistsImmutable())
        self()->mRetrieveSimilarArtists = v;
    }

    /**
      Get Retrieve similar artists
    */
    static
    bool retrieveSimilarArtists()
    {
      return self()->mRetrieveSimilarArtists;
    }

    /**
      Is Retrieve similar artists Immutable
    */
    static
    bool isRetrieveSimilarArtistsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "RetrieveSimilarArtists" ) );
    }

    /**
      Set Device type
    */
    static
    void setDeviceType( const QString & v )
    {
      if (!self()->isDeviceTypeImmutable())
        self()->mDeviceType = v;
    }

    /**
      Get Device type
    */
    static
    QString deviceType()
    {
      return self()->mDeviceType;
    }

    /**
      Is Device type Immutable
    */
    static
    bool isDeviceTypeImmutable()
    {
      return self()->isImmutable( QStringLiteral( "DeviceType" ) );
    }

    /**
      Set Mount point
    */
    static
    void setMountPoint( const QString & v )
    {
      if (!self()->isMountPointImmutable())
        self()->mMountPoint = v;
    }

    /**
      Get Mount point
    */
    static
    QString mountPoint()
    {
      return self()->mMountPoint;
    }

    /**
      Is Mount point Immutable
    */
    static
    bool isMountPointImmutable()
    {
      return self()->isImmutable( QStringLiteral( "MountPoint" ) );
    }

    /**
      Set Mount command
    */
    static
    void setMountCommand( const QString & v )
    {
      if (!self()->isMountCommandImmutable())
        self()->mMountCommand = v;
    }

    /**
      Get Mount command
    */
    static
    QString mountCommand()
    {
      return self()->mMountCommand;
    }

    /**
      Is Mount command Immutable
    */
    static
    bool isMountCommandImmutable()
    {
      return self()->isImmutable( QStringLiteral( "MountCommand" ) );
    }

    /**
      Set UmountCommand
    */
    static
    void setUmountCommand( const QString & v )
    {
      if (!self()->isUmountCommandImmutable())
        self()->mUmountCommand = v;
    }

    /**
      Get UmountCommand
    */
    static
    QString umountCommand()
    {
      return self()->mUmountCommand;
    }

    /**
      Is UmountCommand Immutable
    */
    static
    bool isUmountCommandImmutable()
    {
      return self()->isImmutable( QStringLiteral( "UmountCommand" ) );
    }

    /**
      Set Auto delete podcasts
    */
    static
    void setAutoDeletePodcasts( bool v )
    {
      if (!self()->isAutoDeletePodcastsImmutable())
        self()->mAutoDeletePodcasts = v;
    }

    /**
      Get Auto delete podcasts
    */
    static
    bool autoDeletePodcasts()
    {
      return self()->mAutoDeletePodcasts;
    }

    /**
      Is Auto delete podcasts Immutable
    */
    static
    bool isAutoDeletePodcastsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "AutoDeletePodcasts" ) );
    }

    /**
      Set Sync stats
    */
    static
    void setSyncStats( bool v )
    {
      if (!self()->isSyncStatsImmutable())
        self()->mSyncStats = v;
    }

    /**
      Get Sync stats
    */
    static
    bool syncStats()
    {
      return self()->mSyncStats;
    }

    /**
      Is Sync stats Immutable
    */
    static
    bool isSyncStatsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "SyncStats" ) );
    }

    /**
      Set Manually added servers
    */
    static
    void setManuallyAddedServers( const QStringList & v )
    {
      if (!self()->isManuallyAddedServersImmutable())
        self()->mManuallyAddedServers = v;
    }

    /**
      Get Manually added servers
    */
    static
    QStringList manuallyAddedServers()
    {
      return self()->mManuallyAddedServers;
    }

    /**
      Is Manually added servers Immutable
    */
    static
    bool isManuallyAddedServersImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ManuallyAddedServers" ) );
    }

    /**
      Set Server passwords
    */
    static
    void setServerPasswords( const QStringList & v )
    {
      if (!self()->isServerPasswordsImmutable())
        self()->mServerPasswords = v;
    }

    /**
      Get Server passwords
    */
    static
    QStringList serverPasswords()
    {
      return self()->mServerPasswords;
    }

    /**
      Is Server passwords Immutable
    */
    static
    bool isServerPasswordsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ServerPasswords" ) );
    }

    /**
      Set Include track names in matching
    */
    static
    void setMatchTrack( bool v )
    {
      if (!self()->isMatchTrackImmutable())
        self()->mMatchTrack = v;
    }

    /**
      Get Include track names in matching
    */
    static
    bool matchTrack()
    {
      return self()->mMatchTrack;
    }

    /**
      Is Include track names in matching Immutable
    */
    static
    bool isMatchTrackImmutable()
    {
      return self()->isImmutable( QStringLiteral( "MatchTrack" ) );
    }

    /**
      Set Include album names in matching
    */
    static
    void setMatchAlbum( bool v )
    {
      if (!self()->isMatchAlbumImmutable())
        self()->mMatchAlbum = v;
    }

    /**
      Get Include album names in matching
    */
    static
    bool matchAlbum()
    {
      return self()->mMatchAlbum;
    }

    /**
      Is Include album names in matching Immutable
    */
    static
    bool isMatchAlbumImmutable()
    {
      return self()->isImmutable( QStringLiteral( "MatchAlbum" ) );
    }

    /**
      Set Include artist names in matching
    */
    static
    void setMatchArtist( bool v )
    {
      if (!self()->isMatchArtistImmutable())
        self()->mMatchArtist = v;
    }

    /**
      Get Include artist names in matching
    */
    static
    bool matchArtist()
    {
      return self()->mMatchArtist;
    }

    /**
      Is Include artist names in matching Immutable
    */
    static
    bool isMatchArtistImmutable()
    {
      return self()->isImmutable( QStringLiteral( "MatchArtist" ) );
    }

    /**
      Set Include genre names in matching
    */
    static
    void setMatchGenre( bool v )
    {
      if (!self()->isMatchGenreImmutable())
        self()->mMatchGenre = v;
    }

    /**
      Get Include genre names in matching
    */
    static
    bool matchGenre()
    {
      return self()->mMatchGenre;
    }

    /**
      Is Include genre names in matching Immutable
    */
    static
    bool isMatchGenreImmutable()
    {
      return self()->isImmutable( QStringLiteral( "MatchGenre" ) );
    }

    /**
      Set Include composer names in matching
    */
    static
    void setMatchComposer( bool v )
    {
      if (!self()->isMatchComposerImmutable())
        self()->mMatchComposer = v;
    }

    /**
      Get Include composer names in matching
    */
    static
    bool matchComposer()
    {
      return self()->mMatchComposer;
    }

    /**
      Is Include composer names in matching Immutable
    */
    static
    bool isMatchComposerImmutable()
    {
      return self()->isImmutable( QStringLiteral( "MatchComposer" ) );
    }

    /**
      Set Include years in matching
    */
    static
    void setMatchYear( bool v )
    {
      if (!self()->isMatchYearImmutable())
        self()->mMatchYear = v;
    }

    /**
      Get Include years in matching
    */
    static
    bool matchYear()
    {
      return self()->mMatchYear;
    }

    /**
      Is Include years in matching Immutable
    */
    static
    bool isMatchYearImmutable()
    {
      return self()->isImmutable( QStringLiteral( "MatchYear" ) );
    }

    /**
      Set Include years in matching
    */
    static
    void setShowOnlyMatches( bool v )
    {
      if (!self()->isShowOnlyMatchesImmutable())
        self()->mShowOnlyMatches = v;
    }

    /**
      Get Include years in matching
    */
    static
    bool showOnlyMatches()
    {
      return self()->mShowOnlyMatches;
    }

    /**
      Is Include years in matching Immutable
    */
    static
    bool isShowOnlyMatchesImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ShowOnlyMatches" ) );
    }

    /**
      Set The name of the layout that will be loaded on startup
    */
    static
    void setCurrentLayout( const QString & v )
    {
      if (!self()->isCurrentLayoutImmutable())
        self()->mCurrentLayout = v;
    }

    /**
      Get The name of the layout that will be loaded on startup
    */
    static
    QString currentLayout()
    {
      return self()->mCurrentLayout;
    }

    /**
      Is The name of the layout that will be loaded on startup Immutable
    */
    static
    bool isCurrentLayoutImmutable()
    {
      return self()->isImmutable( QStringLiteral( "CurrentLayout" ) );
    }

    /**
      Set Whether Amarok uses its own internal database, as opposed to an external engine.
    */
    static
    void setUseServer( bool v )
    {
      if (!self()->isUseServerImmutable())
        self()->mUseServer = v;
    }

    /**
      Get Whether Amarok uses its own internal database, as opposed to an external engine.
    */
    static
    bool useServer()
    {
      return self()->mUseServer;
    }

    /**
      Is Whether Amarok uses its own internal database, as opposed to an external engine. Immutable
    */
    static
    bool isUseServerImmutable()
    {
      return self()->isImmutable( QStringLiteral( "UseServer" ) );
    }

    /**
      Set The hostname of the external server to connect to.
    */
    static
    void setHost( const QString & v )
    {
      if (!self()->isHostImmutable())
        self()->mHost = v;
    }

    /**
      Get The hostname of the external server to connect to.
    */
    static
    QString host()
    {
      return self()->mHost;
    }

    /**
      Is The hostname of the external server to connect to. Immutable
    */
    static
    bool isHostImmutable()
    {
      return self()->isImmutable( QStringLiteral( "Host" ) );
    }

    /**
      Set Which server port to connect to the database engine.
    */
    static
    void setPort( int v )
    {
      if (!self()->isPortImmutable())
        self()->mPort = v;
    }

    /**
      Get Which server port to connect to the database engine.
    */
    static
    int port()
    {
      return self()->mPort;
    }

    /**
      Is Which server port to connect to the database engine. Immutable
    */
    static
    bool isPortImmutable()
    {
      return self()->isImmutable( QStringLiteral( "Port" ) );
    }

    /**
      Set The name of the database Amarok will use. The user should have sufficient access permissions.
    */
    static
    void setDatabase( const QString & v )
    {
      if (!self()->isDatabaseImmutable())
        self()->mDatabase = v;
    }

    /**
      Get The name of the database Amarok will use. The user should have sufficient access permissions.
    */
    static
    QString database()
    {
      return self()->mDatabase;
    }

    /**
      Is The name of the database Amarok will use. The user should have sufficient access permissions. Immutable
    */
    static
    bool isDatabaseImmutable()
    {
      return self()->isImmutable( QStringLiteral( "Database" ) );
    }

    /**
      Set Username used to access the external database.
    */
    static
    void setUser( const QString & v )
    {
      if (!self()->isUserImmutable())
        self()->mUser = v;
    }

    /**
      Get Username used to access the external database.
    */
    static
    QString user()
    {
      return self()->mUser;
    }

    /**
      Is Username used to access the external database. Immutable
    */
    static
    bool isUserImmutable()
    {
      return self()->isImmutable( QStringLiteral( "User" ) );
    }

    /**
      Set Password for the external database user.
    */
    static
    void setPassword( const QString & v )
    {
      if (!self()->isPasswordImmutable())
        self()->mPassword = v;
    }

    /**
      Get Password for the external database user.
    */
    static
    QString password()
    {
      return self()->mPassword;
    }

    /**
      Is Password for the external database user. Immutable
    */
    static
    bool isPasswordImmutable()
    {
      return self()->isImmutable( QStringLiteral( "Password" ) );
    }

    /**
      Set Keeps a running count to know when run a CHECK.
    */
    static
    void setCheckCount( int v )
    {
      if (!self()->isCheckCountImmutable())
        self()->mCheckCount = v;
    }

    /**
      Get Keeps a running count to know when run a CHECK.
    */
    static
    int checkCount()
    {
      return self()->mCheckCount;
    }

    /**
      Is Keeps a running count to know when run a CHECK. Immutable
    */
    static
    bool isCheckCountImmutable()
    {
      return self()->isImmutable( QStringLiteral( "CheckCount" ) );
    }

    /**
      Set Whether to enable Amarok's scripting module.
    */
    static
    void setEnableScripts( bool v )
    {
      if (!self()->isEnableScriptsImmutable())
        self()->mEnableScripts = v;
    }

    /**
      Get Whether to enable Amarok's scripting module.
    */
    static
    bool enableScripts()
    {
      return self()->mEnableScripts;
    }

    /**
      Is Whether to enable Amarok's scripting module. Immutable
    */
    static
    bool isEnableScriptsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "EnableScripts" ) );
    }

    /**
      Set Whether to automatically update built-in scripts
    */
    static
    void setAutoUpdateScripts( bool v )
    {
      if (!self()->isAutoUpdateScriptsImmutable())
        self()->mAutoUpdateScripts = v;
    }

    /**
      Get Whether to automatically update built-in scripts
    */
    static
    bool autoUpdateScripts()
    {
      return self()->mAutoUpdateScripts;
    }

    /**
      Is Whether to automatically update built-in scripts Immutable
    */
    static
    bool isAutoUpdateScriptsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "AutoUpdateScripts" ) );
    }

    /**
      Set Whether to enable the script console.
    */
    static
    void setEnableScriptConsole( bool v )
    {
      if (!self()->isEnableScriptConsoleImmutable())
        self()->mEnableScriptConsole = v;
    }

    /**
      Get Whether to enable the script console.
    */
    static
    bool enableScriptConsole()
    {
      return self()->mEnableScriptConsole;
    }

    /**
      Is Whether to enable the script console. Immutable
    */
    static
    bool isEnableScriptConsoleImmutable()
    {
      return self()->isImmutable( QStringLiteral( "EnableScriptConsole" ) );
    }

    /**
      Set Whether to display a warning about scripts accessing deprecated APIs.
    */
    static
    void setEnableDeprecationWarnings( bool v )
    {
      if (!self()->isEnableDeprecationWarningsImmutable())
        self()->mEnableDeprecationWarnings = v;
    }

    /**
      Get Whether to display a warning about scripts accessing deprecated APIs.
    */
    static
    bool enableDeprecationWarnings()
    {
      return self()->mEnableDeprecationWarnings;
    }

    /**
      Is Whether to display a warning about scripts accessing deprecated APIs. Immutable
    */
    static
    bool isEnableDeprecationWarningsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "EnableDeprecationWarnings" ) );
    }

    /**
      Set Whether to save the current session on exit.
    */
    static
    void setSaveSession( bool v )
    {
      if (!self()->isSaveSessionImmutable())
        self()->mSaveSession = v;
    }

    /**
      Get Whether to save the current session on exit.
    */
    static
    bool saveSession()
    {
      return self()->mSaveSession;
    }

    /**
      Is Whether to save the current session on exit. Immutable
    */
    static
    bool isSaveSessionImmutable()
    {
      return self()->isImmutable( QStringLiteral( "SaveSession" ) );
    }

    /**
      Set Whether to show the moodbar of the current track, if available, in the progress slider
    */
    static
    void setShowMoodbarInSlider( bool v )
    {
      if (!self()->isShowMoodbarInSliderImmutable())
        self()->mShowMoodbarInSlider = v;
    }

    /**
      Get Whether to show the moodbar of the current track, if available, in the progress slider
    */
    static
    bool showMoodbarInSlider()
    {
      return self()->mShowMoodbarInSlider;
    }

    /**
      Is Whether to show the moodbar of the current track, if available, in the progress slider Immutable
    */
    static
    bool isShowMoodbarInSliderImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ShowMoodbarInSlider" ) );
    }

    /**
      Set The style to use when painting the moodbar
    */
    static
    void setMoodbarPaintStyle( int v )
    {
      if (!self()->isMoodbarPaintStyleImmutable())
        self()->mMoodbarPaintStyle = v;
    }

    /**
      Get The style to use when painting the moodbar
    */
    static
    int moodbarPaintStyle()
    {
      return self()->mMoodbarPaintStyle;
    }

    /**
      Is The style to use when painting the moodbar Immutable
    */
    static
    bool isMoodbarPaintStyleImmutable()
    {
      return self()->isImmutable( QStringLiteral( "MoodbarPaintStyle" ) );
    }

    /**
      Set Quality factor for Automated Playlist Generator
    */
    static
    void setQualityFactorAPG( int v )
    {
      if (!self()->isQualityFactorAPGImmutable())
        self()->mQualityFactorAPG = v;
    }

    /**
      Get Quality factor for Automated Playlist Generator
    */
    static
    int qualityFactorAPG()
    {
      return self()->mQualityFactorAPG;
    }

    /**
      Is Quality factor for Automated Playlist Generator Immutable
    */
    static
    bool isQualityFactorAPGImmutable()
    {
      return self()->isImmutable( QStringLiteral( "qualityFactorAPG" ) );
    }

  protected:
    AmarokConfig(KSharedConfig::Ptr config);
    friend class AmarokConfigHelper;


    // General Options
    bool mLeftTimeDisplayEnabled;
    bool mLeftTimeDisplayRemaining;
    int mFavorTracks;
    int mTrackProgression;
    bool mDynamicMode;
    bool mDynamicDuplicates;
    int mPreviousTracks;
    int mUpcomingTracks;
    bool mShowTrayIcon;
    bool mHideContextView;
    int mUndoLevels;
    bool mRelativePlaylist;
    QString mExternalBrowser;
    bool mAutoGetCoverArt;
    bool mShowBrowserBackgroundImage;
    bool mAutoScrollPlaylist;
    bool mShowAlbumArt;
    bool mLockLayout;
    bool mPlayFirstRunJingle;
    bool mAnimateAppletCollapse;
    bool mShowArtistForVarious;

    // OrganizeCollectionDialog
    bool mOverwriteFiles;
    bool mIgnoreThe;
    bool mReplaceSpace;
    bool mCoverIcons;
    QString mOrganizeDirectory;
    bool mVfatCompatible;
    bool mAsciiOnly;
    bool mUseCustomScheme;
    QString mCustomScheme;
    QString mReplacementRegexp;
    QString mReplacementString;
    QString mMode;
    QStringList mFormatPresets;

    // Playback
    int mMasterVolume;
    bool mMuteState;
    bool mFadeoutOnStop;
    bool mFadeoutOnPause;
    int mFadeoutLength;
    int mEqualizerMode;
    QList<int> mEqualizerGains;
    QStringList mEqualizerPresetsNames;
    QList<int> mEqualizerPresestValues;
    int mReplayGainMode;
    int mSeekShort;
    int mSeekMedium;
    int mSeekLong;
    bool mPauseOnSuspend;
    bool mInhibitSuspend;
    bool mStartPlayingOnAdd;

    // Cover Manager
    QString mAmazonLocale;

    // Wikipedia
    QString mWikipediaLocale;

    // KNotify
    bool mKNotifyEnabled;

    // OSD
    bool mOsdEnabled;
    bool mGrowlEnabled;
    bool mOsdUseTranslucency;
    bool mOsdUseCustomColors;
    QColor mOsdTextColor;
    int mOsdFontScaling;
    int mOsdDuration;
    int mOsdYOffset;
    int mOsdScreen;
    int mOsdAlignment;
    bool mOsdHideOnFullscreen;

    // Session
    bool mResumePlayback;
    QString mResumeTrack;
    bool mResumePaused;
    int mResumeTime;
    QList<int> mVisibleBrowsers;
    int mLastPlaying;
    int mActiveBrowser;

    // Collection
    bool mScanRecursively;
    bool mMonitorChanges;
    bool mWriteBack;
    bool mWriteBackStatistics;
    bool mWriteBackCover;
    int mWriteBackCoverDimensions;
    QStringList mCollectionFolders;
    bool mShowTrackNumbers;
    bool mShowYears;
    bool mUseCharsetDetector;

    // Scrobbler
    bool mSubmitPlayedSongs;
    QString mScrobblerUsername;
    QString mScrobblerPassword;
    bool mScrobbleComposer;
    bool mRetrieveSimilarArtists;

    // MediaDevice
    QString mDeviceType;
    QString mMountPoint;
    QString mMountCommand;
    QString mUmountCommand;
    bool mAutoDeletePodcasts;
    bool mSyncStats;

    // Daap
    QStringList mManuallyAddedServers;
    QStringList mServerPasswords;

    // Playlist Search
    bool mMatchTrack;
    bool mMatchAlbum;
    bool mMatchArtist;
    bool mMatchGenre;
    bool mMatchComposer;
    bool mMatchYear;
    bool mShowOnlyMatches;

    // Playlist Layout
    QString mCurrentLayout;

    // MySQL
    bool mUseServer;
    QString mHost;
    int mPort;
    QString mDatabase;
    QString mUser;
    QString mPassword;
    int mCheckCount;

    // ScriptManager
    bool mEnableScripts;
    bool mAutoUpdateScripts;
    bool mEnableScriptConsole;
    bool mEnableDeprecationWarnings;

    // ScriptConsole
    bool mSaveSession;

    // Moodbar
    bool mShowMoodbarInSlider;
    int mMoodbarPaintStyle;

    // PlaylistGenerator
    int mQualityFactorAPG;
};

#endif

