package Business::Legal;
use strict;
use warnings;
our $VERSION = '0.02';

use HTTP::Tiny;
use URI::Escape;
use JSON;
use Data::Dumper;
use File::Spec;

sub output {
	print "Sample output 3. Version: $VERSION\n";
}

$| = 1;
my $http = HTTP::Tiny->new();

sub read_html_src{
	my $fn = shift;
	open FH, "<$fn" or die $!;
	my $html_content = do {local $/; <FH>};
	printf "%d\n", length($html_content);
	# $html_content =~ /\d{4}-\d{2}-\d{2}_(\d{4}-\d{2}-\d{2})_(\d{4})/;
	# my @matches = $html_content =~ /<td class="current-state-col d-table-cell">(.[^<])</td>/g;
	my @matches = $html_content =~ /<td class="current-state-col d-table-cell">([^<]+)<\/td>/g;
	my $count = 1;
	foreach(@matches){
		printf "%3d  %s\n", $count++, $_;
	}
	# print "@matches";
	print "\n";
}

sub read_destination_folder_aohref{
	my $dir = shift;
	opendir(D, "$dir") || die "Can't open directory $dir: $!\n";
	my @file_list = readdir(D);
	my @aoh;
    foreach my $entry (@file_list) {
		next unless $entry =~ /\d{4}-\d{2}-\d{2}_(\d{4}-\d{2}-\d{2})_(\d{4})/;
		my $target_month = $1;
		my $page = $2;
		print $entry, "\n";
		my $full_file_path = File::Spec->catdir($dir, $entry);
		read_html_src($full_file_path);
		push @aoh, {target_month=>$target_month, page=>$page, entry=>$entry};
    }
	return \@aoh;
}

sub read_rawdata_by_month_dirs{
	my $dirname = shift;
	print $dirname, "\n";
    opendir(D, "$dirname") || die "Can't open directory $dirname: $!\n";
    my @file_list = readdir(D);
    my @aoh;
    foreach my $entry (@file_list) {
        # if(1 or $entry =~ /(\d{8}_\d{4}_\d{2})/){
        if($entry =~ /^2013-11-11/){
            # my $ts = $1;
			my $destination_folder = File::Spec->catdir($dirname, $entry);
            print $destination_folder, "\n";
            # push @aoh, {ts=>$ts, entry=>$entry};
			my $aohref = read_destination_folder_aohref($destination_folder);
			print Dumper $aohref;
        }
    }
	
    my @aoh2_ref = sort {$b->{ts} cmp $a->{ts}} @aoh ;
    closedir(D);
	
=pod
    my $dirname = $args->{dirname};
	$args->{recency_index} = 0 unless exists $args->{recency_index};
    # print Dumper $aoh2_ref[$index];
    return $aoh2_ref[$args->{recency_index}]->{entry};
=cut
}



1;