# AsposeCellsCloud::Object::SparklineGroup 

## Load the model package
```perl
use AsposeCellsCloud::Object::SparklineGroup;
```

## Properties
Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**DisplayHidden** | **boolean** | Indicates whether to show data in hidden rows and columns.  |
**FirstPointColor** | **CellsColor** | Gets and sets the color of the first point of data in the sparkline group.  |
**HighPointColor** | **CellsColor** | Gets and sets the color of the highest points of data in the sparkline group.  |
**HorizontalAxisColor** | **CellsColor** | Gets and sets the color of the horizontal axis in the sparkline group.  |
**HorizontalAxisDateRange** | **string** | Represents the range that contains the date values for the sparkline data.  |
**LastPointColor** | **CellsColor** | Gets and sets the color of the last point of data in the sparkline group.  |
**LineWeight** | **double** | Gets and sets the line weight in each line sparkline in the sparkline group, in the unit of points.  |
**LowPointColor** | **CellsColor** | Gets and sets the color of the lowest points of data in the sparkline group.  |
**MarkersColor** | **CellsColor** | Gets and sets the color of points in each line sparkline in the sparkline group.  |
**NegativePointsColor** | **CellsColor** | Gets and sets the color of the negative values on the sparkline group.  |
**PlotEmptyCellsType** | **string** | Indicates how to plot empty cells.  |
**PlotRightToLeft** | **boolean** | Indicates whether the plot data is right to left.  |
**PresetStyle** | **string** | Gets and sets the preset style type of the sparkline group.  |
**SeriesColor** | **CellsColor** | Gets and sets the color of the sparklines in the sparkline group.  |
**ShowFirstPoint** | **boolean** | Indicates whether to highlight the first point of data in the sparkline group.  |
**ShowHighPoint** | **boolean** | Indicates whether to highlight the highest points of data in the sparkline group.  |
**ShowHorizontalAxis** | **boolean** | Indicates whether to show the sparkline horizontal axis.            The horizontal axis appears if the sparkline has data that crosses the zero axis.  |
**ShowLastPoint** | **boolean** | Indicates whether to highlight the last point of data in the sparkline group.  |
**ShowLowPoint** | **boolean** | Indicates whether to highlight the lowest points of data in the sparkline group.  |
**ShowMarkers** | **boolean** | Indicates whether to highlight each point in each line sparkline in the sparkline group.  |
**ShowNegativePoints** | **boolean** | Indicates whether to highlight the negative values on the sparkline group with a different color or marker.  |
**SparklineCollection** | **ARRAY[Sparkline]** | Gets the collection of  object.  |
**Type** | **string** | Indicates the sparkline type of the sparkline group.  |
**VerticalAxisMaxValue** | **double** | Gets and sets the custom maximum value for the vertical axis.  |
**VerticalAxisMaxValueType** | **string** | Represents the vertical axis maximum value type.  |
**VerticalAxisMinValue** | **double** | Gets and sets the custom minimum value for the vertical axis.  |
**VerticalAxisMinValueType** | **string** | Represents the vertical axis minimum value type.  |  


[[Back to Model list]](../DeveloperGuide.md#model-reference)  
[[Back to README]](../../README.md)